/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.config;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.config.AttributeSettingsPanelInterface;
import at.grid.themis.application.config.ThemisAttributePanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AttributeSettingsPanel
extends JPanel
implements AttributeSettingsPanelInterface {
    private String elementtype;
    private JButton btnAdd;
    private JButton btnDown;
    private JButton btnRemove;
    private JButton btnUp;
    private JComboBox<ThemisAttribute.Type> fldAttributes;
    private JPanel jPanel8;
    private JLabel lblAtt;
    private JLabel lblBearbeitung;
    private JLabel lblBezeichnung;
    private JLabel lblPlatzhalter;
    private JPanel panelAttributes;
    private JPanel panelHeaderProjectAttributes;
    private JScrollPane scrollPane;

    public AttributeSettingsPanel(String elementtype) {
        this.elementtype = elementtype;
        this.initComponents();
        this.fldAttributes.addItem(ThemisAttribute.Type.TEXT);
        this.fldAttributes.addItem(ThemisAttribute.Type.LONGTEXT);
        this.fldAttributes.addItem(ThemisAttribute.Type.NUMBER);
        this.fldAttributes.addItem(ThemisAttribute.Type.DATE);
        this.fldAttributes.addItem(ThemisAttribute.Type.LIST);
        this.fldAttributes.addItem(ThemisAttribute.Type.BOOLEAN);
        this.fldAttributes.addItem(ThemisAttribute.Type.UPLOAD);
        this.populateAttributes();
    }

    private void populateAttributes() {
        this.panelAttributes.removeAll();
        ArrayList attributes = ThemisApplication.getInstance().getSettings().getAttributes(this.elementtype);
        ThemisAttributePanel firstPanel = null;
        ThemisAttributePanel lastPanel = null;
        for (ThemisAttribute ta : attributes) {
            if (ta.isVirtual()) continue;
            if (!ta.isUserdefined()) {
                lastPanel = new ThemisAttributePanel(ta, this);
                this.panelAttributes.add(lastPanel);
                continue;
            }
            lastPanel = new ThemisAttributePanel(ta, this);
            if (firstPanel == null) {
                firstPanel = lastPanel;
            }
            this.panelAttributes.add(lastPanel);
        }
        if (firstPanel != null) {
            firstPanel.setAsFirstPanel();
        }
        if (lastPanel != null) {
            lastPanel.setAsLastPanel();
        }
        this.panelAttributes.revalidate();
        this.panelAttributes.repaint();
    }

    public void addAttribute() {
        ThemisAttribute.Type t = (ThemisAttribute.Type)this.fldAttributes.getSelectedItem();
        ThemisAttribute ta = ThemisAttribute.create((ThemisAttribute.Type)t, (ThemisAttribute.Target)ThemisAttribute.getTarget((String)this.elementtype));
        this.populateAttributes();
    }

    @Override
    public void removeAttribute(ThemisAttributePanel p) {
        p.ta.setUsed(false);
        ThemisApplication.getInstance().getSettings().removeAttribute(p.ta);
        this.populateAttributes();
    }

    @Override
    public void moveAttribute(ThemisAttributePanel p, int dir) {
        ThemisApplication.getInstance().getSettings().moveAttribute(p.ta, dir);
        this.populateAttributes();
    }

    private void initComponents() {
        this.lblAtt = new JLabel();
        this.fldAttributes = new JComboBox();
        this.btnAdd = new JButton();
        this.panelHeaderProjectAttributes = new JPanel();
        this.lblBezeichnung = new JLabel();
        this.lblPlatzhalter = new JLabel();
        this.lblBearbeitung = new JLabel();
        this.jPanel8 = new JPanel();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.btnRemove = new JButton();
        this.scrollPane = new JScrollPane();
        this.panelAttributes = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblAtt.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblAtt, (String)NbBundle.getMessage(AttributeSettingsPanel.class, (String)"AttributeSettingsPanel.lblAtt.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblAtt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldAttributes, gridBagConstraints);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(AttributeSettingsPanel.class, (String)"AttributeSettingsPanel.btnAdd.text"));
        this.btnAdd.setMaximumSize(new Dimension(83, 50));
        this.btnAdd.setPreferredSize(new Dimension(83, 50));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeSettingsPanel.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnAdd, gridBagConstraints);
        this.panelHeaderProjectAttributes.setBackground(new Color(64, 64, 64));
        this.panelHeaderProjectAttributes.setForeground(new Color(64, 64, 64));
        this.panelHeaderProjectAttributes.setLayout(new GridBagLayout());
        this.lblBezeichnung.setFont(THEMIS.fontLabelBold);
        this.lblBezeichnung.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblBezeichnung, (String)NbBundle.getMessage(AttributeSettingsPanel.class, (String)"AttributeSettingsPanel.lblBezeichnung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 2, 5);
        this.panelHeaderProjectAttributes.add((Component)this.lblBezeichnung, gridBagConstraints);
        this.lblPlatzhalter.setFont(THEMIS.fontLabelBold);
        this.lblPlatzhalter.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblPlatzhalter, (String)NbBundle.getMessage(AttributeSettingsPanel.class, (String)"AttributeSettingsPanel.lblPlatzhalter.text"));
        this.lblPlatzhalter.setMaximumSize(new Dimension(120, 26));
        this.lblPlatzhalter.setMinimumSize(new Dimension(120, 26));
        this.lblPlatzhalter.setPreferredSize(new Dimension(120, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 2, 5);
        this.panelHeaderProjectAttributes.add((Component)this.lblPlatzhalter, gridBagConstraints);
        this.lblBearbeitung.setFont(THEMIS.fontLabelBold);
        this.lblBearbeitung.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblBearbeitung, (String)NbBundle.getMessage(AttributeSettingsPanel.class, (String)"AttributeSettingsPanel.lblBearbeitung.text"));
        this.lblBearbeitung.setMaximumSize(new Dimension(155, 16));
        this.lblBearbeitung.setMinimumSize(new Dimension(155, 16));
        this.lblBearbeitung.setPreferredSize(new Dimension(155, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 2, 5);
        this.panelHeaderProjectAttributes.add((Component)this.lblBearbeitung, gridBagConstraints);
        this.jPanel8.setBackground(new Color(64, 64, 64));
        this.jPanel8.setForeground(new Color(64, 64, 64));
        this.jPanel8.setPreferredSize(new Dimension(172, 20));
        this.jPanel8.setLayout(new GridLayout(1, 3, 5, 0));
        this.btnUp.setVisible(false);
        this.btnUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUp, (String)NbBundle.getMessage(AttributeSettingsPanel.class, (String)"AttributeSettingsPanel.btnUp.text"));
        this.btnUp.setMaximumSize(new Dimension(54, 20));
        this.btnUp.setMinimumSize(new Dimension(54, 20));
        this.btnUp.setPreferredSize(new Dimension(50, 20));
        this.jPanel8.add(this.btnUp);
        this.btnDown.setVisible(false);
        this.btnDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDown, (String)NbBundle.getMessage(AttributeSettingsPanel.class, (String)"AttributeSettingsPanel.btnDown.text"));
        this.btnDown.setMaximumSize(new Dimension(54, 20));
        this.btnDown.setMinimumSize(new Dimension(54, 20));
        this.btnDown.setPreferredSize(new Dimension(50, 20));
        this.jPanel8.add(this.btnDown);
        this.btnRemove.setVisible(false);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(AttributeSettingsPanel.class, (String)"AttributeSettingsPanel.btnRemove.text"));
        this.btnRemove.setMaximumSize(new Dimension(54, 20));
        this.btnRemove.setMinimumSize(new Dimension(54, 20));
        this.btnRemove.setPreferredSize(new Dimension(50, 20));
        this.jPanel8.add(this.btnRemove);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 5, 2, 5);
        this.panelHeaderProjectAttributes.add((Component)this.jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelHeaderProjectAttributes, gridBagConstraints);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.panelAttributes.setLayout(new BoxLayout(this.panelAttributes, 3));
        this.scrollPane.setViewportView(this.panelAttributes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.scrollPane, gridBagConstraints);
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        this.addAttribute();
    }
}

