/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.config;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisLock;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.themis.ontology.template.TemplateManager;
import at.grid.util.ProgressHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdom.JDOMException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LoadSettingsContentPanel
extends ThemisPanel {
    File templateFile;
    private boolean loaded = false;
    private ArrayList<ThemisFolder> updateList = null;
    private ThemisFile tf = null;
    private JButton btnCancel;
    private JButton btnLoad;
    private JButton btnSetAll;
    private JButton btnSetNone;
    private JCheckBox chkContacts;
    private JCheckBox chkDeleteMissing;
    private JCheckBox chkDocuments;
    private JCheckBox chkForms;
    private JCheckBox chkIcons;
    private JCheckBox chkLists;
    private JCheckBox chkMatchByTitle;
    private JCheckBox chkReportTemplates;
    private JCheckBox chkSettings;
    private JCheckBox chkTemplates;
    private JLabel jLabel104;
    private JLabel jLabel105;
    private JLabel jLabel106;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblChoose;
    private JLabel lblTemplateTitle;

    public LoadSettingsContentPanel(File templateFile) {
        this.initComponents();
        THEMIS.setCheckboxIcon(this.chkContacts, this.chkDeleteMissing, this.chkDocuments, this.chkForms, this.chkIcons, this.chkLists, this.chkMatchByTitle, this.chkReportTemplates, this.chkSettings, this.chkTemplates);
        this.templateFile = templateFile;
        this.lblTemplateTitle.setText(templateFile.getName());
    }

    public LoadSettingsContentPanel(File templateFile, ArrayList<ThemisFolder> updateList) {
        this(templateFile);
        this.updateList = updateList;
    }

    @Override
    public void populate(ProgressHandler ph) {
        this.setAll(true);
        this.setAllEnabled(false);
        if (DemoPackManager.isValidTemplateFile((File)this.templateFile)) {
            if (this.templateFile.getName().toLowerCase().endsWith(".themis")) {
                this.tf = new ThemisFile(ph);
                this.tf.analyseThemisFile(this.templateFile);
                this.populateCheckbox(this.chkTemplates, this.tf.getCountTemplate());
                this.setCheckboxEnabled(this.chkDeleteMissing, this.chkTemplates.isSelected());
                this.setCheckboxEnabled(this.chkMatchByTitle, this.chkTemplates.isSelected());
                this.populateCheckbox(this.chkForms, this.tf.getCountForm());
                this.populateCheckbox(this.chkIcons, this.tf.getCountIcon());
                this.populateCheckbox(this.chkContacts, this.tf.getCountContact());
                this.populateCheckbox(this.chkDocuments, this.tf.getCountDocument());
                this.populateCheckbox(this.chkReportTemplates, this.tf.getCountReportTemplate());
                this.populateCheckbox(this.chkLists, this.tf.hasKeytables());
                this.populateCheckbox(this.chkSettings, this.tf.hasSettings());
            } else {
                TemplateManager m = new TemplateManager(this.app, this.project);
                m.analyseTemplateFile(this.templateFile);
                this.populateCheckbox(this.chkTemplates, m.getCountTemplate());
                if (m.getCountTemplate() > 0) {
                    this.chkDeleteMissing.setEnabled(true);
                    this.chkMatchByTitle.setEnabled(true);
                }
                this.populateCheckbox(this.chkForms, m.getCountForm());
                this.populateCheckbox(this.chkIcons, m.getCountIcon());
                this.populateCheckbox(this.chkContacts, m.getCountContact());
                this.populateCheckbox(this.chkDocuments, m.getCountDocument());
                this.populateCheckbox(this.chkReportTemplates, m.getCountReportTemplate());
                this.populateCheckbox(this.chkLists, m.hasKeytables());
                this.populateCheckbox(this.chkSettings, m.hasSettings());
            }
        }
        this.setCheckboxSelected(this.chkDeleteMissing, this.app.getSettings().getTemplateDeleteMissingItems());
        this.setCheckboxSelected(this.chkMatchByTitle, this.app.getSettings().getTemplateMatchByTitle());
        this.setCheckboxEnabled(this.chkDeleteMissing, this.chkTemplates.isSelected());
    }

    private void populateCheckbox(JCheckBox chk, int count) {
        this.setCheckboxEnabled(chk, count > 0);
        chk.setText(chk.getText() + "  [" + count + "]");
    }

    private void populateCheckbox(JCheckBox chk, boolean flg) {
        chk.setEnabled(flg);
        chk.setText(chk.getText() + "  [" + (flg ? "JA" : "-") + "]");
    }

    @Override
    public void apply() {
        this.app.getSettings().setTemplateUseTexts(this.chkTemplates.isSelected());
        this.app.getSettings().setTemplateUseLists(this.chkLists.isSelected());
        this.app.getSettings().setTemplateUseIcons(this.chkIcons.isSelected());
        this.app.getSettings().setTemplateUseReportTemplates(this.chkReportTemplates.isSelected());
        this.app.getSettings().setTemplateUseForms(this.chkForms.isSelected());
        this.app.getSettings().setTemplateUseSettings(this.chkSettings.isSelected());
        this.app.getSettings().setTemplateUseContacts(this.chkContacts.isSelected());
        this.app.getSettings().setTemplateUseDocuments(this.chkDocuments.isSelected());
        this.app.getSettings().setTemplateDeleteMissingItems(this.chkDeleteMissing.isSelected());
        this.app.getSettings().setTemplateMatchByTitle(this.chkMatchByTitle.isSelected());
    }

    public void setAll(boolean flg) {
        this.setCheckboxSelected(this.chkTemplates, flg);
        this.setCheckboxSelected(this.chkIcons, flg);
        this.setCheckboxSelected(this.chkForms, flg);
        this.setCheckboxSelected(this.chkSettings, flg);
        this.setCheckboxSelected(this.chkLists, flg);
        this.setCheckboxSelected(this.chkContacts, flg);
        this.setCheckboxSelected(this.chkDocuments, flg);
        this.setCheckboxSelected(this.chkReportTemplates, flg);
    }

    public void setAllEnabled(boolean flg) {
        this.setCheckboxEnabled(this.chkTemplates, flg);
        this.setCheckboxEnabled(this.chkIcons, flg);
        this.setCheckboxEnabled(this.chkForms, flg);
        this.setCheckboxEnabled(this.chkSettings, flg);
        this.setCheckboxEnabled(this.chkLists, flg);
        this.setCheckboxEnabled(this.chkContacts, flg);
        this.setCheckboxEnabled(this.chkDocuments, flg);
        this.setCheckboxEnabled(this.chkReportTemplates, flg);
    }

    private void setCheckboxSelected(JCheckBox chk, boolean flg) {
        if (chk.isEnabled()) {
            chk.setSelected(flg);
        } else {
            chk.setSelected(false);
        }
    }

    private void setCheckboxEnabled(JCheckBox chk, boolean flg) {
        chk.setEnabled(flg);
        if (!flg) {
            chk.setSelected(false);
        }
    }

    private void loadTemplate() {
        this.apply();
        if (this.updateList == null || this.updateList.isEmpty()) {
            ThemisTaskWithDialog.createTaskWithCounterAndCancel("Projektvorlage wird geladen", ph -> this.loadAndApplyTemplate(this.templateFile, ph));
        } else {
            if (this.project.isOpen()) {
                return;
            }
            ArrayList errors = new ArrayList();
            ThemisTaskWithDialog.createTaskWithCounterAndCancel("task.update-projecttemplate", ph -> {
                ph.switchToDeterminate(this.updateList.size() + 1);
                int counter = 0;
                for (ThemisFolder themis : this.updateList) {
                    ThemisLock projectLock = themis.getProjectLock();
                    if (projectLock.isLocked()) {
                        errors.add(this.project.getResourceText("error.project-locked-cannot-open", new String[]{themis.getFolderName()}));
                        continue;
                    }
                    ph.progress("Projekt '" + themis.getFolderName() + "' wird aktualisiert", ++counter);
                    try {
                        this.project.getLogger().info("... updating project " + themis.getProjectFolder().getAbsolutePath());
                        this.project.open(themis, null, null, false, ThemisUtil.isOnNetworkDrive((File)themis.getProjectFolder()), false, false, false, null);
                        if (!this.project.isOpen()) {
                            errors.add(this.project.getResourceText("error.project-cannot-open", new String[]{themis.getFolderName()}));
                            continue;
                        }
                        if (!this.app.isUserAdministrator()) {
                            errors.add(this.project.getResourceText("error.project-no-admin-permission", new String[]{themis.getFolderName()}));
                            this.project.close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
                            continue;
                        }
                        this.loadAndApplyTemplate(this.templateFile, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.app.getProject().close(new Closing().withoutAsking().withoutExport().withoutTrigger(), null);
                    if (!ph.isCancelled()) continue;
                    return;
                }
            });
            if (!errors.isEmpty()) {
                Dialogs.getInstance().showErrorDialog("- " + String.join((CharSequence)"<br>- ", errors));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadAndApplyTemplate(File templateFile, ProgressHandler ph) {
        if (!this.project.isOpen()) {
            return;
        }
        if (DemoPackManager.isValidTemplateFile((File)this.templateFile)) {
            deleteMissing = this.chkDeleteMissing.isEnabled() != false && this.chkDeleteMissing.isSelected() != false;
            missing = null;
            if (this.templateFile.getName().toLowerCase().endsWith(".themis")) {
                try {
                    if (this.tf == null) {
                        this.tf = new ThemisFile(ph);
                    }
                    this.tf.setWithTemplates(this.chkTemplates.isEnabled() != false && this.chkTemplates.isSelected() != false);
                    this.tf.setWithIcons(this.chkIcons.isEnabled() != false && this.chkIcons.isSelected() != false);
                    this.tf.setWithReportTemplates(this.chkReportTemplates.isEnabled() != false && this.chkReportTemplates.isSelected() != false);
                    this.tf.setWithContacts(this.chkContacts.isEnabled() != false && this.chkContacts.isSelected() != false);
                    this.tf.setWithDocuments(this.chkDocuments.isEnabled() != false && this.chkDocuments.isSelected() != false);
                    this.tf.setWithForms(this.chkForms.isEnabled() != false && this.chkForms.isSelected() != false);
                    this.tf.setWithKeytables(this.chkLists.isEnabled() != false && this.chkLists.isSelected() != false);
                    this.tf.setWithSettings(this.chkSettings.isEnabled() != false && this.chkSettings.isSelected() != false);
                    result = this.tf.loadFromFile(templateFile, true);
                    this.loaded = true;
                    if (!deleteMissing) ** GOTO lbl62
                    s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), new String[]{"locationgroup", "locationtemplate", "observationtemplate", "measuretemplate"});
                    idsInDatabase = s.search().getResultIds();
                    idsInFile = result.getTemplateIds();
                    missing = new ArrayList<Long>();
                    var9_11 = idsInDatabase.iterator();
                    while (var9_11.hasNext()) {
                        id = (Long)var9_11.next();
                        if (idsInFile.contains(id)) continue;
                        missing.add(id);
                    }
                }
                catch (IOException | JDOMException ex) {
                    ex.printStackTrace();
                }
            } else {
                m = new TemplateManager(this.app, this.project);
                m.setWithTemplates(this.chkTemplates.isEnabled() != false && this.chkTemplates.isSelected() != false);
                m.setWithIcons(this.chkIcons.isEnabled() != false && this.chkIcons.isSelected() != false);
                m.setWithContacts(this.chkContacts.isEnabled() != false && this.chkContacts.isSelected() != false);
                m.setWithDocuments(this.chkDocuments.isEnabled() != false && this.chkDocuments.isSelected() != false);
                m.setWithKeytables(this.chkLists.isEnabled() != false && this.chkLists.isSelected() != false);
                m.setWithSettings(this.chkSettings.isEnabled() != false && this.chkSettings.isSelected() != false);
                m.loadTemplatesFromXls(null, null, templateFile);
                this.loaded = true;
                if (deleteMissing) {
                    missing = m.getMissingTemplateIds();
                }
            }
lbl62:
            // 6 sources

            if (deleteMissing && missing != null) {
                this.project.getLogger().info("... deleting " + missing.size() + " entries");
                var5_5 = missing.iterator();
                while (var5_5.hasNext()) {
                    id = (Long)var5_5.next();
                    CmsElement.remove((CmsApplication)this.project, (long)id, (CmsUser)this.project.getUser());
                }
            }
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void initComponents() {
        this.lblChoose = new JLabel();
        this.lblTemplateTitle = new JLabel();
        this.jLabel104 = new JLabel();
        this.jPanel3 = new JPanel();
        this.btnSetAll = new JButton();
        this.btnSetNone = new JButton();
        this.chkTemplates = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.chkDeleteMissing = new JCheckBox();
        this.jLabel105 = new JLabel();
        this.chkMatchByTitle = new JCheckBox();
        this.jLabel106 = new JLabel();
        this.chkIcons = new JCheckBox();
        this.chkReportTemplates = new JCheckBox();
        this.chkContacts = new JCheckBox();
        this.chkDocuments = new JCheckBox();
        this.chkForms = new JCheckBox();
        this.chkLists = new JCheckBox();
        this.chkSettings = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.btnLoad = new JButton();
        this.btnCancel = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.lblChoose.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblChoose, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.lblChoose.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblChoose, gridBagConstraints);
        this.lblTemplateTitle.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblTemplateTitle, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.lblTemplateTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblTemplateTitle, gridBagConstraints);
        this.jLabel104.setFont(THEMIS.fontLabel);
        this.jLabel104.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel104, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.jLabel104.text"));
        this.jLabel104.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel104, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnSetAll.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetAll, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.btnSetAll.text"));
        this.btnSetAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSettingsContentPanel.this.btnSetAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnSetAll, gridBagConstraints);
        this.btnSetNone.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetNone, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.btnSetNone.text"));
        this.btnSetNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSettingsContentPanel.this.btnSetNoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnSetNone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.chkTemplates.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkTemplates, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkTemplates.text"));
        this.chkTemplates.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LoadSettingsContentPanel.this.chkTemplatesItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkTemplates, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.chkDeleteMissing.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkDeleteMissing, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkDeleteMissing.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.chkDeleteMissing, gridBagConstraints);
        this.jLabel105.setFont(THEMIS.fontLabel);
        this.jLabel105.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel105, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.jLabel105.text"));
        this.jLabel105.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 35, 0, 3);
        this.jPanel1.add((Component)this.jLabel105, gridBagConstraints);
        this.chkMatchByTitle.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkMatchByTitle, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkMatchByTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.chkMatchByTitle, gridBagConstraints);
        this.jLabel106.setFont(THEMIS.fontLabel);
        this.jLabel106.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel106, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.jLabel106.text"));
        this.jLabel106.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 35, 0, 3);
        this.jPanel1.add((Component)this.jLabel106, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 23, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.chkIcons.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkIcons, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkIcons.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkIcons, gridBagConstraints);
        this.chkReportTemplates.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkReportTemplates, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkReportTemplates.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkReportTemplates, gridBagConstraints);
        this.chkContacts.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkContacts, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkContacts.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkContacts, gridBagConstraints);
        this.chkDocuments.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkDocuments, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkDocuments.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkDocuments, gridBagConstraints);
        this.chkForms.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkForms, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkForms.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkForms, gridBagConstraints);
        this.chkLists.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkLists, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkLists.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkLists, gridBagConstraints);
        this.chkSettings.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkSettings, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.chkSettings.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkSettings, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnLoad.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnLoad, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.btnLoad.text"));
        this.btnLoad.setMaximumSize(null);
        this.btnLoad.setMinimumSize(null);
        this.btnLoad.setPreferredSize(null);
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSettingsContentPanel.this.btnLoadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.btnLoad, gridBagConstraints);
        this.btnCancel.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(LoadSettingsContentPanel.class, (String)"LoadSettingsContentPanel.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSettingsContentPanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void btnSetAllActionPerformed(ActionEvent evt) {
        this.setAll(true);
    }

    private void btnSetNoneActionPerformed(ActionEvent evt) {
        this.setAll(false);
    }

    private void btnLoadActionPerformed(ActionEvent evt) {
        this.loadTemplate();
        this.closeDialog();
    }

    private void chkTemplatesItemStateChanged(ItemEvent evt) {
        this.setCheckboxEnabled(this.chkDeleteMissing, this.chkTemplates.isSelected());
        this.setCheckboxEnabled(this.chkMatchByTitle, this.chkTemplates.isSelected());
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(730, 645);
    }
}

