/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.config;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.config.LoadSettingsContentPanel;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.themis.ontology.template.TemplateDescription;
import at.grid.util.ProgressHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LoadSettingsPanel
extends ThemisPanel {
    File templateFile;
    private DefaultComboBoxModel<TemplateDescription> modelTemplate = new DefaultComboBoxModel();
    boolean loaded = false;
    ArrayList<ThemisFolder> updateList = null;
    private JButton btnSelectFile;
    private JButton btnSelectFile1;
    private JButton btnSelectFile3;
    private JTextField fldTemplateFile;
    private JComboBox<TemplateDescription> fldTemplateSource;
    private JLabel jLabel104;
    private JLabel jLabel105;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblChoose;
    private JLabel lblChoose1;
    private JPanel panelFile;
    private JPanel panelFileSelect;

    public LoadSettingsPanel() {
        this.initComponents();
        new DropTarget(this.fldTemplateFile, new ThemisDropTargetListener(false, false, new String[]{"xlsx", "themis"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                LoadSettingsPanel.this.setSelectedFile(f);
            }
        });
    }

    public LoadSettingsPanel(ArrayList<ThemisFolder> updateList) {
        this();
        this.updateList = updateList;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void populate(ProgressHandler ph) {
        this.app.getProject().getTemplateManger().readInternalTemplates();
        this.modelTemplate.addElement(TemplateDescription.createFileSource());
        DemoPackManager demo = DemoPackManager.getInstance();
        for (TemplateDescription td : demo.getProjectTemplates()) {
            this.modelTemplate.addElement(td);
        }
        this.templateFile = this.app.getSettings().getTemplateFile();
        this.fldTemplateFile.setText(this.templateFile == null ? "" : this.templateFile.getAbsolutePath());
    }

    @Override
    public void apply() {
        this.app.getSettings().setTemplateFile(this.templateFile);
        this.app.getSettings().setInternalTemplateFile(null);
        if (this.fldTemplateSource.getSelectedIndex() == 0) {
            this.loadTemplateFromFile();
        } else {
            File tempFile;
            TemplateDescription td = (TemplateDescription)this.fldTemplateSource.getSelectedItem();
            boolean success = td.saveToFile(tempFile = ThemisApplication.getInstance().getProject().getTempfileLocation());
            if (success) {
                File f = td.getFileToShow();
                this.app.getSettings().setInternalTemplateFile(new File(tempFile, f.getName()));
            }
        }
    }

    private boolean loadTemplateFromFile() {
        File f = new File(this.fldTemplateFile.getText());
        if (!f.isFile()) {
            this.app.getDialog().showErrorDialog("error.file-not-found", new String[]{f.getName()});
        } else if (DemoPackManager.isValidTemplateFile((File)f)) {
            LoadSettingsContentPanel p = new LoadSettingsContentPanel(f, this.updateList);
            p.showDialog();
            if (p.isLoaded()) {
                this.loaded = true;
                this.closeDialog();
                return true;
            }
        } else {
            this.app.getDialog().showErrorDialog("error.no-project-template-file");
        }
        return false;
    }

    private void setSelectedFile(File f) {
        if (DemoPackManager.isValidTemplateFile((File)f)) {
            this.fldTemplateFile.setText(f.getAbsolutePath());
        } else {
            this.app.getDialog().showWarningDialog("error.no-project-template-file");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.lblChoose = new JLabel();
        this.jLabel104 = new JLabel();
        this.fldTemplateSource = new JComboBox();
        this.panelFile = new JPanel();
        this.lblChoose1 = new JLabel();
        this.jLabel105 = new JLabel();
        this.panelFileSelect = new JPanel();
        this.jLabel4 = new JLabel();
        this.fldTemplateFile = new JTextField();
        this.btnSelectFile = new JButton();
        this.jPanel2 = new JPanel();
        this.btnSelectFile1 = new JButton();
        this.btnSelectFile3 = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblChoose.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblChoose, (String)NbBundle.getMessage(LoadSettingsPanel.class, (String)"LoadSettingsPanel.lblChoose.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.lblChoose, gridBagConstraints);
        this.jLabel104.setFont(THEMIS.fontLabel);
        this.jLabel104.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel104, (String)NbBundle.getMessage(LoadSettingsPanel.class, (String)"LoadSettingsPanel.jLabel104.text"));
        this.jLabel104.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jLabel104, gridBagConstraints);
        this.fldTemplateSource.setFont(THEMIS.fontList);
        this.fldTemplateSource.setModel(this.modelTemplate);
        this.fldTemplateSource.setPreferredSize(new Dimension(100, 30));
        this.fldTemplateSource.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LoadSettingsPanel.this.fldTemplateSourceItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel3.add(this.fldTemplateSource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.panelFile.setLayout(new GridBagLayout());
        this.lblChoose1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblChoose1, (String)NbBundle.getMessage(LoadSettingsPanel.class, (String)"LoadSettingsPanel.lblChoose1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.lblChoose1, gridBagConstraints);
        this.jLabel105.setFont(THEMIS.fontLabel);
        this.jLabel105.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel105, (String)NbBundle.getMessage(LoadSettingsPanel.class, (String)"LoadSettingsPanel.jLabel105.text"));
        this.jLabel105.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.jLabel105, gridBagConstraints);
        this.panelFileSelect.setLayout(new GridBagLayout());
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(LoadSettingsPanel.class, (String)"LoadSettingsPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelFileSelect.add((Component)this.jLabel4, gridBagConstraints);
        this.fldTemplateFile.setFont(THEMIS.fontTextfield);
        this.fldTemplateFile.setText(NbBundle.getMessage(LoadSettingsPanel.class, (String)"LoadSettingsPanel.fldTemplateFile.text"));
        this.fldTemplateFile.setMinimumSize(null);
        this.fldTemplateFile.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelFileSelect.add((Component)this.fldTemplateFile, gridBagConstraints);
        this.btnSelectFile.setFont(THEMIS.fontButton);
        this.btnSelectFile.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/folder24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFile, (String)NbBundle.getMessage(LoadSettingsPanel.class, (String)"LoadSettingsPanel.btnSelectFile.text"));
        this.btnSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSettingsPanel.this.btnSelectFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelFileSelect.add((Component)this.btnSelectFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelFile.add((Component)this.panelFileSelect, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.panelFile, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnSelectFile1.setFont(THEMIS.fontButton);
        this.btnSelectFile1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFile1, (String)NbBundle.getMessage(LoadSettingsPanel.class, (String)"LoadSettingsPanel.btnSelectFile1.text"));
        this.btnSelectFile1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSettingsPanel.this.btnSelectFile1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.btnSelectFile1, gridBagConstraints);
        this.btnSelectFile3.setFont(THEMIS.fontButton);
        this.btnSelectFile3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFile3, (String)NbBundle.getMessage(LoadSettingsPanel.class, (String)"LoadSettingsPanel.btnSelectFile3.text"));
        this.btnSelectFile3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoadSettingsPanel.this.btnSelectFile3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.btnSelectFile3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnSelectFileActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.app.getProject().getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getSettings().getTemplateFile(), null, new FileNameExtensionFilter("Projektvorlage", "xlsx", "themis"), null, false).getSelectedFile();
        if (f != null) {
            this.setSelectedFile(f);
        }
    }

    private void fldTemplateSourceItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            if (this.fldTemplateSource.getSelectedIndex() == 0) {
                this.panelFile.setVisible(true);
            } else {
                this.panelFile.setVisible(false);
                TemplateDescription td = (TemplateDescription)this.fldTemplateSource.getSelectedItem();
                if (td.hasHint()) {
                    this.app.getDialog().showWarningDialog(td.getHint());
                }
            }
        }
    }

    private void btnSelectFile1ActionPerformed(ActionEvent evt) {
        TemplateDescription sel = (TemplateDescription)this.fldTemplateSource.getSelectedItem();
        if (sel != null) {
            if (this.fldTemplateSource.getSelectedIndex() == 0) {
                this.loadTemplateFromFile();
            } else {
                File f = sel.getFile();
                if (DemoPackManager.isValidTemplateFile((File)f)) {
                    LoadSettingsContentPanel p = new LoadSettingsContentPanel(f, this.updateList);
                    p.showDialog();
                    if (p.isLoaded()) {
                        this.loaded = true;
                        this.closeDialog();
                    }
                } else {
                    this.app.getDialog().showWarningDialog("error.no-project-template-file");
                }
            }
        }
    }

    private void btnSelectFile3ActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(600, 340);
    }
}

