/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.config;

import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsLocationgroup;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LocationgroupPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    CmsLocationgroup group;
    private JTextField fldChapter;
    private JTextArea fldDescription;
    private JComboBox<CmsBasicElement> fldGroupHierarchy;
    private JTextField fldTitle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;

    public LocationgroupPanel(CmsLocationgroup g) {
        this.initComponents();
        this.group = g;
        this.populate();
    }

    public boolean isNew() {
        return this.group.isNew();
    }

    public void applyPanel() {
        this.group.setAttributeValue("title", this.fldTitle.getText());
        this.group.setAttributeValue("description", this.fldDescription.getText());
        this.group.setAttributeValue("chapter", this.fldChapter.getText());
        CmsBasicElement sel = (CmsBasicElement)this.fldGroupHierarchy.getSelectedItem();
        if (sel != null) {
            this.group.getLongAttribute("parentgroup").setValue(sel.getId());
        }
    }

    private void populate() {
        this.fldTitle.setText(this.group.getAttributeValue("title"));
        this.fldDescription.setText(this.group.getAttributeValue("description"));
        this.fldChapter.setText(this.group.getAttributeValue("chapter"));
        this.populateGroupHierarchy(this.group.getLongAttribute("parentgroup").getLong());
    }

    public CmsElement getGroup() {
        return this.group;
    }

    private void populateGroupHierarchy(long parent) {
        CmsBasicElement sel = null;
        List locationGroupTemplates = this.project.getTemplateManger().getLocationGroups(-99L);
        ((DefaultComboBoxModel)this.fldGroupHierarchy.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.fldGroupHierarchy.getModel()).addElement(new CmsBasicElement(-1L, ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.none.text")));
        int level = 99;
        for (DataRecord rec : locationGroupTemplates) {
            CmsBasicElement be = new CmsBasicElement(rec);
            if (be.getId() == this.group.getId()) {
                level = rec.getInt("level");
                continue;
            }
            if (rec.getInt("level") > level) continue;
            ((DefaultComboBoxModel)this.fldGroupHierarchy.getModel()).addElement(be);
            if (be.getId() == parent) {
                sel = be;
            }
            level = 99;
        }
        if (sel != null) {
            this.fldGroupHierarchy.setSelectedItem(sel);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.fldGroupHierarchy = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.fldTitle = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.fldDescription = new JTextArea();
        this.jLabel5 = new JLabel();
        this.fldChapter = new JTextField();
        this.jLabel1.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LocationgroupPanel.class, (String)"LocationgroupPanel.jLabel1.text"));
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(LocationgroupPanel.class, (String)"LocationgroupPanel.jLabel2.text"));
        this.fldGroupHierarchy.setFont(THEMIS.fontList);
        this.fldGroupHierarchy.setModel(new DefaultComboBoxModel());
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(LocationgroupPanel.class, (String)"LocationgroupPanel.jLabel3.text"));
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(LocationgroupPanel.class, (String)"LocationgroupPanel.jLabel4.text"));
        this.fldTitle.setFont(THEMIS.fontTextfield);
        this.fldTitle.setText(NbBundle.getMessage(LocationgroupPanel.class, (String)"LocationgroupPanel.fldTitle.text"));
        this.fldDescription.setColumns(20);
        this.fldDescription.setFont(THEMIS.fontTextfield);
        this.fldDescription.setRows(5);
        this.jScrollPane1.setViewportView(this.fldDescription);
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(LocationgroupPanel.class, (String)"LocationgroupPanel.jLabel5.text"));
        this.fldChapter.setFont(THEMIS.fontTextfield);
        this.fldChapter.setText(NbBundle.getMessage(LocationgroupPanel.class, (String)"LocationgroupPanel.fldChapter.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel1).addComponent(this.jLabel5).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldGroupHierarchy, 0, -1, Short.MAX_VALUE).addComponent(this.fldTitle).addComponent(this.jScrollPane1, -1, 423, Short.MAX_VALUE).addComponent(this.fldChapter)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fldGroupHierarchy, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.fldChapter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.fldTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jScrollPane1, -2, 140, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

