/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.config;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.gui.Point;
import at.grid.ontology.swing.CmsElementPanel;
import at.grid.ontology.swing.component.KeytablePanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.config.AttributeSettingsPanel;
import at.grid.themis.application.config.AttributeSettingsPanelInterface;
import at.grid.themis.application.config.LoadSettingsPanel;
import at.grid.themis.application.config.LocationListOptionPanel;
import at.grid.themis.application.config.LocationgroupPanel;
import at.grid.themis.application.config.ReportLayoutWizardIntervace;
import at.grid.themis.application.config.SaveSettingsContentPanel;
import at.grid.themis.application.config.ThemisAttributePanel;
import at.grid.themis.application.project.ViewHelper;
import at.grid.themis.application.report.ReportLayoutManagerPanel;
import at.grid.themis.application.server.ServerCodePanel;
import at.grid.themis.application.server.ServerProjectCodesPanel;
import at.grid.themis.application.server.ServerStatusPanel;
import at.grid.themis.application.ui.ConfigurationTopic;
import at.grid.themis.application.ui.IconItemRenderer;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.ui.WizardTopiCellRenderer;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisProjectStatus;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.attribute.ThemisNoneAttribute;
import at.grid.themis.ontology.element.CmsIcon;
import at.grid.themis.ontology.element.CmsLocationgroup;
import at.grid.themis.ontology.element.CmsObservationTemplate;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.themis.ontology.template.TemplateDescription;
import at.grid.themis.ontology.template.TemplateManager;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FilenameUtils;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ProjectSettingsPanel
extends ThemisPanel
implements AttributeSettingsPanelInterface,
ReportLayoutWizardIntervace {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisSettings settings = this.app.getSettings();
    DemoPackManager demo = DemoPackManager.getInstance();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/config/Bundle");
    ThemisProject project = this.app.getProject();
    Properties conf = new Properties();
    private DefaultListModel<Keytable> modelKeytable = new DefaultListModel();
    private DefaultListModel<CmsBasicElement> modelObservationTemplate = new DefaultListModel();
    private DefaultListModel<CmsBasicElement> modelMeasureTemplate = new DefaultListModel();
    private DefaultListModel<CmsBasicElement> modelLocationTemplate = new DefaultListModel();
    private DefaultListModel<CmsBasicElement> modelLocGroupTemplate = new DefaultListModel();
    private DefaultComboBoxModel<TemplateDescription> modelTemplate = new DefaultComboBoxModel();
    private DefaultListModel<String> modelObsDisplay = new DefaultListModel();
    private DefaultListModel<String> modelLocDisplay = new DefaultListModel();
    private DefaultListModel<String> modelObsAttributes = new DefaultListModel();
    private DefaultListModel<String> modelLocAttributes = new DefaultListModel();
    private DefaultComboBoxModel<String> modelDisplayDoneTasks = new DefaultComboBoxModel();
    long selectedLocationGroupTemplateId = -1L;
    long selectedLocationTemplateId = -1L;
    long selectedObservationTemplateId = -1L;
    CmsIcon currentIcon = null;
    private KeytablePanel panelKeyTable;
    boolean loadTemplateSucessful;
    DefaultMutableTreeNode templateTreeRoot = new DefaultMutableTreeNode();
    DefaultTreeModel templateTreeModel = new DefaultTreeModel(this.templateTreeRoot);
    ImageIcon iconLoc = new ImageIcon(ProjectSettingsPanel.class.getResource("/at/grid/themis/application/media/G.gif"));
    ImageIcon iconObs = new ImageIcon(ProjectSettingsPanel.class.getResource("/at/grid/themis/application/media/B.gif"));
    ImageIcon iconObsCheck = new ImageIcon(ProjectSettingsPanel.class.getResource("/at/grid/themis/application/media/BK.gif"));
    ImageIcon iconObsTask = new ImageIcon(ProjectSettingsPanel.class.getResource("/at/grid/themis/application/media/BA.gif"));
    ImageIcon iconObsDefect = new ImageIcon(ProjectSettingsPanel.class.getResource("/at/grid/themis/application/media/BM.gif"));
    ImageIcon iconObsInfo = new ImageIcon(ProjectSettingsPanel.class.getResource("/at/grid/themis/application/media/BI.gif"));
    ImageIcon iconMeas = new ImageIcon(ProjectSettingsPanel.class.getResource("/at/grid/themis/application/media/M.gif"));
    ImageIcon iconFolder = new ImageIcon(ProjectSettingsPanel.class.getResource("/at/grid/themis/application/media/folder.gif"));
    ArrayList<ThemisAttribute> observationListDisplay = new ArrayList();
    ArrayList<ThemisAttribute> observationListDontDisplay = new ArrayList();
    ArrayList<String> locationListDisplay = new ArrayList();
    ArrayList<String> locationListDontDisplay = new ArrayList();
    boolean trigger = false;
    private boolean initialisingColorDisplay;
    public static final String PAGE_TEMPLATES = "PageTemplates";
    public static final String PAGE_ICONS = "PageIcons";
    public static final String PAGE_KEYTABLES = "PageKeytables";
    public static final String PAGE_OBSLIST = "PageObsList";
    public static final String PAGE_LOCLIST = "PageLocList";
    public static final String PAGE_DISPLAY = "PageDisplay";
    public static final String PAGE_LABELS = "PageLables";
    public static final String PAGE_ATTLOC = "PageAttLoc";
    public static final String PAGE_ATTOBS = "PageAttObs";
    public static final String PAGE_ATTEVT = "PageAttEvt";
    public static final String PAGE_ATTPRJ = "PageAttPrj";
    public static final String PAGE_IMAGE = "PageImage";
    public static final String PAGE_EVENT = "PageEvent";
    public static final String PAGE_OTHER = "PageOther";
    public static final String PAGE_NUMBERING = "PageNumbering";
    public static final String PAGE_REPORT = "PageReportLayout";
    public static final String PAGE_TABLES = "PageReportTables";
    public static final String PAGE_SERVERSETUP = "PageServerSetup";
    public static final String PAGE_SERVERCODE = "PageServerCode";
    public static final String PAGE_SERVERSTATUS = "PageServerStatus";
    ReportLayoutManagerPanel panelReportLayout;
    private ServerCodePanel panelServerSetup;
    private ServerProjectCodesPanel panelServerCodes;
    private ServerStatusPanel panelServerStatus;
    LocationListOptionPanel panelLocationListSettings;
    boolean alreadyPopulated = false;
    private JPanel PanelTextTemplateMain;
    private JButton btnAddDisplay;
    private JButton btnAddIcon;
    private JButton btnAddLocationAttribute1;
    private JButton btnAddObsvervationAttribute1;
    private JButton btnClose;
    private JButton btnColorBackground;
    private JButton btnColorText;
    private JButton btnDisplayDown;
    private JButton btnDisplayUp;
    private JButton btnDown;
    private JButton btnDown1;
    private JButton btnIconFilterClear;
    private JButton btnIconFilterOk;
    private JButton btnIconRemoveDuplicates;
    private JButton btnIconRemoveDuplicates1;
    private JButton btnIconRemoveDuplicates2;
    private JButton btnRemove;
    private JButton btnRemove1;
    private JButton btnRemoveDisplay;
    private JButton btnRemoveIcon;
    private JButton btnSortLocations;
    private JButton btnSortObservations;
    private JButton btnSortTemplatesAlphabetically;
    private JButton btnSortTemplatesAlphabetically1;
    private JButton btnTemplateDeleteAll;
    private JButton btnTemplateExport;
    private JButton btnTemplateLoad;
    private JButton btnTemplateSave;
    private JButton btnTextTemplateAddGroup;
    private JButton btnTextTemplateAddLocation;
    private JButton btnTextTemplateAddMeasure;
    private JButton btnTextTemplateAddObservation;
    private JButton btnTextTemplateDelete;
    private JButton btnTextTemplateEditSave;
    private JButton btnUp;
    private JButton btnUp1;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JRadioButton chkAddFotoLoc;
    private JRadioButton chkAddFotoObs;
    private JCheckBox chkBuildingInLocList;
    private JCheckBox chkCache;
    private JCheckBox chkCreateObservation;
    private JCheckBox chkEventCreate;
    private JCheckBox chkImageKeepOriginal;
    private JCheckBox chkLocNumberIndividual;
    private JCheckBox chkLocationAsFilter;
    private JCheckBox chkPlanLabelNummer;
    private JCheckBox chkPlanLargeBuffer;
    private JCheckBox chkPlanMoveIconWithLabel;
    private JTextField colorLabelBackground;
    private JTextField colorPoint;
    private JTextField colorPointSelected;
    private JComboBox<ColorOption> fldDisplayColorSelection;
    private JComboBox<String> fldDisplayHideDoneTask;
    private JTextField fldFontSize;
    private JTextField fldIconSize;
    private JTextField fldIconfilter;
    private JTextField fldImageSize;
    private JTextField fldLabelOffsetX;
    private JTextField fldLabelOffsetY;
    private JTextField fldLineSize;
    private JComboBox<String> fldLocNumberScheme;
    private JComboBox<String> fldLocSortOrder;
    private JComboBox<ThemisAttribute> fldLocationAttributeCodes1;
    private JComboBox<ThemisAttribute> fldObservationAttributeCodes1;
    private JTextField fldPermissionTemplate;
    private JComboBox<ThemisAttribute> fldPlanLabel;
    private JTextField fldPlanSnippetSizeMM;
    private JTextField fldPointSize;
    private JTextField fldStartnumber;
    private JTextField fldTextNewEvent;
    private JTextField fldTextNoContent;
    private JTextField fldTextNoEvent;
    private JTextField fldTextNoImage;
    private JTextField fldTextObservationtypeAufgabe;
    private JTextField fldTextObservationtypeInfo;
    private JTextField fldTextObservationtypeKontrolle;
    private JTextField fldTextObservationtypeMangel;
    private JTextField fldTextStatusErledigt;
    private JTextField fldTextStatusOffen;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel100;
    private JLabel jLabel102;
    private JLabel jLabel103;
    private JLabel jLabel104;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel4;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel52;
    private JLabel jLabel53;
    private JLabel jLabel54;
    private JLabel jLabel55;
    private JLabel jLabel56;
    private JLabel jLabel57;
    private JLabel jLabel58;
    private JLabel jLabel59;
    private JLabel jLabel6;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel62;
    private JLabel jLabel63;
    private JLabel jLabel64;
    private JLabel jLabel65;
    private JLabel jLabel66;
    private JLabel jLabel67;
    private JLabel jLabel68;
    private JLabel jLabel69;
    private JLabel jLabel7;
    private JLabel jLabel70;
    private JLabel jLabel72;
    private JLabel jLabel73;
    private JLabel jLabel74;
    private JLabel jLabel75;
    private JLabel jLabel76;
    private JLabel jLabel77;
    private JLabel jLabel78;
    private JLabel jLabel79;
    private JLabel jLabel8;
    private JLabel jLabel80;
    private JLabel jLabel81;
    private JLabel jLabel82;
    private JLabel jLabel83;
    private JLabel jLabel84;
    private JLabel jLabel85;
    private JLabel jLabel86;
    private JLabel jLabel87;
    private JLabel jLabel88;
    private JLabel jLabel89;
    private JLabel jLabel9;
    private JLabel jLabel90;
    private JLabel jLabel91;
    private JLabel jLabel92;
    private JLabel jLabel93;
    private JLabel jLabel94;
    private JLabel jLabel95;
    private JLabel jLabel96;
    private JLabel jLabel97;
    private JLabel jLabel98;
    private JLabel jLabel99;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel18;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane8;
    private JLabel lblColorRemainder;
    private JLabel lblColorRemainder1;
    private JLabel lblIconCount;
    private JLabel lblIconDisplay;
    private JLabel lblImageQualityValue;
    private JLabel lblLocList;
    private JLabel lblLocList1;
    private JLabel lblPlanLargeBuffer;
    private JLabel lblType;
    private JLabel lblType1;
    private JList listTopic;
    private JList<CmsBasicElement> lstIcon;
    private JList lstKeytable;
    private JScrollPane lstKeytableScroll;
    private JList<String> lstObservationAttributes;
    private JList<String> modelObservationDisplay;
    private JPanel panelAttributeSelection;
    private JPanel panelAttributesObservation;
    private JPanel panelAttriubtesEvent;
    private JPanel panelAttriubtesLocation;
    private JPanel panelAttriubtesProject;
    private JPanel panelDisplay;
    private JScrollPane panelDisplayScroll;
    private JPanel panelEditor;
    private JScrollPane panelEditorScroll;
    private JPanel panelEvent;
    private JPanel panelHeader;
    private JPanel panelHeader1;
    private JPanel panelIcons;
    private JPanel panelImage;
    private JPanel panelKeytableEdit;
    private JPanel panelKeytables;
    private JPanel panelLabels;
    private JPanel panelLocationAttributes1;
    private JScrollPane panelLocationAttributes1Scroll;
    private JPanel panelNumbering;
    private JPanel panelObservationAttributes1;
    private JScrollPane panelObservationAttributes1Scroll;
    private JPanel panelObservationList;
    private JPanel panelOtherSettings;
    private JPanel panelSelection;
    private JPanel panelTemplateTreeButtons;
    private JPanel panelTextTemplateEdit;
    private JPanel panelTextTemplates;
    private JSlider sliderImageQuality;
    private JTree templateTree;
    private JScrollPane templateTreeScroll;

    public ProjectSettingsPanel() {
        this.initComponents();
        this.project.getTemplateManger().readInternalTemplates();
        this.modelTemplate.addElement(TemplateDescription.createFileSource());
        for (TemplateDescription td : this.project.getTemplateManger().getProjectTemplates()) {
            this.modelTemplate.addElement(td);
        }
        this.listTopic.setCellRenderer(new WizardTopiCellRenderer());
        DefaultListModel topicModel = (DefaultListModel)this.listTopic.getModel();
        topicModel.addElement(new ConfigurationTopic("Katalog"));
        topicModel.addElement(new ConfigurationTopic(PAGE_TEMPLATES, "cardTemplateTree", "  " + this.bundle.getString("SECTION_TEMPLATES")));
        topicModel.addElement(new ConfigurationTopic(PAGE_ICONS, "cardIcons", "  " + this.bundle.getString("SECTION_ICONS")));
        topicModel.addElement(new ConfigurationTopic("Attribute"));
        topicModel.addElement(new ConfigurationTopic(PAGE_ATTOBS, "cardAttributesObs", "  " + this.bundle.getString("SECTION_ATTRIBUTESOBS")));
        topicModel.addElement(new ConfigurationTopic(PAGE_ATTLOC, "cardAttributesLoc", "  " + this.bundle.getString("SECTION_ATTRIBUTESLOC")));
        topicModel.addElement(new ConfigurationTopic(PAGE_KEYTABLES, "cardKeytables", "  " + this.bundle.getString("SECTION_LISTS")));
        topicModel.addElement(new ConfigurationTopic("Darstellung"));
        topicModel.addElement(new ConfigurationTopic(PAGE_OBSLIST, "cardObservationList", "  " + this.bundle.getString("SECTION_OBSERVATIONLIST")));
        this.panelLocationListSettings = new LocationListOptionPanel(this);
        topicModel.addElement(new ConfigurationTopic(PAGE_LOCLIST, this.panelLocationListSettings, "  " + this.bundle.getString("SECTION_LOCATIONLIST")));
        topicModel.addElement(new ConfigurationTopic(PAGE_DISPLAY, "cardDisplay", "  " + this.bundle.getString("SECTION_DISPLAY")));
        topicModel.addElement(new ConfigurationTopic(PAGE_LABELS, "cardLabels", "  " + this.bundle.getString("SECTION_LABELS")));
        topicModel.addElement(new ConfigurationTopic("Allgemein"));
        topicModel.addElement(new ConfigurationTopic(PAGE_IMAGE, "cardImage", "  " + this.bundle.getString("SECTION_IMAGES")));
        topicModel.addElement(new ConfigurationTopic(PAGE_EVENT, "cardEvent", "  " + this.bundle.getString("SECTION_EVENT")));
        topicModel.addElement(new ConfigurationTopic(PAGE_OTHER, "cardDisplayObs", "  " + this.bundle.getString("SECTION_OTHER_SETTINGS")));
        topicModel.addElement(new ConfigurationTopic(PAGE_NUMBERING, "cardOther", "  " + this.bundle.getString("SECTION_NUMBERING")));
        topicModel.addElement(new ConfigurationTopic("Ausgabe"));
        this.panelReportLayout = new ReportLayoutManagerPanel(this);
        topicModel.addElement(new ConfigurationTopic(PAGE_REPORT, this.panelReportLayout, "  " + this.bundle.getString("SECTION_REPORTLAYOUT")).setLazyLoading(true));
        if (!this.project.isThemisFileDirectAccess()) {
            boolean hasServer = this.project.hasThemisServer();
            topicModel.addElement(new ConfigurationTopic("Server"));
            this.panelServerSetup = new ServerCodePanel(this);
            topicModel.addElement(new ConfigurationTopic(PAGE_SERVERSETUP, this.panelServerSetup, "  " + this.bundle.getString("SECTION_SERVERSETUP")).setLazyLoading(true));
            this.panelServerCodes = new ServerProjectCodesPanel(this);
            topicModel.addElement(new ConfigurationTopic(PAGE_SERVERCODE, this.panelServerCodes, "  " + this.bundle.getString("SECTION_SERVERLINKS")).setAvailable(hasServer).setLazyLoading(true));
            this.panelServerStatus = new ServerStatusPanel(this);
            topicModel.addElement(new ConfigurationTopic(PAGE_SERVERSTATUS, this.panelServerStatus, "  " + this.bundle.getString("SECTION_SERVERSTATUS")).setAvailable(hasServer).setLazyLoading(true));
        }
        this.panelAttriubtesProject.add((Component)new AttributeSettingsPanel("project"), "Center");
        this.panelAttriubtesEvent.add((Component)new AttributeSettingsPanel("event"), "Center");
        this.templateTree.setCellRenderer(new ThemisTreeRenderer());
        this.templateTree.getSelectionModel().setSelectionMode(1);
        this.templateTree.setRowHeight((int)((double)this.templateTree.getFont().getSize() * 1.8));
        this.templateTree.setEditable(false);
        this.updateDisplay();
        this.modelDisplayDoneTasks.removeAllElements();
        this.modelDisplayDoneTasks.addElement(this.project.getResourceText("option.hide-done-tasks.none"));
        this.modelDisplayDoneTasks.addElement(this.project.getResourceText("option.hide-done-tasks.all"));
        this.modelDisplayDoneTasks.addElement(this.project.getResourceText("option.hide-done-tasks.all-but-current-event"));
        this.fldDisplayHideDoneTask.setModel(this.modelDisplayDoneTasks);
        this.loadDropDownList((DefaultComboBoxModel)this.fldLocNumberScheme.getModel(), this.bundle.getString("ProjectSettingsPanel.listNumbering.text"));
        this.fldLocationAttributeCodes1.setRenderer(IconItemRenderer.getInstanceNoBorder());
        this.fldObservationAttributeCodes1.setRenderer(IconItemRenderer.getInstanceNoBorder());
        this.populate();
        this.listTopic.setSelectedIndex(0);
        SettingsDnDListener myDragDropListener = new SettingsDnDListener();
        new DropTarget(this.lstIcon, myDragDropListener);
        DragScrollHandler dragScrollHandlerTemplateTree = new DragScrollHandler(this.templateTree, true, true);
        String treeState = this.project.getProjectProperty("system.tree.template", "");
        THEMIS.applyTreeExpansionState(this.templateTree, treeState);
        THEMIS.setCheckboxIcon(this.chkBuildingInLocList, this.chkCache, this.chkCreateObservation, this.chkEventCreate, this.chkImageKeepOriginal, this.chkLocNumberIndividual, this.chkLocationAsFilter, this.chkPlanLabelNummer, this.chkPlanLargeBuffer, this.chkPlanMoveIconWithLabel);
        this.modelObservationDisplay.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index < 0 || index > ProjectSettingsPanel.this.observationListDisplay.size() - 1) {
                    return c;
                }
                ThemisAttribute att = ProjectSettingsPanel.this.observationListDisplay.get(index);
                this.setForeground(att.isVirtual() || att.isUsed() ? Color.black : Color.lightGray);
                return c;
            }
        });
        this.lstObservationAttributes.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index < 0 || index > ProjectSettingsPanel.this.observationListDontDisplay.size() - 1) {
                    return c;
                }
                ThemisAttribute att = ProjectSettingsPanel.this.observationListDontDisplay.get(index);
                this.setForeground(att.isVirtual() || att.isUsed() ? Color.black : Color.lightGray);
                return c;
            }
        });
        if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            this.setVisible(false);
        }
        this.lblPlanLargeBuffer.setVisible(false);
        this.chkPlanLargeBuffer.setVisible(false);
        this.listTopic.setSelectedIndex(0);
        this.trigger = true;
    }

    public void showKeytables(String tbl) {
        if (!this.showTopic(PAGE_KEYTABLES)) {
            return;
        }
        for (int ii = 0; ii < this.modelKeytable.size(); ++ii) {
            if (!this.modelKeytable.elementAt(ii).getCode().equalsIgnoreCase(tbl)) continue;
            this.lstKeytable.setSelectedIndex(ii);
            break;
        }
    }

    public boolean showTopic(String panelId) {
        DefaultListModel topicModel = (DefaultListModel)this.listTopic.getModel();
        if (topicModel.isEmpty()) {
            return false;
        }
        if (panelId == null) {
            this.listTopic.setSelectedIndex(0);
            return false;
        }
        for (int ii = 0; ii < topicModel.size(); ++ii) {
            if (!panelId.equals(((ConfigurationTopic)topicModel.get(ii)).getId())) continue;
            this.listTopic.setSelectedIndex(ii);
            return true;
        }
        return false;
    }

    @Override
    public void populate(ProgressHandler ph0) {
        String numberScheme;
        if (this.alreadyPopulated) {
            return;
        }
        this.project.getLogger().info("populating project settings dialog");
        this.panelKeyTable = new KeytablePanel();
        this.panelKeytableEdit.add((Component)this.panelKeyTable, "North");
        this.panelKeyTable.enableComponents(false);
        this.chkLocNumberIndividual.setSelected(this.settings.getLocNumberIndividual());
        try {
            this.fldLocNumberScheme.setSelectedIndex(Integer.parseInt(this.project.getProjectProperty("attribute.locnumber.scheme", "0")));
        }
        catch (Exception ex) {
            this.fldLocNumberScheme.setSelectedIndex(0);
        }
        switch (numberScheme = this.app.getProject().getProjectProperty("attribute.locnumber.consecutive", "acc2Plan")) {
            case "acc2Plan": {
                this.fldLocSortOrder.setSelectedIndex(0);
                break;
            }
            case "acc2Creation": {
                this.fldLocSortOrder.setSelectedIndex(1);
                break;
            }
            case "acc2Number": {
                this.fldLocSortOrder.setSelectedIndex(2);
                break;
            }
            default: {
                this.fldLocSortOrder.setSelectedIndex(0);
            }
        }
        this.populateObservationDisplayLists(true);
        this.populateAttributeSettings();
        Color c = new Color(this.app.getColorManager().getColorFromString(this.settings.getDisplayColorPoint()));
        this.colorPoint.setForeground(c);
        this.colorPoint.setBackground(c);
        c = new Color(this.app.getColorManager().getColorFromString(this.settings.getDisplayColorPointSelected()));
        this.colorPointSelected.setForeground(c);
        this.colorPointSelected.setBackground(c);
        ColorOption co = this.settings.getDisplayColorOption();
        this.initialisingColorDisplay = true;
        if (co == null) {
            this.fldDisplayColorSelection.setSelectedIndex(0);
        } else {
            Integer cc = co.getStaticColor();
            this.colorLabelBackground.setBackground(cc == null ? Color.WHITE : new Color(cc));
            cc = co.getStaticForegroundColor();
            this.colorLabelBackground.setForeground(cc == null ? Color.BLACK : new Color(cc));
            this.colorLabelBackground.setDisabledTextColor(cc == null ? Color.BLACK : new Color(cc));
            this.colorLabelBackground.revalidate();
            for (int ii = 0; ii < this.fldDisplayColorSelection.getItemCount(); ++ii) {
                if (this.fldDisplayColorSelection.getItemAt(ii).getMethod() != co.getMethod()) continue;
                if (co.getMethod() == ColorOption.Method.ATTRIBUTE) {
                    if (!co.getAttribute().equals((Object)this.fldDisplayColorSelection.getItemAt(ii).getAttribute())) continue;
                    this.fldDisplayColorSelection.setSelectedIndex(ii);
                    this.colorLabelBackground.setEnabled(ii == 1);
                    break;
                }
                this.fldDisplayColorSelection.setSelectedIndex(ii);
                break;
            }
        }
        this.initialisingColorDisplay = true;
        this.chkPlanMoveIconWithLabel.setSelected(this.app.getSettings().getDisplayMoveIconWithLabel());
        Point offset = this.app.getSettings().getDisplayLabelOffset();
        if (offset != null) {
            this.fldLabelOffsetX.setText(Float.toString(0.1f * (float)((int)offset.getX())));
            this.fldLabelOffsetY.setText(Float.toString(0.1f * (float)((int)offset.getY())));
        }
        this.fldIconSize.setText(Float.toString((float)this.settings.getDisplayIconSize() / 10.0f));
        this.fldPointSize.setText(Float.toString((float)this.settings.getDisplayPointSize() / 10.0f));
        this.fldFontSize.setText(Float.toString((float)this.settings.getDisplayFontSize() / 10.0f));
        this.fldLineSize.setText(Float.toString((float)this.settings.getDisplayLineSize() / 10.0f));
        this.fldDisplayHideDoneTask.setSelectedIndex(this.settings.getDisplayHideDoneTask());
        this.chkCreateObservation.setSelected(this.settings.getDoCreateNewObservationWithLocation());
        this.chkLocationAsFilter.setSelected(this.settings.getDoFilterSelectedLocation());
        this.fldTextNewEvent.setText(this.settings.getTerm(ThemisSettings.Term.NewEventTitle));
        this.chkEventCreate.setSelected(this.settings.getDoAutoGenerateEvent());
        boolean addFotoToObs = this.settings.getImageForObservation();
        if (addFotoToObs) {
            this.chkAddFotoObs.setSelected(true);
            this.chkAddFotoLoc.setSelected(false);
        } else {
            this.chkAddFotoObs.setSelected(false);
            this.chkAddFotoLoc.setSelected(true);
        }
        this.fldImageSize.setText(Integer.toString(this.settings.getImageUploadSize()));
        this.fldPlanSnippetSizeMM.setText(Integer.toString(this.settings.getImagePlansnippetSize()));
        this.sliderImageQuality.setValue((int)(this.settings.getImageUploadQuality() * 10.0f));
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(this.sliderImageQuality.getMinimum(), new JLabel(this.bundle.getString("ProjectSettingsPanel.imageQualityLow.text")));
        labelTable.put(this.sliderImageQuality.getMaximum(), new JLabel(this.bundle.getString("ProjectSettingsPanel.imageQualityHigh.text")));
        this.sliderImageQuality.setLabelTable(labelTable);
        this.chkImageKeepOriginal.setSelected(this.settings.getImageKeepOriginal());
        this.chkBuildingInLocList.setSelected(this.settings.getShowBuildingsInLocList());
        this.fldTextStatusOffen.setText(this.settings.getTerm(ThemisSettings.Term.StatusOffen));
        this.fldTextStatusErledigt.setText(this.settings.getTerm(ThemisSettings.Term.StatusErledigt));
        this.fldTextObservationtypeMangel.setText(this.settings.getTerm(ThemisSettings.Term.TypMangel));
        this.fldTextObservationtypeAufgabe.setText(this.settings.getTerm(ThemisSettings.Term.TypAufgabe));
        this.fldTextObservationtypeKontrolle.setText(this.settings.getTerm(ThemisSettings.Term.TypKontrolle));
        this.fldTextObservationtypeInfo.setText(this.settings.getTerm(ThemisSettings.Term.TypInformation));
        this.fldTextNoEvent.setText(this.settings.getTerm(ThemisSettings.Term.TextNoEvent));
        this.fldTextNoImage.setText(this.settings.getTerm(ThemisSettings.Term.TextNoImage));
        this.fldTextNoContent.setText(this.settings.getTerm(ThemisSettings.Term.TextNoContent));
        this.fldPermissionTemplate.setText(this.settings.getPermissionEditTemplates());
        this.updatePlanLabelCombo();
        if (this.project != null && this.project.isOpen()) {
            this.updateIconList(-1L);
            this.updateTemplateTree();
            this.updateKeytableList();
            this.lstIcon.setSelectedIndex(0);
            this.panelKeyTable.enableAddEntryButton(true);
        } else {
            for (Component cc : this.panelIcons.getComponents()) {
                cc.setEnabled(false);
            }
        }
        if (!this.app.isUserAdministrator()) {
            this.btnTextTemplateAddGroup.setEnabled(false);
            this.btnTextTemplateDelete.setEnabled(false);
            this.btnTextTemplateEditSave.setEnabled(false);
        }
        this.chkCache.setSelected(this.project.getCache().isEnabled());
        this.populateServerPanels();
        this.panelLocationListSettings.populate(ph0);
        this.populateReportLayoutList();
        this.alreadyPopulated = true;
    }

    @Override
    public void populateReportLayoutList() {
        this.panelReportLayout.populate();
    }

    private void populateServerPanels() {
        if (this.panelServerSetup != null) {
            this.panelServerSetup.populate();
        }
    }

    private void populateObservationDisplayLists(boolean readFromSettings) {
        if (readFromSettings) {
            this.observationListDisplay.clear();
            this.observationListDontDisplay.clear();
            ArrayList tableAttributes = this.settings.getObservationTableAttributes();
            ArrayList allAttributes = new ArrayList();
            allAttributes.addAll(this.settings.getLocationAttributes());
            allAttributes.addAll(this.settings.getObservationAttributes());
            for (ThemisAttribute ta : tableAttributes) {
                if (ta == null || ta.getSqlCode() == null) continue;
                this.observationListDisplay.add(ta);
            }
            for (ThemisAttribute ta : allAttributes) {
                if (ta == null || ta.getSqlCode() == null || tableAttributes.contains(ta) || !ta.isObsListAllowed() || !ta.isUsed() && !ta.isVirtual()) continue;
                this.observationListDontDisplay.add(ta);
            }
        }
        ((DefaultListModel)this.modelObservationDisplay.getModel()).clear();
        ((DefaultListModel)this.lstObservationAttributes.getModel()).clear();
        for (ThemisAttribute att : this.observationListDisplay) {
            ((DefaultListModel)this.modelObservationDisplay.getModel()).addElement(att.getTargetLetter(true).toUpperCase() + att.getLabel());
        }
        for (ThemisAttribute att : this.observationListDontDisplay) {
            ((DefaultListModel)this.lstObservationAttributes.getModel()).addElement(att.getTargetLetter(true).toUpperCase() + att.getLabel());
        }
    }

    private void populateAttributeSettings() {
        this.populateLocationAttributeSettings();
        this.populateObservationAttributeSettings();
    }

    private void populateLocationAttributeSettings() {
        ArrayList locationAttributes = this.app.getSettings().getLocationAttributes();
        this.fldLocationAttributeCodes1.removeAllItems();
        this.panelLocationAttributes1.removeAll();
        ThemisAttributePanel firstPanel = null;
        ThemisAttributePanel lastPanel = null;
        for (ThemisAttribute ta : locationAttributes) {
            if (ta.isVirtual()) continue;
            if (!ta.isUsed()) {
                this.fldLocationAttributeCodes1.addItem(ta);
                continue;
            }
            if (ta.isUserdefined()) continue;
            lastPanel = new ThemisAttributePanel(ta, this);
            this.panelLocationAttributes1.add(lastPanel);
        }
        for (ThemisAttribute ta : this.app.getSettings().getLocationAttributesUsed()) {
            if (!ta.isUserdefined()) continue;
            lastPanel = new ThemisAttributePanel(ta, this);
            if (firstPanel == null) {
                firstPanel = lastPanel;
            }
            this.panelLocationAttributes1.add(lastPanel);
        }
        if (firstPanel != null) {
            firstPanel.setAsFirstPanel();
        }
        if (lastPanel != null) {
            lastPanel.setAsLastPanel();
        }
        this.panelLocationAttributes1.repaint();
        this.panelLocationAttributes1.revalidate();
    }

    private void populateObservationAttributeSettings() {
        ArrayList observationAttributes = this.app.getSettings().getObservationAttributes();
        this.fldObservationAttributeCodes1.removeAllItems();
        this.panelObservationAttributes1.removeAll();
        ThemisAttributePanel firstPanel = null;
        ThemisAttributePanel lastPanel = null;
        for (ThemisAttribute ta : observationAttributes) {
            if (ta.isVirtual()) continue;
            if (!ta.isUsed()) {
                this.fldObservationAttributeCodes1.addItem(ta);
                continue;
            }
            if (ta.isUserdefined()) continue;
            lastPanel = new ThemisAttributePanel(ta, this);
            this.panelObservationAttributes1.add(lastPanel);
        }
        for (ThemisAttribute ta : this.app.getSettings().getObservationAttributesUsed()) {
            if (!ta.isUserdefined()) continue;
            lastPanel = new ThemisAttributePanel(ta, this);
            if (firstPanel == null) {
                firstPanel = lastPanel;
            }
            this.panelObservationAttributes1.add(lastPanel);
        }
        if (firstPanel != null) {
            firstPanel.setAsFirstPanel();
        }
        if (lastPanel != null) {
            lastPanel.setAsLastPanel();
        }
        this.panelObservationAttributes1.repaint();
        this.panelObservationAttributes1.revalidate();
    }

    @Override
    public void apply() {
        Properties propsApp = new Properties();
        Properties propsProject = new Properties();
        if (this.panelServerSetup != null) {
            this.panelServerSetup.apply();
        }
        this.panelLocationListSettings.apply();
        this.settings.setLocNumberIndividual(this.chkLocNumberIndividual.isSelected());
        propsProject.setProperty("attribute.locnumber.scheme", Integer.toString(this.fldLocNumberScheme.getSelectedIndex()));
        String locSort = "acc2Plan";
        switch (this.fldLocSortOrder.getSelectedIndex()) {
            case 1: {
                locSort = "acc2Creation";
                break;
            }
            case 2: {
                locSort = "acc2Number";
            }
        }
        propsProject.setProperty("attribute.locnumber.consecutive", locSort);
        this.settings.setElementCache(this.chkCache.isSelected());
        this.project.getCache().setEnabled(this.chkCache.isSelected());
        String permission = this.fldPermissionTemplate.getText();
        if ("".equals(permission)) {
            permission = "*";
        }
        if (!"*".equals(permission)) {
            String[] usernames = permission.split(",");
            boolean foundSelf = false;
            String self = this.project.getUser().getUsername();
            for (String username : usernames) {
                if (!username.trim().equals(self)) continue;
                foundSelf = true;
                break;
            }
            if (!foundSelf) {
                permission = permission + "," + self;
            }
        }
        this.settings.setPermissionEditTemplates(permission);
        this.settings.setPermissionEditAttributes(permission);
        this.settings.setImageForObservation(this.chkAddFotoObs.isSelected());
        this.settings.setImageForLocation(this.chkAddFotoLoc.isSelected());
        this.settings.setImageKeepOriginal(this.chkImageKeepOriginal.isSelected());
        this.settings.setImageUploadQuality(Math.min(0.1f * (float)this.sliderImageQuality.getValue(), 1.0f));
        this.settings.setImageUploadSize(ThemisUtil.validateInteger((String)this.fldImageSize.getText(), (int)2000, (boolean)true, (String)"Maximale Gr\u00f6\u00dfe der Fotos", (boolean)true));
        this.settings.setImagePlansnippetSize(ThemisUtil.validateInteger((String)this.fldPlanSnippetSizeMM.getText(), (int)30, (boolean)true, (String)"Gr\u00f6\u00dfe des Planausschnitts", (boolean)true));
        this.settings.setShowBuildingsInLocList(this.chkBuildingInLocList.isSelected());
        ThemisAttribute taAtt = (ThemisAttribute)this.fldPlanLabel.getSelectedItem();
        this.app.getSettings().setDisplayLabelAttribute(taAtt.getId());
        this.app.getSettings().setDisplayLabelNumber(this.chkPlanLabelNummer.isSelected());
        propsProject.setProperty("project.plan.label-number", this.chkPlanLabelNummer.isSelected() ? "yes" : "no");
        this.settings.setDisplayMoveIconWithLabel(this.chkPlanMoveIconWithLabel.isSelected());
        if (this.chkPlanMoveIconWithLabel.isSelected()) {
            this.settings.setDisplayLabelOffset(new Point(10.0 * ThemisUtil.validateDouble((String)this.fldLabelOffsetX.getText(), (double)0.0, (boolean)false, (String)"Verschiebung der Icons in X-Richtung", (boolean)true), 10.0 * ThemisUtil.validateDouble((String)this.fldLabelOffsetY.getText(), (double)0.0, (boolean)false, (String)"Verschiebung der Icons in Y-Richtung", (boolean)true)));
        }
        this.settings.setDisplayIconSize((int)(10.0 * ThemisUtil.validateDouble((String)this.fldIconSize.getText(), (double)3.0, (boolean)true, (String)"Gr\u00f6\u00dfe der Icons", (boolean)true)));
        this.settings.setDisplayPointSize((int)(10.0 * ThemisUtil.validateDouble((String)this.fldPointSize.getText(), (double)3.0, (boolean)true, (String)"Gr\u00f6\u00dfe der Punkte", (boolean)true)));
        this.settings.setDisplayLineSize((int)(10.0 * ThemisUtil.validateDouble((String)this.fldLineSize.getText(), (double)3.0, (boolean)true, (String)"Linienst\u00e4rke", (boolean)true)));
        this.settings.setDisplayFontSize((int)(10.0 * ThemisUtil.validateDouble((String)this.fldFontSize.getText(), (double)3.0, (boolean)true, (String)"Schriftgr\u00f6\u00dfe", (boolean)true)));
        this.settings.setDisplayColorPoint(ThemisUtil.getStringFromColor((Color)this.colorPoint.getBackground()));
        this.settings.setDisplayColorPointSelected(ThemisUtil.getStringFromColor((Color)this.colorPointSelected.getBackground()));
        ColorOption co = (ColorOption)this.fldDisplayColorSelection.getSelectedItem();
        co.setColor(Integer.valueOf(this.colorLabelBackground.getBackground().getRGB()));
        co.setForegroundColor(Integer.valueOf(this.colorLabelBackground.getForeground().getRGB()));
        this.settings.setDisplayColorOption(co);
        int currentOption = this.settings.getDisplayHideDoneTask();
        this.settings.setDisplayHideDoneTask(this.fldDisplayHideDoneTask.getSelectedIndex());
        if (this.fldDisplayHideDoneTask.getSelectedIndex() != currentOption) {
            this.app.getFilter().resetSearchResult();
        }
        this.settings.setTerm(ThemisSettings.Term.TypMangel, this.fldTextObservationtypeMangel.getText());
        this.settings.setTerm(ThemisSettings.Term.TypAufgabe, this.fldTextObservationtypeAufgabe.getText());
        this.settings.setTerm(ThemisSettings.Term.TypInformation, this.fldTextObservationtypeInfo.getText());
        this.settings.setTerm(ThemisSettings.Term.TypKontrolle, this.fldTextObservationtypeKontrolle.getText());
        this.project.getKeytable("obstype").addOrReplaceTerm(1L, "de", this.fldTextObservationtypeMangel.getText());
        this.project.getKeytable("obstype").addOrReplaceTerm(2L, "de", this.fldTextObservationtypeKontrolle.getText());
        this.project.getKeytable("obstype").addOrReplaceTerm(3L, "de", this.fldTextObservationtypeInfo.getText());
        this.project.getKeytable("obstype").addOrReplaceTerm(4L, "de", this.fldTextObservationtypeAufgabe.getText());
        this.project.getKeytable("obstype").save();
        this.settings.setTerm(ThemisSettings.Term.StatusErledigt, this.fldTextStatusErledigt.getText());
        this.settings.setTerm(ThemisSettings.Term.StatusOffen, this.fldTextStatusOffen.getText());
        this.settings.setTerm(ThemisSettings.Term.TextNoContent, this.fldTextNoContent.getText());
        this.settings.setTerm(ThemisSettings.Term.TextNoEvent, this.fldTextNoEvent.getText());
        this.settings.setTerm(ThemisSettings.Term.TextNoImage, this.fldTextNoImage.getText());
        this.settings.setObservationTableAttributes(this.observationListDisplay);
        this.settings.setDoFilterSelectedLocation(this.chkLocationAsFilter.isSelected());
        this.app.setConfiguration(propsApp);
        if (this.project.isOpen()) {
            this.project.setProjectProperties(propsProject);
        }
        this.app.setConfiguration(propsProject);
        this.app.setSysemLanguage();
        this.app.getSettings().setDoAutoGenerateEvent(this.chkEventCreate.isSelected());
        this.settings.setTerm(ThemisSettings.Term.NewEventTitle, this.fldTextNewEvent.getText());
        this.app.getSettings().setDoCreateNewObservationWithLocation(this.chkCreateObservation.isSelected());
        String result = this.settings.save();
        if (result != null) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("warning.cannot-save-settings", new String[]{this.app.getSettings().getSettingsFile().getParent(), result});
        }
        this.project.createActionLog("projectsetting_apply", 0L, "");
    }

    private void saveTextTemplates() {
        File f = new ThemisFileDialog(this.app.getProject().getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.SAVE, this.app.getSettings().getTemplateFile(), null, new FileNameExtensionFilter("Textbausteine", "xlsx"), null, false).getSelectedFile();
        if (f != null) {
            File fImport;
            String fn = f.getName();
            if (!fn.toLowerCase().endsWith(".xlsx")) {
                fn = fn.toLowerCase().endsWith(".xls") ? fn + "x" : fn + ".xlsx";
            }
            if ((fImport = new File(f.getParentFile(), fn)).isDirectory()) {
                Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/config/Bundle").getString("MESSAGE_TEMPLATE_CANNOT_BE_SAVED"));
                return;
            }
            if (fImport.isFile()) {
                Object[] options = new String[]{ResourceBundle.getBundle("at/grid/themis/application/config/Bundle").getString("OPTION_YES"), this.bundle.getString("OPTION_NO")};
                int option = Dialogs.getInstance().showInfoOptionDialog(ResourceBundle.getBundle("at/grid/themis/application/config/Bundle").getString("MESSAGE_OVERWRITE_FILE"), this.bundle.getString("MESSAGE_TITLE_FILE_EXISTS"), options);
                if (option == 1) {
                    return;
                }
            }
            this.app.getSettings().setTemplateFile(fImport);
            ThemisTaskWithDialog.createTaskWithCancel(this.bundle.getString("MESSAGE_SAVING_TEMPLATE"), ph -> {
                try {
                    TemplateManager m = this.project.getTemplateManger();
                    this.app.getSettings().setTemplateUseContacts(false);
                    this.app.getSettings().setTemplateUseDocuments(false);
                    this.app.getSettings().setTemplateUseSettings(false);
                    this.app.getSettings().setTemplateUseIcons(true);
                    this.app.getSettings().setTemplateUseLists(true);
                    this.app.getSettings().setTemplateUseTexts(true);
                    boolean success = m.saveTemplates(fImport);
                    this.setCursor(Cursor.getDefaultCursor());
                    if (success) {
                        THEMIS.showFileResultDialog(fImport);
                    } else {
                        Dialogs.getInstance().showErrorDialog(this.bundle.getString("MESSAGE_CANNOT_CREATE_FILE"));
                    }
                }
                catch (Exception e) {
                    this.project.getLogger().severe("Error while creating the template file: " + e.getMessage());
                }
            });
        }
    }

    @Override
    public void removeAttribute(ThemisAttributePanel p) {
        p.ta.setUsed(false);
        this.observationListDontDisplay.remove(p.ta);
        switch (p.ta.getTarget()) {
            case LOCATION: {
                this.populateLocationAttributeSettings();
                this.updatePlanLabelCombo();
                break;
            }
            case OBSERVATION: {
                this.populateObservationAttributeSettings();
            }
        }
    }

    @Override
    public void moveAttribute(ThemisAttributePanel p, int dir) {
        switch (p.ta.getTarget()) {
            case LOCATION: {
                this.app.getSettings().moveLocationAttribute(p.ta, dir);
                this.populateLocationAttributeSettings();
                break;
            }
            case OBSERVATION: {
                this.app.getSettings().moveObservationAttribute(p.ta, dir);
                this.populateObservationAttributeSettings();
            }
        }
    }

    private void updatePlanLabelCombo() {
        String sel = this.app.getSettings().getDisplayLabelAttribute();
        ThemisAttribute selTa = this.app.getSettings().getLocationAttribute(sel);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.fldPlanLabel.getModel();
        model.removeAllElements();
        ThemisNoneAttribute taNone = new ThemisNoneAttribute(this.app, ThemisAttribute.Target.NONE, null, null, null, "-", ThemisAttribute.Edit.DIALOG_ONLY, false, 0);
        model.addElement(taNone);
        ArrayList nonLableAttributes = new ArrayList();
        ArrayList<ThemisAttribute.Type> attTypes = new ArrayList<ThemisAttribute.Type>();
        attTypes.add(ThemisAttribute.Type.DATE);
        attTypes.add(ThemisAttribute.Type.LIST);
        attTypes.add(ThemisAttribute.Type.NUMBER);
        attTypes.add(ThemisAttribute.Type.TEXT);
        for (ThemisAttribute ta : this.app.getSettings().getLocationAttributes()) {
            if (!ta.isUsed() || !attTypes.contains(ta.getTypeId()) || !this.attributeAllowedOnLabel(ta)) continue;
            model.addElement(ta);
        }
        int idx = model.getIndexOf(selTa);
        if (idx < 0) {
            idx = 0;
        }
        this.fldPlanLabel.setSelectedIndex(idx);
        this.chkPlanLabelNummer.setSelected(this.app.getSettings().getDisplayLabelNumber());
        this.chkPlanMoveIconWithLabel.setSelected(this.settings.getDisplayMoveIconWithLabel());
    }

    private boolean attributeAllowedOnLabel(ThemisAttribute att) {
        switch (att.getId()) {
            case "prefixsuffix": 
            case "suffix": 
            case "number": {
                return false;
            }
        }
        return true;
    }

    private void updateIconList(long selId) {
        CmsBasicElement sel = null;
        String iconfilter = this.fldIconfilter.getText().trim();
        DefaultListModel modelIcon = (DefaultListModel)this.lstIcon.getModel();
        modelIcon.clear();
        ArrayList icons = this.project.getIcons();
        for (CmsBasicElement icon : icons) {
            if (!"".equals(iconfilter) && !icon.getTitle().toLowerCase().contains(iconfilter)) continue;
            modelIcon.addElement(icon);
            if (icon.getId() != selId) continue;
            sel = icon;
        }
        this.lblIconCount.setText("(" + Integer.toString(icons.size()) + ")");
        this.lstIcon.setSelectedValue(sel, true);
        if (modelIcon.isEmpty() || this.lstIcon.getSelectedIndex() == -1) {
            this.btnAddIcon.setEnabled(true);
            this.btnRemoveIcon.setEnabled(false);
        } else if (this.lstIcon.getSelectedIndex() != -1) {
            this.btnAddIcon.setEnabled(true);
            this.btnRemoveIcon.setEnabled(true);
        }
    }

    private void showIconElement() {
        if (this.currentIcon != null) {
            File iconfile = this.currentIcon.getUploadAttribute("file").getFirstUploadItemFile();
            if (iconfile != null) {
                ViewHelper.updateImage(this.lblIconDisplay, iconfile, 36, this.project);
            } else {
                this.lblIconDisplay.setIcon(null);
                this.lblIconDisplay.setText("<>");
            }
            this.btnRemoveIcon.setEnabled(true);
        } else {
            this.btnRemoveIcon.setEnabled(false);
            this.lblIconDisplay.setIcon(null);
            this.lblIconDisplay.setText("<>");
        }
    }

    private void removeSelectedIcons() {
        List<CmsBasicElement> sels = this.lstIcon.getSelectedValuesList();
        if (sels.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (CmsBasicElement ele : sels) {
                ids.add(ele.getId());
            }
            DataRecord rec = this.project.getDatastorage().executeQuery("SELECT count(elementfrom) AS count FROM tdtarelation WHERE elementto IN " + Util.toSqlString(ids) + " AND relationcode IN ('locationicon','locationtemplateicon') ", true).firstRow();
            int occurence = rec.getInt("count");
            String icon = "Das Icon wird f\u00fcr ";
            if (sels.size() > 1) {
                icon = MessageFormat.format(this.bundle.getString("SettingsPanel.iconUsed1.text"), icon);
            }
            String occurenceInfo = "";
            if (occurence == 1) {
                occurenceInfo = MessageFormat.format(this.bundle.getString("SettingsPanel.iconUsed2.text"), icon, occurence);
            } else if (occurence > 1) {
                occurenceInfo = MessageFormat.format(this.bundle.getString("SettingsPanel.iconUsed3.text"), icon, occurence);
            }
            boolean remove = false;
            remove = sels.size() == 1 ? Dialogs.getInstance().showConfirmDialog(this.bundle.getString("ICON_DELETE_QUESTION"), this.bundle.getString("ICON_DELETE")) : Dialogs.getInstance().showConfirmDialog(this.bundle.getString("ICONS_DELETE_QUESTION"), this.bundle.getString("ICONS_DELETE"));
            if (remove) {
                this.project.getDatastorage().executeUpdate("UPDATE tdtaelelocation SET iconfile=null WHERE idelement IN (SELECT elementfrom AS id FROM tdtarelation WHERE elementto IN " + Util.toSqlString(ids) + " AND relationcode IN ('locationicon')) ", true);
                this.project.getDatastorage().executeUpdate("UPDATE tdtaelelocationtemplate SET iconfile=null WHERE idelement IN (SELECT elementfrom AS id FROM tdtarelation WHERE elementto IN " + Util.toSqlString(ids) + " AND relationcode IN (locationtemplateicon')) ", true);
                for (CmsBasicElement o : sels) {
                    CmsBasicElement e;
                    if (!(o instanceof CmsBasicElement) || (e = o) == null) continue;
                    CmsElement ele = this.project.loadElement(e.getId(), this.project.getUser());
                    ele.remove();
                }
                this.updateIconList(-1L);
            }
        }
    }

    private void loadIcons(List<File> files) {
        File[] filelist;
        if (files.isEmpty()) {
            return;
        }
        if (files.size() == 1 && files.get(0).isDirectory() && files.get(0) != null && (filelist = files.get(0).listFiles()) != null) {
            files = Arrays.asList(new File[0]);
        }
        DefaultListModel m = (DefaultListModel)this.lstIcon.getModel();
        ArrayList<String> iconFileNames = new ArrayList<String>();
        HashMap<String, Long> iconNameId = new HashMap<String, Long>();
        for (int ii = 0; ii < m.size(); ++ii) {
            String fn = ((CmsBasicElement)m.get(ii)).getAttribute("file").toLowerCase();
            String fn0 = fn.substring(fn.indexOf("_") + 1);
            iconNameId.put(fn0, ((CmsBasicElement)m.get(ii)).getId());
            iconFileNames.add(fn0);
        }
        long selId = -1L;
        int updateIcons = -1;
        for (File f : files) {
            CmsIcon tempIcon;
            if (!f.getName().toLowerCase().endsWith(".jpg") && !f.getName().toLowerCase().endsWith(".png") && !f.getName().toLowerCase().endsWith(".gif") && !f.getName().toLowerCase().endsWith(".tif")) continue;
            if (iconFileNames.contains(f.getName().toLowerCase())) {
                if (updateIcons < 0) {
                    int n = updateIcons = Dialogs.getInstance().showConfirmDialog("dialog.icon-update.text", "dialog.icon-update.title") ? 1 : 0;
                }
                if (updateIcons > 0) {
                    tempIcon = (CmsIcon)this.project.loadElement(((Long)iconNameId.get(f.getName().toLowerCase())).longValue(), this.project.getUser());
                    tempIcon.getUploadAttribute("file").clear();
                    tempIcon.getUploadAttribute("file").addUpload(f);
                    tempIcon.getUploadAttribute("file").removeDeletedItems();
                    this.project.getLogger().info("Icon with filename '" + f.getName() + "' replaced");
                    tempIcon.save();
                    continue;
                }
                this.project.getLogger().info("Icon with filename '" + f.getName() + "' already exists... skipped");
                continue;
            }
            tempIcon = (CmsIcon)this.project.createElement("icon");
            tempIcon.setAttributeValue("title", FilenameUtils.removeExtension((String)f.getName()));
            tempIcon.getUploadAttribute("file").addUpload(f);
            this.project.getLogger().info("Icon with filename '" + f.getName() + "' created");
            tempIcon.save();
            selId = tempIcon.getId();
        }
        this.app.setIconImportFolder(files.get(0).getParentFile());
        this.updateIconList(selId);
    }

    private void removeIconDuplicates() {
        ArrayList icons = this.project.getIcons();
        HashMap<String, ArrayList<Long>> map = new HashMap<String, ArrayList<Long>>();
        int countremoved = 0;
        for (CmsBasicElement icon : icons) {
            ArrayList uploadItems = this.project.getDatastorage().getUploadItems(icon.getId(), "file");
            if (uploadItems.size() == 0) {
                CmsElement.remove((CmsApplication)this.project, (long)icon.getId(), (CmsUser)this.project.getUser());
                ++countremoved;
                continue;
            }
            if (!((UploadItem)uploadItems.get(0)).getFile().isFile()) {
                CmsElement.remove((CmsApplication)this.project, (long)icon.getId(), (CmsUser)this.project.getUser());
                ++countremoved;
                continue;
            }
            String fn = icon.getTitle();
            ArrayList<Long> ids = (ArrayList<Long>)map.get(fn);
            if (ids == null) {
                ids = new ArrayList<Long>();
                ids.add(icon.getId());
            } else {
                ids.add(icon.getId());
            }
            map.put(fn, ids);
        }
        for (String fn : map.keySet()) {
            ArrayList ids = (ArrayList)map.get(fn);
            long id = (Long)ids.get(0);
            for (int ii = 1; ii < ids.size(); ++ii) {
                this.project.getDatastorage().executeUpdate("UPDATE tdtaRelation SET elementFrom = " + id + " WHERE elementFrom = " + ids.get(ii), true);
                this.project.getDatastorage().executeUpdate("UPDATE tdtaRelation SET elementTo = " + id + " WHERE elementTo = " + ids.get(ii), true);
                CmsElement.remove((CmsApplication)this.project, (long)((Long)ids.get(ii)), (CmsUser)this.project.getUser());
            }
        }
        this.updateIconList(-1L);
        if (countremoved > 0) {
            this.app.getDialog().showInfoDialog("message.icons-deleted-after-cleanup", (Object[])new String[]{Integer.toString(countremoved)});
        }
    }

    private void addKeyTableElement(String keytable, String label) {
        Keytable tbl = this.project.getKeytable(keytable);
        tbl.addName("de", label);
        this.modelKeytable.addElement(tbl);
    }

    private void updateKeytableList() {
        this.modelKeytable.clear();
        for (ThemisAttribute ta : this.settings.getObservationAttributesUsed()) {
            if (ta.getTypeId() != ThemisAttribute.Type.LIST || ta.getId().equals("documents")) continue;
            this.addKeyTableElement(ta.getCmsCode(), "B." + ta.getLabel());
        }
        for (ThemisAttribute ta : this.settings.getLocationAttributesUsed()) {
            if (ta.getTypeId() != ThemisAttribute.Type.LIST || ta.getId().equals("documents")) continue;
            this.addKeyTableElement(ta.getCmsCode(), "G." + ta.getLabel());
        }
        this.addKeyTableElement("documenttype", this.bundle.getString("LIST_DOKUMENTENTYP"));
        this.lstKeytable.setModel(this.modelKeytable);
        if (!this.modelKeytable.isEmpty()) {
            this.lstKeytable.setSelectedIndex(0);
        }
    }

    private void showKeytable() {
        Keytable keytable = (Keytable)this.lstKeytable.getSelectedValue();
        if (this.project != null && this.project.isOpen()) {
            this.panelKeytableEdit.removeAll();
            if (keytable != null) {
                this.panelKeyTable = new KeytablePanel(keytable, "de");
                this.panelKeytableEdit.add((Component)this.panelKeyTable, "North");
            }
            this.panelKeytableEdit.revalidate();
            this.panelKeytableEdit.repaint();
        }
    }

    private void updateDisplay() {
        this.initialisingColorDisplay = true;
        ColorOption co = (ColorOption)this.fldDisplayColorSelection.getSelectedItem();
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.fldDisplayColorSelection.getModel();
        m.removeAllElements();
        m.addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.none")));
        m.addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.static"), Integer.valueOf(this.colorLabelBackground.getBackground().getRGB())));
        if (this.app.getSettings().getObservationAttribute("done").isUsed()) {
            m.addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.status"), this.app.getSettings().getObservationAttribute("done")));
        }
        if (this.app.getSettings().getObservationAttribute("duedate").isUsed()) {
            m.addElement(new ColorOption(this.app.getProject().getResourceText("ColorOption.urgency"), this.app.getSettings().getObservationAttribute("duedate")));
        }
        ThemisSettings settings = this.app.getSettings();
        for (ThemisAttribute ta : settings.getObservationAttributesUsed()) {
            if (ta.getTypeId() != ThemisAttribute.Type.LIST || ta.getId().equals("documents")) continue;
            m.addElement(new ColorOption("B." + ta.getLabel(), ta));
        }
        for (ThemisAttribute ta : settings.getLocationAttributesUsed()) {
            if (ta.getTypeId() != ThemisAttribute.Type.LIST || ta.getId().equals("documents")) continue;
            m.addElement(new ColorOption("G." + ta.getLabel(), ta));
        }
        if (co == null) {
            this.fldDisplayColorSelection.setSelectedIndex(0);
        } else {
            for (int ii = 0; ii < m.getSize(); ++ii) {
                if (co.getMethod() != ((ColorOption)m.getElementAt(ii)).getMethod() || co.getMethod() == ColorOption.Method.ATTRIBUTE && co.getAttribute() != ((ColorOption)m.getElementAt(ii)).getAttribute()) continue;
                this.fldDisplayColorSelection.setSelectedIndex(ii);
                break;
            }
        }
        this.initialisingColorDisplay = false;
    }

    private void loadDropDownList(DefaultComboBoxModel<String> model, String records) {
        String[] recordArray;
        for (String record : recordArray = records.split(",")) {
            model.addElement(record);
        }
    }

    public CmsElementSummary getSelectedTextTemplate() {
        Object sel;
        DefaultMutableTreeNode node = null;
        TreePath path = this.templateTree.getSelectionPath();
        if (path != null) {
            node = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        if (node != null && (sel = node.getUserObject()) != null && sel instanceof CmsElementSummary) {
            return (CmsElementSummary)sel;
        }
        return null;
    }

    public void removeTemplateTreeElement(CmsElementSummary ele) {
        Enumeration<TreeNode> e = this.templateTreeRoot.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object o = node.getUserObject();
            if (o == null || !(o instanceof CmsElementSummary) || ((CmsElementSummary)o).getId() != ele.getId()) continue;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            node.removeAllChildren();
            node.removeFromParent();
            this.templateTreeModel.reload();
            this.templateTree.expandPath(new TreePath(parent.getPath()));
            return;
        }
    }

    public void insertTemplateTreeElement(CmsElementSummary ele) {
        CmsElementSummary sel = this.getSelectedTextTemplate();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(ele);
        if (sel == null) {
            this.templateTreeModel.insertNodeInto(newNode, this.templateTreeRoot, this.templateTreeRoot.getChildCount());
        } else {
            Enumeration<TreeNode> e = this.templateTreeRoot.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                Object o = node.getUserObject();
                if (o == null || !(o instanceof CmsElementSummary) || ((CmsElementSummary)o).getId() != sel.getId()) continue;
                this.templateTreeModel.insertNodeInto(newNode, node, node.getChildCount());
                break;
            }
        }
        TreePath path = new TreePath(newNode.getPath());
        this.templateTree.expandPath(path);
        this.templateTree.setSelectionPath(path);
    }

    public void updateTemplateTreeElement(CmsElementSummary ele) {
        Enumeration<TreeNode> e = this.templateTreeRoot.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object o = node.getUserObject();
            if (o == null || !(o instanceof CmsElementSummary) || ((CmsElementSummary)o).getId() != ele.getId()) continue;
            ((CmsElementSummary)o).update(ele);
            this.templateTreeModel.nodeChanged(node);
            return;
        }
    }

    public void updateTemplateTree() {
        this.updateTemplateTree(-1L);
    }

    public void updateTemplateTree(final long selId) {
        this.templateTreeScroll.setViewportView(new JLabel("... wird geladen"));
        SwingWorker<DefaultTreeModel, String> worker = new SwingWorker<DefaultTreeModel, String>(){

            @Override
            protected DefaultTreeModel doInBackground() throws Exception {
                ProjectSettingsPanel.this.templateTreeRoot.removeAllChildren();
                ProjectSettingsPanel.this.templateTreeRoot.setUserObject("Textvorlagen");
                DefaultMutableTreeNode selNode = null;
                DefaultMutableTreeNode selNodeSub = null;
                selNodeSub = ProjectSettingsPanel.this.updateTemplateTreeObservation(ProjectSettingsPanel.this.templateTreeRoot, null, selId);
                if (selNodeSub != null) {
                    selNode = selNodeSub;
                }
                if ((selNodeSub = ProjectSettingsPanel.this.updateTemplateTreeLocation(ProjectSettingsPanel.this.templateTreeRoot, null, selId)) != null) {
                    selNode = selNodeSub;
                }
                TemplateManager m = ProjectSettingsPanel.this.project.getTemplateManger();
                for (DataRecord rec : m.getLocationGroups()) {
                    CmsElementSummary grp = new CmsElementSummary((CmsApplication)ProjectSettingsPanel.this.project, rec, ProjectSettingsPanel.this.project.getUser());
                    DefaultMutableTreeNode grpNode = new DefaultMutableTreeNode(grp, true);
                    ProjectSettingsPanel.this.templateTreeRoot.add(grpNode);
                    if (grp.getId() == selId) {
                        selNode = grpNode;
                    }
                    if ((selNodeSub = ProjectSettingsPanel.this.updateTemplateTreeObservation(grpNode, grp, selId)) != null) {
                        selNode = selNodeSub;
                    }
                    if ((selNodeSub = ProjectSettingsPanel.this.updateTemplateTreeLocation(grpNode, grp, selId)) != null) {
                        selNode = selNodeSub;
                    }
                    for (DataRecord rec2 : m.getLocationGroups(grp.getId())) {
                        CmsElementSummary grp2 = new CmsElementSummary((CmsApplication)ProjectSettingsPanel.this.project, rec2, ProjectSettingsPanel.this.project.getUser());
                        DefaultMutableTreeNode grpNode2 = new DefaultMutableTreeNode(grp2, true);
                        grpNode.add(grpNode2);
                        if (grp2.getId() == selId) {
                            selNode = grpNode2;
                        }
                        if ((selNodeSub = ProjectSettingsPanel.this.updateTemplateTreeObservation(grpNode2, grp2, selId)) != null) {
                            selNode = selNodeSub;
                        }
                        if ((selNodeSub = ProjectSettingsPanel.this.updateTemplateTreeLocation(grpNode2, grp2, selId)) != null) {
                            selNode = selNodeSub;
                        }
                        for (DataRecord rec3 : m.getLocationGroups(grp2.getId())) {
                            CmsElementSummary grp3 = new CmsElementSummary((CmsApplication)ProjectSettingsPanel.this.project, rec3, ProjectSettingsPanel.this.project.getUser());
                            DefaultMutableTreeNode grpNode3 = new DefaultMutableTreeNode(grp3, true);
                            grpNode2.add(grpNode3);
                            if (grp3.getId() == selId) {
                                selNode = grpNode3;
                            }
                            if ((selNodeSub = ProjectSettingsPanel.this.updateTemplateTreeObservation(grpNode3, grp3, selId)) != null) {
                                selNode = selNodeSub;
                            }
                            if ((selNodeSub = ProjectSettingsPanel.this.updateTemplateTreeLocation(grpNode3, grp3, selId)) == null) continue;
                            selNode = selNodeSub;
                        }
                    }
                }
                ProjectSettingsPanel.this.templateTreeModel.reload();
                if (selNode != null) {
                    TreePath path = new TreePath(ProjectSettingsPanel.this.templateTreeModel.getPathToRoot(selNode));
                    ProjectSettingsPanel.this.templateTree.expandPath(path);
                    ProjectSettingsPanel.this.templateTree.setSelectionPath(path);
                }
                return ProjectSettingsPanel.this.templateTreeModel;
            }

            @Override
            protected void done() {
                ProjectSettingsPanel.this.templateTreeScroll.setViewportView(ProjectSettingsPanel.this.templateTree);
            }
        };
        worker.execute();
    }

    private DefaultMutableTreeNode updateTemplateTreeLocation(DefaultMutableTreeNode basenode, CmsElementSummary parent, long selId) {
        DefaultMutableTreeNode selNode = null;
        DefaultMutableTreeNode selNodeSub = null;
        CmsSqlSearch s2 = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s2.setElementtypes("locationtemplate");
        s2.addSelectMeta();
        s2.addSelectAttribute(this.project.getDefaultElement("locationtemplate").getAttribute("itemsort"));
        s2.setSort("ele.itemsort,el.title");
        if (parent != null && parent.getId() >= 0L) {
            s2.addWhereRelationId((CmsAttribute)this.project.getDefaultElement("locationtemplate").getRelationAttribute("locationgroup"), "=", Long.toString(parent.getId()));
        } else {
            s2.addWhereRelationNone((CmsAttribute)this.project.getDefaultElement("locationtemplate").getRelationAttribute("locationgroup"));
            basenode = this.templateTreeRoot;
        }
        SearchResult result2 = s2.search();
        for (CmsElementSummary loc : result2.getResultAsElementSummary()) {
            DefaultMutableTreeNode locNode = new DefaultMutableTreeNode(loc, true);
            basenode.add(locNode);
            if (loc.getId() == selId) {
                selNode = locNode;
            }
            if ((selNodeSub = this.updateTemplateTreeObservation(locNode, loc, selId)) == null) continue;
            selNode = selNodeSub;
        }
        return selNode;
    }

    private DefaultMutableTreeNode updateTemplateTreeObservation(DefaultMutableTreeNode basenode, CmsElementSummary parent, long selId) {
        DefaultMutableTreeNode selNode = null;
        CmsSqlSearch s2 = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s2.setElementtypes("observationtemplate");
        s2.addSelectMeta();
        s2.addSelectAttribute(this.project.getDefaultElement("observationtemplate").getAttribute("itemsort"));
        s2.setSort("ele.itemsort,el.title");
        if (parent != null && parent.getId() >= 0L) {
            if ("locationgroup".equals(parent.getElementtype())) {
                s2.addWhereRelationId((CmsAttribute)this.project.getDefaultElement("observationtemplate").getRelationAttribute("locationgroup"), "=", Long.toString(parent.getId()));
            } else {
                s2.addWhereRelationId((CmsAttribute)this.project.getDefaultElement("observationtemplate").getRelationAttribute("location"), "=", Long.toString(parent.getId()));
            }
        } else {
            s2.addWhereRelationNone((CmsAttribute)this.project.getDefaultElement("observationtemplate").getRelationAttribute("locationgroup"));
            s2.addWhereRelationNone((CmsAttribute)this.project.getDefaultElement("observationtemplate").getRelationAttribute("location"));
            basenode = this.templateTreeRoot;
        }
        SearchResult result2 = s2.search();
        for (CmsElementSummary obs : result2.getResultAsElementSummary()) {
            DefaultMutableTreeNode obsNode = new DefaultMutableTreeNode(obs, true);
            basenode.add(obsNode);
            if (obs.getId() == selId) {
                selNode = obsNode;
            }
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "measuretemplate");
            s.addSelectMeta();
            s.addSelectAllAttributes("measuretemplate");
            s.addWhere("idlocation=" + obs.getId());
            ArrayList measures = s.search().getResultAsElementSummary();
            for (CmsElementSummary measure : measures) {
                DefaultMutableTreeNode measureNode = new DefaultMutableTreeNode(measure, true);
                obsNode.add(measureNode);
                if (measure.getId() != selId) continue;
                selNode = measureNode;
            }
        }
        return selNode;
    }

    private void removeLocationTemplateFromLocationGroupTemplate(long grpId) {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("locationtemplate");
        s.addSelectTitle("meta_title");
        s.addSelectAttribute(this.project.getDefaultElement("locationtemplate").getAttribute("itemsort"));
        s.setSort("ele.itemsort,el.title");
        s.addWhereRelationId((CmsAttribute)this.project.getDefaultElement("locationtemplate").getRelationAttribute("locationgroup"), "=", Long.toString(grpId));
        SearchResult result = s.search();
        for (DataRecord rec : result.getResult()) {
            CmsBasicElement element = new CmsBasicElement(rec);
            CmsElement elementObsTemplate = this.project.loadElement(element.getId(), this.project.getUser());
            this.removeObservationTemplateFromLocationTemplate(elementObsTemplate.getId());
            elementObsTemplate.remove();
        }
    }

    private void removeObservationTemplateFromLocationTemplate(long locId) {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("observationtemplate");
        s.addSelectTitle("meta_title");
        s.addSelectAttribute(this.project.getDefaultElement("observationtemplate").getAttribute("itemsort"));
        s.setSort("ele.itemsort,el.title");
        s.addWhereRelationId((CmsAttribute)this.project.getDefaultElement("observationtemplate").getRelationAttribute("location"), "=", Long.toString(locId));
        SearchResult result = s.search();
        for (DataRecord rec : result.getResult()) {
            CmsBasicElement element = new CmsBasicElement(rec);
            CmsElement elementObsTemplate = this.project.loadElement(element.getId(), this.project.getUser());
            elementObsTemplate.remove();
        }
    }

    private void removeObservationTemplateFromLocationGroupTemplate(long grpId) {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("observationtemplate");
        s.addSelectTitle("meta_title");
        s.addSelectAttribute(this.project.getDefaultElement("observationtemplate").getAttribute("itemsort"));
        s.setSort("ele.itemsort,el.title");
        s.addWhereRelationId((CmsAttribute)this.project.getDefaultElement("observationtemplate").getRelationAttribute("locationgroup"), "=", Long.toString(grpId));
        SearchResult result = s.search();
        for (DataRecord rec : result.getResult()) {
            CmsBasicElement element = new CmsBasicElement(rec);
            CmsElement elementObsTemplate = this.project.loadElement(element.getId(), this.project.getUser());
            elementObsTemplate.remove();
        }
    }

    private void addTemplate(String elementtype) {
        CmsElement ele;
        CmsElement selEle;
        CmsElementSummary sel = this.getSelectedTextTemplate();
        if ("locationgroup".equals(elementtype)) {
            DefaultMutableTreeNode node = null;
            TreePath path = this.templateTree.getSelectionPath();
            if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getLevel() == 3) {
                Dialogs.getInstance().showInfoDialog(this.bundle.getString("ProjectSettingsPanel.maximumDepthReached.text"));
                return;
            }
        }
        this.panelTextTemplateEdit.removeAll();
        int itemsort = -1;
        if (sel != null && (selEle = sel.getElement()) != null && selEle.hasAttributeValue("itemsort")) {
            itemsort = selEle.getIntegerAttribute("itemsort").getIntValue() + 1;
        }
        if ((ele = this.project.createElement(elementtype)).hasAttribute("itemsort") && itemsort >= 0) {
            ele.getIntegerAttribute("itemsort").setValue(itemsort);
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocationgroup SET itemsort = itemsort + 1 WHERE itemsort >= " + itemsort, true);
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleLocationtemplate SET itemsort = itemsort + 1 WHERE itemsort >= " + itemsort, true);
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleObservationtemplate SET itemsort = itemsort + 1 WHERE itemsort >= " + itemsort, true);
            this.project.getDatastorage().executeUpdate("UPDATE tdtaEleMeasuretemplate SET itemsort = itemsort + 1 WHERE itemsort >= " + itemsort, true);
        }
        if ("locationgroup".equals(elementtype)) {
            if (sel != null) {
                ele.getLongAttribute("parentgroup").setValue(sel.getId());
            }
        } else if ("locationtemplate".equals(elementtype)) {
            if (sel != null) {
                ele.getRelationAttribute("locationgroup").set(sel.getId());
            }
        } else if ("observationtemplate".equals(elementtype)) {
            if (sel != null) {
                if ("locationgroup".equals(sel.getElementtype())) {
                    ele.getRelationAttribute("locationgroup").set(sel.getId());
                } else if ("locationtemplate".equals(sel.getElementtype())) {
                    ele.getRelationAttribute("location").set(sel.getId());
                } else {
                    return;
                }
            }
            ((CmsObservationTemplate)ele).setAttributeVisibility();
        } else if ("measuretemplate".equals(elementtype)) {
            if (sel.getElementtype() == null) {
                return;
            }
            if ("observationtemplate".equals(sel.getElementtype())) {
                ele.getRelationAttribute("observationtemplate").set(sel.getId());
            }
        }
        CmsElementPanel p = new CmsElementPanel(ele);
        p.getPanelStyle().fontLabel = THEMIS.fontLabel;
        p.getPanelStyle().fontText = THEMIS.fontTextfield;
        p.getPanelStyle().fontHeading = THEMIS.fontHeading;
        this.panelTextTemplateEdit.add((Component)p, "Center");
        this.btnTextTemplateDelete.setEnabled(true);
        this.PanelTextTemplateMain.validate();
    }

    protected void setTextColor(Object source) {
        JTextField obj = (JTextField)source;
        Color c = this.getColorFromDialog();
        if (c != null) {
            obj.setForeground(c);
            obj.setDisabledTextColor(c);
        }
    }

    protected void setColor(Object source) {
        JTextField obj = (JTextField)source;
        Color c = this.getColorFromDialog();
        if (c != null) {
            obj.setBackground(c);
        }
    }

    private Color getColorFromDialog() {
        JColorChooser pane = new JColorChooser(Color.white);
        ColorTracker ok = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(this, this.bundle.getString("DIALOG_COLOR_TITLE"), true, pane, ok, null);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Window w = (Window)e.getComponent();
                w.dispose();
            }
        });
        THEMIS.setDialogIcon(dialog);
        dialog.setVisible(true);
        return ok.getColor();
    }

    public void updateServerInfo(ThemisPanel source) {
        ConfigurationTopic[] topics;
        boolean hasServer = this.project.hasThemisServer();
        for (ConfigurationTopic t : topics = new ConfigurationTopic[]{this.getTopic(PAGE_SERVERCODE), this.getTopic(PAGE_SERVERSETUP), this.getTopic(PAGE_SERVERSTATUS)}) {
            t.setAvailable(hasServer);
            if (t.getPanel() == source) continue;
            t.setLazyLoading(true);
        }
        this.listTopic.revalidate();
        this.listTopic.repaint();
    }

    public void invalidatePanel(ThemisPanel panel) {
        ConfigurationTopic topic = this.getTopic(panel);
        if (topic != null) {
            topic.setLazyLoading(true);
            this.listTopic.revalidate();
            this.listTopic.repaint();
        }
    }

    private ConfigurationTopic getTopic(ThemisPanel panel) {
        if (panel == null) {
            return null;
        }
        DefaultListModel topicModel = (DefaultListModel)this.listTopic.getModel();
        for (int ii = 0; ii < topicModel.size(); ++ii) {
            if (!panel.equals(((ConfigurationTopic)topicModel.get(ii)).getPanel())) continue;
            return (ConfigurationTopic)topicModel.get(ii);
        }
        return null;
    }

    private ConfigurationTopic getTopic(String id) {
        if (id == null) {
            return null;
        }
        DefaultListModel topicModel = (DefaultListModel)this.listTopic.getModel();
        for (int ii = 0; ii < topicModel.size(); ++ii) {
            if (!id.equals(((ConfigurationTopic)topicModel.get(ii)).getId())) continue;
            return (ConfigurationTopic)topicModel.get(ii);
        }
        return null;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.panelAttriubtesProject = new JPanel();
        this.jLabel47 = new JLabel();
        this.panelAttriubtesEvent = new JPanel();
        this.jLabel77 = new JLabel();
        this.jLabel8 = new JLabel();
        this.panelSelection = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listTopic = new JList();
        this.jPanel4 = new JPanel();
        this.btnTemplateLoad = new JButton();
        this.btnTemplateSave = new JButton();
        this.panelEditorScroll = new JScrollPane();
        this.panelEditor = new JPanel();
        this.panelTextTemplates = new JPanel();
        this.jPanel3 = new JPanel();
        this.templateTreeScroll = new JScrollPane();
        this.templateTree = new JTree();
        this.panelTemplateTreeButtons = new JPanel();
        this.btnTextTemplateAddGroup = new JButton();
        this.btnTextTemplateAddLocation = new JButton();
        this.btnTextTemplateAddObservation = new JButton();
        this.btnTextTemplateAddMeasure = new JButton();
        this.jPanel10 = new JPanel();
        this.btnTemplateExport = new JButton();
        this.btnTextTemplateDelete = new JButton();
        this.btnTemplateDeleteAll = new JButton();
        this.PanelTextTemplateMain = new JPanel();
        this.jScrollPane8 = new JScrollPane();
        this.panelTextTemplateEdit = new JPanel();
        this.btnTextTemplateEditSave = new JButton();
        this.panelIcons = new JPanel();
        this.jLabel11 = new JLabel();
        this.lblIconCount = new JLabel();
        this.jLabel4 = new JLabel();
        this.lblIconDisplay = new JLabel();
        this.jPanel6 = new JPanel();
        this.jPanel12 = new JPanel();
        this.jLabel65 = new JLabel();
        this.fldIconfilter = new JTextField();
        this.btnIconFilterOk = new JButton();
        this.btnIconFilterClear = new JButton();
        this.jLabel84 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.lstIcon = new JList();
        this.jPanel8 = new JPanel();
        this.jLabel72 = new JLabel();
        this.jLabel87 = new JLabel();
        this.btnIconRemoveDuplicates = new JButton();
        this.jLabel88 = new JLabel();
        this.btnIconRemoveDuplicates1 = new JButton();
        this.jLabel5 = new JLabel();
        this.jPanel5 = new JPanel();
        this.btnAddIcon = new JButton();
        this.btnRemoveIcon = new JButton();
        this.panelKeytables = new JPanel();
        this.jLabel13 = new JLabel();
        this.lstKeytableScroll = new JScrollPane();
        this.lstKeytable = new JList();
        this.panelKeytableEdit = new JPanel();
        this.panelLabels = new JPanel();
        this.jLabel31 = new JLabel();
        this.jLabel14 = new JLabel();
        this.fldTextStatusOffen = new JTextField();
        this.jLabel15 = new JLabel();
        this.fldTextStatusErledigt = new JTextField();
        this.jLabel16 = new JLabel();
        this.fldTextObservationtypeMangel = new JTextField();
        this.jLabel17 = new JLabel();
        this.fldTextObservationtypeAufgabe = new JTextField();
        this.jLabel18 = new JLabel();
        this.fldTextObservationtypeKontrolle = new JTextField();
        this.jLabel19 = new JLabel();
        this.fldTextObservationtypeInfo = new JTextField();
        this.jLabel22 = new JLabel();
        this.fldTextNoEvent = new JTextField();
        this.jLabel36 = new JLabel();
        this.fldTextNoImage = new JTextField();
        this.jLabel76 = new JLabel();
        this.fldTextNoContent = new JTextField();
        this.jLabel2 = new JLabel();
        this.panelEvent = new JPanel();
        this.jLabel85 = new JLabel();
        this.jLabel79 = new JLabel();
        this.fldTextNewEvent = new JTextField();
        this.jLabel83 = new JLabel();
        this.jLabel102 = new JLabel();
        this.chkEventCreate = new JCheckBox();
        this.lblColorRemainder1 = new JLabel();
        this.panelObservationList = new JPanel();
        this.jLabel61 = new JLabel();
        this.panelAttributeSelection = new JPanel();
        this.jLabel62 = new JLabel();
        this.jLabel63 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lstObservationAttributes = new JList();
        this.btnAddDisplay = new JButton();
        this.btnRemoveDisplay = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.modelObservationDisplay = new JList();
        this.btnDisplayDown = new JButton();
        this.btnDisplayUp = new JButton();
        this.panelDisplayScroll = new JScrollPane();
        this.panelDisplay = new JPanel();
        this.jLabel75 = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel1 = new JLabel();
        this.fldPlanLabel = new JComboBox();
        this.chkPlanLabelNummer = new JCheckBox();
        this.lblPlanLargeBuffer = new JLabel();
        this.chkPlanLargeBuffer = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.chkPlanMoveIconWithLabel = new JCheckBox();
        this.jLabel50 = new JLabel();
        this.jLabel51 = new JLabel();
        this.fldLabelOffsetX = new JTextField();
        this.jLabel52 = new JLabel();
        this.fldLabelOffsetY = new JTextField();
        this.jLabel67 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jLabel43 = new JLabel();
        this.fldIconSize = new JTextField();
        this.jLabel44 = new JLabel();
        this.jLabel39 = new JLabel();
        this.fldPointSize = new JTextField();
        this.jLabel41 = new JLabel();
        this.jLabel45 = new JLabel();
        this.fldLineSize = new JTextField();
        this.jLabel49 = new JLabel();
        this.jLabel12 = new JLabel();
        this.colorPoint = new JTextField();
        this.jButton3 = new JButton();
        this.jLabel28 = new JLabel();
        this.colorPointSelected = new JTextField();
        this.jButton4 = new JButton();
        this.jLabel37 = new JLabel();
        this.jLabel38 = new JLabel();
        this.fldDisplayColorSelection = new JComboBox();
        this.jLabel42 = new JLabel();
        this.fldFontSize = new JTextField();
        this.jLabel78 = new JLabel();
        this.jLabel48 = new JLabel();
        this.colorLabelBackground = new JTextField();
        this.btnColorBackground = new JButton();
        this.btnColorText = new JButton();
        this.jLabel68 = new JLabel();
        this.jLabel69 = new JLabel();
        this.panelImage = new JPanel();
        this.jLabel46 = new JLabel();
        this.jLabel54 = new JLabel();
        this.jPanel9 = new JPanel();
        this.fldImageSize = new JTextField();
        this.jLabel55 = new JLabel();
        this.jLabel90 = new JLabel();
        this.btnIconRemoveDuplicates2 = new JButton();
        this.jLabel56 = new JLabel();
        this.sliderImageQuality = new JSlider();
        this.lblImageQualityValue = new JLabel();
        this.jLabel57 = new JLabel();
        this.chkAddFotoObs = new JRadioButton();
        this.chkAddFotoLoc = new JRadioButton();
        this.jLabel58 = new JLabel();
        this.chkImageKeepOriginal = new JCheckBox();
        this.jLabel70 = new JLabel();
        this.jLabel81 = new JLabel();
        this.fldPlanSnippetSizeMM = new JTextField();
        this.jLabel82 = new JLabel();
        this.jLabel89 = new JLabel();
        this.panelOtherSettings = new JPanel();
        this.jLabel74 = new JLabel();
        this.jLabel60 = new JLabel();
        this.jLabel53 = new JLabel();
        this.fldDisplayHideDoneTask = new JComboBox();
        this.lblLocList = new JLabel();
        this.jLabel73 = new JLabel();
        this.chkBuildingInLocList = new JCheckBox();
        this.jLabel66 = new JLabel();
        this.jLabel100 = new JLabel();
        this.chkCreateObservation = new JCheckBox();
        this.jLabel103 = new JLabel();
        this.jLabel104 = new JLabel();
        this.chkLocationAsFilter = new JCheckBox();
        this.jLabel34 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel20 = new JLabel();
        this.fldPermissionTemplate = new JTextField();
        this.lblLocList1 = new JLabel();
        this.jLabel80 = new JLabel();
        this.chkCache = new JCheckBox();
        this.jLabel86 = new JLabel();
        this.jLabel6 = new JLabel();
        this.btnSortTemplatesAlphabetically1 = new JButton();
        this.lblColorRemainder = new JLabel();
        this.panelNumbering = new JPanel();
        this.jLabel32 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel35 = new JLabel();
        this.fldLocNumberScheme = new JComboBox();
        this.jLabel24 = new JLabel();
        this.fldStartnumber = new JTextField();
        this.jLabel98 = new JLabel();
        this.chkLocNumberIndividual = new JCheckBox();
        this.jLabel25 = new JLabel();
        this.jLabel91 = new JLabel();
        this.fldLocSortOrder = new JComboBox();
        this.jLabel94 = new JLabel();
        this.jLabel96 = new JLabel();
        this.btnSortLocations = new JButton();
        this.jLabel95 = new JLabel();
        this.jLabel97 = new JLabel();
        this.btnSortObservations = new JButton();
        this.jLabel59 = new JLabel();
        this.jLabel92 = new JLabel();
        this.jLabel99 = new JLabel();
        this.btnSortTemplatesAlphabetically = new JButton();
        this.jLabel93 = new JLabel();
        this.panelAttributesObservation = new JPanel();
        this.jLabel64 = new JLabel();
        this.jPanel18 = new JPanel();
        this.jLabel26 = new JLabel();
        this.fldObservationAttributeCodes1 = new JComboBox();
        this.btnAddObsvervationAttribute1 = new JButton();
        this.panelHeader1 = new JPanel();
        this.jLabel30 = new JLabel();
        this.lblType1 = new JLabel();
        this.jLabel33 = new JLabel();
        this.jPanel7 = new JPanel();
        this.btnUp1 = new JButton();
        this.btnDown1 = new JButton();
        this.btnRemove1 = new JButton();
        this.panelObservationAttributes1Scroll = new JScrollPane();
        this.panelObservationAttributes1 = new JPanel();
        this.panelAttriubtesLocation = new JPanel();
        this.jLabel40 = new JLabel();
        this.jPanel13 = new JPanel();
        this.jLabel7 = new JLabel();
        this.fldLocationAttributeCodes1 = new JComboBox();
        this.btnAddLocationAttribute1 = new JButton();
        this.panelHeader = new JPanel();
        this.lblType = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.btnRemove = new JButton();
        this.jLabel27 = new JLabel();
        this.jLabel29 = new JLabel();
        this.panelLocationAttributes1Scroll = new JScrollPane();
        this.panelLocationAttributes1 = new JPanel();
        this.btnClose = new JButton();
        this.panelAttriubtesProject.setRequestFocusEnabled(false);
        this.panelAttriubtesProject.setLayout(new BorderLayout());
        this.jLabel47.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel47, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel47.text"));
        this.jLabel47.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelAttriubtesProject.add((Component)this.jLabel47, "North");
        this.panelAttriubtesEvent.setRequestFocusEnabled(false);
        this.panelAttriubtesEvent.setLayout(new BorderLayout());
        this.jLabel77.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel77, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel77.text"));
        this.jLabel77.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelAttriubtesEvent.add((Component)this.jLabel77, "North");
        this.setLayout(new GridBagLayout());
        this.jLabel8.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel8.text"));
        this.jLabel8.setHorizontalTextPosition(10);
        this.jLabel8.setMinimumSize(null);
        this.jLabel8.setPreferredSize(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.panelSelection.setMinimumSize(new Dimension(230, 50));
        this.panelSelection.setPreferredSize(new Dimension(230, 50));
        this.panelSelection.setLayout(new GridBagLayout());
        this.jScrollPane1.setMaximumSize(null);
        this.jScrollPane1.setMinimumSize(null);
        this.listTopic.setFont(THEMIS.fontList);
        this.listTopic.setModel(new DefaultListModel());
        this.listTopic.setSelectionMode(0);
        this.listTopic.setPreferredSize(null);
        this.listTopic.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ProjectSettingsPanel.this.listTopicValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listTopic);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelSelection.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.btnTemplateLoad.setFont(THEMIS.fontButton);
        this.btnTemplateLoad.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/openFile_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTemplateLoad, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTemplateLoad.text"));
        this.btnTemplateLoad.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTemplateLoad.toolTipText"));
        this.btnTemplateLoad.setBorder(new SoftBevelBorder(0));
        this.btnTemplateLoad.setIconTextGap(10);
        this.btnTemplateLoad.setMargin(new Insets(10, 10, 10, 10));
        this.btnTemplateLoad.setMaximumSize(new Dimension(151, 35));
        this.btnTemplateLoad.setMinimumSize(null);
        this.btnTemplateLoad.setPreferredSize(null);
        this.btnTemplateLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTemplateLoadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnTemplateLoad, gridBagConstraints);
        this.btnTemplateSave.setFont(THEMIS.fontButton);
        this.btnTemplateSave.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/save24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTemplateSave, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTemplateSave.text"));
        this.btnTemplateSave.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTemplateSave.toolTipText"));
        this.btnTemplateSave.setBorder(new SoftBevelBorder(0));
        this.btnTemplateSave.setIconTextGap(10);
        this.btnTemplateSave.setMargin(new Insets(10, 10, 10, 10));
        this.btnTemplateSave.setMaximumSize(new Dimension(177, 35));
        this.btnTemplateSave.setMinimumSize(null);
        this.btnTemplateSave.setPreferredSize(null);
        this.btnTemplateSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTemplateSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnTemplateSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.panelSelection.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelSelection, gridBagConstraints);
        this.panelSelection.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.panelSelection.AccessibleContext.accessibleName"));
        this.panelEditorScroll.setHorizontalScrollBarPolicy(31);
        this.panelEditorScroll.setVerticalScrollBarPolicy(21);
        this.panelEditorScroll.setPreferredSize(new Dimension(300, 200));
        this.panelEditorScroll.setRequestFocusEnabled(false);
        this.panelEditor.setBackground(new Color(204, 204, 204));
        this.panelEditor.setMinimumSize(new Dimension(300, 200));
        this.panelEditor.setName("");
        this.panelEditor.setPreferredSize(new Dimension(300, 200));
        this.panelEditor.setRequestFocusEnabled(false);
        this.panelEditor.setLayout(new CardLayout());
        this.panelTextTemplates.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.templateTreeScroll.setMinimumSize(null);
        this.templateTree.setFont(THEMIS.fontLabel);
        this.templateTree.setModel(this.templateTreeModel);
        this.templateTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
                ProjectSettingsPanel.this.templateTreeTreeCollapsed(evt);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                ProjectSettingsPanel.this.templateTreeTreeExpanded(evt);
            }
        });
        this.templateTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                ProjectSettingsPanel.this.templateTreeValueChanged(evt);
            }
        });
        this.templateTreeScroll.setViewportView(this.templateTree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.templateTreeScroll, gridBagConstraints);
        this.panelTemplateTreeButtons.setLayout(new GridBagLayout());
        this.btnTextTemplateAddGroup.setFont(THEMIS.fontButton);
        this.btnTextTemplateAddGroup.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTextTemplateAddGroup, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateAddGroup.text"));
        this.btnTextTemplateAddGroup.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateAddGroup.toolTipText"));
        this.btnTextTemplateAddGroup.setBorder(new SoftBevelBorder(0));
        this.btnTextTemplateAddGroup.setContentAreaFilled(false);
        this.btnTextTemplateAddGroup.setEnabled(false);
        this.btnTextTemplateAddGroup.setMinimumSize(null);
        this.btnTextTemplateAddGroup.setPreferredSize(null);
        this.btnTextTemplateAddGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTextTemplateAddGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTemplateTreeButtons.add((Component)this.btnTextTemplateAddGroup, gridBagConstraints);
        this.btnTextTemplateAddLocation.setFont(THEMIS.fontButton);
        this.btnTextTemplateAddLocation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTextTemplateAddLocation, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateAddLocation.text"));
        this.btnTextTemplateAddLocation.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateAddLocation.toolTipText"));
        this.btnTextTemplateAddLocation.setBorder(new SoftBevelBorder(0));
        this.btnTextTemplateAddLocation.setContentAreaFilled(false);
        this.btnTextTemplateAddLocation.setEnabled(false);
        this.btnTextTemplateAddLocation.setMinimumSize(null);
        this.btnTextTemplateAddLocation.setPreferredSize(null);
        this.btnTextTemplateAddLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTextTemplateAddLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTemplateTreeButtons.add((Component)this.btnTextTemplateAddLocation, gridBagConstraints);
        this.btnTextTemplateAddObservation.setFont(THEMIS.fontButton);
        this.btnTextTemplateAddObservation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTextTemplateAddObservation, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateAddObservation.text"));
        this.btnTextTemplateAddObservation.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateAddObservation.toolTipText"));
        this.btnTextTemplateAddObservation.setBorder(new SoftBevelBorder(0));
        this.btnTextTemplateAddObservation.setContentAreaFilled(false);
        this.btnTextTemplateAddObservation.setEnabled(false);
        this.btnTextTemplateAddObservation.setMinimumSize(null);
        this.btnTextTemplateAddObservation.setPreferredSize(null);
        this.btnTextTemplateAddObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTextTemplateAddObservationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTemplateTreeButtons.add((Component)this.btnTextTemplateAddObservation, gridBagConstraints);
        this.btnTextTemplateAddMeasure.setFont(THEMIS.fontButton);
        this.btnTextTemplateAddMeasure.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTextTemplateAddMeasure, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateAddMeasure.text"));
        this.btnTextTemplateAddMeasure.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateAddMeasure.toolTipText"));
        this.btnTextTemplateAddMeasure.setBorder(new SoftBevelBorder(0));
        this.btnTextTemplateAddMeasure.setContentAreaFilled(false);
        this.btnTextTemplateAddMeasure.setEnabled(false);
        this.btnTextTemplateAddMeasure.setMinimumSize(null);
        this.btnTextTemplateAddMeasure.setPreferredSize(null);
        this.btnTextTemplateAddMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTextTemplateAddMeasureActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTemplateTreeButtons.add((Component)this.btnTextTemplateAddMeasure, gridBagConstraints);
        this.jPanel10.setLayout(new GridBagLayout());
        this.btnTemplateExport.setFont(THEMIS.fontButton);
        this.btnTemplateExport.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_excelExport24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTemplateExport, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTemplateExport.text"));
        this.btnTemplateExport.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTemplateExport.toolTipText"));
        this.btnTemplateExport.setBorder(new SoftBevelBorder(0));
        this.btnTemplateExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTemplateExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel10.add((Component)this.btnTemplateExport, gridBagConstraints);
        this.btnTextTemplateDelete.setFont(THEMIS.fontButton);
        this.btnTextTemplateDelete.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTextTemplateDelete, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateDelete.text"));
        this.btnTextTemplateDelete.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateDelete.toolTipText"));
        this.btnTextTemplateDelete.setBorder(new SoftBevelBorder(0));
        this.btnTextTemplateDelete.setContentAreaFilled(false);
        this.btnTextTemplateDelete.setEnabled(false);
        this.btnTextTemplateDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTextTemplateDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel10.add((Component)this.btnTextTemplateDelete, gridBagConstraints);
        this.btnTemplateDeleteAll.setFont(THEMIS.fontButton);
        this.btnTemplateDeleteAll.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTemplateDeleteAll, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTemplateDeleteAll.text"));
        this.btnTemplateDeleteAll.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTemplateDeleteAll.toolTipText"));
        this.btnTemplateDeleteAll.setBorder(new SoftBevelBorder(0));
        this.btnTemplateDeleteAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTemplateDeleteAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel10.add((Component)this.btnTemplateDeleteAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelTemplateTreeButtons.add((Component)this.jPanel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.panelTemplateTreeButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTextTemplates.add((Component)this.jPanel3, gridBagConstraints);
        this.PanelTextTemplateMain.setLayout(new GridBagLayout());
        this.jScrollPane8.setHorizontalScrollBar(null);
        this.jScrollPane8.setMinimumSize(null);
        this.panelTextTemplateEdit.setBorder(new LineBorder(new Color(240, 240, 240), 10, true));
        this.panelTextTemplateEdit.setLayout(new BorderLayout());
        this.jScrollPane8.setViewportView(this.panelTextTemplateEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.PanelTextTemplateMain.add((Component)this.jScrollPane8, gridBagConstraints);
        this.btnTextTemplateEditSave.setFont(THEMIS.fontButton);
        this.btnTextTemplateEditSave.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTextTemplateEditSave, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnTextTemplateEditSave.text"));
        this.btnTextTemplateEditSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnTextTemplateEditSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.PanelTextTemplateMain.add((Component)this.btnTextTemplateEditSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTextTemplates.add((Component)this.PanelTextTemplateMain, gridBagConstraints);
        this.panelEditor.add((Component)this.panelTextTemplates, "cardTemplateTree");
        this.panelIcons.setLayout(new GridBagLayout());
        this.jLabel11.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel11.text"));
        this.jLabel11.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel11.toolTipText"));
        this.jLabel11.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelIcons.add((Component)this.jLabel11, gridBagConstraints);
        this.lblIconCount.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblIconCount, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblIconCount.text"));
        this.lblIconCount.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblIconCount.toolTipText"));
        this.lblIconCount.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.panelIcons.add((Component)this.lblIconCount, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel4.text"));
        this.jLabel4.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel4.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelIcons.add((Component)this.jLabel4, gridBagConstraints);
        this.lblIconDisplay.setFont(THEMIS.fontLabel);
        this.lblIconDisplay.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblIconDisplay, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblIconDisplay.text"));
        this.lblIconDisplay.setMaximumSize(new Dimension(50, 14));
        this.lblIconDisplay.setMinimumSize(new Dimension(100, 35));
        this.lblIconDisplay.setPreferredSize(new Dimension(100, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelIcons.add((Component)this.lblIconDisplay, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel12.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel65, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel65.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel12.add((Component)this.jLabel65, gridBagConstraints);
        this.fldIconfilter.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldIconfilter.text"));
        this.fldIconfilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.fldIconfilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel12.add((Component)this.fldIconfilter, gridBagConstraints);
        this.btnIconFilterOk.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnIconFilterOk, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnIconFilterOk.text"));
        this.btnIconFilterOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnIconFilterOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel12.add((Component)this.btnIconFilterOk, gridBagConstraints);
        this.btnIconFilterClear.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnIconFilterClear, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnIconFilterClear.text"));
        this.btnIconFilterClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnIconFilterClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel12.add((Component)this.btnIconFilterClear, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel6.add((Component)this.jPanel12, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel84, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel84.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel6.add((Component)this.jLabel84, gridBagConstraints);
        this.jScrollPane5.setMaximumSize(null);
        this.jScrollPane5.setMinimumSize(new Dimension(200, 100));
        this.jScrollPane5.setName("");
        this.jScrollPane5.setPreferredSize(new Dimension(200, 100));
        this.lstIcon.setFont(THEMIS.fontList);
        this.lstIcon.setModel(new DefaultListModel());
        this.lstIcon.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ProjectSettingsPanel.this.lstIconValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.lstIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jScrollPane5, gridBagConstraints);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jLabel72.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel72, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel72.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel8.add((Component)this.jLabel72, gridBagConstraints);
        this.jLabel87.setFont(THEMIS.fontLabel);
        this.jLabel87.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel87, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel87.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel8.add((Component)this.jLabel87, gridBagConstraints);
        this.btnIconRemoveDuplicates.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnIconRemoveDuplicates, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnIconRemoveDuplicates.text"));
        this.btnIconRemoveDuplicates.setMinimumSize(new Dimension(200, 35));
        this.btnIconRemoveDuplicates.setPreferredSize(new Dimension(200, 35));
        this.btnIconRemoveDuplicates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnIconRemoveDuplicatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.jPanel8.add((Component)this.btnIconRemoveDuplicates, gridBagConstraints);
        this.jLabel88.setFont(THEMIS.fontLabel);
        this.jLabel88.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel88, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel88.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.jPanel8.add((Component)this.jLabel88, gridBagConstraints);
        this.btnIconRemoveDuplicates1.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnIconRemoveDuplicates1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnIconRemoveDuplicates1.text"));
        this.btnIconRemoveDuplicates1.setMinimumSize(new Dimension(200, 35));
        this.btnIconRemoveDuplicates1.setPreferredSize(new Dimension(200, 35));
        this.btnIconRemoveDuplicates1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnIconRemoveDuplicates1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.jPanel8.add((Component)this.btnIconRemoveDuplicates1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel8.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.btnAddIcon.setFont(THEMIS.fontButton);
        this.btnAddIcon.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddIcon, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnAddIcon.text"));
        this.btnAddIcon.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnAddIcon.toolTipText"));
        this.btnAddIcon.setBorder(new SoftBevelBorder(0));
        this.btnAddIcon.setContentAreaFilled(false);
        this.btnAddIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnAddIconActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.btnAddIcon, gridBagConstraints);
        this.btnRemoveIcon.setFont(THEMIS.fontButton);
        this.btnRemoveIcon.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveIcon, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnRemoveIcon.text"));
        this.btnRemoveIcon.setToolTipText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnRemoveIcon.toolTipText"));
        this.btnRemoveIcon.setBorder(new SoftBevelBorder(0));
        this.btnRemoveIcon.setContentAreaFilled(false);
        this.btnRemoveIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnRemoveIconActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.btnRemoveIcon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelIcons.add((Component)this.jPanel6, gridBagConstraints);
        this.panelEditor.add((Component)this.panelIcons, "cardIcons");
        this.panelKeytables.setLayout(new GridBagLayout());
        this.jLabel13.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel13.text"));
        this.jLabel13.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panelKeytables.add((Component)this.jLabel13, gridBagConstraints);
        this.lstKeytableScroll.setMinimumSize(new Dimension(200, 300));
        this.lstKeytableScroll.setPreferredSize(new Dimension(200, 300));
        this.lstKeytable.setFont(THEMIS.fontList);
        this.lstKeytable.setModel(this.modelKeytable);
        this.lstKeytable.setSelectionMode(0);
        this.lstKeytable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ProjectSettingsPanel.this.lstKeytableValueChanged(evt);
            }
        });
        this.lstKeytableScroll.setViewportView(this.lstKeytable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panelKeytables.add((Component)this.lstKeytableScroll, gridBagConstraints);
        this.panelKeytableEdit.setLayout(new BorderLayout(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panelKeytables.add((Component)this.panelKeytableEdit, gridBagConstraints);
        this.panelEditor.add((Component)this.panelKeytables, "cardKeytables");
        this.panelLabels.setLayout(new GridBagLayout());
        this.jLabel31.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel31, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel31.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 15, 3);
        this.panelLabels.add((Component)this.jLabel31, gridBagConstraints);
        this.jLabel14.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel14.text"));
        this.jLabel14.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.panelLabels.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel14.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel14.AccessibleContext.accessibleName"));
        this.fldTextStatusOffen.setFont(THEMIS.fontTextfield);
        this.fldTextStatusOffen.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextStatusOffen.text"));
        this.fldTextStatusOffen.setMinimumSize(new Dimension(150, 30));
        this.fldTextStatusOffen.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLabels.add((Component)this.fldTextStatusOffen, gridBagConstraints);
        this.jLabel15.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel15.text"));
        this.jLabel15.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 15, 3);
        this.panelLabels.add((Component)this.jLabel15, gridBagConstraints);
        this.fldTextStatusErledigt.setFont(THEMIS.fontTextfield);
        this.fldTextStatusErledigt.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextStatusErledigt.text"));
        this.fldTextStatusErledigt.setMinimumSize(new Dimension(150, 30));
        this.fldTextStatusErledigt.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 15, 3);
        this.panelLabels.add((Component)this.fldTextStatusErledigt, gridBagConstraints);
        this.jLabel16.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel16.text"));
        this.jLabel16.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.panelLabels.add((Component)this.jLabel16, gridBagConstraints);
        this.fldTextObservationtypeMangel.setFont(THEMIS.fontTextfield);
        this.fldTextObservationtypeMangel.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextObservationtypeMangel.text"));
        this.fldTextObservationtypeMangel.setMinimumSize(new Dimension(150, 30));
        this.fldTextObservationtypeMangel.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLabels.add((Component)this.fldTextObservationtypeMangel, gridBagConstraints);
        this.jLabel17.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel17, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel17.text"));
        this.jLabel17.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.panelLabels.add((Component)this.jLabel17, gridBagConstraints);
        this.fldTextObservationtypeAufgabe.setFont(THEMIS.fontTextfield);
        this.fldTextObservationtypeAufgabe.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextObservationtypeAufgabe.text"));
        this.fldTextObservationtypeAufgabe.setMinimumSize(new Dimension(150, 30));
        this.fldTextObservationtypeAufgabe.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLabels.add((Component)this.fldTextObservationtypeAufgabe, gridBagConstraints);
        this.jLabel18.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel18.text"));
        this.jLabel18.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.panelLabels.add((Component)this.jLabel18, gridBagConstraints);
        this.fldTextObservationtypeKontrolle.setFont(THEMIS.fontTextfield);
        this.fldTextObservationtypeKontrolle.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextObservationtypeKontrolle.text"));
        this.fldTextObservationtypeKontrolle.setMinimumSize(new Dimension(150, 30));
        this.fldTextObservationtypeKontrolle.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLabels.add((Component)this.fldTextObservationtypeKontrolle, gridBagConstraints);
        this.jLabel19.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel19, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel19.text"));
        this.jLabel19.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 15, 3);
        this.panelLabels.add((Component)this.jLabel19, gridBagConstraints);
        this.fldTextObservationtypeInfo.setFont(THEMIS.fontTextfield);
        this.fldTextObservationtypeInfo.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextObservationtypeInfo.text"));
        this.fldTextObservationtypeInfo.setMinimumSize(new Dimension(150, 30));
        this.fldTextObservationtypeInfo.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 15, 3);
        this.panelLabels.add((Component)this.fldTextObservationtypeInfo, gridBagConstraints);
        this.jLabel22.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel22.text"));
        this.jLabel22.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.panelLabels.add((Component)this.jLabel22, gridBagConstraints);
        this.fldTextNoEvent.setFont(THEMIS.fontTextfield);
        this.fldTextNoEvent.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextNoEvent.text"));
        this.fldTextNoEvent.setMinimumSize(new Dimension(150, 30));
        this.fldTextNoEvent.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLabels.add((Component)this.fldTextNoEvent, gridBagConstraints);
        this.jLabel36.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel36, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel36.text"));
        this.jLabel36.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.panelLabels.add((Component)this.jLabel36, gridBagConstraints);
        this.fldTextNoImage.setFont(THEMIS.fontTextfield);
        this.fldTextNoImage.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextNoImage.text"));
        this.fldTextNoImage.setMinimumSize(new Dimension(150, 30));
        this.fldTextNoImage.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLabels.add((Component)this.fldTextNoImage, gridBagConstraints);
        this.jLabel76.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel76, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel76.text"));
        this.jLabel76.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 15, 3);
        this.panelLabels.add((Component)this.jLabel76, gridBagConstraints);
        this.fldTextNoContent.setFont(THEMIS.fontTextfield);
        this.fldTextNoContent.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextNoContent.text"));
        this.fldTextNoContent.setMinimumSize(new Dimension(150, 30));
        this.fldTextNoContent.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLabels.add((Component)this.fldTextNoContent, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panelLabels.add((Component)this.jLabel2, gridBagConstraints);
        this.panelEditor.add((Component)this.panelLabels, "cardLabels");
        this.panelEvent.setLayout(new GridBagLayout());
        this.jLabel85.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel85, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel85.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEvent.add((Component)this.jLabel85, gridBagConstraints);
        this.jLabel79.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel79, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel79.text"));
        this.jLabel79.setMaximumSize(null);
        this.jLabel79.setMinimumSize(null);
        this.jLabel79.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.panelEvent.add((Component)this.jLabel79, gridBagConstraints);
        this.fldTextNewEvent.setFont(THEMIS.fontTextfield);
        this.fldTextNewEvent.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldTextNewEvent.text"));
        this.fldTextNewEvent.setMinimumSize(new Dimension(150, 30));
        this.fldTextNewEvent.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelEvent.add((Component)this.fldTextNewEvent, gridBagConstraints);
        this.jLabel83.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel83, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel83.text"));
        this.jLabel83.setMaximumSize(null);
        this.jLabel83.setMinimumSize(null);
        this.jLabel83.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEvent.add((Component)this.jLabel83, gridBagConstraints);
        this.jLabel102.setFont(THEMIS.fontLabel);
        this.jLabel102.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel102, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel102.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelEvent.add((Component)this.jLabel102, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkEventCreate, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkEventCreate.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEvent.add((Component)this.chkEventCreate, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblColorRemainder1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblColorRemainder1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEvent.add((Component)this.lblColorRemainder1, gridBagConstraints);
        this.panelEditor.add((Component)this.panelEvent, "cardEvent");
        this.panelObservationList.setLayout(new GridBagLayout());
        this.jLabel61.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel61, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel61.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationList.add((Component)this.jLabel61, gridBagConstraints);
        this.panelAttributeSelection.setLayout(new GridBagLayout());
        this.jLabel62.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel62, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel62.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAttributeSelection.add((Component)this.jLabel62, gridBagConstraints);
        this.jLabel63.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel63, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel63.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAttributeSelection.add((Component)this.jLabel63, gridBagConstraints);
        this.lstObservationAttributes.setFont(THEMIS.fontList);
        this.lstObservationAttributes.setModel(this.modelObsAttributes);
        this.jScrollPane2.setViewportView(this.lstObservationAttributes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAttributeSelection.add((Component)this.jScrollPane2, gridBagConstraints);
        this.btnAddDisplay.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddDisplay, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnAddDisplay.text"));
        this.btnAddDisplay.setBorder(new SoftBevelBorder(0));
        this.btnAddDisplay.setPreferredSize(new Dimension(35, 35));
        this.btnAddDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnAddDisplayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAttributeSelection.add((Component)this.btnAddDisplay, gridBagConstraints);
        this.btnRemoveDisplay.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveDisplay, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnRemoveDisplay.text"));
        this.btnRemoveDisplay.setBorder(new SoftBevelBorder(0));
        this.btnRemoveDisplay.setPreferredSize(new Dimension(35, 35));
        this.btnRemoveDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnRemoveDisplayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAttributeSelection.add((Component)this.btnRemoveDisplay, gridBagConstraints);
        this.modelObservationDisplay.setFont(THEMIS.fontList);
        this.modelObservationDisplay.setModel(this.modelObsDisplay);
        this.jScrollPane3.setViewportView(this.modelObservationDisplay);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAttributeSelection.add((Component)this.jScrollPane3, gridBagConstraints);
        this.btnDisplayDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDisplayDown, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnDisplayDown.text"));
        this.btnDisplayDown.setBorder(new SoftBevelBorder(0));
        this.btnDisplayDown.setPreferredSize(new Dimension(35, 35));
        this.btnDisplayDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnDisplayDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAttributeSelection.add((Component)this.btnDisplayDown, gridBagConstraints);
        this.btnDisplayUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDisplayUp, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnDisplayUp.text"));
        this.btnDisplayUp.setBorder(new SoftBevelBorder(0));
        this.btnDisplayUp.setPreferredSize(new Dimension(35, 35));
        this.btnDisplayUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnDisplayUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAttributeSelection.add((Component)this.btnDisplayUp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationList.add((Component)this.panelAttributeSelection, gridBagConstraints);
        this.panelEditor.add((Component)this.panelObservationList, "cardObservationList");
        this.panelDisplayScroll.setBorder(null);
        this.panelDisplayScroll.setMaximumSize(null);
        this.panelDisplayScroll.setMinimumSize(null);
        this.panelDisplayScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.panelDisplay.setLayout(new GridBagLayout());
        this.jLabel75.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel75, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel75.text"));
        this.jLabel75.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDisplay.add((Component)this.jLabel75, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        this.jLabel9.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel1.text"));
        this.jLabel1.setMaximumSize(new Dimension(73, 30));
        this.jLabel1.setMinimumSize(new Dimension(73, 30));
        this.jLabel1.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.jLabel1, gridBagConstraints);
        this.fldPlanLabel.setFont(THEMIS.fontList);
        this.fldPlanLabel.setModel(new DefaultComboBoxModel());
        this.fldPlanLabel.setMinimumSize(new Dimension(100, 35));
        this.fldPlanLabel.setPreferredSize(new Dimension(300, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add(this.fldPlanLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkPlanLabelNummer, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkPlanLabelNummer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.chkPlanLabelNummer, gridBagConstraints);
        this.lblPlanLargeBuffer.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPlanLargeBuffer, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblPlanLargeBuffer.text"));
        this.lblPlanLargeBuffer.setMaximumSize(new Dimension(78, 30));
        this.lblPlanLargeBuffer.setMinimumSize(new Dimension(78, 30));
        this.lblPlanLargeBuffer.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.lblPlanLargeBuffer, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkPlanLargeBuffer, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkPlanLargeBuffer.text"));
        this.chkPlanLargeBuffer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectSettingsPanel.this.chkPlanLargeBufferItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.chkPlanLargeBuffer, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel3.text"));
        this.jLabel3.setMaximumSize(new Dimension(78, 30));
        this.jLabel3.setMinimumSize(new Dimension(78, 30));
        this.jLabel3.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.jLabel3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkPlanMoveIconWithLabel, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkPlanMoveIconWithLabel.text"));
        this.chkPlanMoveIconWithLabel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectSettingsPanel.this.chkPlanMoveIconWithLabelItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.chkPlanMoveIconWithLabel, gridBagConstraints);
        this.jLabel50.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel50, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel50.text"));
        this.jLabel50.setMaximumSize(new Dimension(70, 30));
        this.jLabel50.setMinimumSize(new Dimension(70, 30));
        this.jLabel50.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.jLabel50, gridBagConstraints);
        this.jLabel51.setFont(THEMIS.fontLabel);
        this.jLabel51.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel51, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel51.text"));
        this.jLabel51.setMaximumSize(new Dimension(25, 30));
        this.jLabel51.setMinimumSize(new Dimension(25, 30));
        this.jLabel51.setPreferredSize(new Dimension(25, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.jLabel51, gridBagConstraints);
        this.fldLabelOffsetX.setFont(THEMIS.fontTextfield);
        this.fldLabelOffsetX.setHorizontalAlignment(0);
        this.fldLabelOffsetX.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldLabelOffsetX.text"));
        this.fldLabelOffsetX.setPreferredSize(new Dimension(50, 30));
        this.fldLabelOffsetX.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ProjectSettingsPanel.this.fldLabelOffsetXFocusLost(evt);
            }
        });
        this.fldLabelOffsetX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.fldLabelOffsetXActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.fldLabelOffsetX, gridBagConstraints);
        this.jLabel52.setFont(THEMIS.fontLabel);
        this.jLabel52.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel52, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel52.text"));
        this.jLabel52.setMaximumSize(new Dimension(25, 16));
        this.jLabel52.setMinimumSize(new Dimension(25, 16));
        this.jLabel52.setPreferredSize(new Dimension(25, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.jLabel52, gridBagConstraints);
        this.fldLabelOffsetY.setFont(THEMIS.fontTextfield);
        this.fldLabelOffsetY.setHorizontalAlignment(0);
        this.fldLabelOffsetY.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldLabelOffsetY.text"));
        this.fldLabelOffsetY.setPreferredSize(new Dimension(50, 30));
        this.fldLabelOffsetY.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ProjectSettingsPanel.this.fldLabelOffsetYFocusLost(evt);
            }
        });
        this.fldLabelOffsetY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.fldLabelOffsetYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.fldLabelOffsetY, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel67, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel67.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel11.add((Component)this.jLabel67, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDisplay.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel2.setForeground(new Color(51, 255, 51));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel10.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel43.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel43, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel43.text"));
        this.jLabel43.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel43, gridBagConstraints);
        this.fldIconSize.setFont(THEMIS.fontTextfield);
        this.fldIconSize.setHorizontalAlignment(0);
        this.fldIconSize.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldIconSize.text"));
        this.fldIconSize.setPreferredSize(new Dimension(100, 30));
        this.fldIconSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ProjectSettingsPanel.this.fldIconSizeFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.fldIconSize, gridBagConstraints);
        this.jLabel44.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel44, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel44.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipady = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel44, gridBagConstraints);
        this.jLabel39.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel39, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel39.text"));
        this.jLabel39.setMaximumSize(new Dimension(71, 30));
        this.jLabel39.setMinimumSize(new Dimension(71, 30));
        this.jLabel39.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel39, gridBagConstraints);
        this.fldPointSize.setFont(THEMIS.fontTextfield);
        this.fldPointSize.setHorizontalAlignment(0);
        this.fldPointSize.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldPointSize.text"));
        this.fldPointSize.setPreferredSize(new Dimension(100, 30));
        this.fldPointSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ProjectSettingsPanel.this.fldPointSizeFocusLost(evt);
            }
        });
        this.fldPointSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.fldPointSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.fldPointSize, gridBagConstraints);
        this.jLabel41.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel41, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel41.text"));
        this.jLabel41.setMaximumSize(new Dimension(35, 30));
        this.jLabel41.setMinimumSize(new Dimension(35, 30));
        this.jLabel41.setPreferredSize(new Dimension(35, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel41, gridBagConstraints);
        this.jLabel45.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel45, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel45.text"));
        this.jLabel45.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel45, gridBagConstraints);
        this.fldLineSize.setFont(THEMIS.fontTextfield);
        this.fldLineSize.setHorizontalAlignment(0);
        this.fldLineSize.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldLineSize.text"));
        this.fldLineSize.setPreferredSize(new Dimension(100, 30));
        this.fldLineSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ProjectSettingsPanel.this.fldLineSizeFocusLost(evt);
            }
        });
        this.fldLineSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.fldLineSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.fldLineSize, gridBagConstraints);
        this.jLabel49.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel49, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel49.text"));
        this.jLabel49.setMaximumSize(new Dimension(35, 30));
        this.jLabel49.setMinimumSize(new Dimension(35, 30));
        this.jLabel49.setPreferredSize(new Dimension(35, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel49, gridBagConstraints);
        this.jLabel12.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel12.text"));
        this.jLabel12.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel12, gridBagConstraints);
        this.colorPoint.setBackground(new Color(242, 142, 4));
        this.colorPoint.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.colorPoint.text"));
        this.colorPoint.setEnabled(false);
        this.colorPoint.setMaximumSize(new Dimension(10, 30));
        this.colorPoint.setMinimumSize(new Dimension(14, 30));
        this.colorPoint.setPreferredSize(new Dimension(100, 30));
        this.colorPoint.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectSettingsPanel.this.colorPointMouseClicked(evt);
            }
        });
        this.colorPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.colorPointActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.colorPoint, gridBagConstraints);
        this.jButton3.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jButton3.text"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jButton3, gridBagConstraints);
        this.jLabel28.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel28, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel28.text"));
        this.jLabel28.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel28, gridBagConstraints);
        this.colorPointSelected.setBackground(new Color(4, 30, 100));
        this.colorPointSelected.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.colorPointSelected.text"));
        this.colorPointSelected.setEnabled(false);
        this.colorPointSelected.setMinimumSize(new Dimension(10, 24));
        this.colorPointSelected.setPreferredSize(new Dimension(100, 30));
        this.colorPointSelected.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectSettingsPanel.this.colorPointSelectedMouseClicked(evt);
            }
        });
        this.colorPointSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.colorPointSelectedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.colorPointSelected, gridBagConstraints);
        this.jButton4.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton4, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jButton4.text"));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.jButton4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jButton4, gridBagConstraints);
        this.jLabel37.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel37, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel37.text"));
        this.jLabel37.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel37, gridBagConstraints);
        this.jLabel38.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel38, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel38.text"));
        this.jLabel38.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel38, gridBagConstraints);
        this.fldDisplayColorSelection.setFont(THEMIS.fontList);
        this.fldDisplayColorSelection.setModel(new DefaultComboBoxModel());
        this.fldDisplayColorSelection.setMinimumSize(new Dimension(150, 30));
        this.fldDisplayColorSelection.setPreferredSize(null);
        this.fldDisplayColorSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectSettingsPanel.this.fldDisplayColorSelectionItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add(this.fldDisplayColorSelection, gridBagConstraints);
        this.jLabel42.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel42, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel42.text"));
        this.jLabel42.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel42, gridBagConstraints);
        this.fldFontSize.setFont(THEMIS.fontTextfield);
        this.fldFontSize.setHorizontalAlignment(0);
        this.fldFontSize.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldFontSize.text"));
        this.fldFontSize.setMinimumSize(new Dimension(100, 30));
        this.fldFontSize.setPreferredSize(new Dimension(100, 30));
        this.fldFontSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ProjectSettingsPanel.this.fldFontSizeFocusLost(evt);
            }
        });
        this.fldFontSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.fldFontSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.fldFontSize, gridBagConstraints);
        this.jLabel78.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel78, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel78.text"));
        this.jLabel78.setMaximumSize(new Dimension(35, 30));
        this.jLabel78.setMinimumSize(new Dimension(35, 30));
        this.jLabel78.setPreferredSize(new Dimension(35, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.jLabel78, gridBagConstraints);
        this.jLabel48.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel48, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel48.text"));
        this.jLabel48.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel48, gridBagConstraints);
        this.colorLabelBackground.setEditable(false);
        this.colorLabelBackground.setHorizontalAlignment(0);
        this.colorLabelBackground.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.colorLabelBackground.text"));
        this.colorLabelBackground.setEnabled(false);
        this.colorLabelBackground.setMaximumSize(new Dimension(300, 30));
        this.colorLabelBackground.setPreferredSize(new Dimension(100, 30));
        this.colorLabelBackground.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectSettingsPanel.this.colorLabelBackgroundMouseClicked(evt);
            }
        });
        this.colorLabelBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.colorLabelBackgroundActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.colorLabelBackground, gridBagConstraints);
        this.btnColorBackground.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnColorBackground, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnColorBackground.text"));
        this.btnColorBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnColorBackgroundActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.btnColorBackground, gridBagConstraints);
        this.btnColorText.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnColorText, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnColorText.text"));
        this.btnColorText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnColorTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel2.add((Component)this.btnColorText, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel68, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel68.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jLabel68, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel69, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel69.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jLabel69, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDisplay.add((Component)this.jPanel2, gridBagConstraints);
        this.panelDisplayScroll.setViewportView(this.panelDisplay);
        this.panelEditor.add((Component)this.panelDisplayScroll, "cardDisplay");
        this.panelImage.setLayout(new GridBagLayout());
        this.jLabel46.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel46, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel46.text"));
        this.jLabel46.setMaximumSize(null);
        this.jLabel46.setMinimumSize(null);
        this.jLabel46.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelImage.add((Component)this.jLabel46, gridBagConstraints);
        this.jLabel54.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel54, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel54.text"));
        this.jLabel54.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelImage.add((Component)this.jLabel54, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        this.fldImageSize.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldImageSize.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel9.add((Component)this.fldImageSize, gridBagConstraints);
        this.jLabel55.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel55, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel55.text"));
        this.jLabel55.setMaximumSize(new Dimension(100, 24));
        this.jLabel55.setMinimumSize(new Dimension(100, 24));
        this.jLabel55.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel9.add((Component)this.jLabel55, gridBagConstraints);
        this.jLabel90.setFont(THEMIS.fontLabel);
        this.jLabel90.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel90, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel90.text"));
        this.jLabel90.setMaximumSize(null);
        this.jLabel90.setMinimumSize(null);
        this.jLabel90.setPreferredSize(new Dimension(100, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel9.add((Component)this.jLabel90, gridBagConstraints);
        this.btnIconRemoveDuplicates2.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnIconRemoveDuplicates2, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnIconRemoveDuplicates2.text"));
        this.btnIconRemoveDuplicates2.setMaximumSize(null);
        this.btnIconRemoveDuplicates2.setMinimumSize(null);
        this.btnIconRemoveDuplicates2.setPreferredSize(null);
        this.btnIconRemoveDuplicates2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnIconRemoveDuplicates2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel9.add((Component)this.btnIconRemoveDuplicates2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelImage.add((Component)this.jPanel9, gridBagConstraints);
        this.jLabel56.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel56, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel56.text"));
        this.jLabel56.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.panelImage.add((Component)this.jLabel56, gridBagConstraints);
        this.sliderImageQuality.setMaximum(10);
        this.sliderImageQuality.setMinorTickSpacing(1);
        this.sliderImageQuality.setPaintLabels(true);
        this.sliderImageQuality.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ProjectSettingsPanel.this.sliderImageQualityStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.panelImage.add((Component)this.sliderImageQuality, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblImageQualityValue, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblImageQualityValue.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.panelImage.add((Component)this.lblImageQualityValue, gridBagConstraints);
        this.jLabel57.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel57, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel57.text"));
        this.jLabel57.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.panelImage.add((Component)this.jLabel57, gridBagConstraints);
        this.buttonGroup1.add(this.chkAddFotoObs);
        this.chkAddFotoObs.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkAddFotoObs, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkAddFotoObs.text"));
        this.chkAddFotoObs.setPreferredSize(new Dimension(107, 20));
        this.chkAddFotoObs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProjectSettingsPanel.this.chkAddFotoObsItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.panelImage.add((Component)this.chkAddFotoObs, gridBagConstraints);
        this.buttonGroup1.add(this.chkAddFotoLoc);
        this.chkAddFotoLoc.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkAddFotoLoc, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkAddFotoLoc.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelImage.add((Component)this.chkAddFotoLoc, gridBagConstraints);
        this.jLabel58.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel58, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel58.text"));
        this.jLabel58.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.panelImage.add((Component)this.jLabel58, gridBagConstraints);
        this.chkImageKeepOriginal.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkImageKeepOriginal, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkImageKeepOriginal.text"));
        this.chkImageKeepOriginal.setMinimumSize(null);
        this.chkImageKeepOriginal.setPreferredSize(new Dimension(250, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.panelImage.add((Component)this.chkImageKeepOriginal, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel70, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel70.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelImage.add((Component)this.jLabel70, gridBagConstraints);
        this.jLabel81.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel81, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel81.text"));
        this.jLabel81.setName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelImage.add((Component)this.jLabel81, gridBagConstraints);
        this.fldPlanSnippetSizeMM.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldPlanSnippetSizeMM.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 104;
        gridBagConstraints.ipady = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelImage.add((Component)this.fldPlanSnippetSizeMM, gridBagConstraints);
        this.jLabel82.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel82, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel82.text"));
        this.jLabel82.setMaximumSize(new Dimension(100, 24));
        this.jLabel82.setMinimumSize(new Dimension(100, 24));
        this.jLabel82.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipady = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelImage.add((Component)this.jLabel82, gridBagConstraints);
        this.jLabel89.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel89, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel89.text"));
        this.jLabel89.setMaximumSize(new Dimension(100, 24));
        this.jLabel89.setMinimumSize(new Dimension(100, 24));
        this.jLabel89.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.panelImage.add((Component)this.jLabel89, gridBagConstraints);
        this.panelEditor.add((Component)this.panelImage, "cardImage");
        this.panelOtherSettings.setLayout(new GridBagLayout());
        this.jLabel74.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel74, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel74.text"));
        this.jLabel74.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelOtherSettings.add((Component)this.jLabel74, gridBagConstraints);
        this.jLabel60.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel60, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel60.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel60, gridBagConstraints);
        this.jLabel53.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel53, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel53.text"));
        this.jLabel53.setMaximumSize(null);
        this.jLabel53.setMinimumSize(null);
        this.jLabel53.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel53, gridBagConstraints);
        this.fldDisplayHideDoneTask.setFont(THEMIS.fontList);
        this.fldDisplayHideDoneTask.setModel(this.modelDisplayDoneTasks);
        this.fldDisplayHideDoneTask.setMaximumSize(null);
        this.fldDisplayHideDoneTask.setMinimumSize(null);
        this.fldDisplayHideDoneTask.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add(this.fldDisplayHideDoneTask, gridBagConstraints);
        this.lblLocList.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblLocList, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblLocList.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.lblLocList, gridBagConstraints);
        this.jLabel73.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel73, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel73.text"));
        this.jLabel73.setMaximumSize(null);
        this.jLabel73.setMinimumSize(null);
        this.jLabel73.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel73, gridBagConstraints);
        this.chkBuildingInLocList.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkBuildingInLocList, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkBuildingInLocList.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.chkBuildingInLocList, gridBagConstraints);
        this.jLabel66.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel66, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel66.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel66, gridBagConstraints);
        this.jLabel100.setFont(THEMIS.fontLabel);
        this.jLabel100.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel100, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel100.text"));
        this.jLabel100.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel100, gridBagConstraints);
        this.chkCreateObservation.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkCreateObservation, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkCreateObservation.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.chkCreateObservation, gridBagConstraints);
        this.jLabel103.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel103, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel103.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel103, gridBagConstraints);
        this.jLabel104.setFont(THEMIS.fontLabel);
        this.jLabel104.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel104, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel104.text"));
        this.jLabel104.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel104, gridBagConstraints);
        this.chkLocationAsFilter.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkLocationAsFilter, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkLocationAsFilter.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.chkLocationAsFilter, gridBagConstraints);
        this.jLabel34.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel34, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel34.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel34, gridBagConstraints);
        this.jLabel21.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel21.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel21, gridBagConstraints);
        this.jLabel20.setFont(THEMIS.fontLabel);
        this.jLabel20.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel20, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel20.text"));
        this.jLabel20.setMaximumSize(null);
        this.jLabel20.setMinimumSize(null);
        this.jLabel20.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel20, gridBagConstraints);
        this.fldPermissionTemplate.setFont(THEMIS.fontTextfield);
        this.fldPermissionTemplate.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldPermissionTemplate.text"));
        this.fldPermissionTemplate.setMaximumSize(null);
        this.fldPermissionTemplate.setMinimumSize(new Dimension(300, 30));
        this.fldPermissionTemplate.setPreferredSize(new Dimension(300, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.panelOtherSettings.add((Component)this.fldPermissionTemplate, gridBagConstraints);
        this.lblLocList1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblLocList1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblLocList1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.lblLocList1, gridBagConstraints);
        this.jLabel80.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel80, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel80.text"));
        this.jLabel80.setMaximumSize(null);
        this.jLabel80.setMinimumSize(null);
        this.jLabel80.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel80, gridBagConstraints);
        this.chkCache.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkCache, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkCache.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.chkCache, gridBagConstraints);
        this.jLabel86.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel86, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel86.text"));
        this.jLabel86.setMaximumSize(null);
        this.jLabel86.setMinimumSize(null);
        this.jLabel86.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel86, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        this.jLabel6.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.jLabel6, gridBagConstraints);
        this.btnSortTemplatesAlphabetically1.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSortTemplatesAlphabetically1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnSortTemplatesAlphabetically1.text"));
        this.btnSortTemplatesAlphabetically1.setBorder(new SoftBevelBorder(0));
        this.btnSortTemplatesAlphabetically1.setPreferredSize(new Dimension(145, 30));
        this.btnSortTemplatesAlphabetically1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnSortTemplatesAlphabetically1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 8;
        gridBagConstraints.ipady = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.btnSortTemplatesAlphabetically1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblColorRemainder, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblColorRemainder.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOtherSettings.add((Component)this.lblColorRemainder, gridBagConstraints);
        this.panelEditor.add((Component)this.panelOtherSettings, "cardDisplayObs");
        this.panelNumbering.setLayout(new GridBagLayout());
        this.jLabel32.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel32, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel32.text"));
        this.jLabel32.setMaximumSize(null);
        this.jLabel32.setMinimumSize(null);
        this.jLabel32.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel32, gridBagConstraints);
        this.jLabel23.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel23, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel23.text"));
        this.jLabel23.setMaximumSize(null);
        this.jLabel23.setMinimumSize(null);
        this.jLabel23.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel35.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel35, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel35.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel35, gridBagConstraints);
        this.fldLocNumberScheme.setFont(THEMIS.fontList);
        this.fldLocNumberScheme.setModel(new DefaultComboBoxModel());
        this.fldLocNumberScheme.setMaximumSize(null);
        this.fldLocNumberScheme.setMinimumSize(null);
        this.fldLocNumberScheme.setPreferredSize(null);
        this.fldLocNumberScheme.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectSettingsPanel.this.fldLocNumberSchemePropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add(this.fldLocNumberScheme, gridBagConstraints);
        this.jLabel24.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel24, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel24.text"));
        this.jLabel24.setMaximumSize(null);
        this.jLabel24.setMinimumSize(null);
        this.jLabel24.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel24, gridBagConstraints);
        this.fldStartnumber.setFont(THEMIS.fontTextfield);
        this.fldStartnumber.setHorizontalAlignment(0);
        this.fldStartnumber.setText(NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.fldStartnumber.text"));
        this.fldStartnumber.setMaximumSize(null);
        this.fldStartnumber.setMinimumSize(new Dimension(100, 30));
        this.fldStartnumber.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.fldStartnumber, gridBagConstraints);
        this.jLabel98.setFont(THEMIS.fontLabel);
        this.jLabel98.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel98, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel98.text"));
        this.jLabel98.setMinimumSize(null);
        this.jLabel98.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelNumbering.add((Component)this.jLabel98, gridBagConstraints);
        this.chkLocNumberIndividual.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkLocNumberIndividual, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.chkLocNumberIndividual.text"));
        this.chkLocNumberIndividual.setHideActionText(true);
        this.chkLocNumberIndividual.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.chkLocNumberIndividual, gridBagConstraints);
        this.jLabel25.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel25, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel25.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel25, gridBagConstraints);
        this.jLabel91.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel91, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel91.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel91, gridBagConstraints);
        this.fldLocSortOrder.setFont(THEMIS.fontList);
        this.fldLocSortOrder.setModel(new DefaultComboBoxModel<String>(new String[]{"nach Pl\u00e4nen", "nach Erstelldatum", "nach Nummer"}));
        this.fldLocSortOrder.setMaximumSize(null);
        this.fldLocSortOrder.setMinimumSize(null);
        this.fldLocSortOrder.setPreferredSize(null);
        this.fldLocSortOrder.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectSettingsPanel.this.fldLocSortOrderPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add(this.fldLocSortOrder, gridBagConstraints);
        this.jLabel94.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel94, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel94.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel94, gridBagConstraints);
        this.jLabel96.setFont(THEMIS.fontLabel);
        this.jLabel96.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel96, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel96.text"));
        this.jLabel96.setPreferredSize(new Dimension(400, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel96, gridBagConstraints);
        this.btnSortLocations.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSortLocations, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnSortLocations.text"));
        this.btnSortLocations.setBorder(new SoftBevelBorder(0));
        this.btnSortLocations.setMaximumSize(null);
        this.btnSortLocations.setMinimumSize(null);
        this.btnSortLocations.setPreferredSize(null);
        this.btnSortLocations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnSortLocationsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.btnSortLocations, gridBagConstraints);
        this.jLabel95.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel95, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel95.text"));
        this.jLabel95.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel95, gridBagConstraints);
        this.jLabel97.setFont(THEMIS.fontLabel);
        this.jLabel97.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel97, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel97.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel97, gridBagConstraints);
        this.btnSortObservations.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSortObservations, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnSortObservations.text"));
        this.btnSortObservations.setBorder(new SoftBevelBorder(0));
        this.btnSortObservations.setMaximumSize(null);
        this.btnSortObservations.setMinimumSize(null);
        this.btnSortObservations.setPreferredSize(null);
        this.btnSortObservations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnSortObservationsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.btnSortObservations, gridBagConstraints);
        this.jLabel59.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel59, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel59.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel59, gridBagConstraints);
        this.jLabel92.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel92, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel92.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel92, gridBagConstraints);
        this.jLabel99.setFont(THEMIS.fontLabel);
        this.jLabel99.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel99, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel99.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.jLabel99, gridBagConstraints);
        this.btnSortTemplatesAlphabetically.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSortTemplatesAlphabetically, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnSortTemplatesAlphabetically.text"));
        this.btnSortTemplatesAlphabetically.setBorder(new SoftBevelBorder(0));
        this.btnSortTemplatesAlphabetically.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnSortTemplatesAlphabeticallyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNumbering.add((Component)this.btnSortTemplatesAlphabetically, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel93, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel93.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelNumbering.add((Component)this.jLabel93, gridBagConstraints);
        this.panelEditor.add((Component)this.panelNumbering, "cardOther");
        this.panelAttributesObservation.setMaximumSize(new Dimension(600, 400));
        this.panelAttributesObservation.setPreferredSize(new Dimension(600, 400));
        this.panelAttributesObservation.setRequestFocusEnabled(false);
        this.panelAttributesObservation.setLayout(new GridBagLayout());
        this.jLabel64.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel64, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel64.text"));
        this.jLabel64.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jLabel64.setMinimumSize(null);
        this.jLabel64.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelAttributesObservation.add((Component)this.jLabel64, gridBagConstraints);
        this.jPanel18.setLayout(new GridBagLayout());
        this.jLabel26.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel26, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel26.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel18.add((Component)this.jLabel26, gridBagConstraints);
        this.fldObservationAttributeCodes1.setMaximumSize(null);
        this.fldObservationAttributeCodes1.setMinimumSize(null);
        this.fldObservationAttributeCodes1.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel18.add(this.fldObservationAttributeCodes1, gridBagConstraints);
        this.btnAddObsvervationAttribute1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddObsvervationAttribute1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnAddObsvervationAttribute1.text"));
        this.btnAddObsvervationAttribute1.setMaximumSize(new Dimension(83, 50));
        this.btnAddObsvervationAttribute1.setMinimumSize(null);
        this.btnAddObsvervationAttribute1.setPreferredSize(null);
        this.btnAddObsvervationAttribute1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnAddObsvervationAttribute1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel18.add((Component)this.btnAddObsvervationAttribute1, gridBagConstraints);
        this.panelHeader1.setBackground(new Color(64, 64, 64));
        this.panelHeader1.setForeground(new Color(64, 64, 64));
        this.panelHeader1.setLayout(new GridBagLayout());
        this.jLabel30.setFont(THEMIS.fontLabelBold);
        this.jLabel30.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.jLabel30, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel30.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 2, 5);
        this.panelHeader1.add((Component)this.jLabel30, gridBagConstraints);
        this.lblType1.setFont(THEMIS.fontLabelBold);
        this.lblType1.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblType1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblType1.text"));
        this.lblType1.setMaximumSize(new Dimension(120, 26));
        this.lblType1.setMinimumSize(new Dimension(120, 26));
        this.lblType1.setPreferredSize(new Dimension(120, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 5, 2, 5);
        this.panelHeader1.add((Component)this.lblType1, gridBagConstraints);
        this.jLabel33.setFont(THEMIS.fontLabelBold);
        this.jLabel33.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.jLabel33, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel33.text"));
        this.jLabel33.setMaximumSize(new Dimension(155, 16));
        this.jLabel33.setMinimumSize(new Dimension(155, 16));
        this.jLabel33.setPreferredSize(new Dimension(155, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 5, 2, 5);
        this.panelHeader1.add((Component)this.jLabel33, gridBagConstraints);
        this.jPanel7.setBackground(new Color(64, 64, 64));
        this.jPanel7.setForeground(new Color(64, 64, 64));
        this.jPanel7.setMaximumSize(null);
        this.jPanel7.setLayout(new GridLayout(1, 3, 5, 0));
        this.btnUp1.setVisible(false);
        this.btnUp1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUp1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnUp1.text"));
        this.btnUp1.setMaximumSize(new Dimension(54, 20));
        this.btnUp1.setMinimumSize(new Dimension(54, 20));
        this.btnUp1.setPreferredSize(new Dimension(50, 20));
        this.btnUp1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnUp1ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.btnUp1);
        this.btnDown1.setVisible(false);
        this.btnDown1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDown1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnDown1.text"));
        this.btnDown1.setMaximumSize(new Dimension(54, 20));
        this.btnDown1.setMinimumSize(new Dimension(54, 20));
        this.btnDown1.setPreferredSize(new Dimension(50, 20));
        this.btnDown1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnDown1ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.btnDown1);
        this.btnRemove1.setVisible(false);
        this.btnRemove1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnRemove1.text"));
        this.btnRemove1.setMaximumSize(new Dimension(54, 20));
        this.btnRemove1.setMinimumSize(new Dimension(54, 20));
        this.btnRemove1.setPreferredSize(new Dimension(50, 20));
        this.btnRemove1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnRemove1ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.btnRemove1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 5, 2, 5);
        this.panelHeader1.add((Component)this.jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel18.add((Component)this.panelHeader1, gridBagConstraints);
        this.panelObservationAttributes1Scroll.getVerticalScrollBar().setUnitIncrement(16);
        this.panelObservationAttributes1Scroll.setMaximumSize(null);
        this.panelObservationAttributes1Scroll.setMinimumSize(null);
        this.panelObservationAttributes1Scroll.setPreferredSize(null);
        this.panelObservationAttributes1.setLayout(new BoxLayout(this.panelObservationAttributes1, 3));
        this.panelObservationAttributes1Scroll.setViewportView(this.panelObservationAttributes1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel18.add((Component)this.panelObservationAttributes1Scroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelAttributesObservation.add((Component)this.jPanel18, gridBagConstraints);
        this.panelEditor.add((Component)this.panelAttributesObservation, "cardAttributesObs");
        this.panelAttriubtesLocation.setRequestFocusEnabled(false);
        this.panelAttriubtesLocation.setLayout(new GridBagLayout());
        this.jLabel40.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel40, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel40.text"));
        this.jLabel40.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelAttriubtesLocation.add((Component)this.jLabel40, gridBagConstraints);
        this.jPanel13.setLayout(new GridBagLayout());
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel7.text"));
        this.jLabel7.setMaximumSize(null);
        this.jLabel7.setMinimumSize(null);
        this.jLabel7.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel13.add((Component)this.jLabel7, gridBagConstraints);
        this.fldLocationAttributeCodes1.setMinimumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel13.add(this.fldLocationAttributeCodes1, gridBagConstraints);
        this.btnAddLocationAttribute1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddLocationAttribute1, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnAddLocationAttribute1.text"));
        this.btnAddLocationAttribute1.setMaximumSize(null);
        this.btnAddLocationAttribute1.setMinimumSize(null);
        this.btnAddLocationAttribute1.setPreferredSize(null);
        this.btnAddLocationAttribute1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnAddLocationAttribute1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel13.add((Component)this.btnAddLocationAttribute1, gridBagConstraints);
        this.panelHeader.setBackground(new Color(64, 64, 64));
        this.panelHeader.setForeground(new Color(64, 64, 64));
        this.panelHeader.setLayout(new GridBagLayout());
        this.lblType.setFont(THEMIS.fontLabelBold);
        this.lblType.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblType, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.lblType.text"));
        this.lblType.setMaximumSize(new Dimension(120, 26));
        this.lblType.setMinimumSize(new Dimension(120, 26));
        this.lblType.setPreferredSize(new Dimension(120, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 2, 5);
        this.panelHeader.add((Component)this.lblType, gridBagConstraints);
        this.jPanel1.setBackground(new Color(64, 64, 64));
        this.jPanel1.setForeground(new Color(64, 64, 64));
        this.jPanel1.setPreferredSize(new Dimension(172, 20));
        this.jPanel1.setLayout(new GridLayout(1, 3, 5, 0));
        this.btnUp.setVisible(false);
        this.btnUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUp, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnUp.text"));
        this.btnUp.setMaximumSize(new Dimension(54, 20));
        this.btnUp.setMinimumSize(new Dimension(54, 20));
        this.btnUp.setPreferredSize(new Dimension(50, 20));
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnUpActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnUp);
        this.btnDown.setVisible(false);
        this.btnDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDown, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnDown.text"));
        this.btnDown.setMaximumSize(new Dimension(54, 20));
        this.btnDown.setMinimumSize(new Dimension(54, 20));
        this.btnDown.setPreferredSize(new Dimension(50, 20));
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnDownActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnDown);
        this.btnRemove.setVisible(false);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnRemove.text"));
        this.btnRemove.setMaximumSize(new Dimension(54, 20));
        this.btnRemove.setMinimumSize(new Dimension(54, 20));
        this.btnRemove.setPreferredSize(new Dimension(50, 20));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnRemove);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 5, 2, 5);
        this.panelHeader.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel27.setFont(THEMIS.fontLabelBold);
        this.jLabel27.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.jLabel27, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel27.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 2, 5);
        this.panelHeader.add((Component)this.jLabel27, gridBagConstraints);
        this.jLabel29.setFont(THEMIS.fontLabelBold);
        this.jLabel29.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.jLabel29, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.jLabel29.text"));
        this.jLabel29.setMaximumSize(new Dimension(155, 16));
        this.jLabel29.setMinimumSize(new Dimension(155, 16));
        this.jLabel29.setPreferredSize(new Dimension(155, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 2, 5);
        this.panelHeader.add((Component)this.jLabel29, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel13.add((Component)this.panelHeader, gridBagConstraints);
        this.panelLocationAttributes1Scroll.getVerticalScrollBar().setUnitIncrement(16);
        this.panelLocationAttributes1Scroll.setMinimumSize(null);
        this.panelLocationAttributes1Scroll.setPreferredSize(null);
        this.panelLocationAttributes1.setLayout(new BoxLayout(this.panelLocationAttributes1, 3));
        this.panelLocationAttributes1Scroll.setViewportView(this.panelLocationAttributes1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel13.add((Component)this.panelLocationAttributes1Scroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelAttriubtesLocation.add((Component)this.jPanel13, gridBagConstraints);
        this.panelEditor.add((Component)this.panelAttriubtesLocation, "cardAttributesLoc");
        this.panelEditorScroll.setViewportView(this.panelEditor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelEditorScroll, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(ProjectSettingsPanel.class, (String)"ProjectSettingsPanel.btnClose.text"));
        this.btnClose.setMinimumSize(new Dimension(200, 30));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectSettingsPanel.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.add((Component)this.btnClose, gridBagConstraints);
    }

    private void lstKeytableValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.showKeytable();
        }
    }

    private void listTopicValueChanged(ListSelectionEvent evt) {
        String topicId;
        if (evt.getValueIsAdjusting()) {
            return;
        }
        ConfigurationTopic topic = (ConfigurationTopic)this.listTopic.getSelectedValue();
        if (!topic.isSelectable()) {
            int idx = this.listTopic.getSelectedIndex() + 1;
            if (idx >= this.listTopic.getModel().getSize()) {
                idx = 0;
            }
            this.listTopic.setSelectedIndex(idx);
            return;
        }
        if (topic.isLazyLoading()) {
            topic.getPanel().populate();
            topic.setLazyLoading(false);
        }
        if ((topicId = topic.getId()) != null) {
            switch (topicId) {
                case "PageKeytables": {
                    this.updateKeytableList();
                    break;
                }
                case "PageObsList": {
                    this.populateObservationDisplayLists(false);
                }
            }
        }
        if (topic.hasPanel()) {
            this.panelEditorScroll.setViewportView(topic.getPanel());
        } else {
            this.panelEditorScroll.setViewportView(this.panelEditor);
            CardLayout cd = (CardLayout)this.panelEditor.getLayout();
            cd.show(this.panelEditor, topic.getPanelName());
        }
    }

    private void lstIconValueChanged(ListSelectionEvent evt) {
        if (this.currentIcon != null && this.currentIcon.isNew() && !Dialogs.getInstance().showConfirmDialog("dialog.confirm-icon-not-saved.text")) {
            return;
        }
        CmsBasicElement sel = this.lstIcon.getSelectedValue();
        if (sel == null) {
            this.currentIcon = null;
        } else if (this.currentIcon == null || this.currentIcon.getId() != sel.getId()) {
            this.currentIcon = (CmsIcon)this.project.loadElement(sel.getId(), this.project.getUser());
        }
        this.showIconElement();
    }

    private void btnAddIconActionPerformed(ActionEvent evt) {
        try {
            List<File> files = new ThemisFileDialog(this.bundle.getString("DIALOG_TITLE_FILECHOOSER"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getIconImportFolder(), null, THEMIS.getImageFilter(), null, true).getSelectedFiles();
            if (files != null && files.size() > 0) {
                this.loadIcons(files);
            }
            return;
        }
        catch (Exception files) {
            long selId = -1L;
            if (this.currentIcon != null) {
                selId = this.currentIcon.getId();
            }
            this.updateIconList(selId);
            this.showIconElement();
            return;
        }
    }

    private void btnRemoveIconActionPerformed(ActionEvent evt) {
        this.removeSelectedIcons();
    }

    private void btnTemplateSaveActionPerformed(ActionEvent evt) {
        SaveSettingsContentPanel p = new SaveSettingsContentPanel();
        p.showDialog();
    }

    private void btnTemplateLoadActionPerformed(ActionEvent evt) {
        try {
            if (this.demo.isNewVersionAvailable()) {
                if (this.app.getDialog().showConfirmDialog("Es stehen neue Vorlagen zum Download zur Verf\u00fcgung. Sollen diese heruntergeladen werden?")) {
                    ThemisTaskWithDialog.createTaskWithCounterAndCancel("Vorlagen werden heruntergeladen", ph -> {
                        this.demo.downloadTemplates(ph);
                        if (!ph.isCancelled()) {
                            this.project.getTemplateManger().readInternalTemplates();
                        }
                    });
                } else {
                    this.demo.setIgnoreNewVersion();
                }
            }
            this.loadTemplateSucessful = true;
            TemplateManager m = this.project.getTemplateManger();
            LoadSettingsPanel p = new LoadSettingsPanel();
            p.showDialog();
            if (p.isLoaded()) {
                this.alreadyPopulated = false;
                this.populate();
            }
        }
        catch (Exception e) {
            Dialogs.getInstance().showErrorDialog(this.bundle.getString("MESSAGE_TEMPLATE_CANNOT_BE_LOADED"), e);
        }
    }

    private void btnTextTemplateAddGroupActionPerformed(ActionEvent evt) {
        this.addTemplate("locationgroup");
    }

    private void btnTextTemplateDeleteActionPerformed(ActionEvent evt) {
        CmsElementSummary sel = this.getSelectedTextTemplate();
        if (sel != null && Dialogs.getInstance().showConfirmDialog(this.bundle.getString("MESSAGE_DELETE_TEMPLATE")) && sel.getId() > 0L) {
            CmsElement ele = sel.getElement();
            this.removeLocationTemplateFromLocationGroupTemplate(ele.getId());
            this.removeObservationTemplateFromLocationGroupTemplate(ele.getId());
            ele.remove();
            this.removeTemplateTreeElement(sel);
        }
    }

    private void btnTemplateDeleteAllActionPerformed(ActionEvent evt) {
        if (Dialogs.getInstance().showConfirmDialog(this.bundle.getString("MESSAGE_DELETE_ALL_TEMPLATES"), this.bundle.getString("MESSAGE_TITLE_DELETE_ALL_TEMPLATES"))) {
            this.project.getDatastorage().executeUpdate("DELETE FROM tdtaelement WHERE elementtype IN ('locationtemplate','observationtemplate','measuretemplate')", true);
            ArrayList locationGroupsInUse = this.project.getDatastorage().getLocationGroupsInUse();
            if (locationGroupsInUse.isEmpty() || Dialogs.getInstance().showConfirmDialog(this.bundle.getString("MESSAGE_DELETE_ALSO_TEMPLATE_GROUP"), this.bundle.getString("MESSAGE_DELETE_ALSO_TEMPLATE_GROUP_TITLE"))) {
                this.project.getDatastorage().executeUpdate("DELETE FROM tdtaelement WHERE elementtype IN ('locationgroup')", true);
            }
            this.updateTemplateTree();
        }
    }

    private void templateTreeValueChanged(TreeSelectionEvent evt) {
        CmsElementSummary sel = this.getSelectedTextTemplate();
        this.panelTextTemplateEdit.removeAll();
        if (sel == null) {
            this.btnTextTemplateAddGroup.setEnabled(this.app.getSettings().getLocationAttribute("group").isUsed());
            this.btnTextTemplateAddLocation.setEnabled(true);
            this.btnTextTemplateAddObservation.setEnabled(true);
            this.btnTextTemplateAddMeasure.setEnabled(false);
            if (this.panelTextTemplateEdit.getComponentCount() > 0) {
                this.panelTextTemplateEdit.remove(0);
            }
            this.panelTextTemplateEdit.revalidate();
        } else {
            CmsElement e = sel.getElement();
            if ("locationgroup".equals(sel.getElementtype())) {
                this.btnTextTemplateAddGroup.setEnabled(this.settings.getLocationAttribute("group").isUsed());
                this.btnTextTemplateAddLocation.setEnabled(true);
                this.btnTextTemplateAddObservation.setEnabled(true);
                this.btnTextTemplateAddMeasure.setEnabled(false);
            } else if ("locationtemplate".equals(sel.getElementtype())) {
                this.btnTextTemplateAddGroup.setEnabled(false);
                this.btnTextTemplateAddLocation.setEnabled(false);
                this.btnTextTemplateAddObservation.setEnabled(true);
                this.btnTextTemplateAddMeasure.setEnabled(false);
            } else if ("observationtemplate".equals(sel.getElementtype())) {
                this.btnTextTemplateAddGroup.setEnabled(false);
                this.btnTextTemplateAddLocation.setEnabled(false);
                this.btnTextTemplateAddObservation.setEnabled(false);
                this.btnTextTemplateAddMeasure.setEnabled(true);
            } else if ("measuretemplate".equals(sel.getElementtype())) {
                this.btnTextTemplateAddGroup.setEnabled(false);
                this.btnTextTemplateAddLocation.setEnabled(false);
                this.btnTextTemplateAddObservation.setEnabled(false);
                this.btnTextTemplateAddMeasure.setEnabled(false);
            } else {
                this.btnTextTemplateAddGroup.setEnabled(false);
                this.btnTextTemplateAddLocation.setEnabled(false);
                this.btnTextTemplateAddObservation.setEnabled(false);
                this.btnTextTemplateAddMeasure.setEnabled(false);
            }
            this.btnTextTemplateDelete.setEnabled(true);
            if ("locationgroup".equals(sel.getElementtype())) {
                LocationgroupPanel p = new LocationgroupPanel((CmsLocationgroup)e);
                this.panelTextTemplateEdit.add((Component)p, "First");
            } else {
                CmsElementPanel p = new CmsElementPanel(e, THEMIS.fontLabel, THEMIS.fontTextfield, THEMIS.fontLabelBigBold);
                this.panelTextTemplateEdit.add((Component)p, "First");
            }
        }
        this.PanelTextTemplateMain.validate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void btnTextTemplateEditSaveActionPerformed(ActionEvent evt) {
        try {
            if (this.panelTextTemplateEdit.getComponentCount() <= 0) return;
            Component c = this.panelTextTemplateEdit.getComponent(0);
            CmsElement element = null;
            boolean isnew = false;
            boolean parentGroupChanged = false;
            if (c == null) {
                return;
            }
            if (c instanceof CmsElementPanel) {
                isnew = ((CmsElementPanel)c).getElement().isNew();
                ((CmsElementPanel)c).updateElement();
                element = ((CmsElementPanel)c).getElement();
            } else if (c instanceof LocationgroupPanel) {
                isnew = ((LocationgroupPanel)c).isNew();
                ((LocationgroupPanel)c).applyPanel();
                element = ((LocationgroupPanel)c).getGroup();
                parentGroupChanged = ((CmsLocationgroup)element).hasParentGroupChanged();
            }
            if (element == null) {
                return;
            }
            boolean saveOk = element.save();
            if (!saveOk) {
                Dialogs.getInstance().showWarningDialog(this.bundle.getString("template_notsaved") + "\n" + element.getStatusmessage());
                return;
            }
            if (isnew) {
                CmsElementSummary sel = this.getSelectedTextTemplate();
                this.insertTemplateTreeElement(new CmsElementSummary(element));
                this.panelTextTemplateEdit.removeAll();
                if (sel == null) {
                    // empty if block
                }
            } else if (parentGroupChanged) {
                this.updateTemplateTree(element.getId());
            } else {
                this.updateTemplateTreeElement(new CmsElementSummary(element));
            }
            this.panelTextTemplateEdit.removeAll();
            this.panelTextTemplateEdit.revalidate();
            THEMIS.dismissNotify(5, THEMIS.notify(5, null, this.bundle.getString("template_saved")));
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnTextTemplateAddObservationActionPerformed(ActionEvent evt) {
        this.addTemplate("observationtemplate");
    }

    private void btnTextTemplateAddLocationActionPerformed(ActionEvent evt) {
        this.addTemplate("locationtemplate");
    }

    private void btnTextTemplateAddMeasureActionPerformed(ActionEvent evt) {
        this.addTemplate("measuretemplate");
    }

    private void templateTreeTreeCollapsed(TreeExpansionEvent evt) {
        this.project.setProjectProperty("system.tree.template", THEMIS.getTreeExpansionState(this.templateTree));
    }

    private void templateTreeTreeExpanded(TreeExpansionEvent evt) {
        this.project.setProjectProperty("system.tree.template", THEMIS.getTreeExpansionState(this.templateTree));
    }

    private void fldLocNumberSchemePropertyChange(PropertyChangeEvent evt) {
    }

    private void btnSortLocationsActionPerformed(ActionEvent evt) {
        int scheme = this.fldLocNumberScheme.getSelectedIndex();
        final int locSort = this.fldLocSortOrder.getSelectedIndex();
        this.project.setProjectProperty("attribute.locnumber.scheme", Integer.toString(scheme));
        String msg = "Die Gegenstandsnummern werden gem\u00e4\u00df der eingestellten Sortierung neu vergeben. Diese Aktion kann nicht r\u00fcckg\u00e4ngig gemacht werden.\nACHTUNG: Wenn Sie bereits Protokolle mit Gegenstandsnummern erstellt haben, passen diese nicht mehr zu den neuen Nummern.\nBest\u00e4tigen Sie durch Eingabe von 'neu', dass die Gegenst\u00e4nde neu nummeriert werden sollen.";
        String r = ThemisApplication.getInstance().getDialog().showInputDialog(msg, "Projekt l\u00f6schen");
        if ("neu".equalsIgnoreCase(r)) {
            ProgressRunnable<String> runner = new ProgressRunnable<String>(){

                public String run(ProgressHandle ph) {
                    ThemisProgressHandler tph = new ThemisProgressHandler(ph);
                    int startnumber = 1;
                    try {
                        startnumber = Integer.parseInt(ProjectSettingsPanel.this.fldStartnumber.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String sqlsort = null;
                    switch (locSort) {
                        case 1: {
                            sqlsort = "l.idelement";
                            break;
                        }
                        case 2: {
                            sqlsort = "l.number,l.idelement desc";
                        }
                    }
                    ProjectSettingsPanel.this.project.updateAllLocationNumbers(startnumber, sqlsort, (ProgressHandler)tph);
                    return null;
                }
            };
            BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)runner, (String)this.bundle.getString("ProjectSettingsPanel.updateLocationNumbers.title"), (boolean)true);
        }
    }

    private void btnSortObservationsActionPerformed(ActionEvent evt) {
        if (Dialogs.getInstance().showConfirmDialog("project.reset-observation-numbers.text", "project.reset-observation-numbers.title")) {
            ProgressRunnable<String> runner = new ProgressRunnable<String>(){

                public String run(ProgressHandle ph) {
                    ThemisProgressHandler tph = new ThemisProgressHandler(ph);
                    ProjectSettingsPanel.this.project.updateObservationNumbers((ProgressHandler)tph);
                    return null;
                }
            };
            BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)runner, (String)this.bundle.getString("ProjectSettingsPanel.updateLocationNumbers.title"), (boolean)true);
        }
    }

    private void colorPointSelectedMouseClicked(MouseEvent evt) {
        this.setColor(evt.getSource());
    }

    private void colorPointMouseClicked(MouseEvent evt) {
        this.setColor(evt.getSource());
    }

    private void colorPointActionPerformed(ActionEvent evt) {
    }

    private void colorLabelBackgroundMouseClicked(MouseEvent evt) {
        this.setColor(evt.getSource());
    }

    private void colorLabelBackgroundActionPerformed(ActionEvent evt) {
    }

    private void fldPointSizeFocusLost(FocusEvent evt) {
        this.fldPointSize.setText(Double.toString(ThemisUtil.validateDouble((String)this.fldPointSize.getText(), (double)30.0, (boolean)true, (String)"Punktgr\u00f6\u00dfe", (boolean)true)));
    }

    private void fldPointSizeActionPerformed(ActionEvent evt) {
    }

    private void fldFontSizeFocusLost(FocusEvent evt) {
        this.fldFontSize.setText(Double.toString(ThemisUtil.validateDouble((String)this.fldFontSize.getText(), (double)14.0, (boolean)true, (String)"Schriftgr\u00f6\u00dfe", (boolean)true)));
    }

    private void fldFontSizeActionPerformed(ActionEvent evt) {
    }

    private void fldIconSizeFocusLost(FocusEvent evt) {
        this.fldIconSize.setText(Double.toString(ThemisUtil.validateDouble((String)this.fldIconSize.getText(), (double)30.0, (boolean)true, (String)"Icon-Gr\u00f6\u00dfe", (boolean)true)));
    }

    private void fldLineSizeFocusLost(FocusEvent evt) {
        this.fldLineSize.setText(Double.toString(ThemisUtil.validateDouble((String)this.fldLineSize.getText(), (double)6.0, (boolean)true, (String)"Linienst\u00e4rke", (boolean)true)));
    }

    private void fldLineSizeActionPerformed(ActionEvent evt) {
    }

    private void fldLabelOffsetXFocusLost(FocusEvent evt) {
    }

    private void fldLabelOffsetXActionPerformed(ActionEvent evt) {
    }

    private void fldLabelOffsetYFocusLost(FocusEvent evt) {
    }

    private void fldLabelOffsetYActionPerformed(ActionEvent evt) {
    }

    private void chkAddFotoObsItemStateChanged(ItemEvent evt) {
    }

    private void btnAddLocationAttribute1ActionPerformed(ActionEvent evt) {
        ThemisAttribute ta = (ThemisAttribute)this.fldLocationAttributeCodes1.getSelectedItem();
        if (ta != null) {
            ta.setUsed(true);
            this.observationListDontDisplay.add(ta);
            this.populateLocationAttributeSettings();
        }
    }

    private void btnAddDisplayActionPerformed(ActionEvent evt) {
        int idx = this.lstObservationAttributes.getSelectedIndex();
        if (idx >= 0) {
            this.observationListDisplay.add(this.observationListDontDisplay.get(idx));
            this.observationListDontDisplay.remove(idx);
            this.populateObservationDisplayLists(false);
            if (idx == this.observationListDontDisplay.size()) {
                --idx;
            }
            this.lstObservationAttributes.setSelectedIndex(idx);
            this.modelObservationDisplay.setSelectedIndex(this.modelObservationDisplay.getModel().getSize() - 1);
        }
    }

    private void btnRemoveDisplayActionPerformed(ActionEvent evt) {
        int idx = this.modelObservationDisplay.getSelectedIndex();
        if (idx >= 0) {
            ThemisAttribute ta = this.observationListDisplay.remove(idx);
            if (ta.isUsed() || ta.isVirtual()) {
                this.observationListDontDisplay.add(ta);
            }
            this.populateObservationDisplayLists(false);
            if (idx == this.observationListDisplay.size()) {
                --idx;
            }
            if (idx >= 0) {
                this.modelObservationDisplay.setSelectedIndex(idx);
            }
        }
    }

    private void btnDisplayDownActionPerformed(ActionEvent evt) {
        int idx = this.modelObservationDisplay.getSelectedIndex();
        int idx2 = this.lstObservationAttributes.getSelectedIndex();
        if (idx >= 0 && idx < this.modelObservationDisplay.getModel().getSize() - 1) {
            Collections.swap(this.observationListDisplay, idx, idx + 1);
            this.populateObservationDisplayLists(false);
            this.modelObservationDisplay.setSelectedIndex(idx + 1);
            this.lstObservationAttributes.setSelectedIndex(idx2);
        }
    }

    private void btnDisplayUpActionPerformed(ActionEvent evt) {
        int idx = this.modelObservationDisplay.getSelectedIndex();
        int idx2 = this.lstObservationAttributes.getSelectedIndex();
        if (idx > 0) {
            Collections.swap(this.observationListDisplay, idx, idx - 1);
            this.populateObservationDisplayLists(false);
            this.modelObservationDisplay.setSelectedIndex(idx - 1);
            this.lstObservationAttributes.setSelectedIndex(idx2);
        }
    }

    private void btnAddObsvervationAttribute1ActionPerformed(ActionEvent evt) {
        ThemisAttribute ta = (ThemisAttribute)this.fldObservationAttributeCodes1.getSelectedItem();
        if (ta != null) {
            ta.setUsed(true);
            this.observationListDontDisplay.add(ta);
            this.populateObservationAttributeSettings();
        }
    }

    private void colorPointSelectedActionPerformed(ActionEvent evt) {
    }

    private void btnUpActionPerformed(ActionEvent evt) {
    }

    private void btnDownActionPerformed(ActionEvent evt) {
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
    }

    private void btnUp1ActionPerformed(ActionEvent evt) {
    }

    private void btnDown1ActionPerformed(ActionEvent evt) {
    }

    private void btnRemove1ActionPerformed(ActionEvent evt) {
    }

    private void btnSortTemplatesAlphabeticallyActionPerformed(ActionEvent evt) {
        this.app.getProject().getDatastorage().executeUpdate("UPDATE tdtaelelocationgroup SET itemsort = null", true);
        this.app.getProject().getDatastorage().executeUpdate("UPDATE tdtaelelocationtemplate SET itemsort = null", true);
        this.app.getProject().getDatastorage().executeUpdate("UPDATE tdtaeleobservationtemplate SET itemsort = null", true);
        this.app.getProject().getDatastorage().executeUpdate("UPDATE tdtaelemeasuretemplate SET itemsort = null", true);
        this.updateTemplateTree();
        Dialogs.getInstance().showInfoDialog("message.settings.templates-resorted");
    }

    private void btnColorBackgroundActionPerformed(ActionEvent evt) {
        this.setColor(this.colorLabelBackground);
    }

    private void btnColorTextActionPerformed(ActionEvent evt) {
        this.setTextColor(this.colorLabelBackground);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.setColor(this.colorPoint);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.setColor(this.colorPointSelected);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.apply();
        this.closeDialog();
    }

    private void fldDisplayColorSelectionItemStateChanged(ItemEvent evt) {
        if (this.initialisingColorDisplay) {
            return;
        }
        ColorOption co = (ColorOption)this.fldDisplayColorSelection.getSelectedItem();
        if (co == null) {
            return;
        }
        switch (co.getMethod()) {
            case STATIC: {
                this.jLabel48.setVisible(true);
                this.colorLabelBackground.setVisible(true);
                this.btnColorBackground.setVisible(true);
                this.btnColorText.setVisible(true);
                break;
            }
            case NOCOLOR: {
                this.jLabel48.setVisible(true);
                this.colorLabelBackground.setVisible(false);
                this.btnColorBackground.setVisible(false);
                this.btnColorText.setVisible(true);
                break;
            }
            default: {
                this.jLabel48.setVisible(false);
                this.colorLabelBackground.setVisible(false);
                this.btnColorBackground.setVisible(false);
                this.btnColorText.setVisible(false);
            }
        }
    }

    private void btnIconRemoveDuplicatesActionPerformed(ActionEvent evt) {
        this.removeIconDuplicates();
    }

    private void sliderImageQualityStateChanged(ChangeEvent evt) {
        this.lblImageQualityValue.setText(this.sliderImageQuality.getValue() * 10 + "%");
    }

    private void chkPlanMoveIconWithLabelItemStateChanged(ItemEvent evt) {
        if (this.chkPlanMoveIconWithLabel.isSelected()) {
            this.fldLabelOffsetX.setEnabled(true);
            this.fldLabelOffsetY.setEnabled(true);
            float iconsize = Util.parseFloat((String)this.fldIconSize.getText(), (float)-1.0f);
            if ("".equals(this.fldLabelOffsetX.getText()) && iconsize > 0.0f) {
                this.fldLabelOffsetX.setText(Float.toString(iconsize));
                this.fldLabelOffsetY.setText(Float.toString(iconsize / 2.0f));
            }
        } else {
            this.fldLabelOffsetX.setEnabled(false);
            this.fldLabelOffsetY.setEnabled(false);
        }
    }

    private void fldLocSortOrderPropertyChange(PropertyChangeEvent evt) {
    }

    private void btnSortTemplatesAlphabetically1ActionPerformed(ActionEvent evt) {
        ThemisProjectStatus status = new ThemisProjectStatus();
        ThemisTaskWithDialog.createTask(ThemisApplication.getInstance().getProject().getResourceText("task.check-project-structure"), ph -> status.setUploadStatus(ThemisUtil.checkUploadFileStatus((ProgressHandler)ph)));
        if (status.hasUploadIssues()) {
            ArrayList<String> infos = new ArrayList<String>();
            if (status.countMissingUploads() > 0) {
                infos.add("Fehlende Dateien: " + status.countMissingUploads());
            }
            if (status.countMoveUploads() > 0) {
                infos.add("Speicherort korrigieren: " + status.countMoveUploads());
            }
            if (status.countNotUsedUploads() > 0) {
                infos.add("Nicht verwendet: " + status.countNotUsedUploads());
            }
            if (status.countErrorUploads() > 0) {
                infos.add("Mit Fehler: " + status.countErrorUploads());
            }
            infos.add("Soll die Korrektur durchgef\u00fchrt werden?");
            String info = String.join((CharSequence)"\n", infos);
            if (Dialogs.getInstance().showConfirmDialog(info)) {
                ThemisTaskWithDialog.createTaskWithCounterAndCancel(ThemisApplication.getInstance().getProject().getResourceText("task.update-project-structure.title"), ph -> ThemisUtil.updateUploadFiles((boolean)true, (ProgressHandler)ph));
            }
        } else {
            Dialogs.getInstance().showInfoDialog("Keine Aktualisierung erforderlich");
        }
    }

    private void btnIconRemoveDuplicates1ActionPerformed(ActionEvent evt) {
        ArrayList files = ThemisUtil.getIconFiles((ThemisFolder)this.project.getThemisFile(), (int)100);
        if (files.size() > 0) {
            if (Dialogs.getInstance().showConfirmDialog("Sollen " + files.size() + " Icons korrigiert werden?")) {
                ThemisUtil.updateImage((ArrayList)files, (int)100, (float)70.0f, null);
            }
        } else {
            Dialogs.getInstance().showInfoDialog("Keine Aktualisierung erforderlich");
        }
    }

    private void btnIconRemoveDuplicates2ActionPerformed(ActionEvent evt) {
        int pixel = this.app.getSettings().getImageUploadSize();
        float quality = this.app.getSettings().getImageUploadQuality();
        ArrayList files = ThemisUtil.getImageFiles((ThemisFolder)this.project.getThemisFile(), (int)pixel);
        if (files.size() > 0) {
            if (Dialogs.getInstance().showConfirmDialog("Sollen " + files.size() + " Bilder korrigiert werden?")) {
                ThemisTaskWithDialog.createTaskWithCounterAndCancel("Bilder pr\u00fcfen und korrigieren", ph -> ThemisUtil.updateImage((ArrayList)files, (int)pixel, (float)(100.0f * quality), (ProgressHandler)ph));
            }
        } else {
            Dialogs.getInstance().showInfoDialog("Keine Aktualisierung erforderlich");
        }
    }

    private void fldIconfilterActionPerformed(ActionEvent evt) {
        this.updateIconList(this.lstIcon.getSelectedIndex());
    }

    private void btnIconFilterOkActionPerformed(ActionEvent evt) {
        this.updateIconList(this.lstIcon.getSelectedIndex());
    }

    private void btnIconFilterClearActionPerformed(ActionEvent evt) {
        this.fldIconfilter.setText("");
        this.updateIconList(this.lstIcon.getSelectedIndex());
    }

    private void chkPlanLargeBufferItemStateChanged(ItemEvent evt) {
    }

    private void btnTemplateExportActionPerformed(ActionEvent evt) {
        try {
            File f = new ThemisFileDialog(this.app.getProject().getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.SAVE, this.app.getSettings().getTemplateFile(), null, new FileNameExtensionFilter("Textbausteine", "xlsx"), null, false).getSelectedFile();
            if (f != null) {
                File fExport;
                String fn = f.getName();
                if (!fn.toLowerCase().endsWith(".xlsx")) {
                    fn = fn.toLowerCase().endsWith(".xls") ? fn + "x" : fn + ".xlsx";
                }
                if ((fExport = new File(f.getParentFile(), fn)).isDirectory()) {
                    Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/config/Bundle").getString("MESSAGE_TEMPLATE_CANNOT_BE_SAVED"));
                    return;
                }
                this.app.getSettings().setTemplateFile(fExport);
                ThemisTaskWithDialog.createTaskWithCancel(this.bundle.getString("MESSAGE_SAVING_TEMPLATE"), ph -> {
                    try {
                        TemplateManager m = this.project.getTemplateManger();
                        boolean success = m.saveTextTemplates(fExport);
                        this.setCursor(Cursor.getDefaultCursor());
                        if (success) {
                            THEMIS.showFileResultDialog(fExport);
                        } else {
                            Dialogs.getInstance().showErrorDialog(this.bundle.getString("MESSAGE_CANNOT_CREATE_FILE"));
                        }
                    }
                    catch (Exception e) {
                        this.project.getLogger().severe("Error while creating the template file: " + e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            Dialogs.getInstance().showErrorDialog(this.bundle.getString("MESSAGE_CANNOT_CREATE_FILE"), e);
        }
    }

    @Override
    public String getDialogCode() {
        return "projectsettings";
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(1050, 700);
    }

    class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }

    class ThemisTreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof CmsElementSummary) {
                CmsElementSummary e = (CmsElementSummary)node.getUserObject();
                if (null == e.getElementtype()) {
                    this.setIcon(ProjectSettingsPanel.this.iconFolder);
                } else {
                    block6 : switch (e.getElementtype()) {
                        case "locationgroup": {
                            this.setIcon(ProjectSettingsPanel.this.iconFolder);
                            break;
                        }
                        case "locationtemplate": {
                            this.setIcon(ProjectSettingsPanel.this.iconLoc);
                            break;
                        }
                        case "observationtemplate": {
                            String obstype = ProjectSettingsPanel.this.project.getDatastorage().getElementAttribute(e.getId(), "type");
                            if ("".equals(obstype)) {
                                obstype = null;
                            }
                            int obstypeInt = obstype == null ? -1 : Integer.parseInt(obstype);
                            switch (obstypeInt) {
                                case 2: {
                                    this.setIcon(ProjectSettingsPanel.this.iconObsCheck);
                                    break block6;
                                }
                                case 1: {
                                    this.setIcon(ProjectSettingsPanel.this.iconObsDefect);
                                    break block6;
                                }
                                case 3: {
                                    this.setIcon(ProjectSettingsPanel.this.iconObsInfo);
                                    break block6;
                                }
                                case 4: {
                                    this.setIcon(ProjectSettingsPanel.this.iconObsTask);
                                    break block6;
                                }
                            }
                            this.setIcon(ProjectSettingsPanel.this.iconObs);
                            break;
                        }
                        case "measuretemplate": {
                            this.setIcon(ProjectSettingsPanel.this.iconMeas);
                            break;
                        }
                        default: {
                            this.setIcon(ProjectSettingsPanel.this.iconFolder);
                        }
                    }
                }
            }
            return this;
        }
    }

    class SettingsDnDListener
    implements DropTargetListener {
        SettingsDnDListener() {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            DataFlavor[] flavors;
            event.acceptDrop(1);
            Transferable transferable = event.getTransferable();
            for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                try {
                    if (!flavor.isFlavorJavaFileListType()) continue;
                    List files = (List)transferable.getTransferData(flavor);
                    ProjectSettingsPanel.this.loadIcons(files);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            event.dropComplete(true);
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }
}

