/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.config;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisFile;
import at.grid.util.ProgressHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SaveSettingsContentPanel
extends ThemisPanel {
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/config/Bundle");
    private JButton btnCancel;
    private JButton btnLoad;
    private JButton btnSetAll;
    private JButton btnSetNone;
    private JCheckBox chkContacts;
    private JCheckBox chkDocuments;
    private JCheckBox chkForms;
    private JCheckBox chkIcons;
    private JCheckBox chkLists;
    private JCheckBox chkReportTemplates;
    private JCheckBox chkSettings;
    private JCheckBox chkTemplates;
    private JLabel jLabel104;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblChoose;

    public SaveSettingsContentPanel() {
        this.initComponents();
        THEMIS.setCheckboxIcon(this.chkContacts, this.chkDocuments, this.chkForms, this.chkIcons, this.chkLists, this.chkReportTemplates, this.chkSettings, this.chkTemplates);
    }

    @Override
    public void populate(ProgressHandler ph) {
        this.setAll(true);
        this.setAllEnabled(true);
    }

    @Override
    public void apply() {
        this.app.getSettings().setTemplateUseTexts(this.chkTemplates.isSelected());
        this.app.getSettings().setTemplateUseLists(this.chkLists.isSelected());
        this.app.getSettings().setTemplateUseIcons(this.chkIcons.isSelected());
        this.app.getSettings().setTemplateUseReportTemplates(this.chkReportTemplates.isSelected());
        this.app.getSettings().setTemplateUseForms(this.chkForms.isSelected());
        this.app.getSettings().setTemplateUseSettings(this.chkSettings.isSelected());
        this.app.getSettings().setTemplateUseContacts(this.chkContacts.isSelected());
        this.app.getSettings().setTemplateUseDocuments(this.chkDocuments.isSelected());
    }

    public void setAll(boolean flg) {
        this.chkTemplates.setSelected(flg);
        this.chkIcons.setSelected(flg);
        this.chkForms.setSelected(flg);
        this.chkSettings.setSelected(flg);
        this.chkLists.setSelected(flg);
        this.chkContacts.setSelected(flg);
        this.chkDocuments.setSelected(flg);
        this.chkReportTemplates.setSelected(flg);
    }

    public void setAllEnabled(boolean flg) {
        this.chkTemplates.setEnabled(flg);
        this.chkIcons.setEnabled(flg);
        this.chkForms.setEnabled(flg);
        this.chkSettings.setEnabled(flg);
        this.chkLists.setEnabled(flg);
        this.chkContacts.setEnabled(flg);
        this.chkDocuments.setEnabled(flg);
        this.chkReportTemplates.setEnabled(flg);
    }

    private void saveTemplate() {
        File f = new ThemisFileDialog(this.app.getProject().getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.SAVE, this.app.getSettings().getTemplateFile(), null, new FileNameExtensionFilter("Projektvorlage", "themis"), null, false).getSelectedFile();
        if (f != null) {
            File fImport;
            String fn = f.getName();
            if (!fn.toLowerCase().endsWith(".themis")) {
                fn = fn + ".themis";
            }
            if ((fImport = new File(f.getParentFile(), fn)).isDirectory()) {
                Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/config/Bundle").getString("MESSAGE_TEMPLATE_CANNOT_BE_SAVED"));
                return;
            }
            this.app.getSettings().setTemplateFile(fImport);
            ThemisTaskWithDialog.createTaskWithCancel(this.bundle.getString("MESSAGE_SAVING_TEMPLATE"), ph -> {
                try {
                    boolean success = false;
                    ThemisFile tf = new ThemisFile().setAsProjectTemplate().setWithSettings(this.chkSettings.isSelected()).setWithTemplates(this.chkTemplates.isSelected()).setWithKeytables(this.chkLists.isSelected()).setWithIcons(this.chkIcons.isSelected()).setWithDocuments(this.chkDocuments.isSelected()).setWithContacts(this.chkContacts.isSelected()).setWithReportTemplates(this.chkReportTemplates.isSelected()).setWithForms(this.chkForms.isSelected());
                    try {
                        success = tf.saveToFile(f, true);
                    }
                    catch (IOException ex) {
                        this.app.getDialog().showErrorDialog("Datei kann nicht gespeichert werden: " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    if (success) {
                        THEMIS.showFileResultDialog(fImport, false);
                    } else {
                        Dialogs.getInstance().showErrorDialog(this.bundle.getString("MESSAGE_CANNOT_CREATE_FILE"));
                    }
                }
                catch (Exception e) {
                    this.project.getLogger().severe("Error while creating the template file: " + e.getMessage());
                }
            });
        }
    }

    private void initComponents() {
        this.lblChoose = new JLabel();
        this.jLabel104 = new JLabel();
        this.jPanel3 = new JPanel();
        this.btnSetAll = new JButton();
        this.btnSetNone = new JButton();
        this.chkTemplates = new JCheckBox();
        this.chkIcons = new JCheckBox();
        this.chkReportTemplates = new JCheckBox();
        this.chkContacts = new JCheckBox();
        this.chkDocuments = new JCheckBox();
        this.chkForms = new JCheckBox();
        this.chkLists = new JCheckBox();
        this.chkSettings = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.btnLoad = new JButton();
        this.btnCancel = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.lblChoose.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblChoose, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.lblChoose.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblChoose, gridBagConstraints);
        this.jLabel104.setFont(THEMIS.fontLabel);
        this.jLabel104.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel104, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.jLabel104.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel104, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnSetAll.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetAll, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.btnSetAll.text"));
        this.btnSetAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveSettingsContentPanel.this.btnSetAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnSetAll, gridBagConstraints);
        this.btnSetNone.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetNone, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.btnSetNone.text"));
        this.btnSetNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveSettingsContentPanel.this.btnSetNoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnSetNone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.chkTemplates.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkTemplates, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.chkTemplates.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkTemplates, gridBagConstraints);
        this.chkIcons.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkIcons, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.chkIcons.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkIcons, gridBagConstraints);
        this.chkReportTemplates.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkReportTemplates, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.chkReportTemplates.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkReportTemplates, gridBagConstraints);
        this.chkContacts.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkContacts, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.chkContacts.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkContacts, gridBagConstraints);
        this.chkDocuments.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkDocuments, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.chkDocuments.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkDocuments, gridBagConstraints);
        this.chkForms.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkForms, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.chkForms.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkForms, gridBagConstraints);
        this.chkLists.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkLists, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.chkLists.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkLists, gridBagConstraints);
        this.chkSettings.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkSettings, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.chkSettings.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.chkSettings, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnLoad.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnLoad, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.btnLoad.text"));
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveSettingsContentPanel.this.btnLoadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.btnLoad, gridBagConstraints);
        this.btnCancel.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(SaveSettingsContentPanel.class, (String)"SaveSettingsContentPanel.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveSettingsContentPanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void btnSetAllActionPerformed(ActionEvent evt) {
        this.setAll(true);
    }

    private void btnSetNoneActionPerformed(ActionEvent evt) {
        this.setAll(false);
    }

    private void btnLoadActionPerformed(ActionEvent evt) {
        this.saveTemplate();
        this.closeDialog();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(520, 530);
    }
}

