/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.config;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.ontology.ThemisColor;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.server.ThemisCloudServer;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import com.sun.management.OperatingSystemMXBean;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SystemSettingsPanel
extends ThemisPanel {
    Properties conf = new Properties();
    private DefaultComboBoxModel<String> modelRepeat = new DefaultComboBoxModel();
    private DefaultComboBoxModel<String> modelUpdate = new DefaultComboBoxModel();
    private DefaultListModel<String> modelObsAttributes = new DefaultListModel();
    private DefaultListModel<String> modelLocAttributes = new DefaultListModel();
    private DefaultListModel<String> modelObsDisplay = new DefaultListModel();
    private DefaultListModel<String> modelLocDisplay = new DefaultListModel();
    private DefaultListModel<String> modelChecklistAttributes = new DefaultListModel();
    private DefaultListModel<String> modelChecklistDisplay = new DefaultListModel();
    public static final int GENERAL = 1;
    public static final int ATTRIBUTEDISPLAY = 4;
    public static final int NOTIFICATION = 8;
    public static final int ATTRIBUTES = 9;
    public static final int LOCATIONLIST = 10;
    public static final int UPDATE = 11;
    public static final int EMAIL = 12;
    public static final int SYSTEM = 13;
    public static final int COLOR = 15;
    public static final int STANDARDS = 16;
    ArrayList<String> observationListDisplay = new ArrayList();
    ArrayList<String> observationListDontDisplay = new ArrayList();
    ArrayList<String> locationListDisplay = new ArrayList();
    ArrayList<String> locationListDontDisplay = new ArrayList();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/config/Bundle");
    private boolean currentSettingShowStartScreen = false;
    private JButton btnChooseLogo;
    private JButton btnChooseLogo1;
    private JButton btnClose;
    private JButton btnSetUpdateDirectory;
    private JButton btnSetUploadFolder;
    private JButton btnSetUploadFolderReset;
    private JButton btnUpdateResetCheck;
    private ButtonGroup buttonGroup1;
    private JCheckBox chkMonthlyBackup;
    private JCheckBox chkMovelLabel;
    private JCheckBox chkNotificationDueTasks;
    private JCheckBox chkNotificationNetworkDrive;
    private JCheckBox chkNotificationNoEventInfo;
    private JCheckBox chkNotificationShowStartScreen;
    private JCheckBox chkSimpleEditor;
    private JCheckBox chkUseIntegratedJava;
    private JTextField colorObsChecked;
    private JTextField colorObsSelect;
    private JTextField fieldRAM;
    private JTextField fldDisplayTextareaRows;
    private JTextField fldDuePeriodCount;
    private JComboBox fldDuePeriodUnit;
    private JComboBox<String> fldEmailEncrypt;
    private JTextField fldEmailFrom;
    private JTextField fldEmailImap;
    private JComboBox<String> fldEmailImapEncrypt;
    private JTextField fldEmailImapPort;
    private JTextField fldEmailPort;
    private JTextField fldEmailSmtp;
    private JComboBox<String> fldLanguage;
    private JTextField fldLogo;
    private JTextField fldServerCode;
    private JComboBox<String> fldUpdate;
    private JTextField fldUpdateDirectory;
    private JComboBox<String> fldUpdateMethod;
    private JTextField fldUploadFolder;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel4;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel52;
    private JLabel jLabel53;
    private JLabel jLabel54;
    private JLabel jLabel55;
    private JLabel jLabel6;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel65;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JLabel lblColorRemainder;
    private JLabel lblPeriod;
    private JLabel lblRestart;
    private JLabel lblUpdateNextCheck;
    private JList listTopic;
    private JPanel panelColors;
    private JPanel panelEditor;
    private JPanel panelEmail;
    private JPanel panelEmpty;
    private JPanel panelGeneral;
    private JPanel panelNotification;
    private JPanel panelStandards;
    private JPanel panelSystem;
    private JPanel panelUpdate;
    private JPanel panelUpdateDirectory;
    private JSlider sliderRAM;

    public SystemSettingsPanel() {
        this.initComponents();
        this.listTopic.setCellRenderer(new SimpleTextRenderer());
        DefaultListModel topicModel = (DefaultListModel)this.listTopic.getModel();
        topicModel.addElement(new ConfigurationTopic(16, this.bundle.getString("SECTION_STANDARDS")));
        topicModel.addElement(new ConfigurationTopic(1, this.bundle.getString("SECTION_OTHER_SETTINGS")));
        topicModel.addElement(new ConfigurationTopic(8, this.bundle.getString("SECTION_MESSAGES")));
        topicModel.addElement(new ConfigurationTopic(11, this.bundle.getString("SECTION_UPDATE")));
        topicModel.addElement(new ConfigurationTopic(15, this.bundle.getString("SECTION_COLOR")));
        topicModel.addElement(new ConfigurationTopic(13, this.bundle.getString("SECTION_SYSTEM")));
        topicModel.addElement(new ConfigurationTopic(12, this.bundle.getString("SECTION_EMAIL")));
        this.loadDropDownList(this.modelRepeat, this.bundle.getString("SystemSettingsPanel.repeatList.text"), false);
        this.loadDropDownList(this.modelUpdate, this.bundle.getString("SystemSettingsPanel.updateOptions.text"), false);
        ThemisLicense license = this.app.getLicense();
        boolean allowBeta = license.hasFeature("beta");
        if (allowBeta || license.isInternalLicense()) {
            this.modelUpdate.addElement("THEMIS Beta-Version");
        }
        if (license.isInternalLicense()) {
            this.modelUpdate.addElement("THEMIS Intern");
        }
        this.populate();
        this.listTopic.setSelectedIndex(0);
        THEMIS.setCheckboxIcon(this.chkMonthlyBackup, this.chkMovelLabel, this.chkNotificationDueTasks, this.chkNotificationNetworkDrive, this.chkNotificationNoEventInfo, this.chkNotificationShowStartScreen, this.chkSimpleEditor, this.chkUseIntegratedJava);
        this.chkSimpleEditor.setVisible(allowBeta);
    }

    @Override
    public void populate(ProgressHandler ph) {
        this.fldUploadFolder.setText(this.app.getSettings().getFolderImageObserver().toString());
        this.fldServerCode.setText(this.app.getSettings().getDefaultThemisServerCode());
        ArrayList<String> atts = THEMIS.getObservationTableColumnsAll();
        ArrayList<String> atts2 = THEMIS.getLocationTableColumnCodesAll();
        this.observationListDisplay.clear();
        this.observationListDontDisplay.clear();
        this.locationListDisplay.clear();
        this.locationListDontDisplay.clear();
        for (String att : atts) {
            if (this.observationListDisplay.contains(att)) continue;
            this.observationListDontDisplay.add(att);
        }
        this.locationListDisplay.addAll(this.project.getLocationTableColumnCodes());
        for (String att : atts2) {
            if (this.locationListDisplay.contains(att)) continue;
            this.locationListDontDisplay.add(att);
        }
        ThemisColor tc = this.app.getSettings().getObservationColorChecked();
        this.colorObsChecked.setBackground(tc.getBackground());
        this.colorObsChecked.setForeground(tc.getForeground());
        this.colorObsChecked.setDisabledTextColor(tc.getForeground());
        tc = this.app.getSettings().getObservationColorSelect();
        this.colorObsSelect.setBackground(tc.getBackground());
        this.colorObsSelect.setForeground(tc.getForeground());
        this.colorObsSelect.setDisabledTextColor(tc.getForeground());
        this.chkMovelLabel.setSelected("yes".equalsIgnoreCase(this.app.getConfiguration("display.avoid-moving-of-label", "no")));
        this.fldDisplayTextareaRows.setText(Integer.toString(this.app.getSettings().getDisplayTextareaSize()));
        this.chkSimpleEditor.setSelected("yes".equals(this.app.getConfiguration("interface.simple-editor", "no")));
        String[] appointment = this.app.getAppointmentInfo();
        this.fldDuePeriodCount.setText(appointment[0]);
        int idxUnit = Integer.parseInt(appointment[1]) - 1;
        if (idxUnit < 0) {
            idxUnit = 0;
        }
        this.fldDuePeriodUnit.setSelectedIndex(idxUnit);
        this.chkMonthlyBackup.setSelected(this.app.getSettings().getDoMonthlyDatabaseBackup());
        this.chkNotificationNoEventInfo.setSelected(this.app.getSettings().getNotificationNoEventInfo());
        this.chkNotificationDueTasks.setSelected(this.app.getSettings().getNotificationDueTasks());
        this.chkNotificationShowStartScreen.setSelected(this.app.getSettings().getNotificationShowStartScreen());
        this.currentSettingShowStartScreen = this.app.getSettings().getNotificationShowStartScreen();
        this.chkNotificationNetworkDrive.setSelected(this.app.getSettings().getNotificationNetworkDrive());
        this.fldLanguage.setSelectedItem(this.app.getConfiguration("system.language", "Deutsch"));
        this.fldUpdateDirectory.setText(this.app.getPathUpdateFolder().getAbsolutePath());
        int idx = 0;
        try {
            idx = Integer.parseInt(this.app.getConfiguration("system.update.source.selection", "0"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (idx < this.fldUpdate.getItemCount()) {
            this.fldUpdate.setSelectedIndex(idx);
        }
        switch (this.app.getSettings().getUpdateMethod()) {
            case MODULE: {
                this.fldUpdateMethod.setSelectedIndex(1);
                break;
            }
            default: {
                this.fldUpdateMethod.setSelectedIndex(0);
            }
        }
        Date dt = this.app.getSettings().getUpdatePauseUntil();
        if (dt != null && dt.after(new Date())) {
            this.lblUpdateNextCheck.setText(Util.formatDate((Date)dt, (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone()));
        } else {
            this.lblUpdateNextCheck.setText("-");
        }
        this.fldEmailSmtp.setText(this.settings.getEmailSmtp());
        this.fldEmailFrom.setText(this.settings.getEmailFrom());
        this.fldEmailPort.setText(Integer.toString(this.settings.getEmailPort()));
        int sel = this.settings.getEmailEncrypt();
        if (sel >= 0) {
            this.fldEmailEncrypt.setSelectedIndex(sel);
        } else {
            this.fldEmailEncrypt.setSelectedIndex(0);
        }
        this.fldEmailImap.setText("");
        this.fldEmailImapPort.setText("");
        sel = -1;
        if (sel >= 0) {
            this.fldEmailImapEncrypt.setSelectedIndex(sel);
        } else {
            this.fldEmailImapEncrypt.setSelectedIndex(0);
        }
        Runtime runtime = Runtime.getRuntime();
        int mb = 0x100000;
        boolean minCores = true;
        int maxCores = runtime.availableProcessors();
        long minMem = 1024L;
        long maxMem = runtime.maxMemory() / (long)mb;
        try {
            maxMem = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / (long)mb;
        }
        catch (Exception exception) {
            // empty catch block
        }
        maxMem = maxMem > 4000L ? (maxMem -= 1500L) : (maxMem -= 1024L);
        maxMem = Math.max(maxMem, 1024L);
        long currentMem = Long.valueOf(this.app.getConfiguration("system.system.ram", maxMem > 3000L ? "1650" : "1024"));
        int minorTick = 128;
        int majorTick = 1024;
        if (maxMem > 15000L) {
            minorTick = 512;
            majorTick = 4096;
        }
        this.sliderRAM.setMinimum((int)minMem);
        this.sliderRAM.setMaximum((int)maxMem);
        this.sliderRAM.setMajorTickSpacing(majorTick);
        this.sliderRAM.setMinorTickSpacing(minorTick);
        this.sliderRAM.setValue((int)currentMem);
        this.sliderRAM.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    int newMem = source.getValue();
                    SystemSettingsPanel.this.fieldRAM.setText(newMem + " MB");
                    SystemSettingsPanel.this.lblRestart.setVisible(true);
                }
            }
        });
        this.fieldRAM.setBorder(BorderFactory.createEmptyBorder());
        this.fieldRAM.setText(currentMem + " MB");
        this.fieldRAM.setEditable(false);
        this.lblRestart.setVisible(false);
        boolean useIntegratedJava = this.app.getConfiguration("system.system.useInegratedJava", "true").equals("true");
        this.chkUseIntegratedJava.setSelected(useIntegratedJava);
        this.chkUseIntegratedJava.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SystemSettingsPanel.this.lblRestart.setVisible(true);
            }
        });
        this.fldLogo.setText(this.app.getConfiguration("system.project.logo", ""));
    }

    private void loadDropDownList(DefaultComboBoxModel<String> model, String records, boolean withNone) {
        String[] recordArray = records.split(",");
        if (withNone) {
            model.addElement("-");
        }
        for (String record : recordArray) {
            model.addElement(record);
        }
    }

    public boolean verifyApply() {
        ThemisCloudServer server;
        return "".equals(this.fldServerCode.getText().trim()) || (server = ThemisCloudServer.fromCode((String)this.fldServerCode.getText())) != null;
    }

    @Override
    public void apply() {
        Properties propsApp = new Properties();
        Properties propsProject = new Properties();
        ArrayList locCols = this.project.getLocationTableColumns();
        ArrayList<String> locColsAll = THEMIS.getLocationTableColumnsAll();
        ArrayList<String> newLocCols = new ArrayList<String>();
        boolean found = false;
        block3: for (String code : this.locationListDisplay) {
            found = false;
            for (String col : locCols) {
                if (!col.startsWith(code + ":")) continue;
                newLocCols.add(col);
                found = true;
                break;
            }
            if (found) continue;
            for (String col : locColsAll) {
                if (!col.startsWith(code + ":")) continue;
                newLocCols.add(col);
                found = true;
                continue block3;
            }
        }
        this.app.getSettings().setDoMonthlyDatabaseBackup(this.chkMonthlyBackup.isSelected());
        this.app.getSettings().setDisplayTextareaSize(Util.parseInt((String)this.fldDisplayTextareaRows.getText(), (int)7));
        this.app.getSettings().setNotificationNoEventInfo(this.chkNotificationNoEventInfo.isSelected());
        this.app.getSettings().setNotificationDueTasks(this.chkNotificationDueTasks.isSelected());
        this.app.getSettings().setNotificationShowStartScreen(this.chkNotificationShowStartScreen.isSelected());
        this.app.getSettings().setNotificationNetworkDrive(this.chkNotificationNetworkDrive.isSelected());
        this.app.getSettings().getFolderImageObserver().setValue(this.fldUploadFolder.getText().trim());
        this.app.getSettings().setDefaultThemisServerCode(this.fldServerCode.getText());
        propsApp.setProperty("system.language", (String)this.fldLanguage.getSelectedItem());
        if (this.lblUpdateNextCheck.getText().equals("-")) {
            this.app.getSettings().setUpdatePauseUntil(0);
        }
        switch (this.fldUpdateMethod.getSelectedIndex()) {
            case 1: {
                this.app.getSettings().setUpdateMethod(ThemisSettings.UpdateMethod.MODULE);
                break;
            }
            default: {
                this.app.getSettings().setUpdateMethod(ThemisSettings.UpdateMethod.INSTALLER);
            }
        }
        propsApp.setProperty("system.update.source", this.fldUpdateDirectory.getText().trim());
        propsApp.setProperty("system.update.source.selection", Integer.toString(this.fldUpdate.getSelectedIndex()));
        propsProject.setProperty("display.avoid-moving-of-label", this.chkMovelLabel.isSelected() ? "yes" : "no");
        propsProject.setProperty("interface.simple-editor", this.chkSimpleEditor.isSelected() ? "yes" : "no");
        this.settings.setEmail(this.fldEmailSmtp.getText(), this.fldEmailPort.getText(), this.fldEmailEncrypt.getSelectedIndex(), this.fldEmailFrom.getText(), "");
        propsApp.setProperty("system.system.ram", this.sliderRAM.getValue() + "");
        propsApp.setProperty("system.system.useInegratedJava", this.chkUseIntegratedJava.isSelected() ? "true" : "false");
        propsApp.setProperty("system.project.logo", this.fldLogo.getText());
        this.app.getSettings().setObservationColorSelect(new ThemisColor(this.colorObsSelect.getBackground(), this.colorObsSelect.getForeground()));
        this.app.getSettings().setObservationColorChecked(new ThemisColor(this.colorObsChecked.getBackground(), this.colorObsChecked.getForeground()));
        this.app.setConfiguration(propsApp);
        THEMIS.updateThemisConf();
        if (this.project.isOpen()) {
            this.project.setLocationTableColumns(newLocCols);
            this.project.setProjectProperties(propsProject);
        }
        this.app.setConfiguration(propsProject);
        this.app.setSysemLanguage();
        int sel = this.fldDuePeriodUnit.getSelectedIndex() + 1;
        this.app.setAppointmentInfo(this.fldDuePeriodCount.getText(), sel + "");
        if (this.currentSettingShowStartScreen != this.chkNotificationShowStartScreen.isSelected() && this.chkNotificationShowStartScreen.isSelected()) {
            ViewHelper.showStartScreen();
        }
        this.project.createActionLog("systemsetting_save", 0L, "");
    }

    protected void setTextColor(Object source) {
        JTextField obj = (JTextField)source;
        Color c = this.getColorFromDialog();
        if (c != null) {
            obj.setForeground(c);
            obj.setDisabledTextColor(c);
        }
    }

    protected void setColor(Object source) {
        JTextField obj = (JTextField)source;
        Color c = this.getColorFromDialog();
        if (c != null) {
            obj.setBackground(c);
        }
    }

    private Color getColorFromDialog() {
        JColorChooser pane = new JColorChooser(Color.white);
        ColorTracker ok = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(null, this.bundle.getString("DIALOG_COLOR_TITLE"), true, pane, ok, null);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Window w = (Window)e.getComponent();
                w.dispose();
            }
        });
        THEMIS.setDialogIcon(dialog);
        dialog.setVisible(true);
        return ok.getColor();
    }

    private int handleClickEventOnList(JList list, MouseEvent evt) {
        list = (JList)evt.getSource();
        if (evt.getClickCount() == 2) {
            return 2;
        }
        return -1;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel8 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listTopic = new JList();
        this.panelEditor = new JPanel();
        this.panelEmpty = new JPanel();
        this.panelStandards = new JPanel();
        this.jLabel55 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldUploadFolder = new JTextField();
        this.btnSetUploadFolder = new JButton();
        this.btnSetUploadFolderReset = new JButton();
        this.jLabel20 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.fldLogo = new JTextField();
        this.btnChooseLogo = new JButton();
        this.jLabel21 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel12 = new JLabel();
        this.fldServerCode = new JTextField();
        this.btnChooseLogo1 = new JButton();
        this.jLabel22 = new JLabel();
        this.jLabel4 = new JLabel();
        this.panelGeneral = new JPanel();
        this.jLabel52 = new JLabel();
        this.jLabel6 = new JLabel();
        this.fldLanguage = new JComboBox();
        this.jLabel29 = new JLabel();
        this.lblPeriod = new JLabel();
        this.fldDuePeriodCount = new JTextField();
        this.fldDuePeriodUnit = new JComboBox();
        this.jLabel30 = new JLabel();
        this.chkMonthlyBackup = new JCheckBox();
        this.chkMovelLabel = new JCheckBox();
        this.chkSimpleEditor = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.panelNotification = new JPanel();
        this.jLabel45 = new JLabel();
        this.chkNotificationNoEventInfo = new JCheckBox();
        this.chkNotificationDueTasks = new JCheckBox();
        this.chkNotificationShowStartScreen = new JCheckBox();
        this.chkNotificationNetworkDrive = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.panelUpdate = new JPanel();
        this.jLabel46 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jLabel42 = new JLabel();
        this.fldUpdateMethod = new JComboBox();
        this.jLabel25 = new JLabel();
        this.jLabel40 = new JLabel();
        this.fldUpdate = new JComboBox();
        this.panelUpdateDirectory = new JPanel();
        this.fldUpdateDirectory = new JTextField();
        this.btnSetUpdateDirectory = new JButton();
        this.jLabel24 = new JLabel();
        this.jLabel44 = new JLabel();
        this.jPanel3 = new JPanel();
        this.lblUpdateNextCheck = new JLabel();
        this.btnUpdateResetCheck = new JButton();
        this.jPanel9 = new JPanel();
        this.panelEmail = new JPanel();
        this.jLabel47 = new JLabel();
        this.jLabel32 = new JLabel();
        this.fldEmailSmtp = new JTextField();
        this.jLabel33 = new JLabel();
        this.fldEmailPort = new JTextField();
        this.jLabel34 = new JLabel();
        this.fldEmailEncrypt = new JComboBox();
        this.jLabel35 = new JLabel();
        this.fldEmailFrom = new JTextField();
        this.jLabel48 = new JLabel();
        this.jLabel37 = new JLabel();
        this.fldEmailImap = new JTextField();
        this.jLabel41 = new JLabel();
        this.fldEmailImapPort = new JTextField();
        this.jLabel43 = new JLabel();
        this.fldEmailImapEncrypt = new JComboBox();
        this.jLabel5 = new JLabel();
        this.panelSystem = new JPanel();
        this.jLabel49 = new JLabel();
        this.chkUseIntegratedJava = new JCheckBox();
        this.jLabel26 = new JLabel();
        this.jLabel14 = new JLabel();
        this.sliderRAM = new JSlider();
        this.fieldRAM = new JTextField();
        this.lblRestart = new JLabel();
        this.jPanel8 = new JPanel();
        this.panelColors = new JPanel();
        this.jLabel54 = new JLabel();
        this.jLabel60 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel53 = new JLabel();
        this.colorObsSelect = new JTextField();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jLabel65 = new JLabel();
        this.colorObsChecked = new JTextField();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jLabel61 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jLabel36 = new JLabel();
        this.fldDisplayTextareaRows = new JTextField();
        this.jLabel38 = new JLabel();
        this.lblColorRemainder = new JLabel();
        this.btnClose = new JButton();
        this.setMinimumSize(new Dimension(600, 400));
        this.setPreferredSize(new Dimension(1100, 500));
        this.setLayout(new GridBagLayout());
        this.jLabel8.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel8.text"));
        this.jLabel8.setHorizontalTextPosition(10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.jScrollPane1.setMaximumSize(null);
        this.jScrollPane1.setMinimumSize(new Dimension(230, 50));
        this.jScrollPane1.setPreferredSize(new Dimension(230, 50));
        this.listTopic.setFont(THEMIS.fontList);
        this.listTopic.setModel(new DefaultListModel());
        this.listTopic.setSelectionMode(0);
        this.listTopic.setMinimumSize(null);
        this.listTopic.setPreferredSize(null);
        this.listTopic.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SystemSettingsPanel.this.listTopicValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listTopic);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.panelEditor.setBackground(new Color(204, 204, 204));
        this.panelEditor.setLayout(new CardLayout());
        this.panelEmpty.setMaximumSize(null);
        GroupLayout panelEmptyLayout = new GroupLayout(this.panelEmpty);
        this.panelEmpty.setLayout(panelEmptyLayout);
        panelEmptyLayout.setHorizontalGroup(panelEmptyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 453, Short.MAX_VALUE));
        panelEmptyLayout.setVerticalGroup(panelEmptyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 454, Short.MAX_VALUE));
        this.panelEditor.add((Component)this.panelEmpty, "cardEmpty");
        this.panelStandards.setLayout(new GridBagLayout());
        this.jLabel55.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel55, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel55.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandards.add((Component)this.jLabel55, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.fldUploadFolder.setFont(THEMIS.fontTextfield);
        this.fldUploadFolder.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldUploadFolder.text"));
        this.fldUploadFolder.setMaximumSize(null);
        this.fldUploadFolder.setMinimumSize(null);
        this.fldUploadFolder.setPreferredSize(null);
        this.fldUploadFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.fldUploadFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldUploadFolder, gridBagConstraints);
        this.btnSetUploadFolder.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetUploadFolder, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.btnSetUploadFolder.text"));
        this.btnSetUploadFolder.setMinimumSize(null);
        this.btnSetUploadFolder.setPreferredSize(null);
        this.btnSetUploadFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.btnSetUploadFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnSetUploadFolder, gridBagConstraints);
        this.btnSetUploadFolderReset.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetUploadFolderReset, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.btnSetUploadFolderReset.text_1"));
        this.btnSetUploadFolderReset.setMinimumSize(null);
        this.btnSetUploadFolderReset.setPreferredSize(null);
        this.btnSetUploadFolderReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.btnSetUploadFolderResetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnSetUploadFolderReset, gridBagConstraints);
        this.jLabel20.setFont(THEMIS.fontLabel);
        this.jLabel20.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel20, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel20.text"));
        this.jLabel20.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel20, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.panelStandards.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel10.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel10, gridBagConstraints);
        this.fldLogo.setFont(THEMIS.fontTextfield);
        this.fldLogo.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldLogo.text_1"));
        this.fldLogo.setMaximumSize(null);
        this.fldLogo.setMinimumSize(null);
        this.fldLogo.setPreferredSize(null);
        this.fldLogo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.fldLogoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldLogo, gridBagConstraints);
        this.btnChooseLogo.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnChooseLogo, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.btnChooseLogo.text_1"));
        this.btnChooseLogo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.btnChooseLogoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnChooseLogo, gridBagConstraints);
        this.jLabel21.setFont(THEMIS.fontLabel);
        this.jLabel21.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel21.text"));
        this.jLabel21.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel21, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.panelStandards.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel12.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jLabel12, gridBagConstraints);
        this.fldServerCode.setFont(THEMIS.fontTextfield);
        this.fldServerCode.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldServerCode.text"));
        this.fldServerCode.setMaximumSize(null);
        this.fldServerCode.setMinimumSize(null);
        this.fldServerCode.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.fldServerCode, gridBagConstraints);
        this.btnChooseLogo1.setFont(THEMIS.fontButton);
        this.btnChooseLogo1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnChooseLogo1, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.btnChooseLogo1.text"));
        this.btnChooseLogo1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.btnChooseLogo1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnChooseLogo1, gridBagConstraints);
        this.jLabel22.setFont(THEMIS.fontLabel);
        this.jLabel22.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel22.text"));
        this.jLabel22.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jLabel22, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.panelStandards.add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 2.0;
        this.panelStandards.add((Component)this.jLabel4, gridBagConstraints);
        this.panelEditor.add((Component)this.panelStandards, "cardStandards");
        this.panelGeneral.setPreferredSize(new Dimension(600, 408));
        this.panelGeneral.setLayout(new GridBagLayout());
        this.jLabel52.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel52, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel52.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.jLabel52, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.jLabel6, gridBagConstraints);
        this.fldLanguage.setFont(THEMIS.fontList);
        this.fldLanguage.setModel(new DefaultComboBoxModel<String>(new String[]{"Deutsch", "English"}));
        this.fldLanguage.setMinimumSize(null);
        this.fldLanguage.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add(this.fldLanguage, gridBagConstraints);
        this.jLabel29.setFont(THEMIS.fontLabel);
        this.jLabel29.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel29, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel29.text"));
        this.jLabel29.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.jLabel29, gridBagConstraints);
        this.lblPeriod.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPeriod, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.lblPeriod.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.lblPeriod, gridBagConstraints);
        this.fldDuePeriodCount.setFont(THEMIS.fontTextfield);
        this.fldDuePeriodCount.setHorizontalAlignment(0);
        this.fldDuePeriodCount.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldDuePeriodCount.text"));
        this.fldDuePeriodCount.setMinimumSize(new Dimension(100, 20));
        this.fldDuePeriodCount.setPreferredSize(null);
        this.fldDuePeriodCount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SystemSettingsPanel.this.fldDuePeriodCountKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                SystemSettingsPanel.this.fldDuePeriodCountKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.fldDuePeriodCount, gridBagConstraints);
        this.fldDuePeriodUnit.setFont(THEMIS.fontList);
        this.fldDuePeriodUnit.setModel(this.modelRepeat);
        this.fldDuePeriodUnit.setMinimumSize(null);
        this.fldDuePeriodUnit.setPreferredSize(null);
        this.fldDuePeriodUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SystemSettingsPanel.this.fldDuePeriodUnitItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.fldDuePeriodUnit, gridBagConstraints);
        this.jLabel30.setFont(THEMIS.fontLabel);
        this.jLabel30.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel30, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel30.text"));
        this.jLabel30.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.jLabel30, gridBagConstraints);
        this.chkMonthlyBackup.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkMonthlyBackup, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.chkMonthlyBackup.text"));
        this.chkMonthlyBackup.setVerticalAlignment(1);
        this.chkMonthlyBackup.setVerticalTextPosition(1);
        this.chkMonthlyBackup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.chkMonthlyBackupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.chkMonthlyBackup, gridBagConstraints);
        this.chkMovelLabel.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkMovelLabel, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.chkMovelLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.chkMovelLabel, gridBagConstraints);
        this.chkSimpleEditor.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkSimpleEditor, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.chkSimpleEditor.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelGeneral.add((Component)this.chkSimpleEditor, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 2.0;
        this.panelGeneral.add((Component)this.jLabel3, gridBagConstraints);
        this.panelEditor.add((Component)this.panelGeneral, "cardGeneral");
        this.panelNotification.setLayout(new GridBagLayout());
        this.jLabel45.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel45, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel45.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNotification.add((Component)this.jLabel45, gridBagConstraints);
        this.chkNotificationNoEventInfo.setFont(THEMIS.fontLabel);
        this.chkNotificationNoEventInfo.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkNotificationNoEventInfo, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.chkNotificationNoEventInfo.text"));
        this.chkNotificationNoEventInfo.setVerticalAlignment(1);
        this.chkNotificationNoEventInfo.setVerticalTextPosition(1);
        this.chkNotificationNoEventInfo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SystemSettingsPanel.this.chkNotificationNoEventInfoItemStateChanged(evt);
            }
        });
        this.chkNotificationNoEventInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.chkNotificationNoEventInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNotification.add((Component)this.chkNotificationNoEventInfo, gridBagConstraints);
        this.chkNotificationDueTasks.setFont(THEMIS.fontLabel);
        this.chkNotificationDueTasks.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkNotificationDueTasks, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.chkNotificationDueTasks.text"));
        this.chkNotificationDueTasks.setVerticalAlignment(1);
        this.chkNotificationDueTasks.setVerticalTextPosition(1);
        this.chkNotificationDueTasks.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SystemSettingsPanel.this.chkNotificationDueTasksItemStateChanged(evt);
            }
        });
        this.chkNotificationDueTasks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.chkNotificationDueTasksActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNotification.add((Component)this.chkNotificationDueTasks, gridBagConstraints);
        this.chkNotificationShowStartScreen.setFont(THEMIS.fontLabel);
        this.chkNotificationShowStartScreen.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkNotificationShowStartScreen, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.chkNotificationShowStartScreen.text"));
        this.chkNotificationShowStartScreen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SystemSettingsPanel.this.chkNotificationShowStartScreenItemStateChanged(evt);
            }
        });
        this.chkNotificationShowStartScreen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SystemSettingsPanel.this.chkNotificationShowStartScreenMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNotification.add((Component)this.chkNotificationShowStartScreen, gridBagConstraints);
        this.chkNotificationNetworkDrive.setFont(THEMIS.fontLabel);
        this.chkNotificationNetworkDrive.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkNotificationNetworkDrive, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.chkNotificationNetworkDrive.text"));
        this.chkNotificationNetworkDrive.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SystemSettingsPanel.this.chkNotificationNetworkDriveItemStateChanged(evt);
            }
        });
        this.chkNotificationNetworkDrive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.chkNotificationNetworkDriveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelNotification.add((Component)this.chkNotificationNetworkDrive, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelNotification.add((Component)this.jLabel1, gridBagConstraints);
        this.panelEditor.add((Component)this.panelNotification, "cardNotification");
        this.panelUpdate.setLayout(new GridBagLayout());
        this.jLabel46.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel46, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel46.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdate.add((Component)this.jLabel46, gridBagConstraints);
        this.jLabel23.setFont(THEMIS.fontLabel);
        this.jLabel23.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel23, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel23.text"));
        this.jLabel23.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdate.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel42.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel42, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel42.text"));
        this.jLabel42.setToolTipText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel42.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdate.add((Component)this.jLabel42, gridBagConstraints);
        this.fldUpdateMethod.setFont(THEMIS.fontList);
        this.fldUpdateMethod.setModel(new DefaultComboBoxModel<String>(new String[]{"Neu installieren (Installer)", "Aktualisieren (Module)"}));
        this.fldUpdateMethod.setMinimumSize(new Dimension(100, 30));
        this.fldUpdateMethod.setPreferredSize(new Dimension(100, 30));
        this.fldUpdateMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SystemSettingsPanel.this.fldUpdateMethodItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdate.add(this.fldUpdateMethod, gridBagConstraints);
        this.jLabel25.setFont(THEMIS.fontLabel);
        this.jLabel25.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel25, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel25.text"));
        this.jLabel25.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdate.add((Component)this.jLabel25, gridBagConstraints);
        this.jLabel40.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel40, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel40.text_1"));
        this.jLabel40.setToolTipText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel40.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdate.add((Component)this.jLabel40, gridBagConstraints);
        this.fldUpdate.setFont(THEMIS.fontList);
        this.fldUpdate.setModel(this.modelUpdate);
        this.fldUpdate.setMinimumSize(new Dimension(100, 30));
        this.fldUpdate.setPreferredSize(new Dimension(100, 30));
        this.fldUpdate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SystemSettingsPanel.this.fldUpdateItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdate.add(this.fldUpdate, gridBagConstraints);
        this.panelUpdateDirectory.setLayout(new GridBagLayout());
        this.fldUpdateDirectory.setFont(THEMIS.fontTextfield);
        this.fldUpdateDirectory.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldUpdateDirectory.text_1"));
        this.fldUpdateDirectory.setMaximumSize(null);
        this.fldUpdateDirectory.setMinimumSize(new Dimension(100, 30));
        this.fldUpdateDirectory.setPreferredSize(new Dimension(100, 30));
        this.fldUpdateDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.fldUpdateDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdateDirectory.add((Component)this.fldUpdateDirectory, gridBagConstraints);
        this.btnSetUpdateDirectory.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetUpdateDirectory, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.btnSetUpdateDirectory.text_1"));
        this.btnSetUpdateDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.btnSetUpdateDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdateDirectory.add((Component)this.btnSetUpdateDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelUpdate.add((Component)this.panelUpdateDirectory, gridBagConstraints);
        this.jLabel24.setFont(THEMIS.fontLabel);
        this.jLabel24.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel24, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel24.text"));
        this.jLabel24.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdate.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel44.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel44, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel44.text"));
        this.jLabel44.setToolTipText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel44.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelUpdate.add((Component)this.jLabel44, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblUpdateNextCheck.setFont(THEMIS.fontLabel);
        this.lblUpdateNextCheck.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblUpdateNextCheck, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.lblUpdateNextCheck.text_1"));
        this.lblUpdateNextCheck.setToolTipText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.lblUpdateNextCheck.toolTipText"));
        this.lblUpdateNextCheck.setMinimumSize(new Dimension(100, 30));
        this.lblUpdateNextCheck.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.lblUpdateNextCheck, gridBagConstraints);
        this.btnUpdateResetCheck.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpdateResetCheck, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.btnUpdateResetCheck.text"));
        this.btnUpdateResetCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.btnUpdateResetCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnUpdateResetCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.panelUpdate.add((Component)this.jPanel3, gridBagConstraints);
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 453, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 94, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelUpdate.add((Component)this.jPanel9, gridBagConstraints);
        this.panelEditor.add((Component)this.panelUpdate, "cardUpdate");
        this.panelEmail.setLayout(new GridBagLayout());
        this.jLabel47.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel47, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel47.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.jLabel47, gridBagConstraints);
        this.jLabel32.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel32, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel32.text_1"));
        this.jLabel32.setMaximumSize(null);
        this.jLabel32.setMinimumSize(null);
        this.jLabel32.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.jLabel32, gridBagConstraints);
        this.fldEmailSmtp.setFont(THEMIS.fontTextfield);
        this.fldEmailSmtp.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldEmailSmtp.text"));
        this.fldEmailSmtp.setMaximumSize(null);
        this.fldEmailSmtp.setMinimumSize(null);
        this.fldEmailSmtp.setPreferredSize(null);
        this.fldEmailSmtp.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SystemSettingsPanel.this.fldEmailSmtpFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.fldEmailSmtp, gridBagConstraints);
        this.jLabel33.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel33, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel33.text_1"));
        this.jLabel33.setMaximumSize(null);
        this.jLabel33.setMinimumSize(null);
        this.jLabel33.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.jLabel33, gridBagConstraints);
        this.fldEmailPort.setFont(THEMIS.fontTextfield);
        this.fldEmailPort.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldEmailPort.text"));
        this.fldEmailPort.setMaximumSize(null);
        this.fldEmailPort.setMinimumSize(null);
        this.fldEmailPort.setPreferredSize(null);
        this.fldEmailPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SystemSettingsPanel.this.fldEmailPortFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.fldEmailPort, gridBagConstraints);
        this.jLabel34.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel34, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel34.text_1"));
        this.jLabel34.setMaximumSize(null);
        this.jLabel34.setMinimumSize(null);
        this.jLabel34.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.jLabel34, gridBagConstraints);
        this.fldEmailEncrypt.setModel(new DefaultComboBoxModel<String>(new String[]{this.project.getResourceText("email.security.none"), this.project.getResourceText("email.security.starttls"), this.project.getResourceText("email.security.ssl")}));
        this.fldEmailEncrypt.setMaximumSize(null);
        this.fldEmailEncrypt.setMinimumSize(null);
        this.fldEmailEncrypt.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add(this.fldEmailEncrypt, gridBagConstraints);
        this.jLabel35.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel35, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel35.text_1"));
        this.jLabel35.setMaximumSize(null);
        this.jLabel35.setMinimumSize(null);
        this.jLabel35.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.jLabel35, gridBagConstraints);
        this.fldEmailFrom.setFont(THEMIS.fontTextfield);
        this.fldEmailFrom.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldEmailFrom.text"));
        this.fldEmailFrom.setMaximumSize(null);
        this.fldEmailFrom.setMinimumSize(null);
        this.fldEmailFrom.setPreferredSize(null);
        this.fldEmailFrom.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SystemSettingsPanel.this.fldEmailFromFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.fldEmailFrom, gridBagConstraints);
        this.jLabel48.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel48, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel48.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panelEmail.add((Component)this.jLabel48, gridBagConstraints);
        this.jLabel37.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel37, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel37.text"));
        this.jLabel37.setMaximumSize(null);
        this.jLabel37.setMinimumSize(null);
        this.jLabel37.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.jLabel37, gridBagConstraints);
        this.fldEmailImap.setFont(THEMIS.fontTextfield);
        this.fldEmailImap.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldEmailImap.text"));
        this.fldEmailImap.setMaximumSize(null);
        this.fldEmailImap.setMinimumSize(null);
        this.fldEmailImap.setPreferredSize(null);
        this.fldEmailImap.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SystemSettingsPanel.this.fldEmailImapFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.fldEmailImap, gridBagConstraints);
        this.jLabel41.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel41, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel41.text_1"));
        this.jLabel41.setMaximumSize(null);
        this.jLabel41.setMinimumSize(null);
        this.jLabel41.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.jLabel41, gridBagConstraints);
        this.fldEmailImapPort.setFont(THEMIS.fontTextfield);
        this.fldEmailImapPort.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldEmailImapPort.text"));
        this.fldEmailImapPort.setMaximumSize(null);
        this.fldEmailImapPort.setMinimumSize(null);
        this.fldEmailImapPort.setPreferredSize(null);
        this.fldEmailImapPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SystemSettingsPanel.this.fldEmailImapPortFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.fldEmailImapPort, gridBagConstraints);
        this.jLabel43.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel43, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel43.text"));
        this.jLabel43.setMaximumSize(null);
        this.jLabel43.setMinimumSize(null);
        this.jLabel43.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add((Component)this.jLabel43, gridBagConstraints);
        this.fldEmailImapEncrypt.setModel(new DefaultComboBoxModel<String>(new String[]{this.project.getResourceText("email.security.none"), this.project.getResourceText("email.security.starttls"), this.project.getResourceText("email.security.ssl")}));
        this.fldEmailImapEncrypt.setMaximumSize(null);
        this.fldEmailImapEncrypt.setMinimumSize(null);
        this.fldEmailImapEncrypt.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEmail.add(this.fldEmailImapEncrypt, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelEmail.add((Component)this.jLabel5, gridBagConstraints);
        this.panelEditor.add((Component)this.panelEmail, "cardEmail");
        this.panelSystem.setLayout(new GridBagLayout());
        this.jLabel49.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel49, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel49.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSystem.add((Component)this.jLabel49, gridBagConstraints);
        this.chkUseIntegratedJava.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkUseIntegratedJava, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.chkUseIntegratedJava.text"));
        this.chkUseIntegratedJava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.chkUseIntegratedJavaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSystem.add((Component)this.chkUseIntegratedJava, gridBagConstraints);
        this.jLabel26.setFont(THEMIS.fontLabel);
        this.jLabel26.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel26, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel26.text"));
        this.jLabel26.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSystem.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel14.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel14.text"));
        this.jLabel14.setMaximumSize(null);
        this.jLabel14.setMinimumSize(null);
        this.jLabel14.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSystem.add((Component)this.jLabel14, gridBagConstraints);
        this.sliderRAM.setPaintLabels(true);
        this.sliderRAM.setPaintTicks(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSystem.add((Component)this.sliderRAM, gridBagConstraints);
        this.fieldRAM.setFont(THEMIS.fontTextfield);
        this.fieldRAM.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fieldRAM.text"));
        this.fieldRAM.setMinimumSize(new Dimension(73, 24));
        this.fieldRAM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.fieldRAMActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSystem.add((Component)this.fieldRAM, gridBagConstraints);
        this.lblRestart.setFont(THEMIS.fontLabel);
        this.lblRestart.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.lblRestart, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.lblRestart.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSystem.add((Component)this.lblRestart, gridBagConstraints);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelSystem.add((Component)this.jPanel8, gridBagConstraints);
        this.panelEditor.add((Component)this.panelSystem, "cardSystem");
        this.panelColors.setLayout(new GridBagLayout());
        this.jLabel54.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel54, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel54.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelColors.add((Component)this.jLabel54, gridBagConstraints);
        this.jLabel60.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel60, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel60.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.jLabel60, gridBagConstraints);
        this.jLabel27.setFont(THEMIS.fontLabel);
        this.jLabel27.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel27, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel27.text"));
        this.jLabel27.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelColors.add((Component)this.jLabel27, gridBagConstraints);
        this.jLabel53.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel53, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel53.text_1"));
        this.jLabel53.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.jLabel53, gridBagConstraints);
        this.colorObsSelect.setEditable(false);
        this.colorObsSelect.setHorizontalAlignment(0);
        this.colorObsSelect.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.colorObsSelect.text"));
        this.colorObsSelect.setEnabled(false);
        this.colorObsSelect.setMaximumSize(new Dimension(300, 30));
        this.colorObsSelect.setMinimumSize(new Dimension(100, 20));
        this.colorObsSelect.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.colorObsSelect, gridBagConstraints);
        this.jButton5.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton5, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jButton5.text"));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.jButton5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.jButton5, gridBagConstraints);
        this.jButton6.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jButton6.text"));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.jButton6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.jButton6, gridBagConstraints);
        this.jLabel65.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel65, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel65.text_1"));
        this.jLabel65.setPreferredSize(new Dimension(130, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.jLabel65, gridBagConstraints);
        this.colorObsChecked.setEditable(false);
        this.colorObsChecked.setHorizontalAlignment(0);
        this.colorObsChecked.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.colorObsChecked.text"));
        this.colorObsChecked.setEnabled(false);
        this.colorObsChecked.setMaximumSize(new Dimension(300, 30));
        this.colorObsChecked.setMinimumSize(new Dimension(100, 20));
        this.colorObsChecked.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.colorObsChecked, gridBagConstraints);
        this.jButton7.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton7, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jButton7.text"));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.jButton7ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.jButton7, gridBagConstraints);
        this.jButton8.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton8, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jButton8.text"));
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.jButton8ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.jButton8, gridBagConstraints);
        this.jLabel61.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel61, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel61.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.panelColors.add((Component)this.jLabel61, gridBagConstraints);
        this.jLabel28.setFont(THEMIS.fontLabel);
        this.jLabel28.setForeground(new Color(102, 102, 102));
        Mnemonics.setLocalizedText((JLabel)this.jLabel28, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel28.text"));
        this.jLabel28.setMaximumSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelColors.add((Component)this.jLabel28, gridBagConstraints);
        this.jLabel36.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel36, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel36.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.jLabel36, gridBagConstraints);
        this.fldDisplayTextareaRows.setFont(THEMIS.fontTextfield);
        this.fldDisplayTextareaRows.setText(NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.fldDisplayTextareaRows.text"));
        this.fldDisplayTextareaRows.setMinimumSize(new Dimension(100, 20));
        this.fldDisplayTextareaRows.setPreferredSize(new Dimension(6, 30));
        this.fldDisplayTextareaRows.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SystemSettingsPanel.this.fldDisplayTextareaRowsFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.fldDisplayTextareaRows, gridBagConstraints);
        this.jLabel38.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel38, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.jLabel38.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelColors.add((Component)this.jLabel38, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblColorRemainder, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.lblColorRemainder.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelColors.add((Component)this.lblColorRemainder, gridBagConstraints);
        this.panelEditor.add((Component)this.panelColors, "cardColors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelEditor, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(SystemSettingsPanel.class, (String)"SystemSettingsPanel.btnClose.text"));
        this.btnClose.setMinimumSize(null);
        this.btnClose.setPreferredSize(null);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemSettingsPanel.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.add((Component)this.btnClose, gridBagConstraints);
    }

    private void listTopicValueChanged(ListSelectionEvent evt) {
        ConfigurationTopic topic = (ConfigurationTopic)this.listTopic.getSelectedValue();
        CardLayout cd = (CardLayout)this.panelEditor.getLayout();
        switch (topic.id) {
            case 16: {
                cd.show(this.panelEditor, "cardStandards");
                break;
            }
            case 1: {
                cd.show(this.panelEditor, "cardGeneral");
                break;
            }
            case 4: {
                cd.show(this.panelEditor, "cardObsAttributes");
                break;
            }
            case 9: {
                cd.show(this.panelEditor, "cardAttributes");
                break;
            }
            case 10: {
                cd.show(this.panelEditor, "cardLocationList");
                break;
            }
            case 8: {
                cd.show(this.panelEditor, "cardNotification");
                break;
            }
            case 11: {
                cd.show(this.panelEditor, "cardUpdate");
                break;
            }
            case 12: {
                cd.show(this.panelEditor, "cardEmail");
                break;
            }
            case 13: {
                cd.show(this.panelEditor, "cardSystem");
                break;
            }
            case 15: {
                cd.show(this.panelEditor, "cardColors");
                break;
            }
            default: {
                cd.show(this.panelEditor, "cardEmpty");
            }
        }
    }

    private void chkNotificationNoEventInfoItemStateChanged(ItemEvent evt) {
    }

    private void chkNotificationNoEventInfoActionPerformed(ActionEvent evt) {
    }

    private void chkNotificationDueTasksItemStateChanged(ItemEvent evt) {
    }

    private void chkNotificationDueTasksActionPerformed(ActionEvent evt) {
    }

    private void fldDuePeriodUnitItemStateChanged(ItemEvent evt) {
    }

    private void fldDuePeriodCountKeyTyped(KeyEvent evt) {
    }

    private void fldDuePeriodCountKeyReleased(KeyEvent evt) {
        try {
            Integer.parseInt(this.fldDuePeriodCount.getText());
        }
        catch (Exception ex) {
            this.fldDuePeriodCount.setText("0");
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("SystemSettingsPanel.noInteger.text"));
        }
    }

    private void fldUpdateDirectoryActionPerformed(ActionEvent evt) {
    }

    private void btnSetUpdateDirectoryActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.bundle.getString("FOLDER_UPDATE"), ThemisFileDialog.DIALOGTYPE.DIRECTORY, this.app.getPathUpdateFolder(), null, null, null, false).getSelectedFile();
        if (f != null) {
            this.fldUpdateDirectory.setText(f.getAbsolutePath());
        }
    }

    private void fldUpdateItemStateChanged(ItemEvent evt) {
        this.panelUpdateDirectory.setVisible(this.fldUpdate.getSelectedIndex() == 1);
    }

    private void btnSetUploadFolderActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.bundle.getString("FOLDER_FILE_UPLOADS"), ThemisFileDialog.DIALOGTYPE.DIRECTORY, this.app.getSettings().getFolderImageObserver().getValue(true), null, null, null, false).getSelectedFile();
        if (f != null) {
            this.fldUploadFolder.setText(f.getAbsolutePath());
        }
    }

    private void fldUploadFolderActionPerformed(ActionEvent evt) {
    }

    private void fldEmailSmtpFocusLost(FocusEvent evt) {
    }

    private void fldEmailPortFocusLost(FocusEvent evt) {
    }

    private void chkNotificationShowStartScreenItemStateChanged(ItemEvent evt) {
    }

    private void fldEmailFromFocusLost(FocusEvent evt) {
    }

    private void chkUseIntegratedJavaActionPerformed(ActionEvent evt) {
    }

    private void fieldRAMActionPerformed(ActionEvent evt) {
    }

    private void fldEmailImapFocusLost(FocusEvent evt) {
    }

    private void fldEmailImapPortFocusLost(FocusEvent evt) {
    }

    private void btnChooseLogoActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.project.getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getCurrentFolder(), null, THEMIS.getImageFilter(), null, false).getSelectedFile();
        if (f != null) {
            this.fldLogo.setText(f.getAbsolutePath());
        }
    }

    private void fldLogoActionPerformed(ActionEvent evt) {
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.setColor(this.colorObsSelect);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.setTextColor(this.colorObsSelect);
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.setColor(this.colorObsChecked);
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.setTextColor(this.colorObsChecked);
    }

    private void fldDisplayTextareaRowsFocusLost(FocusEvent evt) {
    }

    private void chkNotificationNetworkDriveItemStateChanged(ItemEvent evt) {
    }

    private void chkNotificationNetworkDriveActionPerformed(ActionEvent evt) {
    }

    private void chkMonthlyBackupActionPerformed(ActionEvent evt) {
    }

    private void chkNotificationShowStartScreenMouseClicked(MouseEvent evt) {
    }

    private void btnUpdateResetCheckActionPerformed(ActionEvent evt) {
        this.lblUpdateNextCheck.setText("-");
    }

    private void btnSetUploadFolderResetActionPerformed(ActionEvent evt) {
        this.fldUploadFolder.setText(ThemisSettings.getFolderImageObserverDefault());
    }

    private void fldUpdateMethodItemStateChanged(ItemEvent evt) {
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        if (this.verifyApply()) {
            this.apply();
            this.closeDialog();
        }
    }

    private void btnChooseLogo1ActionPerformed(ActionEvent evt) {
        this.fldServerCode.setText("");
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(800, 550);
    }

    class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }

    class ConfigurationTopic {
        String display;
        int id;

        public ConfigurationTopic(int id, String display) {
            this.display = display;
            this.id = id;
        }

        public String toString() {
            return this.display;
        }
    }
}

