/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.config;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.config.AttributeDisplayOptionPanel;
import at.grid.themis.application.config.AttributeSettingsPanelInterface;
import at.grid.themis.application.ui.IconItemRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.interfaces.StringIconItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ThemisAttributePanel
extends JPanel {
    ThemisAttribute ta;
    AttributeSettingsPanelInterface panel;
    private JButton btnDown;
    private JButton btnRemove;
    private JButton btnUp;
    private JComboBox<StringIconItem> fldEditStyle;
    private JTextField fldLabel;
    private JPanel jPanel1;
    private JLabel lblSetting;
    private JTextField lblType;

    public ThemisAttributePanel(ThemisAttribute ta, AttributeSettingsPanelInterface p) {
        this.initComponents();
        this.panel = p;
        this.ta = ta;
        String attString = "themisattribute." + ta.getTargetCode() + "." + ta.getId();
        String resString = ThemisApplication.getInstance().getProject().getResourceText(attString);
        if (!attString.equals(resString)) {
            this.lblType.setText("[" + resString + "]");
        } else {
            this.lblType.setText(ta.getPlaceholder(true));
        }
        this.fldLabel.setText(ta.getLabel());
        ThemisAttribute.Edit editStyle = ta.getEditStyle();
        DefaultComboBoxModel<StringIconItem> editStyleModel = new DefaultComboBoxModel<StringIconItem>();
        editStyleModel.addElement(new StringIconItem(ThemisApplication.getInstance().getProject().getResourceText("attribute.permission.standard"), "key_rename"));
        editStyleModel.addElement(new StringIconItem(ThemisApplication.getInstance().getProject().getResourceText("attribute.permission.admin"), "key_lock"));
        if (!ta.isVirtual() && ta.getTarget() == ThemisAttribute.Target.OBSERVATION && !ta.getId().equals("title") && !ta.getId().equals("done") && ta.isChecklistAllowed()) {
            editStyleModel.addElement(new StringIconItem(ThemisApplication.getInstance().getProject().getResourceText("attribute.permission.checklist"), "key_checklist"));
        }
        int editStyleIndex = 0;
        switch (editStyle) {
            case ADMIN_ONLY: {
                editStyleIndex = 1;
                break;
            }
            case DIALOG_AND_CHECKLIST: {
                editStyleIndex = 2;
            }
        }
        if (editStyleIndex >= editStyleModel.getSize()) {
            editStyleIndex = 0;
        }
        this.fldEditStyle.setModel(editStyleModel);
        this.fldEditStyle.setRenderer(IconItemRenderer.getInstanceNoBorder());
        this.fldEditStyle.setSelectedIndex(editStyleIndex);
        if (ta.isAlwaysUsed()) {
            this.btnRemove.setVisible(false);
        }
        if (!ta.isUserdefined()) {
            this.btnDown.setVisible(false);
            this.btnUp.setVisible(false);
            this.fldLabel.setEnabled(false);
            this.fldLabel.setFont(THEMIS.fontLabelBold);
        }
        if (!ta.isUserdefined() || ta.getTarget() != ThemisAttribute.Target.OBSERVATION) {
            this.lblSetting.setEnabled(false);
        }
        if (!ta.isShowDefault()) {
            this.lblSetting.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_settings_red.gif")));
        } else {
            this.lblSetting.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_settings.gif")));
        }
    }

    public void setAsFirstPanel() {
        this.btnUp.setVisible(false);
    }

    public void setAsLastPanel() {
        this.btnDown.setVisible(false);
    }

    private void initComponents() {
        this.fldLabel = new JTextField();
        this.lblType = new JTextField();
        this.fldEditStyle = new JComboBox();
        this.jPanel1 = new JPanel();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.btnRemove = new JButton();
        this.lblSetting = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this.setMinimumSize(new Dimension(350, 50));
        this.setPreferredSize(new Dimension(350, 50));
        this.setLayout(new GridBagLayout());
        this.fldLabel.setFont(THEMIS.fontTextfield);
        this.fldLabel.setText(NbBundle.getMessage(ThemisAttributePanel.class, (String)"ThemisAttributePanel.fldLabel.text"));
        this.fldLabel.setAlignmentX(0.0f);
        this.fldLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ThemisAttributePanel.this.fldLabelFocusLost(evt);
            }
        });
        this.fldLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisAttributePanel.this.fldLabelActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldLabel, gridBagConstraints);
        this.lblType.setEditable(false);
        this.lblType.setFont(THEMIS.fontLabel);
        this.lblType.setHorizontalAlignment(2);
        this.lblType.setText(NbBundle.getMessage(ThemisAttributePanel.class, (String)"ThemisAttributePanel.lblType.text"));
        this.lblType.setBorder(null);
        this.lblType.setMaximumSize(new Dimension(200, 26));
        this.lblType.setMinimumSize(new Dimension(50, 26));
        this.lblType.setPreferredSize(new Dimension(100, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblType, gridBagConstraints);
        this.fldEditStyle.setFont(THEMIS.fontList);
        this.fldEditStyle.setModel(new DefaultComboBoxModel());
        this.fldEditStyle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemisAttributePanel.this.fldEditStyleItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldEditStyle, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 3, 5, 0));
        this.btnUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUp, (String)NbBundle.getMessage(ThemisAttributePanel.class, (String)"ThemisAttributePanel.btnUp.text"));
        this.btnUp.setPreferredSize(new Dimension(50, 30));
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisAttributePanel.this.btnUpActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnUp);
        this.btnDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDown, (String)NbBundle.getMessage(ThemisAttributePanel.class, (String)"ThemisAttributePanel.btnDown.text"));
        this.btnDown.setPreferredSize(new Dimension(50, 30));
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisAttributePanel.this.btnDownActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnDown);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ThemisAttributePanel.class, (String)"ThemisAttributePanel.btnRemove.text"));
        this.btnRemove.setPreferredSize(new Dimension(50, 30));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisAttributePanel.this.btnRemoveActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnRemove);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.lblSetting.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_settings.gif")));
        Mnemonics.setLocalizedText((JLabel)this.lblSetting, (String)NbBundle.getMessage(ThemisAttributePanel.class, (String)"ThemisAttributePanel.lblSetting.text"));
        this.lblSetting.setDisabledIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/empty.gif")));
        this.lblSetting.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ThemisAttributePanel.this.lblSettingMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblSetting, gridBagConstraints);
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        this.panel.removeAttribute(this);
    }

    private void btnUpActionPerformed(ActionEvent evt) {
        this.panel.moveAttribute(this, -1);
    }

    private void btnDownActionPerformed(ActionEvent evt) {
        this.panel.moveAttribute(this, 1);
    }

    private void fldLabelActionPerformed(ActionEvent evt) {
        this.ta.setLabel(this.fldLabel.getText());
    }

    private void fldLabelFocusLost(FocusEvent evt) {
        this.ta.setLabel(this.fldLabel.getText());
    }

    private void fldEditStyleItemStateChanged(ItemEvent evt) {
        this.ta.setEditStyle(this.fldEditStyle.getSelectedIndex());
    }

    private void lblSettingMouseClicked(MouseEvent evt) {
        new AttributeDisplayOptionPanel(this.ta).showDialog();
        if (!this.ta.isShowDefault()) {
            this.lblSetting.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_settings_red.gif")));
        } else {
            this.lblSetting.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_settings.gif")));
        }
    }
}

