/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.documents;

import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.ontology.swing.CmsElementSwing;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXDatePicker;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DocumentPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle");
    CmsInfo information = null;
    UploadItem selectedItem = null;
    private String DIALOG_CODE = "documentpanel";
    public static final int DIALOG_WIDTH = 440;
    public static final int DIALOG_HEIGHT = 600;
    private boolean save = false;
    private JButton bntCancel;
    private JButton btnAddDocument;
    private JButton btnRemoveDocument;
    private JButton btnSaveChanges;
    private JButton btnSaveDocument;
    private JButton btnShowDocument;
    private JXDatePicker fldDate;
    private JComboBox fldDocTypeEntry;
    private JTextArea fldInfo;
    private JTextField fldTitle;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JList lstFiles;

    public DocumentPanel(final CmsInfo information) {
        this.initComponents();
        new DropTarget(this.lstFiles, new ThemisDropTargetListener(true, false){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                information.getUploadAttribute("files").addUpload(f);
                DocumentPanel.this.populateFileList();
            }
        });
        THEMIS.removeUsualTabBehavior(this.fldInfo);
        this.lstFiles.setCellRenderer(new SimpleTextRenderer());
        this.fldDocTypeEntry.setModel(CmsElementSwing.getComboBoxModel(this.project.getKeytable("documenttype"), this.project.getUser().getCurrentLanguage(), true, "-"));
        this.information = information;
        if (this.information == null) {
            this.information = (CmsInfo)this.project.createElement("info");
        }
        this.populate();
    }

    public void populate() {
        this.fldTitle.setText(this.information.getTitle());
        this.fldInfo.setText(this.information.getAttributeValue("comment"));
        this.fldDate.setDate(this.information.getDateAttribute("date").getDate());
        try {
            int keyId = (int)this.information.getKeyAttribute("documenttype").getId();
            int keyIdx = this.app.getProject().getKeytable("documenttype").getIndex((long)keyId);
            if (keyIdx >= 0) {
                this.fldDocTypeEntry.setSelectedIndex(keyIdx + 1);
            } else {
                this.fldDocTypeEntry.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.errorReadingDocType.text"), ex);
        }
        this.populateFileList();
    }

    public void apply(boolean doSave) {
        if (!this.project.isOpen() || ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        if (this.information == null) {
            this.information = (CmsInfo)this.project.createElement("info");
        }
        this.information.setAttributeValue("title", this.fldTitle.getText());
        this.information.getDateAttribute("date").setDate(this.fldDate.getDate());
        this.information.setAttributeValue("comment", this.fldInfo.getText());
        KeytableRecord rec = (KeytableRecord)this.fldDocTypeEntry.getSelectedItem();
        this.information.getKeyAttribute("documenttype").setValue(rec == null ? -1L : rec.id);
        if (doSave) {
            this.information.save();
            this.project.createActionLog("document_edit", this.information.getId(), "");
        }
    }

    public boolean hasChaned() {
        return this.information.hasChanged();
    }

    private void populateFileList() {
        List items = this.information.getUploadAttribute("files").getUploadItems();
        DefaultListModel elementModel = (DefaultListModel)this.lstFiles.getModel();
        elementModel.clear();
        this.btnRemoveDocument.setEnabled(false);
        this.btnShowDocument.setEnabled(false);
        this.btnAddDocument.setEnabled(true);
        if (items.size() == 0) {
            return;
        }
        if (items.size() > 0) {
            for (UploadItem item : items) {
                elementModel.addElement(item);
            }
            if (this.selectedItem != null) {
                this.lstFiles.setSelectedValue(this.selectedItem, true);
            } else {
                this.lstFiles.setSelectedIndex(0);
            }
            if (this.lstFiles.getSelectedIndex() != -1) {
                this.btnRemoveDocument.setEnabled(true);
                this.btnShowDocument.setEnabled(true);
            }
        }
    }

    private void cancelAction() {
        this.apply(false);
        if (!this.hasChaned() || this.app.getDialog().showConfirmDialog("Bearbeitung wirklich abbrechen?")) {
            this.closeDialog();
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.fldTitle = new JTextField();
        this.jLabel7 = new JLabel();
        this.fldDocTypeEntry = new JComboBox();
        this.jLabel6 = new JLabel();
        this.fldDate = new JXDatePicker();
        this.jLabel4 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.fldInfo = new JTextArea();
        this.jLabel5 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.lstFiles = new JList();
        this.jPanel1 = new JPanel();
        this.btnAddDocument = new JButton();
        this.btnSaveDocument = new JButton();
        this.btnShowDocument = new JButton();
        this.btnRemoveDocument = new JButton();
        this.jPanel3 = new JPanel();
        this.btnSaveChanges = new JButton();
        this.bntCancel = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.jLabel3.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.fldTitle.setFont(THEMIS.fontTextfield);
        this.fldTitle.setText(NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.fldTitle.text"));
        this.fldTitle.setMaximumSize(null);
        this.fldTitle.setMinimumSize(new Dimension(100, 35));
        this.fldTitle.setPreferredSize(new Dimension(100, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldTitle, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.fldDocTypeEntry.setFont(THEMIS.fontList);
        this.fldDocTypeEntry.setMaximumSize(null);
        this.fldDocTypeEntry.setMinimumSize(new Dimension(100, 35));
        this.fldDocTypeEntry.setPreferredSize(new Dimension(100, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldDocTypeEntry, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.fldDate.setFont(THEMIS.fontTextfield);
        this.fldDate.setMaximumSize(null);
        this.fldDate.setMinimumSize(new Dimension(100, 35));
        this.fldDate.setPreferredSize(new Dimension(100, 35));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldDate, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(new Dimension(100, 100));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 100));
        this.fldInfo.setColumns(20);
        this.fldInfo.setFont(THEMIS.fontTextfield);
        this.fldInfo.setLineWrap(true);
        this.fldInfo.setRows(2);
        this.fldInfo.setTabSize(4);
        this.fldInfo.setWrapStyleWord(true);
        this.fldInfo.setMinimumSize(new Dimension(5, 16));
        this.jScrollPane3.setViewportView(this.fldInfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jScrollPane4.setFont(THEMIS.fontLabel);
        this.jScrollPane4.setMinimumSize(new Dimension(10, 20));
        this.lstFiles.setFont(THEMIS.fontList);
        this.lstFiles.setModel(new DefaultListModel());
        this.lstFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DocumentPanel.this.lstFilesMousePressed(evt);
            }
        });
        this.lstFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DocumentPanel.this.lstFilesValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.lstFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnAddDocument.setFont(THEMIS.fontButton);
        this.btnAddDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddDocument, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnAddDocument.text"));
        this.btnAddDocument.setToolTipText(NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnAddDocument.toolTipText"));
        this.btnAddDocument.setBorder(new SoftBevelBorder(0));
        this.btnAddDocument.setMinimumSize(null);
        this.btnAddDocument.setPreferredSize(null);
        this.btnAddDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.btnAddDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnAddDocument, gridBagConstraints);
        this.btnSaveDocument.setFont(THEMIS.fontButton);
        this.btnSaveDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/save24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveDocument, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnSaveDocument.text"));
        this.btnSaveDocument.setToolTipText(NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnSaveDocument.toolTipText"));
        this.btnSaveDocument.setBorder(new SoftBevelBorder(0));
        this.btnSaveDocument.setMinimumSize(null);
        this.btnSaveDocument.setPreferredSize(null);
        this.btnSaveDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.btnSaveDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnSaveDocument, gridBagConstraints);
        this.btnShowDocument.setFont(THEMIS.fontButton);
        this.btnShowDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/controlled24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowDocument, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnShowDocument.text"));
        this.btnShowDocument.setToolTipText(NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnShowDocument.toolTipText"));
        this.btnShowDocument.setBorder(new SoftBevelBorder(0));
        this.btnShowDocument.setMinimumSize(null);
        this.btnShowDocument.setPreferredSize(null);
        this.btnShowDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.btnShowDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnShowDocument, gridBagConstraints);
        this.btnRemoveDocument.setFont(THEMIS.fontButton);
        this.btnRemoveDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveDocument, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnRemoveDocument.text"));
        this.btnRemoveDocument.setToolTipText(NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnRemoveDocument.toolTipText"));
        this.btnRemoveDocument.setBorder(new SoftBevelBorder(0));
        this.btnRemoveDocument.setMinimumSize(null);
        this.btnRemoveDocument.setPreferredSize(null);
        this.btnRemoveDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.btnRemoveDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnRemoveDocument, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnSaveChanges.setFont(THEMIS.fontButton);
        this.btnSaveChanges.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveChanges, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnSaveChanges.text"));
        this.btnSaveChanges.setToolTipText(NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.btnSaveChanges.toolTipText"));
        this.btnSaveChanges.setBorder(new SoftBevelBorder(0));
        this.btnSaveChanges.setMinimumSize(new Dimension(100, 35));
        this.btnSaveChanges.setPreferredSize(new Dimension(100, 35));
        this.btnSaveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.btnSaveChangesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnSaveChanges, gridBagConstraints);
        this.bntCancel.setFont(THEMIS.fontButton);
        this.bntCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.bntCancel, (String)NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.bntCancel.text"));
        this.bntCancel.setToolTipText(NbBundle.getMessage(DocumentPanel.class, (String)"DocumentPanel.bntCancel.toolTipText"));
        this.bntCancel.setBorder(new SoftBevelBorder(0));
        this.bntCancel.setMinimumSize(new Dimension(100, 35));
        this.bntCancel.setPreferredSize(new Dimension(100, 35));
        this.bntCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.bntCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.bntCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void lstFilesMousePressed(MouseEvent evt) {
        UploadItem sel;
        int count = evt.getClickCount();
        if (count == 2 && (sel = (UploadItem)this.lstFiles.getSelectedValue()) != null) {
            THEMIS.showFile(sel.getFile());
        }
    }

    private void lstFilesValueChanged(ListSelectionEvent evt) {
        if (this.lstFiles.getSelectedIndex() != -1) {
            this.btnRemoveDocument.setEnabled(true);
            this.btnShowDocument.setEnabled(true);
        } else {
            this.btnRemoveDocument.setEnabled(false);
            this.btnShowDocument.setEnabled(false);
        }
    }

    private void btnAddDocumentActionPerformed(ActionEvent evt) {
        try {
            List<File> files = new ThemisFileDialog(this.bundle.getString("DocumentsTopComponent.chooseFile.text"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getDocumentImportFolder(), null, null, null, false).getSelectedFiles();
            if (files != null && files.size() > 0) {
                for (File f : files) {
                    this.information.getUploadAttribute("files").addUpload(f);
                }
                this.populateFileList();
                this.app.setDocumentImportFolder(files.get(0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnShowDocumentActionPerformed(ActionEvent evt) {
        UploadItem sel = (UploadItem)this.lstFiles.getSelectedValue();
        if (sel != null) {
            THEMIS.showFile(sel.getFile());
        }
    }

    private void btnRemoveDocumentActionPerformed(ActionEvent evt) {
        try {
            List uploadItems = this.lstFiles.getSelectedValuesList();
            boolean remove = false;
            if (uploadItems.size() == 1) {
                remove = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.deleteFile.text"), ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.deleteFileShort.text"));
            } else if (uploadItems.size() > 1) {
                remove = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.deleteFilePlural.text"), ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.deleteFileShortPlural.text"));
            }
            if (remove) {
                for (UploadItem uploadItem : uploadItems) {
                    this.information.getUploadAttribute("files").deleteUpload(uploadItem);
                }
                this.populateFileList();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bntCancelActionPerformed(ActionEvent evt) {
        this.cancelAction();
    }

    private void btnSaveChangesActionPerformed(ActionEvent evt) {
        try {
            if (this.fldTitle.getText().equals("")) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.mandatoryTitle.text"));
                return;
            }
            this.apply(true);
            this.closeDialog();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnSaveDocumentActionPerformed(ActionEvent evt) {
        UploadItem sel = (UploadItem)this.lstFiles.getSelectedValue();
        if (sel != null) {
            File f = new File(this.app.getSettings().getFolderThemisIO().getValue(true), sel.getName());
            if ((f = new ThemisFileDialog("Datei speichern", ThemisFileDialog.DIALOGTYPE.SAVE, f, f, null, null, false).getSelectedFile()) != null) {
                try {
                    Util.copy((File)sel.getFile(), (File)f);
                }
                catch (IOException ex) {
                    this.app.getDialog().showWarningDialog("Fehler beim Speichern der Datei: " + ex.getLocalizedMessage());
                }
            }
        }
    }

    public boolean doSave() {
        return this.save;
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(this.project.getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DocumentPanel.this.cancelAction();
            }
        });
        THEMIS.setAssistantMoveListener(dlg);
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, dlg, 440, 600);
        dlg.setVisible(true);
    }

    private void closeDialog() {
        JDialog parent = (JDialog)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, parent);
        parent.dispose();
    }
}

