/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.documents;

import at.grid.cms.CmsApplication;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.SearchResult;
import at.grid.ontology.swing.CmsElementSwing;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.config.ProjectSettingsPanel;
import at.grid.themis.application.documents.DocumentPanel;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="DocumentsTopComponent", persistenceType=0)
public final class DocumentsTopComponent
extends TopComponent
implements ThemisActionListener {
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle");
    DefaultListModel<CmsElementSummary> documentsModel = new DefaultListModel();
    DefaultListModel<UploadItem> elementModel = new DefaultListModel();
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private CmsInfo information;
    private String selectedInformationId = "";
    private boolean infoChanged = false;
    private JButton btnAdd;
    private JButton btnCopy;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnShowDocument1;
    private JComboBox fldDocTypeSort;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JScrollPane jScrollPane2;
    private JLabel locListSettings;
    private JList lstInformation;
    private JPanel panelMain;

    public DocumentsTopComponent() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + ((Object)((Object)this)).getClass().getName() + " ...");
        THEMIS.getLicense();
        this.initComponents();
        this.setName(ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("CTL_DocumentsAction"));
        this.setToolTipText(ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("HINT_DocumentsTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        new DropTarget(this.lstInformation, new ThemisDropTargetListener(true, false){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                DocumentsTopComponent.this.information = (CmsInfo)DocumentsTopComponent.this.project.createElement("info");
                DocumentsTopComponent.this.information.setAttributeValue("title", f.getName());
                KeytableRecord rec = (KeytableRecord)DocumentsTopComponent.this.fldDocTypeSort.getSelectedItem();
                if (rec.id >= 0L) {
                    DocumentsTopComponent.this.information.getKeyAttribute("documenttype").setValue(rec.id);
                }
                DocumentsTopComponent.this.information.getUploadAttribute("files").addUpload(f);
                DocumentsTopComponent.this.information.save();
                DocumentsTopComponent.this.updateLists();
                DocumentsTopComponent.this.selectListEntry();
            }
        });
        ThemisActionProvider.getInstance().register(this);
        new DragScrollHandler(this.lstInformation, true, true);
        this.lstInformation.setCellRenderer(new SimpleTextRenderer());
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        if (action.getSource() == this) {
            return;
        }
        switch (action.getAction()) {
            case 1101: {
                this.updateLists();
                this.infoChanged = false;
                break;
            }
            case 1100: {
                this.initialiseTopComponent();
                break;
            }
            case 1102: {
                this.initialiseTopComponent();
                break;
            }
            case 650: 
            case 800: 
            case 801: 
            case 1300: {
                this.updateLists();
            }
        }
    }

    private void initialiseTopComponent() {
        if (this.app.getProject() != null && this.app.getProject().isOpen()) {
            this.loadKeytable("documenttype", this.fldDocTypeSort);
            this.updateLists();
            this.enableButtons();
            if (this.lstInformation.getSelectedIndex() != -1) {
                CmsElementSummary ele = (CmsElementSummary)this.lstInformation.getSelectedValue();
                this.information = (CmsInfo)ele.getElement();
                this.selectedInformationId = this.information.getAttributeValue("meta_id");
            }
        }
    }

    public List<CmsElementSummary> getSelection() {
        ArrayList eles = this.lstInformation.getSelectedValuesList();
        return eles == null ? new ArrayList() : eles;
    }

    public void updateLists() {
        this.documentsModel.clear();
        if (this.project.isOpen()) {
            CmsElement info = this.project.getDefaultElement("info");
            CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("info");
            s.addSelectMeta();
            s.addSelectAttribute(info.getAttribute("hasfiles"));
            if (this.fldDocTypeSort.getSelectedIndex() > 0) {
                long keyId = ((KeytableRecord)this.fldDocTypeSort.getSelectedItem()).id;
                s.addWhere("ele.iddocumenttype=" + keyId);
            }
            s.setSort("upper(el.title)");
            SearchResult result = s.search();
            ArrayList elements = result.getResultAsElementSummary();
            List recs = result.getResult();
            ArrayList<Long> infoIds = new ArrayList<Long>();
            for (int ii = 0; ii < recs.size(); ++ii) {
                if (infoIds.contains(((CmsElementSummary)elements.get(ii)).getId())) continue;
                this.documentsModel.addElement((CmsElementSummary)elements.get(ii));
                infoIds.add(((CmsElementSummary)elements.get(ii)).getId());
            }
        }
        this.lstInformation.setModel(this.documentsModel);
        if (this.lstInformation.getSelectedIndex() == -1) {
            this.btnRemove.setEnabled(false);
        }
        this.infoChanged = false;
    }

    private void applyChange(boolean createNew) {
        this.updateLists();
        this.selectListEntry();
    }

    private void addUploadsToList() {
        this.elementModel.clear();
        List uploadItems = this.information.getUploadAttribute("files").getUploadItems();
        for (UploadItem item : uploadItems) {
            this.elementModel.addElement(item);
        }
    }

    private void selectListEntry() {
        for (int ii = 0; ii < this.documentsModel.getSize(); ++ii) {
            CmsElementSummary ele = this.documentsModel.getElementAt(ii);
            CmsInfo temp = (CmsInfo)ele.getElement();
            if (!this.selectedInformationId.equals(temp.getAttributeValue("meta_id"))) continue;
            this.lstInformation.setSelectedIndex(ii);
            break;
        }
    }

    private void edit(CmsInfo i) {
        if (!this.app.getLicense().hasLicense()) {
            return;
        }
        new DocumentPanel(i).showDialog();
        this.updateLists();
    }

    private void enableButtons() {
        boolean hasLicense = this.app.getLicense().hasLicense();
        boolean isSel = this.lstInformation.getSelectedValue() != null;
        this.btnCopy.setEnabled(isSel && hasLicense);
        this.btnEdit.setEnabled(isSel && hasLicense);
        this.btnRemove.setEnabled(isSel && hasLicense);
        this.btnAdd.setEnabled(hasLicense);
    }

    private void initComponents() {
        this.panelMain = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel8 = new JLabel();
        this.fldDocTypeSort = new JComboBox();
        this.locListSettings = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lstInformation = new JList();
        this.jPanel6 = new JPanel();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnCopy = new JButton();
        this.btnRemove = new JButton();
        this.jLabel7 = new JLabel();
        this.btnShowDocument1 = new JButton();
        this.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        this.setMinimumSize(new Dimension(10, 0));
        this.setPreferredSize(new Dimension(420, 598));
        this.setLayout(new BorderLayout());
        this.panelMain.setPreferredSize(new Dimension(100, 100));
        this.panelMain.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelMain.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jLabel8, gridBagConstraints);
        this.fldDocTypeSort.setFont(THEMIS.fontList);
        this.fldDocTypeSort.setMinimumSize(new Dimension(100, 35));
        this.fldDocTypeSort.setPreferredSize(new Dimension(100, 35));
        this.fldDocTypeSort.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DocumentsTopComponent.this.fldDocTypeSortItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.fldDocTypeSort, gridBagConstraints);
        this.locListSettings.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_settings.gif")));
        Mnemonics.setLocalizedText((JLabel)this.locListSettings, (String)NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.locListSettings.text"));
        this.locListSettings.setToolTipText(NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.locListSettings.toolTipText"));
        this.locListSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DocumentsTopComponent.this.locListSettingsMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.jPanel4.add((Component)this.locListSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelMain.add((Component)this.jPanel4, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(10, 20));
        this.jScrollPane2.setPreferredSize(new Dimension(100, 200));
        this.lstInformation.setFont(THEMIS.fontList);
        this.lstInformation.setModel(this.documentsModel);
        this.lstInformation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DocumentsTopComponent.this.lstInformationMouseClicked(evt);
            }
        });
        this.lstInformation.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DocumentsTopComponent.this.lstInformationValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.lstInformation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelMain.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.btnAdd.setFont(THEMIS.fontButton);
        this.btnAdd.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnAdd.text"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnAdd.toolTipText"));
        this.btnAdd.setBorder(new SoftBevelBorder(0));
        this.btnAdd.setMaximumSize(null);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentsTopComponent.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnAdd, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentsTopComponent.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnEdit, gridBagConstraints);
        this.btnCopy.setFont(THEMIS.fontButton);
        this.btnCopy.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopy, (String)NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnCopy.text"));
        this.btnCopy.setToolTipText(NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnCopy.toolTipText"));
        this.btnCopy.setBorder(new SoftBevelBorder(0));
        this.btnCopy.setMaximumSize(null);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentsTopComponent.this.btnCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnCopy, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnRemove.toolTipText"));
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.setMaximumSize(null);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentsTopComponent.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.jLabel7, gridBagConstraints);
        this.btnShowDocument1.setFont(THEMIS.fontButton);
        this.btnShowDocument1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/controlled24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowDocument1, (String)NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnShowDocument1.text"));
        this.btnShowDocument1.setToolTipText(NbBundle.getMessage(DocumentsTopComponent.class, (String)"DocumentsTopComponent.btnShowDocument1.toolTipText"));
        this.btnShowDocument1.setBorder(new SoftBevelBorder(0));
        this.btnShowDocument1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentsTopComponent.this.btnShowDocument1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnShowDocument1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.panelMain.add((Component)this.jPanel6, gridBagConstraints);
        this.add(this.panelMain, "Center");
    }

    private void fldDocTypeSortItemStateChanged(ItemEvent evt) {
        this.updateLists();
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        List<CmsElementSummary> eles = this.getSelection();
        if (eles.size() > 0) {
            CmsInfo e = (CmsInfo)this.project.loadElement(eles.get(0).getId(), this.project.getUser());
            this.edit(e);
        }
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        List<CmsElementSummary> eles = this.getSelection();
        if (eles.size() > 0) {
            CmsInfo e = (CmsInfo)this.project.loadElement(eles.get(0).getId(), this.project.getUser());
            e = (CmsInfo)e.copy();
            this.edit(e);
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen() && !this.lstInformation.isSelectionEmpty()) {
            List elements = this.lstInformation.getSelectedValuesList();
            boolean remove = false;
            if (elements.size() == 1) {
                remove = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.deleteEntry.text"), ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.deleteEntryShort.text"));
            }
            if (elements.size() > 1) {
                remove = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.deleteEntryPlural.text"), ResourceBundle.getBundle("at/grid/themis/application/documents/Bundle").getString("DocumentsTopComponent.deleteEntryShortPlural.text"));
            }
            if (remove) {
                for (CmsElementSummary ele : elements) {
                    CmsElement.moveToTrash((CmsApplication)this.project, (long)ele.getId(), (CmsUser)this.project.getUser());
                    this.project.createActionLog("document_delete", ele.getId(), "");
                }
                this.selectedInformationId = "";
                this.updateLists();
            }
            this.enableButtons();
            if (!this.documentsModel.isEmpty()) {
                this.lstInformation.setSelectedIndex(0);
                CmsElementSummary element = (CmsElementSummary)this.lstInformation.getSelectedValue();
                this.information = (CmsInfo)element.getElement();
                this.selectedInformationId = this.information.getAttributeValue("meta_id");
            }
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        CmsInfo e = (CmsInfo)this.project.createElement("info");
        this.edit(e);
    }

    private void lstInformationMouseClicked(MouseEvent evt) {
        CmsElementSummary sel;
        if (evt.getClickCount() > 1 && this.app.getLicense().hasLicense() && (sel = (CmsElementSummary)this.lstInformation.getSelectedValue()) != null) {
            CmsInfo e = (CmsInfo)this.project.loadElement(sel.getId(), this.project.getUser());
            this.edit(e);
        }
    }

    private void lstInformationValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.enableButtons();
        }
    }

    private void btnShowDocument1ActionPerformed(ActionEvent evt) {
        CmsInfo e;
        UploadItem item;
        List<CmsElementSummary> eles = this.getSelection();
        if (eles.size() > 0 && (item = (e = (CmsInfo)this.project.loadElement(eles.get(0).getId(), this.project.getUser())).getUploadAttribute("files").getFirstUploadItem()) != null) {
            THEMIS.showFile(item.getFile());
        }
    }

    private void locListSettingsMouseClicked(MouseEvent evt) {
        if (!this.project.isOpen()) {
            return;
        }
        ProjectSettingsPanel panel = new ProjectSettingsPanel();
        panel.showKeytables("documenttype");
        panel.showDialog();
        this.loadKeytable("documenttype", this.fldDocTypeSort);
    }

    public void componentOpened() {
        this.initialiseTopComponent();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void loadKeytable(String keytable, JComboBox combo) {
        if (this.project != null && this.project.isOpen()) {
            combo.setModel(CmsElementSwing.getComboBoxModel(this.project.getKeytable(keytable), this.project.getUser().getCurrentLanguage(), true, "-"));
        }
    }
}

