/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.element;

import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.observer.FolderListener;
import at.grid.cms.observer.FolderObserver;
import at.grid.ontology.swing.CmsElementPanel;
import at.grid.ontology.swing.component.CmsListPanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.util.Util;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ElementDialog {
    private CmsElement element;
    private UploadAttribute att;
    CmsElementPanel panel;
    FolderObserver observer;
    boolean readonly = false;
    ThemisApplication app = ThemisApplication.getInstance();

    public ElementDialog(CmsElement element) {
        this(element, false);
    }

    public ElementDialog(CmsElement element, boolean readonly) {
        this.element = element;
        this.readonly = readonly;
        this.panel = new CmsElementPanel(element);
    }

    public ElementDialog(CmsElement element, FolderObserver observer, String attribute) {
        this(element, observer, attribute, false);
    }

    public ElementDialog(CmsElement element, FolderObserver observer, String attribute, boolean readonly) {
        this(element, observer, attribute, readonly, 0);
    }

    public ElementDialog(CmsElement element, FolderObserver observer, String attribute, boolean readonly, final int imagesize) {
        this.element = element;
        this.readonly = readonly;
        this.panel = new CmsElementPanel(element);
        this.att = null;
        this.observer = observer;
        if (element.getAttribute(attribute).isOfType(15) || element.getAttribute(attribute).isOfType(16)) {
            this.att = (UploadAttribute)element.getAttribute(attribute);
            observer.registerListener(new FolderListener(){

                public void onNewFiles(FolderObserver observer, ArrayList<String> filenames) {
                    JComponent comp = ElementDialog.this.panel.getComponent(this, ElementDialog.this.att.getCode());
                    if (comp instanceof CmsListPanel) {
                        for (String filename : filenames) {
                            if (filename.toLowerCase().endsWith(".jpg") && imagesize != 0) {
                                try {
                                    BufferedImage resizeImage = Util.resizeImage((BufferedImage)ImageIO.read(new File(observer.getFolder(), filename)), (int)imagesize);
                                    File outputfile = new File(observer.getFolder(), filename);
                                    ImageIO.write((RenderedImage)resizeImage, "jpg", outputfile);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            ((CmsListPanel)comp).addUpload(new File(observer.getFolder(), filename));
                        }
                    }
                }
            });
        }
    }

    public boolean show() {
        Dimension windowsize = THEMIS.getWindowSize(this.element.getElementcode(), this.app);
        if (windowsize != null) {
            this.panel.setSize(windowsize);
            this.panel.setPreferredSize(windowsize);
        }
        String dlgTitle = this.element.getTitle();
        if (this.element.getTitle().contains("[]")) {
            dlgTitle = "Beobachtung erstellen";
        }
        DialogDescriptor dlg = new DialogDescriptor((Object)this.panel, dlgTitle, true, 2, DialogDescriptor.OK_OPTION, null);
        this.observer.start();
        CmsUser currentUser = this.element.getCurrentUser();
        CmsElement log = this.element.getApplication().createElement("log", this.element.getCurrentUser());
        log.getDateAttribute("startedit").setDate(new Date());
        log.getLongAttribute("observationid").setValue(this.element.getId());
        log.getLongAttribute("eventid").setValue(this.app.getProject().getCurrentEventId());
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
        this.observer.unregisterListener();
        this.observer.stopRunning();
        ThemisUtil.setWindowSize((String)this.element.getElementcode(), (Dimension)this.panel.getSize(), (ThemisApplication)this.app);
        if (result == DialogDescriptor.OK_OPTION && !this.readonly) {
            this.panel.updateElement();
            if (!this.element.verify(null)) {
                Dialogs.getInstance().showWarningDialog(this.element.getStatusmessage());
                return this.show();
            }
            this.element.save();
            if ("observation".equals(this.element.getElementcode())) {
                log.getDateAttribute("endedit").setDate(new Date());
                log.save();
            }
            return true;
        }
        return false;
    }

    public static boolean show(CmsElement ele) {
        return ElementDialog.show(ele, false);
    }

    public static boolean show(CmsElement ele, boolean readonly) {
        CmsElementPanel p = new CmsElementPanel(ele);
        ThemisApplication app = ThemisApplication.getInstance();
        Dimension windowsize = THEMIS.getWindowSize(ele.getElementcode(), app);
        if (windowsize != null) {
            p.setSize(windowsize);
            p.setPreferredSize(windowsize);
        }
        DialogDescriptor dlg = new DialogDescriptor((Object)p, ele.getTitle(), true, 2, DialogDescriptor.OK_OPTION, null);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
        if (result == DialogDescriptor.OK_OPTION && !readonly) {
            p.updateElement();
            if (!ele.verify(null)) {
                Dialogs.getInstance().showWarningDialog(ele.getStatusmessage());
                return ElementDialog.show(ele);
            }
            ele.save();
            ThemisUtil.setWindowSize((String)ele.getElementcode(), (Dimension)p.getSize(), (ThemisApplication)app);
            return true;
        }
        ThemisUtil.setWindowSize((String)ele.getElementcode(), (Dimension)p.getSize(), (ThemisApplication)app);
        return false;
    }
}

