/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.event;

import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.EventPanel;
import at.grid.themis.application.MigrateEventPanel;
import at.grid.themis.application.SignaturePanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ThemisActions;
import at.grid.themis.application.action.ThemisUserAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.tutorial.Assistant;
import at.grid.themis.application.tutorial.Step;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.FontUIResource;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="EventTopComponent", persistenceType=0)
public final class EventTopComponent
extends TopComponent
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    HashMap<String, ThemisUserAction> userActions = new HashMap();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/Bundle");
    private JButton btnAdd;
    private JButton btnCopy;
    private JButton btnEdit;
    private JButton btnEditCurrentEvent;
    private JButton btnEventYearClear;
    private JButton btnEventYearOk;
    private JButton btnExitCurrentEvent;
    private JButton btnRemove;
    private JButton btnShowActionMenu;
    private JButton btnStart;
    private JTextField fldCurrentEvent;
    private JTextField fldEventMonth;
    private JTextField fldEventYear;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JLabel lblEvents;
    private JLabel lblEvents1;
    private JList lstEvents;

    public EventTopComponent() {
        this.initComponents();
        this.lstEvents.setCellRenderer(new EventListRenderer(5));
        this.populate();
        ThemisActionProvider.getInstance().register(this);
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 1101: {
                ((DefaultListModel)this.lstEvents.getModel()).clear();
                this.fldCurrentEvent.setText(this.bundle.getString("EventTopComponent.noEventSelected.text"));
                this.updateActions();
                break;
            }
            case 1100: {
                this.populate();
                this.updateActions();
                this.showNextAssistantStep();
                break;
            }
            case 300: {
                if (action.getId() > 0L) {
                    this.populate();
                    break;
                }
                this.populate();
                break;
            }
            case 302: {
                this.populate();
            }
        }
    }

    private void updateActions() {
        boolean isViewer = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE);
        long currentEventId = this.project.getCurrentEventId();
        boolean hasCurrentEvent = this.project.getSelectionManager().getCurrentEventId() > 0L;
        CmsBasicElement ele = (CmsBasicElement)this.lstEvents.getSelectedValue();
        CmsEvent ev = null;
        if (ele != null) {
            ev = (CmsEvent)this.project.loadElement(ele.getId(), this.project.getUser());
        }
        this.btnCopy.setEnabled(ele != null && !isViewer);
        this.btnEdit.setEnabled(ev != null && !isViewer && !ev.isSigned());
        this.btnRemove.setEnabled(ev != null && !isViewer && !ev.isSigned());
        this.btnStart.setEnabled(ev != null && !isViewer && !ev.isSigned());
        this.btnShowActionMenu.setEnabled(!this.project.isThemisFileDirectAccess());
    }

    private void populate() {
        CmsEvent currentEvent = this.app.getProject().getSelectionManager().getCurrentEvent();
        this.fldCurrentEvent.setText(currentEvent == null ? "<kein aktuelles Ereignis>" : currentEvent.getTitle());
        long currentEventId = currentEvent == null ? -1L : currentEvent.getId();
        CmsBasicElement oldSel = (CmsBasicElement)this.lstEvents.getSelectedValue();
        CmsBasicElement sel = null;
        ((DefaultListModel)this.lstEvents.getModel()).removeAllElements();
        int eventcount = 0;
        if (this.project.isOpen()) {
            int year = Util.parseInt((String)this.fldEventYear.getText(), (int)-1);
            int month = Util.parseInt((String)this.fldEventMonth.getText(), (int)-1);
            SearchResult result = this.project.getEventSearchResult(year, month, false);
            eventcount = result.size();
            ArrayList events = result.getResultAsBasicElements(new String[]{"signature"});
            for (CmsBasicElement ev : events) {
                if (oldSel != null && oldSel.getId() == ev.getId()) {
                    sel = ev;
                }
                String isSigned = ev.getAttribute("signature");
                if (ev.getId() == currentEventId) {
                    ev.setTitle(ev.getTitle() + " <aktuell>");
                } else if (ev.getAttribute("signature") != null && !"".equals(isSigned)) {
                    ev.setTitle(ev.getTitle() + " <versiegelt>");
                }
                ((DefaultListModel)this.lstEvents.getModel()).addElement(ev);
            }
            this.lstEvents.setSelectedValue(sel, true);
        }
        this.updateButtonStates();
        this.setDisplayName("Ereignisliste" + (this.project.isOpen() ? " (" + eventcount + ")" : ""));
    }

    private void updateButtonStates() {
        boolean isViewer = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE);
        boolean hasCurrentEvent = this.project.getSelectionManager().getCurrentEventId() > 0L;
        CmsBasicElement ele = (CmsBasicElement)this.lstEvents.getSelectedValue();
        CmsEvent ev = null;
        if (ele != null) {
            ev = (CmsEvent)this.project.loadElement(ele.getId(), this.project.getUser());
        }
        this.btnCopy.setEnabled(ele != null && !isViewer);
        this.btnEdit.setEnabled(ev != null && !isViewer && !ev.isSigned());
        this.btnRemove.setEnabled(ev != null && !isViewer && !ev.isSigned());
        this.btnStart.setEnabled(ev != null && !isViewer && !ev.isSigned());
        this.btnEditCurrentEvent.setEnabled(!isViewer);
        if (hasCurrentEvent) {
            this.btnEditCurrentEvent.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_editObs24.gif")));
        } else {
            this.btnEditCurrentEvent.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        }
        this.btnExitCurrentEvent.setEnabled(!isViewer && hasCurrentEvent);
    }

    private void createNewEvent(boolean edit) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isThemisFileDirectAccess() && !THEMIS.checkNoEvent((Object)this)) {
            return;
        }
        CmsEvent ev = (CmsEvent)this.project.createElement("event");
        Date dt = new Date();
        ev.getDateAttribute("date").setDate(dt);
        ev.setAttributeValue("title", this.settings.getTerm(ThemisSettings.Term.NewEventTitle));
        EventPanel event = new EventPanel();
        event.editEvent(ev);
        if (!ev.isSaved()) {
            return;
        }
        this.project.setCurrentEvent(ev);
    }

    private void finishChurrentEvent() {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen() && this.project.getSelectionManager().getCurrentEventId() > 0L) {
            ThemisActions.setCurrenetEvent(null);
            this.populate();
        }
    }

    private void copyEvent(boolean withPlanung) {
        CmsBasicElement ele;
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen() && (ele = (CmsBasicElement)this.lstEvents.getSelectedValue()) != null) {
            CmsElement event = this.project.loadElement(ele.getId(), this.project.getUser());
            EventPanel eventPanel = new EventPanel();
            CmsElement newEvent = event.copy("histories");
            ((CmsEvent)newEvent).removeSignature(false);
            if (!withPlanung) {
                newEvent.getRelationAttribute("plannedobservations").clear();
            }
            eventPanel.createEvent(newEvent);
            this.populate();
        }
    }

    private void setSelectedEvent() {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        CmsBasicElement ev = (CmsBasicElement)this.lstEvents.getSelectedValue();
        if (ev != null) {
            if (this.project.isEventSigned(ev.getId())) {
                this.app.getDialog().showErrorDialog("error.event-is-signed");
                return;
            }
            CmsEvent event = (CmsEvent)this.project.loadElement(ev.getId(), this.project.getUser());
            this.project.setCurrentEvent(event);
            this.populate();
        }
    }

    private void editEvent(CmsEvent event) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || event == null) {
            return;
        }
        if (event.isSigned()) {
            this.app.getDialog().showErrorDialog("text.event.sealed");
            return;
        }
        EventPanel eventPanel = new EventPanel();
        eventPanel.editEvent(event.getId());
        if (this.project.getSelectionManager().getCurrentEventId() == event.getId()) {
            this.project.getSelectionManager().updateCurrentEvent();
        }
        this.populate();
    }

    private void migrateEvent() {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen()) {
            final CmsEvent currentEvent = this.project.getCurrentEvent();
            if (currentEvent == null) {
                Dialogs.getInstance().showErrorDialog("no-event");
                return;
            }
            CmsBasicElement ele = (CmsBasicElement)this.lstEvents.getSelectedValue();
            if (ele == null) {
                Dialogs.getInstance().showErrorDialog("error.migrateEvent.noEventSelected");
                return;
            }
            if (ele.getId() == currentEvent.getId()) {
                Dialogs.getInstance().showErrorDialog("error.migrateEvent.selectionIsCurrent");
                return;
            }
            final CmsEvent event = (CmsEvent)this.project.loadElement(ele.getId(), this.project.getUser());
            if (event.isSigned()) {
                ThemisApplication.getInstance().getDialog().showWarningDialog(this.bundle.getString("error.migrateEvent.signedEvent"));
                return;
            }
            ArrayList obsIds = event.getObservationIds();
            ArrayList currentObsIds = currentEvent.getObservationIds();
            final ArrayList<Long> obsIdsMigrate = new ArrayList<Long>();
            ArrayList<Long> obsIdsConflict = new ArrayList<Long>();
            Iterator iterator = obsIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (currentObsIds.contains(id)) {
                    obsIdsConflict.add(id);
                    continue;
                }
                obsIdsMigrate.add(id);
            }
            final MigrateEventPanel panel = new MigrateEventPanel(currentEvent.getTitle(), event.getTitle(), obsIdsConflict);
            if (Dialogs.getInstance().showDialog(panel, this.bundle.getString("EventTopComponent.migrateEventTitle"), new String[]{this.project.getResourceText("dialog.ok"), this.project.getResourceText("dialog.cancel")}) == 0) {
                String progressTitle = this.bundle.getString("EventTopComponent.migrateEventTitle");
                BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

                    public String run(ProgressHandle ph) {
                        int maxcounter = obsIdsMigrate.size();
                        ph.switchToDeterminate(maxcounter);
                        int counter = 0;
                        String[] stringArray = obsIdsMigrate.iterator();
                        while (stringArray.hasNext()) {
                            long id = (Long)stringArray.next();
                            CmsObservation observation = (CmsObservation)EventTopComponent.this.project.loadElement(id, EventTopComponent.this.project.getUser());
                            List obsHistories = observation.getHistories();
                            CmsHistory history = observation.getHistory(event);
                            observation.applyHistory(history);
                            for (UploadItem item : history.getUploadAttribute("files").getAllUploadItems()) {
                                File targetFile = Util.getUniqueFile((File)EventTopComponent.this.project.getTempfileLocation(), (String)item.getName());
                                try {
                                    Util.copy((File)item.getFile(), (File)targetFile);
                                    observation.getUploadAttribute("files").addUpload(targetFile);
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            observation.save();
                            ph.setDisplayName("Integration l\u00e4uft");
                            ph.progress("Beobachtungen werden \u00fcbernommen", counter);
                            ++counter;
                        }
                        if (panel.deleteSelectedEvent()) {
                            EventTopComponent.this.deleteEvent(true, false);
                        }
                        if (panel.copyDescription()) {
                            currentEvent.reload();
                            for (String code : new String[]{"comment", "participants", "place", "time"}) {
                                String t1 = currentEvent.getAttributeValue(code);
                                if (!event.hasAttributeValue(code)) continue;
                                String t2 = event.getAttributeValue(code);
                                String lb = event.getAttribute(code).isOfType(13) ? "\n" : ", ";
                                currentEvent.setAttributeValue(code, (currentEvent.hasAttributeValue(code) ? t1 + lb + event.getTitle() + ": " : "") + t2);
                            }
                            currentEvent.save();
                        }
                        ph.finish();
                        THEMIS.dismissNotify(5, THEMIS.notify(5, EventTopComponent.this.bundle.getString("EventTopComponent.migrateDoneTitle"), EventTopComponent.this.bundle.getString("EventTopComponent.migrateDoneText")));
                        return null;
                    }
                }, (String)progressTitle, (boolean)true);
            }
        }
    }

    private void deleteEvent(boolean force, boolean askDeleteLocation) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen()) {
            boolean doremove;
            CmsBasicElement ele = (CmsBasicElement)this.lstEvents.getSelectedValue();
            if (ele == null) {
                return;
            }
            final CmsEvent event = (CmsEvent)this.project.loadElement(ele.getId(), this.project.getUser());
            if (event.isSigned()) {
                ThemisApplication.getInstance().getDialog().showWarningDialog(this.bundle.getString("EventTopComponent.deleteSignedEvent"));
                return;
            }
            int countHistories = event.getRelationAttribute("histories").getElements(false).size();
            boolean bl = doremove = force || countHistories == 0 || ThemisApplication.getInstance().getDialog().showConfirmDialog("Sie haben " + countHistories + " Beobachtungen im Rahmen dieses Ereignisses bearbeitet bzw. erfasst. Diese Informationen werden ebenfalls gel\u00f6scht. Wollen Sie fortfahren?");
            if (doremove) {
                CmsEvent currentEvent = this.project.getCurrentEvent();
                if (currentEvent != null && event.getId() == currentEvent.getId()) {
                    currentEvent = null;
                }
                BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

                    public String run(ProgressHandle ph) {
                        ThemisProgressHandler p = new ThemisProgressHandler(ph);
                        p.switchToDeterminate(event.getRelationAttribute("histories").size());
                        event.moveToTrash((ProgressHandler)p);
                        return null;
                    }
                }, (String)this.project.getResourceText("progress.event-delete.title"), (boolean)true);
                this.project.createActionLog("event_delete", ele.getId(), "");
                this.app.getFilter().resetSearchResult();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.EVENT_DELETED.setId(ele.getId()));
            }
        }
    }

    private void sealEvent() {
        List eles = this.lstEvents.getSelectedValuesList();
        boolean allSigned = true;
        for (CmsBasicElement ele : eles) {
            allSigned = allSigned && this.project.isEventSigned(ele.getId());
        }
        if (allSigned) {
            this.app.getDialog().showInfoDialog(this.bundle.getString("message.allEventsSealed"));
            return;
        }
        if (eles.size() > 0 && !allSigned) {
            SignaturePanel p = new SignaturePanel();
            UIManager.put("OptionPane.buttonFont", new FontUIResource(THEMIS.fontButton));
            if (Dialogs.getInstance().showDialog(p, this.app.getProject().getResourceText("app.core.text.signature", this.app.getLocale()), new String[]{this.app.getProject().getResourceText("app.core.text.apply", this.app.getLocale()), this.app.getProject().getResourceText("app.core.text.cancel", this.app.getLocale())}) == 0) {
                try {
                    if (!Dialogs.getInstance().showOptionDialog(this.app.getProject().getResourceText("app.text.event.reallysealevent", this.app.getLocale()), "", new Object[]{this.app.getProject().getResourceText("app.core.text.yes", this.app.getLocale()), this.app.getProject().getResourceText("app.core.text.no", this.app.getLocale())})) {
                        return;
                    }
                    File f = new File(this.project.getTempfileLocation(), "signatur.jpg");
                    p.writeToFile(f);
                    for (CmsBasicElement ele : eles) {
                        if (this.project.isEventSigned(ele.getId())) continue;
                        CmsEvent e = (CmsEvent)this.project.loadElement(ele.getId(), this.project.getUser());
                        e.sign(f);
                        this.project.createActionLog("event_sign", e.getId(), "signed by user " + e.getCurrentUser().getUsername());
                    }
                    this.populate();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void showActionMenu() {
        int c;
        JMenuItem item;
        List eles = this.lstEvents.getSelectedValuesList();
        boolean allSigned = true;
        for (CmsBasicElement ele : eles) {
            allSigned = allSigned && this.project.isEventSigned(ele.getId());
        }
        boolean isViewer = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE);
        long currentEventId = this.project.getSelectionManager().getCurrentEventId();
        JPopupMenu menu = new JPopupMenu("Optionen");
        if (!isViewer && eles.size() == 1 && currentEventId > 0L && currentEventId != ((CmsBasicElement)eles.get(0)).getId() && !allSigned) {
            item = THEMIS.createMenuItem("Zusammenf\u00fchren", Color.WHITE, false, null);
            item.addActionListener(e2 -> {
                this.migrateEvent();
                this.populate();
            });
            menu.add(item);
        }
        if (!isViewer && eles.size() > 0 && !allSigned) {
            item = THEMIS.createMenuItem("Versiegeln", Color.WHITE, false, null);
            item.addActionListener(e2 -> this.sealEvent());
            menu.add(item);
        }
        if ((c = menu.getComponentCount()) > 0) {
            menu.show(this.btnShowActionMenu, this.btnShowActionMenu.getWidth(), 0);
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel7 = new JLabel();
        this.fldCurrentEvent = new JTextField();
        this.btnEditCurrentEvent = new JButton();
        this.btnExitCurrentEvent = new JButton();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.lblEvents = new JLabel();
        this.fldEventYear = new JTextField();
        this.lblEvents1 = new JLabel();
        this.fldEventMonth = new JTextField();
        this.btnEventYearOk = new JButton();
        this.btnEventYearClear = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lstEvents = new JList();
        this.jPanel1 = new JPanel();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnCopy = new JButton();
        this.btnRemove = new JButton();
        this.jLabel1 = new JLabel();
        this.btnStart = new JButton();
        this.btnShowActionMenu = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel7.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.jLabel7.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.fldCurrentEvent.setEditable(false);
        this.fldCurrentEvent.setFont(THEMIS.fontSubheading);
        this.fldCurrentEvent.setHorizontalAlignment(0);
        this.fldCurrentEvent.setText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.fldCurrentEvent.text"));
        this.fldCurrentEvent.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.jPanel2.add((Component)this.fldCurrentEvent, gridBagConstraints);
        this.btnEditCurrentEvent.setFont(THEMIS.fontButton);
        this.btnEditCurrentEvent.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_editObs24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEditCurrentEvent, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnEditCurrentEvent.text"));
        this.btnEditCurrentEvent.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnEditCurrentEvent.toolTipText"));
        this.btnEditCurrentEvent.setBorder(new SoftBevelBorder(0));
        this.btnEditCurrentEvent.setMinimumSize(new Dimension(55, 35));
        this.btnEditCurrentEvent.setPreferredSize(new Dimension(55, 35));
        this.btnEditCurrentEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnEditCurrentEventActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnEditCurrentEvent, gridBagConstraints);
        this.btnExitCurrentEvent.setFont(THEMIS.fontButton);
        this.btnExitCurrentEvent.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/exit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnExitCurrentEvent, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnExitCurrentEvent.text"));
        this.btnExitCurrentEvent.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnExitCurrentEvent.toolTipText"));
        this.btnExitCurrentEvent.setBorder(new SoftBevelBorder(0));
        this.btnExitCurrentEvent.setMinimumSize(new Dimension(55, 35));
        this.btnExitCurrentEvent.setPreferredSize(new Dimension(55, 35));
        this.btnExitCurrentEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnExitCurrentEventActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnExitCurrentEvent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add(this.jPanel2, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add(this.jLabel5, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.lblEvents.setFont(THEMIS.fontLabelBig);
        Mnemonics.setLocalizedText((JLabel)this.lblEvents, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.lblEvents.text"));
        this.lblEvents.setMinimumSize(new Dimension(5, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblEvents, gridBagConstraints);
        this.fldEventYear.setFont(THEMIS.fontTextfield);
        this.fldEventYear.setHorizontalAlignment(0);
        this.fldEventYear.setText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.fldEventYear.text"));
        this.fldEventYear.setMinimumSize(new Dimension(30, 35));
        this.fldEventYear.setPreferredSize(new Dimension(50, 35));
        this.fldEventYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.fldEventYearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.fldEventYear, gridBagConstraints);
        this.lblEvents1.setFont(THEMIS.fontLabelBig);
        Mnemonics.setLocalizedText((JLabel)this.lblEvents1, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.lblEvents1.text"));
        this.lblEvents1.setMinimumSize(new Dimension(5, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblEvents1, gridBagConstraints);
        this.fldEventMonth.setFont(THEMIS.fontTextfield);
        this.fldEventMonth.setHorizontalAlignment(0);
        this.fldEventMonth.setText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.fldEventMonth.text"));
        this.fldEventMonth.setMinimumSize(new Dimension(30, 35));
        this.fldEventMonth.setPreferredSize(new Dimension(50, 35));
        this.fldEventMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.fldEventMonthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.fldEventMonth, gridBagConstraints);
        this.btnEventYearOk.setFont(THEMIS.fontButton);
        this.btnEventYearOk.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEventYearOk, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnEventYearOk.text"));
        this.btnEventYearOk.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnEventYearOk.toolTipText"));
        this.btnEventYearOk.setBorder(new SoftBevelBorder(0));
        this.btnEventYearOk.setMinimumSize(new Dimension(5, 30));
        this.btnEventYearOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnEventYearOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnEventYearOk, gridBagConstraints);
        this.btnEventYearClear.setFont(THEMIS.fontButton);
        this.btnEventYearClear.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEventYearClear, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnEventYearClear.text"));
        this.btnEventYearClear.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnEventYearClear.toolTipText"));
        this.btnEventYearClear.setBorder(new SoftBevelBorder(0));
        this.btnEventYearClear.setMinimumSize(new Dimension(5, 30));
        this.btnEventYearClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnEventYearClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnEventYearClear, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jPanel4, gridBagConstraints);
        this.lstEvents.setFont(THEMIS.fontList);
        this.lstEvents.setModel(new DefaultListModel());
        this.lstEvents.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                EventTopComponent.this.lstEventsMousePressed(evt);
            }
        });
        this.lstEvents.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                EventTopComponent.this.lstEventsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstEvents);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add(this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnAdd.setFont(THEMIS.fontButton);
        this.btnAdd.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnAdd.text"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnAdd.toolTipText"));
        this.btnAdd.setBorder(new SoftBevelBorder(0));
        this.btnAdd.setMaximumSize(null);
        this.btnAdd.setMinimumSize(null);
        this.btnAdd.setPreferredSize(null);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnAdd, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnEdit, gridBagConstraints);
        this.btnCopy.setFont(THEMIS.fontButton);
        this.btnCopy.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopy, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnCopy.text"));
        this.btnCopy.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnCopy.toolTipText"));
        this.btnCopy.setBorder(new SoftBevelBorder(0));
        this.btnCopy.setMaximumSize(null);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnCopy, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnRemove.toolTipText"));
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.setMaximumSize(null);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.btnStart.setFont(THEMIS.fontButton);
        this.btnStart.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnStart, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnStart.text"));
        this.btnStart.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnStart.toolTipText"));
        this.btnStart.setBorder(new SoftBevelBorder(0));
        this.btnStart.setMaximumSize(new Dimension(400, 30));
        this.btnStart.setMinimumSize(null);
        this.btnStart.setPreferredSize(null);
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnStart, gridBagConstraints);
        this.btnShowActionMenu.setFont(THEMIS.fontButton);
        this.btnShowActionMenu.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/menu_options24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowActionMenu, (String)NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnShowActionMenu.text"));
        this.btnShowActionMenu.setToolTipText(NbBundle.getMessage(EventTopComponent.class, (String)"EventTopComponent.btnShowActionMenu.toolTipText"));
        this.btnShowActionMenu.setBorder(new SoftBevelBorder(0));
        this.btnShowActionMenu.setDisabledIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/menu_options_disabled24.gif")));
        this.btnShowActionMenu.setMaximumSize(new Dimension(400, 30));
        this.btnShowActionMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventTopComponent.this.btnShowActionMenuActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnShowActionMenu, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add(this.jPanel1, gridBagConstraints);
    }

    private void btnStartActionPerformed(ActionEvent evt) {
        this.setSelectedEvent();
    }

    private void fldEventYearActionPerformed(ActionEvent evt) {
        this.populate();
    }

    private void fldEventMonthActionPerformed(ActionEvent evt) {
        this.populate();
    }

    private void btnEventYearOkActionPerformed(ActionEvent evt) {
        this.populate();
    }

    private void btnEventYearClearActionPerformed(ActionEvent evt) {
        this.fldEventYear.setText("");
        this.fldEventMonth.setText("");
        this.populate();
    }

    private void lstEventsMousePressed(MouseEvent evt) {
        int count;
        if (this.lstEvents.getModel().getSize() > 0 && (count = evt.getClickCount()) == 2 && !ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            this.setSelectedEvent();
        }
    }

    private void lstEventsValueChanged(ListSelectionEvent evt) {
        this.updateButtonStates();
    }

    private void btnEditCurrentEventActionPerformed(ActionEvent evt) {
        if (this.project.getSelectionManager().getCurrentEventId() > 0L) {
            this.editEvent(this.project.getCurrentEvent());
        } else {
            this.createNewEvent(true);
        }
    }

    private void btnExitCurrentEventActionPerformed(ActionEvent evt) {
        this.finishChurrentEvent();
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        this.deleteEvent(false, true);
        this.populate();
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        CmsBasicElement sel = (CmsBasicElement)this.lstEvents.getSelectedValue();
        if (sel != null) {
            CmsEvent ev = (CmsEvent)this.project.loadElement(sel.getId(), this.project.getUser());
            boolean withPlanung = false;
            if (!ev.getPlannedObservationIds().isEmpty()) {
                withPlanung = this.app.getDialog().showConfirmDialog("Soll die Planung f\u00fcr das Ereignis in der Kopie \u00fcbernommen werden?", "Ereignis kopieren");
            }
            this.copyEvent(withPlanung);
        }
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        CmsBasicElement sel = (CmsBasicElement)this.lstEvents.getSelectedValue();
        if (sel != null) {
            CmsEvent ev = (CmsEvent)this.project.loadElement(sel.getId(), this.project.getUser());
            this.editEvent(ev);
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.createNewEvent(true);
    }

    private void btnShowActionMenuActionPerformed(ActionEvent evt) {
        this.showActionMenu();
    }

    public void componentOpened() {
        this.populate();
    }

    public void componentClosed() {
    }

    public void componentHidden() {
    }

    public void componentShowing() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void showNextAssistantStep() {
        if (this.lstEvents != null && this.lstEvents.getModel().getSize() > 0) {
            Assistant.getInstance().setNextStep(this.jScrollPane1, Step.SELECT_EVENT);
        } else {
            Assistant.getInstance().setNextStep(this.btnAdd, Step.CREATE_EVENT);
        }
    }

    private class EventListRenderer
    extends SimpleTextRenderer {
        public EventListRenderer() {
        }

        public EventListRenderer(int border) {
            super(border);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            CmsBasicElement ele = (CmsBasicElement)value;
            if (EventTopComponent.this.project.isEventSigned(ele.getId())) {
                lbl.setForeground(Color.red);
            } else if (EventTopComponent.this.app.getProject().getCurrentEventId() == ele.getId()) {
                lbl.setForeground(Color.BLUE);
                lbl.setFont(THEMIS.fontListBold);
                lbl.setBackground(Color.LIGHT_GRAY);
            } else {
                lbl.setForeground(Color.black);
            }
            return lbl;
        }
    }
}

