/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.filter;

import at.grid.cms.CmsApplication;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.ui.CheckableItem;
import at.grid.themis.application.ui.JComboCheckBox;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.filter.ThemisFilterBoolean;
import at.grid.themis.ontology.filter.ThemisFilterListItem;
import at.grid.themis.ontology.settings.ThemisSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.jdesktop.swingx.JXDatePicker;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class FilterPanel
extends JPanel
implements ThemisActionListener {
    private ImageIcon iconUp = new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif"));
    private ImageIcon iconDown = new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif"));
    DefaultComboBoxModel<CheckableItem<CmsBasicElement>> modelEvent = new DefaultComboBoxModel();
    DefaultComboBoxModel<CheckableItem<KeytableRecord>> modelType = new DefaultComboBoxModel();
    DefaultComboBoxModel<String> modelEventOption = new DefaultComboBoxModel();
    DefaultComboBoxModel<CheckableItem<CmsBasicElement>> modelMap = new DefaultComboBoxModel();
    DefaultComboBoxModel<CheckableItem<CmsBasicElement>> modelBuilding = new DefaultComboBoxModel();
    DefaultComboBoxModel<CheckableItem<CmsBasicElement>> modelContact = new DefaultComboBoxModel();
    DefaultComboBoxModel<CheckableItem<KeytableRecord>> modelObsType = new DefaultComboBoxModel();
    DefaultComboBoxModel<CheckableItem<KeytableRecord>> modelPriority = new DefaultComboBoxModel();
    DefaultComboBoxModel<CheckableItem<KeytableRecord>> modelTopic = new DefaultComboBoxModel();
    DefaultComboBoxModel<CheckableItem<CmsBasicElement>> modelLocGroup = new DefaultComboBoxModel();
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    ThemisFilter filter = ThemisApplication.getInstance().getFilter();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/filter/Bundle");
    boolean triggerFilter = true;
    CmsBasicElement currentFilterElement = null;
    private JButton btnClearDuedate;
    private JButton btnClearEvent;
    private JButton btnClearEventDates;
    private JButton btnClearFilter;
    private JButton btnClearLocBarcode;
    private JButton btnClearLocBuilding;
    private JButton btnClearLocDates1;
    private JButton btnClearLocDates2;
    private JButton btnClearLocDates3;
    private JButton btnClearLocDates4;
    private JButton btnClearLocFreeText;
    private JButton btnClearLocGroup;
    private JButton btnClearLocLangtext1;
    private JButton btnClearLocLangtext2;
    private JButton btnClearLocLangtext3;
    private JButton btnClearLocLangtext4;
    private JButton btnClearLocList1;
    private JButton btnClearLocList2;
    private JButton btnClearLocList3;
    private JButton btnClearLocList4;
    private JButton btnClearLocPlan;
    private JButton btnClearLocRange;
    private JButton btnClearLocText1;
    private JButton btnClearLocText2;
    private JButton btnClearLocText3;
    private JButton btnClearLocText4;
    private JButton btnClearObsAmount;
    private JButton btnClearObsCode;
    private JButton btnClearObsContacts;
    private JButton btnClearObsFreetext;
    private JButton btnClearObsFreetext1;
    private JButton btnClearObsFreetext2;
    private JButton btnClearObsFreetext3;
    private JButton btnClearObsLangtext1;
    private JButton btnClearObsLangtext2;
    private JButton btnClearObsPriority;
    private JButton btnClearObsRealType;
    private JButton btnClearObsRisk;
    private JButton btnClearObsTopic;
    private JButton btnClearObsType;
    private JButton btnDeleteFilterElement;
    private JButton btnEventFilter;
    private JButton btnLoadFilterElement;
    private JButton btnLocFilter;
    private JButton btnObsFilter;
    private JButton btnSaveFilterElement;
    private JButton btnSearchEventDates;
    private JButton btnSearchLocBarcode;
    private JButton btnSearchLocFreeText;
    private JButton btnSearchLocLangtext1;
    private JButton btnSearchLocLangtext2;
    private JButton btnSearchLocLangtext3;
    private JButton btnSearchLocLangtext4;
    private JButton btnSearchLocRange;
    private JButton btnSearchLocText1;
    private JButton btnSearchLocText2;
    private JButton btnSearchLocText3;
    private JButton btnSearchLocText4;
    private JButton btnSearchObsAmount;
    private JButton btnSearchObsCode;
    private JButton btnSearchObsFreetext;
    private JButton btnSearchObsFreetext1;
    private JButton btnSearchObsFreetext2;
    private JButton btnSearchObsFreetext3;
    private JButton btnSearchObsLangtext1;
    private JButton btnSearchObsLangtext2;
    private JButton btnSearchObsRisk;
    private JButton btnSetLocDates1;
    private JButton btnSetLocDates2;
    private JButton btnSetLocDates3;
    private JButton btnSetLocDates4;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JComboBox<CheckableItem<CmsBasicElement>> fldContact;
    private JXDatePicker fldDuedate;
    private JComboBox<CheckableItem<CmsBasicElement>> fldEvent;
    private JXDatePicker fldEventDateFrom;
    private JXDatePicker fldEventDateUntil;
    private JComboBox<String> fldEventOption;
    private JComboBox<CmsBasicElement> fldFilterElements;
    private JTextField fldLocBarcode;
    private JComboBox<CheckableItem<CmsBasicElement>> fldLocBuilding;
    private JXDatePicker fldLocDate1From;
    private JXDatePicker fldLocDate1Until;
    private JXDatePicker fldLocDate2From;
    private JXDatePicker fldLocDate2Until;
    private JXDatePicker fldLocDate3From;
    private JXDatePicker fldLocDate3Until;
    private JXDatePicker fldLocDate4From;
    private JXDatePicker fldLocDate4Until;
    private JComboBox<CheckableItem<CmsBasicElement>> fldLocGroup;
    private JTextField fldLocLangtext1;
    private JTextField fldLocLangtext2;
    private JTextField fldLocLangtext3;
    private JTextField fldLocLangtext4;
    private JComboBox<CheckableItem<KeytableRecord>> fldLocList1;
    private JComboBox<CheckableItem<KeytableRecord>> fldLocList2;
    private JComboBox<CheckableItem<KeytableRecord>> fldLocList3;
    private JComboBox<CheckableItem<KeytableRecord>> fldLocList4;
    private JComboBox<CheckableItem<CmsBasicElement>> fldLocPlan;
    private JTextField fldLocText1;
    private JTextField fldLocText2;
    private JTextField fldLocText3;
    private JTextField fldLocText4;
    private JComboBox fldLocVisibility;
    private JTextField fldLocationRange;
    private JTextField fldLocationTextFilter;
    private JTextField fldObsAmount;
    private JTextField fldObsCode;
    private JTextField fldObsFreetext1;
    private JTextField fldObsFreetext2;
    private JTextField fldObsFreetext3;
    private JTextField fldObsLangtext1;
    private JTextField fldObsLangtext2;
    private JComboBox<CheckableItem<KeytableRecord>> fldObsList1;
    private JComboBox<CheckableItem<KeytableRecord>> fldObsList2;
    private JComboBox<CheckableItem<KeytableRecord>> fldObsList3;
    private JComboBox<CheckableItem<KeytableRecord>> fldObsRealType;
    private JTextField fldObsRisk;
    private JTextField fldObsTextFilter;
    private JComboBox<String> fldStatus;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lblContact;
    private JLabel lblControlled;
    private JLabel lblDueDate;
    private JLabel lblEmpty;
    private JLabel lblExclude;
    private JLabel lblLocBarcode;
    private JLabel lblLocDate1;
    private JLabel lblLocDate2;
    private JLabel lblLocDate3;
    private JLabel lblLocDate4;
    private JLabel lblLocFlag1;
    private JLabel lblLocFlag2;
    private JLabel lblLocFlag3;
    private JLabel lblLocFlag4;
    private JLabel lblLocGroup;
    private JLabel lblLocGroup2;
    private JLabel lblLocList1;
    private JLabel lblLocList2;
    private JLabel lblLocList3;
    private JLabel lblLocList4;
    private JLabel lblLocLongtext1;
    private JLabel lblLocLongtext2;
    private JLabel lblLocLongtext3;
    private JLabel lblLocLongtext4;
    private JLabel lblLocText1;
    private JLabel lblLocText2;
    private JLabel lblLocText3;
    private JLabel lblLocText4;
    private JLabel lblLocVisibility;
    private JLabel lblLocation;
    private JLabel lblMap;
    private JLabel lblMap1;
    private JLabel lblMap10;
    private JLabel lblMap11;
    private JLabel lblMap2;
    private JLabel lblMap3;
    private JLabel lblMap4;
    private JLabel lblMap5;
    private JLabel lblMap6;
    private JLabel lblMap7;
    private JLabel lblMap8;
    private JLabel lblMap9;
    private JLabel lblObsAmount;
    private JLabel lblObsCode1;
    private JLabel lblObsFreeText;
    private JLabel lblObsFreetext1;
    private JLabel lblObsFreetext2;
    private JLabel lblObsFreetext3;
    private JLabel lblObsLangtext1;
    private JLabel lblObsLangtext2;
    private JLabel lblObsList1;
    private JLabel lblObsList2;
    private JLabel lblObsList3;
    private JLabel lblObsRisk;
    private JLabel lblPlanned1;
    private JLabel lblRealObsType;
    private JLabel lblStatus;
    private JPanel mainPanel;
    private JPanel panelCategory;
    private JPanel panelContact;
    private JPanel panelDueDate;
    private JPanel panelEventDates;
    private JPanel panelEventFilter;
    private JPanel panelLocBarcode;
    private JPanel panelLocBuilding;
    private JPanel panelLocFlag1;
    private JPanel panelLocFlag2;
    private JPanel panelLocFlag3;
    private JPanel panelLocFlag4;
    private JPanel panelLocFreeText;
    private JPanel panelLocGroup;
    private JPanel panelLocList1;
    private JPanel panelLocList2;
    private JPanel panelLocList3;
    private JPanel panelLocList4;
    private JPanel panelLocLongtext1;
    private JPanel panelLocLongtext2;
    private JPanel panelLocLongtext3;
    private JPanel panelLocLongtext4;
    private JPanel panelLocMap;
    private JPanel panelLocRangeFilter;
    private JPanel panelLocText1;
    private JPanel panelLocText2;
    private JPanel panelLocText3;
    private JPanel panelLocText4;
    private JPanel panelLocVisibility;
    private JPanel panelLocationDates1;
    private JPanel panelLocationDates2;
    private JPanel panelLocationDates3;
    private JPanel panelLocationDates4;
    private JPanel panelLocationFilter;
    private JPanel panelObsAmount;
    private JPanel panelObsCode;
    private JPanel panelObsFreeText;
    private JPanel panelObsFreetext1;
    private JPanel panelObsFreetext2;
    private JPanel panelObsFreetext3;
    private JPanel panelObsLangtext1;
    private JPanel panelObsLangtext2;
    private JPanel panelObsRisk;
    private JPanel panelObservationFilter;
    private JPanel panelPriority;
    private JPanel panelStatus;
    private JPanel panelTopic;
    private JRadioButton radLocFlagNo1;
    private JRadioButton radLocFlagNo2;
    private JRadioButton radLocFlagNo3;
    private JRadioButton radLocFlagNo4;
    private JRadioButton radLocFlagNotSet1;
    private JRadioButton radLocFlagNotSet2;
    private JRadioButton radLocFlagNotSet3;
    private JRadioButton radLocFlagNotSet4;
    private JRadioButton radLocFlagYes1;
    private JRadioButton radLocFlagYes2;
    private JRadioButton radLocFlagYes3;
    private JRadioButton radLocFlagYes4;
    private String DIALOG_CODE = "filterpanel";
    public static final int DIALOG_WIDTH = 420;
    public static final int DIALOG_HEIGHT = 335;
    public static final int DIALOG_WIDTH_MIN = 350;
    public static final int DIALOG_HEIGHT_MIN = 335;

    public FilterPanel() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + this.getClass().getName() + " ...");
        THEMIS.getLicense();
        this.initComponents();
        this.fldEventOption.setRenderer(new SimpleTextRenderer());
        this.fldStatus.setRenderer(new SimpleTextRenderer());
        this.showPanel(2);
        this.loadDropDownLists();
        if (this.project != null && this.project.isOpen()) {
            this.updateAttributeNames();
            this.loadEvents();
            this.loadMaps();
            this.loadBuildings();
            this.loadContacts();
            this.loadKeytables();
            this.loadLocationGroups();
        }
        this.handleAttributeVisibility();
        this.panelLocVisibility.setVisible(false);
        this.modelEventOption.removeAllElements();
        this.modelEventOption.addElement(this.bundle.getString("FilterNewTopComponent.modelEventOptionControlled"));
        this.modelEventOption.addElement(this.bundle.getString("FilterNewTopComponent.modelEventOptionNotControlled"));
        this.modelEventOption.addElement(this.bundle.getString("FilterNewTopComponent.modelEventOptionCreated"));
        this.modelEventOption.addElement(this.bundle.getString("FilterNewTopComponent.modelEventOptionTodo"));
        this.modelEventOption.addElement(this.bundle.getString("FilterNewTopComponent.modelEventOptionPlanned"));
        DragScrollHandler dragScrollHandlerObservation = new DragScrollHandler(this.panelObservationFilter, false, true);
        dragScrollHandlerObservation.addDragComponent(this.lblObsFreeText);
        dragScrollHandlerObservation.addDragComponent(this.fldObsTextFilter);
        dragScrollHandlerObservation.addDragComponent(this.btnSearchObsFreetext);
        dragScrollHandlerObservation.addDragComponent(this.btnClearObsFreetext);
        dragScrollHandlerObservation.addDragComponent(this.lblObsCode1);
        dragScrollHandlerObservation.addDragComponent(this.fldObsCode);
        dragScrollHandlerObservation.addDragComponent(this.btnSearchObsCode);
        dragScrollHandlerObservation.addDragComponent(this.btnClearObsCode);
        dragScrollHandlerObservation.addDragComponent(this.panelObsFreetext1);
        dragScrollHandlerObservation.addDragComponent(this.lblObsFreetext1);
        dragScrollHandlerObservation.addDragComponent(this.fldObsFreetext1);
        dragScrollHandlerObservation.addDragComponent(this.btnClearObsFreetext1);
        dragScrollHandlerObservation.addDragComponent(this.btnSearchObsFreetext1);
        dragScrollHandlerObservation.addDragComponent(this.panelObsFreetext2);
        dragScrollHandlerObservation.addDragComponent(this.lblObsFreetext2);
        dragScrollHandlerObservation.addDragComponent(this.fldObsFreetext2);
        dragScrollHandlerObservation.addDragComponent(this.btnClearObsFreetext2);
        dragScrollHandlerObservation.addDragComponent(this.btnSearchObsFreetext2);
        dragScrollHandlerObservation.addDragComponent(this.panelObsFreetext3);
        dragScrollHandlerObservation.addDragComponent(this.lblObsFreetext3);
        dragScrollHandlerObservation.addDragComponent(this.fldObsFreetext3);
        dragScrollHandlerObservation.addDragComponent(this.btnClearObsFreetext3);
        dragScrollHandlerObservation.addDragComponent(this.btnSearchObsFreetext3);
        dragScrollHandlerObservation.addDragComponent(this.panelObsLangtext1);
        dragScrollHandlerObservation.addDragComponent(this.lblObsLangtext1);
        dragScrollHandlerObservation.addDragComponent(this.fldObsLangtext1);
        dragScrollHandlerObservation.addDragComponent(this.btnClearObsLangtext1);
        dragScrollHandlerObservation.addDragComponent(this.btnSearchObsLangtext1);
        dragScrollHandlerObservation.addDragComponent(this.panelObsLangtext2);
        dragScrollHandlerObservation.addDragComponent(this.lblObsLangtext2);
        dragScrollHandlerObservation.addDragComponent(this.fldObsLangtext2);
        dragScrollHandlerObservation.addDragComponent(this.btnClearObsLangtext2);
        dragScrollHandlerObservation.addDragComponent(this.btnSearchObsLangtext2);
        dragScrollHandlerObservation.addDragComponent(this.panelObsAmount);
        dragScrollHandlerObservation.addDragComponent(this.lblObsAmount);
        dragScrollHandlerObservation.addDragComponent(this.fldObsAmount);
        dragScrollHandlerObservation.addDragComponent(this.btnClearObsAmount);
        dragScrollHandlerObservation.addDragComponent(this.btnSearchObsAmount);
        dragScrollHandlerObservation.addDragComponent(this.fldStatus);
        dragScrollHandlerObservation.addDragComponent(this.lblStatus);
        dragScrollHandlerObservation.addDragComponent(this.lblDueDate);
        dragScrollHandlerObservation.addDragComponent((JComponent)this.fldDuedate);
        dragScrollHandlerObservation.addDragComponent(this.btnClearDuedate);
        dragScrollHandlerObservation.addDragComponent(this.lblObsList2);
        dragScrollHandlerObservation.addDragComponent(this.lblObsList1);
        dragScrollHandlerObservation.addDragComponent(this.lblObsList3);
        dragScrollHandlerObservation.addDragComponent(this.lblContact);
        this.populateFilterElements();
        ThemisActionProvider.getInstance().register(this);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + this.getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    private void populateFilterElements() {
        long idSel = -1L;
        if (this.currentFilterElement != null) {
            idSel = this.currentFilterElement.getId();
        }
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.fldFilterElements.getModel();
        m.removeAllElements();
        m.addElement(new CmsBasicElement(-1L, "-"));
        for (CmsBasicElement be : this.project.getFilters()) {
            m.addElement(be);
            if (be.getId() != idSel) continue;
            this.currentFilterElement = be;
        }
        this.fldFilterElements.setSelectedItem(this.currentFilterElement);
    }

    public void onAction(ThemisAction action) {
        if (action.getSource() == this) {
            return;
        }
        switch (action.getAction()) {
            case 1100: {
                this.filter.setTriggerEnabled(false);
                this.loadEvents();
                this.loadMaps();
                this.loadBuildings();
                this.loadContacts();
                this.loadKeytables();
                this.loadLocationGroups();
                this.loadDropDownLists();
                this.clearAll();
                this.handleAttributeVisibility();
                this.updateAttributeNames();
                this.populateFilterElements();
                String filterOpened = this.project.getProjectProperty("display.filter", "1");
                this.showPanel(Integer.parseInt(filterOpened));
                this.filter.setTriggerEnabled(true);
                break;
            }
            case 1101: {
                this.reset();
                break;
            }
            case 1102: {
                this.loadKeytables();
                this.loadLocationGroups();
                this.handleAttributeVisibility();
                this.updateAttributeNames();
                break;
            }
            case 1110: {
                if (action.getSource() == this) break;
                this.updateAll();
                break;
            }
            case 1111: {
                this.populateFilterElements();
                break;
            }
            case 102: {
                if (!this.filter.hasCurrentPlanFilter()) break;
                this.filter.setCurrentPlanFilter();
                this.app.getActionProvider().invokeAction(ThemisAction.FILTER_CHANGED.from((Object)this, "after plan selected"), true);
                break;
            }
            default: {
                if (action.dealsWith("event")) {
                    this.loadEvents();
                    break;
                }
                if (action.dealsWith("plan")) {
                    this.loadMaps();
                    this.loadBuildings();
                    break;
                }
                if (!action.dealsWith("company")) break;
                this.loadContacts();
            }
        }
    }

    private void handleAttributeVisibility() {
        this.panelLocGroup.setVisible(this.settings.getLocationAttribute("group").isUsed());
        this.panelLocText1.setVisible(this.settings.getLocationAttribute("text1").isUsed());
        this.panelLocText2.setVisible(this.settings.getLocationAttribute("text2").isUsed());
        this.panelLocText3.setVisible(this.settings.getLocationAttribute("text3").isUsed());
        this.panelLocText4.setVisible(this.settings.getLocationAttribute("text4").isUsed());
        this.panelLocLongtext1.setVisible(this.settings.getLocationAttribute("longtext1").isUsed());
        this.panelLocLongtext2.setVisible(this.settings.getLocationAttribute("longtext2").isUsed());
        this.panelLocLongtext3.setVisible(this.settings.getLocationAttribute("longtext3").isUsed());
        this.panelLocLongtext4.setVisible(this.settings.getLocationAttribute("longtext4").isUsed());
        this.panelLocList1.setVisible(this.settings.getLocationAttribute("list1").isUsed());
        this.panelLocList2.setVisible(this.settings.getLocationAttribute("list2").isUsed());
        this.panelLocList3.setVisible(this.settings.getLocationAttribute("list3").isUsed());
        this.panelLocList4.setVisible(this.settings.getLocationAttribute("list4").isUsed());
        this.panelLocBarcode.setVisible(this.settings.getLocationAttribute("barcode").isUsed());
        this.panelLocFlag1.setVisible(this.settings.getLocationAttribute("boolean1").isUsed());
        this.panelLocFlag2.setVisible(this.settings.getLocationAttribute("boolean2").isUsed());
        this.panelLocFlag3.setVisible(this.settings.getLocationAttribute("boolean3").isUsed());
        this.panelLocFlag4.setVisible(this.settings.getLocationAttribute("boolean4").isUsed());
        this.panelLocationDates1.setVisible(this.settings.getLocationAttribute("date1").isUsed());
        this.panelLocationDates2.setVisible(this.settings.getLocationAttribute("date2").isUsed());
        this.panelLocationDates3.setVisible(this.settings.getLocationAttribute("date3").isUsed());
        this.panelLocationDates4.setVisible(this.settings.getLocationAttribute("date4").isUsed());
        this.panelObsCode.setVisible(this.settings.getObservationAttribute("text1").isUsed());
        this.panelObsFreetext1.setVisible(this.settings.getObservationAttribute("text2").isUsed());
        this.panelObsFreetext2.setVisible(this.settings.getObservationAttribute("text3").isUsed());
        this.panelObsFreetext3.setVisible(this.settings.getObservationAttribute("text4").isUsed());
        this.panelObsLangtext1.setVisible(this.settings.getObservationAttribute("longtext1").isUsed());
        this.panelObsLangtext2.setVisible(this.settings.getObservationAttribute("longtext2").isUsed());
        this.panelObsAmount.setVisible(this.settings.getObservationAttribute("quantity").isUsed());
        this.panelStatus.setVisible(this.settings.getObservationAttribute("done").isUsed());
        this.panelDueDate.setVisible(this.settings.getObservationAttribute("duedate").isUsed());
        this.panelTopic.setVisible(this.settings.getObservationAttribute("list1").isUsed());
        this.panelCategory.setVisible(this.settings.getObservationAttribute("list2").isUsed());
        this.panelPriority.setVisible(this.settings.getObservationAttribute("list3").isUsed());
        this.panelObsRisk.setVisible(this.settings.getObservationAttribute("assessment").isUsed());
        this.panelContact.setVisible(this.settings.getObservationAttribute("responsible").isUsed());
    }

    private void updateAttributeNames() {
        this.lblLocText1.setText(this.settings.getLocationAttribute("text1").getLabel());
        this.lblLocText2.setText(this.settings.getLocationAttribute("text2").getLabel());
        this.lblLocText3.setText(this.settings.getLocationAttribute("text3").getLabel());
        this.lblLocText4.setText(this.settings.getLocationAttribute("text4").getLabel());
        this.lblLocLongtext1.setText(this.settings.getLocationAttribute("longtext1").getLabel());
        this.lblLocLongtext2.setText(this.settings.getLocationAttribute("longtext2").getLabel());
        this.lblLocLongtext3.setText(this.settings.getLocationAttribute("longtext3").getLabel());
        this.lblLocLongtext4.setText(this.settings.getLocationAttribute("longtext4").getLabel());
        this.lblLocList1.setText(this.settings.getLocationAttribute("list1").getLabel());
        this.lblLocList2.setText(this.settings.getLocationAttribute("list2").getLabel());
        this.lblLocList3.setText(this.settings.getLocationAttribute("list3").getLabel());
        this.lblLocList4.setText(this.settings.getLocationAttribute("list4").getLabel());
        this.lblLocBarcode.setText(this.settings.getLocationAttribute("barcode").getLabel());
        this.lblLocFlag1.setText(this.settings.getLocationAttribute("boolean1").getLabel());
        this.lblLocFlag2.setText(this.settings.getLocationAttribute("boolean2").getLabel());
        this.lblLocFlag3.setText(this.settings.getLocationAttribute("boolean3").getLabel());
        this.lblLocFlag4.setText(this.settings.getLocationAttribute("boolean4").getLabel());
        this.lblLocDate1.setText(this.settings.getLocationAttribute("date1").getLabel());
        this.lblLocDate2.setText(this.settings.getLocationAttribute("date2").getLabel());
        this.lblLocDate3.setText(this.settings.getLocationAttribute("date3").getLabel());
        this.lblLocDate4.setText(this.settings.getLocationAttribute("date4").getLabel());
        this.lblObsCode1.setText(this.settings.getObservationAttribute("text1").getLabel());
        this.lblObsFreetext1.setText(this.settings.getObservationAttribute("text2").getLabel());
        this.lblObsFreetext2.setText(this.settings.getObservationAttribute("text3").getLabel());
        this.lblObsFreetext3.setText(this.settings.getObservationAttribute("text4").getLabel());
        this.lblObsLangtext1.setText(this.settings.getObservationAttribute("longtext1").getLabel());
        this.lblObsLangtext2.setText(this.settings.getObservationAttribute("longtext2").getLabel());
        this.lblObsList1.setText(this.settings.getObservationAttribute("list1").getLabel());
        this.lblObsList2.setText(this.settings.getObservationAttribute("list2").getLabel());
        this.lblObsList3.setText(this.settings.getObservationAttribute("list3").getLabel());
        this.lblObsAmount.setText(this.settings.getObservationAttribute("quantity").getLabel());
    }

    private void showPanel(int id) {
        this.panelEventFilter.setVisible(id == 1 && !this.panelEventFilter.isVisible());
        this.btnEventFilter.setIcon(this.panelEventFilter.isVisible() ? this.iconDown : this.iconUp);
        this.panelLocationFilter.setVisible(id == 2 && !this.panelLocationFilter.isVisible());
        this.btnLocFilter.setIcon(this.panelLocationFilter.isVisible() ? this.iconDown : this.iconUp);
        this.panelObservationFilter.setVisible(id == 3 && !this.panelObservationFilter.isVisible());
        this.btnObsFilter.setIcon(this.panelObservationFilter.isVisible() ? this.iconDown : this.iconUp);
        if (this.project.isOpen() && this.project != null) {
            this.project.setProjectProperty("display.filter", id + "");
        }
        this.validate();
    }

    private void loadEvents() {
        HashMap<Long, Boolean> selected = new HashMap<Long, Boolean>();
        for (int i = 0; i < this.modelEvent.getSize(); ++i) {
            CheckableItem<CmsBasicElement> ele = this.modelEvent.getElementAt(i);
            selected.put(ele.getElement().getId(), ele.selected);
        }
        ArrayList events = this.project.getEvents();
        this.modelEvent.removeAllElements();
        for (CmsElementSummary event : events) {
            boolean wasSelected = selected.getOrDefault(event.getId(), false);
            this.modelEvent.addElement(new CheckableItem<CmsBasicElement>(event.toBasicElement(), wasSelected));
        }
    }

    private void loadMaps() {
        HashMap<Long, Boolean> selected = new HashMap<Long, Boolean>();
        for (int i = 0; i < this.modelMap.getSize(); ++i) {
            CmsElementSummary ele = this.modelMap.getElementAt(i);
            selected.put(ele.getElement().getId(), ele.selected);
        }
        this.modelMap.removeAllElements();
        this.modelMap.addElement(new CheckableItem<CmsBasicElement>(new CmsBasicElement(-9L, this.bundle.getString("Location.plan.noPlan")), false));
        for (CmsElementSummary ele : this.project.getPlans()) {
            CmsBasicElement item = ele.toBasicElement();
            boolean wasSelected = selected.getOrDefault(ele.getId(), false);
            this.modelMap.addElement(new CheckableItem<CmsBasicElement>(item, wasSelected));
        }
        this.fldLocPlan.updateUI();
    }

    private void loadBuildings() {
        HashMap<Long, Boolean> selected = new HashMap<Long, Boolean>();
        for (int i = 0; i < this.modelBuilding.getSize(); ++i) {
            CmsElementSummary ele = this.modelBuilding.getElementAt(i);
            selected.put(ele.getElement().getId(), ele.selected);
        }
        this.modelBuilding.removeAllElements();
        for (CmsElementSummary ele : this.project.getBuildings()) {
            CmsBasicElement item = ele.toBasicElement();
            boolean wasSelected = selected.getOrDefault(ele.getId(), false);
            this.modelBuilding.addElement(new CheckableItem<CmsBasicElement>(item, wasSelected));
        }
        this.fldLocBuilding.updateUI();
    }

    private void loadContacts() {
        HashMap<Long, Boolean> selected = new HashMap<Long, Boolean>();
        for (int i = 0; i < this.modelContact.getSize(); ++i) {
            CheckableItem<CmsBasicElement> ele = this.modelContact.getElementAt(i);
            selected.put(ele.getElement().getId(), ele.selected);
        }
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("company");
        s.addSelectAttribute(this.project.getDefaultElement("company").getAttribute("name"));
        s.addSelectTitle("meta_title");
        s.setSort("ele.name");
        SearchResult result = s.search();
        this.modelContact.removeAllElements();
        this.modelContact.addElement(new CheckableItem<CmsBasicElement>(new CmsBasicElement(-9L, this.project.getResourceText("filter.list.no-selection.text")), selected.getOrDefault(-9L, false)));
        for (DataRecord rec : result.getResult()) {
            boolean wasSelected = selected.getOrDefault(rec.getLong("meta_id"), false);
            this.modelContact.addElement(new CheckableItem<CmsBasicElement>(new CmsBasicElement(rec), wasSelected));
        }
        this.fldContact.updateUI();
    }

    private void loadKeytables() {
        this.loadKeytable(this.fldObsList1, "topic", true);
        this.loadKeytable(this.fldObsList2, "observationtype", true);
        this.loadKeytable(this.fldObsList3, "priority", true);
        this.loadKeytable(this.fldObsRealType, "obstype", false);
        this.loadKeytable(this.fldLocList1, "list1", true);
        this.loadKeytable(this.fldLocList2, "list2", true);
        this.loadKeytable(this.fldLocList3, "list3", true);
        this.loadKeytable(this.fldLocList4, "list4", true);
    }

    private void loadKeytable(JComboBox fld, String tbl, boolean withNone) {
        if (this.project != null && this.project.isOpen()) {
            HashMap<Long, Boolean> selected = new HashMap<Long, Boolean>();
            for (int i = 0; i < fld.getModel().getSize(); ++i) {
                CheckableItem ele = (CheckableItem)fld.getModel().getElementAt(i);
                selected.put(((KeytableRecord)ele.getElement()).id, ele.selected);
            }
            fld.removeAllItems();
            if (withNone) {
                KeytableRecord rec = new KeytableRecord(-9L, this.project.getResourceText("filter.list.no-selection.text"), -1);
                fld.addItem(new CheckableItem<KeytableRecord>(rec, selected.getOrDefault(-9L, false)));
            }
            ArrayList recs = this.project.getKeytable(tbl).toList(this.app.getSystemLanguage());
            for (KeytableRecord rec : recs) {
                boolean wasSelected = selected.getOrDefault(rec.id, false);
                fld.addItem(new CheckableItem<KeytableRecord>(rec, wasSelected));
            }
        }
        fld.repaint();
    }

    private void loadLocationGroups() {
        if (this.project != null && this.project.isOpen()) {
            HashMap<Long, Boolean> selected = new HashMap<Long, Boolean>();
            for (int i = 0; i < this.modelLocGroup.getSize(); ++i) {
                CheckableItem<CmsBasicElement> ele = this.modelLocGroup.getElementAt(i);
                selected.put(ele.getElement().getId(), ele.selected);
            }
            this.modelLocGroup.removeAllElements();
            this.modelLocGroup.addElement(new CheckableItem<CmsBasicElement>(new CmsBasicElement(-9L, this.bundle.getString("Location.group.noGroup"))));
            List locationGroupTemplates = this.project.getTemplateManger().getLocationGroups(-99L);
            for (DataRecord rec : locationGroupTemplates) {
                CmsBasicElement be = new CmsBasicElement(rec);
                boolean wasSelected = selected.getOrDefault(be.getId(), false);
                CheckableItem<CmsBasicElement> item = new CheckableItem<CmsBasicElement>(be, wasSelected);
                this.modelLocGroup.addElement(item);
            }
            this.fldLocGroup.updateUI();
        }
    }

    private void loadDropDownLists() {
        this.loadDropDownList(this.fldStatus, ResourceBundle.getBundle("at/grid/themis/application/filter/Bundle").getString("FilterNewTopComponent.dropDownStatus.text"));
        this.loadDropDownList(this.fldLocVisibility, ResourceBundle.getBundle("at/grid/themis/application/filter/Bundle").getString("FilterNewTopComponent.dropDownItemView.text"));
    }

    private void loadDropDownList(JComboBox fld, String records) {
        String[] recordArray = records.split(",");
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("-");
        for (String record : recordArray) {
            model.addElement(record);
        }
        fld.setModel(model);
    }

    public void reset() {
        this.modelEvent.removeAllElements();
        this.fldEventDateFrom.setDate(null);
        this.fldEventDateUntil.setDate(null);
        this.fldEventOption.setEnabled(false);
        this.fldLocVisibility.removeAllItems();
        this.modelLocGroup.removeAllElements();
        this.fldLocationTextFilter.setText("");
        this.fldLocationRange.setText("");
        this.modelMap.removeAllElements();
        this.fldLocText1.setText("");
        this.fldLocText2.setText("");
        this.fldLocText3.setText("");
        this.fldLocText4.setText("");
        this.fldLocLangtext1.setText("");
        this.fldLocLangtext2.setText("");
        this.fldLocLangtext3.setText("");
        this.fldLocLangtext4.setText("");
        this.fldObsTextFilter.setText("");
        this.fldObsCode.setText("");
        this.fldObsFreetext1.setText("");
        this.fldObsFreetext2.setText("");
        this.fldObsFreetext3.setText("");
        this.fldObsAmount.setText("");
        this.fldDuedate.setDate(null);
        this.modelContact.removeAllElements();
        this.modelObsType.removeAllElements();
        this.modelPriority.removeAllElements();
        this.modelTopic.removeAllElements();
        this.clearAll();
    }

    private void clearAll() {
        this.filter.clearAll();
        this.updateAll();
        this.fldFilterElements.setSelectedIndex(0);
    }

    public void updateAll() {
        this.triggerFilter = false;
        this.filter.setExternalModification(false);
        this.updateElementFilter(this.fldEvent, this.filter.getEventId());
        this.updateElementFilter(this.fldLocPlan, this.filter.getPlanId());
        this.updateElementFilter(this.fldLocBuilding, this.filter.getLocBuildingId());
        this.updateElementFilter(this.fldContact, this.filter.getCompanyId());
        this.updateKeytableFilter(this.fldObsList3, this.filter.getPriority());
        this.updateKeytableFilter(this.fldObsList1, this.filter.getTopic());
        this.updateKeytableFilter(this.fldObsList2, this.filter.getObsType());
        this.updateKeytableFilter(this.fldObsRealType, this.filter.getObsRealType());
        this.fldDuedate.setDate(this.filter.getDuedate());
        this.fldStatus.setSelectedIndex(this.filter.getStatus());
        this.fldLocationTextFilter.setText(this.filter.getLocTextFilter());
        this.updateElementFilter(this.fldLocGroup, this.filter.getLocGroupId());
        this.fldLocText1.setText(this.filter.getLocText1());
        this.fldLocText2.setText(this.filter.getLocText2());
        this.fldLocText3.setText(this.filter.getLocText3());
        this.fldLocText4.setText(this.filter.getLocText4());
        this.updateKeytableFilter(this.fldLocList1, this.filter.getLocList1());
        this.updateKeytableFilter(this.fldLocList2, this.filter.getLocList2());
        this.updateKeytableFilter(this.fldLocList3, this.filter.getLocList3());
        this.updateKeytableFilter(this.fldLocList4, this.filter.getLocList4());
        this.fldLocBarcode.setText(this.filter.getLocBarcode());
        this.fldObsCode.setText(this.filter.getObsCode());
        this.fldObsFreetext1.setText(this.filter.getObsFreetext1());
        this.fldObsFreetext2.setText(this.filter.getObsFreetext2());
        this.fldObsFreetext3.setText(this.filter.getObsFreetext3());
        this.fldObsAmount.setText(this.filter.getObsAmount());
        this.fldObsTextFilter.setText(this.filter.getObsTextFilter());
        this.fldLocationRange.setText(this.filter.getLocRangeAsString());
        this.fldEventDateFrom.setDate(this.filter.getEventFromDate());
        this.fldEventDateUntil.setDate(this.filter.getEventUntilDate());
        this.fldEventOption.setEnabled(this.isEventOptionEnabled());
        switch (this.filter.getLocFlag1().getValue()) {
            case NOTSET: {
                this.radLocFlagNotSet1.setSelected(true);
                break;
            }
            case NO: {
                this.radLocFlagNo1.setSelected(true);
                break;
            }
            case YES: {
                this.radLocFlagYes1.setSelected(true);
            }
        }
        switch (this.filter.getLocFlag2().getValue()) {
            case NOTSET: {
                this.radLocFlagNotSet2.setSelected(true);
                break;
            }
            case NO: {
                this.radLocFlagNo2.setSelected(true);
                break;
            }
            case YES: {
                this.radLocFlagYes2.setSelected(true);
            }
        }
        switch (this.filter.getLocFlag3().getValue()) {
            case NOTSET: {
                this.radLocFlagNotSet3.setSelected(true);
                break;
            }
            case NO: {
                this.radLocFlagNo3.setSelected(true);
                break;
            }
            case YES: {
                this.radLocFlagYes3.setSelected(true);
            }
        }
        switch (this.filter.getLocFlag4().getValue()) {
            case NOTSET: {
                this.radLocFlagNotSet4.setSelected(true);
                break;
            }
            case NO: {
                this.radLocFlagNo4.setSelected(true);
                break;
            }
            case YES: {
                this.radLocFlagYes4.setSelected(true);
            }
        }
        this.triggerFilter = true;
    }

    private boolean isEventOptionEnabled() {
        return !this.filter.getEventId().isEmpty() || this.fldEventDateFrom.getDate() != null || this.fldEventDateUntil.getDate() != null;
    }

    private void updateKeytableFilter(JComboBox<CheckableItem<KeytableRecord>> comboBox, ThemisFilterListItem filter) {
        boolean changed = false;
        for (int ii = 0; ii < comboBox.getModel().getSize(); ++ii) {
            CheckableItem item = (CheckableItem)comboBox.getModel().getElementAt(ii);
            long id = ((KeytableRecord)item.getElement()).id;
            boolean previousState = item.selected;
            item.selected = filter.getList().contains(id);
            if (previousState == item.selected) continue;
            changed = true;
        }
        if (changed) {
            comboBox.updateUI();
        }
    }

    private void updateElementFilter(JComboBox<CheckableItem<CmsBasicElement>> c, ThemisFilterListItem filter) {
        boolean changed = false;
        for (int ii = 0; ii < c.getModel().getSize(); ++ii) {
            CheckableItem be = (CheckableItem)c.getModel().getElementAt(ii);
            boolean previousState = be.selected;
            be.selected = filter.getList().contains(((CmsBasicElement)be.getElement()).getId());
            if (previousState == be.selected) continue;
            changed = true;
        }
        if (changed) {
            c.updateUI();
        }
    }

    private void setEventDateFilter() {
        Date dtFrom = this.fldEventDateFrom.getDate();
        Date dtUntil = this.fldEventDateUntil.getDate();
        this.filter.setEventRange(dtFrom, dtUntil, (Object)this);
    }

    private void setLocDate1Filter() {
        this.filter.getLocDate1().setDates(this.fldLocDate1From.getDate(), this.fldLocDate1Until.getDate(), (Object)this);
    }

    private void setLocDate2Filter() {
        this.filter.getLocDate2().setDates(this.fldLocDate2From.getDate(), this.fldLocDate2Until.getDate(), (Object)this);
    }

    private void setLocDate3Filter() {
        this.filter.getLocDate3().setDates(this.fldLocDate3From.getDate(), this.fldLocDate3Until.getDate(), (Object)this);
    }

    private void setLocDate4Filter() {
        this.filter.getLocDate4().setDates(this.fldLocDate4From.getDate(), this.fldLocDate4Until.getDate(), (Object)this);
    }

    private void setLocRangeFilter() {
        this.filter.setLocRangeAsString(this.fldLocationRange.getText(), (Object)this);
    }

    private void updateFilterItem(ThemisFilterListItem item, long id, boolean selected) {
        if (selected) {
            item.addItem(id, (Object)this);
        } else {
            item.removeItem(id, (Object)this);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.btnClearFilter = new JButton();
        this.fldFilterElements = new JComboBox();
        this.btnLoadFilterElement = new JButton();
        this.btnSaveFilterElement = new JButton();
        this.btnDeleteFilterElement = new JButton();
        this.btnEventFilter = new JButton();
        this.panelEventFilter = new JPanel();
        this.lblControlled = new JLabel();
        this.fldEvent = new JComboCheckBox<CheckableItem<CmsBasicElement>>();
        this.lblPlanned1 = new JLabel();
        this.lblExclude = new JLabel();
        this.fldEventOption = new JComboBox();
        this.btnClearEvent = new JButton();
        this.jPanel2 = new JPanel();
        this.panelEventDates = new JPanel();
        this.lblMap2 = new JLabel();
        this.fldEventDateFrom = new JXDatePicker();
        this.lblMap3 = new JLabel();
        this.fldEventDateUntil = new JXDatePicker();
        this.btnSearchEventDates = new JButton();
        this.btnClearEventDates = new JButton();
        this.btnLocFilter = new JButton();
        this.panelLocationFilter = new JPanel();
        this.panelLocGroup = new JPanel();
        this.fldLocGroup = new JComboCheckBox<CheckableItem<CmsBasicElement>>();
        this.lblLocGroup = new JLabel();
        this.btnClearLocGroup = new JButton();
        this.panelLocRangeFilter = new JPanel();
        this.lblLocGroup2 = new JLabel();
        this.fldLocationRange = new JTextField();
        this.btnSearchLocRange = new JButton();
        this.btnClearLocRange = new JButton();
        this.panelLocFreeText = new JPanel();
        this.lblLocation = new JLabel();
        this.btnSearchLocFreeText = new JButton();
        this.btnClearLocFreeText = new JButton();
        this.fldLocationTextFilter = new JTextField();
        this.panelLocBuilding = new JPanel();
        this.fldLocBuilding = new JComboCheckBox<CheckableItem<CmsBasicElement>>();
        this.lblMap1 = new JLabel();
        this.btnClearLocBuilding = new JButton();
        this.panelLocMap = new JPanel();
        this.fldLocPlan = new JComboCheckBox<CheckableItem<CmsBasicElement>>();
        this.lblMap = new JLabel();
        this.btnClearLocPlan = new JButton();
        this.panelLocText1 = new JPanel();
        this.lblLocText1 = new JLabel();
        this.btnSearchLocText1 = new JButton();
        this.btnClearLocText1 = new JButton();
        this.fldLocText1 = new JTextField();
        this.panelLocText2 = new JPanel();
        this.lblLocText2 = new JLabel();
        this.btnSearchLocText2 = new JButton();
        this.btnClearLocText2 = new JButton();
        this.fldLocText2 = new JTextField();
        this.panelLocText3 = new JPanel();
        this.lblLocText3 = new JLabel();
        this.btnSearchLocText3 = new JButton();
        this.btnClearLocText3 = new JButton();
        this.fldLocText3 = new JTextField();
        this.panelLocText4 = new JPanel();
        this.lblLocText4 = new JLabel();
        this.btnSearchLocText4 = new JButton();
        this.btnClearLocText4 = new JButton();
        this.fldLocText4 = new JTextField();
        this.panelLocationDates1 = new JPanel();
        this.lblLocDate1 = new JLabel();
        this.lblMap4 = new JLabel();
        this.fldLocDate1From = new JXDatePicker();
        this.lblMap5 = new JLabel();
        this.fldLocDate1Until = new JXDatePicker();
        this.btnSetLocDates1 = new JButton();
        this.btnClearLocDates1 = new JButton();
        this.panelLocationDates2 = new JPanel();
        this.lblLocDate2 = new JLabel();
        this.lblMap6 = new JLabel();
        this.fldLocDate2From = new JXDatePicker();
        this.lblMap7 = new JLabel();
        this.fldLocDate2Until = new JXDatePicker();
        this.btnSetLocDates2 = new JButton();
        this.btnClearLocDates2 = new JButton();
        this.panelLocationDates3 = new JPanel();
        this.lblLocDate3 = new JLabel();
        this.lblMap8 = new JLabel();
        this.fldLocDate3From = new JXDatePicker();
        this.lblMap9 = new JLabel();
        this.fldLocDate3Until = new JXDatePicker();
        this.btnSetLocDates3 = new JButton();
        this.btnClearLocDates3 = new JButton();
        this.panelLocationDates4 = new JPanel();
        this.lblLocDate4 = new JLabel();
        this.lblMap10 = new JLabel();
        this.fldLocDate4From = new JXDatePicker();
        this.lblMap11 = new JLabel();
        this.fldLocDate4Until = new JXDatePicker();
        this.btnSetLocDates4 = new JButton();
        this.btnClearLocDates4 = new JButton();
        this.panelLocLongtext3 = new JPanel();
        this.lblLocLongtext3 = new JLabel();
        this.btnSearchLocLangtext3 = new JButton();
        this.btnClearLocLangtext3 = new JButton();
        this.fldLocLangtext3 = new JTextField();
        this.panelLocLongtext4 = new JPanel();
        this.lblLocLongtext4 = new JLabel();
        this.btnSearchLocLangtext4 = new JButton();
        this.btnClearLocLangtext4 = new JButton();
        this.fldLocLangtext4 = new JTextField();
        this.panelLocLongtext1 = new JPanel();
        this.lblLocLongtext1 = new JLabel();
        this.btnSearchLocLangtext1 = new JButton();
        this.btnClearLocLangtext1 = new JButton();
        this.fldLocLangtext1 = new JTextField();
        this.panelLocLongtext2 = new JPanel();
        this.lblLocLongtext2 = new JLabel();
        this.btnSearchLocLangtext2 = new JButton();
        this.btnClearLocLangtext2 = new JButton();
        this.fldLocLangtext2 = new JTextField();
        this.panelLocBarcode = new JPanel();
        this.lblLocBarcode = new JLabel();
        this.btnSearchLocBarcode = new JButton();
        this.btnClearLocBarcode = new JButton();
        this.fldLocBarcode = new JTextField();
        this.panelLocList1 = new JPanel();
        this.lblLocList1 = new JLabel();
        this.fldLocList1 = new JComboCheckBox<CheckableItem<KeytableRecord>>();
        this.btnClearLocList1 = new JButton();
        this.panelLocList2 = new JPanel();
        this.lblLocList2 = new JLabel();
        this.fldLocList2 = new JComboCheckBox<CheckableItem<KeytableRecord>>();
        this.btnClearLocList2 = new JButton();
        this.panelLocList3 = new JPanel();
        this.lblLocList3 = new JLabel();
        this.fldLocList3 = new JComboCheckBox<CheckableItem<KeytableRecord>>();
        this.btnClearLocList3 = new JButton();
        this.panelLocList4 = new JPanel();
        this.lblLocList4 = new JLabel();
        this.fldLocList4 = new JComboCheckBox<CheckableItem<KeytableRecord>>();
        this.btnClearLocList4 = new JButton();
        this.panelLocFlag1 = new JPanel();
        this.lblLocFlag1 = new JLabel();
        this.radLocFlagNotSet1 = new JRadioButton();
        this.radLocFlagYes1 = new JRadioButton();
        this.radLocFlagNo1 = new JRadioButton();
        this.panelLocFlag2 = new JPanel();
        this.lblLocFlag2 = new JLabel();
        this.radLocFlagNotSet2 = new JRadioButton();
        this.radLocFlagYes2 = new JRadioButton();
        this.radLocFlagNo2 = new JRadioButton();
        this.panelLocFlag3 = new JPanel();
        this.lblLocFlag3 = new JLabel();
        this.radLocFlagNotSet3 = new JRadioButton();
        this.radLocFlagYes3 = new JRadioButton();
        this.radLocFlagNo3 = new JRadioButton();
        this.panelLocFlag4 = new JPanel();
        this.lblLocFlag4 = new JLabel();
        this.radLocFlagNotSet4 = new JRadioButton();
        this.radLocFlagYes4 = new JRadioButton();
        this.radLocFlagNo4 = new JRadioButton();
        this.panelLocVisibility = new JPanel();
        this.fldLocVisibility = new JComboBox();
        this.lblLocVisibility = new JLabel();
        this.jLabel1 = new JLabel();
        this.btnObsFilter = new JButton();
        this.panelObservationFilter = new JPanel();
        this.panelObsRisk = new JPanel();
        this.lblObsRisk = new JLabel();
        this.btnSearchObsRisk = new JButton();
        this.btnClearObsRisk = new JButton();
        this.fldObsRisk = new JTextField();
        this.panelStatus = new JPanel();
        this.fldStatus = new JComboBox();
        this.lblStatus = new JLabel();
        this.jPanel1 = new JPanel();
        this.panelDueDate = new JPanel();
        this.btnClearDuedate = new JButton();
        this.lblDueDate = new JLabel();
        this.fldDuedate = new JXDatePicker();
        this.panelContact = new JPanel();
        this.fldContact = new JComboCheckBox<CheckableItem<CmsBasicElement>>();
        this.lblContact = new JLabel();
        this.btnClearObsContacts = new JButton();
        this.panelCategory = new JPanel();
        this.lblObsList2 = new JLabel();
        this.fldObsList2 = new JComboCheckBox<CheckableItem<KeytableRecord>>();
        this.btnClearObsType = new JButton();
        this.panelPriority = new JPanel();
        this.lblObsList3 = new JLabel();
        this.fldObsList3 = new JComboCheckBox<CheckableItem<KeytableRecord>>();
        this.btnClearObsPriority = new JButton();
        this.panelTopic = new JPanel();
        this.lblObsList1 = new JLabel();
        this.fldObsList1 = new JComboCheckBox<CheckableItem<KeytableRecord>>();
        this.btnClearObsTopic = new JButton();
        this.panelObsFreeText = new JPanel();
        this.lblObsFreeText = new JLabel();
        this.btnSearchObsFreetext = new JButton();
        this.btnClearObsFreetext = new JButton();
        this.fldObsTextFilter = new JTextField();
        this.panelObsCode = new JPanel();
        this.lblObsCode1 = new JLabel();
        this.btnSearchObsCode = new JButton();
        this.btnClearObsCode = new JButton();
        this.fldObsCode = new JTextField();
        this.fldObsRealType = new JComboCheckBox<CheckableItem<KeytableRecord>>();
        this.lblRealObsType = new JLabel();
        this.panelObsFreetext1 = new JPanel();
        this.lblObsFreetext1 = new JLabel();
        this.btnSearchObsFreetext1 = new JButton();
        this.btnClearObsFreetext1 = new JButton();
        this.fldObsFreetext1 = new JTextField();
        this.panelObsFreetext2 = new JPanel();
        this.lblObsFreetext2 = new JLabel();
        this.btnSearchObsFreetext2 = new JButton();
        this.btnClearObsFreetext2 = new JButton();
        this.fldObsFreetext2 = new JTextField();
        this.panelObsFreetext3 = new JPanel();
        this.lblObsFreetext3 = new JLabel();
        this.btnSearchObsFreetext3 = new JButton();
        this.btnClearObsFreetext3 = new JButton();
        this.fldObsFreetext3 = new JTextField();
        this.panelObsAmount = new JPanel();
        this.lblObsAmount = new JLabel();
        this.btnSearchObsAmount = new JButton();
        this.btnClearObsAmount = new JButton();
        this.fldObsAmount = new JTextField();
        this.btnClearObsRealType = new JButton();
        this.panelObsLangtext1 = new JPanel();
        this.lblObsLangtext1 = new JLabel();
        this.btnSearchObsLangtext1 = new JButton();
        this.btnClearObsLangtext1 = new JButton();
        this.fldObsLangtext1 = new JTextField();
        this.panelObsLangtext2 = new JPanel();
        this.lblObsLangtext2 = new JLabel();
        this.btnSearchObsLangtext2 = new JButton();
        this.btnClearObsLangtext2 = new JButton();
        this.fldObsLangtext2 = new JTextField();
        this.lblEmpty = new JLabel();
        this.setLayout(new GridBagLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.btnClearFilter.setFont(THEMIS.fontButton);
        this.btnClearFilter.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_resetFilter24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearFilter, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearFilter.text"));
        this.btnClearFilter.setBorder(new SoftBevelBorder(0));
        this.btnClearFilter.setIconTextGap(8);
        this.btnClearFilter.setPreferredSize(new Dimension(93, 35));
        this.btnClearFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearFilterActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.btnClearFilter, gridBagConstraints);
        this.fldFilterElements.setFont(THEMIS.fontList);
        this.fldFilterElements.setModel(new DefaultComboBoxModel());
        this.fldFilterElements.setMinimumSize(new Dimension(100, 30));
        this.fldFilterElements.setPreferredSize(new Dimension(100, 30));
        this.fldFilterElements.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldFilterElementsItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add(this.fldFilterElements, gridBagConstraints);
        this.btnLoadFilterElement.setFont(THEMIS.fontButton);
        this.btnLoadFilterElement.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLoadFilterElement, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnLoadFilterElement.text"));
        this.btnLoadFilterElement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnLoadFilterElementActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.btnLoadFilterElement, gridBagConstraints);
        this.btnSaveFilterElement.setFont(THEMIS.fontButton);
        this.btnSaveFilterElement.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/save24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveFilterElement, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSaveFilterElement.text"));
        this.btnSaveFilterElement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSaveFilterElementActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.btnSaveFilterElement, gridBagConstraints);
        this.btnDeleteFilterElement.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteFilterElement, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnDeleteFilterElement.text"));
        this.btnDeleteFilterElement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnDeleteFilterElementActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.btnDeleteFilterElement, gridBagConstraints);
        this.btnEventFilter.setFont(THEMIS.fontSubheading);
        this.btnEventFilter.setIcon(this.iconUp);
        Mnemonics.setLocalizedText((AbstractButton)this.btnEventFilter, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnEventFilter.text"));
        this.btnEventFilter.setBorder(new SoftBevelBorder(0));
        this.btnEventFilter.setHorizontalAlignment(2);
        this.btnEventFilter.setIconTextGap(8);
        this.btnEventFilter.setMinimumSize(new Dimension(100, 30));
        this.btnEventFilter.setPreferredSize(new Dimension(93, 30));
        this.btnEventFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnEventFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.btnEventFilter, gridBagConstraints);
        this.panelEventFilter.setPreferredSize(new Dimension(10, 174));
        this.lblControlled.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblControlled, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblControlled.text"));
        this.fldEvent.setFont(THEMIS.fontList);
        this.fldEvent.setModel(this.modelEvent);
        this.fldEvent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldEventItemStateChanged(evt);
            }
        });
        this.fldEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldEventActionPerformed(evt);
            }
        });
        this.lblPlanned1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPlanned1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblPlanned1.text"));
        this.lblExclude.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblExclude, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblExclude.text"));
        this.fldEventOption.setFont(THEMIS.fontList);
        this.fldEventOption.setModel(this.modelEventOption);
        this.fldEventOption.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldEventOptionItemStateChanged(evt);
            }
        });
        this.btnClearEvent.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearEvent, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearEvent.text"));
        this.btnClearEvent.setBorder(new SoftBevelBorder(0));
        this.btnClearEvent.setContentAreaFilled(false);
        this.btnClearEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearEventActionPerformed(evt);
            }
        });
        this.jPanel2.setPreferredSize(new Dimension(30, 30));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        this.panelEventDates.setLayout(new GridBagLayout());
        this.lblMap2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEventDates.add((Component)this.lblMap2, gridBagConstraints);
        this.fldEventDateFrom.setFont(THEMIS.fontTextfield);
        this.fldEventDateFrom.setMaximumSize(new Dimension(200, 30));
        this.fldEventDateFrom.setMinimumSize(new Dimension(50, 30));
        this.fldEventDateFrom.setPreferredSize(new Dimension(50, 30));
        this.fldEventDateFrom.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldEventDateFromPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEventDates.add((Component)this.fldEventDateFrom, gridBagConstraints);
        this.lblMap3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEventDates.add((Component)this.lblMap3, gridBagConstraints);
        this.fldEventDateUntil.setFont(THEMIS.fontTextfield);
        this.fldEventDateUntil.setMaximumSize(new Dimension(200, 30));
        this.fldEventDateUntil.setMinimumSize(new Dimension(50, 30));
        this.fldEventDateUntil.setPreferredSize(new Dimension(50, 30));
        this.fldEventDateUntil.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldEventDateUntilPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEventDates.add((Component)this.fldEventDateUntil, gridBagConstraints);
        this.btnSearchEventDates.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchEventDates, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchEventDates.text"));
        this.btnSearchEventDates.setBorder(new SoftBevelBorder(0));
        this.btnSearchEventDates.setContentAreaFilled(false);
        this.btnSearchEventDates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchEventDatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEventDates.add((Component)this.btnSearchEventDates, gridBagConstraints);
        this.btnClearEventDates.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearEventDates, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearEventDates.text"));
        this.btnClearEventDates.setBorder(new SoftBevelBorder(0));
        this.btnClearEventDates.setContentAreaFilled(false);
        this.btnClearEventDates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearEventDatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelEventDates.add((Component)this.btnClearEventDates, gridBagConstraints);
        GroupLayout panelEventFilterLayout = new GroupLayout(this.panelEventFilter);
        this.panelEventFilter.setLayout(panelEventFilterLayout);
        panelEventFilterLayout.setHorizontalGroup(panelEventFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblControlled, GroupLayout.Alignment.TRAILING, -1, 546, Short.MAX_VALUE).addComponent(this.lblPlanned1, -1, -1, Short.MAX_VALUE).addComponent(this.lblExclude, -1, -1, Short.MAX_VALUE).addGroup(panelEventFilterLayout.createSequentialGroup().addComponent(this.fldEventOption, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2)).addGroup(panelEventFilterLayout.createSequentialGroup().addGroup(panelEventFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEventFilterLayout.createSequentialGroup().addComponent(this.fldEvent, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearEvent, -2, 30, -2)).addComponent(this.panelEventDates, GroupLayout.Alignment.TRAILING, -1, 536, Short.MAX_VALUE)).addContainerGap()));
        panelEventFilterLayout.setVerticalGroup(panelEventFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelEventFilterLayout.createSequentialGroup().addComponent(this.lblPlanned1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelEventDates, -2, -1, -2).addGap(11, 11, 11).addComponent(this.lblControlled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelEventFilterLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fldEvent, -2, 30, -2).addComponent(this.btnClearEvent, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelEventFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldEventOption, -2, 30, -2).addComponent(this.jPanel2, -2, -1, -2))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.panelEventFilter, gridBagConstraints);
        this.btnLocFilter.setFont(THEMIS.fontSubheading);
        this.btnLocFilter.setIcon(this.iconUp);
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocFilter, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnLocFilter.text"));
        this.btnLocFilter.setBorder(new SoftBevelBorder(0));
        this.btnLocFilter.setHorizontalAlignment(2);
        this.btnLocFilter.setIconTextGap(8);
        this.btnLocFilter.setMinimumSize(new Dimension(100, 30));
        this.btnLocFilter.setPreferredSize(new Dimension(93, 30));
        this.btnLocFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnLocFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.btnLocFilter, gridBagConstraints);
        this.panelLocationFilter.setLayout(new GridBagLayout());
        this.fldLocGroup.setFont(THEMIS.fontList);
        this.fldLocGroup.setModel(this.modelLocGroup);
        this.fldLocGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldLocGroupItemStateChanged(evt);
            }
        });
        this.lblLocGroup.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocGroup, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocGroup.text"));
        this.btnClearLocGroup.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocGroup, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocGroup.text"));
        this.btnClearLocGroup.setBorder(new SoftBevelBorder(0));
        this.btnClearLocGroup.setContentAreaFilled(false);
        this.btnClearLocGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocGroupActionPerformed(evt);
            }
        });
        GroupLayout panelLocGroupLayout = new GroupLayout(this.panelLocGroup);
        this.panelLocGroup.setLayout(panelLocGroupLayout);
        panelLocGroupLayout.setHorizontalGroup(panelLocGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocGroupLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelLocGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocGroupLayout.createSequentialGroup().addComponent(this.lblLocGroup, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(panelLocGroupLayout.createSequentialGroup().addComponent(this.fldLocGroup, 0, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocGroup, -2, 30, -2)))));
        panelLocGroupLayout.setVerticalGroup(panelLocGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocGroupLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblLocGroup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocGroupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fldLocGroup, -2, 30, -2).addComponent(this.btnClearLocGroup, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocGroup, gridBagConstraints);
        this.lblLocGroup2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocGroup2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocGroup2.text"));
        this.fldLocationRange.setFont(THEMIS.fontTextfield);
        this.fldLocationRange.setHorizontalAlignment(2);
        this.fldLocationRange.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocationRange.text"));
        this.fldLocationRange.setPreferredSize(new Dimension(55, 30));
        this.fldLocationRange.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocationRangeFocusLost(evt);
            }
        });
        this.fldLocationRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocationRangeActionPerformed(evt);
            }
        });
        this.btnSearchLocRange.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocRange, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocRange.text"));
        this.btnSearchLocRange.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocRange.setContentAreaFilled(false);
        this.btnSearchLocRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocRangeActionPerformed(evt);
            }
        });
        this.btnClearLocRange.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocRange, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocRange.text"));
        this.btnClearLocRange.setBorder(new SoftBevelBorder(0));
        this.btnClearLocRange.setContentAreaFilled(false);
        this.btnClearLocRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocRangeActionPerformed(evt);
            }
        });
        GroupLayout panelLocRangeFilterLayout = new GroupLayout(this.panelLocRangeFilter);
        this.panelLocRangeFilter.setLayout(panelLocRangeFilterLayout);
        panelLocRangeFilterLayout.setHorizontalGroup(panelLocRangeFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocRangeFilterLayout.createSequentialGroup().addComponent(this.lblLocGroup2, -1, 530, Short.MAX_VALUE).addContainerGap()).addGroup(panelLocRangeFilterLayout.createSequentialGroup().addComponent(this.fldLocationRange, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocRange, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocRange, -2, 30, -2)));
        panelLocRangeFilterLayout.setVerticalGroup(panelLocRangeFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocRangeFilterLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblLocGroup2).addGroup(panelLocRangeFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocRangeFilterLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fldLocationRange, -1, -1, Short.MAX_VALUE)).addGroup(panelLocRangeFilterLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(panelLocRangeFilterLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocRange, -2, 30, -2).addComponent(this.btnSearchLocRange, GroupLayout.Alignment.LEADING, -2, 30, -2))))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocRangeFilter, gridBagConstraints);
        this.lblLocation.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocation, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocation.text"));
        this.btnSearchLocFreeText.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocFreeText, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocFreeText.text"));
        this.btnSearchLocFreeText.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocFreeText.setContentAreaFilled(false);
        this.btnSearchLocFreeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocFreeTextActionPerformed(evt);
            }
        });
        this.btnClearLocFreeText.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocFreeText, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocFreeText.text"));
        this.btnClearLocFreeText.setBorder(new SoftBevelBorder(0));
        this.btnClearLocFreeText.setContentAreaFilled(false);
        this.btnClearLocFreeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocFreeTextActionPerformed(evt);
            }
        });
        this.fldLocationTextFilter.setFont(THEMIS.fontTextfield);
        this.fldLocationTextFilter.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocationTextFilter.text"));
        this.fldLocationTextFilter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocationTextFilterFocusLost(evt);
            }
        });
        this.fldLocationTextFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocationTextFilterActionPerformed(evt);
            }
        });
        GroupLayout panelLocFreeTextLayout = new GroupLayout(this.panelLocFreeText);
        this.panelLocFreeText.setLayout(panelLocFreeTextLayout);
        panelLocFreeTextLayout.setHorizontalGroup(panelLocFreeTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocFreeTextLayout.createSequentialGroup().addComponent(this.fldLocationTextFilter).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocFreeText, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocFreeText, -2, 30, -2)).addComponent(this.lblLocation, -1, 540, Short.MAX_VALUE));
        panelLocFreeTextLayout.setVerticalGroup(panelLocFreeTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocFreeTextLayout.createSequentialGroup().addComponent(this.lblLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocFreeTextLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocFreeText, -2, 30, -2).addComponent(this.btnSearchLocFreeText, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocationTextFilter, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocFreeText, gridBagConstraints);
        this.fldLocBuilding.setFont(THEMIS.fontList);
        this.fldLocBuilding.setModel(this.modelBuilding);
        this.fldLocBuilding.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldLocBuildingItemStateChanged(evt);
            }
        });
        this.lblMap1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap1.text"));
        this.btnClearLocBuilding.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocBuilding, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocBuilding.text"));
        this.btnClearLocBuilding.setBorder(new SoftBevelBorder(0));
        this.btnClearLocBuilding.setContentAreaFilled(false);
        this.btnClearLocBuilding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocBuildingActionPerformed(evt);
            }
        });
        GroupLayout panelLocBuildingLayout = new GroupLayout(this.panelLocBuilding);
        this.panelLocBuilding.setLayout(panelLocBuildingLayout);
        panelLocBuildingLayout.setHorizontalGroup(panelLocBuildingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocBuildingLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelLocBuildingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMap1, -1, -1, Short.MAX_VALUE).addGroup(panelLocBuildingLayout.createSequentialGroup().addComponent(this.fldLocBuilding, 0, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocBuilding, -2, 30, -2)))));
        panelLocBuildingLayout.setVerticalGroup(panelLocBuildingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocBuildingLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblMap1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocBuildingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldLocBuilding, -2, 30, -2).addComponent(this.btnClearLocBuilding, -2, 30, -2))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocBuilding, gridBagConstraints);
        this.fldLocPlan.setFont(THEMIS.fontList);
        this.fldLocPlan.setModel(this.modelMap);
        this.fldLocPlan.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldLocPlanItemStateChanged(evt);
            }
        });
        this.lblMap.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap.text"));
        this.btnClearLocPlan.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocPlan, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocPlan.text"));
        this.btnClearLocPlan.setBorder(new SoftBevelBorder(0));
        this.btnClearLocPlan.setContentAreaFilled(false);
        this.btnClearLocPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocPlanActionPerformed(evt);
            }
        });
        GroupLayout panelLocMapLayout = new GroupLayout(this.panelLocMap);
        this.panelLocMap.setLayout(panelLocMapLayout);
        panelLocMapLayout.setHorizontalGroup(panelLocMapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocMapLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelLocMapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMap, -1, -1, Short.MAX_VALUE).addGroup(panelLocMapLayout.createSequentialGroup().addComponent(this.fldLocPlan, 0, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocPlan, -2, 30, -2)))));
        panelLocMapLayout.setVerticalGroup(panelLocMapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocMapLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblMap).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocMapLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fldLocPlan, -2, 30, -2).addComponent(this.btnClearLocPlan, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocMap, gridBagConstraints);
        this.lblLocText1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocText1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocText1.text"));
        this.btnSearchLocText1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocText1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocText1.text"));
        this.btnSearchLocText1.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocText1.setContentAreaFilled(false);
        this.btnSearchLocText1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocText1ActionPerformed(evt);
            }
        });
        this.btnClearLocText1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocText1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocText1.text"));
        this.btnClearLocText1.setBorder(new SoftBevelBorder(0));
        this.btnClearLocText1.setContentAreaFilled(false);
        this.btnClearLocText1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocText1ActionPerformed(evt);
            }
        });
        this.fldLocText1.setFont(THEMIS.fontTextfield);
        this.fldLocText1.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocText1.text"));
        this.fldLocText1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocText1ActionPerformed(evt);
            }
        });
        this.fldLocText1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocText1FocusLost(evt);
            }
        });
        GroupLayout panelLocText1Layout = new GroupLayout(this.panelLocText1);
        this.panelLocText1.setLayout(panelLocText1Layout);
        panelLocText1Layout.setHorizontalGroup(panelLocText1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocText1Layout.createSequentialGroup().addComponent(this.fldLocText1, -1, 464, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocText1, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocText1, -2, 30, -2)).addComponent(this.lblLocText1, -1, -1, Short.MAX_VALUE));
        panelLocText1Layout.setVerticalGroup(panelLocText1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocText1Layout.createSequentialGroup().addComponent(this.lblLocText1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocText1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocText1, -2, 30, -2).addComponent(this.btnSearchLocText1, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocText1, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocText1, gridBagConstraints);
        this.lblLocText2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocText2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocText2.text"));
        this.btnSearchLocText2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocText2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocText2.text"));
        this.btnSearchLocText2.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocText2.setContentAreaFilled(false);
        this.btnSearchLocText2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocText2ActionPerformed(evt);
            }
        });
        this.btnClearLocText2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocText2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocText2.text"));
        this.btnClearLocText2.setBorder(new SoftBevelBorder(0));
        this.btnClearLocText2.setContentAreaFilled(false);
        this.btnClearLocText2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocText2ActionPerformed(evt);
            }
        });
        this.fldLocText2.setFont(THEMIS.fontTextfield);
        this.fldLocText2.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocText2.text"));
        this.fldLocText2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocText2ActionPerformed(evt);
            }
        });
        this.fldLocText2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocText2FocusLost(evt);
            }
        });
        GroupLayout panelLocText2Layout = new GroupLayout(this.panelLocText2);
        this.panelLocText2.setLayout(panelLocText2Layout);
        panelLocText2Layout.setHorizontalGroup(panelLocText2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocText2Layout.createSequentialGroup().addComponent(this.fldLocText2, -1, 464, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocText2, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocText2, -2, 30, -2)).addComponent(this.lblLocText2, -1, -1, Short.MAX_VALUE));
        panelLocText2Layout.setVerticalGroup(panelLocText2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocText2Layout.createSequentialGroup().addComponent(this.lblLocText2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocText2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocText2, -2, 30, -2).addComponent(this.btnSearchLocText2, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocText2, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocText2, gridBagConstraints);
        this.lblLocText3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocText3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocText3.text"));
        this.btnSearchLocText3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocText3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocText3.text"));
        this.btnSearchLocText3.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocText3.setContentAreaFilled(false);
        this.btnSearchLocText3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocText3ActionPerformed(evt);
            }
        });
        this.btnClearLocText3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocText3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocText3.text"));
        this.btnClearLocText3.setBorder(new SoftBevelBorder(0));
        this.btnClearLocText3.setContentAreaFilled(false);
        this.btnClearLocText3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocText3ActionPerformed(evt);
            }
        });
        this.fldLocText3.setFont(THEMIS.fontTextfield);
        this.fldLocText3.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocText3.text"));
        this.fldLocText3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocText3ActionPerformed(evt);
            }
        });
        this.fldLocText3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocText3FocusLost(evt);
            }
        });
        GroupLayout panelLocText3Layout = new GroupLayout(this.panelLocText3);
        this.panelLocText3.setLayout(panelLocText3Layout);
        panelLocText3Layout.setHorizontalGroup(panelLocText3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocText3Layout.createSequentialGroup().addComponent(this.fldLocText3, -1, 464, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocText3, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocText3, -2, 30, -2)).addComponent(this.lblLocText3, -1, -1, Short.MAX_VALUE));
        panelLocText3Layout.setVerticalGroup(panelLocText3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocText3Layout.createSequentialGroup().addComponent(this.lblLocText3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocText3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocText3, -2, 30, -2).addComponent(this.btnSearchLocText3, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocText3, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocText3, gridBagConstraints);
        this.lblLocText4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocText4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocText4.text"));
        this.btnSearchLocText4.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocText4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocText4.text"));
        this.btnSearchLocText4.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocText4.setContentAreaFilled(false);
        this.btnSearchLocText4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocText4ActionPerformed(evt);
            }
        });
        this.btnClearLocText4.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocText4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocText4.text"));
        this.btnClearLocText4.setBorder(new SoftBevelBorder(0));
        this.btnClearLocText4.setContentAreaFilled(false);
        this.btnClearLocText4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocText4ActionPerformed(evt);
            }
        });
        this.fldLocText4.setFont(THEMIS.fontTextfield);
        this.fldLocText4.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocText4.text"));
        this.fldLocText4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocText4ActionPerformed(evt);
            }
        });
        this.fldLocText4.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocText4FocusLost(evt);
            }
        });
        GroupLayout panelLocText4Layout = new GroupLayout(this.panelLocText4);
        this.panelLocText4.setLayout(panelLocText4Layout);
        panelLocText4Layout.setHorizontalGroup(panelLocText4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocText4Layout.createSequentialGroup().addComponent(this.fldLocText4, -1, 464, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocText4, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocText4, -2, 30, -2)).addComponent(this.lblLocText4, -1, -1, Short.MAX_VALUE));
        panelLocText4Layout.setVerticalGroup(panelLocText4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocText4Layout.createSequentialGroup().addComponent(this.lblLocText4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocText4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocText4, -2, 30, -2).addComponent(this.btnSearchLocText4, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocText4, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocText4, gridBagConstraints);
        this.panelLocationDates1.setLayout(new GridBagLayout());
        this.lblLocDate1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocDate1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocDate1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelLocationDates1.add((Component)this.lblLocDate1, gridBagConstraints);
        this.lblMap4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates1.add((Component)this.lblMap4, gridBagConstraints);
        this.fldLocDate1From.setFont(THEMIS.fontTextfield);
        this.fldLocDate1From.setMaximumSize(new Dimension(200, 30));
        this.fldLocDate1From.setMinimumSize(new Dimension(50, 30));
        this.fldLocDate1From.setPreferredSize(new Dimension(50, 30));
        this.fldLocDate1From.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldLocDate1FromPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates1.add((Component)this.fldLocDate1From, gridBagConstraints);
        this.lblMap5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap5, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates1.add((Component)this.lblMap5, gridBagConstraints);
        this.fldLocDate1Until.setFont(THEMIS.fontTextfield);
        this.fldLocDate1Until.setMaximumSize(new Dimension(200, 30));
        this.fldLocDate1Until.setMinimumSize(new Dimension(50, 30));
        this.fldLocDate1Until.setPreferredSize(new Dimension(50, 30));
        this.fldLocDate1Until.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldLocDate1UntilPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates1.add((Component)this.fldLocDate1Until, gridBagConstraints);
        this.btnSetLocDates1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetLocDates1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSetLocDates1.text"));
        this.btnSetLocDates1.setBorder(new SoftBevelBorder(0));
        this.btnSetLocDates1.setContentAreaFilled(false);
        this.btnSetLocDates1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSetLocDates1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates1.add((Component)this.btnSetLocDates1, gridBagConstraints);
        this.btnClearLocDates1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocDates1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocDates1.text"));
        this.btnClearLocDates1.setBorder(new SoftBevelBorder(0));
        this.btnClearLocDates1.setContentAreaFilled(false);
        this.btnClearLocDates1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocDates1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelLocationDates1.add((Component)this.btnClearLocDates1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelLocationFilter.add((Component)this.panelLocationDates1, gridBagConstraints);
        this.panelLocationDates2.setLayout(new GridBagLayout());
        this.lblLocDate2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocDate2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocDate2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelLocationDates2.add((Component)this.lblLocDate2, gridBagConstraints);
        this.lblMap6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap6, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates2.add((Component)this.lblMap6, gridBagConstraints);
        this.fldLocDate2From.setFont(THEMIS.fontTextfield);
        this.fldLocDate2From.setMaximumSize(new Dimension(200, 30));
        this.fldLocDate2From.setMinimumSize(new Dimension(50, 30));
        this.fldLocDate2From.setPreferredSize(new Dimension(50, 30));
        this.fldLocDate2From.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldLocDate2FromPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates2.add((Component)this.fldLocDate2From, gridBagConstraints);
        this.lblMap7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap7, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates2.add((Component)this.lblMap7, gridBagConstraints);
        this.fldLocDate2Until.setFont(THEMIS.fontTextfield);
        this.fldLocDate2Until.setMaximumSize(new Dimension(200, 30));
        this.fldLocDate2Until.setMinimumSize(new Dimension(50, 30));
        this.fldLocDate2Until.setPreferredSize(new Dimension(50, 30));
        this.fldLocDate2Until.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldLocDate2UntilPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates2.add((Component)this.fldLocDate2Until, gridBagConstraints);
        this.btnSetLocDates2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetLocDates2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSetLocDates2.text"));
        this.btnSetLocDates2.setBorder(new SoftBevelBorder(0));
        this.btnSetLocDates2.setContentAreaFilled(false);
        this.btnSetLocDates2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSetLocDates2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates2.add((Component)this.btnSetLocDates2, gridBagConstraints);
        this.btnClearLocDates2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocDates2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocDates2.text"));
        this.btnClearLocDates2.setBorder(new SoftBevelBorder(0));
        this.btnClearLocDates2.setContentAreaFilled(false);
        this.btnClearLocDates2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocDates2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelLocationDates2.add((Component)this.btnClearLocDates2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelLocationFilter.add((Component)this.panelLocationDates2, gridBagConstraints);
        this.panelLocationDates3.setLayout(new GridBagLayout());
        this.lblLocDate3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocDate3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocDate3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelLocationDates3.add((Component)this.lblLocDate3, gridBagConstraints);
        this.lblMap8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap8, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates3.add((Component)this.lblMap8, gridBagConstraints);
        this.fldLocDate3From.setFont(THEMIS.fontTextfield);
        this.fldLocDate3From.setMaximumSize(new Dimension(200, 30));
        this.fldLocDate3From.setMinimumSize(new Dimension(50, 30));
        this.fldLocDate3From.setPreferredSize(new Dimension(50, 30));
        this.fldLocDate3From.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldLocDate3FromPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates3.add((Component)this.fldLocDate3From, gridBagConstraints);
        this.lblMap9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap9, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates3.add((Component)this.lblMap9, gridBagConstraints);
        this.fldLocDate3Until.setFont(THEMIS.fontTextfield);
        this.fldLocDate3Until.setMaximumSize(new Dimension(200, 30));
        this.fldLocDate3Until.setMinimumSize(new Dimension(50, 30));
        this.fldLocDate3Until.setPreferredSize(new Dimension(50, 30));
        this.fldLocDate3Until.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldLocDate3UntilPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates3.add((Component)this.fldLocDate3Until, gridBagConstraints);
        this.btnSetLocDates3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetLocDates3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSetLocDates3.text"));
        this.btnSetLocDates3.setBorder(new SoftBevelBorder(0));
        this.btnSetLocDates3.setContentAreaFilled(false);
        this.btnSetLocDates3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSetLocDates3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates3.add((Component)this.btnSetLocDates3, gridBagConstraints);
        this.btnClearLocDates3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocDates3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocDates3.text"));
        this.btnClearLocDates3.setBorder(new SoftBevelBorder(0));
        this.btnClearLocDates3.setContentAreaFilled(false);
        this.btnClearLocDates3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocDates3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelLocationDates3.add((Component)this.btnClearLocDates3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelLocationFilter.add((Component)this.panelLocationDates3, gridBagConstraints);
        this.panelLocationDates4.setLayout(new GridBagLayout());
        this.lblLocDate4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocDate4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocDate4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelLocationDates4.add((Component)this.lblLocDate4, gridBagConstraints);
        this.lblMap10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap10, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates4.add((Component)this.lblMap10, gridBagConstraints);
        this.fldLocDate4From.setFont(THEMIS.fontTextfield);
        this.fldLocDate4From.setMaximumSize(new Dimension(200, 30));
        this.fldLocDate4From.setMinimumSize(new Dimension(50, 30));
        this.fldLocDate4From.setPreferredSize(new Dimension(50, 30));
        this.fldLocDate4From.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldLocDate4FromPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates4.add((Component)this.fldLocDate4From, gridBagConstraints);
        this.lblMap11.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMap11, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblMap11.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates4.add((Component)this.lblMap11, gridBagConstraints);
        this.fldLocDate4Until.setFont(THEMIS.fontTextfield);
        this.fldLocDate4Until.setMaximumSize(new Dimension(200, 30));
        this.fldLocDate4Until.setMinimumSize(new Dimension(50, 30));
        this.fldLocDate4Until.setPreferredSize(new Dimension(50, 30));
        this.fldLocDate4Until.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterPanel.this.fldLocDate4UntilPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates4.add((Component)this.fldLocDate4Until, gridBagConstraints);
        this.btnSetLocDates4.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetLocDates4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSetLocDates4.text"));
        this.btnSetLocDates4.setBorder(new SoftBevelBorder(0));
        this.btnSetLocDates4.setContentAreaFilled(false);
        this.btnSetLocDates4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSetLocDates4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationDates4.add((Component)this.btnSetLocDates4, gridBagConstraints);
        this.btnClearLocDates4.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocDates4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocDates4.text"));
        this.btnClearLocDates4.setBorder(new SoftBevelBorder(0));
        this.btnClearLocDates4.setContentAreaFilled(false);
        this.btnClearLocDates4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocDates4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.panelLocationDates4.add((Component)this.btnClearLocDates4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelLocationFilter.add((Component)this.panelLocationDates4, gridBagConstraints);
        this.lblLocLongtext3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocLongtext3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocLongtext3.text"));
        this.btnSearchLocLangtext3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocLangtext3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocLangtext3.text"));
        this.btnSearchLocLangtext3.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocLangtext3.setContentAreaFilled(false);
        this.btnSearchLocLangtext3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocLangtext3ActionPerformed(evt);
            }
        });
        this.btnClearLocLangtext3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocLangtext3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocLangtext3.text"));
        this.btnClearLocLangtext3.setBorder(new SoftBevelBorder(0));
        this.btnClearLocLangtext3.setContentAreaFilled(false);
        this.btnClearLocLangtext3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocLangtext3ActionPerformed(evt);
            }
        });
        this.fldLocLangtext3.setFont(THEMIS.fontTextfield);
        this.fldLocLangtext3.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocLangtext3.text"));
        this.fldLocLangtext3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocLangtext3ActionPerformed(evt);
            }
        });
        this.fldLocLangtext3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocLangtext3FocusLost(evt);
            }
        });
        GroupLayout panelLocLongtext3Layout = new GroupLayout(this.panelLocLongtext3);
        this.panelLocLongtext3.setLayout(panelLocLongtext3Layout);
        panelLocLongtext3Layout.setHorizontalGroup(panelLocLongtext3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocLongtext3Layout.createSequentialGroup().addComponent(this.fldLocLangtext3, -1, 464, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocLangtext3, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocLangtext3, -2, 30, -2)).addComponent(this.lblLocLongtext3, -1, -1, Short.MAX_VALUE));
        panelLocLongtext3Layout.setVerticalGroup(panelLocLongtext3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocLongtext3Layout.createSequentialGroup().addComponent(this.lblLocLongtext3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocLongtext3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocLangtext3, -2, 30, -2).addComponent(this.btnSearchLocLangtext3, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocLangtext3, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocLongtext3, gridBagConstraints);
        this.lblLocLongtext4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocLongtext4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocLongtext4.text"));
        this.btnSearchLocLangtext4.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocLangtext4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocLangtext4.text"));
        this.btnSearchLocLangtext4.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocLangtext4.setContentAreaFilled(false);
        this.btnSearchLocLangtext4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocLangtext4ActionPerformed(evt);
            }
        });
        this.btnClearLocLangtext4.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocLangtext4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocLangtext4.text"));
        this.btnClearLocLangtext4.setBorder(new SoftBevelBorder(0));
        this.btnClearLocLangtext4.setContentAreaFilled(false);
        this.btnClearLocLangtext4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocLangtext4ActionPerformed(evt);
            }
        });
        this.fldLocLangtext4.setFont(THEMIS.fontTextfield);
        this.fldLocLangtext4.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocLangtext4.text"));
        this.fldLocLangtext4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocLangtext4ActionPerformed(evt);
            }
        });
        this.fldLocLangtext4.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocLangtext4FocusLost(evt);
            }
        });
        GroupLayout panelLocLongtext4Layout = new GroupLayout(this.panelLocLongtext4);
        this.panelLocLongtext4.setLayout(panelLocLongtext4Layout);
        panelLocLongtext4Layout.setHorizontalGroup(panelLocLongtext4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocLongtext4Layout.createSequentialGroup().addComponent(this.fldLocLangtext4, -1, 464, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocLangtext4, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocLangtext4, -2, 30, -2)).addComponent(this.lblLocLongtext4, -1, -1, Short.MAX_VALUE));
        panelLocLongtext4Layout.setVerticalGroup(panelLocLongtext4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocLongtext4Layout.createSequentialGroup().addComponent(this.lblLocLongtext4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocLongtext4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocLangtext4, -2, 30, -2).addComponent(this.btnSearchLocLangtext4, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocLangtext4, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocLongtext4, gridBagConstraints);
        this.lblLocLongtext1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocLongtext1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocLongtext1.text"));
        this.btnSearchLocLangtext1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocLangtext1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocLangtext1.text"));
        this.btnSearchLocLangtext1.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocLangtext1.setContentAreaFilled(false);
        this.btnSearchLocLangtext1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocLangtext1ActionPerformed(evt);
            }
        });
        this.btnClearLocLangtext1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocLangtext1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocLangtext1.text"));
        this.btnClearLocLangtext1.setBorder(new SoftBevelBorder(0));
        this.btnClearLocLangtext1.setContentAreaFilled(false);
        this.btnClearLocLangtext1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocLangtext1ActionPerformed(evt);
            }
        });
        this.fldLocLangtext1.setFont(THEMIS.fontTextfield);
        this.fldLocLangtext1.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocLangtext1.text"));
        this.fldLocLangtext1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocLangtext1ActionPerformed(evt);
            }
        });
        this.fldLocLangtext1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocLangtext1FocusLost(evt);
            }
        });
        GroupLayout panelLocLongtext1Layout = new GroupLayout(this.panelLocLongtext1);
        this.panelLocLongtext1.setLayout(panelLocLongtext1Layout);
        panelLocLongtext1Layout.setHorizontalGroup(panelLocLongtext1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocLongtext1Layout.createSequentialGroup().addComponent(this.fldLocLangtext1, -1, 464, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocLangtext1, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocLangtext1, -2, 30, -2)).addComponent(this.lblLocLongtext1, -1, -1, Short.MAX_VALUE));
        panelLocLongtext1Layout.setVerticalGroup(panelLocLongtext1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocLongtext1Layout.createSequentialGroup().addComponent(this.lblLocLongtext1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocLongtext1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocLangtext1, -2, 30, -2).addComponent(this.btnSearchLocLangtext1, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocLangtext1, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocLongtext1, gridBagConstraints);
        this.lblLocLongtext2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocLongtext2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocLongtext2.text"));
        this.btnSearchLocLangtext2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocLangtext2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocLangtext2.text"));
        this.btnSearchLocLangtext2.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocLangtext2.setContentAreaFilled(false);
        this.btnSearchLocLangtext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocLangtext2ActionPerformed(evt);
            }
        });
        this.btnClearLocLangtext2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocLangtext2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocLangtext2.text"));
        this.btnClearLocLangtext2.setBorder(new SoftBevelBorder(0));
        this.btnClearLocLangtext2.setContentAreaFilled(false);
        this.btnClearLocLangtext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocLangtext2ActionPerformed(evt);
            }
        });
        this.fldLocLangtext2.setFont(THEMIS.fontTextfield);
        this.fldLocLangtext2.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocLangtext2.text"));
        this.fldLocLangtext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocLangtext2ActionPerformed(evt);
            }
        });
        this.fldLocLangtext2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocLangtext2FocusLost(evt);
            }
        });
        GroupLayout panelLocLongtext2Layout = new GroupLayout(this.panelLocLongtext2);
        this.panelLocLongtext2.setLayout(panelLocLongtext2Layout);
        panelLocLongtext2Layout.setHorizontalGroup(panelLocLongtext2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocLongtext2Layout.createSequentialGroup().addComponent(this.fldLocLangtext2, -1, 464, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocLangtext2, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocLangtext2, -2, 30, -2)).addComponent(this.lblLocLongtext2, -1, -1, Short.MAX_VALUE));
        panelLocLongtext2Layout.setVerticalGroup(panelLocLongtext2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocLongtext2Layout.createSequentialGroup().addComponent(this.lblLocLongtext2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocLongtext2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocLangtext2, -2, 30, -2).addComponent(this.btnSearchLocLangtext2, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocLangtext2, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocLongtext2, gridBagConstraints);
        this.lblLocBarcode.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocBarcode, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocBarcode.text"));
        this.btnSearchLocBarcode.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocBarcode, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchLocBarcode.text"));
        this.btnSearchLocBarcode.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocBarcode.setContentAreaFilled(false);
        this.btnSearchLocBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchLocBarcodeActionPerformed(evt);
            }
        });
        this.btnClearLocBarcode.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocBarcode, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocBarcode.text"));
        this.btnClearLocBarcode.setBorder(new SoftBevelBorder(0));
        this.btnClearLocBarcode.setContentAreaFilled(false);
        this.btnClearLocBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocBarcodeActionPerformed(evt);
            }
        });
        this.fldLocBarcode.setFont(THEMIS.fontTextfield);
        this.fldLocBarcode.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldLocBarcode.text"));
        this.fldLocBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocBarcodeActionPerformed(evt);
            }
        });
        this.fldLocBarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldLocBarcodeFocusLost(evt);
            }
        });
        GroupLayout panelLocBarcodeLayout = new GroupLayout(this.panelLocBarcode);
        this.panelLocBarcode.setLayout(panelLocBarcodeLayout);
        panelLocBarcodeLayout.setHorizontalGroup(panelLocBarcodeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocBarcodeLayout.createSequentialGroup().addComponent(this.fldLocBarcode, -1, 464, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchLocBarcode, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocBarcode, -2, 30, -2)).addComponent(this.lblLocBarcode, -1, -1, Short.MAX_VALUE));
        panelLocBarcodeLayout.setVerticalGroup(panelLocBarcodeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocBarcodeLayout.createSequentialGroup().addComponent(this.lblLocBarcode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocBarcodeLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearLocBarcode, -2, 30, -2).addComponent(this.btnSearchLocBarcode, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldLocBarcode, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocBarcode, gridBagConstraints);
        this.lblLocList1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocList1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocList1.text"));
        this.fldLocList1.setFont(THEMIS.fontList);
        this.fldLocList1.setModel(new DefaultComboBoxModel());
        this.fldLocList1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldLocList1ItemStateChanged(evt);
            }
        });
        this.btnClearLocList1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocList1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocList1.text"));
        this.btnClearLocList1.setBorder(new SoftBevelBorder(0));
        this.btnClearLocList1.setContentAreaFilled(false);
        this.btnClearLocList1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocList1ActionPerformed(evt);
            }
        });
        GroupLayout panelLocList1Layout = new GroupLayout(this.panelLocList1);
        this.panelLocList1.setLayout(panelLocList1Layout);
        panelLocList1Layout.setHorizontalGroup(panelLocList1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLocList1, -1, -1, Short.MAX_VALUE).addGroup(panelLocList1Layout.createSequentialGroup().addComponent(this.fldLocList1, 0, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocList1, -2, 30, -2)));
        panelLocList1Layout.setVerticalGroup(panelLocList1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocList1Layout.createSequentialGroup().addComponent(this.lblLocList1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocList1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldLocList1, -2, 30, -2).addComponent(this.btnClearLocList1, -2, 30, -2))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocList1, gridBagConstraints);
        this.lblLocList2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocList2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocList2.text"));
        this.fldLocList2.setFont(THEMIS.fontList);
        this.fldLocList2.setModel(new DefaultComboBoxModel());
        this.fldLocList2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldLocList2ItemStateChanged(evt);
            }
        });
        this.btnClearLocList2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocList2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocList2.text"));
        this.btnClearLocList2.setBorder(new SoftBevelBorder(0));
        this.btnClearLocList2.setContentAreaFilled(false);
        this.btnClearLocList2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocList2ActionPerformed(evt);
            }
        });
        GroupLayout panelLocList2Layout = new GroupLayout(this.panelLocList2);
        this.panelLocList2.setLayout(panelLocList2Layout);
        panelLocList2Layout.setHorizontalGroup(panelLocList2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLocList2, -1, -1, Short.MAX_VALUE).addGroup(panelLocList2Layout.createSequentialGroup().addComponent(this.fldLocList2, 0, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocList2, -2, 30, -2)));
        panelLocList2Layout.setVerticalGroup(panelLocList2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocList2Layout.createSequentialGroup().addComponent(this.lblLocList2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocList2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldLocList2, -2, 30, -2).addComponent(this.btnClearLocList2, -2, 30, -2))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocList2, gridBagConstraints);
        this.lblLocList3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocList3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocList3.text"));
        this.fldLocList3.setFont(THEMIS.fontList);
        this.fldLocList3.setModel(new DefaultComboBoxModel());
        this.fldLocList3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldLocList3ItemStateChanged(evt);
            }
        });
        this.fldLocList3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldLocList3ActionPerformed(evt);
            }
        });
        this.btnClearLocList3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocList3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocList3.text"));
        this.btnClearLocList3.setBorder(new SoftBevelBorder(0));
        this.btnClearLocList3.setContentAreaFilled(false);
        this.btnClearLocList3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocList3ActionPerformed(evt);
            }
        });
        GroupLayout panelLocList3Layout = new GroupLayout(this.panelLocList3);
        this.panelLocList3.setLayout(panelLocList3Layout);
        panelLocList3Layout.setHorizontalGroup(panelLocList3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLocList3, -1, -1, Short.MAX_VALUE).addGroup(panelLocList3Layout.createSequentialGroup().addComponent(this.fldLocList3, 0, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocList3, -2, 30, -2)));
        panelLocList3Layout.setVerticalGroup(panelLocList3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocList3Layout.createSequentialGroup().addComponent(this.lblLocList3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocList3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldLocList3, -2, 30, -2).addComponent(this.btnClearLocList3, -2, 30, -2))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocList3, gridBagConstraints);
        this.lblLocList4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocList4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocList4.text"));
        this.fldLocList4.setFont(THEMIS.fontList);
        this.fldLocList4.setModel(new DefaultComboBoxModel());
        this.fldLocList4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldLocList4ItemStateChanged(evt);
            }
        });
        this.btnClearLocList4.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocList4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearLocList4.text"));
        this.btnClearLocList4.setBorder(new SoftBevelBorder(0));
        this.btnClearLocList4.setContentAreaFilled(false);
        this.btnClearLocList4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearLocList4ActionPerformed(evt);
            }
        });
        GroupLayout panelLocList4Layout = new GroupLayout(this.panelLocList4);
        this.panelLocList4.setLayout(panelLocList4Layout);
        panelLocList4Layout.setHorizontalGroup(panelLocList4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLocList4, -1, -1, Short.MAX_VALUE).addGroup(panelLocList4Layout.createSequentialGroup().addComponent(this.fldLocList4, 0, 504, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearLocList4, -2, 30, -2)));
        panelLocList4Layout.setVerticalGroup(panelLocList4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocList4Layout.createSequentialGroup().addComponent(this.lblLocList4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(panelLocList4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldLocList4, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.btnClearLocList4, GroupLayout.Alignment.TRAILING, -2, 30, -2))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocList4, gridBagConstraints);
        this.panelLocFlag1.setLayout(new GridBagLayout());
        this.lblLocFlag1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocFlag1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocFlag1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelLocFlag1.add((Component)this.lblLocFlag1, gridBagConstraints);
        this.buttonGroup1.add(this.radLocFlagNotSet1);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagNotSet1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagNotSet1.text"));
        this.radLocFlagNotSet1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagNotSet1ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag1.add((Component)this.radLocFlagNotSet1, gridBagConstraints);
        this.buttonGroup1.add(this.radLocFlagYes1);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagYes1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagYes1.text"));
        this.radLocFlagYes1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagYes1ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag1.add((Component)this.radLocFlagYes1, gridBagConstraints);
        this.buttonGroup1.add(this.radLocFlagNo1);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagNo1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagNo1.text"));
        this.radLocFlagNo1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagNo1ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag1.add((Component)this.radLocFlagNo1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocFlag1, gridBagConstraints);
        this.panelLocFlag2.setLayout(new GridBagLayout());
        this.lblLocFlag2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocFlag2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocFlag2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelLocFlag2.add((Component)this.lblLocFlag2, gridBagConstraints);
        this.buttonGroup2.add(this.radLocFlagNotSet2);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagNotSet2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagNotSet2.text"));
        this.radLocFlagNotSet2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagNotSet2ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag2.add((Component)this.radLocFlagNotSet2, gridBagConstraints);
        this.buttonGroup2.add(this.radLocFlagYes2);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagYes2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagYes2.text"));
        this.radLocFlagYes2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagYes2ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag2.add((Component)this.radLocFlagYes2, gridBagConstraints);
        this.buttonGroup2.add(this.radLocFlagNo2);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagNo2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagNo2.text"));
        this.radLocFlagNo2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagNo2ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag2.add((Component)this.radLocFlagNo2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocFlag2, gridBagConstraints);
        this.panelLocFlag3.setLayout(new GridBagLayout());
        this.lblLocFlag3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocFlag3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocFlag3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelLocFlag3.add((Component)this.lblLocFlag3, gridBagConstraints);
        this.buttonGroup3.add(this.radLocFlagNotSet3);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagNotSet3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagNotSet3.text"));
        this.radLocFlagNotSet3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagNotSet3ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag3.add((Component)this.radLocFlagNotSet3, gridBagConstraints);
        this.buttonGroup3.add(this.radLocFlagYes3);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagYes3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagYes3.text"));
        this.radLocFlagYes3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagYes3ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag3.add((Component)this.radLocFlagYes3, gridBagConstraints);
        this.buttonGroup3.add(this.radLocFlagNo3);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagNo3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagNo3.text"));
        this.radLocFlagNo3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagNo3ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag3.add((Component)this.radLocFlagNo3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocFlag3, gridBagConstraints);
        this.panelLocFlag4.setLayout(new GridBagLayout());
        this.lblLocFlag4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocFlag4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocFlag4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelLocFlag4.add((Component)this.lblLocFlag4, gridBagConstraints);
        this.buttonGroup4.add(this.radLocFlagNotSet4);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagNotSet4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagNotSet4.text"));
        this.radLocFlagNotSet4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagNotSet4ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag4.add((Component)this.radLocFlagNotSet4, gridBagConstraints);
        this.buttonGroup4.add(this.radLocFlagYes4);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagYes4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagYes4.text"));
        this.radLocFlagYes4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagYes4ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag4.add((Component)this.radLocFlagYes4, gridBagConstraints);
        this.buttonGroup4.add(this.radLocFlagNo4);
        Mnemonics.setLocalizedText((AbstractButton)this.radLocFlagNo4, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.radLocFlagNo4.text"));
        this.radLocFlagNo4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.radLocFlagNo4ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocFlag4.add((Component)this.radLocFlagNo4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocFlag4, gridBagConstraints);
        this.fldLocVisibility.setFont(THEMIS.fontList);
        this.fldLocVisibility.setModel(new DefaultComboBoxModel());
        this.fldLocVisibility.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldLocVisibilityItemStateChanged(evt);
            }
        });
        this.lblLocVisibility.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocVisibility, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblLocVisibility.text"));
        GroupLayout panelLocVisibilityLayout = new GroupLayout(this.panelLocVisibility);
        this.panelLocVisibility.setLayout(panelLocVisibilityLayout);
        panelLocVisibilityLayout.setHorizontalGroup(panelLocVisibilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocVisibilityLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelLocVisibilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldLocVisibility, 0, -1, Short.MAX_VALUE).addGroup(panelLocVisibilityLayout.createSequentialGroup().addComponent(this.lblLocVisibility, -1, 530, Short.MAX_VALUE).addContainerGap()))));
        panelLocVisibilityLayout.setVerticalGroup(panelLocVisibilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocVisibilityLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblLocVisibility).addGap(4, 4, 4).addComponent(this.fldLocVisibility, -2, 30, -2).addGap(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelLocationFilter.add((Component)this.panelLocVisibility, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelLocationFilter.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.panelLocationFilter, gridBagConstraints);
        this.btnObsFilter.setFont(THEMIS.fontSubheading);
        this.btnObsFilter.setIcon(this.iconUp);
        Mnemonics.setLocalizedText((AbstractButton)this.btnObsFilter, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnObsFilter.text"));
        this.btnObsFilter.setBorder(new SoftBevelBorder(0));
        this.btnObsFilter.setHorizontalAlignment(2);
        this.btnObsFilter.setIconTextGap(8);
        this.btnObsFilter.setMinimumSize(new Dimension(100, 30));
        this.btnObsFilter.setPreferredSize(new Dimension(100, 30));
        this.btnObsFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnObsFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.btnObsFilter, gridBagConstraints);
        this.panelObservationFilter.setPreferredSize(new Dimension(90, 852));
        this.lblObsRisk.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsRisk, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsRisk.text"));
        this.btnSearchObsRisk.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchObsRisk, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchObsRisk.text"));
        this.btnSearchObsRisk.setBorder(new SoftBevelBorder(0));
        this.btnSearchObsRisk.setContentAreaFilled(false);
        this.btnSearchObsRisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchObsRiskActionPerformed(evt);
            }
        });
        this.btnClearObsRisk.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsRisk, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsRisk.text"));
        this.btnClearObsRisk.setBorder(new SoftBevelBorder(0));
        this.btnClearObsRisk.setContentAreaFilled(false);
        this.btnClearObsRisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsRiskActionPerformed(evt);
            }
        });
        this.fldObsRisk.setFont(THEMIS.fontTextfield);
        this.fldObsRisk.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldObsRisk.text"));
        this.fldObsRisk.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldObsRiskFocusLost(evt);
            }
        });
        this.fldObsRisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldObsRiskActionPerformed(evt);
            }
        });
        GroupLayout panelObsRiskLayout = new GroupLayout(this.panelObsRisk);
        this.panelObsRisk.setLayout(panelObsRiskLayout);
        panelObsRiskLayout.setHorizontalGroup(panelObsRiskLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsRiskLayout.createSequentialGroup().addComponent(this.fldObsRisk).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchObsRisk, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsRisk, -2, 30, -2)).addComponent(this.lblObsRisk, -1, -1, Short.MAX_VALUE));
        panelObsRiskLayout.setVerticalGroup(panelObsRiskLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsRiskLayout.createSequentialGroup().addComponent(this.lblObsRisk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObsRiskLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearObsRisk, -2, 30, -2).addComponent(this.btnSearchObsRisk, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldObsRisk, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        this.fldStatus.setFont(THEMIS.fontList);
        this.fldStatus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldStatusItemStateChanged(evt);
            }
        });
        this.lblStatus.setFont(THEMIS.fontList);
        Mnemonics.setLocalizedText((JLabel)this.lblStatus, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblStatus.text"));
        this.jPanel1.setPreferredSize(new Dimension(30, 30));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        GroupLayout panelStatusLayout = new GroupLayout(this.panelStatus);
        this.panelStatus.setLayout(panelStatusLayout);
        panelStatusLayout.setHorizontalGroup(panelStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelStatusLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblStatus, -1, -1, Short.MAX_VALUE).addGroup(panelStatusLayout.createSequentialGroup().addComponent(this.fldStatus, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)))));
        panelStatusLayout.setVerticalGroup(panelStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelStatusLayout.createSequentialGroup().addComponent(this.lblStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldStatus, -2, 30, -2).addComponent(this.jPanel1, -2, -1, -2)).addGap(0, 0, 0)));
        this.btnClearDuedate.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearDuedate, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearDuedate.text"));
        this.btnClearDuedate.setBorder(new SoftBevelBorder(0));
        this.btnClearDuedate.setContentAreaFilled(false);
        this.btnClearDuedate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearDuedateActionPerformed(evt);
            }
        });
        this.lblDueDate.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblDueDate, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblDueDate.text"));
        this.fldDuedate.setFont(THEMIS.fontTextfield);
        this.fldDuedate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldDuedateActionPerformed(evt);
            }
        });
        GroupLayout panelDueDateLayout = new GroupLayout(this.panelDueDate);
        this.panelDueDate.setLayout(panelDueDateLayout);
        panelDueDateLayout.setHorizontalGroup(panelDueDateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDueDateLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelDueDateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDueDateLayout.createSequentialGroup().addComponent((Component)this.fldDuedate, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearDuedate, -2, 30, -2).addGap(2, 2, 2)).addComponent(this.lblDueDate, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        panelDueDateLayout.setVerticalGroup(panelDueDateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelDueDateLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblDueDate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelDueDateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.fldDuedate, -2, 30, -2).addComponent(this.btnClearDuedate, -2, 30, -2)).addGap(0, 0, 0)));
        this.fldContact.setFont(THEMIS.fontList);
        this.fldContact.setModel(this.modelContact);
        this.fldContact.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldContactItemStateChanged(evt);
            }
        });
        this.lblContact.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblContact, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblContact.text"));
        this.btnClearObsContacts.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsContacts, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsContacts.text"));
        this.btnClearObsContacts.setBorder(new SoftBevelBorder(0));
        this.btnClearObsContacts.setContentAreaFilled(false);
        this.btnClearObsContacts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsContactsActionPerformed(evt);
            }
        });
        GroupLayout panelContactLayout = new GroupLayout(this.panelContact);
        this.panelContact.setLayout(panelContactLayout);
        panelContactLayout.setHorizontalGroup(panelContactLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelContactLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelContactLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblContact, -1, -1, Short.MAX_VALUE).addGroup(panelContactLayout.createSequentialGroup().addComponent(this.fldContact, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsContacts, -2, 30, -2)))));
        panelContactLayout.setVerticalGroup(panelContactLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelContactLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblContact).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelContactLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldContact, -2, 30, -2).addComponent(this.btnClearObsContacts, -2, 30, -2))));
        this.lblObsList2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsList2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsList2.text"));
        this.fldObsList2.setFont(THEMIS.fontList);
        this.fldObsList2.setModel(this.modelObsType);
        this.fldObsList2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldObsList2ItemStateChanged(evt);
            }
        });
        this.btnClearObsType.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsType, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsType.text"));
        this.btnClearObsType.setBorder(new SoftBevelBorder(0));
        this.btnClearObsType.setContentAreaFilled(false);
        this.btnClearObsType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsTypeActionPerformed(evt);
            }
        });
        GroupLayout panelCategoryLayout = new GroupLayout(this.panelCategory);
        this.panelCategory.setLayout(panelCategoryLayout);
        panelCategoryLayout.setHorizontalGroup(panelCategoryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCategoryLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelCategoryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblObsList2, -1, -1, Short.MAX_VALUE).addGroup(panelCategoryLayout.createSequentialGroup().addComponent(this.fldObsList2, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsType, -2, 30, -2)))));
        panelCategoryLayout.setVerticalGroup(panelCategoryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCategoryLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblObsList2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelCategoryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldObsList2, -2, 30, -2).addComponent(this.btnClearObsType, -2, 30, -2))));
        this.lblObsList3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsList3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsList3.text"));
        this.fldObsList3.setFont(THEMIS.fontList);
        this.fldObsList3.setModel(this.modelPriority);
        this.fldObsList3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldObsList3ItemStateChanged(evt);
            }
        });
        this.btnClearObsPriority.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsPriority, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsPriority.text"));
        this.btnClearObsPriority.setBorder(new SoftBevelBorder(0));
        this.btnClearObsPriority.setContentAreaFilled(false);
        this.btnClearObsPriority.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsPriorityActionPerformed(evt);
            }
        });
        GroupLayout panelPriorityLayout = new GroupLayout(this.panelPriority);
        this.panelPriority.setLayout(panelPriorityLayout);
        panelPriorityLayout.setHorizontalGroup(panelPriorityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPriorityLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelPriorityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblObsList3, -1, -1, Short.MAX_VALUE).addGroup(panelPriorityLayout.createSequentialGroup().addComponent(this.fldObsList3, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsPriority, -2, 30, -2)))));
        panelPriorityLayout.setVerticalGroup(panelPriorityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelPriorityLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblObsList3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelPriorityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldObsList3, -2, 30, -2).addComponent(this.btnClearObsPriority, -2, 30, -2))));
        this.lblObsList1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsList1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsList1.text"));
        this.fldObsList1.setFont(THEMIS.fontList);
        this.fldObsList1.setModel(this.modelTopic);
        this.fldObsList1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldObsList1ItemStateChanged(evt);
            }
        });
        this.btnClearObsTopic.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsTopic, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsTopic.text"));
        this.btnClearObsTopic.setBorder(new SoftBevelBorder(0));
        this.btnClearObsTopic.setContentAreaFilled(false);
        this.btnClearObsTopic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsTopicActionPerformed(evt);
            }
        });
        GroupLayout panelTopicLayout = new GroupLayout(this.panelTopic);
        this.panelTopic.setLayout(panelTopicLayout);
        panelTopicLayout.setHorizontalGroup(panelTopicLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTopicLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelTopicLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblObsList1, -1, -1, Short.MAX_VALUE).addGroup(panelTopicLayout.createSequentialGroup().addComponent(this.fldObsList1, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsTopic, -2, 30, -2)))));
        panelTopicLayout.setVerticalGroup(panelTopicLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTopicLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblObsList1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelTopicLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldObsList1, -2, 30, -2).addComponent(this.btnClearObsTopic, -2, 30, -2))));
        this.lblObsFreeText.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsFreeText, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsFreeText.text"));
        this.btnSearchObsFreetext.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchObsFreetext, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchObsFreetext.text"));
        this.btnSearchObsFreetext.setBorder(new SoftBevelBorder(0));
        this.btnSearchObsFreetext.setContentAreaFilled(false);
        this.btnSearchObsFreetext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchObsFreetextActionPerformed(evt);
            }
        });
        this.btnClearObsFreetext.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsFreetext, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsFreetext.text"));
        this.btnClearObsFreetext.setBorder(new SoftBevelBorder(0));
        this.btnClearObsFreetext.setContentAreaFilled(false);
        this.btnClearObsFreetext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsFreetextActionPerformed(evt);
            }
        });
        this.fldObsTextFilter.setFont(THEMIS.fontTextfield);
        this.fldObsTextFilter.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldObsTextFilter.text"));
        this.fldObsTextFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldObsTextFilterActionPerformed(evt);
            }
        });
        this.fldObsTextFilter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldObsTextFilterFocusLost(evt);
            }
        });
        GroupLayout panelObsFreeTextLayout = new GroupLayout(this.panelObsFreeText);
        this.panelObsFreeText.setLayout(panelObsFreeTextLayout);
        panelObsFreeTextLayout.setHorizontalGroup(panelObsFreeTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsFreeTextLayout.createSequentialGroup().addComponent(this.fldObsTextFilter).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchObsFreetext, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsFreetext, -2, 30, -2)).addComponent(this.lblObsFreeText, -1, 546, Short.MAX_VALUE));
        panelObsFreeTextLayout.setVerticalGroup(panelObsFreeTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsFreeTextLayout.createSequentialGroup().addComponent(this.lblObsFreeText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObsFreeTextLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearObsFreetext, -2, 30, -2).addComponent(this.btnSearchObsFreetext, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldObsTextFilter, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        this.lblObsCode1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsCode1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsCode1.text"));
        this.btnSearchObsCode.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchObsCode, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchObsCode.text"));
        this.btnSearchObsCode.setBorder(new SoftBevelBorder(0));
        this.btnSearchObsCode.setContentAreaFilled(false);
        this.btnSearchObsCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchObsCodeActionPerformed(evt);
            }
        });
        this.btnClearObsCode.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsCode, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsCode.text"));
        this.btnClearObsCode.setBorder(new SoftBevelBorder(0));
        this.btnClearObsCode.setContentAreaFilled(false);
        this.btnClearObsCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsCodeActionPerformed(evt);
            }
        });
        this.fldObsCode.setFont(THEMIS.fontTextfield);
        this.fldObsCode.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldObsCode.text"));
        this.fldObsCode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldObsCodeFocusLost(evt);
            }
        });
        this.fldObsCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldObsCodeActionPerformed(evt);
            }
        });
        GroupLayout panelObsCodeLayout = new GroupLayout(this.panelObsCode);
        this.panelObsCode.setLayout(panelObsCodeLayout);
        panelObsCodeLayout.setHorizontalGroup(panelObsCodeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsCodeLayout.createSequentialGroup().addComponent(this.fldObsCode).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchObsCode, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsCode, -2, 30, -2)).addComponent(this.lblObsCode1, -1, -1, Short.MAX_VALUE));
        panelObsCodeLayout.setVerticalGroup(panelObsCodeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsCodeLayout.createSequentialGroup().addComponent(this.lblObsCode1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObsCodeLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearObsCode, -2, 30, -2).addComponent(this.btnSearchObsCode, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldObsCode, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        this.fldObsRealType.setFont(THEMIS.fontList);
        this.fldObsRealType.setModel(this.modelType);
        this.fldObsRealType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FilterPanel.this.fldObsRealTypeItemStateChanged(evt);
            }
        });
        this.lblRealObsType.setFont(THEMIS.fontList);
        Mnemonics.setLocalizedText((JLabel)this.lblRealObsType, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblRealObsType.text"));
        this.lblObsFreetext1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsFreetext1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsFreetext1.text"));
        this.btnSearchObsFreetext1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchObsFreetext1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchObsFreetext1.text"));
        this.btnSearchObsFreetext1.setBorder(new SoftBevelBorder(0));
        this.btnSearchObsFreetext1.setContentAreaFilled(false);
        this.btnSearchObsFreetext1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchObsFreetext1ActionPerformed(evt);
            }
        });
        this.btnClearObsFreetext1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsFreetext1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsFreetext1.text"));
        this.btnClearObsFreetext1.setBorder(new SoftBevelBorder(0));
        this.btnClearObsFreetext1.setContentAreaFilled(false);
        this.btnClearObsFreetext1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsFreetext1ActionPerformed(evt);
            }
        });
        this.fldObsFreetext1.setFont(THEMIS.fontTextfield);
        this.fldObsFreetext1.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldObsFreetext1.text"));
        this.fldObsFreetext1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldObsFreetext1FocusLost(evt);
            }
        });
        this.fldObsFreetext1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldObsFreetext1ActionPerformed(evt);
            }
        });
        GroupLayout panelObsFreetext1Layout = new GroupLayout(this.panelObsFreetext1);
        this.panelObsFreetext1.setLayout(panelObsFreetext1Layout);
        panelObsFreetext1Layout.setHorizontalGroup(panelObsFreetext1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsFreetext1Layout.createSequentialGroup().addComponent(this.fldObsFreetext1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchObsFreetext1, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsFreetext1, -2, 30, -2)).addComponent(this.lblObsFreetext1, -1, -1, Short.MAX_VALUE));
        panelObsFreetext1Layout.setVerticalGroup(panelObsFreetext1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsFreetext1Layout.createSequentialGroup().addComponent(this.lblObsFreetext1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObsFreetext1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearObsFreetext1, -2, 30, -2).addComponent(this.btnSearchObsFreetext1, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldObsFreetext1, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        this.lblObsFreetext2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsFreetext2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsFreetext2.text"));
        this.btnSearchObsFreetext2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchObsFreetext2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchObsFreetext2.text"));
        this.btnSearchObsFreetext2.setBorder(new SoftBevelBorder(0));
        this.btnSearchObsFreetext2.setContentAreaFilled(false);
        this.btnSearchObsFreetext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchObsFreetext2ActionPerformed(evt);
            }
        });
        this.btnClearObsFreetext2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsFreetext2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsFreetext2.text"));
        this.btnClearObsFreetext2.setBorder(new SoftBevelBorder(0));
        this.btnClearObsFreetext2.setContentAreaFilled(false);
        this.btnClearObsFreetext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsFreetext2ActionPerformed(evt);
            }
        });
        this.fldObsFreetext2.setFont(THEMIS.fontTextfield);
        this.fldObsFreetext2.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldObsFreetext2.text"));
        this.fldObsFreetext2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldObsFreetext2FocusLost(evt);
            }
        });
        this.fldObsFreetext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldObsFreetext2ActionPerformed(evt);
            }
        });
        GroupLayout panelObsFreetext2Layout = new GroupLayout(this.panelObsFreetext2);
        this.panelObsFreetext2.setLayout(panelObsFreetext2Layout);
        panelObsFreetext2Layout.setHorizontalGroup(panelObsFreetext2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsFreetext2Layout.createSequentialGroup().addComponent(this.fldObsFreetext2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchObsFreetext2, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsFreetext2, -2, 30, -2)).addComponent(this.lblObsFreetext2, -1, -1, Short.MAX_VALUE));
        panelObsFreetext2Layout.setVerticalGroup(panelObsFreetext2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsFreetext2Layout.createSequentialGroup().addComponent(this.lblObsFreetext2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObsFreetext2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearObsFreetext2, -2, 30, -2).addComponent(this.btnSearchObsFreetext2, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldObsFreetext2, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        this.lblObsFreetext3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsFreetext3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsFreetext3.text"));
        this.btnSearchObsFreetext3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchObsFreetext3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchObsFreetext3.text"));
        this.btnSearchObsFreetext3.setBorder(new SoftBevelBorder(0));
        this.btnSearchObsFreetext3.setContentAreaFilled(false);
        this.btnSearchObsFreetext3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchObsFreetext3ActionPerformed(evt);
            }
        });
        this.btnClearObsFreetext3.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsFreetext3, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsFreetext3.text"));
        this.btnClearObsFreetext3.setBorder(new SoftBevelBorder(0));
        this.btnClearObsFreetext3.setContentAreaFilled(false);
        this.btnClearObsFreetext3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsFreetext3ActionPerformed(evt);
            }
        });
        this.fldObsFreetext3.setFont(THEMIS.fontTextfield);
        this.fldObsFreetext3.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldObsFreetext3.text"));
        this.fldObsFreetext3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldObsFreetext3FocusLost(evt);
            }
        });
        this.fldObsFreetext3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldObsFreetext3ActionPerformed(evt);
            }
        });
        GroupLayout panelObsFreetext3Layout = new GroupLayout(this.panelObsFreetext3);
        this.panelObsFreetext3.setLayout(panelObsFreetext3Layout);
        panelObsFreetext3Layout.setHorizontalGroup(panelObsFreetext3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsFreetext3Layout.createSequentialGroup().addComponent(this.fldObsFreetext3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchObsFreetext3, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsFreetext3, -2, 30, -2)).addComponent(this.lblObsFreetext3, -1, -1, Short.MAX_VALUE));
        panelObsFreetext3Layout.setVerticalGroup(panelObsFreetext3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsFreetext3Layout.createSequentialGroup().addComponent(this.lblObsFreetext3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObsFreetext3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearObsFreetext3, -2, 30, -2).addComponent(this.btnSearchObsFreetext3, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldObsFreetext3, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        this.lblObsAmount.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsAmount, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsAmount.text"));
        this.btnSearchObsAmount.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchObsAmount, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchObsAmount.text"));
        this.btnSearchObsAmount.setBorder(new SoftBevelBorder(0));
        this.btnSearchObsAmount.setContentAreaFilled(false);
        this.btnSearchObsAmount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchObsAmountActionPerformed(evt);
            }
        });
        this.btnClearObsAmount.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsAmount, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsAmount.text"));
        this.btnClearObsAmount.setBorder(new SoftBevelBorder(0));
        this.btnClearObsAmount.setContentAreaFilled(false);
        this.btnClearObsAmount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsAmountActionPerformed(evt);
            }
        });
        this.fldObsAmount.setFont(THEMIS.fontTextfield);
        this.fldObsAmount.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldObsAmount.text"));
        this.fldObsAmount.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldObsAmountFocusLost(evt);
            }
        });
        this.fldObsAmount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldObsAmountActionPerformed(evt);
            }
        });
        GroupLayout panelObsAmountLayout = new GroupLayout(this.panelObsAmount);
        this.panelObsAmount.setLayout(panelObsAmountLayout);
        panelObsAmountLayout.setHorizontalGroup(panelObsAmountLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsAmountLayout.createSequentialGroup().addComponent(this.fldObsAmount).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchObsAmount, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsAmount, -2, 30, -2)).addComponent(this.lblObsAmount, -1, -1, Short.MAX_VALUE));
        panelObsAmountLayout.setVerticalGroup(panelObsAmountLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsAmountLayout.createSequentialGroup().addComponent(this.lblObsAmount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObsAmountLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearObsAmount, -2, 30, -2).addComponent(this.btnSearchObsAmount, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldObsAmount, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        this.btnClearObsRealType.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsRealType, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsRealType.text"));
        this.btnClearObsRealType.setBorder(new SoftBevelBorder(0));
        this.btnClearObsRealType.setContentAreaFilled(false);
        this.btnClearObsRealType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsRealTypeActionPerformed(evt);
            }
        });
        this.lblObsLangtext1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsLangtext1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsLangtext1.text"));
        this.btnSearchObsLangtext1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchObsLangtext1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchObsLangtext1.text"));
        this.btnSearchObsLangtext1.setBorder(new SoftBevelBorder(0));
        this.btnSearchObsLangtext1.setContentAreaFilled(false);
        this.btnSearchObsLangtext1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchObsLangtext1ActionPerformed(evt);
            }
        });
        this.btnClearObsLangtext1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsLangtext1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsLangtext1.text"));
        this.btnClearObsLangtext1.setBorder(new SoftBevelBorder(0));
        this.btnClearObsLangtext1.setContentAreaFilled(false);
        this.btnClearObsLangtext1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsLangtext1ActionPerformed(evt);
            }
        });
        this.fldObsLangtext1.setFont(THEMIS.fontTextfield);
        this.fldObsLangtext1.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldObsLangtext1.text"));
        this.fldObsLangtext1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldObsLangtext1ActionPerformed(evt);
            }
        });
        this.fldObsLangtext1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldObsLangtext1FocusLost(evt);
            }
        });
        GroupLayout panelObsLangtext1Layout = new GroupLayout(this.panelObsLangtext1);
        this.panelObsLangtext1.setLayout(panelObsLangtext1Layout);
        panelObsLangtext1Layout.setHorizontalGroup(panelObsLangtext1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsLangtext1Layout.createSequentialGroup().addComponent(this.fldObsLangtext1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchObsLangtext1, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsLangtext1, -2, 30, -2)).addComponent(this.lblObsLangtext1, -1, -1, Short.MAX_VALUE));
        panelObsLangtext1Layout.setVerticalGroup(panelObsLangtext1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsLangtext1Layout.createSequentialGroup().addComponent(this.lblObsLangtext1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObsLangtext1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearObsLangtext1, -2, 30, -2).addComponent(this.btnSearchObsLangtext1, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldObsLangtext1, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        this.lblObsLangtext2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsLangtext2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblObsLangtext2.text"));
        this.btnSearchObsLangtext2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchObsLangtext2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnSearchObsLangtext2.text"));
        this.btnSearchObsLangtext2.setBorder(new SoftBevelBorder(0));
        this.btnSearchObsLangtext2.setContentAreaFilled(false);
        this.btnSearchObsLangtext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnSearchObsLangtext2ActionPerformed(evt);
            }
        });
        this.btnClearObsLangtext2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearObsLangtext2, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.btnClearObsLangtext2.text"));
        this.btnClearObsLangtext2.setBorder(new SoftBevelBorder(0));
        this.btnClearObsLangtext2.setContentAreaFilled(false);
        this.btnClearObsLangtext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.btnClearObsLangtext2ActionPerformed(evt);
            }
        });
        this.fldObsLangtext2.setFont(THEMIS.fontTextfield);
        this.fldObsLangtext2.setText(NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.fldObsLangtext2.text"));
        this.fldObsLangtext2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.fldObsLangtext2ActionPerformed(evt);
            }
        });
        this.fldObsLangtext2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FilterPanel.this.fldObsLangtext2FocusLost(evt);
            }
        });
        GroupLayout panelObsLangtext2Layout = new GroupLayout(this.panelObsLangtext2);
        this.panelObsLangtext2.setLayout(panelObsLangtext2Layout);
        panelObsLangtext2Layout.setHorizontalGroup(panelObsLangtext2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsLangtext2Layout.createSequentialGroup().addComponent(this.fldObsLangtext2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSearchObsLangtext2, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsLangtext2, -2, 30, -2)).addComponent(this.lblObsLangtext2, -1, -1, Short.MAX_VALUE));
        panelObsLangtext2Layout.setVerticalGroup(panelObsLangtext2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObsLangtext2Layout.createSequentialGroup().addComponent(this.lblObsLangtext2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObsLangtext2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnClearObsLangtext2, -2, 30, -2).addComponent(this.btnSearchObsLangtext2, GroupLayout.Alignment.LEADING, -2, 30, -2).addComponent(this.fldObsLangtext2, GroupLayout.Alignment.LEADING, -2, 30, -2)).addGap(0, 0, 0)));
        GroupLayout panelObservationFilterLayout = new GroupLayout(this.panelObservationFilter);
        this.panelObservationFilter.setLayout(panelObservationFilterLayout);
        panelObservationFilterLayout.setHorizontalGroup(panelObservationFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelStatus, -1, -1, Short.MAX_VALUE).addComponent(this.panelDueDate, -1, -1, Short.MAX_VALUE).addComponent(this.panelContact, -1, -1, Short.MAX_VALUE).addComponent(this.panelCategory, -1, -1, Short.MAX_VALUE).addComponent(this.panelPriority, -1, -1, Short.MAX_VALUE).addComponent(this.panelTopic, -1, -1, Short.MAX_VALUE).addComponent(this.panelObsFreeText, -1, -1, Short.MAX_VALUE).addComponent(this.panelObsCode, -1, -1, Short.MAX_VALUE).addComponent(this.lblRealObsType, -1, -1, Short.MAX_VALUE).addComponent(this.panelObsFreetext1, -1, -1, Short.MAX_VALUE).addComponent(this.panelObsFreetext2, -1, -1, Short.MAX_VALUE).addComponent(this.panelObsFreetext3, -1, -1, Short.MAX_VALUE).addComponent(this.panelObsAmount, -1, -1, Short.MAX_VALUE).addComponent(this.panelObsRisk, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelObservationFilterLayout.createSequentialGroup().addComponent(this.fldObsRealType, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearObsRealType, -2, 30, -2)).addComponent(this.panelObsLangtext1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.panelObsLangtext2, -1, -1, Short.MAX_VALUE));
        panelObservationFilterLayout.setVerticalGroup(panelObservationFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationFilterLayout.createSequentialGroup().addComponent(this.panelObsFreeText, -2, -1, -2).addGap(10, 10, 10).addComponent(this.lblRealObsType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObservationFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldObsRealType, -2, 30, -2).addComponent(this.btnClearObsRealType, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelObsCode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelObsFreetext1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelObsFreetext2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelObsFreetext3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelObsLangtext1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelObsLangtext2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelObsAmount, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelStatus, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelDueDate, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelTopic, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelCategory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelPriority, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelObsRisk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelContact, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.panelObservationFilter, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.lblEmpty.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.lblEmpty, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.mainPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void btnEventFilterActionPerformed(ActionEvent evt) {
        this.showPanel(1);
    }

    private void btnLocFilterActionPerformed(ActionEvent evt) {
        this.showPanel(2);
    }

    private void btnObsFilterActionPerformed(ActionEvent evt) {
        this.showPanel(3);
    }

    private void fldEventOptionItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && !this.filter.getEventId().isEmpty()) {
            this.filter.setEventOption(this.fldEventOption.getSelectedIndex(), (Object)this);
        }
    }

    private void fldEventItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getEventId(), ((CmsBasicElement)item.getElement()).getId(), item.selected);
        }
        this.fldEventOption.setEnabled(this.isEventOptionEnabled());
    }

    private void fldStatusItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            this.filter.setStatus(this.fldStatus.getSelectedIndex(), (Object)this);
            if (this.fldStatus.getSelectedIndex() == 4 && this.app.getSettings().getDisplayHideDoneTask() == 1) {
                this.app.getDialog().showWarningDialog("message.filter.setting-status-done");
            }
        }
    }

    private void fldDuedateActionPerformed(ActionEvent evt) {
        if (this.triggerFilter) {
            this.filter.setDuedate(this.fldDuedate.getDate(), (Object)this);
        }
    }

    private void btnClearDuedateActionPerformed(ActionEvent evt) {
        this.fldDuedate.setDate(null);
        this.filter.setDuedate(null, (Object)this);
    }

    private void fldContactItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getCompanyId(), ((CmsBasicElement)item.getElement()).getId(), item.selected);
        }
    }

    private void fldObsList2ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getObsType(), ((KeytableRecord)item.getElement()).id, item.selected);
        }
    }

    private void fldObsList3ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getPriority(), ((KeytableRecord)item.getElement()).id, item.selected);
        }
    }

    private void fldObsList1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getTopic(), ((KeytableRecord)item.getElement()).id, item.selected);
        }
    }

    private void fldLocGroupItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getLocGroupId(), ((CmsBasicElement)item.getElement()).getId(), item.selected);
        }
    }

    private void btnSearchLocFreeTextActionPerformed(ActionEvent evt) {
        if (this.triggerFilter) {
            this.filter.setLocFreeText(this.fldLocationTextFilter.getText(), (Object)this);
        }
    }

    private void btnClearLocFreeTextActionPerformed(ActionEvent evt) {
        this.fldLocationTextFilter.setText("");
        this.filter.setLocFreeText(this.fldLocationTextFilter.getText(), (Object)this);
    }

    private void fldLocationTextFilterFocusLost(FocusEvent evt) {
        if (this.triggerFilter) {
            this.filter.setLocFreeText(this.fldLocationTextFilter.getText(), (Object)this);
        }
    }

    private void fldLocationTextFilterActionPerformed(ActionEvent evt) {
        this.filter.setLocFreeText(this.fldLocationTextFilter.getText(), (Object)this);
    }

    private void btnSearchLocText1ActionPerformed(ActionEvent evt) {
        this.filter.setLocText1(this.fldLocText1.getText(), (Object)this);
    }

    private void btnClearLocText1ActionPerformed(ActionEvent evt) {
        this.fldLocText1.setText("");
        this.filter.setLocText1(this.fldLocText1.getText(), (Object)this);
    }

    private void fldLocText1FocusLost(FocusEvent evt) {
        if (this.triggerFilter) {
            this.filter.setLocText1(this.fldLocText1.getText(), (Object)this);
        }
    }

    private void fldLocText1ActionPerformed(ActionEvent evt) {
        this.filter.setLocText1(this.fldLocText1.getText(), (Object)this);
    }

    private void btnSearchLocText2ActionPerformed(ActionEvent evt) {
        this.filter.setLocText2(this.fldLocText2.getText(), (Object)this);
    }

    private void btnClearLocText2ActionPerformed(ActionEvent evt) {
        this.fldLocText2.setText("");
        this.filter.setLocText2(this.fldLocText2.getText(), (Object)this);
    }

    private void fldLocText2FocusLost(FocusEvent evt) {
        if (this.triggerFilter) {
            this.filter.setLocText2(this.fldLocText2.getText(), (Object)this);
        }
    }

    private void fldLocText2ActionPerformed(ActionEvent evt) {
        this.filter.setLocText2(this.fldLocText2.getText(), (Object)this);
    }

    private void fldLocList1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getLocList1(), ((KeytableRecord)item.getElement()).id, item.selected);
        }
    }

    private void fldLocList2ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getLocList2(), ((KeytableRecord)item.getElement()).id, item.selected);
        }
    }

    private void btnSearchObsFreetextActionPerformed(ActionEvent evt) {
        this.filter.setObsFreeText(this.fldObsTextFilter.getText(), (Object)this);
    }

    private void btnClearObsFreetextActionPerformed(ActionEvent evt) {
        this.fldObsTextFilter.setText("");
        this.filter.setObsFreeText(this.fldObsTextFilter.getText(), (Object)this);
    }

    private void fldObsTextFilterFocusLost(FocusEvent evt) {
        this.filter.setObsFreeText(this.fldObsTextFilter.getText(), (Object)this);
    }

    private void fldObsTextFilterActionPerformed(ActionEvent evt) {
        this.filter.setObsFreeText(this.fldObsTextFilter.getText(), (Object)this);
    }

    private void btnSearchObsCodeActionPerformed(ActionEvent evt) {
        this.filter.setObsCode(this.fldObsCode.getText(), (Object)this);
    }

    private void btnClearObsCodeActionPerformed(ActionEvent evt) {
        this.fldObsCode.setText("");
        this.filter.setObsCode(this.fldObsCode.getText(), (Object)this);
    }

    private void fldObsCodeFocusLost(FocusEvent evt) {
        this.filter.setObsCode(this.fldObsCode.getText(), (Object)this);
    }

    private void fldObsCodeActionPerformed(ActionEvent evt) {
        this.filter.setObsCode(this.fldObsCode.getText(), (Object)this);
    }

    private void fldLocPlanItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            this.filter.clearCurrentPlanFilterFlag();
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getPlanId(), ((CmsBasicElement)item.getElement()).getId(), item.selected);
        }
    }

    private void btnClearFilterActionPerformed(ActionEvent evt) {
        this.clearAll();
    }

    private void fldObsRealTypeItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getObsRealType(), ((KeytableRecord)item.getElement()).id, item.selected);
        }
    }

    private void btnSearchObsFreetext1ActionPerformed(ActionEvent evt) {
        this.filter.setObsFreetext1(this.fldObsFreetext1.getText(), (Object)this);
    }

    private void btnClearObsFreetext1ActionPerformed(ActionEvent evt) {
        this.fldObsFreetext1.setText("");
        this.filter.setObsFreetext1(this.fldObsFreetext1.getText(), (Object)this);
    }

    private void fldObsFreetext1ActionPerformed(ActionEvent evt) {
        this.filter.setObsFreetext1(this.fldObsFreetext1.getText(), (Object)this);
    }

    private void fldObsFreetext1FocusLost(FocusEvent evt) {
        this.filter.setObsFreetext1(this.fldObsFreetext1.getText(), (Object)this);
    }

    private void btnSearchObsFreetext2ActionPerformed(ActionEvent evt) {
        this.filter.setObsFreetext2(this.fldObsFreetext2.getText(), (Object)this);
    }

    private void btnClearObsFreetext2ActionPerformed(ActionEvent evt) {
        this.fldObsFreetext2.setText("");
        this.filter.setObsFreetext2(this.fldObsFreetext2.getText(), (Object)this);
    }

    private void fldObsFreetext2ActionPerformed(ActionEvent evt) {
        this.filter.setObsFreetext2(this.fldObsFreetext2.getText(), (Object)this);
    }

    private void fldObsFreetext2FocusLost(FocusEvent evt) {
        this.filter.setObsFreetext2(this.fldObsFreetext2.getText(), (Object)this);
    }

    private void btnSearchObsFreetext3ActionPerformed(ActionEvent evt) {
        this.filter.setObsFreetext3(this.fldObsFreetext3.getText(), (Object)this);
    }

    private void btnClearObsFreetext3ActionPerformed(ActionEvent evt) {
        this.fldObsFreetext3.setText("");
        this.filter.setObsFreetext3(this.fldObsFreetext3.getText(), (Object)this);
    }

    private void fldObsFreetext3ActionPerformed(ActionEvent evt) {
        this.filter.setObsFreetext3(this.fldObsFreetext3.getText(), (Object)this);
    }

    private void fldObsFreetext3FocusLost(FocusEvent evt) {
        this.filter.setObsFreetext3(this.fldObsFreetext3.getText(), (Object)this);
    }

    private void btnSearchObsAmountActionPerformed(ActionEvent evt) {
        this.filter.setObsAmount(this.fldObsAmount.getText(), (Object)this);
    }

    private void btnClearObsAmountActionPerformed(ActionEvent evt) {
        this.fldObsAmount.setText("");
        this.filter.setObsAmount(this.fldObsAmount.getText(), (Object)this);
    }

    private void fldObsAmountFocusLost(FocusEvent evt) {
        this.filter.setObsAmount(this.fldObsAmount.getText(), (Object)this);
    }

    private void fldObsAmountActionPerformed(ActionEvent evt) {
        this.filter.setObsAmount(this.fldObsAmount.getText(), (Object)this);
    }

    private void fldLocationRangeFocusLost(FocusEvent evt) {
    }

    private void fldLocationRangeActionPerformed(ActionEvent evt) {
        this.setLocRangeFilter();
    }

    private void btnSearchLocRangeActionPerformed(ActionEvent evt) {
        this.setLocRangeFilter();
    }

    private void btnClearLocRangeActionPerformed(ActionEvent evt) {
        this.fldLocationRange.setText("");
        this.filter.setLocRange(null, (Object)this);
    }

    private void fldLocVisibilityItemStateChanged(ItemEvent evt) {
    }

    private void btnSearchLocBarcodeActionPerformed(ActionEvent evt) {
        this.filter.setLocBarcode(this.fldLocBarcode.getText(), (Object)this);
    }

    private void btnClearLocBarcodeActionPerformed(ActionEvent evt) {
        this.fldLocBarcode.setText("");
        this.filter.setLocBarcode(this.fldLocBarcode.getText(), (Object)this);
    }

    private void fldLocBarcodeActionPerformed(ActionEvent evt) {
        this.filter.setLocBarcode(this.fldLocBarcode.getText(), (Object)this);
    }

    private void fldLocBarcodeFocusLost(FocusEvent evt) {
        this.filter.setLocBarcode(this.fldLocBarcode.getText(), (Object)this);
    }

    private void btnSearchObsRiskActionPerformed(ActionEvent evt) {
        this.filter.setObsRisk(this.fldObsRisk.getText(), (Object)this);
    }

    private void btnClearObsRiskActionPerformed(ActionEvent evt) {
        this.fldObsRisk.setText("");
        this.filter.setObsRisk(this.fldObsRisk.getText(), (Object)this);
    }

    private void fldObsRiskFocusLost(FocusEvent evt) {
        this.filter.setObsRisk(this.fldObsRisk.getText(), (Object)this);
    }

    private void fldObsRiskActionPerformed(ActionEvent evt) {
        this.filter.setObsRisk(this.fldObsRisk.getText(), (Object)this);
    }

    private void fldLocBuildingItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getLocBuildingId(), ((CmsBasicElement)item.getElement()).getId(), item.selected);
        }
    }

    private void btnSearchEventDatesActionPerformed(ActionEvent evt) {
        this.setEventDateFilter();
    }

    private void btnClearEventDatesActionPerformed(ActionEvent evt) {
        this.fldEventDateFrom.setDate(null);
        this.fldEventDateUntil.setDate(null);
        this.setEventDateFilter();
    }

    private void btnSearchLocText3ActionPerformed(ActionEvent evt) {
        this.filter.setLocText3(this.fldLocText3.getText(), (Object)this);
    }

    private void btnClearLocText3ActionPerformed(ActionEvent evt) {
        this.fldLocText3.setText("");
        this.filter.setLocText3(this.fldLocText3.getText(), (Object)this);
    }

    private void fldLocText3ActionPerformed(ActionEvent evt) {
        this.filter.setLocText3(this.fldLocText3.getText(), (Object)this);
    }

    private void fldLocText3FocusLost(FocusEvent evt) {
        this.filter.setLocText3(this.fldLocText3.getText(), (Object)this);
    }

    private void btnSearchLocText4ActionPerformed(ActionEvent evt) {
        this.filter.setLocText4(this.fldLocText4.getText(), (Object)this);
    }

    private void btnClearLocText4ActionPerformed(ActionEvent evt) {
        this.fldLocText4.setText("");
        this.filter.setLocText4(this.fldLocText4.getText(), (Object)this);
    }

    private void fldLocText4ActionPerformed(ActionEvent evt) {
        this.filter.setLocText4(this.fldLocText4.getText(), (Object)this);
    }

    private void fldLocText4FocusLost(FocusEvent evt) {
        this.filter.setLocText4(this.fldLocText4.getText(), (Object)this);
    }

    private void btnSearchLocLangtext2ActionPerformed(ActionEvent evt) {
        this.filter.setLocLongtext2(this.fldLocLangtext2.getText(), (Object)this);
    }

    private void btnClearLocLangtext2ActionPerformed(ActionEvent evt) {
        this.fldLocLangtext2.setText("");
        this.filter.setLocLongtext2(this.fldLocLangtext2.getText(), (Object)this);
    }

    private void fldLocLangtext2ActionPerformed(ActionEvent evt) {
        this.filter.setLocLongtext2(this.fldLocLangtext2.getText(), (Object)this);
    }

    private void fldLocLangtext2FocusLost(FocusEvent evt) {
        this.filter.setLocLongtext2(this.fldLocLangtext2.getText(), (Object)this);
    }

    private void btnSearchLocLangtext1ActionPerformed(ActionEvent evt) {
        this.filter.setLocLongtext1(this.fldLocLangtext1.getText(), (Object)this);
    }

    private void btnClearLocLangtext1ActionPerformed(ActionEvent evt) {
        this.fldLocLangtext1.setText("");
        this.filter.setLocLongtext1(this.fldLocLangtext1.getText(), (Object)this);
    }

    private void fldLocLangtext1ActionPerformed(ActionEvent evt) {
        this.filter.setLocLongtext1(this.fldLocLangtext1.getText(), (Object)this);
    }

    private void fldLocLangtext1FocusLost(FocusEvent evt) {
        this.filter.setLocLongtext1(this.fldLocLangtext1.getText(), (Object)this);
    }

    private void btnSearchLocLangtext4ActionPerformed(ActionEvent evt) {
        this.filter.setLocLongtext4(this.fldLocLangtext4.getText(), (Object)this);
    }

    private void btnClearLocLangtext4ActionPerformed(ActionEvent evt) {
        this.fldLocLangtext4.setText("");
        this.filter.setLocLongtext4(this.fldLocLangtext4.getText(), (Object)this);
    }

    private void fldLocLangtext4ActionPerformed(ActionEvent evt) {
        this.filter.setLocLongtext4(this.fldLocLangtext4.getText(), (Object)this);
    }

    private void fldLocLangtext4FocusLost(FocusEvent evt) {
        this.filter.setLocLongtext4(this.fldLocLangtext4.getText(), (Object)this);
    }

    private void btnSearchLocLangtext3ActionPerformed(ActionEvent evt) {
        this.filter.setLocLongtext3(this.fldLocLangtext3.getText(), (Object)this);
    }

    private void btnClearLocLangtext3ActionPerformed(ActionEvent evt) {
        this.fldLocLangtext3.setText("");
        this.filter.setLocLongtext3(this.fldLocLangtext3.getText(), (Object)this);
    }

    private void fldLocLangtext3ActionPerformed(ActionEvent evt) {
        this.filter.setLocLongtext3(this.fldLocLangtext3.getText(), (Object)this);
    }

    private void fldLocLangtext3FocusLost(FocusEvent evt) {
        this.filter.setLocLongtext3(this.fldLocLangtext3.getText(), (Object)this);
    }

    private void fldLocList3ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.triggerFilter) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getLocList3(), ((KeytableRecord)item.getElement()).id, item.selected);
        }
    }

    private void fldLocList4ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            CheckableItem item = (CheckableItem)evt.getItem();
            this.updateFilterItem(this.filter.getLocList4(), ((KeytableRecord)item.getElement()).id, item.selected);
        }
    }

    private void fldLocList3ActionPerformed(ActionEvent evt) {
    }

    private void btnClearEventActionPerformed(ActionEvent evt) {
        this.filter.getEventId().clear((Object)this);
        this.fldEventOption.setEnabled(this.isEventOptionEnabled());
        this.updateElementFilter(this.fldEvent, this.filter.getEventId());
    }

    private void btnClearLocGroupActionPerformed(ActionEvent evt) {
        this.filter.getLocGroupId().clear((Object)this);
        this.updateElementFilter(this.fldLocGroup, this.filter.getLocGroupId());
    }

    private void btnClearLocPlanActionPerformed(ActionEvent evt) {
        this.filter.getPlanId().clear((Object)this);
        this.updateElementFilter(this.fldLocPlan, this.filter.getPlanId());
    }

    private void btnClearLocBuildingActionPerformed(ActionEvent evt) {
        this.filter.getLocBuildingId().clear((Object)this);
        this.updateElementFilter(this.fldLocBuilding, this.filter.getLocBuildingId());
    }

    private void btnClearLocList1ActionPerformed(ActionEvent evt) {
        this.filter.getLocList1().clear((Object)this);
        this.updateKeytableFilter(this.fldLocList1, this.filter.getLocList1());
    }

    private void btnClearLocList2ActionPerformed(ActionEvent evt) {
        this.filter.getLocList2().clear((Object)this);
        this.updateKeytableFilter(this.fldLocList2, this.filter.getLocList2());
    }

    private void btnClearLocList3ActionPerformed(ActionEvent evt) {
        this.filter.getLocList3().clear((Object)this);
        this.updateKeytableFilter(this.fldLocList3, this.filter.getLocList3());
    }

    private void btnClearLocList4ActionPerformed(ActionEvent evt) {
        this.filter.getLocList4().clear((Object)this);
        this.updateKeytableFilter(this.fldLocList4, this.filter.getLocList4());
    }

    private void btnClearObsRealTypeActionPerformed(ActionEvent evt) {
        this.filter.getObsRealType().clear((Object)this);
        this.updateKeytableFilter(this.fldObsRealType, this.filter.getObsRealType());
    }

    private void btnClearObsTypeActionPerformed(ActionEvent evt) {
        this.filter.getObsType().clear((Object)this);
        this.updateKeytableFilter(this.fldObsList2, this.filter.getObsType());
    }

    private void btnClearObsTopicActionPerformed(ActionEvent evt) {
        this.filter.getTopic().clear((Object)this);
        this.updateKeytableFilter(this.fldObsList1, this.filter.getTopic());
    }

    private void btnClearObsPriorityActionPerformed(ActionEvent evt) {
        this.filter.getPriority().clear((Object)this);
        this.updateKeytableFilter(this.fldObsList3, this.filter.getPriority());
    }

    private void btnClearObsContactsActionPerformed(ActionEvent evt) {
        this.filter.getCompanyId().clear((Object)this);
        this.updateElementFilter(this.fldContact, this.filter.getCompanyId());
    }

    private void fldEventDateFromPropertyChange(PropertyChangeEvent evt) {
        if ("date".equals(evt.getPropertyName())) {
            this.fldEventOption.setEnabled(this.isEventOptionEnabled());
        }
    }

    private void fldEventDateUntilPropertyChange(PropertyChangeEvent evt) {
        if ("date".equals(evt.getPropertyName())) {
            this.fldEventOption.setEnabled(this.isEventOptionEnabled());
        }
    }

    private void radLocFlagNotSet1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag1().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.NOTSET, (Object)this);
        }
    }

    private void radLocFlagYes1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag1().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.YES, (Object)this);
        }
    }

    private void radLocFlagNo1ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag1().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.NO, (Object)this);
        }
    }

    private void radLocFlagNotSet2ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag2().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.NOTSET, (Object)this);
        }
    }

    private void radLocFlagYes2ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag2().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.YES, (Object)this);
        }
    }

    private void radLocFlagNo2ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag2().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.NO, (Object)this);
        }
    }

    private void radLocFlagYes3ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag3().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.YES, (Object)this);
        }
    }

    private void radLocFlagNotSet3ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag3().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.NOTSET, (Object)this);
        }
    }

    private void radLocFlagNo3ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag3().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.NO, (Object)this);
        }
    }

    private void radLocFlagNotSet4ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag4().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.NOTSET, (Object)this);
        }
    }

    private void radLocFlagYes4ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag4().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.YES, (Object)this);
        }
    }

    private void radLocFlagNo4ItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.filter.getLocFlag4().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.NO, (Object)this);
        }
    }

    private void btnSaveFilterElementActionPerformed(ActionEvent evt) {
        String newName;
        String name = "";
        if (this.currentFilterElement != null && this.currentFilterElement.getId() > 0L) {
            name = this.currentFilterElement.getTitle();
        }
        if ((newName = Dialogs.getInstance().showInputDialogFilled("dialog.input-filtername", name)) == null) {
            return;
        }
        ArrayList filters = this.project.getFilters();
        long saveId = -1L;
        for (CmsBasicElement f : filters) {
            if (!newName.equals(f.getTitle()) || !Dialogs.getInstance().showConfirmDialog("dialog.confirm-overwrite-filter")) continue;
            saveId = f.getId();
            this.currentFilterElement = f;
        }
        this.currentFilterElement = this.filter.saveFilter(saveId, newName);
        this.populateFilterElements();
    }

    private void btnDeleteFilterElementActionPerformed(ActionEvent evt) {
        CmsBasicElement be = (CmsBasicElement)this.fldFilterElements.getSelectedItem();
        if (be != null && be.getId() > 0L) {
            CmsElement.moveToTrash((CmsApplication)this.project, (long)be.getId(), (CmsUser)this.project.getUser());
            this.populateFilterElements();
        }
    }

    private void btnLoadFilterElementActionPerformed(ActionEvent evt) {
        CmsBasicElement be = (CmsBasicElement)this.fldFilterElements.getSelectedItem();
        if (be != null && be.getId() > 0L) {
            this.filter.loadFilter(be.getId());
            this.currentFilterElement = be;
            this.updateAll();
        }
    }

    private void btnSearchObsLangtext1ActionPerformed(ActionEvent evt) {
        this.filter.setObsLangtext1(this.fldObsLangtext1.getText(), (Object)this);
    }

    private void btnClearObsLangtext1ActionPerformed(ActionEvent evt) {
        this.fldObsLangtext1.setText("");
        this.filter.setObsLangtext1(this.fldObsLangtext1.getText(), (Object)this);
    }

    private void fldObsLangtext1ActionPerformed(ActionEvent evt) {
        this.filter.setObsLangtext1(this.fldObsLangtext1.getText(), (Object)this);
    }

    private void fldObsLangtext1FocusLost(FocusEvent evt) {
        this.filter.setObsLangtext1(this.fldObsLangtext1.getText(), (Object)this);
    }

    private void btnSearchObsLangtext2ActionPerformed(ActionEvent evt) {
        this.filter.setObsLangtext2(this.fldObsLangtext2.getText(), (Object)this);
    }

    private void btnClearObsLangtext2ActionPerformed(ActionEvent evt) {
        this.fldObsLangtext1.setText("");
        this.filter.setObsLangtext1(this.fldObsLangtext1.getText(), (Object)this);
    }

    private void fldObsLangtext2ActionPerformed(ActionEvent evt) {
        this.filter.setObsLangtext2(this.fldObsLangtext2.getText(), (Object)this);
    }

    private void fldObsLangtext2FocusLost(FocusEvent evt) {
        this.filter.setObsLangtext2(this.fldObsLangtext2.getText(), (Object)this);
    }

    private void fldEventActionPerformed(ActionEvent evt) {
    }

    private void fldLocDate1FromPropertyChange(PropertyChangeEvent evt) {
        this.setLocDate1Filter();
    }

    private void fldLocDate1UntilPropertyChange(PropertyChangeEvent evt) {
        this.setLocDate1Filter();
    }

    private void btnSetLocDates1ActionPerformed(ActionEvent evt) {
        this.setLocDate1Filter();
    }

    private void btnClearLocDates1ActionPerformed(ActionEvent evt) {
        this.fldLocDate1From.setDate(null);
        this.fldLocDate1Until.setDate(null);
        this.setLocDate1Filter();
    }

    private void fldLocDate2FromPropertyChange(PropertyChangeEvent evt) {
        this.setLocDate2Filter();
    }

    private void fldLocDate2UntilPropertyChange(PropertyChangeEvent evt) {
        this.setLocDate2Filter();
    }

    private void btnSetLocDates2ActionPerformed(ActionEvent evt) {
        this.setLocDate2Filter();
    }

    private void btnClearLocDates2ActionPerformed(ActionEvent evt) {
        this.fldLocDate2From.setDate(null);
        this.fldLocDate2Until.setDate(null);
        this.setLocDate2Filter();
    }

    private void fldLocDate3FromPropertyChange(PropertyChangeEvent evt) {
        this.setLocDate3Filter();
    }

    private void fldLocDate3UntilPropertyChange(PropertyChangeEvent evt) {
        this.setLocDate3Filter();
    }

    private void btnSetLocDates3ActionPerformed(ActionEvent evt) {
        this.setLocDate3Filter();
    }

    private void btnClearLocDates3ActionPerformed(ActionEvent evt) {
        this.fldLocDate3From.setDate(null);
        this.fldLocDate3Until.setDate(null);
        this.setLocDate3Filter();
    }

    private void fldLocDate4FromPropertyChange(PropertyChangeEvent evt) {
        this.setLocDate4Filter();
    }

    private void fldLocDate4UntilPropertyChange(PropertyChangeEvent evt) {
        this.setLocDate4Filter();
    }

    private void btnSetLocDates4ActionPerformed(ActionEvent evt) {
        this.setLocDate4Filter();
    }

    private void btnClearLocDates4ActionPerformed(ActionEvent evt) {
        this.fldLocDate3From.setDate(null);
        this.fldLocDate3Until.setDate(null);
        this.setLocDate4Filter();
    }

    private void fldFilterElementsItemStateChanged(ItemEvent evt) {
        CmsBasicElement be;
        if (evt.getStateChange() == 1 && (be = (CmsBasicElement)this.fldFilterElements.getSelectedItem()) != null && be.getId() > 0L) {
            this.filter.loadFilter(be.getId());
            this.currentFilterElement = be;
            this.updateAll();
        }
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(ThemisApplication.getInstance().getProject().getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FilterPanel.this.closeDialog();
            }
        });
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, dlg, 420, 335);
        dlg.setMinimumSize(new Dimension(350, 335));
        dlg.setVisible(true);
    }

    private void closeDialog() {
        JDialog parent = (JDialog)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, parent);
        parent.dispose();
    }
}

