/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.form;

import at.grid.themis.application.form.FormListPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.CmsFormularHistory;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FormListItem
extends JPanel {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final CmsFormular form;
    private final FormListPanel parent;
    private JCheckBox chkSelection;
    private JLabel lblAlias;
    private JLabel lblHistory;
    private JLabel lblTitle;
    private JPanel panelContent;
    private JPanel panelLine1;
    private JPanel panelLine2;

    public FormListItem(CmsFormular form) {
        this(form, null);
    }

    public FormListItem(CmsFormular form, FormListPanel parent) {
        this.initComponents();
        this.form = form;
        this.parent = parent;
        this.initialise();
    }

    private void initialise() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                FormListItem.this.handleClick(e);
            }
        });
        this.lblTitle.setText(this.form.getFormName());
        this.lblAlias.setText(this.form.getFormAlias());
        String history = "-";
        CmsFormularHistory hist = this.form.getLatestFormHistory();
        if (hist != null) {
            history = Util.formatDate((Date)hist.getEventDate(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone());
            if (history.trim().isEmpty()) {
                history = history + "-";
            }
            history = history + " (" + hist.getAttributeValue("meta_lasteditby") + ")";
        }
        this.lblHistory.setText(history);
    }

    private void handleClick(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (this.parent != null) {
                this.parent.editForm(this.form);
            }
        } else {
            this.handleSingleClick();
        }
    }

    public void handleSingleClick() {
        Component[] components;
        for (Component c : components = this.getParent().getComponents()) {
            if (!(c instanceof FormListItem)) continue;
            ((FormListItem)c).setSelectCheckbox(false);
        }
        this.setSelectCheckbox(true);
    }

    public void setSelectCheckbox(boolean flag) {
        this.chkSelection.setSelected(flag);
    }

    public boolean isSelected() {
        return this.chkSelection.isSelected();
    }

    public CmsFormular getForm() {
        return this.form;
    }

    private void initComponents() {
        this.chkSelection = new JCheckBox();
        this.panelContent = new JPanel();
        this.panelLine1 = new JPanel();
        this.lblTitle = new JLabel();
        this.lblAlias = new JLabel();
        this.panelLine2 = new JPanel();
        this.lblHistory = new JLabel();
        this.setBorder(new SoftBevelBorder(0));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 42));
        this.setMinimumSize(new Dimension(59, 42));
        this.setPreferredSize(new Dimension(59, 42));
        this.setLayout(new BoxLayout(this, 2));
        this.chkSelection.setToolTipText(NbBundle.getMessage(FormListItem.class, (String)"FormListItem.chkSelection.toolTipText"));
        this.chkSelection.setMargin(new Insets(8, 8, 8, 8));
        this.chkSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FormListItem.this.chkSelectionItemStateChanged(evt);
            }
        });
        this.add(this.chkSelection);
        this.panelContent.setLayout(new BoxLayout(this.panelContent, 3));
        this.panelLine1.setLayout(new BoxLayout(this.panelLine1, 2));
        this.lblTitle.setFont(new Font("Tahoma", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(FormListItem.class, (String)"FormListItem.lblTitle.text"));
        this.lblTitle.setMaximumSize(new Dimension(999, 999));
        this.panelLine1.add(this.lblTitle);
        this.lblAlias.setFont(new Font("Tahoma", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.lblAlias, (String)NbBundle.getMessage(FormListItem.class, (String)"FormListItem.lblAlias.text"));
        this.panelLine1.add(this.lblAlias);
        this.panelContent.add(this.panelLine1);
        this.panelLine2.setLayout(new BoxLayout(this.panelLine2, 2));
        Mnemonics.setLocalizedText((JLabel)this.lblHistory, (String)NbBundle.getMessage(FormListItem.class, (String)"FormListItem.lblHistory.text"));
        this.lblHistory.setMaximumSize(new Dimension(999, 999));
        this.panelLine2.add(this.lblHistory);
        this.panelContent.add(this.panelLine2);
        this.add(this.panelContent);
    }

    private void chkSelectionItemStateChanged(ItemEvent evt) {
        if (this.isSelected()) {
            this.setBackground(Color.LIGHT_GRAY);
            this.chkSelection.setBackground(Color.LIGHT_GRAY);
            this.panelContent.setBackground(Color.LIGHT_GRAY);
            this.panelLine1.setBackground(Color.LIGHT_GRAY);
            this.panelLine2.setBackground(Color.LIGHT_GRAY);
        } else {
            this.setBackground(new Color(242, 242, 242));
            this.chkSelection.setBackground(new Color(242, 242, 242));
            this.panelContent.setBackground(new Color(242, 242, 242));
            this.panelLine1.setBackground(new Color(242, 242, 242));
            this.panelLine2.setBackground(new Color(242, 242, 242));
        }
        if (this.parent != null) {
            this.parent.itemClicked(this);
        }
    }
}

