/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.form;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.storage.SearchResult;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.form.FormListItem;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsFormular;
import at.grid.themis.ontology.element.CmsFormularHistory;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.javafx.formeditor.FormEditorFxPanel;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.PdfContentForm;
import at.grid.themis.ontology.report.pdf.PdfLayoutExporter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.apache.commons.io.FileUtils;
import org.jdom.JDOMException;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class FormListPanel
extends JPanel
implements ThemisActionListener {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/form/Bundle");
    private final TopComponent tc;
    private ArrayList<FormListItem> items = new ArrayList();
    private boolean ignoreItemClick = false;
    private JButton btnAdd;
    private JButton btnClearLocFreeText;
    private JButton btnCopy;
    private JButton btnDelete;
    private JButton btnEdit;
    private JButton btnPdf;
    private JButton btnSearchLocFreeText;
    private JButton btnUserAction;
    private JPanel buttonPanel;
    private JCheckBox chkSelection;
    private JPanel contentPanel;
    private JTextField fldSearch;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JLabel lblAlias;
    private JLabel lblHistory;
    private JLabel lblLocation1;
    private JLabel lblTitle;
    private JPanel listPanel;
    private JScrollPane listScroll;
    private JPanel mainPanel;
    private JPanel panelContent;
    private JPanel panelLine1;
    private JPanel panelLine2;
    private JPanel searchPanel;

    public FormListPanel(TopComponent tc, boolean editor) {
        THEMIS.getLicense();
        this.initComponents();
        this.tc = tc;
        new DragScrollHandler(this.listPanel, false, true);
        this.initialize();
        this.searchPanel.setVisible(false);
        if (editor) {
            ThemisActionProvider.getInstance().registerEditor(this);
        } else {
            ThemisActionProvider.getInstance().register(this);
        }
    }

    public void initialize() {
        this.clear();
        this.updateFormsList();
        this.updateActions();
        this.chkSelection.setSelected(false);
        this.ignoreItemClick = true;
        for (FormListItem item : this.items) {
            item.setSelectCheckbox(false);
        }
        this.ignoreItemClick = false;
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 1101: {
                this.clear();
                this.updateActions();
                break;
            }
            case 550: {
                this.updateFormsList();
                break;
            }
            case 1100: 
            case 1102: {
                this.initialize();
            }
        }
    }

    public void clear() {
        this.listPanel.removeAll();
        this.items.clear();
    }

    private void updateActions() {
        this.btnAdd.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnDelete.setVisible(false);
        this.btnUserAction.setVisible(false);
        this.btnAdd.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnCopy.setEnabled(false);
        this.btnDelete.setEnabled(false);
        if (!this.app.getProject().isOpen()) {
            return;
        }
        boolean hasLicense = this.app.getLicense().hasLicense();
        this.btnAdd.setEnabled(hasLicense);
        long selected = this.items.stream().filter(i -> i.isSelected()).count();
        this.btnEdit.setEnabled(hasLicense && selected == 1L);
        this.btnCopy.setEnabled(hasLicense && selected == 1L);
        this.btnDelete.setEnabled(hasLicense && selected > 0L);
        this.btnPdf.setEnabled(hasLicense && selected == 1L);
    }

    public void itemClicked(FormListItem item) {
        if (this.ignoreItemClick) {
            return;
        }
        if (!item.isSelected()) {
            this.chkSelection.setSelected(false);
        }
        if (this.items.stream().noneMatch(i -> !i.isSelected())) {
            this.chkSelection.setSelected(true);
        }
        this.updateActions();
    }

    public void updateFormsList() {
        this.items.clear();
        this.listPanel.removeAll();
        if (!this.project.isOpen()) {
            return;
        }
        String keyword = this.fldSearch.getText();
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "form");
        s.addSelectAllAttributes("form");
        if (!"".equals(keyword)) {
            s.addWhere(keyword);
        }
        SearchResult result = s.search();
        ArrayList ids = result.getResultIds();
        ids.sort((a, b) -> a.compareTo((Long)b));
        for (Long id : ids) {
            CmsFormular form = (CmsFormular)this.project.loadElement(id.longValue(), this.project.getUser());
            FormListItem item = new FormListItem(form, this);
            this.items.add(item);
            this.listPanel.add(item);
        }
        this.listPanel.revalidate();
        this.listPanel.repaint();
    }

    private void showActionMenu() {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        JPopupMenu menu = new JPopupMenu("Optionen");
        JMenuItem item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.frm.load"), Color.WHITE, false, null);
        item.addActionListener(e2 -> {
            this.loadForm();
            this.initialize();
        });
        menu.add(item);
        item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.frm.save"), Color.WHITE, false, null);
        item.addActionListener(e2 -> this.saveForm());
        menu.add(item);
        item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.frm.load-structure"), Color.WHITE, false, null);
        item.addActionListener(e2 -> this.loadFormStructure());
        menu.add(item);
        int c = menu.getComponentCount();
        menu.show(this.btnUserAction, this.btnUserAction.getWidth(), 0);
    }

    private void loadForm() {
        File file = new ThemisFileDialog("Datei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getSettings().getExportFolder().getValue(true), null, THEMIS.getThemisFileFilter(), "themis", false).getSelectedFile();
        if (file != null) {
            this.app.getSettings().getExportFolder().setValue(file.getParentFile());
            ThemisFile tf = new ThemisFile();
            tf.setAsForm();
            try {
                tf.loadFromFile(file, true);
            }
            catch (IOException | JDOMException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void loadFormStructure() {
        File file = new ThemisFileDialog("Datei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getSettings().getExportFolder().getValue(true), null, THEMIS.getFileExtensionFilter("xml", "XML Datei"), "xml", false).getSelectedFile();
        if (file != null) {
            this.app.getSettings().getExportFolder().setValue(file.getParentFile());
            try {
                String xml = FileUtils.readFileToString((File)file, (String)"UTF-8");
                for (FormListItem item : this.items) {
                    if (!item.isSelected()) continue;
                    CmsFormular form = item.getForm();
                    form.setFormXml(xml);
                    form.save();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void saveForm() {
        File file = new ThemisFileDialog("Datei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.SAVE, this.app.getSettings().getExportFolder().getValue(true), null, THEMIS.getThemisFileFilter(), "themis", false).getSelectedFile();
        if (file != null) {
            this.app.getSettings().getExportFolder().setValue(file.getParentFile());
            ThemisFile tf = new ThemisFile();
            tf.setContentType(ThemisFile.ContentType.FORM);
            for (FormListItem item : this.items) {
                if (!item.isSelected()) continue;
                CmsFormular form = item.getForm();
                tf.addContent(form.getId());
                tf.addContent(form.getFilterIds());
            }
            try {
                tf.saveToFile(file, false);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void saveAsPdf() {
        Optional<FormListItem> item = this.items.stream().filter(i -> i.isSelected()).findFirst();
        if (item.isPresent()) {
            if (this.project.getSelectionManager().getCurrentEventId() < 0L) {
                Dialogs.getInstance().showErrorDialog("Kein Ereignis");
                return;
            }
            CmsFormular form = item.get().getForm();
            CmsReport rep = new CmsReport();
            rep.event = this.project.getSelectionManager().getCurrentEvent();
            rep.exportFormat = CmsReport.ReportFormat.PDF_FREE;
            rep.contentType = CmsReport.Content.FILTER;
            rep.exportPlans = false;
            PdfContentForm pdfForm = new PdfContentForm();
            pdfForm.setForm(form);
            rep.templatePdfLayout.clear();
            rep.templatePdfLayout.add(pdfForm);
            File file = new ThemisFileDialog("Datei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.SAVE, null, null, THEMIS.getPdfFilter(), "pdf", false).getSelectedFile();
            if (file != null) {
                if (file.exists() && !Dialogs.getInstance().showConfirmDialog("\u00dcberschreiben?")) {
                    return;
                }
                if (file.exists()) {
                    file.delete();
                }
                PdfLayoutExporter pdf = new PdfLayoutExporter(rep);
                pdf.exportToPdf(file, rep, this.project.getUser(), null, 0, 10);
                if (file.isFile()) {
                    THEMIS.showFileResultDialog(file);
                }
            }
        }
    }

    public void editForm(CmsFormular form) {
        if (form == null) {
            return;
        }
        CmsFormularHistory hist = this.project.getSelectionManager().getCurrentEventId() > 0L ? form.getCurrentFormHistory() : form.getLatestFormHistory();
        new FormEditorFxPanel(hist).showAsSwingDialog(THEMIS.getMainWindow());
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.searchPanel = new JPanel();
        this.lblLocation1 = new JLabel();
        this.fldSearch = new JTextField();
        this.btnSearchLocFreeText = new JButton();
        this.btnClearLocFreeText = new JButton();
        this.contentPanel = new JPanel();
        this.listScroll = new JScrollPane();
        this.listPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.chkSelection = new JCheckBox();
        this.panelContent = new JPanel();
        this.panelLine1 = new JPanel();
        this.lblTitle = new JLabel();
        this.lblAlias = new JLabel();
        this.panelLine2 = new JPanel();
        this.lblHistory = new JLabel();
        this.buttonPanel = new JPanel();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnCopy = new JButton();
        this.btnDelete = new JButton();
        this.jLabel2 = new JLabel();
        this.btnPdf = new JButton();
        this.btnUserAction = new JButton();
        this.mainPanel.setPreferredSize(new Dimension(410, 717));
        this.mainPanel.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.searchPanel.setLayout(new GridBagLayout());
        this.lblLocation1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocation1, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.lblLocation1.text"));
        this.lblLocation1.setPreferredSize(new Dimension(85, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.searchPanel.add((Component)this.lblLocation1, gridBagConstraints);
        this.fldSearch.setFont(THEMIS.fontTextfield);
        this.fldSearch.setText(NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.fldSearch.text"));
        this.fldSearch.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FormListPanel.this.fldSearchFocusLost(evt);
            }
        });
        this.fldSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormListPanel.this.fldSearchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.searchPanel.add((Component)this.fldSearch, gridBagConstraints);
        this.btnSearchLocFreeText.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocFreeText, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnSearchLocFreeText.text"));
        this.btnSearchLocFreeText.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocFreeText.setContentAreaFilled(false);
        this.btnSearchLocFreeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormListPanel.this.btnSearchLocFreeTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.searchPanel.add((Component)this.btnSearchLocFreeText, gridBagConstraints);
        this.btnClearLocFreeText.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocFreeText, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnClearLocFreeText.text"));
        this.btnClearLocFreeText.setBorder(new SoftBevelBorder(0));
        this.btnClearLocFreeText.setContentAreaFilled(false);
        this.btnClearLocFreeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormListPanel.this.btnClearLocFreeTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.searchPanel.add((Component)this.btnClearLocFreeText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.searchPanel, gridBagConstraints);
        this.contentPanel.setLayout(new BorderLayout());
        this.listScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 3));
        this.listScroll.setViewportView(this.listPanel);
        this.contentPanel.add((Component)this.listScroll, "Center");
        this.jPanel1.setBackground(new Color(64, 64, 64));
        this.jPanel1.setBorder(new SoftBevelBorder(0));
        this.jPanel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 42));
        this.jPanel1.setMinimumSize(new Dimension(59, 42));
        this.jPanel1.setPreferredSize(new Dimension(59, 42));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.chkSelection.setBackground(new Color(64, 64, 64));
        this.chkSelection.setToolTipText(NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.chkSelection.toolTipText"));
        this.chkSelection.setMargin(new Insets(8, 8, 8, 8));
        this.chkSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FormListPanel.this.chkSelectionItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.chkSelection);
        this.panelContent.setBackground(new Color(64, 64, 64));
        this.panelContent.setLayout(new BoxLayout(this.panelContent, 3));
        this.panelLine1.setBackground(new Color(64, 64, 64));
        this.panelLine1.setLayout(new BoxLayout(this.panelLine1, 2));
        this.lblTitle.setFont(new Font("Tahoma", 1, 12));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.lblTitle.text"));
        this.lblTitle.setMaximumSize(new Dimension(999, 999));
        this.panelLine1.add(this.lblTitle);
        this.lblAlias.setFont(new Font("Tahoma", 0, 10));
        this.lblAlias.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblAlias, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.lblAlias.text"));
        this.panelLine1.add(this.lblAlias);
        this.panelContent.add(this.panelLine1);
        this.panelLine2.setBackground(new Color(64, 64, 64));
        this.panelLine2.setLayout(new BoxLayout(this.panelLine2, 2));
        this.lblHistory.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.lblHistory, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.lblHistory.text"));
        this.lblHistory.setMaximumSize(new Dimension(999, 999));
        this.panelLine2.add(this.lblHistory);
        this.panelContent.add(this.panelLine2);
        this.jPanel1.add(this.panelContent);
        this.contentPanel.add((Component)this.jPanel1, "First");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.contentPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.btnAdd.setFont(THEMIS.fontButton);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnAdd.text"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnAdd.toolTipText"));
        this.btnAdd.setBorder(new SoftBevelBorder(0));
        this.btnAdd.setMaximumSize(null);
        this.btnAdd.setMinimumSize(null);
        this.btnAdd.setPreferredSize(null);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormListPanel.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.btnAdd, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.setMinimumSize(null);
        this.btnEdit.setPreferredSize(null);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormListPanel.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.btnEdit, gridBagConstraints);
        this.btnCopy.setFont(THEMIS.fontButton);
        this.btnCopy.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopy, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnCopy.text"));
        this.btnCopy.setToolTipText(NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnCopy.toolTipText"));
        this.btnCopy.setBorder(new SoftBevelBorder(0));
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormListPanel.this.btnCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.btnCopy, gridBagConstraints);
        this.btnDelete.setFont(THEMIS.fontButton);
        this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelete, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnDelete.text"));
        this.btnDelete.setToolTipText(NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnDelete.toolTipText"));
        this.btnDelete.setBorder(new SoftBevelBorder(0));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormListPanel.this.btnDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.btnDelete, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.btnPdf.setFont(THEMIS.fontButton);
        this.btnPdf.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/pdfreport24.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPdf, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnPdf.text"));
        this.btnPdf.setToolTipText(NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnPdf.toolTipText"));
        this.btnPdf.setBorder(new SoftBevelBorder(0));
        this.btnPdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormListPanel.this.btnPdfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.btnPdf, gridBagConstraints);
        this.btnUserAction.setFont(THEMIS.fontButton);
        this.btnUserAction.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUserAction, (String)NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnUserAction.text"));
        this.btnUserAction.setToolTipText(NbBundle.getMessage(FormListPanel.class, (String)"FormListPanel.btnUserAction.toolTipText"));
        this.btnUserAction.setBorder(new SoftBevelBorder(0));
        this.btnUserAction.setDisabledIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options_disabled24.gif")));
        this.btnUserAction.setMaximumSize(null);
        this.btnUserAction.setMinimumSize(null);
        this.btnUserAction.setPreferredSize(null);
        this.btnUserAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FormListPanel.this.btnUserActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonPanel.add((Component)this.btnUserAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.buttonPanel, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, 386, Short.MAX_VALUE));
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        Dialogs.getInstance().showInfoDialog("Noch nicht implementiert");
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        Optional<FormListItem> item = this.items.stream().filter(i -> i.isSelected()).findFirst();
        if (item.isPresent()) {
            CmsFormular form = item.get().getForm();
            this.editForm(form);
        }
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        for (FormListItem item : this.items) {
            if (!item.isSelected()) continue;
            CmsFormular f = (CmsFormular)this.project.loadElement(item.getForm().getId(), this.project.getUser());
            f = (CmsFormular)f.copy();
            f.removeHistories();
            f.save();
        }
        this.initialize();
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        for (FormListItem item : this.items) {
            if (!item.isSelected() || !this.app.getDialog().showConfirmDialog("Formular '" + item.getName() + "' l\u00f6schen?")) continue;
            CmsElement.remove((CmsApplication)this.project, (long)item.getForm().getId(), (CmsUser)this.project.getUser());
        }
        this.initialize();
    }

    private void btnPdfActionPerformed(ActionEvent evt) {
        this.saveAsPdf();
    }

    private void chkSelectionItemStateChanged(ItemEvent evt) {
        this.ignoreItemClick = true;
        for (FormListItem item : this.items) {
            item.setSelectCheckbox(this.chkSelection.isSelected());
        }
        this.ignoreItemClick = false;
        this.updateActions();
    }

    private void btnUserActionActionPerformed(ActionEvent evt) {
        this.showActionMenu();
    }

    private void fldSearchFocusLost(FocusEvent evt) {
        this.updateFormsList();
    }

    private void fldSearchActionPerformed(ActionEvent evt) {
        this.updateFormsList();
    }

    private void btnSearchLocFreeTextActionPerformed(ActionEvent evt) {
        this.updateFormsList();
    }

    private void btnClearLocFreeTextActionPerformed(ActionEvent evt) {
        this.fldSearch.setText("");
        this.updateFormsList();
    }
}

