/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.image;

import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.image.ImageCorrectionResult;
import at.grid.util.Util;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ImageCorrection {
    HashMap<String, String> parameters = new HashMap();
    String verificationOutput = null;

    public void setParameter(String key, double val) {
        this.parameters.put(key, Double.toString(val));
    }

    public String getParameter(String key, String defaultValue) {
        return this.parameters.getOrDefault(key, defaultValue);
    }

    public double getParameterAsDouble(String key, double defaultValue) {
        String s = this.parameters.getOrDefault(key, Double.toString(defaultValue));
        return Util.parseDouble((String)s, (double)defaultValue);
    }

    public int getParameterAsInt(String key, int defaultValue) {
        String s = this.parameters.getOrDefault(key, Integer.toString(defaultValue));
        return Util.parseInt((String)s, (int)defaultValue);
    }

    public ImageCorrectionResult apply(BufferedImage bi, ArrayList<SimpleGeometry> geoms) {
        if (this.verifyParameters() && bi != null) {
            return this.applyToImage(bi, geoms);
        }
        return null;
    }

    public String getVerificationOutput() {
        return this.verificationOutput;
    }

    protected abstract boolean verifyParameters();

    protected abstract ImageCorrectionResult applyToImage(BufferedImage var1, ArrayList<SimpleGeometry> var2);

    public abstract SimpleGeometry reverseDrawing(BufferedImage var1, SimpleGeometry var2);

    protected abstract ImageCorrection getClone();
}

