/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.image;

import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.image.ImageCorrection;
import at.grid.themis.application.image.ImageCorrectionResult;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class ImageCrop
extends ImageCorrection {
    public static final String UPPERLEFT_X = "upperleftx";
    public static final String UPPERLEFT_Y = "upperlefty";
    public static final String LOWERRIGHT_X = "lowerrightx";
    public static final String LOWERRIGHT_Y = "lowerrighty";

    @Override
    public ImageCorrectionResult applyToImage(BufferedImage bi, ArrayList<SimpleGeometry> geoms) {
        int height0 = bi.getHeight();
        int width0 = bi.getWidth();
        int ulx = this.getParameterAsInt(UPPERLEFT_X, bi.getWidth());
        int uly = this.getParameterAsInt(UPPERLEFT_Y, bi.getHeight());
        int lrx = this.getParameterAsInt(LOWERRIGHT_X, 0);
        int lry = this.getParameterAsInt(LOWERRIGHT_Y, 0);
        int height = Math.abs(uly - lry);
        int width = Math.abs(ulx - lrx);
        BufferedImage image = bi.getSubimage(this.getParameterAsInt(LOWERRIGHT_X, 0), this.getParameterAsInt(LOWERRIGHT_Y, 0), width, height);
        ArrayList<SimpleGeometry> correctedDrawings = new ArrayList<SimpleGeometry>();
        for (SimpleGeometry geom : geoms) {
            SimpleGeometry geomCorr = new SimpleGeometry(geom, true);
            for (Point p : geomCorr.getPoints()) {
                double oldx = p.getX();
                double oldy = p.getY();
                p.setX(oldx - (double)ulx);
                p.setY(oldy - (double)lry);
            }
            correctedDrawings.add(geomCorr);
        }
        return new ImageCorrectionResult(image, geoms);
    }

    @Override
    public SimpleGeometry reverseDrawing(BufferedImage bi, SimpleGeometry geom) {
        int height0 = bi.getHeight();
        int width0 = bi.getWidth();
        int ulx = this.getParameterAsInt(UPPERLEFT_X, bi.getWidth());
        int uly = this.getParameterAsInt(UPPERLEFT_Y, bi.getHeight());
        int lrx = this.getParameterAsInt(LOWERRIGHT_X, 0);
        int lry = this.getParameterAsInt(LOWERRIGHT_Y, 0);
        SimpleGeometry geomCorr = new SimpleGeometry(geom, true);
        for (Point p : geomCorr.getPoints()) {
            double oldx = p.getX();
            double oldy = p.getY();
            p.setX(oldx + (double)ulx);
            p.setY(oldy + (double)lry);
        }
        return geomCorr;
    }

    @Override
    protected boolean verifyParameters() {
        return this.parameters.get(UPPERLEFT_X) != null && this.parameters.get(UPPERLEFT_Y) != null && this.parameters.get(LOWERRIGHT_X) != null && this.parameters.get(LOWERRIGHT_Y) != null;
    }

    public String toString() {
        return "ImageCorrection: crop " + (String)this.parameters.get(UPPERLEFT_X) + " / " + (String)this.parameters.get(UPPERLEFT_Y) + " -> " + (String)this.parameters.get(LOWERRIGHT_X) + " / " + (String)this.parameters.get(LOWERRIGHT_Y);
    }

    @Override
    protected ImageCorrection getClone() {
        ImageCrop c = new ImageCrop();
        for (String p : this.parameters.keySet()) {
            c.setParameter(p, Double.parseDouble((String)this.parameters.get(p)));
        }
        return c;
    }
}

