/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.image;

import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.image.ImageCorrection;
import at.grid.themis.application.image.ImageCorrectionResult;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.util.Util;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class ImageReference {
    long idelement = -1L;
    CmsElement element = null;
    String imageInfo = "";
    String description = "";
    UploadItem uploadItem = null;
    String uploadItemComment = "";
    long uploadItemDetail = 0L;
    File imageFile = null;
    Dimension imageDim = null;
    ArrayList<SimpleGeometry> drawings = new ArrayList();
    BufferedImage bi = null;
    boolean changed = false;

    public ImageReference(CmsElement ele, UploadItem item) {
        this(ele, item.getFile(), item.getFileComment(), item.getUploadDetail(), item.getFileInfo(), item.getIdelement());
        this.setUploadItem(item);
    }

    public ImageReference(ImageReference ref) {
        this.idelement = ref.idelement;
        if (ref.imageInfo != null) {
            this.imageInfo = new String(ref.imageInfo);
        }
        if (ref.description != null) {
            this.description = new String(ref.description);
        }
        this.uploadItem = ref.uploadItem;
        if (ref.uploadItemComment != null) {
            this.uploadItemComment = new String(ref.uploadItemComment);
        }
        this.uploadItemDetail = ref.uploadItemDetail;
        this.imageFile = ref.imageFile;
        this.imageDim = ref.imageDim;
        this.bi = ref.bi;
        if (ref.drawings != null) {
            for (SimpleGeometry geom : ref.drawings) {
                this.drawings.add(new SimpleGeometry(geom, true));
            }
        }
    }

    public ImageReference(CmsElement ele, File imageFile, String imageComment, long cat, String imageInfo, long idelement) {
        this.imageFile = imageFile;
        this.imageInfo = imageInfo;
        this.idelement = idelement;
        this.uploadItemComment = imageComment;
        this.element = ele;
    }

    private void loadDrawings() {
        this.drawings.clear();
        if (this.uploadItem != null) {
            long uploadid = this.getUploadItem().getId();
            this.drawings.addAll(ThemisApplication.getInstance().getProject().getDrawings(uploadid));
        }
    }

    public void addNewDrawings(ArrayList<SimpleGeometry> newGeoms) {
        ArrayList<Long> geomIds = new ArrayList<Long>();
        for (SimpleGeometry geom : this.getDrawings()) {
            geomIds.add(geom.getId());
        }
        for (SimpleGeometry geom : newGeoms) {
            if (geomIds.contains(geom.getId())) continue;
            this.drawings.add(geom);
        }
        this.changed = true;
    }

    public long getLastGeometryId() {
        if (this.drawings.isEmpty()) {
            return -1L;
        }
        ArrayList<SimpleGeometry> ds = this.getDrawings();
        return ds.get(ds.size() - 1).getId();
    }

    public void clearDrawings() {
        this.drawings.clear();
        this.changed = true;
    }

    public ArrayList<SimpleGeometry> getDrawings() {
        return this.drawings;
    }

    public void removeDrawing(long id) {
        SimpleGeometry toBeRemoved = null;
        for (SimpleGeometry geom : this.getDrawings()) {
            if (geom.getId() != id) continue;
            toBeRemoved = geom;
        }
        if (toBeRemoved != null) {
            this.drawings.remove(toBeRemoved);
        }
        this.changed = true;
    }

    public void applyImageCorrection(ImageCorrection corr) {
        if (this.bi == null) {
            this.loadImage();
        }
        ImageCorrectionResult result = corr.apply(this.bi, this.getDrawings());
        this.bi = result.bi;
        this.drawings = result.drawings;
        this.changed = true;
    }

    public void save() {
        UploadItem elementItem = null;
        if (this.element != null) {
            UploadAttribute att;
            Iterator iterator = this.element.getUploadAttributes().iterator();
            while (iterator.hasNext() && (elementItem = (att = (UploadAttribute)iterator.next()).getUploadItemById(this.uploadItem.getId())) == null) {
            }
        }
        if (elementItem == null) {
            return;
        }
        ThemisApplication.getInstance().getProject().getLogger().fine("Saving image '" + this.imageFile.getName() + "' with " + this.drawings.size() + " drawings...");
        try {
            if (this.bi != null) {
                ImageIO.write((RenderedImage)this.bi, "jpg", this.imageFile);
            }
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog("error.image-file-write", ex);
        }
        int count = 0;
        if (this.uploadItem != null) {
            for (SimpleGeometry geom : this.drawings) {
                String wkt = geom.toWKT();
                count = ThemisApplication.getInstance().getProject().getDatastorage().executeUpdate("UPDATE tdtaDrawing SET geometry=" + Util.toSqlString((String)wkt) + " WHERE idFileUpload = " + this.uploadItem.getId() + " AND idgeometry=" + geom.getId(), true);
                if (count != 0) continue;
                count = ThemisApplication.getInstance().getProject().getDatastorage().executeUpdate("INSERT INTO tdtaDrawing (idFileUpload, idGeometry, geometry, geometrytype, color, linewidth) VALUES (" + this.uploadItem.getId() + "," + geom.getId() + ",'" + geom.toWKT() + "'," + geom.getType() + "," + geom.getDisplay().getColor().getRGB() + "," + geom.getDisplay().getLinewidth() + ")", true);
            }
            count = ThemisApplication.getInstance().getProject().getDatastorage().updateUploadItemInfos(this.getUploadItem().getId(), this.getUploadItemComment(), this.getUploaditemDetail());
            elementItem.setFileComment(this.getUploadItemComment());
            elementItem.setUploadDetail(this.getUploaditemDetail());
        }
        this.changed = false;
    }

    public ImageReference setDescription(String desc) {
        this.changed = this.description == null ? desc != null : !this.description.endsWith(desc);
        this.description = desc;
        return this;
    }

    protected void loadImage() {
        try {
            this.bi = ImageIO.read(this.imageFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public long getIdElement() {
        return this.idelement;
    }

    public String getImageInfo() {
        return this.imageInfo;
    }

    public void setImageInfo(String s) {
        this.imageInfo = s;
    }

    public ImageReference setUploadItem(UploadItem item) {
        this.uploadItem = item;
        if (item != null) {
            this.uploadItemComment = item.getFileComment();
            this.uploadItemDetail = item.getUploadDetail();
        }
        this.loadDrawings();
        return this;
    }

    public String getUploadItemComment() {
        if (this.hasUploadItem()) {
            return this.uploadItemComment;
        }
        return null;
    }

    public void setUploadItemComment(String s) {
        if (this.hasUploadItem()) {
            this.changed = this.uploadItemComment == null ? s != null : this.changed || !this.uploadItemComment.equals(s);
            this.uploadItemComment = s;
        }
    }

    public long getUploaditemDetail() {
        if (this.hasUploadItem()) {
            return this.uploadItemDetail;
        }
        return -1L;
    }

    public void setUploadItemDetailNoChange(long id) {
        this.uploadItemDetail = id;
    }

    public void setUploadItemDetail(long id) {
        if (this.hasUploadItem()) {
            boolean chanedId = this.uploadItemDetail != id;
            this.changed = this.changed || this.uploadItemDetail != id;
            this.uploadItemDetail = id;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasUploadItem() {
        return this.uploadItem != null;
    }

    public UploadItem getUploadItem() {
        return this.uploadItem;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void reset() {
        this.loadImage();
        this.loadDrawings();
    }

    public BufferedImage getImage() {
        if (this.bi == null) {
            this.loadImage();
        }
        return this.bi;
    }
}

