/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.image;

import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.image.ImageCorrection;
import at.grid.themis.application.image.ImageCorrectionResult;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class ImageRotateLeft
extends ImageCorrection {
    @Override
    protected ImageCorrectionResult applyToImage(BufferedImage bi, ArrayList<SimpleGeometry> geoms) {
        int height = bi.getHeight();
        int width = bi.getWidth();
        BufferedImage image = new BufferedImage(height, width, bi.getType());
        AffineTransform at = new AffineTransform();
        at.translate(height / 2, width / 2);
        at.rotate(Math.toRadians(-90.0));
        at.translate(-width / 2, -height / 2);
        Graphics2D g2 = image.createGraphics();
        g2.drawImage(bi, at, null);
        g2.dispose();
        ArrayList<SimpleGeometry> correctedDrawings = new ArrayList<SimpleGeometry>();
        for (SimpleGeometry geom : geoms) {
            SimpleGeometry geomCorr = new SimpleGeometry(geom, true);
            for (Point p : geomCorr.getPoints()) {
                double oldx = p.getX();
                double oldy = p.getY();
                p.setX(oldy);
                p.setY((double)width - oldx);
            }
            correctedDrawings.add(geomCorr);
        }
        return new ImageCorrectionResult(image, correctedDrawings);
    }

    @Override
    public SimpleGeometry reverseDrawing(BufferedImage bi, SimpleGeometry geom) {
        int height = bi.getHeight();
        int width = bi.getWidth();
        SimpleGeometry geomCorr = new SimpleGeometry(geom, true);
        for (Point p : geomCorr.getPoints()) {
            double oldx = p.getX();
            double oldy = p.getY();
            p.setX((double)height - oldy);
            p.setY(oldx);
        }
        return geomCorr;
    }

    @Override
    protected boolean verifyParameters() {
        return true;
    }

    public String toString() {
        return "ImageCorrection: rotate left";
    }

    @Override
    protected ImageCorrection getClone() {
        return new ImageRotateLeft();
    }
}

