/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer;

import at.grid.cms.content.KeytableRecord;
import at.grid.cms.storage.DataRecord;
import at.grid.gui.Dialogs;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.importer.ThemisCsvExporter;
import at.grid.themis.ontology.importer.ThemisReaderXlsx;
import at.grid.themis.ontology.importer.ThemisXlsExporter;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ExportWizard
extends JPanel {
    public static String DIALOG_CODE = "exportwizard";
    public static final int DIALOG_WIDTH = 800;
    public static final int DIALOG_HEIGHT = 800;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/io/importer/Bundle");
    ThemisSettings settings = this.app.getSettings();
    private File exportFile;
    private File exportFileFolder;
    private File templateFile;
    private ExportFormat format;
    ArrayList<String> fieldsUsed = new ArrayList();
    Properties placeholderMapping = new Properties();
    Placeholder ph = new Placeholder(new CmsReport());
    ArrayList<String> placeholders;
    private JButton btnAddDisplay;
    private JButton btnClose;
    private JButton btnDisplayDown;
    private JButton btnDisplayUp;
    private JButton btnImport;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnRemoveDisplay;
    private JButton btnSelectExportFile;
    private JButton btnSelectTemplateFile;
    private JCheckBox chkCreateObservation;
    private JCheckBox chkPreviousMethod;
    private JLabel empty;
    private JLabel empty1;
    private JComboBox<KeytableRecord> fldCreateObservationType;
    private JTextField fldExportFile;
    private JTextField fldExportFileFolder;
    private JTextField fldRowData;
    private JComboBox<String> fldSheet;
    private JTextField fldTemplateFile;
    private JTextField fldTemplateFileFolder;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel62;
    private JLabel jLabel63;
    private JLabel jLabel64;
    private JLabel jLabel9;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane6;
    private JLabel lblImport;
    private JLabel lblSheet;
    private JList listTopic;
    private JList<String> lstFieldsAvailable;
    private JList<String> lstFieldsUsed;
    private JPanel panelAssign;
    private JPanel panelButtons;
    private JPanel panelButtons1;
    private JPanel panelEditor;
    private JPanel panelFile;
    private JPanel panelFileSelect;
    private JPanel panelFileSelect1;
    private JPanel panelFileXlsx;
    private JPanel panelOptions;

    public ExportWizard() {
        this.initComponents();
        int wizardNo = 1;
        DefaultListModel topicModel = (DefaultListModel)this.listTopic.getModel();
        topicModel.addElement(new ConfigurationTopic("cardFile", wizardNo++, this.bundle.getString("ImportWizard.card.file")));
        topicModel.addElement(new ConfigurationTopic("cardAssign", wizardNo++, this.bundle.getString("ImportWizard.card.assign")));
        topicModel.addElement(new ConfigurationTopic("cardOptions", wizardNo++, this.bundle.getString("ImportWizard.card.options")));
        this.listTopic.setSelectedIndex(0);
        this.listTopic.setCellRenderer(new SimpleTextRenderer());
        try {
            this.placeholderMapping = Placeholder.loadMapping((String)"placeholder_mapping.properties");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.populate();
        this.panelFileXlsx.setVisible(false);
        new DropTarget(this.fldTemplateFile, new ThemisDropTargetListener(false, false, new String[]{"xlsx"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ExportWizard.this.setTemplateFile(f);
            }
        });
    }

    private void populate() {
        this.exportFileFolder = this.app.getSettings().getExportFolder().getValue(true);
        if (this.exportFileFolder != null) {
            this.fldExportFileFolder.setText(this.exportFileFolder.getAbsolutePath());
        }
        this.templateFile = this.app.getSettings().getExportTemplateFile().getValue(true);
        if (this.templateFile != null) {
            this.fldTemplateFile.setText(this.templateFile.getName());
            this.fldTemplateFileFolder.setText(this.templateFile.getParentFile().getAbsolutePath());
        }
        this.fldRowData.setText(this.app.getSettings().getExportRowData());
        this.updatePlaceholderList();
        this.updateAttributeLists();
    }

    private void updatePlaceholderList() {
        ArrayList<String> ignore = new ArrayList<String>();
        ignore.add("obs.histories-dates");
        ignore.add("obs.histories-count");
        ignore.add("obs.observation-creationdate");
        ignore.add("obs.history-eventdate");
        ignore.add("obs.history-event");
        ignore.add("obs.creator");
        ignore.add("obs.uuid");
        ignore.add("obs.location-counter-grouping");
        ArrayList<String> phs = new ArrayList<String>();
        this.placeholders = new ArrayList();
        phs.addAll(this.placeholderMapping.stringPropertyNames());
        Collections.sort(phs);
        ((DefaultListModel)this.lstFieldsAvailable.getModel()).removeAllElements();
        for (String k : phs) {
            String v = this.placeholderMapping.getProperty(k);
            if (v == null || v.indexOf("dummy") >= 0 || "obs.observation-risk".equals(v) || "obs.rowheight".equals(v) || "obs.repeat".equals(v) || v.startsWith("obs.head1") || v.startsWith("obs.foot1") || v.startsWith("obs.pagebreak") || v.startsWith("obs.image") || v.startsWith("obs.location-image") || v.startsWith("obs.location-document") || v.startsWith("obs.location-dim") || v.startsWith("obs.location-locationgroup-") || v.startsWith("obs.location-plan-") || v.startsWith("obs.location-plansnippet") || !v.startsWith("loc.") && !v.startsWith("obs.") || ignore.contains(v)) continue;
            this.placeholders.add(k);
        }
    }

    private void saveSettings() {
    }

    private void updateAttributeLists() {
        ((DefaultListModel)this.lstFieldsAvailable.getModel()).clear();
        ((DefaultListModel)this.lstFieldsUsed.getModel()).clear();
        for (String ph : this.placeholders) {
            if (this.fieldsUsed.contains(ph)) continue;
            ((DefaultListModel)this.lstFieldsAvailable.getModel()).addElement(ph);
        }
        for (String ph : this.fieldsUsed) {
            ((DefaultListModel)this.lstFieldsUsed.getModel()).addElement(ph);
        }
        this.panelAssign.revalidate();
    }

    private void setExportFile(File f) {
        if (f == null) {
            return;
        }
        if (f.isDirectory()) {
            Dialogs.showErrorDialog((String)"Es wurde ein Ordner ausgew\u00e4hlt. Bitte w\u00e4hlen Sie eine Datei.");
            return;
        }
        if (f.isFile() && !Dialogs.showConfirmDialog((String)"Die Datei existiert bereits - \u00fcberschreiben?")) {
            return;
        }
        this.exportFile = f;
        String fn = f.getName();
        if (fn.toLowerCase().endsWith(".xlsx")) {
            this.panelFileXlsx.setVisible(true);
            this.format = ExportFormat.XLSX;
        } else {
            this.panelFileXlsx.setVisible(false);
            this.format = ExportFormat.CSV;
        }
        this.fldExportFile.setText(fn);
        this.fldExportFileFolder.setText(f.getParentFile().getAbsolutePath());
    }

    private void setTemplateFile(File f) {
        this.templateFile = f;
        int rowData = Util.parseInt((String)this.fldRowData.getText(), (int)2);
        ThemisReaderXlsx r = new ThemisReaderXlsx(0, rowData);
        this.fldSheet.removeAllItems();
        try {
            ArrayList names = r.getSheetNames(f);
            for (String n : names) {
                this.fldSheet.addItem(n);
            }
            if (!names.isEmpty()) {
                this.fldSheet.setSelectedIndex(0);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fldTemplateFile.setText(f.getName());
        this.fldTemplateFileFolder.setText(f.getParentFile().getAbsolutePath());
    }

    private boolean runExport() {
        if (this.exportFile == null) {
            Dialogs.showErrorDialog((String)"Es ist keine Ausgabedatei defineirt");
            return false;
        }
        if (this.fieldsUsed.isEmpty()) {
            Dialogs.showErrorDialog((String)"Es sind keine Attribute f\u00fcr die Ausgabe definiert");
            return false;
        }
        boolean withHeader = true;
        Object exporter = this.format == ExportFormat.XLSX ? new ThemisXlsExporter() : new ThemisCsvExporter();
        if (this.templateFile != null) {
            withHeader = false;
        }
        String sort = null;
        for (String ta : this.fieldsUsed) {
            exporter.addHeader(ta);
        }
        List recs = this.app.getFilter().getFilteredObservations(sort, null);
        for (DataRecord rec : recs) {
            Properties props = new Properties();
            for (String ta : this.fieldsUsed) {
                props.setProperty(ta, this.ph.getPlaceholderContent(ta, rec));
            }
            exporter.addData(props);
        }
        exporter.runExport(this.exportFile);
        return true;
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.listTopic = new JList();
        this.panelEditor = new JPanel();
        this.panelFile = new JPanel();
        this.jLabel23 = new JLabel();
        this.panelFileSelect = new JPanel();
        this.jLabel3 = new JLabel();
        this.fldExportFileFolder = new JTextField();
        this.jLabel4 = new JLabel();
        this.fldExportFile = new JTextField();
        this.btnSelectExportFile = new JButton();
        this.jLabel24 = new JLabel();
        this.panelFileSelect1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.fldTemplateFileFolder = new JTextField();
        this.jLabel9 = new JLabel();
        this.fldTemplateFile = new JTextField();
        this.btnSelectTemplateFile = new JButton();
        this.jLabel25 = new JLabel();
        this.panelFileXlsx = new JPanel();
        this.lblSheet = new JLabel();
        this.fldSheet = new JComboBox();
        this.jLabel62 = new JLabel();
        this.fldRowData = new JTextField();
        this.empty = new JLabel();
        this.panelOptions = new JPanel();
        this.lblImport = new JLabel();
        this.chkCreateObservation = new JCheckBox();
        this.fldCreateObservationType = new JComboBox();
        this.chkPreviousMethod = new JCheckBox();
        this.empty1 = new JLabel();
        this.panelAssign = new JPanel();
        this.jLabel63 = new JLabel();
        this.jLabel64 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lstFieldsAvailable = new JList();
        this.btnAddDisplay = new JButton();
        this.btnRemoveDisplay = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.lstFieldsUsed = new JList();
        this.btnDisplayDown = new JButton();
        this.btnDisplayUp = new JButton();
        this.panelButtons = new JPanel();
        this.btnImport = new JButton();
        this.btnClose = new JButton();
        this.panelButtons1 = new JPanel();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.setMinimumSize(new Dimension(900, 600));
        this.setPreferredSize(new Dimension(900, 600));
        this.setLayout(new GridBagLayout());
        this.jScrollPane3.setHorizontalScrollBar(null);
        this.jScrollPane3.setMaximumSize(null);
        this.jScrollPane3.setMinimumSize(new Dimension(250, 150));
        this.jScrollPane3.setPreferredSize(new Dimension(250, 150));
        this.listTopic.setFont(THEMIS.fontList);
        this.listTopic.setModel(new DefaultListModel());
        this.listTopic.setSelectionMode(0);
        this.listTopic.setPreferredSize(new Dimension(250, 150));
        this.listTopic.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ExportWizard.this.listTopicValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.listTopic);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jScrollPane3, gridBagConstraints);
        this.panelEditor.setPreferredSize(new Dimension(900, 600));
        this.panelEditor.setRequestFocusEnabled(false);
        this.panelEditor.setLayout(new CardLayout(5, 5));
        this.panelFile.setLayout(new GridBagLayout());
        this.jLabel23.setFont(THEMIS.fontSubheading);
        this.jLabel23.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel23.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.jLabel23, gridBagConstraints);
        this.panelFileSelect.setLayout(new GridBagLayout());
        this.jLabel3.setFont(THEMIS.fontLabel);
        this.jLabel3.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect.add((Component)this.jLabel3, gridBagConstraints);
        this.fldExportFileFolder.setEditable(false);
        this.fldExportFileFolder.setFont(THEMIS.fontTextfield);
        this.fldExportFileFolder.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.fldExportFileFolder.text"));
        this.fldExportFileFolder.setMinimumSize(new Dimension(100, 30));
        this.fldExportFileFolder.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.panelFileSelect.add((Component)this.fldExportFileFolder, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        this.jLabel4.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect.add((Component)this.jLabel4, gridBagConstraints);
        this.fldExportFile.setFont(THEMIS.fontTextfield);
        this.fldExportFile.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.fldExportFile.text"));
        this.fldExportFile.setMinimumSize(new Dimension(100, 30));
        this.fldExportFile.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect.add((Component)this.fldExportFile, gridBagConstraints);
        this.btnSelectExportFile.setFont(THEMIS.fontButton);
        this.btnSelectExportFile.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnSelectExportFile.text"));
        this.btnSelectExportFile.setMaximumSize(new Dimension(110, 36));
        this.btnSelectExportFile.setMinimumSize(new Dimension(100, 30));
        this.btnSelectExportFile.setPreferredSize(new Dimension(100, 30));
        this.btnSelectExportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnSelectExportFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.panelFileSelect.add((Component)this.btnSelectExportFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelFile.add((Component)this.panelFileSelect, gridBagConstraints);
        this.jLabel24.setFont(THEMIS.fontSubheading);
        this.jLabel24.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel24.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.jLabel24, gridBagConstraints);
        this.panelFileSelect1.setLayout(new GridBagLayout());
        this.jLabel5.setFont(THEMIS.fontLabel);
        this.jLabel5.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect1.add((Component)this.jLabel5, gridBagConstraints);
        this.fldTemplateFileFolder.setEditable(false);
        this.fldTemplateFileFolder.setFont(THEMIS.fontTextfield);
        this.fldTemplateFileFolder.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.fldTemplateFileFolder.text"));
        this.fldTemplateFileFolder.setMinimumSize(new Dimension(100, 30));
        this.fldTemplateFileFolder.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.panelFileSelect1.add((Component)this.fldTemplateFileFolder, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        this.jLabel9.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect1.add((Component)this.jLabel9, gridBagConstraints);
        this.fldTemplateFile.setFont(THEMIS.fontTextfield);
        this.fldTemplateFile.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.fldTemplateFile.text"));
        this.fldTemplateFile.setMinimumSize(new Dimension(100, 30));
        this.fldTemplateFile.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect1.add((Component)this.fldTemplateFile, gridBagConstraints);
        this.btnSelectTemplateFile.setFont(THEMIS.fontButton);
        this.btnSelectTemplateFile.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnSelectTemplateFile.text"));
        this.btnSelectTemplateFile.setMaximumSize(new Dimension(110, 36));
        this.btnSelectTemplateFile.setMinimumSize(new Dimension(100, 30));
        this.btnSelectTemplateFile.setPreferredSize(new Dimension(100, 30));
        this.btnSelectTemplateFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnSelectTemplateFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.panelFileSelect1.add((Component)this.btnSelectTemplateFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelFile.add((Component)this.panelFileSelect1, gridBagConstraints);
        this.jLabel25.setFont(THEMIS.fontSubheading);
        this.jLabel25.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel25.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.jLabel25, gridBagConstraints);
        this.panelFileXlsx.setLayout(new GridBagLayout());
        this.lblSheet.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.lblSheet.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.lblSheet, gridBagConstraints);
        this.fldSheet.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.fldSheet.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add(this.fldSheet, gridBagConstraints);
        this.jLabel62.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel62.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.jLabel62, gridBagConstraints);
        this.fldRowData.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.fldRowData.text"));
        this.fldRowData.setMinimumSize(new Dimension(150, 30));
        this.fldRowData.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.fldRowData, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelFile.add((Component)this.panelFileXlsx, gridBagConstraints);
        this.empty.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.empty.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelFile.add((Component)this.empty, gridBagConstraints);
        this.panelEditor.add((Component)this.panelFile, "cardFile");
        this.panelOptions.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.panelOptions.setPreferredSize(new Dimension(350, 350));
        this.panelOptions.setLayout(new GridBagLayout());
        this.lblImport.setFont(THEMIS.fontSubheading);
        this.lblImport.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.lblImport.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOptions.add((Component)this.lblImport, gridBagConstraints);
        this.chkCreateObservation.setFont(THEMIS.fontLabel);
        this.chkCreateObservation.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.chkCreateObservation.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOptions.add((Component)this.chkCreateObservation, gridBagConstraints);
        this.fldCreateObservationType.setFont(THEMIS.fontList);
        this.fldCreateObservationType.setModel(new DefaultComboBoxModel());
        this.fldCreateObservationType.setMinimumSize(new Dimension(44, 30));
        this.fldCreateObservationType.setPreferredSize(new Dimension(185, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 25, 5, 5);
        this.panelOptions.add(this.fldCreateObservationType, gridBagConstraints);
        this.chkPreviousMethod.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.chkPreviousMethod.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOptions.add((Component)this.chkPreviousMethod, gridBagConstraints);
        this.empty1.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.empty1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelOptions.add((Component)this.empty1, gridBagConstraints);
        this.panelEditor.add((Component)this.panelOptions, "cardOptions");
        this.panelAssign.setLayout(new GridBagLayout());
        this.jLabel63.setFont(THEMIS.fontLabelBold);
        this.jLabel63.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel63.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel63, gridBagConstraints);
        this.jLabel64.setFont(THEMIS.fontLabelBold);
        this.jLabel64.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.jLabel64.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel64, gridBagConstraints);
        this.lstFieldsAvailable.setFont(THEMIS.fontList);
        this.lstFieldsAvailable.setModel(new DefaultListModel());
        this.jScrollPane2.setViewportView(this.lstFieldsAvailable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jScrollPane2, gridBagConstraints);
        this.btnAddDisplay.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        this.btnAddDisplay.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnAddDisplay.text"));
        this.btnAddDisplay.setBorder(new SoftBevelBorder(0));
        this.btnAddDisplay.setPreferredSize(new Dimension(35, 35));
        this.btnAddDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnAddDisplayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnAddDisplay, gridBagConstraints);
        this.btnRemoveDisplay.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft24.gif")));
        this.btnRemoveDisplay.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnRemoveDisplay.text"));
        this.btnRemoveDisplay.setBorder(new SoftBevelBorder(0));
        this.btnRemoveDisplay.setPreferredSize(new Dimension(35, 35));
        this.btnRemoveDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnRemoveDisplayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnRemoveDisplay, gridBagConstraints);
        this.lstFieldsUsed.setFont(THEMIS.fontList);
        this.lstFieldsUsed.setModel(new DefaultListModel());
        this.jScrollPane6.setViewportView(this.lstFieldsUsed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jScrollPane6, gridBagConstraints);
        this.btnDisplayDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        this.btnDisplayDown.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnDisplayDown.text"));
        this.btnDisplayDown.setBorder(new SoftBevelBorder(0));
        this.btnDisplayDown.setPreferredSize(new Dimension(35, 35));
        this.btnDisplayDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnDisplayDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnDisplayDown, gridBagConstraints);
        this.btnDisplayUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        this.btnDisplayUp.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnDisplayUp.text"));
        this.btnDisplayUp.setBorder(new SoftBevelBorder(0));
        this.btnDisplayUp.setPreferredSize(new Dimension(35, 35));
        this.btnDisplayUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnDisplayUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnDisplayUp, gridBagConstraints);
        this.panelEditor.add((Component)this.panelAssign, "cardAssign");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelEditor, gridBagConstraints);
        this.panelButtons.setMinimumSize(new Dimension(100, 50));
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnImport.setFont(THEMIS.fontButton);
        this.btnImport.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_importCAD24.gif")));
        this.btnImport.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnImport.text"));
        this.btnImport.setBorder(new SoftBevelBorder(0));
        this.btnImport.setMinimumSize(new Dimension(150, 40));
        this.btnImport.setPreferredSize(new Dimension(100, 30));
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnImport, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontButton);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        this.btnClose.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnClose.text"));
        this.btnClose.setBorder(new SoftBevelBorder(0));
        this.btnClose.setMinimumSize(new Dimension(150, 40));
        this.btnClose.setPreferredSize(new Dimension(100, 30));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
        this.panelButtons1.setMinimumSize(new Dimension(100, 50));
        this.panelButtons1.setLayout(new GridBagLayout());
        this.btnPrevious.setFont(THEMIS.fontButton);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft24.gif")));
        this.btnPrevious.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnPrevious.text"));
        this.btnPrevious.setBorder(new SoftBevelBorder(0));
        this.btnPrevious.setMinimumSize(new Dimension(100, 30));
        this.btnPrevious.setPreferredSize(new Dimension(100, 30));
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnPreviousActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelButtons1.add((Component)this.btnPrevious, gridBagConstraints);
        this.btnNext.setFont(THEMIS.fontButton);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        this.btnNext.setText(NbBundle.getMessage(ExportWizard.class, (String)"ExportWizard.btnNext.text"));
        this.btnNext.setBorder(new SoftBevelBorder(0));
        this.btnNext.setHorizontalTextPosition(10);
        this.btnNext.setMinimumSize(new Dimension(100, 30));
        this.btnNext.setPreferredSize(new Dimension(100, 30));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard.this.btnNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelButtons1.add((Component)this.btnNext, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons1, gridBagConstraints);
    }

    private void listTopicValueChanged(ListSelectionEvent evt) {
        this.showWizardPage();
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        int idx = this.listTopic.getSelectedIndex();
        if (idx > 0) {
            this.listTopic.setSelectedIndex(idx - 1);
        }
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        int idx = this.listTopic.getSelectedIndex();
        if (idx < this.listTopic.getModel().getSize() - 1) {
            this.listTopic.setSelectedIndex(idx + 1);
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.saveSettings();
        this.closeDialog(evt);
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.saveSettings();
        this.runExport();
    }

    private void btnSelectExportFileActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.app.getProject().getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.SAVE, this.exportFileFolder, null, new FileNameExtensionFilter(this.app.getProject().getResourceText("dialog.save.export-csv-xls"), "xlsx", "csv", "txt"), null, false).getSelectedFile();
        this.setExportFile(f);
    }

    private void btnSelectTemplateFileActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.app.getProject().getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.SAVE, this.templateFile == null ? null : this.templateFile.getParentFile(), null, new FileNameExtensionFilter(this.app.getProject().getResourceText("dialog.load.export-template.excel"), "xlsx"), null, false).getSelectedFile();
        this.setExportFile(f);
    }

    private void btnAddDisplayActionPerformed(ActionEvent evt) {
        int selIdx = this.lstFieldsAvailable.getSelectedIndex();
        String sel = this.lstFieldsAvailable.getSelectedValue();
        if (sel != null) {
            this.fieldsUsed.add(sel);
            this.updateAttributeLists();
            this.lstFieldsUsed.setSelectedIndex(this.lstFieldsUsed.getModel().getSize() - 1);
            this.lstFieldsAvailable.setSelectedIndex(selIdx >= this.lstFieldsAvailable.getModel().getSize() ? this.lstFieldsAvailable.getModel().getSize() : selIdx);
        }
    }

    private void btnRemoveDisplayActionPerformed(ActionEvent evt) {
        int idx = this.lstFieldsUsed.getSelectedIndex();
        String sel = this.lstFieldsUsed.getSelectedValue();
        if (sel != null) {
            this.fieldsUsed.remove(sel);
            this.updateAttributeLists();
        }
    }

    private void btnDisplayDownActionPerformed(ActionEvent evt) {
        int idx = this.lstFieldsUsed.getSelectedIndex();
        if (idx >= 0 && idx < this.lstFieldsUsed.getModel().getSize() - 1) {
            Collections.swap(this.fieldsUsed, idx, idx + 1);
            this.updateAttributeLists();
            this.lstFieldsUsed.setSelectedIndex(idx + 1);
        }
    }

    private void btnDisplayUpActionPerformed(ActionEvent evt) {
        int idx = this.lstFieldsUsed.getSelectedIndex();
        if (idx > 0) {
            Collections.swap(this.fieldsUsed, idx, idx - 1);
            this.updateAttributeLists();
            this.lstFieldsUsed.setSelectedIndex(idx - 1);
        }
    }

    private void showExportAssistantStep() {
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog("Import", this, true, true);
        THEMIS.applyWindowSizeAndLocation(DIALOG_CODE, dlg, 800, 800);
        dlg.setVisible(true);
    }

    private void closeDialog(ActionEvent evt) {
        JComponent c = (JComponent)evt.getSource();
        Window w = SwingUtilities.getWindowAncestor(c);
        THEMIS.saveWindowSizeAndLocation(DIALOG_CODE, w);
        w.dispose();
    }

    public void getWindowSizeAndLocation() {
        Dimension windowSize = THEMIS.getWindowSize("reportpanel", this.app);
        if (windowSize != null) {
            this.setSize(windowSize);
            this.setPreferredSize(windowSize);
        }
    }

    private void showWizardPage() {
        ConfigurationTopic topic = (ConfigurationTopic)this.listTopic.getSelectedValue();
        if (topic == null) {
            this.listTopic.setSelectedIndex(0);
            return;
        }
        CardLayout cd = (CardLayout)this.panelEditor.getLayout();
        cd.show(this.panelEditor, topic.panelName);
    }

    class ConfigurationTopic {
        int number;
        String displayLabel;
        String panelName;

        public ConfigurationTopic(String panelName, int number, String display) {
            this.displayLabel = display;
            this.panelName = panelName;
            this.number = number;
        }

        public String toString() {
            return (this.number > 0 ? this.number + ". " : "") + this.displayLabel;
        }
    }

    static enum ExportFormat {
        XLSX,
        CSV;

    }
}

