/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer;

import at.grid.cms.storage.DataRecord;
import at.grid.gui.Dialogs;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.importer.ThemisCsvExporter;
import at.grid.themis.ontology.importer.ThemisGenericExporter;
import at.grid.themis.ontology.importer.ThemisReaderXlsx;
import at.grid.themis.ontology.importer.ThemisXlsExporter;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ExportWizard2
extends JPanel {
    public static String DIALOG_CODE = "exportwizard";
    public static final int DIALOG_WIDTH = 800;
    public static final int DIALOG_HEIGHT = 800;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/io/importer/Bundle");
    ThemisSettings settings = this.app.getSettings();
    private File exportFile;
    private File exportFileFolder;
    private File templateFile;
    private ExportFormat format;
    ArrayList<String> fieldsGroup = new ArrayList();
    ArrayList<String> fieldsUsed = new ArrayList();
    Properties groupFunction = new Properties();
    Properties placeholderMapping = new Properties();
    Placeholder ph = new Placeholder(new CmsReport());
    ArrayList<String> placeholders;
    private JButton btnAddToGroup;
    private JButton btnAddToUsed;
    private JButton btnClose;
    private JButton btnGroupDown;
    private JButton btnGroupUp;
    private JButton btnImport;
    private JButton btnRemoveFromGroup;
    private JButton btnRemoveFromUsed;
    private JButton btnSelectExportFile;
    private JButton btnSelectTemplateFile;
    private JButton btnUsedCount;
    private JButton btnUsedDown;
    private JButton btnUsedFirst;
    private JButton btnUsedSum;
    private JButton btnUsedUp;
    private JTextField fldExportFile;
    private JTextField fldExportFileFolder;
    private JTextField fldRowData;
    private JComboBox<String> fldSheet;
    private JTextField fldTemplateFile;
    private JTextField fldTemplateFileFolder;
    private JLabel jLabel1;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel62;
    private JLabel jLabel64;
    private JLabel jLabel66;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane8;
    private JLabel lblSheet;
    private JList<String> lstFieldsAvailable;
    private JList<String> lstFieldsGroup;
    private JList<String> lstFieldsUsed;
    private JPanel panelAssign;
    private JPanel panelButtons;
    private JPanel panelFile;
    private JPanel panelFileSelect;
    private JPanel panelFileXlsx;
    private JPanel panelTemplate;

    public ExportWizard2() {
        this.initComponents();
        try {
            this.placeholderMapping = Placeholder.loadMapping((String)"placeholder_mapping.properties");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.populate();
        this.panelTemplate.setVisible(false);
        this.panelFileXlsx.setVisible(false);
        new DropTarget(this.fldTemplateFile, new ThemisDropTargetListener(false, false, new String[]{"xlsx"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ExportWizard2.this.setTemplateFile(f);
            }
        });
    }

    private void populate() {
        this.exportFileFolder = this.app.getSettings().getExportFolder().getValue(true);
        if (this.exportFileFolder != null) {
            this.fldExportFileFolder.setText(this.exportFileFolder.getAbsolutePath());
        }
        this.templateFile = this.app.getSettings().getExportTemplateFile().getValue(true);
        if (this.templateFile != null) {
            this.fldTemplateFile.setText(this.templateFile.getName());
            this.fldTemplateFileFolder.setText(this.templateFile.getParentFile().getAbsolutePath());
        }
        this.fldRowData.setText(this.app.getSettings().getExportRowData());
        this.fieldsGroup = this.app.getSettings().getExportAttributesGroup();
        this.fieldsUsed = this.app.getSettings().getExportAttributesUsed();
        this.groupFunction = this.app.getSettings().getExportAttributesGroupFunction();
        this.updatePlaceholderList();
        this.updateAttributeLists();
    }

    private void updatePlaceholderList() {
        ArrayList<String> ignore = new ArrayList<String>();
        ignore.add("obs.histories-dates");
        ignore.add("obs.histories-count");
        ignore.add("obs.observation-creationdate");
        ignore.add("obs.history-eventdate");
        ignore.add("obs.history-event");
        ignore.add("obs.creator");
        ignore.add("obs.uuid");
        ignore.add("obs.location-counter-grouping");
        ArrayList<String> phs = new ArrayList<String>();
        this.placeholders = new ArrayList();
        phs.addAll(this.placeholderMapping.stringPropertyNames());
        Collections.sort(phs);
        ((DefaultListModel)this.lstFieldsAvailable.getModel()).removeAllElements();
        for (String k : phs) {
            String v = this.placeholderMapping.getProperty(k);
            if (v == null || v.indexOf("dummy") >= 0 || "obs.observation-risk".equals(v) || "obs.rowheight".equals(v) || "obs.repeat".equals(v) || v.startsWith("obs.head1") || v.startsWith("obs.foot1") || v.startsWith("obs.pagebreak") || v.startsWith("obs.image") || v.startsWith("obs.location-image") || v.startsWith("obs.location-document") || v.startsWith("obs.location-dim") || v.startsWith("obs.location-locationgroup-") || v.startsWith("obs.location-plan-") || v.startsWith("obs.location-plansnippet") || !v.startsWith("loc.") && !v.startsWith("obs.") || ignore.contains(v)) continue;
            this.placeholders.add(k);
        }
    }

    private void saveSettings() {
        this.app.getSettings().setExportAttributes(this.fieldsGroup, this.fieldsUsed, this.groupFunction);
        this.app.getSettings().setExportRowData(this.fldRowData.getText());
        this.app.getSettings().getExportTemplateFile().setValue(this.templateFile);
        if (this.getExportFile() != null) {
            this.app.getSettings().getExportFolder().setValue(this.exportFile.getParentFile());
        }
    }

    private void updateAttributeLists() {
        ((DefaultListModel)this.lstFieldsAvailable.getModel()).clear();
        ((DefaultListModel)this.lstFieldsGroup.getModel()).clear();
        ((DefaultListModel)this.lstFieldsUsed.getModel()).clear();
        boolean withGroups = this.hasGroups();
        if (!withGroups) {
            this.groupFunction.clear();
        }
        for (String ph : this.placeholders) {
            if (this.fieldsGroup.contains(ph) || this.fieldsUsed.contains(ph)) continue;
            ((DefaultListModel)this.lstFieldsAvailable.getModel()).addElement(ph);
        }
        for (String ph : this.fieldsGroup) {
            ((DefaultListModel)this.lstFieldsGroup.getModel()).addElement(ph);
        }
        for (String ph : this.fieldsUsed) {
            String groupInfo;
            String string = groupInfo = withGroups ? "[1] " : "";
            if ("s".equals(this.groupFunction.getProperty(ph))) {
                groupInfo = "[S] ";
            } else if ("n".equals(this.groupFunction.getProperty(ph))) {
                groupInfo = "[n] ";
            }
            ((DefaultListModel)this.lstFieldsUsed.getModel()).addElement(groupInfo + ph);
        }
        this.btnUsedFirst.setEnabled(withGroups);
        this.btnUsedSum.setEnabled(withGroups);
        this.btnUsedCount.setEnabled(withGroups);
        this.panelAssign.revalidate();
    }

    private void setExportFile(File f) {
        if (f == null) {
            return;
        }
        if (f.isDirectory()) {
            Dialogs.showErrorDialog((String)"Es wurde ein Ordner ausgew\u00e4hlt. Bitte w\u00e4hlen Sie eine Datei.");
            return;
        }
        if (f.isFile() && !Dialogs.showConfirmDialog((String)"Die Datei existiert bereits - \u00fcberschreiben?")) {
            return;
        }
        this.exportFile = f;
        this.format = this.getExportFormat();
        String fn = f.getName();
        switch (this.format) {
            default: 
        }
        this.fldExportFile.setText(fn);
        this.fldExportFileFolder.setText(f.getParentFile().getAbsolutePath());
    }

    private File getExportFile() {
        this.exportFile = null;
        String fnFolder = this.fldExportFileFolder.getText();
        String fnFile = this.fldExportFile.getText();
        if (!"".equals(fnFolder) && !"".equals(fnFile)) {
            if (fnFile.endsWith(".xls")) {
                fnFile = fnFile + "x";
                this.fldExportFile.setText(fnFile);
            }
            this.exportFile = new File(fnFolder, fnFile);
        }
        return this.exportFile;
    }

    private ExportFormat getExportFormat() {
        File f = this.getExportFile();
        if (f == null) {
            return ExportFormat.NONE;
        }
        if (f.getName().toLowerCase().endsWith(".xlsx")) {
            return ExportFormat.XLSX;
        }
        return ExportFormat.CSV;
    }

    private void setTemplateFile(File f) {
        this.templateFile = f;
        int rowData = Util.parseInt((String)this.fldRowData.getText(), (int)2);
        ThemisReaderXlsx r = new ThemisReaderXlsx(0, rowData);
        this.fldSheet.removeAllItems();
        try {
            ArrayList names = r.getSheetNames(f);
            for (String n : names) {
                this.fldSheet.addItem(n);
            }
            if (!names.isEmpty()) {
                this.fldSheet.setSelectedIndex(0);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fldTemplateFile.setText(f.getName());
        this.fldTemplateFileFolder.setText(f.getParentFile().getAbsolutePath());
    }

    private boolean runExport() {
        String sql;
        ThemisCsvExporter exporter;
        File f = this.getExportFile();
        if (f == null) {
            Dialogs.showErrorDialog((String)"Es ist keine Ausgabedatei defineirt");
            return false;
        }
        if (this.fieldsUsed.isEmpty() && this.fieldsGroup.isEmpty()) {
            Dialogs.showErrorDialog((String)"Es sind keine Attribute f\u00fcr die Ausgabe definiert");
            return false;
        }
        if (this.getExportFormat() == ExportFormat.NONE) {
            Dialogs.showErrorDialog((String)"Es ist kein Ausgabeformat definiert");
            return false;
        }
        boolean withHeader = true;
        switch (this.getExportFormat()) {
            case CSV: {
                exporter = new ThemisCsvExporter();
                break;
            }
            case XLSX: {
                exporter = new ThemisXlsExporter();
                break;
            }
            default: {
                exporter = null;
            }
        }
        if (exporter == null) {
            Dialogs.showErrorDialog((String)"Es konnte kein Export durchgef\u00fchrt werden, es ist kein Ausgabeformat definiert.");
            return false;
        }
        if (this.hasGroups()) {
            exporter.setGroupFunction(this.groupFunction);
        }
        if (this.templateFile != null) {
            withHeader = false;
        }
        final StringBuilder sort = new StringBuilder();
        int sortcount = 0;
        for (String ta : this.fieldsGroup) {
            if (sortcount > 3) break;
            sql = this.ph.getPlaceholderSql(ta);
            if (sql == null) continue;
            if (sort.length() > 0) {
                sort.append(",");
            }
            sort.append(sql);
            ++sortcount;
        }
        for (String ta : this.fieldsUsed) {
            if (sortcount > 3) break;
            sql = this.ph.getPlaceholderSql(ta);
            if (sql == null) continue;
            if (sort.length() > 0) {
                sort.append(",");
            }
            sort.append(sql);
            ++sortcount;
        }
        for (String ta : this.fieldsGroup) {
            exporter.addHeader(ta, this.ph.getPlaceholderLabel(ta));
        }
        for (String ta : this.fieldsUsed) {
            exporter.addHeader(ta, this.ph.getPlaceholderLabel(ta));
        }
        BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable((ThemisGenericExporter)exporter){
            final /* synthetic */ ThemisGenericExporter val$exporter;
            {
                this.val$exporter = themisGenericExporter;
            }

            @Override
            public void run() {
                List recs = ExportWizard2.this.app.getFilter().getFilteredObservations(sort.toString(), null);
                if (ExportWizard2.this.hasGroups()) {
                    ExportWizard2.this.prepareDataWithGroups(recs, this.val$exporter);
                } else {
                    ExportWizard2.this.prepareDataWithoutGroups(recs, this.val$exporter);
                }
                this.val$exporter.runExport(ExportWizard2.this.exportFile);
                THEMIS.showFileResultDialog(ExportWizard2.this.exportFile);
            }
        }, (String)"Export");
        return true;
    }

    private void prepareDataWithoutGroups(List<DataRecord> recs, ThemisGenericExporter exporter) {
        for (DataRecord rec : recs) {
            Properties props = new Properties();
            for (String ta : this.fieldsGroup) {
                props.setProperty(ta, this.ph.getPlaceholderContent(ta, rec));
            }
            for (String ta : this.fieldsUsed) {
                props.setProperty(ta, this.ph.getPlaceholderContent(ta, rec));
            }
            exporter.addData(props);
        }
    }

    private void prepareDataWithGroups(List<DataRecord> recs, ThemisGenericExporter exporter) {
        ArrayList<String> groupnames = new ArrayList<String>();
        HashMap<String, Properties> data = new HashMap<String, Properties>();
        for (DataRecord rec : recs) {
            boolean newGroup = false;
            String groupname = "";
            for (String ta : this.fieldsGroup) {
                String v = this.ph.getPlaceholderContent(ta, rec);
                groupname = groupname + v;
            }
            Properties groupProps = (Properties)data.get(groupname);
            if (groupProps == null) {
                newGroup = true;
                groupProps = new Properties();
                groupnames.add(groupname);
            }
            for (String ta : this.fieldsGroup) {
                groupProps.setProperty(ta, this.ph.getPlaceholderContent(ta, rec));
            }
            block11: for (String ta : this.fieldsUsed) {
                String groupFunction = this.groupFunction.getProperty(ta, "1");
                switch (groupFunction.toLowerCase()) {
                    case "s": {
                        double val = Util.parseDouble((String)groupProps.getProperty(ta), (double)0.0);
                        groupProps.setProperty(ta, Double.toString(val += Util.parseDouble((String)this.ph.getPlaceholderContent(ta, rec), (double)0.0)));
                        continue block11;
                    }
                    case "n": {
                        int count = Util.parseInt((String)groupProps.getProperty(ta), (int)0) + 1;
                        groupProps.setProperty(ta, Integer.toString(count));
                        continue block11;
                    }
                }
                if (!newGroup) continue;
                groupProps.setProperty(ta, this.ph.getPlaceholderContent(ta, rec));
            }
            data.put(groupname, groupProps);
        }
        for (String groupname : groupnames) {
            exporter.addData((Properties)data.get(groupname));
        }
    }

    private boolean hasGroups() {
        return !this.fieldsGroup.isEmpty();
    }

    private void addToGroup() {
        this.addToList(this.lstFieldsGroup, this.fieldsGroup, true);
    }

    private void addToOutput() {
        this.addToList(this.lstFieldsUsed, this.fieldsUsed, false);
    }

    private void addToList(JList lst, ArrayList liste, boolean group) {
        int selIdx = this.lstFieldsAvailable.getSelectedIndex();
        String sel = this.lstFieldsAvailable.getSelectedValue();
        if (sel != null) {
            liste.add(sel);
            this.updateAttributeLists();
            lst.setSelectedIndex(lst.getModel().getSize() - 1);
            this.lstFieldsAvailable.setSelectedIndex(selIdx >= this.lstFieldsAvailable.getModel().getSize() ? this.lstFieldsAvailable.getModel().getSize() : selIdx);
            if (group) {
                this.groupFunction.setProperty(sel, "g");
            }
        }
    }

    private void removeFromGroup() {
        this.removeFromList(this.lstFieldsGroup, this.fieldsGroup, false);
    }

    private void removeFromOutput() {
        this.removeFromList(this.lstFieldsUsed, this.fieldsUsed, false);
    }

    private void removeFromList(JList lst, ArrayList liste, boolean group) {
        int selIdx = lst.getSelectedIndex();
        String sel = (String)lst.getSelectedValue();
        if (sel != null && liste.size() > selIdx && selIdx >= 0) {
            liste.remove(selIdx);
            this.updateAttributeLists();
            lst.setSelectedIndex(selIdx >= lst.getModel().getSize() ? lst.getModel().getSize() : selIdx);
            this.lstFieldsAvailable.setSelectedValue(sel, true);
            if (group) {
                this.groupFunction.remove(sel);
            }
        }
    }

    private void changeOrder(JList lst, ArrayList liste, int dir) {
        int idx = lst.getSelectedIndex();
        if (idx < 0 || Math.abs(1) != 1) {
            return;
        }
        int idx2 = idx + dir;
        if (idx2 >= 0 && idx2 < liste.size()) {
            Collections.swap(liste, idx, idx2);
            this.updateAttributeLists();
            lst.setSelectedIndex(idx2);
        }
    }

    private void changeGroupFunction(String f) {
        int idx = this.lstFieldsUsed.getSelectedIndex();
        String sel = this.lstFieldsUsed.getSelectedValue();
        if (sel != null) {
            String ph = this.fieldsUsed.get(idx);
            if ("1".equals(f)) {
                this.groupFunction.remove(ph);
            } else {
                this.groupFunction.setProperty(ph, f);
            }
        }
        this.updateAttributeLists();
        if (idx >= 0) {
            this.lstFieldsUsed.setSelectedIndex(idx);
        }
    }

    private void initComponents() {
        this.panelFile = new JPanel();
        this.panelFileSelect = new JPanel();
        this.jLabel23 = new JLabel();
        this.jLabel3 = new JLabel();
        this.fldExportFileFolder = new JTextField();
        this.jLabel4 = new JLabel();
        this.fldExportFile = new JTextField();
        this.btnSelectExportFile = new JButton();
        this.jLabel1 = new JLabel();
        this.panelTemplate = new JPanel();
        this.jLabel24 = new JLabel();
        this.jLabel5 = new JLabel();
        this.fldTemplateFileFolder = new JTextField();
        this.jLabel9 = new JLabel();
        this.fldTemplateFile = new JTextField();
        this.btnSelectTemplateFile = new JButton();
        this.panelFileXlsx = new JPanel();
        this.jLabel25 = new JLabel();
        this.lblSheet = new JLabel();
        this.fldSheet = new JComboBox();
        this.jLabel62 = new JLabel();
        this.fldRowData = new JTextField();
        this.panelAssign = new JPanel();
        this.jLabel26 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lstFieldsAvailable = new JList();
        this.jPanel1 = new JPanel();
        this.jLabel64 = new JLabel();
        this.jPanel4 = new JPanel();
        this.btnAddToGroup = new JButton();
        this.btnRemoveFromGroup = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.lstFieldsGroup = new JList();
        this.jPanel3 = new JPanel();
        this.btnGroupUp = new JButton();
        this.btnGroupDown = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel66 = new JLabel();
        this.jPanel6 = new JPanel();
        this.btnAddToUsed = new JButton();
        this.btnRemoveFromUsed = new JButton();
        this.jScrollPane8 = new JScrollPane();
        this.lstFieldsUsed = new JList();
        this.jPanel7 = new JPanel();
        this.btnUsedUp = new JButton();
        this.btnUsedDown = new JButton();
        this.btnUsedFirst = new JButton();
        this.btnUsedCount = new JButton();
        this.btnUsedSum = new JButton();
        this.panelButtons = new JPanel();
        this.btnImport = new JButton();
        this.btnClose = new JButton();
        this.setMinimumSize(new Dimension(900, 600));
        this.setPreferredSize(new Dimension(900, 600));
        this.setLayout(new GridBagLayout());
        this.panelFile.setLayout(new GridBagLayout());
        this.panelFileSelect.setLayout(new GridBagLayout());
        this.jLabel23.setFont(THEMIS.fontSubheading);
        this.jLabel23.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel23.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        this.jLabel3.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect.add((Component)this.jLabel3, gridBagConstraints);
        this.fldExportFileFolder.setEditable(false);
        this.fldExportFileFolder.setFont(THEMIS.fontTextfield);
        this.fldExportFileFolder.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.fldExportFileFolder.text"));
        this.fldExportFileFolder.setMinimumSize(new Dimension(100, 30));
        this.fldExportFileFolder.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.panelFileSelect.add((Component)this.fldExportFileFolder, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        this.jLabel4.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect.add((Component)this.jLabel4, gridBagConstraints);
        this.fldExportFile.setFont(THEMIS.fontTextfield);
        this.fldExportFile.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.fldExportFile.text"));
        this.fldExportFile.setMinimumSize(new Dimension(100, 30));
        this.fldExportFile.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileSelect.add((Component)this.fldExportFile, gridBagConstraints);
        this.btnSelectExportFile.setFont(THEMIS.fontButton);
        this.btnSelectExportFile.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnSelectExportFile.text"));
        this.btnSelectExportFile.setMaximumSize(null);
        this.btnSelectExportFile.setMinimumSize(new Dimension(100, 30));
        this.btnSelectExportFile.setPreferredSize(null);
        this.btnSelectExportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnSelectExportFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.panelFileSelect.add((Component)this.btnSelectExportFile, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabel);
        this.jLabel1.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.panelFileSelect.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.panelFileSelect, gridBagConstraints);
        this.panelTemplate.setLayout(new GridBagLayout());
        this.jLabel24.setFont(THEMIS.fontSubheading);
        this.jLabel24.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel24.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelTemplate.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabel);
        this.jLabel5.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelTemplate.add((Component)this.jLabel5, gridBagConstraints);
        this.fldTemplateFileFolder.setEditable(false);
        this.fldTemplateFileFolder.setFont(THEMIS.fontTextfield);
        this.fldTemplateFileFolder.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.fldTemplateFileFolder.text"));
        this.fldTemplateFileFolder.setMinimumSize(new Dimension(100, 30));
        this.fldTemplateFileFolder.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        this.panelTemplate.add((Component)this.fldTemplateFileFolder, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        this.jLabel9.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelTemplate.add((Component)this.jLabel9, gridBagConstraints);
        this.fldTemplateFile.setFont(THEMIS.fontTextfield);
        this.fldTemplateFile.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.fldTemplateFile.text"));
        this.fldTemplateFile.setMinimumSize(new Dimension(100, 30));
        this.fldTemplateFile.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelTemplate.add((Component)this.fldTemplateFile, gridBagConstraints);
        this.btnSelectTemplateFile.setFont(THEMIS.fontButton);
        this.btnSelectTemplateFile.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnSelectTemplateFile.text"));
        this.btnSelectTemplateFile.setMaximumSize(new Dimension(110, 36));
        this.btnSelectTemplateFile.setMinimumSize(new Dimension(100, 30));
        this.btnSelectTemplateFile.setPreferredSize(null);
        this.btnSelectTemplateFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnSelectTemplateFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.panelTemplate.add((Component)this.btnSelectTemplateFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.panelTemplate, gridBagConstraints);
        this.panelFileXlsx.setLayout(new GridBagLayout());
        this.jLabel25.setFont(THEMIS.fontSubheading);
        this.jLabel25.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel25.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileXlsx.add((Component)this.jLabel25, gridBagConstraints);
        this.lblSheet.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.lblSheet.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileXlsx.add((Component)this.lblSheet, gridBagConstraints);
        this.fldSheet.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.fldSheet.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add(this.fldSheet, gridBagConstraints);
        this.jLabel62.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel62.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelFileXlsx.add((Component)this.jLabel62, gridBagConstraints);
        this.fldRowData.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.fldRowData.text"));
        this.fldRowData.setMinimumSize(new Dimension(150, 30));
        this.fldRowData.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.fldRowData, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.panelFileXlsx, gridBagConstraints);
        this.panelAssign.setLayout(new GridBagLayout());
        this.jLabel26.setFont(THEMIS.fontSubheading);
        this.jLabel26.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel26.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.panelAssign.add((Component)this.jLabel26, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(100, 50));
        this.jScrollPane2.setPreferredSize(new Dimension(100, 50));
        this.lstFieldsAvailable.setFont(THEMIS.fontList);
        this.lstFieldsAvailable.setModel(new DefaultListModel());
        this.jScrollPane2.setViewportView(this.lstFieldsAvailable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel64.setFont(THEMIS.fontLabelBold);
        this.jLabel64.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel64.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel64, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.btnAddToGroup.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        this.btnAddToGroup.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnAddToGroup.text"));
        this.btnAddToGroup.setBorder(new SoftBevelBorder(0));
        this.btnAddToGroup.setPreferredSize(new Dimension(35, 35));
        this.btnAddToGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnAddToGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnAddToGroup, gridBagConstraints);
        this.btnRemoveFromGroup.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft24.gif")));
        this.btnRemoveFromGroup.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnRemoveFromGroup.text"));
        this.btnRemoveFromGroup.setBorder(new SoftBevelBorder(0));
        this.btnRemoveFromGroup.setPreferredSize(new Dimension(35, 35));
        this.btnRemoveFromGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnRemoveFromGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnRemoveFromGroup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jScrollPane6.setMinimumSize(new Dimension(100, 50));
        this.jScrollPane6.setPreferredSize(new Dimension(100, 50));
        this.lstFieldsGroup.setFont(THEMIS.fontList);
        this.lstFieldsGroup.setModel(new DefaultListModel());
        this.jScrollPane6.setViewportView(this.lstFieldsGroup);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jScrollPane6, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnGroupUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        this.btnGroupUp.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnGroupUp.text"));
        this.btnGroupUp.setBorder(new SoftBevelBorder(0));
        this.btnGroupUp.setPreferredSize(new Dimension(35, 35));
        this.btnGroupUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnGroupUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnGroupUp, gridBagConstraints);
        this.btnGroupDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        this.btnGroupDown.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnGroupDown.text"));
        this.btnGroupDown.setBorder(new SoftBevelBorder(0));
        this.btnGroupDown.setPreferredSize(new Dimension(35, 35));
        this.btnGroupDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnGroupDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnGroupDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.8;
        this.panelAssign.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel66.setFont(THEMIS.fontLabelBold);
        this.jLabel66.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.jLabel66.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel5.add((Component)this.jLabel66, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.btnAddToUsed.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        this.btnAddToUsed.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnAddToUsed.text"));
        this.btnAddToUsed.setBorder(new SoftBevelBorder(0));
        this.btnAddToUsed.setPreferredSize(new Dimension(35, 35));
        this.btnAddToUsed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnAddToUsedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnAddToUsed, gridBagConstraints);
        this.btnRemoveFromUsed.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft24.gif")));
        this.btnRemoveFromUsed.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnRemoveFromUsed.text"));
        this.btnRemoveFromUsed.setBorder(new SoftBevelBorder(0));
        this.btnRemoveFromUsed.setPreferredSize(new Dimension(35, 35));
        this.btnRemoveFromUsed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnRemoveFromUsedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.btnRemoveFromUsed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        this.jScrollPane8.setMinimumSize(new Dimension(100, 50));
        this.jScrollPane8.setPreferredSize(new Dimension(100, 50));
        this.lstFieldsUsed.setFont(THEMIS.fontList);
        this.lstFieldsUsed.setModel(new DefaultListModel());
        this.jScrollPane8.setViewportView(this.lstFieldsUsed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jScrollPane8, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.btnUsedUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        this.btnUsedUp.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnUsedUp.text"));
        this.btnUsedUp.setBorder(new SoftBevelBorder(0));
        this.btnUsedUp.setPreferredSize(new Dimension(35, 35));
        this.btnUsedUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnUsedUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.btnUsedUp, gridBagConstraints);
        this.btnUsedDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        this.btnUsedDown.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnUsedDown.text"));
        this.btnUsedDown.setBorder(new SoftBevelBorder(0));
        this.btnUsedDown.setPreferredSize(new Dimension(35, 35));
        this.btnUsedDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnUsedDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.btnUsedDown, gridBagConstraints);
        this.btnUsedFirst.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnUsedFirst.text"));
        this.btnUsedFirst.setBorder(new SoftBevelBorder(0));
        this.btnUsedFirst.setMaximumSize(null);
        this.btnUsedFirst.setMinimumSize(null);
        this.btnUsedFirst.setPreferredSize(null);
        this.btnUsedFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnUsedFirstActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.btnUsedFirst, gridBagConstraints);
        this.btnUsedCount.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnUsedCount.text"));
        this.btnUsedCount.setBorder(new SoftBevelBorder(0));
        this.btnUsedCount.setMaximumSize(null);
        this.btnUsedCount.setMinimumSize(null);
        this.btnUsedCount.setPreferredSize(null);
        this.btnUsedCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnUsedCountActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.btnUsedCount, gridBagConstraints);
        this.btnUsedSum.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnUsedSum.text"));
        this.btnUsedSum.setBorder(new SoftBevelBorder(0));
        this.btnUsedSum.setMaximumSize(null);
        this.btnUsedSum.setMinimumSize(null);
        this.btnUsedSum.setPreferredSize(null);
        this.btnUsedSum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnUsedSumActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel7.add((Component)this.btnUsedSum, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        this.jPanel5.add((Component)this.jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.8;
        this.panelAssign.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.panelAssign, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelFile, gridBagConstraints);
        this.panelButtons.setMinimumSize(new Dimension(100, 50));
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnImport.setFont(THEMIS.fontButton);
        this.btnImport.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_importCAD24.gif")));
        this.btnImport.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnImport.text"));
        this.btnImport.setBorder(new SoftBevelBorder(0));
        this.btnImport.setMaximumSize(null);
        this.btnImport.setMinimumSize(null);
        this.btnImport.setPreferredSize(null);
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnImport, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontButton);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        this.btnClose.setText(NbBundle.getMessage(ExportWizard2.class, (String)"ExportWizard2.btnClose.text"));
        this.btnClose.setBorder(new SoftBevelBorder(0));
        this.btnClose.setMaximumSize(null);
        this.btnClose.setMinimumSize(null);
        this.btnClose.setPreferredSize(null);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportWizard2.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.saveSettings();
        this.closeDialog(evt);
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.saveSettings();
        this.runExport();
    }

    private void btnSelectExportFileActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.app.getProject().getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.SAVE, this.exportFileFolder, null, new FileNameExtensionFilter(this.app.getProject().getResourceText("dialog.save.export-csv-xls"), "xlsx", "csv", "txt"), null, false).getSelectedFile();
        this.setExportFile(f);
    }

    private void btnSelectTemplateFileActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.app.getProject().getResourceText("file.choose.title"), ThemisFileDialog.DIALOGTYPE.SAVE, this.templateFile == null ? null : this.templateFile.getParentFile(), null, new FileNameExtensionFilter(this.app.getProject().getResourceText("dialog.load.export-template.excel"), "xlsx"), null, false).getSelectedFile();
        this.setExportFile(f);
    }

    private void btnAddToGroupActionPerformed(ActionEvent evt) {
        this.addToGroup();
    }

    private void btnRemoveFromGroupActionPerformed(ActionEvent evt) {
        this.removeFromGroup();
    }

    private void btnGroupDownActionPerformed(ActionEvent evt) {
        this.changeOrder(this.lstFieldsGroup, this.fieldsGroup, 1);
    }

    private void btnGroupUpActionPerformed(ActionEvent evt) {
        this.changeOrder(this.lstFieldsGroup, this.fieldsGroup, -1);
    }

    private void btnAddToUsedActionPerformed(ActionEvent evt) {
        this.addToOutput();
    }

    private void btnRemoveFromUsedActionPerformed(ActionEvent evt) {
        this.removeFromOutput();
    }

    private void btnUsedUpActionPerformed(ActionEvent evt) {
        this.changeOrder(this.lstFieldsUsed, this.fieldsUsed, -1);
    }

    private void btnUsedDownActionPerformed(ActionEvent evt) {
        this.changeOrder(this.lstFieldsUsed, this.fieldsUsed, 1);
    }

    private void btnUsedFirstActionPerformed(ActionEvent evt) {
        this.changeGroupFunction("1");
    }

    private void btnUsedCountActionPerformed(ActionEvent evt) {
        this.changeGroupFunction("n");
    }

    private void btnUsedSumActionPerformed(ActionEvent evt) {
        this.changeGroupFunction("s");
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog("Export", this, true, true);
        THEMIS.applyWindowSizeAndLocation(DIALOG_CODE, dlg, 800, 800);
        dlg.setVisible(true);
    }

    private void closeDialog(ActionEvent evt) {
        JComponent c = (JComponent)evt.getSource();
        Window w = SwingUtilities.getWindowAncestor(c);
        THEMIS.saveWindowSizeAndLocation(DIALOG_CODE, w);
        w.dispose();
    }

    public void getWindowSizeAndLocation() {
        Dimension windowSize = THEMIS.getWindowSize("reportpanel", this.app);
        if (windowSize != null) {
            this.setSize(windowSize);
            this.setPreferredSize(windowSize);
        }
    }

    class ConfigurationTopic {
        int number;
        String displayLabel;
        String panelName;

        public ConfigurationTopic(String panelName, int number, String display) {
            this.displayLabel = display;
            this.panelName = panelName;
            this.number = number;
        }

        public String toString() {
            return (this.number > 0 ? this.number + ". " : "") + this.displayLabel;
        }
    }

    static enum ExportFormat {
        XLSX,
        CSV,
        NONE;

    }
}

