/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer;

import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.importer.AttributeReference;
import at.grid.themis.ontology.importer.ThemisReaderGeneric;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ProgressHandler;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;

public abstract class ImportTarget {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    HashMap<Integer, AttributeReference> mapping = new HashMap();
    ThemisReaderGeneric reader = null;
    ArrayList<AttributeReference> attributes = new ArrayList();

    public ImportTarget() {
        this.initialise();
    }

    protected abstract void initialise();

    public void clear() {
        this.mapping.clear();
    }

    public HashMap getMapping() {
        return this.mapping;
    }

    public void addMapping(int columnIndex, AttributeReference att) {
        if (!this.mapping.containsKey(columnIndex)) {
            this.mapping.put(columnIndex, att);
        }
    }

    public void removeMapping(int idx) {
        this.mapping.remove(idx);
    }

    public void autoMap() {
        if (this.reader == null) {
            return;
        }
        HashMap<String, AttributeReference> toMap = new HashMap<String, AttributeReference>();
        ArrayList columns = this.reader.getHeader();
        for (String c : columns) {
            if (this.getMapping().containsKey(c)) continue;
            for (AttributeReference att : this.attributes) {
                if (att.toString().indexOf(c) < 0 && att.attributecode.indexOf(c) < 0) continue;
                toMap.put(c, att);
            }
        }
        for (String k : toMap.keySet()) {
            this.addMapping(columns.indexOf(k), (AttributeReference)toMap.get(k));
        }
    }

    public void setReader(ThemisReaderGeneric r) {
        this.reader = r;
    }

    public ThemisReaderGeneric getReader() {
        return this.reader;
    }

    public DefaultListModel getObjectListModel() {
        DefaultListModel<AttributeReference> m2 = new DefaultListModel<AttributeReference>();
        m2.removeAllElements();
        for (AttributeReference c : this.attributes) {
            boolean found = false;
            for (AttributeReference ar : this.mapping.values()) {
                if (!ar.equals(c)) continue;
                found = true;
                break;
            }
            if (found) continue;
            m2.addElement(c);
        }
        return m2;
    }

    public abstract void runImport(ProgressHandler var1);

    public void runImportWithProgress() {
        String progressTitle = "Import";
        BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                ThemisProgressHandler tph = new ThemisProgressHandler(ph);
                ImportTarget.this.runImport(tph);
                ph.finish();
                return null;
            }
        }, (String)progressTitle, (boolean)true);
    }
}

