/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer;

import at.grid.cms.content.KeytableRecord;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.io.importer.LocationObservationImportTarget;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.importer.AttributeReference;
import at.grid.themis.ontology.importer.ThemisCsvImporter;
import at.grid.themis.ontology.importer.ThemisReaderCsv;
import at.grid.themis.ontology.importer.ThemisReaderGeneric;
import at.grid.themis.ontology.importer.ThemisReaderXlsx;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ImportWizard
extends JPanel {
    public static String DIALOG_CODE = "importwizard";
    public static final int DIALOG_WIDTH = 800;
    public static final int DIALOG_HEIGHT = 800;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/io/importer/Bundle");
    public static final int OHTER_REASON = 1;
    public static final int LOCATION_NUMBEWR_ALREADY_USED = 10;
    public static final int LOCATION_OUTSIDE_BOX = 11;
    public static final int LOCATION_IS_MARKER = 12;
    public static final int LOCATION_NOT_IN_PLAN = 13;
    public static final int LOCATION_HAS_NO_PLAN = 14;
    public static final int LOCATION_SAVED = 100;
    ThemisSettings settings = this.app.getSettings();
    ArrayList<LocationCsv> rows = new ArrayList();
    long planId = -1L;
    HashMap<String, Long> planMapping = new HashMap();
    HashMap<String, String> columnMapping = new HashMap();
    boolean hasPlanColumn = false;
    DefaultListModel<LocationCsv> locationModel = new DefaultListModel();
    boolean waitingForPoint = false;
    LocationObservationImportTarget importer = new LocationObservationImportTarget();
    HashMap<Integer, AttributeReference> mapping2 = null;
    ArrayList<String> columns = new ArrayList();
    ArrayList<AttributeReference> attributes = new ArrayList();
    private File importFile;
    private JButton btnClose;
    private JButton btnImport;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnSelectFile;
    private JButton btnSelectFile1;
    private JButton btnTrennen;
    private JButton btnZuweisen;
    private JButton btnZuweisen1;
    private JCheckBox chkCreateObservation;
    private JCheckBox chkCurrentPlanOnly;
    private JCheckBox chkImportMarker;
    private JCheckBox chkIncludeNoPlan;
    private JCheckBox chkOnlyWithin;
    private JCheckBox chkPreviousMethod;
    private JLabel empty;
    private JLabel empty1;
    private JComboBox<KeytableRecord> fldCreateObservationType;
    private JTextField fldFilename;
    private JTextField fldRowData;
    private JTextField fldRowHeader;
    private JComboBox<String> fldSheet;
    private JLabel jLabel2;
    private JLabel jLabel23;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel52;
    private JLabel jLabel6;
    private JLabel jLabel62;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JLabel lblImport;
    private JLabel lblSheet;
    private JList listTopic;
    private JList lstAttributes;
    private JList lstColumns;
    private JList lstMapping;
    private JPanel panelAssign;
    private JPanel panelButtons;
    private JPanel panelButtons1;
    private JPanel panelEditor;
    private JPanel panelFile;
    private JPanel panelFileXlsx;
    private JPanel panelOptions;
    private JPanel panelTemp;

    public ImportWizard() {
        this.initComponents();
        int wizardNo = 1;
        DefaultListModel topicModel = (DefaultListModel)this.listTopic.getModel();
        topicModel.addElement(new ConfigurationTopic("cardFile", wizardNo++, this.bundle.getString("ImportWizard.card.file")));
        topicModel.addElement(new ConfigurationTopic("cardAssign", wizardNo++, this.bundle.getString("ImportWizard.card.assign")));
        topicModel.addElement(new ConfigurationTopic("cardOptions", wizardNo++, this.bundle.getString("ImportWizard.card.options")));
        this.listTopic.setSelectedIndex(0);
        this.listTopic.setCellRenderer(new SimpleTextRenderer());
        this.mapping2 = this.app.getSettings().getImportMapping();
        this.fldRowHeader.setText(this.app.getSettings().getImportRowHeader());
        this.fldRowData.setText(this.app.getSettings().getImportRowData());
        this.panelFileXlsx.setVisible(false);
        new DropTarget(this.fldFilename, new ThemisDropTargetListener(false, false, new String[]{"xlsx", "txt", "csv"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                try {
                    ImportWizard.this.setImportFile(f);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    public void populateObservationtype() {
        DefaultComboBoxModel<KeytableRecord> m = new DefaultComboBoxModel<KeytableRecord>();
        if (this.project != null && this.project.isOpen()) {
            ArrayList lst = this.project.getDefaultElement("observation").getKeyAttribute("type").getKeytable().toList(this.project.getUser().getCurrentLanguage());
            for (KeytableRecord rec : lst) {
                switch ((int)rec.id) {
                    case 2: {
                        rec.term = this.app.getSettings().getTerm(ThemisSettings.Term.TypKontrolle);
                        break;
                    }
                    case 3: {
                        rec.term = this.app.getSettings().getTerm(ThemisSettings.Term.TypInformation);
                        break;
                    }
                    case 4: {
                        rec.term = this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe);
                        break;
                    }
                    default: {
                        rec.term = this.app.getSettings().getTerm(ThemisSettings.Term.TypMangel);
                    }
                }
                m.addElement(rec);
            }
        }
        this.fldCreateObservationType.setModel(m);
    }

    private void populateAttributes() {
        block10: for (ThemisAttribute a : this.settings.getLocationAttributes()) {
            if (!a.isUsed() || a.isVirtual()) continue;
            switch (a.getId()) {
                case "size": {
                    this.attributes.add(new AttributeReference("location", "dimwidth", this.project.getResourceText("attribute.location.dimwidth")));
                    this.attributes.add(new AttributeReference("location", "dimheight", this.project.getResourceText("attribute.location.dimheight")));
                    this.attributes.add(new AttributeReference("location", "dimdiameter", this.project.getResourceText("attribute.location.dimdiameter")));
                    continue block10;
                }
                case "prefixsuffix": 
                case "suffix": 
                case "group": {
                    continue block10;
                }
            }
            this.attributes.add(new AttributeReference(a));
        }
        for (ThemisAttribute a : this.settings.getObservationAttributes()) {
            if (!a.isUsed() || a.isVirtual()) continue;
            this.attributes.add(new AttributeReference(a));
        }
        this.attributes.add(new AttributeReference("observation", "upload-file", this.project.getResourceText("attribute.observation.upload-file")));
        this.attributes.add(new AttributeReference("observation", "upload-comment", this.project.getResourceText("attribute.observation.upload-comment")));
        this.attributes.add(new AttributeReference("observation", "type", "Beobachtungstyp"));
        this.attributes.add(new AttributeReference("observation", "uuid", "UUID"));
        this.attributes.add(new AttributeReference("location", "uuid", "UUID"));
    }

    private void updateAttributes() {
        for (AttributeReference a : this.attributes) {
            if (a.ta == null) continue;
            a.attributelabel = a.ta.getLabel();
        }
        this.updateLists();
    }

    private void addMapping(String col, AttributeReference att) {
        this.mapping2.put(this.columns.indexOf(col), att);
        this.app.getSettings().setImportMapping(this.mapping2);
        this.updateLists();
    }

    private void removeMapping(String selectedValue) {
        String[] split = selectedValue.split(" -> ");
        if (split.length > 1) {
            this.mapping2.remove(this.columns.indexOf(split[0]));
        }
        this.app.getSettings().setImportMapping(this.mapping2);
        this.updateLists();
    }

    public void updateLists() {
        DefaultListModel m = (DefaultListModel)this.lstColumns.getModel();
        m.removeAllElements();
        for (int ii = 0; ii < this.columns.size(); ++ii) {
            if (this.mapping2.containsKey(ii)) continue;
            m.addElement(this.columns.get(ii));
        }
        DefaultListModel m2 = (DefaultListModel)this.lstAttributes.getModel();
        m2.removeAllElements();
        for (AttributeReference c : this.attributes) {
            boolean found = false;
            for (AttributeReference ar : this.mapping2.values()) {
                if (!ar.equals((Object)c)) continue;
                found = true;
                break;
            }
            if (found) continue;
            m2.addElement(c);
        }
        m = (DefaultListModel)this.lstMapping.getModel();
        m.removeAllElements();
        for (int ii = 0; ii < this.columns.size(); ++ii) {
            if (!this.mapping2.containsKey(ii)) continue;
            m.addElement(this.columns.get(ii) + " -> " + this.mapping2.get(ii));
        }
    }

    private void setImportFile(File f) throws IOException {
        if (f == null || !f.isFile()) {
            return;
        }
        this.app.setDocumentImportFolder(f.getParentFile());
        this.importFile = f;
        String fn = f.getName().toLowerCase();
        if (f.getName().toLowerCase().endsWith(".xlsx")) {
            this.panelFileXlsx.setVisible(true);
            int rowHeader = Util.parseInt((String)this.fldRowHeader.getText(), (int)1);
            int rowData = Util.parseInt((String)this.fldRowData.getText(), (int)2);
            ThemisReaderXlsx r = new ThemisReaderXlsx(rowHeader, rowData);
            this.fldSheet.removeAllItems();
            ArrayList names = r.getSheetNames(f);
            for (String n : names) {
                this.fldSheet.addItem(n);
            }
            if (!names.isEmpty()) {
                this.fldSheet.setSelectedIndex(0);
            }
            this.importer.setReader((ThemisReaderGeneric)r);
        } else {
            this.panelFileXlsx.setVisible(false);
            this.importer.setReader((ThemisReaderGeneric)new ThemisReaderCsv());
        }
        this.readFile(f);
        this.fldFilename.setText(f.getAbsolutePath());
    }

    private void readFile(File f) {
        try {
            this.importer.getReader().setSheet(this.fldSheet.getSelectedIndex());
            this.importer.getReader().readFile(f);
            this.columns.clear();
            this.attributes.clear();
            for (String col : this.importer.getReader().getHeader()) {
                this.columns.add(col);
            }
            this.populateAttributes();
            this.updateLists();
            if (this.columns.isEmpty()) {
                Dialogs.getInstance().showErrorDialog("error.import.noContent");
            }
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog("error.fileCannotBeDeleted");
        }
    }

    protected void importLocations() {
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        ThemisActionProvider.getInstance().setActive(false);
        final ThemisCsvImporter importer = new ThemisCsvImporter();
        importer.setCreateStandardObservation(this.chkCreateObservation.isSelected() ? (KeytableRecord)this.fldCreateObservationType.getSelectedItem() : null);
        HashMap<String, AttributeReference> m = new HashMap<String, AttributeReference>();
        for (int k : this.mapping2.keySet()) {
            m.put(this.columns.get(k), this.mapping2.get(k));
        }
        importer.setColumnMapping(m);
        String progressTitle = "Import";
        BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                ThemisProgressHandler tph = new ThemisProgressHandler(ph);
                importer.importData((ProgressHandler)tph);
                ph.finish();
                return null;
            }
        }, (String)progressTitle, (boolean)true);
        this.app.getFilter().resetSearchResult();
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED);
        Dialogs.getInstance().showInfoDialog(this.project.getResourceText("info.csv-import.succeeded"));
        ThemisActionProvider.getInstance().setActive(true);
    }

    protected void importLocations2() throws IOException {
        Object type;
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        ThemisActionProvider.getInstance().setActive(false);
        if (this.chkCreateObservation.isSelected()) {
            type = (KeytableRecord)this.fldCreateObservationType.getSelectedItem();
            this.importer.setCreateStandardObservation("Beobachtung", ((KeytableRecord)type).id);
        }
        this.importer.clearMapping();
        type = this.mapping2.keySet().iterator();
        while (type.hasNext()) {
            int k = (Integer)type.next();
            this.importer.addMapping(k, this.mapping2.get(k));
        }
        String progressTitle = "Import";
        BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                ThemisProgressHandler tph = new ThemisProgressHandler(ph);
                ImportWizard.this.importer.runImport(tph);
                ph.finish();
                return null;
            }
        }, (String)progressTitle, (boolean)true);
        this.app.getFilter().resetSearchResult();
        ThemisActionProvider.getInstance().setActive(true);
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED);
        Dialogs.getInstance().showInfoDialog(this.project.getResourceText("info.csv-import.succeeded"));
    }

    private int executeImport(ArrayList<LocationCsv> refs, double transformX, double transformY, ArrayList<Long> locationnumbers, LocationCsv l, boolean doSave) {
        double dX = l.x - refs.get((int)0).x;
        double dY = l.y - refs.get((int)0).y;
        l.imgX = refs.get((int)0).imgX + transformX * dX;
        l.imgY = refs.get((int)0).imgY + transformY * dY;
        double minX = Math.min(refs.get((int)0).x, refs.get((int)1).x);
        double maxX = Math.max(refs.get((int)0).x, refs.get((int)1).x);
        double minY = Math.min(refs.get((int)0).y, refs.get((int)1).y);
        double maxY = Math.max(refs.get((int)0).y, refs.get((int)1).y);
        if (this.chkOnlyWithin.isSelected() && (l.x < minX || l.x > maxX || l.y < minY || l.y > maxY)) {
            return 11;
        }
        if (!this.chkImportMarker.isSelected() && refs.contains(l)) {
            return 12;
        }
        long linePlanId = -1L;
        linePlanId = this.hasPlanColumn ? l.planId : this.planId;
        if (linePlanId < 0L && !this.chkIncludeNoPlan.isSelected()) {
            return 14;
        }
        if (this.chkCurrentPlanOnly.isSelected() && linePlanId != this.planId) {
            return 13;
        }
        if (locationnumbers.contains(l.number)) {
            return 10;
        }
        if (doSave) {
            CmsLocation loc = (CmsLocation)this.project.createElement("location");
            loc.setAttributeValue("title", l.name);
            loc.setAttributeValue("number", Long.toString(l.number));
            loc.setAttributeValue("description", l.comment);
            loc.setAttributeValue("position", "POINT(" + l.imgX + " " + l.imgY + ")");
            loc.setAttributeValue("quantity", l.quantity);
            loc.setAttributeValue("code", l.code);
            loc.setAttributeValue("code2", l.code2);
            if (linePlanId >= 0L) {
                loc.getRelationAttribute("plan").set(linePlanId);
            }
            loc.save();
            if (this.chkCreateObservation.isSelected()) {
                CmsObservation obs = (CmsObservation)this.project.createElement("observation");
                obs.getRelationAttribute("location").set(loc.getId());
                obs.setNumber(loc.getNextObservationNumber());
                KeytableRecord rec = (KeytableRecord)this.fldCreateObservationType.getSelectedItem();
                obs.setAttributeValue("title", rec.term);
                obs.getKeyAttribute("type").setValue(rec.id);
                obs.setAttributeValue("description", "");
                if (linePlanId >= 0L) {
                    obs.getRelationAttribute("plan").set(linePlanId);
                }
                obs.save();
            }
        }
        return 100;
    }

    public void getWindowSizeAndLocation() {
        Dimension windowSize = THEMIS.getWindowSize("reportpanel", this.app);
        if (windowSize != null) {
            this.setSize(windowSize);
            this.setPreferredSize(windowSize);
        }
    }

    private void showWizardPage() {
        ConfigurationTopic topic = (ConfigurationTopic)this.listTopic.getSelectedValue();
        if (topic == null) {
            this.listTopic.setSelectedIndex(0);
            return;
        }
        CardLayout cd = (CardLayout)this.panelEditor.getLayout();
        cd.show(this.panelEditor, topic.panelName);
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.listTopic = new JList();
        this.panelEditor = new JPanel();
        this.panelFile = new JPanel();
        this.jLabel23 = new JLabel();
        this.jLabel49 = new JLabel();
        this.fldFilename = new JTextField();
        this.btnSelectFile = new JButton();
        this.panelFileXlsx = new JPanel();
        this.lblSheet = new JLabel();
        this.fldSheet = new JComboBox();
        this.jLabel52 = new JLabel();
        this.fldRowHeader = new JTextField();
        this.jLabel62 = new JLabel();
        this.fldRowData = new JTextField();
        this.btnSelectFile1 = new JButton();
        this.empty = new JLabel();
        this.panelAssign = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstColumns = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.lstAttributes = new JList();
        this.btnZuweisen1 = new JButton();
        this.btnZuweisen = new JButton();
        this.jLabel5 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.lstMapping = new JList();
        this.btnTrennen = new JButton();
        this.panelOptions = new JPanel();
        this.lblImport = new JLabel();
        this.chkCreateObservation = new JCheckBox();
        this.fldCreateObservationType = new JComboBox();
        this.chkPreviousMethod = new JCheckBox();
        this.empty1 = new JLabel();
        this.panelTemp = new JPanel();
        this.chkOnlyWithin = new JCheckBox();
        this.chkImportMarker = new JCheckBox();
        this.chkCurrentPlanOnly = new JCheckBox();
        this.chkIncludeNoPlan = new JCheckBox();
        this.panelButtons = new JPanel();
        this.btnImport = new JButton();
        this.btnClose = new JButton();
        this.panelButtons1 = new JPanel();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.setMinimumSize(new Dimension(900, 600));
        this.setPreferredSize(new Dimension(900, 600));
        this.setLayout(new GridBagLayout());
        this.jScrollPane3.setHorizontalScrollBar(null);
        this.jScrollPane3.setMaximumSize(null);
        this.jScrollPane3.setMinimumSize(new Dimension(250, 150));
        this.jScrollPane3.setPreferredSize(new Dimension(250, 150));
        this.listTopic.setFont(THEMIS.fontList);
        this.listTopic.setModel(new DefaultListModel());
        this.listTopic.setSelectionMode(0);
        this.listTopic.setPreferredSize(new Dimension(250, 150));
        this.listTopic.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ImportWizard.this.listTopicValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.listTopic);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jScrollPane3, gridBagConstraints);
        this.panelEditor.setPreferredSize(new Dimension(900, 600));
        this.panelEditor.setRequestFocusEnabled(false);
        this.panelEditor.setLayout(new CardLayout(5, 5));
        this.panelFile.setLayout(new GridBagLayout());
        this.jLabel23.setFont(THEMIS.fontSubheading);
        this.jLabel23.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.jLabel23.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel49.setFont(THEMIS.fontLabel);
        this.jLabel49.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.jLabel49.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.jLabel49, gridBagConstraints);
        this.fldFilename.setEditable(false);
        this.fldFilename.setFont(THEMIS.fontTextfield);
        this.fldFilename.setHorizontalAlignment(4);
        this.fldFilename.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.fldFilename.text"));
        this.fldFilename.setMinimumSize(new Dimension(5, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.fldFilename, gridBagConstraints);
        this.btnSelectFile.setFont(THEMIS.fontButton);
        this.btnSelectFile.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnSelectFile.text"));
        this.btnSelectFile.setBorder(new SoftBevelBorder(0));
        this.btnSelectFile.setMinimumSize(new Dimension(100, 40));
        this.btnSelectFile.setPreferredSize(new Dimension(100, 40));
        this.btnSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.btnSelectFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFile.add((Component)this.btnSelectFile, gridBagConstraints);
        this.panelFileXlsx.setLayout(new GridBagLayout());
        this.lblSheet.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.lblSheet.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.lblSheet, gridBagConstraints);
        this.fldSheet.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.fldSheet.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add(this.fldSheet, gridBagConstraints);
        this.jLabel52.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.jLabel52.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.jLabel52, gridBagConstraints);
        this.fldRowHeader.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.fldRowHeader.text"));
        this.fldRowHeader.setMinimumSize(new Dimension(150, 30));
        this.fldRowHeader.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.fldRowHeader, gridBagConstraints);
        this.jLabel62.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.jLabel62.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.jLabel62, gridBagConstraints);
        this.fldRowData.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.fldRowData.text"));
        this.fldRowData.setMinimumSize(new Dimension(150, 30));
        this.fldRowData.setPreferredSize(new Dimension(150, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.fldRowData, gridBagConstraints);
        this.btnSelectFile1.setFont(THEMIS.fontButton);
        this.btnSelectFile1.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnSelectFile1.text"));
        this.btnSelectFile1.setBorder(new SoftBevelBorder(0));
        this.btnSelectFile1.setMinimumSize(new Dimension(150, 40));
        this.btnSelectFile1.setPreferredSize(new Dimension(150, 40));
        this.btnSelectFile1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.btnSelectFile1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.btnSelectFile1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelFile.add((Component)this.panelFileXlsx, gridBagConstraints);
        this.empty.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.empty.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelFile.add((Component)this.empty, gridBagConstraints);
        this.panelEditor.add((Component)this.panelFile, "cardFile");
        this.panelAssign.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.panelAssign.setPreferredSize(new Dimension(350, 486));
        this.panelAssign.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontSubheading);
        this.jLabel2.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        this.jLabel7.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        this.jLabel6.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel6, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(10, 20));
        this.jScrollPane1.setPreferredSize(new Dimension(180, 119));
        this.lstColumns.setFont(THEMIS.fontList);
        this.lstColumns.setModel(new DefaultListModel());
        this.lstColumns.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lstColumns);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelAssign.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane4.setMinimumSize(new Dimension(10, 20));
        this.jScrollPane4.setPreferredSize(new Dimension(180, 119));
        this.lstAttributes.setFont(THEMIS.fontList);
        this.lstAttributes.setModel(new DefaultListModel());
        this.lstAttributes.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.lstAttributes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelAssign.add((Component)this.jScrollPane4, gridBagConstraints);
        this.btnZuweisen1.setFont(THEMIS.fontButton);
        this.btnZuweisen1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/connect32.gif")));
        this.btnZuweisen1.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnZuweisen1.text"));
        this.btnZuweisen1.setToolTipText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnZuweisen1.toolTipText"));
        this.btnZuweisen1.setBorder(new SoftBevelBorder(0));
        this.btnZuweisen1.setMinimumSize(new Dimension(100, 40));
        this.btnZuweisen1.setPreferredSize(new Dimension(100, 40));
        this.btnZuweisen1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.btnZuweisen1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnZuweisen1, gridBagConstraints);
        this.btnZuweisen.setFont(THEMIS.fontButton);
        this.btnZuweisen.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/connect32.gif")));
        this.btnZuweisen.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnZuweisen.text"));
        this.btnZuweisen.setToolTipText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnZuweisen.toolTipText"));
        this.btnZuweisen.setBorder(new SoftBevelBorder(0));
        this.btnZuweisen.setMinimumSize(new Dimension(100, 40));
        this.btnZuweisen.setPreferredSize(new Dimension(100, 40));
        this.btnZuweisen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.btnZuweisenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnZuweisen, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontSubheading);
        this.jLabel5.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel5, gridBagConstraints);
        this.jScrollPane5.setMinimumSize(new Dimension(10, 20));
        this.lstMapping.setFont(THEMIS.fontList);
        this.lstMapping.setModel(new DefaultListModel());
        this.jScrollPane5.setViewportView(this.lstMapping);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelAssign.add((Component)this.jScrollPane5, gridBagConstraints);
        this.btnTrennen.setFont(THEMIS.fontButton);
        this.btnTrennen.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        this.btnTrennen.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnTrennen.text"));
        this.btnTrennen.setToolTipText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnTrennen.toolTipText"));
        this.btnTrennen.setBorder(new SoftBevelBorder(0));
        this.btnTrennen.setMaximumSize(new Dimension(500, 40));
        this.btnTrennen.setMinimumSize(new Dimension(100, 40));
        this.btnTrennen.setPreferredSize(new Dimension(100, 40));
        this.btnTrennen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.btnTrennenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnTrennen, gridBagConstraints);
        this.panelEditor.add((Component)this.panelAssign, "cardAssign");
        this.panelOptions.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.panelOptions.setPreferredSize(new Dimension(350, 350));
        this.panelOptions.setLayout(new GridBagLayout());
        this.lblImport.setFont(THEMIS.fontSubheading);
        this.lblImport.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.lblImport.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOptions.add((Component)this.lblImport, gridBagConstraints);
        this.chkCreateObservation.setFont(THEMIS.fontLabel);
        this.chkCreateObservation.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.chkCreateObservation.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOptions.add((Component)this.chkCreateObservation, gridBagConstraints);
        this.fldCreateObservationType.setFont(THEMIS.fontList);
        this.fldCreateObservationType.setModel(new DefaultComboBoxModel());
        this.fldCreateObservationType.setMinimumSize(new Dimension(44, 30));
        this.fldCreateObservationType.setPreferredSize(new Dimension(185, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 25, 5, 5);
        this.panelOptions.add(this.fldCreateObservationType, gridBagConstraints);
        this.chkPreviousMethod.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.chkPreviousMethod.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelOptions.add((Component)this.chkPreviousMethod, gridBagConstraints);
        this.empty1.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.empty1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelOptions.add((Component)this.empty1, gridBagConstraints);
        this.panelEditor.add((Component)this.panelOptions, "cardOptions");
        this.panelTemp.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.chkOnlyWithin.setFont(THEMIS.fontLabel);
        this.chkOnlyWithin.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.chkOnlyWithin.text"));
        this.chkOnlyWithin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.chkOnlyWithinActionPerformed(evt);
            }
        });
        this.chkImportMarker.setFont(THEMIS.fontLabel);
        this.chkImportMarker.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.chkImportMarker.text"));
        this.chkImportMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.chkImportMarkerActionPerformed(evt);
            }
        });
        this.chkCurrentPlanOnly.setFont(THEMIS.fontLabel);
        this.chkCurrentPlanOnly.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.chkCurrentPlanOnly.text"));
        this.chkIncludeNoPlan.setFont(THEMIS.fontLabel);
        this.chkIncludeNoPlan.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.chkIncludeNoPlan.text"));
        GroupLayout panelTempLayout = new GroupLayout(this.panelTemp);
        this.panelTemp.setLayout(panelTempLayout);
        panelTempLayout.setHorizontalGroup(panelTempLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkOnlyWithin, -1, 628, Short.MAX_VALUE).addComponent(this.chkImportMarker, -1, -1, Short.MAX_VALUE).addComponent(this.chkCurrentPlanOnly, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.chkIncludeNoPlan, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        panelTempLayout.setVerticalGroup(panelTempLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTempLayout.createSequentialGroup().addComponent(this.chkOnlyWithin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkImportMarker).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCurrentPlanOnly, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkIncludeNoPlan).addGap(9, 9, 9)));
        this.panelEditor.add((Component)this.panelTemp, "card6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelEditor, gridBagConstraints);
        this.panelButtons.setMinimumSize(new Dimension(100, 50));
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnImport.setFont(THEMIS.fontButton);
        this.btnImport.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_importCAD24.gif")));
        this.btnImport.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnImport.text"));
        this.btnImport.setBorder(new SoftBevelBorder(0));
        this.btnImport.setMinimumSize(new Dimension(150, 40));
        this.btnImport.setPreferredSize(new Dimension(100, 30));
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.btnImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnImport, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontButton);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        this.btnClose.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnClose.text"));
        this.btnClose.setBorder(new SoftBevelBorder(0));
        this.btnClose.setMinimumSize(new Dimension(150, 40));
        this.btnClose.setPreferredSize(new Dimension(100, 30));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
        this.panelButtons1.setMinimumSize(new Dimension(100, 50));
        this.panelButtons1.setLayout(new GridBagLayout());
        this.btnPrevious.setFont(THEMIS.fontButton);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft24.gif")));
        this.btnPrevious.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnPrevious.text"));
        this.btnPrevious.setBorder(new SoftBevelBorder(0));
        this.btnPrevious.setMinimumSize(new Dimension(100, 30));
        this.btnPrevious.setPreferredSize(new Dimension(100, 30));
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.btnPreviousActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelButtons1.add((Component)this.btnPrevious, gridBagConstraints);
        this.btnNext.setFont(THEMIS.fontButton);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        this.btnNext.setText(NbBundle.getMessage(ImportWizard.class, (String)"ImportWizard.btnNext.text"));
        this.btnNext.setBorder(new SoftBevelBorder(0));
        this.btnNext.setHorizontalTextPosition(10);
        this.btnNext.setMinimumSize(new Dimension(100, 30));
        this.btnNext.setPreferredSize(new Dimension(100, 30));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard.this.btnNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelButtons1.add((Component)this.btnNext, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons1, gridBagConstraints);
    }

    private void listTopicValueChanged(ListSelectionEvent evt) {
        this.showWizardPage();
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        int idx = this.listTopic.getSelectedIndex();
        if (idx > 0) {
            this.listTopic.setSelectedIndex(idx - 1);
        }
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        int idx = this.listTopic.getSelectedIndex();
        if (idx < this.listTopic.getModel().getSize() - 1) {
            this.listTopic.setSelectedIndex(idx + 1);
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog(evt);
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        if (this.mapping2.isEmpty()) {
            Dialogs.getInstance().showErrorDialog(this.project.getResourceText("csvimort.nomapping", this.app.getLocale()));
            return;
        }
        try {
            if (this.chkPreviousMethod.isSelected()) {
                this.importLocations();
            } else {
                this.importLocations2();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void btnSelectFileActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        try {
            File f = new ThemisFileDialog(this.bundle.getString("ImportWizard.chooseFile.title"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getDocumentImportFolder(), null, THEMIS.getCsvXlsFilter(), null, false).getSelectedFile();
            if (f == null) {
                return;
            }
            if (!f.isFile() || f.isDirectory()) {
                Dialogs.getInstance().showWarningDialog(this.bundle.getString("MESSAGE_TEMPLATE_NOT_A_FILE"));
                return;
            }
            this.setImportFile(f);
        }
        catch (IOException ex) {
            boolean bl = false;
        }
    }

    private void btnSelectFile1ActionPerformed(ActionEvent evt) {
        ThemisReaderGeneric reader = this.importer.getReader();
        if (reader instanceof ThemisReaderXlsx) {
            ((ThemisReaderXlsx)reader).setRows(Util.parseInt((String)this.fldRowHeader.getText(), (int)1), Util.parseInt((String)this.fldRowData.getText(), (int)1));
        }
        this.app.getSettings().setImportRowHeader(this.fldRowHeader.getText());
        this.app.getSettings().setImportRowData(this.fldRowData.getText());
        this.readFile(this.importFile);
    }

    private void btnZuweisenActionPerformed(ActionEvent evt) {
        if (this.lstColumns.getSelectedIndex() >= 0 && this.lstAttributes.getSelectedIndex() >= 0) {
            this.addMapping((String)this.lstColumns.getSelectedValue(), (AttributeReference)this.lstAttributes.getSelectedValue());
        }
    }

    private void btnTrennenActionPerformed(ActionEvent evt) {
        List sels = this.lstMapping.getSelectedValuesList();
        for (Object sel : sels) {
            this.removeMapping((String)sel);
        }
    }

    private void chkOnlyWithinActionPerformed(ActionEvent evt) {
    }

    private void chkImportMarkerActionPerformed(ActionEvent evt) {
    }

    private void btnZuweisen1ActionPerformed(ActionEvent evt) {
        DefaultListModel m1 = (DefaultListModel)this.lstColumns.getModel();
        DefaultListModel m2 = (DefaultListModel)this.lstAttributes.getModel();
        HashMap<String, AttributeReference> toMap = new HashMap<String, AttributeReference>();
        for (int ii = 0; ii < m1.size(); ++ii) {
            String c = (String)m1.get(ii);
            if (this.mapping2.containsKey(c)) continue;
            for (int jj = 0; jj < m2.size(); ++jj) {
                AttributeReference att = (AttributeReference)m2.get(jj);
                if (att.toString().indexOf(c) < 0) continue;
                toMap.put(c, att);
            }
        }
        for (String k : toMap.keySet()) {
            if (this.mapping2.containsKey(k)) continue;
            this.addMapping(k, (AttributeReference)toMap.get(k));
        }
    }

    private void showExportAssistantStep() {
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog("Import", this, true, true);
        THEMIS.applyWindowSizeAndLocation(DIALOG_CODE, dlg, 800, 800);
        dlg.setVisible(true);
    }

    private void closeDialog(ActionEvent evt) {
        JComponent c = (JComponent)evt.getSource();
        Window w = SwingUtilities.getWindowAncestor(c);
        THEMIS.saveWindowSizeAndLocation(DIALOG_CODE, w);
        w.dispose();
    }

    class LocationCsv
    implements Comparable<LocationCsv> {
        long number;
        String plan;
        long planId;
        String name;
        double x;
        double y;
        String comment;
        double imgX;
        double imgY;
        boolean hasImgCoordinates = false;
        String errormessage = null;
        String quantity;
        String code;
        String code2;

        public LocationCsv(String number, String plan, long planId, String name, String x, String y, String comment, String quantity, String code, String code2) {
            if (x == null || "".equals(x)) {
                this.errormessage = ImportWizard.this.bundle.getString("LocationImportTopComponent.noXDefined.text");
                return;
            }
            if (y == null || "".equals(y)) {
                this.errormessage = ImportWizard.this.bundle.getString("LocationImportTopComponent.noYDefined.text");
                return;
            }
            this.number = number == null || "".equals(number) ? 0L : Long.parseLong(number);
            x = x.replaceAll(",", ".");
            y = y.replaceAll(",", ".");
            if (name == null || "".equals(name)) {
                name = ImportWizard.this.bundle.getString("LocationImportTopComponent.noTitle.text");
            }
            this.name = name;
            this.x = Double.parseDouble(x);
            this.y = Double.parseDouble(y);
            this.comment = comment;
            this.plan = plan == null ? "" : plan;
            this.planId = planId;
            this.quantity = quantity;
            this.code = code;
            this.code2 = code2;
        }

        public LocationCsv(String name, double x, double y, String c) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.comment = c;
        }

        public String getErrorMessage() {
            return this.errormessage;
        }

        public String toString() {
            return (this.hasImgCoordinates ? "(*) " : "") + "[" + this.number + "] " + ("".equals(this.plan) ? "" : this.plan + ":") + this.name;
        }

        public void setImageCoordinates(double x, double y) {
            this.imgX = x;
            this.imgY = y;
            this.hasImgCoordinates = true;
        }

        @Override
        public int compareTo(LocationCsv o) {
            if (this.number == o.number) {
                return this.name.compareTo(o.name);
            }
            return o.number < this.number ? -1 : 1;
        }
    }

    class ConfigurationTopic {
        int number;
        String displayLabel;
        String panelName;

        public ConfigurationTopic(String panelName, int number, String display) {
            this.displayLabel = display;
            this.panelName = panelName;
            this.number = number;
        }

        public String toString() {
            return (this.number > 0 ? this.number + ". " : "") + this.displayLabel;
        }
    }
}

