/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.io.importer.ImportTarget;
import at.grid.themis.application.io.importer.LocationObservationImportTarget;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.importer.AttributeReference;
import at.grid.themis.ontology.importer.ThemisReaderCsv;
import at.grid.themis.ontology.importer.ThemisReaderGeneric;
import at.grid.themis.ontology.importer.ThemisReaderXlsx;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ImportWizard2
extends JPanel {
    public static String DIALOG_CODE = "importwizard";
    public static final int DIALOG_WIDTH = 800;
    public static final int DIALOG_HEIGHT = 800;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/io/importer/Bundle");
    ThemisSettings settings = this.app.getSettings();
    long planId = -1L;
    HashMap<String, Long> planMapping = new HashMap();
    HashMap<String, String> columnMapping = new HashMap();
    boolean hasPlanColumn = false;
    boolean waitingForPoint = false;
    ArrayList<String> columns = new ArrayList();
    private File importFile;
    private ImportTarget target;
    private JButton btnClose;
    private JButton btnImport;
    private JButton btnSelectFile;
    private JButton btnSelectFile1;
    private JButton btnTrennen;
    private JButton btnZuweisen;
    private JButton btnZuweisen1;
    private JTextField fldFilename;
    private JComboBox<String> fldMappingAttribute;
    private JTextField fldRowData;
    private JTextField fldRowHeader;
    private JComboBox<String> fldSheet;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel52;
    private JLabel jLabel6;
    private JLabel jLabel62;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JLabel lblSheet;
    private JList<AttributeReference> lstAttributes;
    private JList lstColumns;
    private JList lstMapping;
    private JPanel panelAssign;
    private JPanel panelButtons;
    private JPanel panelEditor;
    private JPanel panelFileXlsx;
    private JPanel panelMappingAttribute;

    public ImportWizard2(ImportTarget t) {
        this.initComponents();
        this.fldRowHeader.setText(this.app.getSettings().getImportRowHeader());
        this.fldRowData.setText(this.app.getSettings().getImportRowData());
        this.panelFileXlsx.setVisible(false);
        new DropTarget(this.fldFilename, new ThemisDropTargetListener(false, false, new String[]{"xlsx", "txt", "csv"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                try {
                    ImportWizard2.this.setImportFile(f);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.target = t;
        this.panelMappingAttribute.setVisible(this.target instanceof LocationObservationImportTarget);
    }

    private void updateMappingList() {
        DefaultListModel m = (DefaultListModel)this.lstMapping.getModel();
        m.removeAllElements();
        for (int ii = 0; ii < this.columns.size(); ++ii) {
            if (!this.target.getMapping().containsKey(ii)) continue;
            m.addElement(this.columns.get(ii) + " -> " + this.target.getMapping().get(ii));
        }
    }

    private void updateObjectList() {
        this.lstAttributes.setModel(this.target.getObjectListModel());
    }

    private void updateColumnList() {
        DefaultListModel m = (DefaultListModel)this.lstColumns.getModel();
        m.removeAllElements();
        for (int ii = 0; ii < this.columns.size(); ++ii) {
            if (this.target.getMapping().containsKey(ii)) continue;
            m.addElement(this.columns.get(ii));
        }
    }

    public void updateLists() {
        this.updateColumnList();
        this.updateObjectList();
        this.updateMappingList();
    }

    private void setImportFile(File f) throws IOException {
        if (f == null || !f.isFile()) {
            return;
        }
        this.app.setDocumentImportFolder(f.getParentFile());
        this.importFile = f;
        String fn = f.getName().toLowerCase();
        if (f.getName().toLowerCase().endsWith(".xlsx")) {
            this.panelFileXlsx.setVisible(true);
            int rowHeader = Util.parseInt((String)this.fldRowHeader.getText(), (int)1);
            int rowData = Util.parseInt((String)this.fldRowData.getText(), (int)2);
            ThemisReaderXlsx r = new ThemisReaderXlsx(rowHeader, rowData);
            this.fldSheet.removeAllItems();
            ArrayList names = r.getSheetNames(f);
            for (String n : names) {
                this.fldSheet.addItem(n);
            }
            if (!names.isEmpty()) {
                this.fldSheet.setSelectedIndex(0);
            }
            this.target.setReader((ThemisReaderGeneric)r);
        } else {
            this.panelFileXlsx.setVisible(false);
            this.target.setReader((ThemisReaderGeneric)new ThemisReaderCsv());
        }
        this.readFile(f);
        this.fldFilename.setText(f.getAbsolutePath());
    }

    private void readFile(File f) {
        try {
            this.target.getReader().setSheet(this.fldSheet.getSelectedIndex());
            this.target.getReader().readFile(f);
            this.columns.clear();
            this.target.clear();
            for (String col : this.target.getReader().getHeader()) {
                this.columns.add(col);
            }
            this.updateLists();
            if (this.columns.isEmpty()) {
                Dialogs.getInstance().showErrorDialog("error.import.noContent");
            }
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog("error.fileCannotBeDeleted");
        }
    }

    public void getWindowSizeAndLocation() {
        Dimension windowSize = THEMIS.getWindowSize("reportpanel", this.app);
        if (windowSize != null) {
            this.setSize(windowSize);
            this.setPreferredSize(windowSize);
        }
    }

    private void initComponents() {
        this.panelEditor = new JPanel();
        this.jLabel23 = new JLabel();
        this.jLabel49 = new JLabel();
        this.fldFilename = new JTextField();
        this.btnSelectFile = new JButton();
        this.panelFileXlsx = new JPanel();
        this.lblSheet = new JLabel();
        this.jLabel52 = new JLabel();
        this.jLabel62 = new JLabel();
        this.fldSheet = new JComboBox();
        this.fldRowHeader = new JTextField();
        this.fldRowData = new JTextField();
        this.btnSelectFile1 = new JButton();
        this.panelAssign = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstColumns = new JList();
        this.jScrollPane4 = new JScrollPane();
        this.lstAttributes = new JList();
        this.btnZuweisen1 = new JButton();
        this.btnZuweisen = new JButton();
        this.jLabel5 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.lstMapping = new JList();
        this.btnTrennen = new JButton();
        this.panelMappingAttribute = new JPanel();
        this.jLabel3 = new JLabel();
        this.fldMappingAttribute = new JComboBox();
        this.jLabel1 = new JLabel();
        this.panelButtons = new JPanel();
        this.btnImport = new JButton();
        this.btnClose = new JButton();
        this.setMinimumSize(new Dimension(900, 600));
        this.setPreferredSize(new Dimension(900, 600));
        this.setLayout(new GridBagLayout());
        this.panelEditor.setLayout(new GridBagLayout());
        this.jLabel23.setFont(THEMIS.fontSubheading);
        this.jLabel23.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel23.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEditor.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel49.setFont(THEMIS.fontLabel);
        this.jLabel49.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel49.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEditor.add((Component)this.jLabel49, gridBagConstraints);
        this.fldFilename.setEditable(false);
        this.fldFilename.setFont(THEMIS.fontTextfield);
        this.fldFilename.setHorizontalAlignment(2);
        this.fldFilename.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.fldFilename.text"));
        this.fldFilename.setMinimumSize(new Dimension(5, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEditor.add((Component)this.fldFilename, gridBagConstraints);
        this.btnSelectFile.setFont(THEMIS.fontButton);
        this.btnSelectFile.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnSelectFile.text"));
        this.btnSelectFile.setBorder(new SoftBevelBorder(0));
        this.btnSelectFile.setMinimumSize(null);
        this.btnSelectFile.setPreferredSize(null);
        this.btnSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard2.this.btnSelectFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelEditor.add((Component)this.btnSelectFile, gridBagConstraints);
        this.panelFileXlsx.setLayout(new GridBagLayout());
        this.lblSheet.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.lblSheet.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelFileXlsx.add((Component)this.lblSheet, gridBagConstraints);
        this.jLabel52.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel52.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelFileXlsx.add((Component)this.jLabel52, gridBagConstraints);
        this.jLabel62.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel62.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelFileXlsx.add((Component)this.jLabel62, gridBagConstraints);
        this.fldSheet.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.fldSheet.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add(this.fldSheet, gridBagConstraints);
        this.fldRowHeader.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.fldRowHeader.text"));
        this.fldRowHeader.setMinimumSize(new Dimension(100, 30));
        this.fldRowHeader.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.fldRowHeader, gridBagConstraints);
        this.fldRowData.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.fldRowData.text"));
        this.fldRowData.setMinimumSize(new Dimension(100, 30));
        this.fldRowData.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.fldRowData, gridBagConstraints);
        this.btnSelectFile1.setFont(THEMIS.fontButton);
        this.btnSelectFile1.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnSelectFile1.text"));
        this.btnSelectFile1.setBorder(new SoftBevelBorder(0));
        this.btnSelectFile1.setMinimumSize(null);
        this.btnSelectFile1.setPreferredSize(null);
        this.btnSelectFile1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard2.this.btnSelectFile1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFileXlsx.add((Component)this.btnSelectFile1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panelEditor.add((Component)this.panelFileXlsx, gridBagConstraints);
        this.panelAssign.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.panelAssign.setPreferredSize(new Dimension(350, 486));
        this.panelAssign.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontSubheading);
        this.jLabel2.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        this.jLabel7.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        this.jLabel6.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel6, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(10, 20));
        this.jScrollPane1.setPreferredSize(new Dimension(180, 119));
        this.lstColumns.setFont(THEMIS.fontList);
        this.lstColumns.setModel(new DefaultListModel());
        this.lstColumns.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lstColumns);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelAssign.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane4.setMinimumSize(new Dimension(10, 20));
        this.jScrollPane4.setPreferredSize(new Dimension(180, 119));
        this.lstAttributes.setFont(THEMIS.fontList);
        this.lstAttributes.setModel(new DefaultListModel());
        this.lstAttributes.setSelectionMode(0);
        this.jScrollPane4.setViewportView(this.lstAttributes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelAssign.add((Component)this.jScrollPane4, gridBagConstraints);
        this.btnZuweisen1.setFont(THEMIS.fontButton);
        this.btnZuweisen1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/connect32.gif")));
        this.btnZuweisen1.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnZuweisen1.text"));
        this.btnZuweisen1.setToolTipText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnZuweisen1.toolTipText"));
        this.btnZuweisen1.setBorder(new SoftBevelBorder(0));
        this.btnZuweisen1.setMinimumSize(new Dimension(100, 40));
        this.btnZuweisen1.setPreferredSize(new Dimension(100, 40));
        this.btnZuweisen1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard2.this.btnZuweisen1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnZuweisen1, gridBagConstraints);
        this.btnZuweisen.setFont(THEMIS.fontButton);
        this.btnZuweisen.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/connect32.gif")));
        this.btnZuweisen.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnZuweisen.text"));
        this.btnZuweisen.setToolTipText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnZuweisen.toolTipText"));
        this.btnZuweisen.setBorder(new SoftBevelBorder(0));
        this.btnZuweisen.setMinimumSize(new Dimension(100, 40));
        this.btnZuweisen.setPreferredSize(new Dimension(100, 40));
        this.btnZuweisen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard2.this.btnZuweisenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnZuweisen, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontSubheading);
        this.jLabel5.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.jLabel5, gridBagConstraints);
        this.jScrollPane5.setMinimumSize(new Dimension(10, 20));
        this.lstMapping.setFont(THEMIS.fontList);
        this.lstMapping.setModel(new DefaultListModel());
        this.jScrollPane5.setViewportView(this.lstMapping);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.panelAssign.add((Component)this.jScrollPane5, gridBagConstraints);
        this.btnTrennen.setFont(THEMIS.fontButton);
        this.btnTrennen.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        this.btnTrennen.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnTrennen.text"));
        this.btnTrennen.setToolTipText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnTrennen.toolTipText"));
        this.btnTrennen.setBorder(new SoftBevelBorder(0));
        this.btnTrennen.setMaximumSize(new Dimension(500, 40));
        this.btnTrennen.setMinimumSize(new Dimension(100, 40));
        this.btnTrennen.setPreferredSize(new Dimension(100, 40));
        this.btnTrennen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard2.this.btnTrennenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelAssign.add((Component)this.btnTrennen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelEditor.add((Component)this.panelAssign, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panelEditor, gridBagConstraints);
        this.panelMappingAttribute.setLayout(new GridBagLayout());
        this.jLabel3.setFont(THEMIS.fontSubheading);
        this.jLabel3.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelMappingAttribute.add((Component)this.jLabel3, gridBagConstraints);
        this.fldMappingAttribute.setModel(new DefaultComboBoxModel<String>(new String[]{"-", "Titel", "UUID"}));
        this.fldMappingAttribute.setSelectedIndex(2);
        this.fldMappingAttribute.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelMappingAttribute.add(this.fldMappingAttribute, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabelSmall);
        this.jLabel1.setForeground(new Color(153, 153, 153));
        this.jLabel1.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelMappingAttribute.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.panelMappingAttribute, gridBagConstraints);
        this.panelButtons.setMinimumSize(new Dimension(100, 50));
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnImport.setFont(THEMIS.fontButton);
        this.btnImport.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_importCAD24.gif")));
        this.btnImport.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnImport.text"));
        this.btnImport.setBorder(new SoftBevelBorder(0));
        this.btnImport.setMinimumSize(new Dimension(150, 40));
        this.btnImport.setPreferredSize(new Dimension(100, 30));
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard2.this.btnImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnImport, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontButton);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        this.btnClose.setText(NbBundle.getMessage(ImportWizard2.class, (String)"ImportWizard2.btnClose.text"));
        this.btnClose.setBorder(new SoftBevelBorder(0));
        this.btnClose.setMinimumSize(new Dimension(150, 40));
        this.btnClose.setPreferredSize(new Dimension(100, 30));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportWizard2.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog(evt);
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        if (this.target.getMapping().isEmpty()) {
            Dialogs.getInstance().showErrorDialog(this.project.getResourceText("csvimort.nomapping", this.app.getLocale()));
            return;
        }
        if (this.target instanceof LocationObservationImportTarget) {
            int idx = this.fldMappingAttribute.getSelectedIndex();
            switch (idx) {
                case 0: {
                    ((LocationObservationImportTarget)this.target).setMappingAttribute(LocationObservationImportTarget.Mapping.NONE);
                    break;
                }
                case 1: {
                    ((LocationObservationImportTarget)this.target).setMappingAttribute(LocationObservationImportTarget.Mapping.TITLE);
                    break;
                }
                case 2: {
                    ((LocationObservationImportTarget)this.target).setMappingAttribute(LocationObservationImportTarget.Mapping.UUID);
                }
            }
        }
        this.target.runImportWithProgress();
    }

    private void btnSelectFileActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        try {
            File f = new ThemisFileDialog(this.bundle.getString("ImportWizard2.chooseFile.title"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getDocumentImportFolder(), null, THEMIS.getCsvXlsFilter(), null, false).getSelectedFile();
            if (f == null) {
                return;
            }
            if (!f.isFile() || f.isDirectory()) {
                Dialogs.getInstance().showWarningDialog(this.bundle.getString("MESSAGE_TEMPLATE_NOT_A_FILE"));
                return;
            }
            this.setImportFile(f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void btnSelectFile1ActionPerformed(ActionEvent evt) {
        ThemisReaderGeneric reader = this.target.getReader();
        if (reader instanceof ThemisReaderXlsx) {
            ((ThemisReaderXlsx)reader).setRows(Util.parseInt((String)this.fldRowHeader.getText(), (int)1), Util.parseInt((String)this.fldRowData.getText(), (int)1));
        }
        this.app.getSettings().setImportRowHeader(this.fldRowHeader.getText());
        this.app.getSettings().setImportRowData(this.fldRowData.getText());
        this.readFile(this.importFile);
    }

    private void btnZuweisenActionPerformed(ActionEvent evt) {
        if (this.lstColumns.getSelectedIndex() >= 0 && this.lstAttributes.getSelectedIndex() >= 0) {
            String sel = (String)this.lstColumns.getSelectedValue();
            this.target.addMapping(this.columns.indexOf(sel), this.lstAttributes.getSelectedValue());
            this.updateLists();
        }
    }

    private void btnTrennenActionPerformed(ActionEvent evt) {
        List sels = this.lstMapping.getSelectedValuesList();
        for (Object sel : sels) {
            String[] split = ((String)sel).split(" -> ");
            if (split.length <= 1) continue;
            this.target.removeMapping(this.columns.indexOf(split[0]));
        }
        this.updateLists();
    }

    private void btnZuweisen1ActionPerformed(ActionEvent evt) {
        this.target.autoMap();
        this.updateLists();
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog("Import", this, true, true);
        THEMIS.applyWindowSizeAndLocation(DIALOG_CODE, dlg, 800, 800);
        dlg.setVisible(true);
    }

    private void closeDialog(ActionEvent evt) {
        JComponent c = (JComponent)evt.getSource();
        Window w = SwingUtilities.getWindowAncestor(c);
        THEMIS.saveWindowSizeAndLocation(DIALOG_CODE, w);
        w.dispose();
    }
}

