/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer;

import at.grid.cms.content.Keytable;
import at.grid.cms.content.UploadItem;
import at.grid.cms.storage.DataRecord;
import at.grid.gui.Dialogs;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.project.ProjectHelper;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsLocationTemplate;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.util.Util;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class KevoxImporter {
    File dbfile;
    File templatefile;
    HashMap<String, File> files;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    String buildingUUID = null;
    long buildingId = -1L;
    HashMap<String, Long> planId = new HashMap();
    HashMap<String, PlanPosition> objektPosition = new HashMap();
    HashMap<String, Document> document = new HashMap();
    HashMap<String, Document> document2 = new HashMap();
    HashMap<String, ArrayList<String>> taskHistory = new HashMap();
    HashMap<String, Long> locationId = new HashMap();
    HashMap<String, Long> observationId = new HashMap();
    HashMap<String, CmsEvent> event = new HashMap();
    HashMap<String, Long> locationTemplates = new HashMap();
    HashMap<String, Properties> objectVariable = new HashMap();
    HashMap<Long, ArrayList<Long>> locationObservation = new HashMap();
    HashMap<String, String> responsible = new HashMap();
    ArrayList<String> deleted = new ArrayList();
    ArrayList<CmsObservation> observations = new ArrayList();
    boolean importAll = false;

    public KevoxImporter(File f, File template, boolean importAll) {
        this.dbfile = f;
        this.templatefile = template;
        this.importAll = importAll;
    }

    public void importFromFile() throws IOException, InvalidFormatException {
        int counter = 1;
        this.app.getActionProvider().setActive(false);
        ArrayList<String> errors = new ArrayList<String>();
        if (this.importAll) {
            File root = this.dbfile.getParentFile();
            for (File f : root.listFiles()) {
                File fld;
                if (!f.isFile() || !f.getName().toLowerCase().endsWith(".xls")) continue;
                String fn = Util.getFileNameWithoutExtension((File)f);
                if (f.getName().toLowerCase().startsWith("kevox_")) {
                    fn = fn.substring(6);
                }
                if (!(fld = new File(root, fn)).isDirectory()) {
                    this.project.getLogger().info("ERROR: Folder not found: " + fld.getName());
                    errors.add(fld.getName() + " - Projektordner nicht gefunden");
                } else {
                    try {
                        if (this.app.getProject().isOpen()) {
                            ProjectHelper.closeProject(new Closing());
                        }
                        this.importFromFile(f, fld, counter);
                    }
                    catch (Exception e) {
                        errors.add(fld.getName() + " - Fehler beim Import: " + e.getMessage());
                    }
                }
                ++counter;
            }
        } else {
            try {
                this.importFromFile(this.dbfile, this.dbfile.getParentFile(), counter);
            }
            catch (Exception e) {
                Dialogs.showErrorDialog((String)("ERROR: " + e.getMessage()), (Exception)e);
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Folgende Projekte konnten nicht importiert werden:");
            for (String err : errors) {
                sb.append("\n- ").append(err);
            }
        }
        if (!this.app.getActionProvider().isActive()) {
            this.app.getActionProvider().setActive(true);
            this.app.getActionProvider().invokeAction(ThemisAction.PROJECT_OPENED);
        }
        Dialogs.showInfoDialog((String)"Import fertig");
    }

    public void importFromFile(File databasefile, File folder, int projectcount) throws IOException, InvalidFormatException {
        String val;
        int row;
        String oUUID;
        String plan;
        String ol_crc;
        int row2;
        ThemisProgressHandler p = new ThemisProgressHandler("KEVOX Projekt importieren", 100);
        p.switchToDeterminate(100);
        this.buildingUUID = null;
        this.buildingId = -1L;
        this.planId.clear();
        this.objektPosition.clear();
        this.document.clear();
        this.document2.clear();
        this.taskHistory.clear();
        this.locationId.clear();
        this.observationId.clear();
        this.event.clear();
        this.locationTemplates.clear();
        this.objectVariable.clear();
        this.locationObservation.clear();
        this.deleted.clear();
        this.observations.clear();
        this.project.getLogger().info("####################################################");
        this.project.getLogger().info("Start importing KEVOX #" + projectcount);
        this.project.getLogger().info("####################################################");
        p.progress("Vorbereitungen #" + projectcount, 1);
        this.files = this.getFileReferences(folder);
        Workbook wb = WorkbookFactory.create((File)databasefile);
        String projectFilename = null;
        boolean closeAfterImport = false;
        p.progress("Projekt anlegen #" + projectcount, 2);
        Sheet sheet = wb.getSheet("s_Setting");
        HashMap<String, Integer> columns = this.getColumns(sheet);
        int lastRow = sheet.getLastRowNum() + 1;
        for (int row3 = 2; row3 <= lastRow; ++row3) {
            String ss_Var = this.getCellValue(sheet, row3, columns.get("ss_Var"));
            String ss_Val = this.getCellValue(sheet, row3, columns.get("ss_Val"));
            if (!"$159003".equals(ss_Var)) continue;
            projectFilename = ss_Val;
        }
        projectFilename = projectFilename.replaceAll(";", ",");
        sheet = wb.getSheet("a_Company");
        columns = this.getColumns(sheet);
        int addressRow = lastRow = sheet.getLastRowNum() + 1;
        for (int row4 = 2; row4 <= lastRow; ++row4) {
            if (!"---".equals(this.getCellValue(sheet, row4, columns.get("ac_Company")))) continue;
            addressRow = row4;
        }
        String projectNumber = this.getCellValue(sheet, addressRow, columns.get("ac_ID"));
        String projectTitle = projectNumber + "-" + projectFilename;
        String projectAddress = this.getCellValue(sheet, addressRow, columns.get("ac_Street")) + "\n" + this.getCellValue(sheet, addressRow, columns.get("ac_ZIP")) + " " + this.getCellValue(sheet, addressRow, columns.get("ac_City"));
        this.project.getLogger().info("KEVOX UUID " + folder.getName() + " -> " + projectTitle);
        this.project.getLogger().info("####################################################");
        if (!projectTitle.toLowerCase().startsWith("ger-wnd")) {
            return;
        }
        if (!this.app.getProject().isOpen()) {
            closeAfterImport = true;
            int counter = 2;
            Object projectfolder = new File(this.app.getSettings().getFolderProjectRoot().getValue(true), projectTitle);
            while (((File)projectfolder).exists()) {
                projectfolder = new File(this.app.getSettings().getFolderProjectRoot().getValue(true), projectTitle + " v" + counter);
                ++counter;
            }
            ThemisProject prj = this.app.createProject((File)projectfolder, null, false);
            if (this.templatefile != null) {
                prj.getTemplateManger().setIgnoreDisclaimer(true);
                prj.getTemplateManger().loadTemplate(this.templatefile);
                prj.getTemplateManger().setIgnoreDisclaimer(false);
            }
            prj.getProjectElement().setAttributeValue("projecttitle", projectNumber);
            prj.getProjectElement().setAttributeValue("projectnumber", projectTitle);
            prj.getProjectElement().setAttributeValue("customer", "ThyssenKrupp Business Services GmbH\nThyssenKrupp Allee 1\n45143 Essen");
            prj.getProjectElement().setAttributeValue("info", "");
            prj.getProjectElement().setAttributeValue("projectlocation", projectAddress);
            prj.getProjectElement().save();
            this.app.getSettings().getFolderOpenProject().setValue((File)projectfolder);
            this.app.loadProject((File)projectfolder, false, false, false, null, null);
        }
        List recs = this.project.getDatastorage().executeQuery("SELECT idelement,titel FROM tdtaelelocationtemplate", true).getResult();
        for (DataRecord rec : recs) {
            this.locationTemplates.put(rec.getString("titel"), rec.getLong("idelement"));
        }
        p.progress(5);
        Keytable keytableList1 = this.project.getKeytable("list1");
        Keytable keytableList2 = this.project.getKeytable("list2");
        Keytable keytableDocumenttype = this.project.getKeytable("documenttype");
        Keytable keytablePriority = this.project.getKeytable("priority");
        p.progress("Geb\u00e4ude erzeugen #" + projectcount, 2);
        sheet = wb.getSheet("o_Location");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        this.project.getLogger().info("Reading buidlings and plans ... ");
        int buildingcount = 1;
        for (row2 = 2; row2 <= lastRow; ++row2) {
            ol_crc = this.getCellValue(sheet, row2, columns.get("ol_CRC"));
            plan = this.getCellValue(sheet, row2, columns.get("ol_UUID_Plan"));
            if ("1414".equals(ol_crc) || !"".equals(plan)) continue;
            String building = this.getCellValue(sheet, row2, columns.get("ol_Class_Description"));
            if ("".equals(building)) {
                building = "Geb\u00e4ude " + buildingcount;
            }
            CmsLocation loc = (CmsLocation)this.project.createElement("location");
            loc.setAsBuilding();
            loc.setAttributeValue("title", building);
            loc.save();
            this.project.getLogger().info("#### BUILDING created: " + loc.getTitle());
            this.buildingId = loc.getId();
            this.buildingUUID = this.getCellValue(sheet, row2, columns.get("ol_UUID"));
            ++buildingcount;
        }
        p.progress("Pl\u00e4ne laden #" + projectcount, 3);
        for (row2 = 2; row2 <= lastRow; ++row2) {
            String planfilename;
            File planfile;
            ol_crc = this.getCellValue(sheet, row2, columns.get("ol_CRC"));
            plan = this.getCellValue(sheet, row2, columns.get("ol_UUID_Plan"));
            if (!"1414".equals(ol_crc) || "".equals(plan) || (planfile = this.getPlanFile(planfilename = this.getFileCode(plan))) == null) continue;
            String plantitle = this.getCellValue(sheet, row2, columns.get("ol_Class_2"));
            if ("".equals(plantitle)) {
                plantitle = this.getCellValue(sheet, row2, columns.get("ol_Class_1"));
            }
            CmsPlan planElement = this.project.createPlan(this.buildingId);
            planElement.setAttributeValue("title", plantitle);
            BufferedImage image = ImageIO.read(planfile);
            int imageWidth = image.getWidth();
            File tempfile = new File(this.app.getProject().getTempfileLocation(), Util.getFileNameWithoutExtension((File)planfile) + ".jpg");
            ImageIO.write((RenderedImage)Util.resizeImage((BufferedImage)image, (int)((int)((double)imageWidth * 0.5))), "jpg", tempfile);
            planElement.addPlanFile(tempfile, null, null, new Date());
            planElement.save();
            this.planId.put(this.getCellValue(sheet, row2, columns.get("ol_UUID")), planElement.getId());
            this.project.getLogger().info("#### PLAN created: " + planElement.getTitle());
        }
        p.progress("Kontakte laden", 4);
        this.project.getLogger().info("Reading contacts ... ");
        sheet = wb.getSheet("a_Competent");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        for (row2 = 2; row2 <= lastRow; ++row2) {
            String contactUUID = this.getCellValue(sheet, row2, columns.get("act_aclUUID"));
            String contactCode = this.getCellValue(sheet, row2, columns.get("act_Task"));
            this.responsible.put(contactUUID, contactCode);
        }
        p.progress("Sonstige Variablen lesen #" + projectcount, 5);
        this.project.getLogger().info("Reading additional variables ... ");
        sheet = wb.getSheet("o_Object_Var");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        for (row2 = 2; row2 <= lastRow; ++row2) {
            oUUID = this.getCellValue(sheet, row2, columns.get("oov_OUID"));
            Properties props = this.objectVariable.get(oUUID);
            if (props == null) {
                props = new Properties();
            }
            String propVal = this.getCellValue(sheet, row2, columns.get("oov_Val"));
            String propKey = this.getCellValue(sheet, row2, columns.get("oov_Var"));
            if (!"".equals(propVal)) {
                props.setProperty(propKey, propVal);
            }
            this.objectVariable.put(oUUID, props);
        }
        p.progress("Gel\u00f6schte Daten lesen #" + projectcount, 6);
        this.project.getLogger().info("Reading deleted objects ... ");
        sheet = wb.getSheet("h_History");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        for (row2 = 2; row2 <= lastRow; ++row2) {
            if (!this.getCellValue(sheet, row2, columns.get("hh_Txt")).contains("gel\u00f6scht  |")) continue;
            this.deleted.add(this.getCellValue(sheet, row2, columns.get("hh_ObjID")));
        }
        p.progress("Positionen lesen #" + projectcount, 7);
        this.project.getLogger().info("Reading location positions ... ");
        sheet = wb.getSheet("o_Object_Position");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        for (row2 = 2; row2 <= lastRow; ++row2) {
            oUUID = this.getCellValue(sheet, row2, columns.get("oop_OUID"));
            String planUUID = this.getCellValue(sheet, row2, columns.get("oop_LUID"));
            PlanPosition pos = new PlanPosition();
            pos.idplan = this.planId.get(planUUID);
            pos.x1 = Integer.parseInt(this.getCellValue(sheet, row2, columns.get("oop_X1"))) / 2;
            pos.y1 = Integer.parseInt(this.getCellValue(sheet, row2, columns.get("oop_Y1"))) / 2;
            pos.x2 = Integer.parseInt(this.getCellValue(sheet, row2, columns.get("oop_X2"))) / 2;
            pos.y2 = Integer.parseInt(this.getCellValue(sheet, row2, columns.get("oop_Y2"))) / 2;
            pos.xline = Integer.parseInt(this.getCellValue(sheet, row2, columns.get("oop_LineX"))) / 2;
            pos.yline = Integer.parseInt(this.getCellValue(sheet, row2, columns.get("oop_LineY"))) / 2;
            this.objektPosition.put(oUUID, pos);
        }
        this.project.getLogger().info("#### Number of positions: " + this.objektPosition.size());
        this.project.getLogger().info("Reading files ... ");
        sheet = wb.getSheet("h_History_Doc");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        for (row2 = 2; row2 <= lastRow; ++row2) {
            String uuid = this.getCellValue(sheet, row2, columns.get("hhd_HUID"));
            Document d = new Document();
            d.doctype = this.getCellValue(sheet, row2, columns.get("hhd_DocTyp"));
            d.uuid = this.getCellValue(sheet, row2, columns.get("hhd_UUID"));
            d.dt = this.getCellValue(sheet, row2, columns.get("hhd_DocDate"));
            d.filename = this.getCellValue(sheet, row2, columns.get("hhd_DocFile"));
            this.document.put(this.getFileCode(uuid), d);
            this.document2.put(this.getFileCode(d.uuid), d);
        }
        this.project.getLogger().info("#### Number of documents: " + this.document.size());
        p.progress("Gegenst\u00e4nde anlegen #" + projectcount, 8);
        this.project.getLogger().info("Reading locations ... ");
        sheet = wb.getSheet("o_Object");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        for (row2 = 2; row2 <= lastRow; ++row2) {
            Properties props;
            Long templateId;
            int objecttype = Integer.parseInt(this.getCellValue(sheet, row2, columns.get("oo_Class_ID")));
            String docclass = this.getCellValue(sheet, row2, columns.get("oo_Class_2"));
            String oUUID2 = this.getCellValue(sheet, row2, columns.get("oo_UUID"));
            if (this.deleted.contains(oUUID2) || objecttype == 1010) continue;
            if (objecttype == 1500 && !"foto".equalsIgnoreCase(docclass)) {
                String doctitle = this.getCellValue(sheet, row2, columns.get("oo_Class_3"));
                String docdesc = this.getCellValue(sheet, row2, columns.get("oo_Description"));
                String doctype = this.getCellValue(sheet, row2, columns.get("oo_Class_3"));
                long docid = keytableList2.getIdByTermAndCreate(doctype, this.project.getPrimaryLang());
                CmsInfo info = (CmsInfo)this.project.createElement("info");
                info.setAttributeValue("title", doctitle);
                info.setAttributeValue("date", "");
                info.setAttributeValue("comment", docdesc);
                info.getKeyAttribute("documenttype").setValue(docid);
                String dUUID = this.getCellValue(sheet, row2, columns.get("oo_UUID"));
                String foldername = this.getFileCode(dUUID);
                for (File f : this.files.values()) {
                    String fn;
                    Document d;
                    if (!f.getParentFile().getName().equals(foldername) || (d = this.document2.get(fn = Util.getFileNameWithoutExtension((File)f))) == null) continue;
                    File tempfile = new File(this.app.getProject().getTempfileLocation(), d.filename + d.doctype);
                    Util.copy((File)f, (File)tempfile);
                    info.getUploadAttribute("files").addUpload(tempfile);
                }
                info.save();
                continue;
            }
            String contactUUID = this.getCellValue(sheet, row2, columns.get("oo_CUser"));
            CmsLocation loc = (CmsLocation)this.project.createElement("location");
            String locTitle = this.getCellValue(sheet, row2, columns.get("oo_Class_3"));
            loc.setAttributeValue("title", locTitle);
            PlanPosition pos = this.objektPosition.get(oUUID2);
            if (pos != null) {
                loc.getRelationAttribute("plan").set(pos.idplan);
                SimpleGeometry pt = new SimpleGeometry(1);
                SimpleGeometry ptlbl = new SimpleGeometry(1);
                if (pos.x2 != 0 && pos.y2 != 0) {
                    pt.add((double)pos.x2, (double)pos.y2);
                } else {
                    pt.add((double)pos.x1, (double)pos.y1);
                }
                ptlbl.add((double)pos.xline, (double)pos.yline);
                loc.setAttributeValue("position", pos.xline == 0 ? pt.toWKT() : ptlbl.toWKT());
            }
            if ((templateId = this.locationTemplates.get(locTitle)) != null) {
                CmsLocationTemplate template = (CmsLocationTemplate)this.project.loadElement(templateId.longValue(), this.project.getUser());
                template.applyTo(loc);
            }
            if ((props = this.objectVariable.get(oUUID2)) != null) {
                String company = props.getProperty("company");
                String product = props.getProperty("product");
                String locDescription = (company != null && !"".equals(company) ? "Hersteller: " + company + "\n" : "") + (product != null && !"".equals(product) ? "Produkt: " + product : "");
                if (!"".equals(company)) {
                    long id = keytableList1.getIdByTermAndCreate(company, this.project.getPrimaryLang());
                    loc.getKeyAttribute("list1").setValue(id);
                }
                if (!"".equals(product)) {
                    long id = keytableList2.getIdByTermAndCreate(product, this.project.getPrimaryLang());
                    loc.getKeyAttribute("list2").setValue(id);
                }
            }
            loc.setAttributeValue("code", this.getCellValue(sheet, row2, columns.get("oo_MyID")));
            this.locationId.put(oUUID2, loc.getId());
            loc.save();
            int interval = Integer.parseInt(this.getCellValue(sheet, row2, columns.get("oo_DT1_Interval")));
            CmsObservation o = null;
            if (interval > 0) {
                String dt = this.getCellValue(sheet, row2, columns.get("oo_CDT"));
                CmsEvent ev = null;
                if (this.event.containsKey(dt)) {
                    ev = this.event.get(dt);
                } else {
                    ev = (CmsEvent)this.project.createElement("event");
                    ev.setAttributeValue("date", dt);
                    ev.setAttributeValue("title", "Erfassung");
                    ev.save();
                    this.event.put(dt, ev);
                }
                this.project.setCurrentEvent(ev);
                o = (CmsObservation)this.project.createElement("observation");
                o.setAttributeValue("title", "Wartungsnachweis");
                o.setAttributeValue("description", "N\u00e4chster Service bzw. n\u00e4chste Inspektion");
                o.getKeyAttribute("type").setValue(2L);
                if (interval == 720) {
                    o.setAttributeValue("repeatcount", "2");
                    o.getKeyAttribute("repeat").setValue(4L);
                } else if (interval == 360) {
                    o.setAttributeValue("repeatcount", "1");
                    o.getKeyAttribute("repeat").setValue(4L);
                } else {
                    o.setAttributeValue("repeatcount", Integer.toString(interval));
                    o.getKeyAttribute("repeat").setValue(1L);
                }
                o.setAttributeValue("duedate", this.getCellValue(sheet, row2, columns.get("oo_DT1_Next")));
                o.setLocation(loc);
                o.setNumber(loc.getNextObservationNumber());
                o.save();
            }
            this.project.getLogger().info("#### Location created: " + loc.getTitle() + " ... " + (pos != null ? "with position " + pos.x2 + "/" + pos.y2 + " ... " : "") + (o != null ? "with service in " + interval + " days" : ""));
        }
        p.progress("Keytables definieren #" + projectcount, 9);
        this.project.getLogger().info("Reading keytable TASK STATUS ... ");
        sheet = wb.getSheet("t_Task_Status");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        Keytable keytable = this.project.getKeytable("observationtype");
        for (row = 2; row <= lastRow; ++row) {
            int id = Integer.parseInt(this.getCellValue(sheet, row, columns.get("tts_ID")));
            val = this.getCellValue(sheet, row, columns.get("tts_Status"));
            keytable.addTerm((long)id, this.project.getUser().getCurrentLanguage(), val);
        }
        sheet = wb.getSheet("a_Task_Status");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        for (row = 2; row <= lastRow; ++row) {
            int id = Integer.parseInt(this.getCellValue(sheet, row, columns.get("ats_ID")));
            val = this.getCellValue(sheet, row, columns.get("ats_Status"));
            if (keytable.hasId((long)id, this.project.getUser().getCurrentLanguage())) continue;
            keytable.addTerm((long)id, this.project.getUser().getCurrentLanguage(), val);
        }
        keytable.save();
        this.project.getLogger().info("#### Number of entries: " + keytable.size());
        this.project.setProjectProperty("observationtable.column.observationtype", "show");
        p.progress("Dokumente zuweisen #" + projectcount, 10);
        this.project.getLogger().info("Reading document-task assignment ... ");
        sheet = wb.getSheet("h_History_Task");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        for (row = 2; row <= lastRow; ++row) {
            String taskUUID = this.getCellValue(sheet, row, columns.get("hht_UUID_Task"));
            String docUUID = this.getCellValue(sheet, row, columns.get("hht_UUID_History"));
            ArrayList<String> docUUIDs = this.taskHistory.get(taskUUID);
            if (docUUIDs == null) {
                docUUIDs = new ArrayList();
            }
            docUUIDs.add(docUUID);
            this.taskHistory.put(taskUUID, docUUIDs);
        }
        p.progress("M\u00e4ngel anlegen #" + projectcount, 11);
        this.project.getLogger().info("Reading observations (tasks) ... ");
        sheet = wb.getSheet("t_Task");
        columns = this.getColumns(sheet);
        lastRow = sheet.getLastRowNum() + 1;
        for (row = 2; row <= lastRow; ++row) {
            String oUUID3 = this.getCellValue(sheet, row, columns.get("tt_ObjID"));
            String taskUUID = this.getCellValue(sheet, row, columns.get("tt_UUID"));
            Long locId = this.locationId.get(oUUID3);
            if (locId == null) {
                CmsLocation loc = (CmsLocation)this.project.createElement("location");
                loc.setAttributeValue("title", "Dokumente");
                loc.save();
                locId = loc.getId();
                this.locationId.put(oUUID3, locId);
            }
            boolean ok = true;
            if (locId != null) {
                ArrayList<String> docUUIDs;
                String dt = this.getCellValue(sheet, row, columns.get("tt_Create"));
                CmsEvent ev = null;
                if (this.event.containsKey(dt)) {
                    ev = this.event.get(dt);
                } else {
                    ev = (CmsEvent)this.project.createElement("event");
                    ev.setAttributeValue("date", dt);
                    ev.setAttributeValue("title", "Erfassung");
                    ev.save();
                    this.event.put(dt, ev);
                }
                this.project.setCurrentEvent(ev);
                CmsObservation o = (CmsObservation)this.project.createElement("observation");
                o.setAttributeValue("title", this.getCellValue(sheet, row, columns.get("tt_MsgHL")));
                o.setAttributeValue("description", this.getCellValue(sheet, row, columns.get("tt_MsgSubject")));
                o.setAttributeValue("measure", this.getCellValue(sheet, row, columns.get("tt_MsgAction")));
                o.getKeyAttribute("type").setValue(1L);
                long obstype = Long.parseLong(this.getCellValue(sheet, row, columns.get("tt_TaskTyp")));
                o.getKeyAttribute("observationtype").setValue(obstype);
                long status = Long.parseLong(this.getCellValue(sheet, row, columns.get("tt_Status")));
                o.setAttributeValue("duedate", this.getCellValue(sheet, row, columns.get("tt_DeadLine")));
                String responsibleUUID = this.getCellValue(sheet, row, columns.get("tt_Responsible"));
                if (this.responsible.containsKey(responsibleUUID)) {
                    o.setAttributeValue("code", this.responsible.get(responsibleUUID));
                }
                String assessment = this.getCellValue(sheet, row, columns.get("tt_Assessment"));
                long priorityid = -1L;
                if ("0".equals(assessment)) {
                    priorityid = keytablePriority.getIdByTermAndCreate("keine", this.project.getPrimaryLang());
                } else if ("20".equals(assessment)) {
                    priorityid = keytablePriority.getIdByTermAndCreate("gering", this.project.getPrimaryLang());
                } else if ("50".equals(assessment)) {
                    priorityid = keytablePriority.getIdByTermAndCreate("mittel", this.project.getPrimaryLang());
                } else if ("80".equals(assessment)) {
                    priorityid = keytablePriority.getIdByTermAndCreate("hoch", this.project.getPrimaryLang());
                }
                if (priorityid >= 0L) {
                    o.getKeyAttribute("priority").setValue(priorityid);
                }
                if ((docUUIDs = this.taskHistory.get(taskUUID)) != null) {
                    for (String docUUID : docUUIDs) {
                        Document d = this.document.get(this.getFileCode(docUUID));
                        if (d != null) {
                            File f = d.getFile();
                            if (f != null) {
                                o.getUploadAttribute("files").addUpload(f);
                                UploadItem item = o.getUploadAttribute("files").getFirstUploadItem();
                                item.setFileInfo(d.filename);
                            }
                            d.usedForTask = true;
                            continue;
                        }
                        this.project.getLogger().info("#### No document found for: " + docUUID);
                    }
                }
                o.getRelationAttribute("location").set(locId.longValue());
                ArrayList<Long> obsIds = this.locationObservation.get(locId);
                if (obsIds == null) {
                    obsIds = new ArrayList();
                }
                obsIds.add(o.getId());
                this.locationObservation.put(locId, obsIds);
                o.setNumber((long)obsIds.size());
                o.save();
                this.observationId.put(oUUID3, o.getId());
                this.project.getLogger().info("#### Observation created: " + o.getTitle());
                dt = this.getCellValue(sheet, row, columns.get("tt_Closed"));
                if (status <= 800L || "".equals(dt)) continue;
                o.setDone(true);
                if (this.event.containsKey(dt)) {
                    ev = this.event.get(dt);
                } else {
                    ev = (CmsEvent)this.project.createElement("event");
                    ev.setAttributeValue("date", dt);
                    ev.setAttributeValue("title", "Kontrolle");
                    ev.save();
                    this.event.put(dt, ev);
                }
                this.project.setCurrentEvent(ev);
                o.save();
                this.project.getLogger().info("#### Observation CLOSED: " + o.getTitle());
                continue;
            }
            this.project.getLogger().info("!!!! Observation NOT created, no location: " + this.getCellValue(sheet, row, columns.get("tt_MsgHL")));
            ok = false;
        }
        this.project.setProjectProperty("observationtable.column.obsCode1", "show");
        if (closeAfterImport) {
            ProjectHelper.closeProject(new Closing().withoutExport().withoutTrigger());
        }
        wb.close();
        p.done();
    }

    private File getPlanFile(String fn) {
        File f = this.files.get(fn.toLowerCase() + "-map.png");
        return f;
    }

    private File getBackupFolder(File f) {
        for (File file : f.listFiles()) {
            if (!file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    private HashMap<String, File> getFileReferences(File f) {
        HashMap<String, File> result = new HashMap<String, File>();
        this.addFiles(result, f);
        return result;
    }

    private void addFiles(HashMap<String, File> map, File f) {
        File[] files;
        for (File file : files = f.listFiles()) {
            if (file.isFile()) {
                if (file.getName().endsWith("png")) {
                    boolean bl = false;
                }
                map.put(file.getName().toLowerCase(), file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.addFiles(map, file);
        }
    }

    private HashMap<String, Integer> getColumns(Sheet sh) {
        int col = 1;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String cell = null;
        while (cell == null || !cell.equals("")) {
            cell = this.getCellValue(sh, 1, col);
            result.put(cell, col);
            ++col;
        }
        return result;
    }

    private String getFileCode(String uuid) {
        if (!"".equals(uuid)) {
            return uuid.substring(1, uuid.length() - 1).replaceAll("-", "");
        }
        return null;
    }

    private String getCellValue(Sheet sh, int row, int col) {
        Row r = sh.getRow(row - 1);
        if (r == null) {
            return "";
        }
        Cell c = r.getCell(col - 1);
        if (c == null) {
            return "";
        }
        switch (c.getCellType()) {
            case BOOLEAN: {
                return c.getBooleanCellValue() ? "TRUE" : "FALSE";
            }
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)c)) {
                    Date dt = c.getDateCellValue();
                    return Util.formatDate((Date)dt, (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone());
                }
                double v = c.getNumericCellValue();
                if (v == Math.floor(v)) {
                    return Integer.toString((int)v);
                }
                return Double.toString(c.getNumericCellValue());
            }
            case STRING: {
                return c.getStringCellValue();
            }
        }
        return c.getStringCellValue();
    }

    private String getCellValue(Sheet sh, int row, int col, String defaultValue) {
        String v = this.getCellValue(sh, row, col);
        return v == null || "".equals(v) ? defaultValue : v;
    }

    class Document {
        String uuid;
        String dt;
        String doctype;
        String filename;
        boolean usedForTask = false;

        Document() {
        }

        public File getFile() {
            String fileid = KevoxImporter.this.getFileCode(this.uuid);
            File f = KevoxImporter.this.files.get((fileid + this.doctype).toLowerCase());
            return f;
        }
    }

    class PlanPosition {
        long idplan;
        int x1;
        int x2;
        int y1;
        int y2;
        int xline;
        int yline;

        PlanPosition() {
        }
    }
}

