/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.io.importer.ImportTarget;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.importer.AttributeReference;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;

public class LocationObservationImportTarget
extends ImportTarget {
    int idxObsUUID = -1;
    int idxObsType = -1;
    int idxLocUUID = -1;
    int idxLocTitle = -1;
    Mapping mappingAttribute = Mapping.UUID;
    boolean createStandardObservation = false;
    String standardObservationTitle = null;
    long standardObservationType = -1L;

    @Override
    protected void initialise() {
        if (this.app == null) {
            this.app = ThemisApplication.getInstance();
        }
        if (this.settings == null) {
            this.settings = this.app.getSettings();
        }
        block10: for (ThemisAttribute a : this.settings.getLocationAttributes()) {
            if (!a.isUsed() || a.isVirtual()) continue;
            switch (a.getId()) {
                case "size": {
                    this.attributes.add(new AttributeReference("location", "dimwidth", this.project.getResourceText("attribute.location.dimwidth")));
                    this.attributes.add(new AttributeReference("location", "dimheight", this.project.getResourceText("attribute.location.dimheight")));
                    this.attributes.add(new AttributeReference("location", "dimdiameter", this.project.getResourceText("attribute.location.dimdiameter")));
                    continue block10;
                }
                case "prefixsuffix": 
                case "suffix": 
                case "group": {
                    continue block10;
                }
            }
            this.attributes.add(new AttributeReference(a));
        }
        for (ThemisAttribute a : this.settings.getObservationAttributes()) {
            if (!a.isUsed() || a.isVirtual()) continue;
            this.attributes.add(new AttributeReference(a));
        }
        this.attributes.add(new AttributeReference("observation", "upload-file", this.project.getResourceText("attribute.observation.upload-file")));
        this.attributes.add(new AttributeReference("observation", "upload-comment", this.project.getResourceText("attribute.observation.upload-comment")));
        this.attributes.add(new AttributeReference("observation", "type", "Beobachtungstyp"));
        this.attributes.add(new AttributeReference("observation", "uuid", "UUID"));
        this.attributes.add(new AttributeReference("location", "uuid", "UUID"));
    }

    public void clearMapping() {
        this.mapping.clear();
        this.idxLocUUID = -1;
        this.idxLocTitle = -1;
        this.idxObsUUID = -1;
        this.idxObsType = -1;
    }

    public void setMappingAttribute(Mapping m) {
        this.mappingAttribute = m;
    }

    @Override
    public void addMapping(int idx, AttributeReference att) {
        if ("uuid".equals(att.attributecode)) {
            switch (att.elementtype) {
                case "observation": {
                    this.idxObsUUID = idx;
                    break;
                }
                case "location": {
                    this.idxLocUUID = idx;
                }
            }
        } else if ("title".equals(att.attributecode) && "location".equals(att.elementtype)) {
            this.idxLocTitle = idx;
        } else if ("type".equals(att.attributecode) && "observation".equals(att.elementtype)) {
            this.idxObsType = idx;
        }
        this.mapping.put(idx, att);
    }

    private HashMap getPlanMap() {
        HashMap<String, Long> planIds = new HashMap<String, Long>();
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "plan");
        s.addSelectMeta();
        s.addElementJoin("plan", "plan");
        s.addSelect("plan.sort", "sort");
        s.addSelect("plan.currentplanfile", "currentplanfile");
        CmsAttribute att = this.project.getDefaultElement("plan").getAttribute("building");
        s.addSelectRelationTerm(att);
        s.setSort("planbuilding,sort");
        for (DataRecord rec : s.search().getResult()) {
            String b = rec.getString("planbuilding");
            String p = rec.getString("plan.title");
            String b_p = b == null ? p : b + "#" + p;
            planIds.put(b_p, rec.getLong("meta_id"));
        }
        return planIds;
    }

    public void setObservationUUIDcolumn(int col) {
        this.idxObsUUID = col;
    }

    public void setLocationUUIDcolumn(int col) {
        this.idxLocUUID = col;
    }

    public void setObservationTypeColumn(int col) {
        this.idxLocUUID = col;
    }

    public void setCreateStandardObservation(String title, long type) {
        this.standardObservationTitle = title;
        this.standardObservationType = type;
        this.createStandardObservation = true;
    }

    @Override
    public void runImport(ProgressHandler ph) {
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        ThemisActionProvider.getInstance().setActive(false);
        CmsLocation loc = null;
        CmsObservation obs = null;
        Properties locProps = new Properties();
        Properties obsProps = new Properties();
        long planid = -1L;
        String filenames = null;
        String filecomment = null;
        String mangel = this.app.getSettings().getTerm(ThemisSettings.Term.TypMangel);
        String kontrolle = this.app.getSettings().getTerm(ThemisSettings.Term.TypKontrolle);
        String information = this.app.getSettings().getTerm(ThemisSettings.Term.TypInformation);
        String aufgabe = this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe);
        HashMap planIds = this.getPlanMap();
        int count = this.reader.getRecords().size();
        if (ph != null) {
            ph.switchToDeterminate(count);
        }
        File folder = this.reader.getParentFolder();
        for (int ii = 0; ii < count; ++ii) {
            try {
                if (ph != null) {
                    ph.progress("Import " + (ii + 1) + " von " + count, ii);
                }
                ArrayList record = (ArrayList)this.reader.getRecords().get(ii);
                String locUUID = null;
                String locTitle = null;
                String obsUUID = null;
                long obsType = -1L;
                String obsTitle = null;
                planid = -1L;
                Iterator iterator = this.mapping.keySet().iterator();
                block32: while (iterator.hasNext()) {
                    int columnIndex = (Integer)iterator.next();
                    AttributeReference att = (AttributeReference)this.mapping.get(columnIndex);
                    if (att == null) continue;
                    switch (att.attributecode) {
                        case "plan": {
                            Long planidLong = (Long)planIds.get(record.get(columnIndex));
                            planid = planidLong == null ? -1L : planidLong;
                            continue block32;
                        }
                        case "upload-file": {
                            filenames = (String)record.get(columnIndex);
                            continue block32;
                        }
                        case "upload-comment": {
                            filecomment = (String)record.get(columnIndex);
                            continue block32;
                        }
                    }
                    CmsElement def = this.project.getDefaultElement(att.elementtype);
                    if (def.hasAttribute(att.attributecode) && def.getAttribute(att.attributecode).isNumber() && !Util.isNumber((String)((String)record.get(columnIndex)))) continue;
                    if (columnIndex == this.idxLocUUID) {
                        locUUID = (String)record.get(columnIndex);
                        continue;
                    }
                    if (columnIndex == this.idxObsUUID) {
                        obsUUID = (String)record.get(columnIndex);
                        continue;
                    }
                    if (columnIndex == this.idxObsType) {
                        String obsTypeStr = (String)record.get(columnIndex);
                        switch (obsTypeStr.toLowerCase()) {
                            case "d": 
                            case "m": {
                                obsType = 1L;
                                break;
                            }
                            case "t": 
                            case "a": {
                                obsType = 4L;
                                break;
                            }
                            case "i": {
                                obsType = 3L;
                                break;
                            }
                            case "k": 
                            case "c": {
                                obsType = 2L;
                                break;
                            }
                            default: {
                                if (kontrolle.equals(obsTypeStr)) {
                                    obsType = 2L;
                                    break;
                                }
                                if (aufgabe.equals(obsTypeStr)) {
                                    obsType = 4L;
                                    break;
                                }
                                if (information.equals(obsTypeStr)) {
                                    obsType = 3L;
                                    break;
                                }
                                obsType = 1L;
                                break;
                            }
                        }
                        continue;
                    }
                    if (att.elementtype.equals("location")) {
                        if (columnIndex == this.idxLocTitle) {
                            locTitle = (String)record.get(columnIndex);
                        }
                        locProps.put(att.attributecode, record.get(columnIndex));
                        continue;
                    }
                    if (!att.elementtype.equals("observation")) continue;
                    obsProps.put(att.attributecode, record.get(columnIndex));
                }
                long locId = -1L;
                switch (this.mappingAttribute) {
                    case TITLE: {
                        if (locTitle == null) break;
                        locId = this.project.getDatastorage().getElementId(locTitle, "location");
                        break;
                    }
                    case UUID: {
                        if (locUUID == null) break;
                        locId = this.project.getDatastorage().getElementId(UUID.fromString(locUUID));
                    }
                }
                long obsId = -1L;
                if (obsUUID != null) {
                    obsId = this.project.getDatastorage().getElementId(UUID.fromString(obsUUID));
                }
                loc = locId >= 0L ? (CmsLocation)this.project.loadElement(locId, this.project.getUser()) : this.project.createLocation(-1L);
                loc.setAttributes(locProps);
                if (locUUID != null) {
                    loc.setUUID(locUUID);
                }
                if (planid > 0L) {
                    loc.getRelationAttribute("plan").add(planid);
                }
                loc.save();
                obs = null;
                boolean createObs = false;
                if (obsId >= 0L) {
                    obs = (CmsObservation)this.project.loadElement(obsId, this.project.getUser());
                } else {
                    if (!obsProps.isEmpty()) {
                        for (String k : obsProps.stringPropertyNames()) {
                            if ("".equals(obsProps.getProperty(k))) continue;
                            createObs = true;
                            break;
                        }
                    }
                    if (!createObs) {
                        createObs = this.createStandardObservation;
                        obsType = this.standardObservationType;
                        obsTitle = this.standardObservationTitle;
                    }
                }
                if (createObs) {
                    obs = (CmsObservation)this.project.createElement("observation");
                    obs.setLocation(loc);
                    obs.setNumber(loc.getNextObservationNumber());
                    if (obsType < 0L) {
                        obsType = 1L;
                    }
                    obs.getKeyAttribute("type").setValue(obsType);
                    if (obsTitle == null) {
                        obsTitle = "Beobachtung";
                    }
                    obs.setAttributeValue("title", obsTitle);
                    if (obsUUID != null) {
                        obs.setUUID(obsUUID);
                    }
                }
                if (obs != null) {
                    obs.setAttributes(obsProps);
                    if (filenames != null && !"null".equals(filenames) && folder != null) {
                        for (String filename : filenames.split(",")) {
                            UploadItem item = null;
                            if (this.settings.getImageForObservation() && obs != null) {
                                item = obs.getUploadAttribute("files").addUpload(new File(folder, filename.trim()));
                            } else if (!this.settings.getImageForObservation()) {
                                item = loc.getUploadAttribute("files").addUpload(new File(folder, filename.trim()));
                            }
                            if (item == null || filecomment == null) continue;
                            item.setFileComment(filecomment);
                        }
                    }
                }
                if (obs == null) continue;
                obs.save();
                continue;
            }
            catch (Exception e) {
                if (!this.app.isDebugMode()) continue;
                e.printStackTrace();
            }
        }
        this.app.getFilter().resetSearchResult();
        ThemisActionProvider.getInstance().setActive(true);
        if (ph != null) {
            ph.progressDone();
        }
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED);
        Dialogs.getInstance().showInfoDialog(this.project.getResourceText("info.csv-import.succeeded"));
    }

    class LocationCsv
    implements Comparable<LocationCsv> {
        long number;
        String plan;
        long planId;
        String name;
        double x;
        double y;
        String comment;
        double imgX;
        double imgY;
        boolean hasImgCoordinates = false;
        String errormessage = null;
        String quantity;
        String code;
        String code2;

        public LocationCsv(String number, String plan, long planId, String name, String x, String y, String comment, String quantity, String code, String code2) {
            if (x == null || "".equals(x)) {
                this.errormessage = "Keine X-Koordinate definiert";
                return;
            }
            if (y == null || "".equals(y)) {
                this.errormessage = "Keine Y-Koordinate definiert";
                return;
            }
            this.number = number == null || "".equals(number) ? 0L : Long.parseLong(number);
            x = x.replaceAll(",", ".");
            y = y.replaceAll(",", ".");
            if (name == null || "".equals(name)) {
                name = "Kein Titel";
            }
            this.name = name;
            this.x = Double.parseDouble(x);
            this.y = Double.parseDouble(y);
            this.comment = comment;
            this.plan = plan == null ? "" : plan;
            this.planId = planId;
            this.quantity = quantity;
            this.code = code;
            this.code2 = code2;
        }

        public LocationCsv(String name, double x, double y, String c) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.comment = c;
        }

        public String getErrorMessage() {
            return this.errormessage;
        }

        public String toString() {
            return (this.hasImgCoordinates ? "(*) " : "") + "[" + this.number + "] " + ("".equals(this.plan) ? "" : this.plan + ":") + this.name;
        }

        public void setImageCoordinates(double x, double y) {
            this.imgX = x;
            this.imgY = y;
            this.hasImgCoordinates = true;
        }

        @Override
        public int compareTo(LocationCsv o) {
            if (this.number == o.number) {
                return this.name.compareTo(o.name);
            }
            return o.number < this.number ? -1 : 1;
        }
    }

    public static enum Mapping {
        NONE,
        TITLE,
        UUID;

    }
}

