/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer;

import at.grid.gui.Dialogs;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.io.importer.ImportTarget;
import at.grid.themis.application.project.ProjectHelper;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.importer.AttributeReference;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ProgressHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class ProjectImportTarget
extends ImportTarget {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    File projectFolder = null;

    @Override
    protected void initialise() {
        this.attributes.add(new AttributeReference("project", "projectfile", "Projekt-Datei"));
        this.attributes.add(new AttributeReference("project", "projectfolder", "Verzeichnis"));
        this.attributes.add(new AttributeReference("project", "projecttitle", "Projekttitel"));
        this.attributes.add(new AttributeReference("project", "projectlocation", "Ortsangabe"));
        this.attributes.add(new AttributeReference("project", "customer", "Auftraggeber"));
        this.attributes.add(new AttributeReference("project", "projectnumber", "Projektnummer"));
        this.attributes.add(new AttributeReference("project", "info", "Sonstige Information"));
        this.attributes.add(new AttributeReference("project", "projectimage", "Projektfoto (Datei)"));
        this.attributes.add(new AttributeReference("project", "projectlogo", "Projektlogo (Datei)"));
        this.attributes.add(new AttributeReference("project", "projecttemplate", "Projektvorlage (Datei)"));
    }

    public void setProjectFolder(File f) {
        this.projectFolder = f;
    }

    @Override
    public void runImport(ProgressHandler ph) {
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        if (this.project.isOpen()) {
            Dialogs.showErrorDialog((String)"Es darf kein Projekt ge\u00f6ffnet sein, offenes Projekt vorher schlie\u00dfen");
            return;
        }
        ThemisActionProvider.getInstance().setActive(false);
        this.app.getActionProvider().setActive(false);
        int count = this.reader.getRecords().size();
        if (ph != null) {
            ph.switchToDeterminate(count);
        }
        File currentFolder = ThemisApplication.getInstance().getCurrentFolder();
        boolean foundFile = false;
        for (AttributeReference att : this.mapping.values()) {
            if (!"projectfile".equals(att.attributecode)) continue;
            foundFile = true;
            break;
        }
        if (!foundFile) {
            Dialogs.showErrorDialog((String)"Keine Spalte f\u00fcr Projekt Dateiname definiert");
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (int ii = 0; ii < count; ++ii) {
            ArrayList<String> result;
            if (ph != null) {
                ph.progress("Projekt " + (ii + 1) + " von " + count + " wird angelegt", ii);
            }
            ArrayList record = (ArrayList)this.reader.getRecords().get(ii);
            Properties props = new Properties();
            Iterator iterator = this.mapping.keySet().iterator();
            while (iterator.hasNext()) {
                int columnIndex = (Integer)iterator.next();
                AttributeReference att = (AttributeReference)this.mapping.get(columnIndex);
                if (att == null) continue;
                props.setProperty(att.attributecode, (String)record.get(columnIndex));
            }
            String foldername = props.getProperty("projectfolder", currentFolder.getAbsolutePath());
            File folder = new File(foldername);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            String filename = props.getProperty("projectfile");
            ThemisFolder tf = new ThemisFolder(new File(folder, filename));
            ThemisProject p = null;
            if (tf.isProject()) {
                this.project.open(tf, null, null, false, ThemisUtil.isOnNetworkDrive((File)tf.getProjectFolder()), false, false, false, ph);
                if (ThemisApplication.getInstance().getProject().isOpen()) {
                    p = ThemisApplication.getInstance().getProject();
                    result = ProjectHelper.updateProject(p, props);
                    for (String r : result) {
                        if (errors.contains(r)) continue;
                        errors.add(r);
                    }
                }
            } else if (!tf.getProjectFolder().exists()) {
                result = ProjectHelper.createAndUpdateProject(tf.getProjectFolder(), props, null);
                for (String r : result) {
                    if (errors.contains(r)) continue;
                    errors.add(r);
                }
                p = ThemisApplication.getInstance().getProject();
                if (p != null && !p.isOpen()) {
                    p = null;
                }
            }
            if (p == null) continue;
            ProjectHelper.closeProject(new Closing().withoutTrigger().withoutExport());
        }
        if (!errors.isEmpty()) {
            Dialogs.showErrorDialog((String)("Fehler beim Erstellen bzw. Aktualisieren der Projekte:<br><li>" + String.join((CharSequence)"<li>", errors)));
        }
        this.app.getFilter().resetSearchResult();
        this.app.getActionProvider().setActive(true);
        ThemisActionProvider.getInstance().setActive(true);
    }
}

