/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer;

import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.content.Keytable;
import at.grid.gui.Dialogs;
import at.grid.themis.application.io.importer.ImportTarget;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsLocationTemplate;
import at.grid.themis.ontology.element.CmsLocationgroup;
import at.grid.themis.ontology.element.CmsObservationTemplate;
import at.grid.themis.ontology.importer.AttributeReference;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.themis.ontology.template.TemplateManager;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.ProgressHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class TemplateImportTarget
extends ImportTarget {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    File projectFolder = null;

    @Override
    protected void initialise() {
        this.attributes.add(new AttributeReference("locationgroup", "group1", "Gruppe 1"));
        this.attributes.add(new AttributeReference("locationgroup", "group2", "Gruppe 2"));
        this.attributes.add(new AttributeReference("locationgroup", "group3", "Gruppe 3"));
        this.attributes.add(new AttributeReference("locationtemplate", "loctitle", "Gegenstand"));
        this.attributes.add(new AttributeReference("observationtemplate", "obstitle", "Beobachtung Titel"));
        this.attributes.add(new AttributeReference("observationtemplate", "obsdescription", "Beobachtung Beschreibung"));
        this.attributes.add(new AttributeReference("observationtemplate", "obstopic", "Beobachtung Liste 1"));
        this.attributes.add(new AttributeReference("observationtemplate", "obsobservationtype", "Beobachtung Liste 2"));
        this.attributes.add(new AttributeReference("observationtemplate", "obspriority", "Beobachtung Liste 3"));
        this.attributes.add(new AttributeReference("observationtemplate", "obscode", "Beobachtung Text 1"));
        this.attributes.add(new AttributeReference("observationtemplate", "obsfreetext1", "Beobachtung Text 2"));
        this.attributes.add(new AttributeReference("observationtemplate", "obsfreetext2", "Beobachtung Text 3"));
    }

    public void setProjectFolder(File f) {
        this.projectFolder = f;
    }

    @Override
    public void runImport(ProgressHandler ph) {
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        if (!this.project.isOpen()) {
            Dialogs.showErrorDialog((String)"error.no-project");
            return;
        }
        TemplateManager m = this.app.getProject().getTemplateManger();
        int count = this.reader.getRecords().size();
        ArrayList errors = new ArrayList();
        ph.switchToDeterminate(count);
        int itemsort = 0;
        HashMap attributes = new HashMap();
        String prevLocTitle = "";
        String prevGroup1 = "";
        String prevGroup2 = "";
        String prevGroup3 = "";
        for (int ii = 0; ii < count; ++ii) {
            long id;
            Keytable keytable;
            CmsAttribute cmsatt;
            String attval;
            String attcode;
            CmsLocationgroup grp;
            ph.progress("Vorlage " + (ii + 1) + " von " + count + " wird angelegt", ii);
            ArrayList record = (ArrayList)this.reader.getRecords().get(ii);
            attributes.clear();
            String group1 = "";
            String group2 = "";
            String group3 = "";
            long idGroup1 = -1L;
            long idGroup2 = -1L;
            long idGroup3 = -1L;
            String locTitle = "";
            String obsTitle = "";
            String obsDesc = "";
            Iterator iterator = this.mapping.keySet().iterator();
            block17: while (iterator.hasNext()) {
                int columnIndex = (Integer)iterator.next();
                AttributeReference att = (AttributeReference)this.mapping.get(columnIndex);
                if (att == null) continue;
                switch (att.attributecode) {
                    case "group1": {
                        group1 = (String)record.get(columnIndex);
                        continue block17;
                    }
                    case "group2": {
                        group2 = (String)record.get(columnIndex);
                        continue block17;
                    }
                    case "group13": {
                        group3 = (String)record.get(columnIndex);
                        continue block17;
                    }
                    case "loctitle": {
                        locTitle = (String)record.get(columnIndex);
                        continue block17;
                    }
                    case "obstitle": {
                        obsTitle = (String)record.get(columnIndex);
                        continue block17;
                    }
                    case "obsdescription": {
                        obsDesc = (String)record.get(columnIndex);
                        continue block17;
                    }
                }
                attributes.put(att.attributecode, record.get(columnIndex));
            }
            if ("".equals(locTitle.trim()) && "".equals((group1 + group2 + group3).trim())) {
                locTitle = prevLocTitle;
            }
            prevLocTitle = locTitle;
            if ("".equals(group1.trim())) {
                group1 = prevGroup1;
            } else {
                prevGroup2 = "";
                prevGroup3 = "";
            }
            if ("".equals(group2.trim())) {
                group2 = prevGroup2;
            } else {
                prevGroup3 = "";
            }
            if ("".equals(group3.trim())) {
                group3 = prevGroup3;
            }
            prevGroup1 = group1;
            prevGroup2 = group2;
            prevGroup3 = group3;
            idGroup1 = m.getFirstLocationGroupId(group1, -1L);
            if (!"".equals(group1) && idGroup1 < 0L) {
                grp = (CmsLocationgroup)this.project.createElement("locationgroup", this.project.getUser());
                grp.setAttributeValue("title", group1);
                grp.setAttributeValue("itemsort", Integer.toString(++itemsort));
                grp.save();
                idGroup1 = grp.getId();
            }
            if (idGroup1 > 0L) {
                idGroup2 = m.getFirstLocationGroupId(group2, idGroup1);
                if (!"".equals(group2) && idGroup2 < 0L) {
                    grp = (CmsLocationgroup)this.project.createElement("locationgroup", this.project.getUser());
                    grp.setAttributeValue("title", group2);
                    grp.getLongAttribute("parentgroup").setValue(idGroup1);
                    grp.setAttributeValue("itemsort", Integer.toString(++itemsort));
                    grp.save();
                    idGroup2 = grp.getId();
                }
            }
            if (idGroup2 > 0L) {
                idGroup3 = m.getFirstLocationGroupId(group3, idGroup2);
                if (!"".equals(group3) && idGroup3 < 0L) {
                    grp = (CmsLocationgroup)this.project.createElement("locationgroup", this.project.getUser());
                    grp.setAttributeValue("title", group3);
                    grp.getLongAttribute("parentgroup").setValue(idGroup2);
                    grp.setAttributeValue("itemsort", Integer.toString(++itemsort));
                    grp.save();
                    idGroup3 = grp.getId();
                }
            }
            long idGroup = idGroup1;
            if (idGroup2 > 0L) {
                idGroup = idGroup2;
            }
            if (idGroup3 > 0L) {
                idGroup = idGroup3;
            }
            long idLoc = m.getFirstLocationTemplateId(locTitle, idGroup);
            if (!"".equals(locTitle) && idLoc < 0L) {
                CmsLocationTemplate loc = (CmsLocationTemplate)this.project.createElement("locationtemplate", this.project.getUser());
                loc.setAttributeValue("title", locTitle);
                loc.getRelationAttribute("locationgroup").set(idGroup);
                loc.setAttributeValue("itemsort", Integer.toString(++itemsort));
                for (String k : attributes.keySet()) {
                    if (!k.startsWith("loc")) continue;
                    attcode = k.substring(3);
                    attval = (String)attributes.get(k);
                    cmsatt = loc.getAttribute(attcode);
                    if (cmsatt == null) continue;
                    if (cmsatt instanceof KeyAttribute) {
                        keytable = ((KeyAttribute)cmsatt).getKeytable();
                        id = keytable.getIdByTerm(attval, this.project.getPrimaryLang());
                        if (id < 0L) {
                            id = keytable.createNewId();
                            keytable.addTerm(id, this.project.getPrimaryLang(), attval);
                            keytable.save();
                        }
                        ((KeyAttribute)cmsatt).setValue(id);
                        continue;
                    }
                    cmsatt.setValue(attval);
                }
                loc.save();
                idLoc = loc.getId();
            }
            if ("".equals(obsDesc + obsTitle)) continue;
            CmsObservationTemplate obs = (CmsObservationTemplate)this.project.createElement("observationtemplate", this.project.getUser());
            obs.setAttributeValue("title", obsTitle);
            obs.setAttributeValue("description", obsDesc);
            if (idLoc > 0L) {
                obs.getRelationAttribute("location").set(idLoc);
            } else {
                obs.getRelationAttribute("locationgroup").set(idGroup);
            }
            obs.setAttributeValue("itemsort", Integer.toString(++itemsort));
            for (String k : attributes.keySet()) {
                if (!k.startsWith("obs")) continue;
                attcode = k.substring(3);
                attval = (String)attributes.get(k);
                cmsatt = obs.getAttribute(attcode);
                if (cmsatt == null) continue;
                if (cmsatt instanceof KeyAttribute) {
                    keytable = ((KeyAttribute)cmsatt).getKeytable();
                    id = keytable.getIdByTerm(attval, this.project.getPrimaryLang());
                    if (id < 0L) {
                        id = keytable.createNewId();
                        keytable.addTerm(id, this.project.getPrimaryLang(), attval);
                        keytable.save();
                    }
                    ((KeyAttribute)cmsatt).setValue(id);
                    continue;
                }
                cmsatt.setValue(attval);
            }
            obs.save();
        }
        if (!errors.isEmpty()) {
            Dialogs.showErrorDialog((String)("Fehler beim Einlesen:<br><li>" + String.join((CharSequence)"<li>", errors)));
        }
    }
}

