/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.io.importer.photo;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.io.importer.photo.Bundle;
import at.grid.themis.application.io.importer.photo.SetTimePanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.Util;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ImportPhotoTopComponent", persistenceType=0)
public final class ImportPhotoTopComponent
extends TopComponent
implements ThemisActionListener {
    private final ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle");
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private final DefaultListModel<ImageListEntry> imageListModel = new DefaultListModel();
    private final DefaultListModel elementListModel = new DefaultListModel();
    private final ArrayList<ImageListEntry> images = new ArrayList();
    private long deltaTime;
    private int imagesize;
    private Timer timer;
    private JButton btnApplyTimeDifference;
    private JButton btnConnect;
    private JButton btnRemove;
    private JButton btnRemovePhoto;
    private JButton btnSaveRelations;
    private JButton btnSelectFolder;
    private JButton btnSetTime;
    private JButton btnSetTimeDifference;
    private JCheckBox chkOnlyOpen;
    private JPanel clockPanel;
    private JList elementList;
    private JTextField fldTimeDifference;
    private JList imageList;
    private JPanel importPanel;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblDate;
    private JLabel lblObsLoc;
    private JLabel lblTime;
    private JPanel panelButtons;
    private JPanel panelFotoAction;
    private JPanel panelTimeDiff;

    public ImportPhotoTopComponent() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + ((Object)((Object)this)).getClass().getName() + " ...");
        this.initComponents();
        this.setName(Bundle.CTL_ImportPhotoTopComponent());
        this.setToolTipText(Bundle.HINT_ImportPhotoTopComponent());
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.dragging_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.sliding_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.undocking_disabled", Boolean.TRUE);
        THEMIS.getLicense();
        ThemisActionProvider.getInstance().register(this);
        this.fldTimeDifference.setText(this.app.getConfiguration("image.sync.delta", ""));
        ImportPhotoDnDListener myDragDropListener = new ImportPhotoDnDListener();
        new DropTarget(this.imageList, myDragDropListener);
        new DragScrollHandler(this.elementList, false, true);
        new DragScrollHandler(this.imageList, false, true);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        if (action.getSource() == this) {
            return;
        }
        switch (action.getAction()) {
            case 1100: {
                if (!this.app.getSettings().getImageForLocation()) break;
                this.lblObsLoc.setText(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.locations.text"));
                break;
            }
            case 1102: {
                if (!this.app.getSettings().getImageForLocation()) break;
                this.lblObsLoc.setText(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.locations.text"));
            }
        }
    }

    public void getElements() {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        if (this.app.getSettings().getImageForObservation()) {
            CmsElement obs = this.project.getDefaultElement("observation");
            s.setElementtypes("observation");
            s.addSelectAttribute(obs.getAttribute("location"));
            s.addInnerJoin("tdtaelelocation AS loc ON (locationele.idelement=loc.idelement)");
            s.addSelect("loc.number", "locnumber");
            s.addSelectAttribute(obs.getAttribute("number"));
            s.setSort("loc.number,ele.number");
            s.addSelectMeta();
            s.addWhereRelationId(obs.getAttribute("histories"), " IN ", "(SELECT elementFrom FROM tdtaRelation WHERE elementTo=" + this.project.getSelectionManager().getCurrentEventId() + " AND relationcode='historyevent')");
        } else {
            CmsElement loc = this.project.getDefaultElement("location");
            s.setElementtypes("location");
            s.setSort(loc.getAttribute("meta_id"));
            s.addSelect("loc.number", "locnumber");
            s.addSelectMeta();
        }
        this.elementListModel.clear();
        this.elementListModel.addElement(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.notAssigned.text"));
        List recs = s.search().getResult();
        for (DataRecord rec : recs) {
            CmsElementSummary ele = new CmsElementSummary((CmsApplication)this.project, rec, this.project.getUser());
            String nr = rec.getString("locnumber");
            if (!rec.isEmpty("number")) {
                nr = nr + "." + rec.getString("number");
            }
            ele.setTitle(nr + " " + rec.getString("meta_title"));
            this.elementListModel.addElement(ele);
        }
        this.elementList.setModel(this.elementListModel);
    }

    private void updateImageList() {
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        boolean onlyOpen = this.chkOnlyOpen.isSelected();
        this.imageListModel.clear();
        this.images.sort((a, b) -> ((ImageListEntry)a).image.getName().compareTo(((ImageListEntry)b).image.getName()));
        for (ImageListEntry img : this.images) {
            if (onlyOpen && img.element != null || !img.selected) continue;
            this.imageListModel.addElement(img);
        }
        this.imageList.setModel(this.imageListModel);
    }

    private void loadImageFolder(List<File> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        this.app.setPictureImportFolder(files.get(0).getParentFile());
        this.images.clear();
        this.imageListModel.clear();
        for (File f : files) {
            if (!Util.isImageFile((String)f.getName())) continue;
            ImageListEntry img = new ImageListEntry(f);
            this.images.add(img);
            this.imageListModel.addElement(img);
        }
        this.imageList.setModel(this.imageListModel);
        this.updateImageList();
    }

    public void updateObservations() {
        this.app.setConfiguration("image.sync.delta", this.fldTimeDifference.getText(), true);
        ProgressUtils.showProgressDialogAndRun(ph -> {
            int count = 0;
            int countFailed = 0;
            try {
                ph.switchToDeterminate(this.images.size());
                File tempFolder = this.app.getProject().getTempfileLocation();
                for (ImageListEntry img : this.images) {
                    if (img.element != null) {
                        ++count;
                        CmsElement ele = this.project.loadElement(img.element.getId(), this.project.getUser());
                        File imagefile = img.image;
                        if (Util.isImageFile((String)imagefile.getName())) {
                            try {
                                ph.progress(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.image.text"), imagefile.getName()), count + countFailed);
                                BufferedImage resizeImage = this.getRotatedImage(img, this.imagesize);
                                File outputfile = new File(tempFolder, "reduced_" + imagefile.getName());
                                THEMIS.createImageFile(resizeImage, outputfile, this.app.getSettings().getImageUploadQuality());
                                if (this.app.getSettings().getImageKeepOriginal()) {
                                    Util.copy((File)imagefile, (File)this.project.getImagefileLocation());
                                }
                                imagefile = outputfile;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        ele.getUploadAttribute("files").addUpload(imagefile);
                        ele.save();
                        imagefile.delete();
                        continue;
                    }
                    ++countFailed;
                }
                ph.finish();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.FOTOIMPORT_COMPLETE);
                this.showResultDialog(count, countFailed);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }, (String)ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.importFotos.text"), (boolean)true);
    }

    private void showResultDialog(int count, int countFailed) {
        if (count == 1) {
            Dialogs.getInstance().showInfoDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.imageAssigned.text"), count, countFailed));
        } else {
            Dialogs.getInstance().showInfoDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.imagesAssigned.text"), count, countFailed));
        }
    }

    private void automaticImageAssignment() {
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        CmsElement log = this.project.getDefaultElement("log");
        s.setElementtypes("log");
        s.addSelectAllAttributes("log");
        s.addWhereAttribute(log.getAttribute("eventid"), "=", Long.toString(this.project.getSelectionManager().getCurrentEventId()));
        List recs = s.search().getResult();
        boolean usePrefix = this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed();
        boolean useSuffix = this.app.getSettings().getLocationAttribute("suffix").isUsed();
        for (DataRecord rec : recs) {
            long t0 = rec.getDate("startedit", this.project.getTimeZone()).getTime();
            long t1 = rec.getDate("endedit", this.project.getTimeZone()).getTime();
            long obsid = rec.getLong("observationid");
            String t = this.project.getDatastorage().getObservationFullNumber(obsid, usePrefix, useSuffix);
            for (ImageListEntry img : this.images) {
                CmsElement e;
                if (img.element != null || !img.selected || (t0 > img.capturetime + this.deltaTime || t1 < img.capturetime + this.deltaTime) && (t0 > img.lastModified + this.deltaTime || t1 < img.lastModified + this.deltaTime) || (e = this.project.loadElement(obsid, this.project.getUser())) == null) continue;
                t = t + " " + e.getTitle();
                img.setElement(e, t);
            }
        }
        this.updateImageList();
    }

    private BufferedImage getRotatedImage(ImageListEntry img, int newSize) throws IOException {
        BufferedImage imageOrig = newSize == 0 ? ImageIO.read(img.image) : Util.resizeImage((BufferedImage)ImageIO.read(img.image), (int)newSize);
        int width = imageOrig.getWidth();
        int height = imageOrig.getHeight();
        if (img.rotation != 0.0) {
            BufferedImage image;
            AffineTransform at = new AffineTransform();
            if (img.rotation == 90.0 || img.rotation == 270.0) {
                image = new BufferedImage(height, width, imageOrig.getType());
                at.translate(height / 2, width / 2);
                at.rotate(Math.toRadians(img.rotation));
                at.translate(-width / 2, -height / 2);
            } else {
                image = new BufferedImage(width, height, imageOrig.getType());
                at.translate(width / 2, height / 2);
                at.rotate(Math.toRadians(img.rotation));
                at.translate(-width / 2, -height / 2);
            }
            Graphics2D g2 = image.createGraphics();
            g2.drawImage(imageOrig, at, (ImageObserver)((Object)this));
            g2.dispose();
            return image;
        }
        return imageOrig;
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.clockPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.lblDate = new JLabel();
        this.lblTime = new JLabel();
        this.btnSelectFolder = new JButton();
        this.btnRemovePhoto = new JButton();
        this.panelTimeDiff = new JPanel();
        this.jLabel4 = new JLabel();
        this.fldTimeDifference = new JTextField();
        this.btnSetTimeDifference = new JButton();
        this.btnSetTime = new JButton();
        this.importPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.chkOnlyOpen = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.imageList = new JList();
        this.panelFotoAction = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblObsLoc = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.elementList = new JList();
        this.panelButtons = new JPanel();
        this.btnConnect = new JButton();
        this.btnApplyTimeDifference = new JButton();
        this.btnRemove = new JButton();
        this.btnSaveRelations = new JButton();
        this.setMaximumSize(new Dimension(450, Short.MAX_VALUE));
        this.setLayout(new BorderLayout());
        this.jScrollPane3.setMaximumSize(new Dimension(400, Short.MAX_VALUE));
        this.jScrollPane3.setMinimumSize(new Dimension(10, 23));
        this.jScrollPane3.setPreferredSize(new Dimension(360, 620));
        this.jPanel2.setMaximumSize(new Dimension(400, Short.MAX_VALUE));
        this.jPanel2.setPreferredSize(new Dimension(372, 610));
        this.jPanel2.setLayout(new GridBagLayout());
        this.clockPanel.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblDate.setFont(THEMIS.fontLabelBigBold);
        Mnemonics.setLocalizedText((JLabel)this.lblDate, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.lblDate.text"));
        this.lblDate.setMinimumSize(new Dimension(10, 73));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.lblDate, gridBagConstraints);
        this.lblTime.setFont(THEMIS.fontLabelBigBold);
        Mnemonics.setLocalizedText((JLabel)this.lblTime, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.lblTime.text"));
        this.lblTime.setMinimumSize(new Dimension(10, 73));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.lblTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.clockPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.btnSelectFolder.setFont(THEMIS.fontButton);
        this.btnSelectFolder.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_openProject24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFolder, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.btnSelectFolder.text"));
        this.btnSelectFolder.setBorder(new SoftBevelBorder(0));
        this.btnSelectFolder.setMinimumSize(new Dimension(5, 22));
        this.btnSelectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportPhotoTopComponent.this.btnSelectFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.clockPanel.add((Component)this.btnSelectFolder, gridBagConstraints);
        this.btnRemovePhoto.setFont(THEMIS.fontButton);
        this.btnRemovePhoto.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemovePhoto, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.btnRemovePhoto.text"));
        this.btnRemovePhoto.setBorder(new SoftBevelBorder(0));
        this.btnRemovePhoto.setMinimumSize(new Dimension(5, 38));
        this.btnRemovePhoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportPhotoTopComponent.this.btnRemovePhotoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.clockPanel.add((Component)this.btnRemovePhoto, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.clockPanel, gridBagConstraints);
        this.panelTimeDiff.setLayout(new GridBagLayout());
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTimeDiff.add((Component)this.jLabel4, gridBagConstraints);
        this.fldTimeDifference.setFont(THEMIS.fontTextfield);
        this.fldTimeDifference.setMinimumSize(new Dimension(80, 30));
        this.fldTimeDifference.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTimeDiff.add((Component)this.fldTimeDifference, gridBagConstraints);
        this.btnSetTimeDifference.setFont(THEMIS.fontButton);
        this.btnSetTimeDifference.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetTimeDifference, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.btnSetTimeDifference.text"));
        this.btnSetTimeDifference.setBorder(new SoftBevelBorder(0));
        this.btnSetTimeDifference.setMinimumSize(new Dimension(80, 30));
        this.btnSetTimeDifference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportPhotoTopComponent.this.btnSetTimeDifferenceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTimeDiff.add((Component)this.btnSetTimeDifference, gridBagConstraints);
        this.btnSetTime.setFont(THEMIS.fontButton);
        this.btnSetTime.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_createEvent24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetTime, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.btnSetTime.text"));
        this.btnSetTime.setBorder(new SoftBevelBorder(0));
        this.btnSetTime.setMinimumSize(new Dimension(5, 38));
        this.btnSetTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportPhotoTopComponent.this.btnSetTimeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.panelTimeDiff.add((Component)this.btnSetTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.panelTimeDiff, gridBagConstraints);
        this.importPanel.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.importPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.chkOnlyOpen.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkOnlyOpen, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.chkOnlyOpen.text"));
        this.chkOnlyOpen.setMinimumSize(new Dimension(10, 24));
        this.chkOnlyOpen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImportPhotoTopComponent.this.chkOnlyOpenItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.importPanel.add((Component)this.chkOnlyOpen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.importPanel, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(10, 20));
        this.imageList.setFont(THEMIS.fontList);
        this.imageList.setModel(this.imageListModel);
        this.imageList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ImportPhotoTopComponent.this.imageListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.imageList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.panelFotoAction.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.panelFotoAction, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblObsLoc.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObsLoc, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.lblObsLoc.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.lblObsLoc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(10, 20));
        this.elementList.setFont(THEMIS.fontList);
        this.elementList.setModel(this.elementListModel);
        this.jScrollPane2.setViewportView(this.elementList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnConnect.setFont(THEMIS.fontButton);
        this.btnConnect.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/connect24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnConnect, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.btnConnect.text"));
        this.btnConnect.setBorder(new SoftBevelBorder(0));
        this.btnConnect.setMinimumSize(null);
        this.btnConnect.setPreferredSize(null);
        this.btnConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportPhotoTopComponent.this.btnConnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelButtons.add((Component)this.btnConnect, gridBagConstraints);
        this.btnApplyTimeDifference.setFont(THEMIS.fontButton);
        this.btnApplyTimeDifference.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/connect24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApplyTimeDifference, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.btnApplyTimeDifference.text"));
        this.btnApplyTimeDifference.setBorder(new SoftBevelBorder(0));
        this.btnApplyTimeDifference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportPhotoTopComponent.this.btnApplyTimeDifferenceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelButtons.add((Component)this.btnApplyTimeDifference, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.btnRemove.text"));
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportPhotoTopComponent.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelButtons.add((Component)this.btnRemove, gridBagConstraints);
        this.btnSaveRelations.setFont(THEMIS.fontButton);
        this.btnSaveRelations.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveRelations, (String)NbBundle.getMessage(ImportPhotoTopComponent.class, (String)"ImportPhotoTopComponent.btnSaveRelations.text"));
        this.btnSaveRelations.setBorder(new SoftBevelBorder(0));
        this.btnSaveRelations.setMinimumSize(null);
        this.btnSaveRelations.setPreferredSize(null);
        this.btnSaveRelations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportPhotoTopComponent.this.btnSaveRelationsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelButtons.add((Component)this.btnSaveRelations, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.panelButtons, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.jPanel2);
        this.add(this.jScrollPane3, "Center");
    }

    private void btnSelectFolderActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        try {
            List<File> files = new ThemisFileDialog(this.bundle.getString("ImportPhotoTopComponent.chooseDirectory.text"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getPictureImportFolder(), null, THEMIS.getImageFilter(), null, true).getSelectedFiles();
            if (files != null) {
                this.loadImageFolder(files);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void imageListValueChanged(ListSelectionEvent evt) {
        ImageListEntry img = (ImageListEntry)this.imageList.getSelectedValue();
        if (img != null) {
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.FOTOIMPORT_SHOW_IMAGE.setReference((Object)img.image));
        } else {
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.FOTOIMPORT_SHOW_IMAGE.setReference(null));
        }
    }

    private void btnSetTimeDifferenceActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.automaticImageAssignment();
    }

    private void chkOnlyOpenItemStateChanged(ItemEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.updateImageList();
    }

    private void btnApplyTimeDifferenceActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        try {
            this.deltaTime = 1000L * Long.parseLong(this.fldTimeDifference.getText());
            this.automaticImageAssignment();
        }
        catch (Exception e) {
            Dialogs.getInstance().showWarningDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.errorWhileReadingValue.text"), this.fldTimeDifference.getText()));
        }
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        List imgs = this.imageList.getSelectedValuesList();
        if (imgs.isEmpty()) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.atLeastOneImage.text"));
            return;
        }
        if (this.elementList.getSelectedIndex() == 0) {
            for (ImageListEntry img : imgs) {
                img.removeElement();
            }
        } else {
            CmsElementSummary ele = (CmsElementSummary)this.elementList.getSelectedValue();
            if (ele == null) {
                Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.selectObsFirst.text"));
                return;
            }
            for (ImageListEntry img : imgs) {
                img.setElement(ele.getElement(), ele.getTitle());
            }
        }
        this.updateImageList();
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        List imgs = this.imageList.getSelectedValuesList();
        if (imgs.isEmpty()) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.chooseImageFirst.text"));
            return;
        }
        for (ImageListEntry img : imgs) {
            img.removeElement();
        }
        this.updateImageList();
    }

    private void btnSaveRelationsActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        try {
            ImageListEntry img;
            boolean imagesAssigned = false;
            Iterator<ImageListEntry> iterator = this.images.iterator();
            while (iterator.hasNext() && !(imagesAssigned = (img = iterator.next()).hasElement())) {
            }
            if (imagesAssigned) {
                this.updateObservations();
                this.images.clear();
                this.imageListModel.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateImageList();
    }

    private void btnRemovePhotoActionPerformed(ActionEvent evt) {
        this.imageListModel.removeAllElements();
        this.images.clear();
        this.updateImageList();
    }

    private void btnSetTimeActionPerformed(ActionEvent evt) {
        ImageListEntry img = (ImageListEntry)this.imageList.getSelectedValue();
        if (img == null) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/io/importer/photo/Bundle").getString("ImportPhotoTopComponent.chooseImageFirst.text"));
            return;
        }
        SetTimePanel p = new SetTimePanel();
        p.showDialog();
        if (p.hasDate()) {
            this.deltaTime = p.getDate().getTime() - img.capturetime;
            this.fldTimeDifference.setText(Long.toString(this.deltaTime / 1000L));
        }
    }

    public void componentOpened() {
        this.startClock();
        if (this.project != null && this.project.isOpen() && this.project.checkForCurrentEvent(false)) {
            this.getElements();
        }
    }

    public void componentClosed() {
        this.stopClock();
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void startClock() {
        if (this.timer == null) {
            this.timer = new Timer(100, new ClockListener());
        }
        this.timer.start();
    }

    private void stopClock() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    class ImportPhotoDnDListener
    implements DropTargetListener {
        ImportPhotoDnDListener() {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            DataFlavor[] flavors;
            event.acceptDrop(1);
            Transferable transferable = event.getTransferable();
            for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                try {
                    if (!flavor.isFlavorJavaFileListType()) continue;
                    List files = (List)transferable.getTransferData(flavor);
                    for (File f : files) {
                        if (!Util.isImageFile((String)f.getName())) continue;
                        ImageListEntry img = new ImageListEntry(f);
                        ImportPhotoTopComponent.this.images.add(img);
                        ImportPhotoTopComponent.this.imageListModel.addElement(img);
                    }
                    ImportPhotoTopComponent.this.imageList.setModel(ImportPhotoTopComponent.this.imageListModel);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            event.dropComplete(true);
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }

    class ImageListEntry {
        private File image;
        private boolean selected = true;
        private CmsElement element;
        private String elementTitle = "";
        private long lastModified = 0L;
        private long capturetime = 0L;
        private double rotation = 0.0;

        public ImageListEntry(File image) {
            this.image = image;
            this.lastModified = image.lastModified();
            try {
                Date captureDate;
                Directory sub;
                int orientation = 1;
                Metadata metadata = ImageMetadataReader.readMetadata((File)image);
                Directory directory = metadata.getDirectory(ExifIFD0Directory.class);
                if (directory != null) {
                    orientation = directory.getInt(274);
                }
                if ((sub = metadata.getDirectory(ExifSubIFDDirectory.class)) != null && (captureDate = sub.getDate(36867)) != null) {
                    this.capturetime = captureDate.getTime();
                }
                switch (orientation) {
                    case 3: {
                        this.rotation = 180.0;
                        break;
                    }
                    case 6: {
                        this.rotation = 90.0;
                        break;
                    }
                    case 8: {
                        this.rotation = 270.0;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void removeElement() {
            this.element = null;
        }

        public void setElement(CmsElement e, String t) {
            this.element = e;
            this.elementTitle = t;
        }

        public boolean hasElement() {
            return this.element != null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(this.capturetime > 0L ? this.capturetime : this.lastModified));
            sb.append("] - ");
            sb.append(this.image.getName());
            if (this.element != null) {
                sb.append(" -> ").append(this.elementTitle);
            } else if (!this.selected) {
                sb.insert(0, "[").append("]");
            }
            return sb.toString();
        }

        public void setSelected(boolean sel) {
            this.selected = sel;
            if (!sel) {
                this.element = null;
            }
        }

        public void addRotation(double rot) {
            this.rotation += rot;
            while (this.rotation < 0.0) {
                this.rotation += 360.0;
            }
            while (this.rotation >= 360.0) {
                this.rotation -= 360.0;
            }
        }
    }

    class ClockListener
    implements ActionListener {
        ClockListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Calendar now = Calendar.getInstance();
            int h = now.get(11);
            int m = now.get(12);
            int s = now.get(13);
            ImportPhotoTopComponent.this.lblTime.setText((h < 10 ? "0" : "") + h + ":" + (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s);
            ImportPhotoTopComponent.this.lblDate.setText(Util.formatDate((Date)now.getTime(), (String)Util.DATE_READ, (TimeZone)ImportPhotoTopComponent.this.project.getTimeZone()));
        }
    }
}

