/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.license;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.json.JSONException;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ThemisLicensePanel
extends ThemisPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisLicense license = THEMIS.getLicense();
    private static int LICENSE_FILE = 0;
    private static int FLOATING_SERVER = 1;
    private JButton btnActivate;
    private JButton btnCloseDialog;
    private JButton btnCopy;
    private JButton btnDeactivate;
    private JButton btnReadLicensefile;
    private JCheckBox chkTestServer;
    private JTextField fldDate;
    private JTextField fldFloatingPort;
    private JTextField fldFloatingServer;
    private JTextField fldKey;
    private JTextArea fldLicenseInfo;
    private JComboBox<String> fldLicenseType;
    private JTextField fldStatus;
    private JLabel jLabel1;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JLabel lblFloatingServer;
    private JLabel lblFloatingServer1;
    private JLabel lblKey;
    private JPanel panelFloatingLicense;

    public ThemisLicensePanel() {
        this.initComponents();
        this.populatePanel();
    }

    private void populatePanel() {
        if (!ThemisApplication.getInstance().getLicense().isInternalLicense()) {
            this.chkTestServer.setVisible(false);
        }
        this.fldLicenseInfo.setText(this.license.getComputerInfo());
        this.btnDeactivate.setVisible(this.license.hasFeature("deactivate"));
        int licensetype = ThemisApplication.getInstance().getSettings().getLicenseType();
        String floatingServer = "";
        if (licensetype == FLOATING_SERVER) {
            floatingServer = ThemisApplication.getInstance().getSettings().getLicenseFloatingServer();
            String[] serverAndPort = floatingServer.split(":");
            this.fldFloatingServer.setText(serverAndPort[0]);
            if (serverAndPort.length > 1) {
                this.fldFloatingPort.setText(serverAndPort[1]);
            } else {
                this.fldFloatingPort.setText("");
            }
        }
        this.fldLicenseType.setSelectedIndex(licensetype);
        this.lblFloatingServer.setVisible(licensetype == FLOATING_SERVER);
        this.panelFloatingLicense.setVisible(licensetype == FLOATING_SERVER);
        this.lblKey.setVisible(licensetype == LICENSE_FILE);
        this.fldKey.setVisible(licensetype == LICENSE_FILE);
        ThemisProject project = this.app.getProject();
        this.fldStatus.setText(project.getResourceText("license.invalid"));
        this.fldStatus.setBackground(Color.RED);
        String liecenseKey = this.license.getLicenseDetails().getLicenseKey();
        if ("".equals(this.fldKey.getText())) {
            this.fldKey.setText(liecenseKey);
        }
        if (this.license.hasLicense()) {
            this.fldStatus.setText(project.getResourceText("license.activated"));
            this.fldStatus.setBackground(Color.GREEN);
        } else {
            String licenseStatus = this.license.getLicenseDetails().getLicenseStatus();
            this.fldStatus.setText(project.getResourceText(licenseStatus));
            this.fldStatus.setBackground(Color.RED);
        }
        this.fldDate.setText(Util.formatDate((Date)this.license.getLicenseDetails().getValidUntil(), (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone()));
        this.fldLicenseInfo.setText(this.license.getLicenseDetails().getLicenseStatusDescription());
    }

    private void activateLicense() {
        BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ThemisLicensePanel.this.fldLicenseType.getSelectedIndex() == LICENSE_FILE) {
                    if ("".equals(ThemisLicensePanel.this.fldKey.getText().trim())) {
                        ThemisLicensePanel.this.app.getDialog().showInfoDialog(ThemisLicensePanel.this.app.getProject().getResourceText("license.no-key", ThemisLicensePanel.this.app.getLocale()));
                        return;
                    }
                    String key = ThemisLicensePanel.this.fldKey.getText().trim();
                    boolean problemWithKey = false;
                    if (key.length() != 29) {
                        ThemisLicensePanel.this.app.getDialog().showWarningDialog(ThemisLicensePanel.this.app.getProject().getResourceText("license.problem-with-key.text", ThemisLicensePanel.this.app.getLocale()));
                        return;
                    }
                    if (!("-".equals(String.valueOf(key.charAt(5))) && "-".equals(String.valueOf(key.charAt(11))) && "-".equals(String.valueOf(key.charAt(17))) && "-".equals(String.valueOf(key.charAt(23))))) {
                        ThemisLicensePanel.this.app.getDialog().showWarningDialog(ThemisLicensePanel.this.app.getProject().getResourceText("license.problem-with-key.text", ThemisLicensePanel.this.app.getLocale()));
                        return;
                    }
                    ThemisLicensePanel.this.license.setTestService(ThemisLicensePanel.this.chkTestServer.isSelected());
                    ThemisLicensePanel.this.license.activateLicenseOnServer(key);
                    switch (ThemisLicensePanel.this.license.getLicenseDetails().getErrorType()) {
                        case SERVER_ERROR: {
                            ThemisLicensePanel.this.app.getDialog().showErrorDialog("license.error.no-connection");
                            break;
                        }
                        case ALL_IN_USE: {
                            ThemisLicensePanel.this.app.getDialog().showErrorDialog("license.error.activation-max-reached");
                            break;
                        }
                        case KEY_UNKOWN: {
                            ThemisLicensePanel.this.app.getDialog().showErrorDialog("license.invalid");
                            break;
                        }
                        case OTHER: {
                            ThemisLicensePanel.this.app.getDialog().showErrorDialog("license.error.no-activation");
                            break;
                        }
                    }
                } else {
                    ThemisLicensePanel.this.license.setFloatingServer(ThemisLicensePanel.this.fldFloatingServer.getText().trim() + ":" + ThemisLicensePanel.this.fldFloatingPort.getText().trim());
                    ThemisLicensePanel.this.license.activateLicense();
                }
                ThemisLicensePanel.this.app.getActionProvider().invokeAction(ThemisAction.LICENSE_CHANGED);
                ThemisLicensePanel.this.populatePanel();
                ThemisApplication.getInstance().getGUImanager().setTitle();
            }
        }, (String)this.app.getProject().getResourceText("progress.activating-license"));
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.fldLicenseType = new JComboBox();
        this.lblKey = new JLabel();
        this.fldKey = new JTextField();
        this.lblFloatingServer = new JLabel();
        this.panelFloatingLicense = new JPanel();
        this.fldFloatingServer = new JTextField();
        this.lblFloatingServer1 = new JLabel();
        this.fldFloatingPort = new JTextField();
        this.jLabel1 = new JLabel();
        this.fldStatus = new JTextField();
        this.jLabel9 = new JLabel();
        this.fldDate = new JTextField();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.btnReadLicensefile = new JButton();
        this.btnCopy = new JButton();
        this.btnActivate = new JButton();
        this.btnDeactivate = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.fldLicenseInfo = new JTextArea();
        this.chkTestServer = new JCheckBox();
        this.btnCloseDialog = new JButton();
        this.setFont(THEMIS.fontButton);
        this.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.jPanel2.border.title"), 0, 0, THEMIS.fontSubheading));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.jLabel8.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        this.fldLicenseType.setFont(THEMIS.fontList);
        this.fldLicenseType.setModel(new DefaultComboBoxModel<String>(new String[]{this.app.getProject().getResourceText("license.standard"), this.app.getProject().getResourceText("license.floating")}));
        this.fldLicenseType.setMinimumSize(null);
        this.fldLicenseType.setPreferredSize(null);
        this.fldLicenseType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThemisLicensePanel.this.fldLicenseTypeItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add(this.fldLicenseType, gridBagConstraints);
        this.lblKey.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblKey, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.lblKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblKey, gridBagConstraints);
        this.fldKey.setFont(THEMIS.fontTextfield);
        this.fldKey.setText(NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.fldKey.text"));
        this.fldKey.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                ThemisLicensePanel.this.fldKeyInputMethodTextChanged(evt);
            }
        });
        this.fldKey.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ThemisLicensePanel.this.fldKeyKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldKey, gridBagConstraints);
        this.lblFloatingServer.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblFloatingServer, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.lblFloatingServer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblFloatingServer, gridBagConstraints);
        this.panelFloatingLicense.setLayout(new GridBagLayout());
        this.fldFloatingServer.setFont(THEMIS.fontTextfield);
        this.fldFloatingServer.setText(NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.fldFloatingServer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.panelFloatingLicense.add((Component)this.fldFloatingServer, gridBagConstraints);
        this.lblFloatingServer1.setFont(THEMIS.fontLabel);
        this.lblFloatingServer1.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lblFloatingServer1, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.lblFloatingServer1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFloatingLicense.add((Component)this.lblFloatingServer1, gridBagConstraints);
        this.fldFloatingPort.setFont(THEMIS.fontTextfield);
        this.fldFloatingPort.setText(NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.fldFloatingPort.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFloatingLicense.add((Component)this.fldFloatingPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.panelFloatingLicense, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.fldStatus.setEditable(false);
        this.fldStatus.setFont(THEMIS.fontTextfield);
        this.fldStatus.setText(NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.fldStatus.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldStatus, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints);
        this.fldDate.setEditable(false);
        this.fldDate.setFont(THEMIS.fontTextfield);
        this.fldDate.setText(NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.fldDate.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldDate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnReadLicensefile.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnReadLicensefile, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.btnReadLicensefile.text"));
        this.btnReadLicensefile.setMinimumSize(null);
        this.btnReadLicensefile.setPreferredSize(null);
        this.btnReadLicensefile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLicensePanel.this.btnReadLicensefileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnReadLicensefile, gridBagConstraints);
        this.btnCopy.setFont(THEMIS.fontButton);
        this.btnCopy.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopy, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.btnCopy.text"));
        this.btnCopy.setMinimumSize(null);
        this.btnCopy.setPreferredSize(null);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLicensePanel.this.btnCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnCopy, gridBagConstraints);
        this.btnActivate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnActivate, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.btnActivate.text"));
        this.btnActivate.setMinimumSize(null);
        this.btnActivate.setPreferredSize(null);
        this.btnActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLicensePanel.this.btnActivateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnActivate, gridBagConstraints);
        this.btnDeactivate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeactivate, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.btnDeactivate.text"));
        this.btnDeactivate.setMinimumSize(null);
        this.btnDeactivate.setPreferredSize(null);
        this.btnDeactivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLicensePanel.this.btnDeactivateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnDeactivate, gridBagConstraints);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, 716, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.fldLicenseInfo.setEditable(false);
        this.fldLicenseInfo.setColumns(20);
        this.fldLicenseInfo.setFont(THEMIS.fontTextfieldFixed);
        this.fldLicenseInfo.setLineWrap(true);
        this.fldLicenseInfo.setRows(5);
        this.jScrollPane1.setViewportView(this.fldLicenseInfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkTestServer, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.chkTestServer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.add((Component)this.chkTestServer, gridBagConstraints);
        this.btnCloseDialog.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCloseDialog, (String)NbBundle.getMessage(ThemisLicensePanel.class, (String)"ThemisLicensePanel.btnCloseDialog.text"));
        this.btnCloseDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLicensePanel.this.btnCloseDialogActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnCloseDialog, gridBagConstraints);
    }

    private void btnActivateActionPerformed(ActionEvent evt) {
        this.activateLicense();
    }

    private void fldLicenseTypeItemStateChanged(ItemEvent evt) {
        boolean standardLicense = this.fldLicenseType.getSelectedIndex() == LICENSE_FILE;
        this.lblFloatingServer.setVisible(!standardLicense);
        this.panelFloatingLicense.setVisible(!standardLicense);
        this.lblKey.setVisible(standardLicense);
        this.fldKey.setVisible(standardLicense);
        this.btnReadLicensefile.setVisible(standardLicense);
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        StringSelection stringSelection = new StringSelection(this.fldLicenseInfo.getText());
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
        THEMIS.prepareEmail("THEMIS License " + this.app.getLicense().getClientID(), this.fldLicenseInfo.getText(), false, null);
    }

    private void btnDeactivateActionPerformed(ActionEvent evt) {
        if (this.license.isDeactivationAllowed()) {
            this.license.deactivate();
            this.app.getActionProvider().invokeAction(ThemisAction.LICENSE_CHANGED);
            this.populatePanel();
        } else {
            this.app.getDialog().showInfoDialog(this.app.getProject().getResourceText("license.no-license", this.app.getLocale()));
        }
    }

    private void btnReadLicensefileActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.app.getProject().getResourceText("license.load-license-file", this.app.getLocale()), ThemisFileDialog.DIALOGTYPE.OPEN, new File(System.getProperty("user.home") + "/Desktop"), null, new FileNameExtensionFilter(this.app.getProject().getResourceText("license.file-types", this.app.getLocale()), "lic", "txt"), null, false).getSelectedFile();
        if (f != null) {
            try {
                Util.copy((File)f, (File)this.license.getLicenseDetails().getFile());
                this.license.getLicenseDetails().fromFile();
                Util.stringToFile((String)this.license.getLicenseDetails().getLicenseKey(), (File)this.license.getLicenseDetails().getKeyFile());
            }
            catch (IOException | JSONException throwable) {
                // empty catch block
            }
            if (!this.license.getLicenseDetails().isValid()) {
                this.app.getDialog().showErrorDialog(this.app.getProject().getResourceText("license.invalid-file", this.app.getLocale()));
                Util.delete((File)this.license.getLicenseDetails().getFile());
                Util.delete((File)this.license.getLicenseDetails().getKeyFile());
            }
            this.populatePanel();
            this.app.getActionProvider().invokeAction(ThemisAction.LICENSE_CHANGED);
            ThemisApplication.getInstance().getGUImanager().setTitle();
        }
    }

    private void fldKeyInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void fldKeyKeyReleased(KeyEvent evt) {
    }

    private void btnCloseDialogActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    @Override
    public void populate(ProgressHandler ph) {
        this.populatePanel();
    }

    @Override
    public void apply() {
        String key;
        String keyInDialog = this.fldKey.getText();
        if (!keyInDialog.equals(key = this.license.getLicenseDetails().getLicenseKey())) {
            this.app.getDialog().showInfoDialog("warning.license-key-not-updated");
        }
    }

    @Override
    public String getDialogCode() {
        return "themislicensepanel";
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(920, 590);
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(620, 480);
    }
}

