/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.gui.Dialogs;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.observation.PlaceholderForEmail;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.util.EmailSendThread;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EmailTemplatePanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    Properties placeholder_mapping;
    String smtp;
    String port;
    String encrypt;
    File folder;
    private JButton btnSend;
    private JButton btnSend1;
    private JCheckBox chkRemoveLineFeed;
    private JCheckBox chkSingle;
    private JPasswordField fldAuthPwd;
    private JTextField fldAuthUser;
    private JTextField fldCountObs;
    private JTextField fldEmailAbout;
    private JTextField fldEmailBCC;
    private JTextField fldEmailRecipient;
    private JTextField fldEmailSender;
    private JTextArea fldTextFinal;
    private JTextArea fldTextIntro;
    private JTextArea fldTextLocation;
    private JTextArea fldTextObservation;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JLabel lblError;

    public EmailTemplatePanel() {
        this.initComponents();
        try {
            this.placeholder_mapping = Placeholder.loadMapping((String)"placeholder_mapping.properties");
            this.placeholder_mapping.putAll((Map<?, ?>)Placeholder.loadMapping((String)"placeholder_mapping_v4.properties"));
        }
        catch (IOException ex) {
            at.grid.themis.application.api.Dialogs.getInstance().showErrorDialog("error.read-placeholder-mapping", ex);
        }
        this.populate();
    }

    public void setFolder(File f) {
        this.folder = f;
    }

    public void populate() {
        this.fldCountObs.setText(Integer.toString(this.project.getSelectionManager().getSelectedObservationIds().size()));
        this.fldTextIntro.setText(this.project.getProjectProperty("emailtemplate.txtintro", ""));
        this.fldTextFinal.setText(this.project.getProjectProperty("emailtemplate.txtfinal", ""));
        this.fldTextLocation.setText(this.project.getProjectProperty("emailtemplate.txtlocation", ""));
        this.fldTextObservation.setText(this.project.getProjectProperty("emailtemplate.txtobservation", ""));
        this.fldEmailSender.setText(this.project.getProjectProperty("emailtemplate.emailfrom", ""));
        this.fldEmailRecipient.setText(this.project.getProjectProperty("emailtemplate.emailto", ""));
        this.fldEmailBCC.setText(this.project.getProjectProperty("emailtemplate.emailbcc", ""));
        this.fldEmailAbout.setText(this.project.getProjectProperty("emailtemplate.emailsubject", ""));
        this.fldAuthUser.setText(this.project.getProjectProperty("emailtemplate.emailauthuser", ""));
        this.chkSingle.setSelected("1".equals(this.project.getProjectProperty("emailtemplate.singlemail", "0")));
        this.chkRemoveLineFeed.setSelected("1".equals(this.project.getProjectProperty("emailtemplate.removelinefeed", "0")));
        if (ThemisApplication.emailAuthenticationPassword != null) {
            this.fldAuthPwd.setText(ThemisApplication.emailAuthenticationPassword);
        }
        this.smtp = this.app.getConfiguration("system.email.smtp");
        this.port = this.app.getConfiguration("system.email.port", "587");
        this.encrypt = this.app.getConfiguration("system.email.encrypt", "0");
        if (this.smtp == null || "".equals(this.smtp)) {
            this.lblError.setText("E-Mail Konfiguration nicht definiert");
        }
    }

    public void apply() {
        this.project.setProjectProperty("emailtemplate.txtintro", this.fldTextIntro.getText());
        this.project.setProjectProperty("emailtemplate.txtfinal", this.fldTextFinal.getText());
        this.project.setProjectProperty("emailtemplate.txtlocation", this.fldTextLocation.getText());
        this.project.setProjectProperty("emailtemplate.txtobservation", this.fldTextObservation.getText());
        this.project.setProjectProperty("emailtemplate.emailfrom", this.fldEmailSender.getText());
        this.project.setProjectProperty("emailtemplate.emailto", this.fldEmailRecipient.getText());
        this.project.setProjectProperty("emailtemplate.emailbcc", this.fldEmailBCC.getText());
        this.project.setProjectProperty("emailtemplate.emailsubject", this.fldEmailAbout.getText());
        this.project.setProjectProperty("emailtemplate.emailauthuser", this.fldAuthUser.getText());
        this.project.setProjectProperty("emailtemplate.singlemail", this.chkSingle.isSelected() ? "1" : "0");
        this.project.setProjectProperty("emailtemplate.removelinefeed", this.chkRemoveLineFeed.isSelected() ? "1" : "0");
        String p = new String(this.fldAuthPwd.getPassword());
        if (!"".equals(p)) {
            ThemisApplication.emailAuthenticationPassword = p;
        }
    }

    public void sendEmails(final boolean saveToFile) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                String templateText = EmailTemplatePanel.this.replacePlaceholderMapping(EmailTemplatePanel.this.fldTextObservation.getText());
                String templateBetreff = EmailTemplatePanel.this.replacePlaceholderMapping(EmailTemplatePanel.this.fldEmailAbout.getText());
                templateText = EmailTemplatePanel.this.replaceTemplateProject(templateText);
                templateBetreff = EmailTemplatePanel.this.replaceTemplateProject(templateBetreff);
                boolean sendSingle = EmailTemplatePanel.this.chkSingle.isSelected();
                boolean sendRemoveLinefeed = EmailTemplatePanel.this.chkRemoveLineFeed.isSelected();
                StringBuilder sb = new StringBuilder();
                if (!sendSingle) {
                    sb.append(EmailTemplatePanel.this.fldTextIntro.getText());
                }
                String emailBetreff = templateBetreff;
                boolean error = false;
                int counter = 0;
                Iterator iterator = EmailTemplatePanel.this.project.getSelectionManager().getSelectedObservationIds().iterator();
                while (iterator.hasNext()) {
                    long obsId = (Long)iterator.next();
                    CmsObservation obs = (CmsObservation)EmailTemplatePanel.this.project.loadElement(obsId, EmailTemplatePanel.this.project.getUser());
                    CmsLocation loc = obs.getLocation();
                    CmsEvent event = (CmsEvent)EmailTemplatePanel.this.project.loadElement(obs.getLatestHistory().getEventId(), EmailTemplatePanel.this.project.getUser());
                    String emailText = EmailTemplatePanel.this.replaceTemplateObservation((CmsElement)obs, templateText);
                    emailText = EmailTemplatePanel.this.replaceTemplateObservation((CmsElement)loc, emailText);
                    emailText = EmailTemplatePanel.this.replaceTemplateObservation((CmsElement)event, emailText);
                    emailBetreff = EmailTemplatePanel.this.replaceTemplateObservation((CmsElement)obs, templateBetreff);
                    emailBetreff = EmailTemplatePanel.this.replaceTemplateObservation((CmsElement)loc, emailBetreff);
                    emailBetreff = EmailTemplatePanel.this.replaceTemplateObservation((CmsElement)event, emailBetreff);
                    if (emailText.indexOf("\r\n") < 0) {
                        emailText = emailText.replaceAll("\n", "\r\n");
                    }
                    if (sendSingle) {
                        emailText = EmailTemplatePanel.this.fldTextIntro.getText() + emailText + EmailTemplatePanel.this.fldTextFinal.getText();
                        error = error || !EmailTemplatePanel.this.sendMail(++counter, emailBetreff, emailText, error, saveToFile);
                        continue;
                    }
                    sb.append(emailText);
                }
                if (!sendSingle) {
                    sb.append(EmailTemplatePanel.this.fldTextFinal.getText());
                    EmailTemplatePanel.this.sendMail(++counter, emailBetreff, sb.toString(), false, saveToFile);
                } else if (error) {
                    Dialogs.showErrorDialog((String)"Es konnten nicht alle E-Mails gesendet werden.");
                }
            }
        };
        BaseProgressUtils.showProgressDialogAndRun((Runnable)runner, (String)"Die E-Mails werden versendet ...");
    }

    private boolean sendMail(int counter, String betreff, String txt, boolean ignoreError, boolean saveToFile) {
        if (saveToFile) {
            try {
                Properties props = new Properties();
                props.setProperty("mail.transport.protocol", "smtp");
                Session mailSession = Session.getDefaultInstance((Properties)props, null);
                MimeMessage message = new MimeMessage(mailSession);
                message.setSubject(betreff);
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.fldEmailRecipient.getText()));
                message.setHeader("X-Unsent", "1");
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Object)txt, "text/txt");
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                message.setContent((Multipart)multipart);
                String filename = counter + ".eml";
                File emailfile = new File(this.folder, filename);
                FileOutputStream fos = new FileOutputStream(emailfile);
                message.writeTo((OutputStream)fos);
                fos.close();
                return true;
            }
            catch (MessagingException ex) {
                if (!ignoreError) {
                    at.grid.themis.application.api.Dialogs.getInstance().showErrorDialog("error.cannot-save-email", (Exception)((Object)ex));
                }
                return false;
            }
            catch (FileNotFoundException ex) {
                if (!ignoreError) {
                    at.grid.themis.application.api.Dialogs.getInstance().showErrorDialog("error.cannot-save-email", ex);
                }
                return false;
            }
            catch (IOException ex) {
                if (!ignoreError) {
                    at.grid.themis.application.api.Dialogs.getInstance().showErrorDialog("error.cannot-save-email", ex);
                }
                return false;
            }
        }
        EmailSendThread email = new EmailSendThread(betreff, txt);
        email.setServer(this.smtp, Integer.parseInt(this.port), Integer.parseInt(this.encrypt));
        email.addRecipient(this.fldEmailRecipient.getText());
        email.setFrom(this.fldEmailSender.getText());
        String bcc = this.fldEmailBCC.getText();
        if (bcc.contains("@")) {
            email.setBcc(bcc);
        }
        if (!"".equals(this.fldAuthUser.getText())) {
            email.setAuthentication(this.fldAuthUser.getText(), new String(this.fldAuthPwd.getPassword()));
        }
        return email.send(ignoreError);
    }

    private String replaceLinefeed(String txt) {
        if (this.chkRemoveLineFeed.isSelected()) {
            return txt.replace("\n", " | ");
        }
        return txt;
    }

    private String replacePlaceholderMapping(String template) {
        String result = new String(template);
        for (String string : this.placeholder_mapping.keySet()) {
            result = result.replaceAll("#!#" + string + "#!#", "#!#" + this.placeholder_mapping.getProperty(string) + "#!#");
        }
        return result;
    }

    private String replaceTemplateProject(String template) {
        String result = new String(template);
        CmsProject projectElement = this.project.getProjectElement();
        result = result.replaceAll("#!#project.client#!#", projectElement.getAttributeValue("customer", ""));
        result = result.replaceAll("#!#project.title#!#", projectElement.getAttributeValue("projecttitle", ""));
        result = result.replaceAll("#!#project.number#!#", projectElement.getAttributeValue("projectnumber", ""));
        result = result.replaceAll("#!#project.description#!#", this.replaceLinefeed(projectElement.getAttributeValue("info", "")));
        result = result.replaceAll("#!#project.location#!#", projectElement.getAttributeValue("projectlocation", ""));
        result = result.replaceAll("#!#other.user#!#", this.project.getUser().getUsername());
        result = result.replaceAll("#!#other.now-date#!#", Util.formatDate((Date)new Date(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
        result = result.replaceAll("#!#other.now-datetime#!#", Util.formatDate((Date)new Date(), (String)Util.DATETIME_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
        return result;
    }

    private String replaceTemplateObservation(CmsElement obs, String template) {
        ArrayList<PlaceholderForEmail> placeholders = PlaceholderForEmail.analyse(template);
        String result = new String(template);
        for (PlaceholderForEmail ph : placeholders) {
            ph.setContent(obs);
            result = ph.apply(result);
        }
        return result;
    }

    private String replaceTemplateLocation(CmsLocation loc, String template) {
        String result = new String(template);
        for (CmsAttribute att : loc.getAttributes()) {
            String val = att.getValue();
            val = this.replaceLinefeed(val);
            result = result.replaceAll("#!#location." + att.getCode() + "#!#", val);
        }
        return result;
    }

    private String replaceTemplateEvent(CmsEvent ev, String template) {
        String result = new String(template);
        for (CmsAttribute att : ev.getAttributes()) {
            result = result.replaceAll("#!#event." + att.getCode() + "#!#", att.getValue());
        }
        return result;
    }

    private String replaceTemplateMetadata(CmsElement ele, String template) {
        String result = new String(template);
        for (CmsAttribute att : ele.getMetaAttributes()) {
            result = result.replaceAll("#!#event." + att.getCode() + "#!#", att.getValue());
        }
        return result;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldTextIntro = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.fldTextObservation = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.fldTextLocation = new JTextArea();
        this.jScrollPane4 = new JScrollPane();
        this.fldTextFinal = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.fldCountObs = new JTextField();
        this.jLabel6 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.fldEmailRecipient = new JTextField();
        this.jLabel8 = new JLabel();
        this.fldEmailBCC = new JTextField();
        this.btnSend = new JButton();
        this.chkSingle = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.fldEmailAbout = new JTextField();
        this.chkRemoveLineFeed = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.fldAuthPwd = new JPasswordField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.fldAuthUser = new JTextField();
        this.jLabel13 = new JLabel();
        this.fldEmailSender = new JTextField();
        this.btnSend1 = new JButton();
        this.lblError = new JLabel();
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel3.text"));
        this.fldTextIntro.setColumns(20);
        this.fldTextIntro.setFont(THEMIS.fontTextfieldFixed);
        this.fldTextIntro.setRows(5);
        this.jScrollPane1.setViewportView(this.fldTextIntro);
        this.fldTextObservation.setColumns(20);
        this.fldTextObservation.setFont(THEMIS.fontTextfieldFixed);
        this.fldTextObservation.setRows(5);
        this.jScrollPane3.setViewportView(this.fldTextObservation);
        this.fldTextLocation.setColumns(20);
        this.fldTextLocation.setFont(THEMIS.fontTextfieldFixed);
        this.fldTextLocation.setRows(5);
        this.jScrollPane2.setViewportView(this.fldTextLocation);
        this.fldTextFinal.setColumns(20);
        this.fldTextFinal.setFont(THEMIS.fontTextfieldFixed);
        this.fldTextFinal.setRows(5);
        this.jScrollPane4.setViewportView(this.fldTextFinal);
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel2.text"));
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel4.text"));
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel7.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 199, Short.MAX_VALUE).addComponent(this.jScrollPane2).addComponent(this.jScrollPane3).addComponent(this.jScrollPane4).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel7)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, -1, -2)));
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel5.text"));
        this.fldCountObs.setFont(THEMIS.fontTextfield);
        this.fldCountObs.setText(NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.fldCountObs.text"));
        this.fldCountObs.setEnabled(false);
        this.jLabel6.setFont(THEMIS.fontLabelBigBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel6.text"));
        this.jComboBox1.setFont(THEMIS.fontTextfield);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Beobachtung Kontakt", "Adresse unten", "Kontakt + Adresse", "Kontakt oder Adresse"}));
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel1.text"));
        this.fldEmailRecipient.setFont(THEMIS.fontTextfield);
        this.fldEmailRecipient.setText(NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.fldEmailRecipient.text"));
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel8.text"));
        this.fldEmailBCC.setFont(THEMIS.fontTextfield);
        this.fldEmailBCC.setText(NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.fldEmailBCC.text"));
        this.btnSend.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSend, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.btnSend.text"));
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmailTemplatePanel.this.btnSendActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.chkSingle, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.chkSingle.text"));
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel9.text"));
        this.fldEmailAbout.setFont(THEMIS.fontTextfield);
        this.fldEmailAbout.setText(NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.fldEmailAbout.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkRemoveLineFeed, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.chkRemoveLineFeed.text"));
        this.jLabel10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel10.text"));
        this.fldAuthPwd.setText(NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.fldAuthPwd.text"));
        this.jLabel11.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel11.text"));
        this.jLabel12.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel12.text"));
        this.fldAuthUser.setFont(THEMIS.fontTextfield);
        this.fldAuthUser.setText(NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.fldAuthUser.text"));
        this.jLabel13.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.jLabel13.text"));
        this.fldEmailSender.setFont(THEMIS.fontTextfield);
        this.fldEmailSender.setText(NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.fldEmailSender.text"));
        this.btnSend1.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSend1, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.btnSend1.text"));
        this.btnSend1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmailTemplatePanel.this.btnSend1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 170, Short.MAX_VALUE).addComponent(this.fldCountObs, -2, 120, -2)).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE).addComponent(this.fldEmailRecipient).addComponent(this.fldEmailBCC).addComponent(this.fldEmailAbout).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel11, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel12, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fldAuthPwd, -1, 376, Short.MAX_VALUE).addComponent(this.fldAuthUser))).addComponent(this.fldEmailSender).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel1).addComponent(this.jLabel8).addComponent(this.chkSingle).addComponent(this.jLabel9).addComponent(this.chkRemoveLineFeed).addComponent(this.jLabel10).addComponent(this.jLabel13)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.btnSend, -2, 202, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE).addComponent(this.btnSend1, -2, 202, -2)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.fldCountObs, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.chkSingle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkRemoveLineFeed).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldEmailSender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldEmailAbout, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldEmailRecipient, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldEmailBCC, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.fldAuthUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldAuthPwd, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSend, -2, 40, -2).addComponent(this.btnSend1, -2, 40, -2)).addGap(0, 19, Short.MAX_VALUE)));
        this.lblError.setFont(THEMIS.fontLabelBold);
        this.lblError.setForeground(Color.red);
        Mnemonics.setLocalizedText((JLabel)this.lblError, (String)NbBundle.getMessage(EmailTemplatePanel.class, (String)"EmailTemplatePanel.lblError.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.lblError, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblError).addGap(6, 6, 6))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnSendActionPerformed(ActionEvent evt) {
        this.sendEmails(false);
        this.apply();
    }

    private void btnSend1ActionPerformed(ActionEvent evt) {
        this.sendEmails(true);
        this.apply();
    }
}

