/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ThemisActions;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.barcode.CreateBarcodePanel;
import at.grid.themis.application.barcode.PrintBarcodePanel;
import at.grid.themis.application.config.LocationListOptionPanel;
import at.grid.themis.application.config.ProjectSettingsPanel;
import at.grid.themis.application.observation.LocationListSingleEntryPanel;
import at.grid.themis.application.observation.MapReferencePanel;
import at.grid.themis.application.planviewer.MultiLocationPanel;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.settings.ThemisSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class LocationListPanel
extends JPanel
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisFilter filter = this.app.getFilter();
    DefaultComboBoxModel modelLocGroup = new DefaultComboBoxModel();
    private String tablesort = "ele.number";
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle");
    int selectedUserAction = 0;
    DragScrollHandler dsh;
    TopComponent tc = null;
    private JButton btnAddLocation;
    private JButton btnClearLocFreeText;
    private JButton btnCopy;
    private JButton btnDelete;
    private JButton btnEdit;
    private JButton btnSearchLocFreeText;
    private JButton btnShowInPlan;
    private JButton btnToggleSelection;
    private JButton btnUserAction;
    private JTextField fldLocFreeText;
    private JComboBox fldLocGroup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblLocGroup;
    private JLabel lblLocation1;
    private JLabel locListSettings;
    private JPanel locationListPanel;
    private JPanel locationlistHeaderPanel;
    private JScrollPane locationlistScroll;
    private JPanel mainPanel;
    private JPanel panelLocFreeText;
    private JPanel panelLocGroup;

    public LocationListPanel(TopComponent tc, boolean editor) {
        THEMIS.getLicense();
        this.initComponents();
        this.updateLicenseSpecifications();
        this.updateHeader();
        this.dsh = new DragScrollHandler(this.locationListPanel, false, true);
        this.tc = tc;
        if (editor) {
            ThemisActionProvider.getInstance().registerEditor(this);
        } else {
            ThemisActionProvider.getInstance().register(this);
        }
    }

    private void showActionMenu() {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        JPopupMenu menu = new JPopupMenu("Optionen");
        JMenuItem item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.loc.change-plan"), Color.WHITE, false, null);
        item.addActionListener(e2 -> this.changePlan(this.getSelectedLocationIds().size() > 1));
        menu.add(item);
        item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.loc.create-barcode"), Color.WHITE, false, null);
        item.addActionListener(e2 -> new CreateBarcodePanel().showDialog());
        menu.add(item);
        item = THEMIS.createMenuItem(this.app.getProject().getResourceText("user-action.loc.print-barcode"), Color.WHITE, false, null);
        item.addActionListener(e2 -> new PrintBarcodePanel().showDialog());
        menu.add(item);
        menu.add(THEMIS.createSeparator(Color.WHITE));
        int c = menu.getComponentCount();
        menu.show(this.btnUserAction, this.btnUserAction.getWidth(), 0);
    }

    public void onAction(ThemisAction action) {
        if (this == action.getSource() || action.getSource() instanceof LocationListSingleEntryPanel) {
            return;
        }
        switch (action.getAction()) {
            case 1101: {
                this.clear();
                if (this.tc == null) break;
                SwingUtilities.invokeLater(() -> this.tc.setDisplayName(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("LocationListTopComponent.componentTitle.text")));
                break;
            }
            case 1100: {
                this.clear();
                this.loadLocationGroups();
                this.checkSortOption();
                this.updateHeader();
                this.updateLocationList();
                this.updateFilter(false);
                this.updateLicenseSpecifications();
                break;
            }
            case 501: 
            case 1300: {
                this.updateLocationList();
                break;
            }
            case 651: {
                this.updateLocationList();
                this.setLocationSelection(false);
                break;
            }
            case 650: {
                this.setLocationSelection();
                this.updateActions();
                break;
            }
            case 1110: {
                this.updateLocationList();
                this.updateFilter(false);
                break;
            }
            case 1102: 
            case 1103: {
                this.loadLocationGroups();
                this.checkSortOption();
                this.updateHeader();
                this.updateLocationList();
                this.updateFilter(false);
            }
        }
    }

    public void clear() {
        this.fldLocFreeText.setText("");
        this.fldLocGroup.removeAllItems();
        this.locationListPanel.removeAll();
    }

    public void selectAllLocations(boolean setSelected) {
        Component[] components;
        ArrayList<Long> locIds = new ArrayList<Long>();
        for (Component c : components = this.locationListPanel.getComponents()) {
            if (!(c instanceof LocationListSingleEntryPanel)) continue;
            ((LocationListSingleEntryPanel)c).setSelectCheckbox(setSelected);
            if (!setSelected) continue;
            locIds.add(((LocationListSingleEntryPanel)c).getId());
        }
        this.project.getSelectionManager().setSelectedLocations(locIds, true, (Object)this);
        this.setHeaderCheckbox(setSelected);
    }

    private void updateActions() {
        boolean hasLicense = this.app.getLicense().hasLicense();
        this.btnAddLocation.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnCopy.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnShowInPlan.setEnabled(false);
        this.btnUserAction.setEnabled(false);
        if (!this.app.getProject().isOpen()) {
            return;
        }
        if (this.app.getProject().getSelectionManager().hasSelectedLocationIds()) {
            this.btnEdit.setEnabled(hasLicense);
            this.btnCopy.setEnabled(hasLicense);
            this.btnDelete.setEnabled(hasLicense);
            this.btnUserAction.setEnabled(true);
            this.btnShowInPlan.setEnabled(true);
        }
        this.btnAddLocation.setEnabled(hasLicense);
    }

    private void updateLicenseSpecifications() {
    }

    public void setLocationSelection() {
        this.setLocationSelection(true);
    }

    public void setLocationSelection(boolean scrollTo) {
        ArrayList ids = this.project.getSelectionManager().getSelectedLocationIds();
        Component[] components = this.locationListPanel.getComponents();
        Component cFirstSel = null;
        for (Component c : components) {
            if (!(c instanceof LocationListSingleEntryPanel)) continue;
            boolean sel = ids.contains(((LocationListSingleEntryPanel)c).getId());
            ((LocationListSingleEntryPanel)c).setSelectCheckbox(sel);
            if (!sel || cFirstSel != null) continue;
            cFirstSel = c;
        }
        if (scrollTo && cFirstSel != null) {
            this.locationListPanel.scrollRectToVisible(cFirstSel.getBounds());
        }
    }

    private void setHeaderCheckbox(boolean selected) {
        for (Component c : this.locationlistHeaderPanel.getComponents()) {
            if (!(c instanceof LocationListSingleEntryPanel)) continue;
            ((LocationListSingleEntryPanel)c).setSelectCheckbox(selected);
        }
    }

    public void updateHeader() {
        this.locationlistHeaderPanel.removeAll();
        String txtLeft = this.app.getSettings().getLocationListTitleLeft();
        String txtRight = this.app.getSettings().getLocationListTitleRight();
        LocationListSingleEntryPanel p = new LocationListSingleEntryPanel(-1L, this.bundle.getString("LocationListPanel.headerNumber.text"), txtRight, this.bundle.getString("LocationListPanel.headerLocation.text"), txtLeft, null, 0, this);
        p.setAsHeader();
        this.locationlistHeaderPanel.add(p);
        this.locationlistHeaderPanel.revalidate();
        this.locationlistHeaderPanel.repaint();
    }

    public void updateLocationList() {
        long performanceMillis = new Date().getTime();
        ThemisSettings settings = ThemisApplication.getInstance().getSettings();
        String contentleft = settings.getLocationListContentLeft();
        String contentright = settings.getLocationListContentRight();
        String sort = settings.getLocationListSortAttribute();
        ThemisAttribute taSort = settings.getLocationAttribute(sort);
        if (taSort != null) {
            this.tablesort = taSort.getSqlSort();
            if (this.tablesort != null && !"number".equals(taSort.getId())) {
                this.tablesort = this.tablesort + ",ele.number";
            }
        }
        final int scrollvalue = this.locationlistScroll.getVerticalScrollBar().getValue();
        this.updateActions();
        this.locationListPanel.removeAll();
        if (this.project == null || !this.project.isOpen()) {
            return;
        }
        List items = this.filter.getFilteredLocations(this.tablesort, null, true);
        this.project.getLogger().fine("LOCATIONLIST: " + (new Date().getTime() - performanceMillis) + " ms, Filter - getFilteredLocations");
        Placeholder ph = new Placeholder(null);
        ColorOption co = this.app.getSettings().getDisplayColorOption();
        for (DataRecord item : items) {
            if (!settings.getShowBuildingsInLocList() && item.getBoolean("building").booleanValue()) continue;
            if (item.getBoolean("locationgroupdel", Boolean.valueOf(false)).booleanValue()) {
                item.deleteColum("locationgroup");
            }
            int colorlevel = 0;
            if (!item.isEmpty("colorlevel")) {
                colorlevel = item.getInt("colorlevel", Integer.valueOf(0));
            }
            String iconfile = null;
            iconfile = item.getBoolean("building") != false ? "/at/grid/themis/application/media/house32.gif" : item.getString("iconfile");
            LocationListSingleEntryPanel p = new LocationListSingleEntryPanel(item.getLong("meta_id"), item.getString("locnumber"), ph.apply(contentright, item), item.getString("location"), ph.apply(contentleft, item), iconfile, colorlevel, this);
            p = new LocationListSingleEntryPanel(ph, contentleft, contentright, item, co, this);
            this.locationListPanel.add(p);
            this.dsh.addDragComponent(p);
        }
        this.project.getLogger().fine("LOCATIONLIST: " + (new Date().getTime() - performanceMillis) + " ms, created all panels");
        if (this.tc != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LocationListPanel.this.tc.setDisplayName(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("LocationListTopComponent.locListAndCount.text"), LocationListPanel.this.locationListPanel.getComponentCount()));
                    LocationListPanel.this.locationlistScroll.getVerticalScrollBar().setValue(scrollvalue);
                }
            });
        }
        this.locationListPanel.revalidate();
        this.locationListPanel.repaint();
        this.project.getLogger().fine("LOCATIONLIST: " + (new Date().getTime() - performanceMillis) + " ms, all done");
    }

    private ArrayList<Long> getSelectedLocationIds() {
        Component[] components;
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Component c : components = this.locationListPanel.getComponents()) {
            if (!(c instanceof LocationListSingleEntryPanel) || !((LocationListSingleEntryPanel)c).isSelected()) continue;
            ids.add(((LocationListSingleEntryPanel)c).getId());
        }
        return ids;
    }

    private void deleteLocations() {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        ThemisActions.deleteLocations(this.getSelectedLocationIds());
    }

    private void setAsBuilding() {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        ArrayList<Long> ids = this.getSelectedLocationIds();
        if (ids.size() == 1) {
            CmsLocation l = (CmsLocation)this.project.loadElement(ids.get(0).longValue(), this.project.getUser());
            l.setAsBuilding();
            l.save();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(ids.get(0).longValue()));
        } else if (ids.size() > 1 && Dialogs.getInstance().showConfirmDialog("dialog.confirm-set-as-building")) {
            for (long id : ids) {
                CmsLocation l = (CmsLocation)this.project.loadElement(id, this.project.getUser());
                l.setAsBuilding();
                l.save();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(id));
            }
        }
    }

    private void copySelectedLocation() {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        boolean insertLocationFromClipboard = false;
        final ArrayList<Long> ids = this.getSelectedLocationIds();
        if (this.project.hasCopiedLocationId() && ids.isEmpty()) {
            insertLocationFromClipboard = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("LocationListTopComponent.pasteFromClipboard.text"));
        }
        if (ids.isEmpty()) {
            Dialogs.getInstance().showWarningDialog("location.no-location-selected");
        } else if (ids.size() == 1 || insertLocationFromClipboard) {
            long locId = -1L;
            locId = !insertLocationFromClipboard ? ids.get(0).longValue() : this.project.getCopiedLocationId();
            CmsLocation location = this.copySingleLocation(locId);
            new LocationObservationDialog().editLocation((CmsElement)location);
        } else if (ids.size() > 1) {
            String progressTitle = this.project.getResourceText("progress.copy-location.title");
            BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

                public String run(ProgressHandle ph) {
                    ph.switchToDeterminate(ids.size());
                    int counter = 0;
                    Iterator iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        long locId = (Long)iterator.next();
                        ph.setDisplayName(LocationListPanel.this.project.getResourceText("progress.copy-location.text"));
                        CmsLocation loc = LocationListPanel.this.copySingleLocation(locId);
                        for (CmsElement obs : loc.getObservations()) {
                            obs.save(true, true);
                        }
                        loc.save();
                        for (CmsElement obs : loc.getObservations()) {
                            obs.save();
                        }
                        ph.progress(counter);
                        ++counter;
                    }
                    ph.finish();
                    ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED);
                    return null;
                }
            }, (String)progressTitle, (boolean)true);
        }
    }

    private CmsLocation copySingleLocation(long locId) {
        CmsLocation origLocation = (CmsLocation)this.project.loadElement(locId, this.project.getUser());
        CmsLocation location = (CmsLocation)origLocation.copy("files,observations");
        location.getAttribute("position").clear();
        location.getAttribute("labelposition").clear();
        location.getAttribute("barcode").clear();
        location.getRelationAttribute("plan").clear();
        if (this.project.checkForCurrentEvent(false)) {
            List obsIds = origLocation.getRelationAttribute("observations").getElementIds();
            Iterator iterator = obsIds.iterator();
            while (iterator.hasNext()) {
                long obsId = (Long)iterator.next();
                CmsObservation obsOrig = (CmsObservation)this.project.loadElement(obsId, this.project.getUser());
                if (obsOrig.isTrash()) continue;
                CmsObservation obs = (CmsObservation)obsOrig.copy("location,files,donedate,histories");
                obs.setLocation(location);
                obs.setNumber(location.getNextObservationNumber());
                location.getRelationAttribute("observations").add((CmsElement)obs);
                location.addObservation(obs);
            }
        }
        return location;
    }

    private void loadLocationGroups() {
        if (this.project != null && this.project.isOpen()) {
            List recs = this.project.getTemplateManger().getLocationGroups(-99L);
            this.modelLocGroup.removeAllElements();
            this.modelLocGroup.addElement(new CmsBasicElement(-1L, "-"));
            for (DataRecord rec : recs) {
                CmsBasicElement ele = new CmsBasicElement(rec);
                this.modelLocGroup.addElement(ele);
                if (!this.filter.getLocGroupId().getList().contains(ele.getId())) continue;
                this.modelLocGroup.setSelectedItem(ele);
            }
        }
    }

    private void checkSortOption() {
        ThemisAttribute sortTA = this.app.getSettings().getLocationAttribute(this.app.getSettings().getLocationListSortAttribute());
        if (sortTA == null || !sortTA.isUsed()) {
            for (ThemisAttribute ta : this.app.getSettings().getLocationAttributes()) {
                if (!ta.isUsed() || LocationListOptionPanel.getExcludeSortAttributes().contains(ta.getId())) continue;
                this.app.getSettings().setLocationListSortAttribute(ta.getId());
            }
        }
    }

    public void updateFilter(boolean trigger) {
        this.filter.setExternalModification(false);
        for (int ii = 0; ii < this.modelLocGroup.getSize(); ++ii) {
            CmsBasicElement ces = (CmsBasicElement)this.modelLocGroup.getElementAt(ii);
            if (!this.filter.getLocGroupId().getList().contains(ces.getId())) continue;
            this.fldLocGroup.setSelectedIndex(ii);
            break;
        }
        if (trigger) {
            this.fldLocFreeText.setText(this.filter.getLocTextFilter());
        }
        this.filter.setExternalModification(true);
    }

    private void changePlan(boolean multi) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        ArrayList<Long> ids = this.getSelectedLocationIds();
        if (ids.isEmpty()) {
            Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("LocationListTopComponent.selectLocFirst.text"));
            return;
        }
        ArrayList<CmsLocation> locationList = new ArrayList<CmsLocation>();
        for (long id : ids) {
            CmsLocation location = (CmsLocation)this.project.loadElement(id, this.project.getUser());
            if (location.getRelationAttribute("plan").getFirstElementId() < 0L && ids.size() == 1) {
                this.project.setAddMapRefToLocId(location.getId());
                Notification notify = THEMIS.notify(1, "Planbezug setzen", ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("LocationsListTopComponent.placeItem.text"));
                return;
            }
            if (location.getRelationAttribute("plan").getFirstElementId() < 0L) continue;
            locationList.add(location);
        }
        if (locationList.size() < 1) {
            Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("LocationListTopComponent.noLocationsMapRef.text"));
            return;
        }
        MapReferencePanel p = new MapReferencePanel(locationList);
        String[] btnPanel = new String[]{this.project.getResourceText("text.cancel"), this.project.getResourceText("text.ok")};
        int result = Dialogs.getInstance().showDialog(p, "", btnPanel);
        if (result > 0) {
            p.applyChange();
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.locListSettings = new JLabel();
        this.panelLocGroup = new JPanel();
        this.lblLocGroup = new JLabel();
        this.fldLocGroup = new JComboBox();
        this.panelLocFreeText = new JPanel();
        this.lblLocation1 = new JLabel();
        this.fldLocFreeText = new JTextField();
        this.btnSearchLocFreeText = new JButton();
        this.btnClearLocFreeText = new JButton();
        this.jPanel3 = new JPanel();
        this.locationlistScroll = new JScrollPane();
        this.locationListPanel = new JPanel();
        this.locationlistHeaderPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.btnAddLocation = new JButton();
        this.btnEdit = new JButton();
        this.btnCopy = new JButton();
        this.btnDelete = new JButton();
        this.jLabel2 = new JLabel();
        this.btnToggleSelection = new JButton();
        this.btnShowInPlan = new JButton();
        this.btnUserAction = new JButton();
        this.mainPanel.setPreferredSize(new Dimension(410, 717));
        this.mainPanel.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(83, 35));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.locListSettings.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_settings.gif")));
        Mnemonics.setLocalizedText((JLabel)this.locListSettings, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.locListSettings.text"));
        this.locListSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LocationListPanel.this.locListSettingsMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.locListSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.panelLocGroup.setLayout(new GridBagLayout());
        this.lblLocGroup.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocGroup, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.lblLocGroup.text"));
        this.lblLocGroup.setPreferredSize(new Dimension(85, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocGroup.add((Component)this.lblLocGroup, gridBagConstraints);
        this.fldLocGroup.setFont(THEMIS.fontList);
        this.fldLocGroup.setModel(this.modelLocGroup);
        this.fldLocGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationListPanel.this.fldLocGroupItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocGroup.add((Component)this.fldLocGroup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.panelLocGroup, gridBagConstraints);
        this.panelLocFreeText.setMinimumSize(new Dimension(83, 35));
        this.panelLocFreeText.setLayout(new GridBagLayout());
        this.lblLocation1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocation1, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.lblLocation1.text"));
        this.lblLocation1.setPreferredSize(new Dimension(85, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocFreeText.add((Component)this.lblLocation1, gridBagConstraints);
        this.fldLocFreeText.setFont(THEMIS.fontTextfield);
        this.fldLocFreeText.setText(NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.fldLocFreeText.text"));
        this.fldLocFreeText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LocationListPanel.this.fldLocFreeTextFocusLost(evt);
            }
        });
        this.fldLocFreeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.fldLocFreeTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocFreeText.add((Component)this.fldLocFreeText, gridBagConstraints);
        this.btnSearchLocFreeText.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchLocFreeText, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnSearchLocFreeText.text"));
        this.btnSearchLocFreeText.setBorder(new SoftBevelBorder(0));
        this.btnSearchLocFreeText.setContentAreaFilled(false);
        this.btnSearchLocFreeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.btnSearchLocFreeTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocFreeText.add((Component)this.btnSearchLocFreeText, gridBagConstraints);
        this.btnClearLocFreeText.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearLocFreeText, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnClearLocFreeText.text"));
        this.btnClearLocFreeText.setBorder(new SoftBevelBorder(0));
        this.btnClearLocFreeText.setContentAreaFilled(false);
        this.btnClearLocFreeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.btnClearLocFreeTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocFreeText.add((Component)this.btnClearLocFreeText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.panelLocFreeText, gridBagConstraints);
        this.jPanel3.setLayout(new BorderLayout());
        this.locationlistScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.locationListPanel.setLayout(new BoxLayout(this.locationListPanel, 3));
        this.locationlistScroll.setViewportView(this.locationListPanel);
        this.jPanel3.add((Component)this.locationlistScroll, "Center");
        this.locationlistHeaderPanel.setLayout(new BoxLayout(this.locationlistHeaderPanel, 1));
        this.jPanel3.add((Component)this.locationlistHeaderPanel, "First");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnAddLocation.setFont(THEMIS.fontButton);
        this.btnAddLocation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddLocation, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnAddLocation.text"));
        this.btnAddLocation.setToolTipText(NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnAddLocation.toolTipText"));
        this.btnAddLocation.setBorder(new SoftBevelBorder(0));
        this.btnAddLocation.setMaximumSize(null);
        this.btnAddLocation.setMinimumSize(null);
        this.btnAddLocation.setPreferredSize(null);
        this.btnAddLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.btnAddLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnAddLocation, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.setMinimumSize(null);
        this.btnEdit.setPreferredSize(null);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnEdit, gridBagConstraints);
        this.btnCopy.setFont(THEMIS.fontButton);
        this.btnCopy.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopy, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnCopy.text"));
        this.btnCopy.setToolTipText(NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnCopy.toolTipText"));
        this.btnCopy.setBorder(new SoftBevelBorder(0));
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.btnCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnCopy, gridBagConstraints);
        this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelete, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnDelete.text"));
        this.btnDelete.setToolTipText(NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnDelete.toolTipText"));
        this.btnDelete.setBorder(new SoftBevelBorder(0));
        this.btnDelete.setContentAreaFilled(false);
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.btnDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnDelete, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.btnToggleSelection.setFont(THEMIS.fontButton);
        this.btnToggleSelection.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_selectAllObs24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnToggleSelection, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnToggleSelection.text"));
        this.btnToggleSelection.setToolTipText(NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnToggleSelection.toolTipText"));
        this.btnToggleSelection.setBorder(new SoftBevelBorder(0));
        this.btnToggleSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.btnToggleSelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnToggleSelection, gridBagConstraints);
        this.btnShowInPlan.setFont(THEMIS.fontButton);
        this.btnShowInPlan.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/locateInPlan24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowInPlan, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnShowInPlan.text"));
        this.btnShowInPlan.setToolTipText(NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnShowInPlan.toolTipText"));
        this.btnShowInPlan.setBorder(new SoftBevelBorder(0));
        this.btnShowInPlan.setMaximumSize(null);
        this.btnShowInPlan.setMinimumSize(null);
        this.btnShowInPlan.setPreferredSize(null);
        this.btnShowInPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.btnShowInPlanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnShowInPlan, gridBagConstraints);
        this.btnUserAction.setFont(THEMIS.fontButton);
        this.btnUserAction.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUserAction, (String)NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnUserAction.text"));
        this.btnUserAction.setToolTipText(NbBundle.getMessage(LocationListPanel.class, (String)"LocationListPanel.btnUserAction.toolTipText"));
        this.btnUserAction.setBorder(new SoftBevelBorder(0));
        this.btnUserAction.setDisabledIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/menu_options_disabled24.gif")));
        this.btnUserAction.setMaximumSize(null);
        this.btnUserAction.setMinimumSize(null);
        this.btnUserAction.setPreferredSize(null);
        this.btnUserAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationListPanel.this.btnUserActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnUserAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.jPanel1, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, 560, Short.MAX_VALUE));
    }

    private void btnAddLocationActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        CmsLocation location = this.project.createLocation(-1L);
        new LocationObservationDialog().editLocation((CmsElement)location);
        if (location != null && location.isSaved()) {
            this.project.updateCurrentEvent();
            this.project.getSelectionManager().setSelectedLocation(location.getId(), true, (Object)this);
        }
    }

    private void btnShowInPlanActionPerformed(ActionEvent evt) {
        try {
            ArrayList ids = this.app.getProject().getSelectionManager().getSelectedLocationIds();
            if (!ids.isEmpty()) {
                CmsElement loc = this.app.getProject().loadElement(((Long)ids.get(0)).longValue(), this.app.getProject().getUser());
                long planid = loc.getRelationAttribute("plan").getFirstElementId();
                if (planid < 0L) {
                    Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("LocationListTopComponent.noMapAssigned.text"));
                } else {
                    ThemisActions.showLocationInPlan(planid, loc.getId());
                }
            }
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("LocationListTopComponent.zoomToError.text"));
        }
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        MultiLocationPanel.editSelectedLocations();
    }

    private void btnToggleSelectionActionPerformed(ActionEvent evt) {
        if (this.locationListPanel.getComponents().length == 0) {
            return;
        }
        this.selectAllLocations(false);
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.SELECTION_CHANGED.setSource((Object)this));
    }

    private void btnSearchLocFreeTextActionPerformed(ActionEvent evt) {
        this.updateLocFreeText();
    }

    private void btnClearLocFreeTextActionPerformed(ActionEvent evt) {
        this.fldLocFreeText.setText("");
        this.updateLocFreeText();
    }

    private void fldLocFreeTextFocusLost(FocusEvent evt) {
        this.updateLocFreeText();
    }

    private void fldLocFreeTextActionPerformed(ActionEvent evt) {
        this.updateLocFreeText();
    }

    private void updateLocFreeText() {
        this.filter.setLocFreeText(this.fldLocFreeText.getText(), (Object)this);
        this.clearSelection();
    }

    private void clearSelection() {
        this.project.getSelectionManager().clearSelection(true, (Object)this);
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.SELECTION_CHANGED.setSource((Object)this));
    }

    private void fldLocGroupItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            CmsBasicElement sel = (CmsBasicElement)this.fldLocGroup.getSelectedItem();
            if (sel != null && sel.getId() >= 0L) {
                this.filter.getLocGroupId().setItem(sel.getId(), (Object)this);
            } else {
                this.filter.getLocGroupId().clear((Object)this);
            }
            this.clearSelection();
        }
    }

    private void btnUserActionActionPerformed(ActionEvent evt) {
        this.showActionMenu();
    }

    private void locListSettingsMouseClicked(MouseEvent evt) {
        if (!this.project.isOpen()) {
            return;
        }
        ProjectSettingsPanel panel = new ProjectSettingsPanel();
        panel.showTopic("PageLocList");
        panel.showDialog();
        this.updateHeader();
        this.updateLocationList();
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        this.deleteLocations();
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        this.copySelectedLocation();
    }
}

