/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.observation.LocationListPanel;
import at.grid.themis.ontology.ColorOption;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.Placeholder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LocationListSingleEntryPanel
extends JPanel {
    private long id;
    private boolean ignoreItemChanged = false;
    private boolean isHeader = false;
    private LocationListPanel dataProvider2 = null;
    private long selectedObservationId;
    private JCheckBox chkSelection;
    private JLabel lblGruppe;
    private JLabel lblIcon;
    private JLabel lblNumber;
    private JLabel lblPlan;
    private JLabel lblTitle;
    private JPanel panelLine1;
    private JPanel panelLine2;
    private JPanel panelStatus;

    public LocationListSingleEntryPanel(long id, String nr, String textRight, String title, String textLeft, String iconfile, int colorlevel, LocationListPanel mainWindow) {
        this.initComponents();
        this.dataProvider2 = mainWindow;
        this.initialise(id, nr, textRight, title, textLeft, iconfile, colorlevel);
    }

    public LocationListSingleEntryPanel(Placeholder ph, String contentleft, String contentright, DataRecord item, ColorOption co, LocationListPanel mainWindow) {
        this.initComponents();
        this.dataProvider2 = mainWindow;
        this.initialise(ph, contentleft, contentright, item, co);
    }

    private void initialise(long id, String nr, String textRight, String title, String textLeft, String iconfile, int colorlevel) {
        this.lblIcon.setVisible(ThemisApplication.getInstance().getSettings().getLocationAttribute("icon").isUsed());
        this.id = id;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                LocationListSingleEntryPanel.this.handleClick(e);
            }
        });
        this.setContent(nr, textRight, title, textLeft, iconfile);
        this.setColorLevel(colorlevel);
    }

    private void initialise(Placeholder ph, String cleft, String cright, DataRecord item, ColorOption co) {
        String iconfile = null;
        iconfile = item.getBoolean("building") != false ? "/at/grid/themis/application/media/house32.gif" : item.getString("iconfile");
        this.lblIcon.setVisible(ThemisApplication.getInstance().getSettings().getLocationAttribute("icon").isUsed());
        this.id = item.getLong("meta_id");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                LocationListSingleEntryPanel.this.handleClick(e);
            }
        });
        this.setContent(item.getString("locnumber"), ph.apply(cright, item), item.getString("location"), ph.apply(cleft, item), iconfile);
        this.setColorForLocation(co, item);
    }

    private void handleClick(MouseEvent e) {
        if (this.isHeader) {
            return;
        }
        if (e.getClickCount() == 2) {
            ThemisApplication app = ThemisApplication.getInstance();
            if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)app)) {
                return;
            }
            if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
                return;
            }
            ThemisProject project = app.getProject();
            new LocationObservationDialog().editLocation(project.loadElement(this.id, project.getUser()));
        } else {
            this.setSingleSelection();
        }
    }

    public void setContent(String nr, String textRight, String title, String textLeft, String iconFilename) {
        BufferedImage bi;
        this.lblGruppe.setText(textRight);
        if (title.length() > 45) {
            title = title.substring(0, 43) + "(...)";
        }
        this.lblTitle.setText(title);
        this.lblNumber.setText(nr);
        this.lblPlan.setText(textLeft);
        this.lblIcon.setText("");
        if (iconFilename != null && !iconFilename.isEmpty() && (bi = ThemisProject.getIconImage35px((String)iconFilename)) != null) {
            this.lblIcon.setIcon(new ImageIcon(bi));
        }
    }

    public void setAsHeader() {
        this.isHeader = true;
        this.setBackground(Color.darkGray);
        this.lblGruppe.setBackground(Color.darkGray);
        this.lblGruppe.setForeground(Color.white);
        this.lblNumber.setBackground(Color.darkGray);
        this.lblNumber.setForeground(Color.white);
        this.lblPlan.setBackground(Color.darkGray);
        this.lblPlan.setForeground(Color.white);
        this.lblTitle.setBackground(Color.darkGray);
        this.lblTitle.setForeground(Color.white);
        this.panelStatus.setBackground(Color.darkGray);
        this.chkSelection.setBackground(Color.darkGray);
        this.lblIcon.setBackground(Color.darkGray);
        this.lblIcon.setForeground(Color.darkGray);
        this.panelLine1.setBackground(Color.darkGray);
        this.panelLine1.setForeground(Color.white);
        this.panelLine2.setBackground(Color.darkGray);
        this.panelLine2.setForeground(Color.white);
    }

    public void setSingleSelection() {
        Component[] components;
        for (Component c : components = this.getParent().getComponents()) {
            if (!(c instanceof LocationListSingleEntryPanel)) continue;
            ((LocationListSingleEntryPanel)c).setSelectCheckbox(false);
        }
        this.selectedObservationId = -1L;
        if (ThemisApplication.getInstance().getProject().getSelectionManager().getSelectedObservationIds().size() == 1) {
            this.selectedObservationId = (Long)ThemisApplication.getInstance().getProject().getSelectionManager().getSelectedObservationIds().get(0);
        }
        ThemisApplication.getInstance().getProject().getSelectionManager().clearSelection(false, (Object)this);
        this.chkSelection.setSelected(true);
    }

    public void setSelectCheckbox(boolean flag) {
        this.ignoreItemChanged = true;
        this.chkSelection.setSelected(flag);
        this.ignoreItemChanged = false;
    }

    public void setColor(Color bg) {
        this.panelStatus.setBackground(bg);
    }

    public void setColorForLocation(ColorOption co, DataRecord rec) {
        Integer bgcolor = null;
        if (co.getMethod() != ColorOption.Method.STATIC && co.getMethod() != ColorOption.Method.NOCOLOR) {
            bgcolor = co.getColor(rec);
            if (bgcolor == null) {
                bgcolor = co.getStaticColor();
            }
            if (bgcolor == null) {
                bgcolor = Color.BLUE.getRGB();
            }
        }
        Color c = ThemisColors.white;
        if (bgcolor != null) {
            c = new Color(bgcolor);
        }
        this.panelStatus.setBackground(c);
        this.chkSelection.setBackground(c);
    }

    public void setColorLevel(int colorlevel) {
        switch (colorlevel) {
            case 1: {
                this.panelStatus.setBackground(ThemisColors.COLOR_DUE);
                this.chkSelection.setBackground(ThemisColors.COLOR_DUE);
                break;
            }
            case 2: {
                this.panelStatus.setBackground(ThemisColors.COLOR_OVERDUE);
                this.chkSelection.setBackground(ThemisColors.COLOR_OVERDUE);
                break;
            }
            default: {
                this.panelStatus.setBackground(ThemisColors.white);
                this.chkSelection.setBackground(ThemisColors.white);
            }
        }
    }

    public boolean isSelected() {
        return this.id > 0L && this.chkSelection.isSelected();
    }

    public long getId() {
        return this.id;
    }

    private void initComponents() {
        this.lblIcon = new JLabel();
        this.panelStatus = new JPanel();
        this.chkSelection = new JCheckBox();
        this.panelLine1 = new JPanel();
        this.lblNumber = new JLabel();
        this.lblTitle = new JLabel();
        this.panelLine2 = new JPanel();
        this.lblPlan = new JLabel();
        this.lblGruppe = new JLabel();
        this.setBorder(new SoftBevelBorder(0));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 42));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblIcon, (String)NbBundle.getMessage(LocationListSingleEntryPanel.class, (String)"LocationListSingleEntryPanel.lblIcon.text"));
        this.lblIcon.setPreferredSize(new Dimension(35, 35));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.lblIcon, gridBagConstraints);
        this.panelStatus.setPreferredSize(new Dimension(34, 34));
        this.panelStatus.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.chkSelection, (String)NbBundle.getMessage(LocationListSingleEntryPanel.class, (String)"LocationListSingleEntryPanel.chkSelection.text"));
        this.chkSelection.setHorizontalAlignment(0);
        this.chkSelection.setHorizontalTextPosition(0);
        this.chkSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationListSingleEntryPanel.this.chkSelectionItemStateChanged(evt);
            }
        });
        this.panelStatus.add((Component)this.chkSelection, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        this.add((Component)this.panelStatus, gridBagConstraints);
        this.panelLine1.setLayout(new GridBagLayout());
        this.lblNumber.setFont(new Font("Tahoma", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.lblNumber, (String)NbBundle.getMessage(LocationListSingleEntryPanel.class, (String)"LocationListSingleEntryPanel.lblNumber.text"));
        this.lblNumber.setMaximumSize(new Dimension(999, 999));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.panelLine1.add((Component)this.lblNumber, gridBagConstraints);
        this.lblTitle.setFont(new Font("Tahoma", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(LocationListSingleEntryPanel.class, (String)"LocationListSingleEntryPanel.lblTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 6);
        this.panelLine1.add((Component)this.lblTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelLine1, gridBagConstraints);
        this.panelLine2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblPlan, (String)NbBundle.getMessage(LocationListSingleEntryPanel.class, (String)"LocationListSingleEntryPanel.lblPlan.text"));
        this.lblPlan.setMaximumSize(new Dimension(999, 999));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panelLine2.add((Component)this.lblPlan, gridBagConstraints);
        this.lblGruppe.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lblGruppe, (String)NbBundle.getMessage(LocationListSingleEntryPanel.class, (String)"LocationListSingleEntryPanel.lblGruppe.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.panelLine2.add((Component)this.lblGruppe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelLine2, gridBagConstraints);
    }

    private void chkSelectionItemStateChanged(ItemEvent evt) {
        if (this.isHeader) {
            if (!this.ignoreItemChanged && this.dataProvider2 != null) {
                this.dataProvider2.selectAllLocations(this.chkSelection.isSelected());
            }
        } else {
            if (!this.ignoreItemChanged) {
                if (this.chkSelection.isSelected()) {
                    ThemisApplication.getInstance().getProject().getSelectionManager().addSelectedLocation(this.getId(), false, (Object)this);
                    if (this.selectedObservationId >= 0L && ThemisApplication.getInstance().getProject().getDatastorage().hasRelation(this.getId(), this.selectedObservationId, "locationobservation", false)) {
                        ThemisApplication.getInstance().getProject().getSelectionManager().setSelectedObservation(this.selectedObservationId, true, (Object)this);
                    }
                } else {
                    ThemisApplication.getInstance().getProject().getSelectionManager().removeSelectedLocation(this.getId(), false, (Object)this);
                }
                ThemisApplication.getInstance().getActionProvider().invokeAction(ThemisAction.SELECTION_CHANGED.from((Object)this, "location selected in list"));
            }
            Color color = this.chkSelection.isSelected() ? Color.LIGHT_GRAY : new Color(240, 240, 240);
            this.setBackground(color);
            this.panelLine1.setBackground(color);
            this.panelLine2.setBackground(color);
        }
    }
}

