/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.data.grid.GridGeometry;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsPlan;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MapReferencePanel
extends JPanel {
    DefaultComboBoxModel<CmsElementSummary> planModel = new DefaultComboBoxModel();
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ArrayList<CmsLocation> locationList;
    private JCheckBox chkCopy;
    private JLabel lblTitle;
    private JComboBox planCombo;

    public MapReferencePanel(ArrayList<CmsLocation> locationIDs) {
        this.initComponents();
        this.populateComboBox("plan", this.planModel, this.planCombo);
        this.locationList = locationIDs;
    }

    private void populateComboBox(String elementtype, DefaultComboBoxModel model, JComboBox combo) {
        if (this.project != null && this.project.isOpen()) {
            ArrayList plansWithBuildings = this.project.getPlansWithBuildings();
            combo.removeAllItems();
            model.addElement(new CmsElementSummary(-1L, ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("MapReferencePanel.removeMapRef.text"), this.app.getSystemLanguage(), (CmsApplication)this.project, this.project.getUser()));
            for (CmsBasicElement be : plansWithBuildings) {
                model.addElement(new CmsElementSummary(be.getId(), be.getTitle(), this.app.getSystemLanguage(), (CmsApplication)this.project, this.project.getUser()));
            }
            combo.setModel(model);
        }
    }

    public void applyChange() {
        boolean removeMapRef = false;
        boolean removeMapRefAsked = false;
        boolean createCopy = this.chkCopy.isSelected();
        CmsElementSummary selMap = (CmsElementSummary)this.planCombo.getSelectedItem();
        Long selMapId = selMap.getId();
        CmsPlan destPlan = null;
        GridGeometry planExtent = null;
        if (selMapId >= 0L) {
            destPlan = (CmsPlan)this.project.loadElement(selMapId.longValue(), this.project.getUser());
            planExtent = destPlan.getPlanExtent();
        }
        boolean outOfBounds = false;
        boolean changed = false;
        try {
            for (CmsLocation location : this.locationList) {
                Point pt;
                long currentMapId = location.getRelationAttribute("plan").getFirstElementId();
                if (selMapId == currentMapId && this.locationList.size() == 1) {
                    Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("MapReferencePanel.sameMap.text"));
                    return;
                }
                if (selMapId == -1L) {
                    if (!removeMapRefAsked && Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("MapReferencePanel.deleteMapReference.text"))) {
                        removeMapRef = true;
                        removeMapRefAsked = true;
                    } else {
                        removeMapRefAsked = true;
                    }
                    if (!removeMapRef) continue;
                    location.getRelationAttribute("plan").clear();
                    location.save();
                    changed = true;
                    continue;
                }
                long zoomToId = location.getId();
                SimpleGeometry pos = location.getPosition();
                Point point = pt = pos == null ? null : pos.getFirstPoint();
                if (planExtent != null && pt != null && planExtent.contains(pt.getX(), pt.getY())) {
                    location.getRelationAttribute("plan").clear();
                    location.getRelationAttribute("plan").add(selMapId.longValue());
                    if (createCopy) {
                        zoomToId = location.saveCopy();
                    } else {
                        location.save();
                    }
                    changed = true;
                    if (this.locationList.size() != 1) continue;
                    ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(selMapId.longValue()));
                    ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_ZOOM_TO.setId(zoomToId));
                    continue;
                }
                outOfBounds = true;
            }
            this.app.getFilter().resetSearchResult();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED);
            if (outOfBounds) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("MapReferencePanel.outOfBounds.text"));
            } else if (changed) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("MapReferencePanel.successChangeMapRef.text"));
            }
        }
        catch (Exception ex) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("MapReferencePanel.errorChangeMapRef.text"));
        }
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.planCombo = new JComboBox();
        this.chkCopy = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.lblTitle.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(MapReferencePanel.class, (String)"MapReferencePanel.lblTitle.text"));
        this.lblTitle.setToolTipText(NbBundle.getMessage(MapReferencePanel.class, (String)"MapReferencePanel.lblTitle.toolTipText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblTitle, gridBagConstraints);
        this.planCombo.setFont(THEMIS.fontList);
        this.planCombo.setModel(this.planModel);
        this.planCombo.setPreferredSize(new Dimension(220, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.planCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkCopy, (String)NbBundle.getMessage(MapReferencePanel.class, (String)"MapReferencePanel.chkCopy.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.chkCopy, gridBagConstraints);
    }
}

