/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.element.CmsElement;
import at.grid.ontology.swing.ui.PDControlScrollPane;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ThemisActions;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ObservationEditPanel
extends JPanel
implements ThemisActionListener {
    static final int PREVIOUS = 1;
    static final int NEXT = 2;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    boolean userAdministrator = false;
    long previousObservationId = -1L;
    long nextObservationId = -1L;
    CmsObservation observation = null;
    CmsHistory selectedHistory = null;
    CmsLocation location = null;
    HashMap<String, JComponent> attributeMap = new HashMap();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle");
    private boolean ignoreFldHistoriesItemChange = false;
    private JButton btnChecked;
    private JButton btnDone;
    private JButton btnEdit;
    private JButton btnEditLoc;
    private JButton btnNext;
    private JButton btnNextHistory;
    private JButton btnPrev;
    private JButton btnPreviousHistory;
    private JButton btnSendMail;
    private JButton btnShowInPlan;
    private JComboBox<CmsHistory> fldHistories;
    private JTextField fldLocation;
    private JEditorPane fldObservation;
    private JScrollPane fldObservationScroll;
    private JTextField fldObservationTitle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JLabel lblDuedate;
    private JLabel lblIcon;
    private JLabel lblStatus;
    private JLabel lblType;
    private JPanel panelAttributes;
    private JScrollPane panelAttributesScroll;
    private JPanel panelButtons;
    private JPanel panelDuedate;
    private JPanel panelHistories;
    private JPanel panelMain;
    private JScrollPane panelMainScroll;
    private JPanel panelMangel;
    private JPanel panelStatus;
    private JPanel panelTop;

    public ObservationEditPanel() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + this.getClass().getName() + " ...");
        THEMIS.getLicense();
        this.initComponents();
        this.btnSendMail.setVisible(false);
        ThemisActionProvider.getInstance().register(this);
        this.lblType.setOpaque(true);
        this.panelMangel.setVisible(false);
        this.panelHistories.setVisible(false);
        this.populateObservationDisplay();
        new DragScrollHandler(this.fldObservation);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + this.getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        if (action.getSource() == this) {
            return;
        }
        switch (action.getAction()) {
            case 650: {
                ArrayList selObsIds = this.project.getSelectionManager().getSelectedObservationIds();
                if (selObsIds.isEmpty()) {
                    this.clear();
                    break;
                }
                if (this.observation != null && selObsIds.contains(this.observation.getId())) break;
                this.selectedHistory = null;
                this.updateObservation(true, true);
                this.loadObservation((Long)selObsIds.get(0), false);
                break;
            }
            case 501: {
                this.populate();
                break;
            }
            case 601: {
                ArrayList deletedObservations = (ArrayList)action.getReference();
                if (deletedObservations == null || this.observation == null || !deletedObservations.contains(this.observation.getId())) break;
                this.clear();
                break;
            }
            case 651: {
                if (this.observation == null) break;
                this.loadObservation(this.observation.getId(), false);
                break;
            }
            case 1112: {
                this.updatePreviousNext();
                break;
            }
            case 1300: {
                this.populateObservationDisplay();
                break;
            }
            case 1100: 
            case 1102: {
                this.userAdministrator = this.app.isUserAdministrator();
            }
            case 302: 
            case 1101: {
                this.populate();
            }
        }
    }

    private void updatePreviousNext() {
        if (this.observation != null) {
            this.updatePreviousNext(this.observation.getId());
        } else {
            this.nextObservationId = -1L;
            this.previousObservationId = -1L;
        }
    }

    private void updatePreviousNext(long obsId) {
        if (obsId >= 0L) {
            ArrayList filterIds;
            int idx;
            if (this.nextObservationId == obsId) {
                this.nextObservationId = -1L;
            }
            if (this.previousObservationId == obsId) {
                this.previousObservationId = -1L;
            }
            if ((idx = (filterIds = this.app.getFilter().getFilteredObservationIds()).indexOf(obsId)) >= 0) {
                int idxnext = idx == filterIds.size() - 1 ? 0 : idx + 1;
                this.nextObservationId = (Long)filterIds.get(idxnext);
                int idxprevious = idx == 0 ? filterIds.size() - 1 : idx - 1;
                this.previousObservationId = (Long)filterIds.get(idxprevious);
            } else {
                if (filterIds.indexOf(this.nextObservationId) < 0) {
                    long l = this.nextObservationId = filterIds.isEmpty() ? -1L : (Long)filterIds.get(0);
                }
                if (filterIds.indexOf(this.previousObservationId) < 0) {
                    this.previousObservationId = filterIds.isEmpty() ? -1L : (Long)filterIds.get(0);
                }
            }
        } else {
            this.nextObservationId = -1L;
            this.previousObservationId = -1L;
        }
    }

    private void populate() {
        ArrayList ids = this.project.getSelectionManager().getSelectedObservationIds();
        if (ids.isEmpty()) {
            this.clear();
        } else {
            this.loadObservation((Long)ids.get(0), false);
        }
    }

    private void clear() {
        this.fldObservation.setText("");
        this.panelMangel.setVisible(false);
        this.fldLocation.setText("Es ist keine Beobachtung ausgew\u00e4hlt.");
        this.fldObservationTitle.setText("");
        this.lblType.setText("-");
        this.lblIcon.setIcon(null);
        this.lblIcon.setText(null);
        this.lblIcon.setVisible(false);
        this.lblStatus.setText("");
        this.lblDuedate.setText("");
        this.panelDuedate.setBackground(THEMIS.white);
        this.panelStatus.setBackground(THEMIS.white);
        this.lblType.setBackground(THEMIS.gray);
        this.btnDone.setEnabled(false);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
        this.btnChecked.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnEditLoc.setEnabled(false);
        this.btnShowInPlan.setEnabled(false);
        this.clearPanelMain();
        this.panelAttributes.removeAll();
        this.panelAttributes.revalidate();
        this.panelAttributes.repaint();
        this.observation = null;
        this.selectedHistory = null;
        this.location = null;
    }

    private void clearPanelMain() {
        this.panelMain.removeAll();
        this.panelMain.revalidate();
        this.panelMain.repaint();
    }

    private boolean allowSetDone() {
        ThemisAttribute ta = this.app.getSettings().getObservationAttribute("done");
        return ta != null && (this.userAdministrator || !ta.isWriteprotected());
    }

    private boolean updateObservation(boolean trigger, boolean dosave) {
        if (this.observation == null) {
            return false;
        }
        String md5 = this.observation.getMD5();
        THEMIS.applyAttribute(this.attributeMap, (CmsElement)this.observation);
        boolean nochange = md5.equals(this.observation.getMD5());
        if (!nochange && dosave) {
            this.observation.save();
            if (trigger) {
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(this.observation.getId()), true);
            }
        }
        return !nochange;
    }

    private void loadObservation(long obsId, boolean trigger) {
        if (!this.project.isOpen()) {
            this.clear();
            return;
        }
        this.updatePreviousNext(obsId);
        if (this.observation == null || this.observation.getId() != obsId) {
            this.observation = (CmsObservation)this.project.loadElement(obsId, this.project.getUser());
        } else {
            this.observation.reload();
        }
        this.populateObservationDisplay();
    }

    public void populateObservationDisplay() {
        String controlInfo;
        if (this.observation == null) {
            this.clear();
            return;
        }
        boolean hasLicense = this.app.getLicense().hasLicense();
        boolean isControlled = this.observation.isControlledInCurrentEvent();
        String string = controlInfo = isControlled ? "kontrolliert" : "nicht kontrolliert";
        if (this.observation.isDone() && (this.observation.isOfType(1) || this.observation.isOfType(4))) {
            this.panelStatus.setBackground(isControlled ? THEMIS.green : THEMIS.white);
        } else {
            this.panelStatus.setBackground(isControlled ? THEMIS.green : THEMIS.lightred);
        }
        this.btnDone.setEnabled(hasLicense);
        this.btnNext.setEnabled(true);
        this.btnPrev.setEnabled(true);
        this.btnChecked.setEnabled(hasLicense);
        this.btnEdit.setEnabled(hasLicense);
        this.btnEditLoc.setEnabled(hasLicense);
        this.btnShowInPlan.setEnabled(true);
        StringBuilder infotext = new StringBuilder();
        infotext.append("<html>");
        infotext.append("<body style=\"font-family: " + THEMIS.fontLabel.getFamily() + "\">");
        ArrayList<ThemisAttribute> textAtts = new ArrayList<ThemisAttribute>();
        for (ThemisAttribute att : this.settings.getObservationAttributes()) {
            if (!att.isUsed() || att.isChecklistedit() && hasLicense || "title".equals(att.getId()) || "type".equals(att.getId()) || "repeatunit".equals(att.getId()) || "repeat".equals(att.getId()) || !att.doShow(this.observation.getKeyAttribute("type").getId())) continue;
            textAtts.add(att);
        }
        String obsString = ThemisUtil.toString((CmsElement)this.observation, (String)"", (String)"\n", (boolean)false, textAtts, (boolean)true);
        infotext.append(obsString);
        infotext.append("</body></html>");
        this.fldObservation.setText(infotext.toString());
        this.fldObservation.setCaretPosition(0);
        boolean hasCurrentEvent = this.project.getSelectionManager().getCurrentEventId() >= 0L;
        int panelRow = 0;
        int inset = 2;
        this.clearPanelMain();
        this.attributeMap.clear();
        for (ThemisAttribute att : this.settings.getObservationAttributes()) {
            JComponent comp;
            if (!att.isUsed() || att.isVirtual() || !att.isChecklistedit() || !att.isChecklistedit() || !hasLicense || (comp = THEMIS.addAttributeToPanel(att, (CmsElement)this.observation, this.panelMain)) == null) continue;
            if (!hasCurrentEvent) {
                comp.setEnabled(false);
            }
            this.attributeMap.put(att.getCmsCode(), comp);
            ++panelRow;
        }
        GridBagConstraints gridBagConstraintsPanel = new GridBagConstraints();
        gridBagConstraintsPanel.fill = 2;
        gridBagConstraintsPanel.insets = new Insets(inset, inset, inset, inset);
        gridBagConstraintsPanel.anchor = 18;
        gridBagConstraintsPanel.weightx = 1.0;
        gridBagConstraintsPanel.weighty = 1.0;
        gridBagConstraintsPanel.gridx = -1;
        gridBagConstraintsPanel.gridy = -1;
        gridBagConstraintsPanel.gridwidth = 0;
        this.panelMain.add((Component)this.fldObservationScroll, gridBagConstraintsPanel);
        ++panelRow;
        int observationType = (int)this.observation.getKeyAttribute("type").getId();
        this.btnDone.setVisible(this.settings.getObservationAttribute("done").isUsed());
        switch (observationType) {
            case 1: {
                this.btnDone.setEnabled(hasLicense && this.allowSetDone());
                String tm = this.app.getSettings().getTerm(ThemisSettings.Term.TypMangel).trim();
                this.lblType.setText(tm.isEmpty() ? tm : tm.substring(0, 1));
                this.lblStatus.setText(controlInfo + ", " + (this.observation.getBooleanAttribute("done").isSet() ? ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationControlTopComponent.Done.text") : ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationControlTopComponent.Undone.text")));
                this.lblType.setBackground(THEMIS.COLOR_DEFECT);
                if (this.observation.getBooleanAttribute("done").isSet()) {
                    this.btnDone.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_showMangel24.gif")));
                    this.btnDone.setEnabled(false);
                    break;
                }
                this.btnDone.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
                this.btnDone.setEnabled(hasLicense && this.allowSetDone());
                break;
            }
            case 2: {
                this.panelMangel.setVisible(true);
                this.btnDone.setEnabled(false);
                String tk = this.app.getSettings().getTerm(ThemisSettings.Term.TypKontrolle).trim();
                this.lblType.setText(tk.isEmpty() ? tk : tk.substring(0, 1));
                this.lblStatus.setText(controlInfo);
                this.lblType.setBackground(THEMIS.COLOR_CHECK);
                break;
            }
            case 3: {
                this.panelMangel.setVisible(false);
                this.btnDone.setEnabled(false);
                String ti = this.app.getSettings().getTerm(ThemisSettings.Term.TypInformation).trim();
                this.lblType.setText(ti.isEmpty() ? ti : ti.substring(0, 1));
                this.lblStatus.setText(controlInfo);
                this.lblType.setBackground(THEMIS.COLOR_INFO);
                break;
            }
            case 4: {
                this.panelMangel.setVisible(false);
                this.btnDone.setEnabled(hasLicense && this.allowSetDone());
                String ta = this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe).trim();
                this.lblType.setText(ta.isEmpty() ? ta : ta.substring(0, 1));
                this.lblType.setText(this.app.getSettings().getTerm(ThemisSettings.Term.TypAufgabe).substring(0, 1));
                this.lblStatus.setText(controlInfo + ", " + (this.observation.getBooleanAttribute("done").isSet() ? ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationControlTopComponent.Done.text") : ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationControlTopComponent.Undone.text")));
                this.lblType.setBackground(THEMIS.COLOR_TASK);
                if (this.observation.getBooleanAttribute("done").isSet()) {
                    this.btnDone.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_showMangel24.gif")));
                    this.btnDone.setEnabled(false);
                    break;
                }
                this.btnDone.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
                this.btnDone.setEnabled(hasLicense && this.allowSetDone());
                this.btnDone.setText(this.settings.getTerm(ThemisSettings.Term.StatusErledigt));
            }
        }
        this.lblType.setOpaque(true);
        long locationid = this.observation.getRelationAttribute("location").getFirstElementId();
        if (locationid > 0L) {
            BufferedImage bi;
            this.location = (CmsLocation)this.project.loadElement(locationid, this.project.getUser());
            this.lblIcon.setVisible(false);
            String iconfile = null;
            iconfile = this.location.isBuilding() ? "/at/grid/themis/application/media/house32.gif" : this.location.getAttributeValue("iconfile");
            if (iconfile != null && (bi = ThemisProject.getIconImage35px((String)iconfile)) != null) {
                this.lblIcon.setIcon(new ImageIcon(bi));
                this.lblIcon.setVisible(true);
            }
            this.fldLocation.setText(this.location.getFullNumber() + "  " + this.location.getAttributeValue("title"));
            this.fldObservationTitle.setText(this.location.getFullNumber() + "." + this.observation.getAttributeValue("number") + "  " + this.observation.getAttributeValue("title"));
        } else {
            this.location = null;
            this.fldLocation.setText("-");
            this.fldObservationTitle.setText("");
            this.lblIcon.setIcon(null);
        }
        Date duedate = this.observation.getDateAttribute("duedate").getDate();
        if (duedate != null) {
            String datetext = Util.formatDate((Date)duedate, (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone());
            String[] reminder = this.app.getAppointmentInfo();
            Date reminderDate = ThemisApplication.applyPeriodToDate((Date)new Date(), (Integer)Integer.parseInt(reminder[1]), (Integer)Integer.parseInt(reminder[0]));
            if (this.observation.isDone() && (this.observation.isOfType(1) || this.observation.isOfType(4))) {
                this.panelDuedate.setBackground(THEMIS.white);
            } else if (duedate.after(reminderDate)) {
                this.panelDuedate.setBackground(THEMIS.white);
                datetext = datetext + " (" + this.project.getResourceText("ObservationControlTopComponent.duedate.nichtfaellig", this.app.getLocale()) + ")";
            } else if (duedate.before(reminderDate) && duedate.after(new Date())) {
                this.panelDuedate.setBackground(THEMIS.yellow);
                datetext = datetext + " (" + this.project.getResourceText("ObservationControlTopComponente.duedate.faellig", this.app.getLocale()) + ")";
            } else {
                this.panelDuedate.setBackground(THEMIS.red);
                datetext = datetext + " (" + this.project.getResourceText("ObservationControlTopComponente.duedate.ueberfaellig", this.app.getLocale()) + ")";
            }
            this.lblDuedate.setText(datetext);
        } else {
            this.lblDuedate.setText(this.project.getResourceText("ObservationControlTopComponent.duedate.noduedate", this.app.getLocale()));
            this.panelDuedate.setBackground(THEMIS.white);
        }
    }

    private boolean loadNextObservation(boolean trigger, boolean forcesave, int step) {
        if (!this.project.isOpen()) {
            this.clear();
            return true;
        }
        boolean saved = this.updateObservation(trigger, true);
        if (!saved && forcesave) {
            this.observation.save();
            saved = true;
            if (trigger) {
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(this.observation.getId()));
            }
        }
        switch (step) {
            case 1: {
                if (this.previousObservationId <= 0L) break;
                this.loadObservation(this.previousObservationId, trigger);
                break;
            }
            case 2: {
                if (this.nextObservationId <= 0L) break;
                this.loadObservation(this.nextObservationId, trigger);
            }
        }
        if (this.observation != null) {
            this.project.getSelectionManager().setSelectedObservation(this.observation.getId(), true, (Object)this);
        } else {
            this.project.getSelectionManager().clearSelection(true, (Object)this);
        }
        return saved;
    }

    private void initComponents() {
        this.panelAttributesScroll = new JScrollPane();
        this.panelAttributes = new JPanel();
        this.fldObservationScroll = new PDControlScrollPane();
        this.fldObservation = new JEditorPane();
        this.panelTop = new JPanel();
        this.lblIcon = new JLabel();
        this.fldLocation = new JTextField();
        this.lblType = new JLabel();
        this.fldObservationTitle = new JTextField();
        this.panelHistories = new JPanel();
        this.btnPreviousHistory = new JButton();
        this.fldHistories = new JComboBox();
        this.btnNextHistory = new JButton();
        this.panelMainScroll = new JScrollPane();
        this.panelMain = new JPanel();
        this.panelStatus = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblStatus = new JLabel();
        this.panelDuedate = new JPanel();
        this.jLabel2 = new JLabel();
        this.lblDuedate = new JLabel();
        this.panelButtons = new JPanel();
        this.btnPrev = new JButton();
        this.btnChecked = new JButton();
        this.btnDone = new JButton();
        this.btnNext = new JButton();
        this.jLabel3 = new JLabel();
        this.btnSendMail = new JButton();
        this.btnShowInPlan = new JButton();
        this.jPanel1 = new JPanel();
        this.btnEditLoc = new JButton();
        this.btnEdit = new JButton();
        this.panelMangel = new JPanel();
        this.panelAttributesScroll.setBorder(null);
        this.panelAttributesScroll.setMaximumSize(new Dimension(Short.MAX_VALUE, 300));
        this.panelAttributesScroll.setMinimumSize(new Dimension(23, 1));
        this.panelAttributes.setLayout(new GridBagLayout());
        this.panelAttributesScroll.setViewportView(this.panelAttributes);
        this.fldObservationScroll.setMinimumSize(new Dimension(100, 100));
        this.fldObservationScroll.setPreferredSize(new Dimension(200, 300));
        this.fldObservationScroll.setRequestFocusEnabled(false);
        this.fldObservation.setEditable(false);
        this.fldObservation.setContentType("text/html");
        this.fldObservation.setFont(THEMIS.fontTextfield);
        this.fldObservationScroll.setViewportView(this.fldObservation);
        this.setPreferredSize(new Dimension(460, 592));
        this.setLayout(new GridBagLayout());
        this.panelTop.setLayout(new GridBagLayout());
        this.lblIcon.setFont(THEMIS.fontLabelBigBold);
        this.lblIcon.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblIcon, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.lblIcon.text"));
        this.lblIcon.setFocusable(false);
        this.lblIcon.setIconTextGap(0);
        this.lblIcon.setMinimumSize(new Dimension(50, 50));
        this.lblIcon.setOpaque(true);
        this.lblIcon.setPreferredSize(new Dimension(50, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelTop.add((Component)this.lblIcon, gridBagConstraints);
        this.fldLocation.setEditable(false);
        this.fldLocation.setFont(THEMIS.fontLabelBold);
        this.fldLocation.setText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.fldLocation.text"));
        this.fldLocation.setBorder(null);
        this.fldLocation.setFocusable(false);
        this.fldLocation.setMinimumSize(new Dimension(100, 25));
        this.fldLocation.setPreferredSize(new Dimension(100, 25));
        this.fldLocation.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelTop.add((Component)this.fldLocation, gridBagConstraints);
        this.lblType.setFont(THEMIS.fontLabelBigBold);
        this.lblType.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblType, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.lblType.text"));
        this.lblType.setBorder(BorderFactory.createBevelBorder(0));
        this.lblType.setMinimumSize(new Dimension(40, 40));
        this.lblType.setPreferredSize(new Dimension(40, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelTop.add((Component)this.lblType, gridBagConstraints);
        this.fldObservationTitle.setEditable(false);
        this.fldObservationTitle.setFont(THEMIS.fontLabelBold);
        this.fldObservationTitle.setText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.fldObservationTitle.text"));
        this.fldObservationTitle.setBorder(null);
        this.fldObservationTitle.setFocusable(false);
        this.fldObservationTitle.setMinimumSize(new Dimension(100, 25));
        this.fldObservationTitle.setPreferredSize(new Dimension(100, 25));
        this.fldObservationTitle.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelTop.add((Component)this.fldObservationTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelTop, gridBagConstraints);
        this.panelHistories.setLayout(new GridBagLayout());
        this.btnPreviousHistory.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft24.gif")));
        this.btnPreviousHistory.setMaximumSize(new Dimension(50, 30));
        this.btnPreviousHistory.setMinimumSize(new Dimension(50, 30));
        this.btnPreviousHistory.setPreferredSize(new Dimension(50, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelHistories.add((Component)this.btnPreviousHistory, gridBagConstraints);
        this.fldHistories.setFont(THEMIS.fontList);
        this.fldHistories.setModel(new DefaultComboBoxModel());
        this.fldHistories.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.fldHistories.setMinimumSize(new Dimension(56, 30));
        this.fldHistories.setPreferredSize(new Dimension(56, 30));
        this.fldHistories.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ObservationEditPanel.this.fldHistoriesItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelHistories.add(this.fldHistories, gridBagConstraints);
        this.btnNextHistory.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        this.btnNextHistory.setMaximumSize(new Dimension(50, 30));
        this.btnNextHistory.setMinimumSize(new Dimension(50, 30));
        this.btnNextHistory.setPreferredSize(new Dimension(50, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelHistories.add((Component)this.btnNextHistory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelHistories, gridBagConstraints);
        this.panelMainScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.panelMain.setLayout(new GridBagLayout());
        this.panelMainScroll.setViewportView(this.panelMain);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelMainScroll, gridBagConstraints);
        this.panelStatus.setBackground(new Color(255, 255, 255));
        this.panelStatus.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.panelStatus.setPreferredSize(new Dimension(159, 30));
        this.panelStatus.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.jLabel1.text"));
        this.jLabel1.setMinimumSize(new Dimension(120, 30));
        this.jLabel1.setPreferredSize(new Dimension(120, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStatus.add((Component)this.jLabel1, gridBagConstraints);
        this.lblStatus.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblStatus, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.lblStatus.text"));
        this.lblStatus.setMinimumSize(new Dimension(120, 30));
        this.lblStatus.setPreferredSize(new Dimension(120, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStatus.add((Component)this.lblStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.panelStatus, gridBagConstraints);
        this.panelDuedate.setBackground(new Color(255, 255, 255));
        this.panelDuedate.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.panelDuedate.setPreferredSize(new Dimension(159, 30));
        this.panelDuedate.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.jLabel2.text"));
        this.jLabel2.setMinimumSize(new Dimension(120, 30));
        this.jLabel2.setPreferredSize(new Dimension(120, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDuedate.add((Component)this.jLabel2, gridBagConstraints);
        this.lblDuedate.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblDuedate, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.lblDuedate.text"));
        this.lblDuedate.setMinimumSize(new Dimension(120, 30));
        this.lblDuedate.setPreferredSize(new Dimension(120, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelDuedate.add((Component)this.lblDuedate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.panelDuedate, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnPrev.setFont(THEMIS.fontButton);
        this.btnPrev.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPrev, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnPrev.text"));
        this.btnPrev.setToolTipText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnPrev.toolTipText"));
        this.btnPrev.setBorder(new SoftBevelBorder(0));
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationEditPanel.this.btnPrevActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnPrev, gridBagConstraints);
        this.btnChecked.setFont(THEMIS.fontButton);
        this.btnChecked.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/controlled24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnChecked, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnChecked.text"));
        this.btnChecked.setToolTipText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnChecked.toolTipText"));
        this.btnChecked.setBorder(new SoftBevelBorder(0));
        this.btnChecked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationEditPanel.this.btnCheckedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnChecked, gridBagConstraints);
        this.btnDone.setFont(THEMIS.fontButton);
        this.btnDone.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDone, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnDone.text"));
        this.btnDone.setToolTipText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnDone.toolTipText"));
        this.btnDone.setBorder(new SoftBevelBorder(0));
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationEditPanel.this.btnDoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnDone, gridBagConstraints);
        this.btnNext.setFont(THEMIS.fontButton);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNext, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnNext.text"));
        this.btnNext.setToolTipText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnNext.toolTipText"));
        this.btnNext.setBorder(new SoftBevelBorder(0));
        this.btnNext.setHorizontalTextPosition(2);
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationEditPanel.this.btnNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnNext, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panelButtons.add((Component)this.jLabel3, gridBagConstraints);
        this.btnSendMail.setFont(THEMIS.fontButton);
        this.btnSendMail.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/email24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSendMail, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnSendMail.text"));
        this.btnSendMail.setToolTipText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnSendMail.toolTipText"));
        this.btnSendMail.setBorder(new SoftBevelBorder(0));
        this.btnSendMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationEditPanel.this.btnSendMailActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnSendMail, gridBagConstraints);
        this.btnShowInPlan.setFont(THEMIS.fontButton);
        this.btnShowInPlan.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/locateInPlan24_1.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowInPlan, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnShowInPlan.text"));
        this.btnShowInPlan.setToolTipText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnShowInPlan.toolTipText"));
        this.btnShowInPlan.setBorder(new SoftBevelBorder(0));
        this.btnShowInPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationEditPanel.this.btnShowInPlanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnShowInPlan, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnEditLoc.setFont(THEMIS.fontButton);
        this.btnEditLoc.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_editObs24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEditLoc, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnEditLoc.text"));
        this.btnEditLoc.setToolTipText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnEditLoc.toolTipText"));
        this.btnEditLoc.setBorder(new SoftBevelBorder(0));
        this.btnEditLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationEditPanel.this.btnEditLocActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnEditLoc, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_editObs24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(ObservationEditPanel.class, (String)"ObservationEditPanel.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationEditPanel.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnEdit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelButtons.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelButtons, gridBagConstraints);
        this.panelMangel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelMangel, gridBagConstraints);
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.loadNextObservation(true, false, 2);
    }

    private void btnCheckedActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.observation != null && THEMIS.checkAndCreateEvent()) {
            ArrayList filterIds = this.app.getFilter().getFilteredObservationIds();
            int currentIndex = filterIds.indexOf(this.observation.getId());
            this.updateObservation(false, false);
            this.observation.setControlled();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(this.observation.getId()));
            this.updateDisplayAfterFilterChange(currentIndex);
        }
    }

    private void btnDoneActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.observation != null && THEMIS.checkAndCreateEvent()) {
            ArrayList filterIds = this.app.getFilter().getFilteredObservationIds();
            int currentIndex = filterIds.indexOf(this.observation.getId());
            this.updateObservation(false, false);
            this.observation.setDone(!this.observation.getBooleanAttribute("done").isSet());
            this.observation.save();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(this.observation.getId()));
            this.updateDisplayAfterFilterChange(currentIndex);
        }
    }

    private void updateDisplayAfterFilterChange(int currentIndex) {
        long currentObsId = this.observation.getId();
        this.app.getFilter().resetSearchResult();
        ArrayList filterIds = this.app.getFilter().getFilteredObservationIds();
        if (filterIds.isEmpty()) {
            this.clear();
        } else {
            long newObsId = -1L;
            newObsId = currentIndex < 0 ? (Long)filterIds.get(0) : (currentIndex < filterIds.size() ? ((Long)filterIds.get(currentIndex)).longValue() : ((Long)filterIds.get(filterIds.size() - 1)).longValue());
            if (newObsId != currentObsId) {
                this.loadObservation(newObsId, true);
                this.project.getSelectionManager().setSelectedObservation(newObsId, true, (Object)this);
            }
        }
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.observation != null && this.location != null && THEMIS.checkAndCreateEvent()) {
            this.updateObservation(true, true);
            new LocationObservationDialog().editObservation((CmsElement)this.location, this.observation.getId());
            this.loadObservation(this.observation.getId(), true);
        }
    }

    private void btnPrevActionPerformed(ActionEvent evt) {
        this.loadNextObservation(true, false, 1);
    }

    private void btnEditLocActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.location != null) {
            this.updateObservation(true, true);
            new LocationObservationDialog().editLocation((CmsElement)this.location);
            this.loadObservation(this.observation.getId(), true);
        }
    }

    private void fldHistoriesItemStateChanged(ItemEvent evt) {
    }

    private void btnShowInPlanActionPerformed(ActionEvent evt) {
        ThemisActions.showObservationInPlan();
    }

    private void btnSendMailActionPerformed(ActionEvent evt) {
        if (this.observation != null) {
            // empty if block
        }
    }
}

