/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.MultiObservationPanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ThemisActions;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.observation.ThemisTableCellRenderer;
import at.grid.themis.application.observation.ThemisTableColumnHeaderListener;
import at.grid.themis.application.observation.ThemisTableModel;
import at.grid.themis.application.observation.ThemisTableModelDataProvider;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class ObservationListPanel
extends JPanel
implements ThemisActionListener,
ThemisTableModelDataProvider {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    ArrayList<Long> observationids = new ArrayList();
    boolean triggerEnabled = true;
    boolean selectAllChkBoxes = false;
    String tablesort = "ele.number,observation.number";
    ThemisTableCellRenderer cellRenderer;
    TopComponent topComponent;
    private JButton btnEditObs;
    private JButton btnSelectAll;
    private JButton btnShowInPlan;
    private JScrollPane jScrollPane1;
    private JPanel panelButtons;
    private JTable table;

    public ObservationListPanel(TopComponent tc, boolean editor) {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + this.getClass().getName() + " ...");
        this.topComponent = tc;
        THEMIS.getLicense();
        this.initComponents();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setModel(new ThemisTableModel(this.table, this));
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(40, Integer.MAX_VALUE));
        this.table.setFont(THEMIS.fontLabel);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.setRowSelectionAllowed(false);
        this.table.setShowVerticalLines(false);
        this.cellRenderer = new ThemisTableCellRenderer();
        this.table.setDefaultRenderer(Object.class, this.cellRenderer);
        this.table.setDefaultRenderer(Date.class, this.cellRenderer);
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new ThemisTableColumnHeaderListener(this.table));
        header.setFont(THEMIS.fontLabelBold);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                JTable table = (JTable)me.getSource();
                Point p = me.getPoint();
                int row = table.rowAtPoint(p);
                int col = table.columnAtPoint(p);
                if (col > 0) {
                    ObservationListPanel.this.getTableModel().setSelectedRow(table.getSelectedRow());
                    table.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                JTable table = (JTable)me.getSource();
                Point p = me.getPoint();
                int row = table.rowAtPoint(p);
                if (me.getClickCount() == 2) {
                    if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)ObservationListPanel.this.app)) {
                        return;
                    }
                    ObservationListPanel.this.handleObservationEdit();
                }
            }
        });
        new DragScrollHandler(this.table);
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            this.btnEditObs.setEnabled(false);
        }
        if (editor) {
            ThemisActionProvider.getInstance().registerEditor(this);
        } else {
            ThemisActionProvider.getInstance().register(this);
        }
        if (this.project.isOpen()) {
            this.updateTableModel();
        }
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + this.getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        if (this == action.getSource()) {
            return;
        }
        switch (action.getAction()) {
            case 1300: {
                this.btnEditObs.setEnabled(!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE));
                break;
            }
            case 100: 
            case 300: 
            case 301: 
            case 302: 
            case 501: 
            case 601: 
            case 650: 
            case 651: 
            case 1110: 
            case 2000: {
                this.updateTableModel();
                break;
            }
            case 1100: {
                this.getTableModel().setDataProvider(this);
                this.updateTableModel();
                break;
            }
            case 1101: {
                this.project.getSelectionManager().reset(false, (Object)this);
                this.table.setModel(new ThemisTableModel(this.table, null));
                this.getTableModel().initialise();
                this.table.revalidate();
                this.table.repaint();
                break;
            }
            case 1102: 
            case 1103: {
                if (this.project == null || !this.project.isOpen()) {
                    this.getTableModel().initialise();
                    this.table.repaint();
                    break;
                }
                this.updateTableModel();
            }
        }
    }

    public ArrayList<Long> getObservationids() {
        return this.observationids;
    }

    private ThemisTableModel getTableModel() {
        return (ThemisTableModel)this.table.getModel();
    }

    @Override
    public void setTableSort(String s) {
        if ("fullnumber".equalsIgnoreCase(s)) {
            s = null;
        }
        this.tablesort = s == null ? "ele.number,observation.number,observation.idelement" : (this.tablesort == null || this.tablesort.startsWith(s + " desc") || !this.tablesort.startsWith(s) ? (s == null ? "" : s + ",") + "ele.number,observation.number" : (s == null ? "" : s + " desc,") + "ele.number,observation.number");
    }

    private boolean checkForSelection() {
        ArrayList<Long> sel = this.getTableModel().getSelectedObservationIds();
        int selrow = this.table.getSelectedRow();
        if (selrow < 0 && sel.isEmpty()) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationListTopComponent.chooseObsFirst.text"));
            return false;
        }
        return true;
    }

    private boolean checkForCurrentEvent() {
        if (!this.project.checkForCurrentEvent(false)) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noevent", this.app.getLocale()));
            return false;
        }
        return true;
    }

    @Override
    public void initialiseTableColumns(ThemisTableModel tm) {
        if (this.project == null || !this.project.isOpen()) {
            return;
        }
        int idx = 0;
        tm.addCheckColumn(idx++);
        ArrayList observationTableAttributes = this.settings.getObservationTableAttributes();
        for (ThemisAttribute ta : observationTableAttributes) {
            if (ta == null || !ta.isVirtual() && !ta.isUsed()) continue;
            tm.addTableColumn(ta, idx++);
        }
    }

    @Override
    public void updateTableModel() {
        if (this.project == null || !this.project.isOpen()) {
            return;
        }
        ArrayList eventObsIds = new ArrayList();
        if (this.project.getCurrentEvent() != null) {
            eventObsIds = this.project.getCurrentEvent().getObservationIds();
        }
        boolean selectFirstObs = false;
        boolean selectFromLocation = false;
        this.cellRenderer.updateColors();
        ThemisTableModel tm = new ThemisTableModel(this.table, this);
        tm.initialise();
        String selWhere = null;
        boolean rememberObsList = true;
        if (!this.project.getSelectionManager().getSelectedLocationIds().isEmpty() && this.app.getSettings().getDoFilterSelectedLocation()) {
            selWhere = "ele.idelement IN " + Util.toSqlString((Iterable)this.project.getSelectionManager().getSelectedLocationIds());
            rememberObsList = false;
        }
        boolean changedSelection = false;
        ArrayList<Long> sels = new ArrayList<Long>();
        sels.addAll(this.project.getSelectionManager().getSelectedObservationIds());
        ThemisFilter filter = this.app.getFilter();
        List items = filter.getFilteredObservations(this.tablesort, selWhere, rememberObsList);
        if (items == null) {
            return;
        }
        this.observationids.clear();
        boolean firstRow = true;
        for (DataRecord item : items) {
            if (!item.isEmpty("observationid")) {
                String description;
                this.observationids.add(item.getLong("observationid"));
                if (selectFromLocation && this.project.getSelectionManager().getSelectedLocationIds().contains(item.getLong("meta_id"))) {
                    sels.add(item.getLong("observationid"));
                }
                if ((description = item.getString("observationdescription")).contains("\n")) {
                    description = description.replace("\n", "; ");
                }
                item.add("description", description);
                item.add("number", item.get("fullnumber"));
                Integer idtype = item.getInt("idtype");
                if (idtype != null) {
                    switch (idtype) {
                        case 2: {
                            item.add("type", this.settings.getTerm(ThemisSettings.Term.TypKontrolle));
                            break;
                        }
                        case 1: {
                            item.add("type", this.settings.getTerm(ThemisSettings.Term.TypMangel));
                            break;
                        }
                        case 3: {
                            item.add("type", this.settings.getTerm(ThemisSettings.Term.TypInformation));
                            break;
                        }
                        case 4: {
                            item.add("type", this.settings.getTerm(ThemisSettings.Term.TypAufgabe));
                            break;
                        }
                    }
                } else {
                    boolean bl = false;
                }
                String control = "";
                if (eventObsIds.contains(item.getLong("observationid"))) {
                    control = "OK";
                }
                item.add("control", control);
                long itemId = item.getLong("observationid");
                tm.addRow(item, sels.contains(itemId));
                if (firstRow && selectFirstObs) {
                    sels.add(itemId);
                }
            }
            firstRow = false;
        }
        tm.setSelectedObservationIds(sels);
        if (sels.size() > 0) {
            ArrayList<Integer> selRows = tm.getSelectedIndices();
            if (selRows.size() > 0) {
                this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(selRows.get(0), 0, true)));
            } else {
                boolean bl = true;
            }
        }
        if (changedSelection) {
            this.project.getSelectionManager().setSelectedObservations(sels, true, (Object)this);
        }
        tm.setSelectedObservationIds(sels);
        int numberOfObservations = this.observationids.size();
        this.topComponent.setDisplayName(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationListTopComponent.obsListAndCount.text"), numberOfObservations));
        this.table.setModel(tm);
        tm.setTableColumnWidth(this.table);
        this.table.revalidate();
        this.table.repaint();
    }

    @Override
    public void moveTableColumn(int from, int to) {
        ThemisTableModel tm = (ThemisTableModel)this.table.getModel();
        ThemisAttribute ta = tm.getThemisAttribute(from);
        if (ta != null) {
            this.settings.moveObservationTableAttributes(ta, to);
        }
    }

    @Override
    public void changeColumnWidth(String columnCode, ThemisTableModel.TableColumn col) {
        if (col.ta != null) {
            this.settings.setObservationTableColumnWidth(col.ta, col.getWidth());
        }
    }

    @Override
    public void selectionChanged() {
        this.project.getSelectionManager().setSelectedObservations(this.getTableModel().getSelectedObservationIds(), true, (Object)this);
    }

    @Override
    public void selectionChanged(long id) {
        this.project.getSelectionManager().setSelectedObservations(this.getTableModel().getSelectedObservationIds(), true, (Object)this);
    }

    public void selectAllObservations() {
        this.getTableModel().selectAllOrNone();
        this.updateSelection();
    }

    public CmsObservation getSelectedObservation() {
        long obsid = this.getSelectedObservationId();
        if (obsid < 0L) {
            return null;
        }
        return (CmsObservation)this.project.loadElement(obsid, this.project.getUser());
    }

    public long getSelectedObservationId() {
        int idx = this.table.getSelectedRow();
        if (idx < 0 || idx >= this.observationids.size()) {
            return -1L;
        }
        return this.observationids.get(idx);
    }

    public void setSelectedObservationId(long id) {
        int idx = this.observationids.indexOf(id);
        if (idx >= 0) {
            this.table.getSelectionModel().setSelectionInterval(idx, idx);
            this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(idx, 0, true)));
        }
    }

    public void setSelectedObservationId(ArrayList<Long> ids) {
        boolean first = true;
        this.table.clearSelection();
        ((ThemisTableModel)this.table.getModel()).clearSelection();
        for (long id : ids) {
            int idx = this.observationids.indexOf(id);
            if (idx < 0) continue;
            ((ThemisTableModel)this.table.getModel()).addSelectedRowWithoutProjectUpdate(idx);
            this.table.getSelectionModel().setSelectionInterval(idx, idx);
            if (first) {
                this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(idx, 0, true)));
            }
            first = false;
        }
    }

    private void updateSelection() {
        long obsid;
        ThemisTableModel tm = this.getTableModel();
        ArrayList<Long> sel = tm.getSelectedObservationIds();
        if (sel.size() > 0) {
            this.project.getSelectionManager().setSelectedObservations(sel, true, (Object)this);
        }
        if ((obsid = this.getSelectedObservationId()) >= 0L && sel.isEmpty()) {
            this.project.getSelectionManager().setSelectedObservation(obsid, true, (Object)this);
        } else {
            this.project.getSelectionManager().clearSelection(true, (Object)this);
        }
    }

    public void handleObservationEdit() {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        if (this.checkForSelection() && THEMIS.checkAndCreateEvent()) {
            ArrayList<Long> sel = this.getTableModel().getSelectedObservationIds();
            if (sel.size() > 1) {
                MultiObservationPanel p = new MultiObservationPanel(sel);
                Object[] btnObsPanel = new String[]{ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationListTopComponent.close.text")};
                JOptionPane panel = new JOptionPane(p, -1, 0, null, btnObsPanel, btnObsPanel[0]);
                try {
                    JDialog dialog = panel.createDialog(null, ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationListTopComponent.editObservation.text"));
                    dialog.setResizable(true);
                    THEMIS.setDialogIcon(dialog);
                    dialog.setVisible(true);
                }
                catch (Exception exception) {}
            } else if (sel.size() == 1) {
                CmsLocation loc;
                CmsObservation obs = (CmsObservation)this.project.loadElement(sel.get(0).longValue(), this.project.getUser());
                CmsElementSummary ele = obs.getRelationAttribute("location").getFirstElement();
                if (ele == null) {
                    loc = (CmsLocation)this.app.getProject().createElement("location");
                    loc.getRelationAttribute("observations").add((CmsElement)obs);
                } else {
                    loc = (CmsLocation)ele.getElement();
                }
                if (loc != null) {
                    new LocationObservationDialog().editObservation((CmsElement)loc, obs.getId());
                }
            } else {
                Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationListTopComponent.chooseObsFirst.text"));
            }
        }
    }

    private int handleClickEventOnTable(JTable table, MouseEvent evt) {
        table = (JTable)evt.getSource();
        if (evt.getClickCount() == 2) {
            return 2;
        }
        return -1;
    }

    private void initComponents() {
        this.panelButtons = new JPanel();
        this.btnShowInPlan = new JButton();
        this.btnEditObs = new JButton();
        this.btnSelectAll = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.setLayout(new GridBagLayout());
        this.panelButtons.setLayout(new GridBagLayout());
        this.btnShowInPlan.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/locateInPlan24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowInPlan, (String)NbBundle.getMessage(ObservationListPanel.class, (String)"ObservationListPanel.btnShowInPlan.text"));
        this.btnShowInPlan.setToolTipText(NbBundle.getMessage(ObservationListPanel.class, (String)"ObservationListPanel.btnShowInPlan.toolTipText"));
        this.btnShowInPlan.setMinimumSize(new Dimension(35, 35));
        this.btnShowInPlan.setPreferredSize(new Dimension(35, 35));
        this.btnShowInPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationListPanel.this.btnShowInPlanActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelButtons.add((Component)this.btnShowInPlan, gridBagConstraints);
        this.btnEditObs.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEditObs, (String)NbBundle.getMessage(ObservationListPanel.class, (String)"ObservationListPanel.btnEditObs.text"));
        this.btnEditObs.setToolTipText(NbBundle.getMessage(ObservationListPanel.class, (String)"ObservationListPanel.btnEditObs.toolTipText"));
        this.btnEditObs.setMinimumSize(new Dimension(35, 35));
        this.btnEditObs.setPreferredSize(new Dimension(35, 35));
        this.btnEditObs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationListPanel.this.btnEditObsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelButtons.add((Component)this.btnEditObs, gridBagConstraints);
        this.btnSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_selectAllObs24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectAll, (String)NbBundle.getMessage(ObservationListPanel.class, (String)"ObservationListPanel.btnSelectAll.text"));
        this.btnSelectAll.setToolTipText(NbBundle.getMessage(ObservationListPanel.class, (String)"ObservationListPanel.btnSelectAll.toolTipText"));
        this.btnSelectAll.setMinimumSize(new Dimension(35, 35));
        this.btnSelectAll.setPreferredSize(new Dimension(35, 35));
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObservationListPanel.this.btnSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelButtons.add((Component)this.btnSelectAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.panelButtons, gridBagConstraints);
        this.jScrollPane1.setAutoscrolls(true);
        this.table.setModel(new ThemisTableModel(this.table, null));
        this.table.setRowHeight(22);
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObservationListPanel.this.tablePropertyChange(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void tablePropertyChange(PropertyChangeEvent evt) {
    }

    private void btnShowInPlanActionPerformed(ActionEvent evt) {
        ThemisActions.showObservationInPlan();
    }

    private void btnEditObsActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (!this.project.getSelectionManager().hasSelectedObservationIds()) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationListTopComponent.chooseObsFirst.text"));
            return;
        }
        if (THEMIS.checkAndCreateEvent() && this.project.getCurrentEventId() > 0L) {
            ArrayList sel = this.project.getSelectionManager().getSelectedObservationIds();
            if (sel.size() > 1) {
                MultiObservationPanel p = new MultiObservationPanel(sel);
                p.showDialog();
            } else {
                CmsLocation loc;
                long obsid = (Long)sel.get(0);
                CmsObservation obs = (CmsObservation)this.project.loadElement(obsid, this.project.getUser());
                CmsElementSummary ele = obs.getRelationAttribute("location").getFirstElement();
                if (ele == null) {
                    loc = (CmsLocation)this.app.getProject().createElement("location");
                    loc.getRelationAttribute("observations").add((CmsElement)obs);
                } else {
                    loc = (CmsLocation)ele.getElement();
                }
                if (loc != null) {
                    new LocationObservationDialog().editObservation((CmsElement)loc, obs.getId());
                }
            }
        }
    }

    private void btnSelectAllActionPerformed(ActionEvent evt) {
        ThemisTableModel tm = (ThemisTableModel)this.table.getModel();
        tm.selectAllOrNone();
        this.table.setModel(tm);
        this.table.repaint();
    }
}

