/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsObservation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import javax.swing.GroupLayout;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ObservationViewerTopComponent", persistenceType=0)
public final class ObservationViewerTopComponent
extends TopComponent
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    final JFXPanel jfx;

    public ObservationViewerTopComponent() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + ((Object)((Object)this)).getClass().getName() + " ...");
        THEMIS.getLicense();
        this.initComponents();
        this.setName(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("CTL_ObservationViewerTopComponent"));
        this.setToolTipText(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("HINT_ObservationViewerTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        ThemisActionProvider.getInstance().register(this);
        this.setLayout(new BorderLayout());
        this.jfx = new JFXPanel();
        this.add((Component)this.jfx, "Center");
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 302: 
            case 650: 
            case 1102: {
                ArrayList ids = this.project.getSelectionManager().getSelectedObservationIds();
                if (ids.isEmpty()) {
                    this.populate(-1L);
                    break;
                }
                this.populate((Long)ids.get(0));
                break;
            }
            case 651: {
                this.populate(action.getId());
                break;
            }
            case 1100: 
            case 1101: {
                this.populate(-1L);
            }
        }
    }

    private void populate(long observationId) {
        String text = "";
        CmsUser user = this.project.getUser();
        if (observationId > 0L && user != null) {
            CmsElement e = this.project.loadElement(observationId, user);
            if (!(e instanceof CmsObservation)) {
                return;
            }
            CmsObservation observation = (CmsObservation)e;
            if (observation == null) {
                return;
            }
            List historyIds = observation.getRelationAttribute("histories").getElementIds(false);
            CmsElement history = null;
            CmsElement previousHistory = null;
            for (int ii = 0; ii < historyIds.size(); ++ii) {
                StringBuilder sb = new StringBuilder();
                previousHistory = history;
                long historyId = (Long)historyIds.get(ii);
                history = this.project.loadElement(historyId, user);
                String title = history.getRelationAttribute("event").getFirstElementTitle();
                if (title.length() > 30) {
                    String temp = title.substring(title.length() - 13, title.length());
                    title = (title = title.substring(0, title.length() - 13)).length() > 25 ? title.substring(0, 25) + " ... " + temp : title + " " + temp;
                }
                if (history.getRelationAttribute("event").getFirstElementTitle().endsWith("  ")) {
                    title = title + ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationViewerTopComponent.eventLocked.text");
                }
                sb.append("<h2>").append(title).append("</h2>");
                String change = ((CmsHistory)history).toString("", "<br>", (CmsHistory)previousHistory);
                sb.append("".equals(change) ? this.project.getResourceText("text.history-no-change") : change);
                text = sb.toString() + text;
            }
        }
        String displayText = text;
        Platform.runLater(() -> {
            WebView webView = new WebView();
            webView.getEngine().loadContent(displayText);
            this.jfx.setScene(new Scene((Parent)webView));
        });
    }

    private void initComponents() {
        this.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        this.setMinimumSize(new Dimension(10, 0));
        this.setPreferredSize(new Dimension(300, 598));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 321, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 598, Short.MAX_VALUE));
    }

    public void componentOpened() {
        ArrayList ids = this.project.getSelectionManager().getSelectedObservationIds();
        if (ids.isEmpty()) {
            this.populate(-1L);
        } else {
            this.populate((Long)ids.get(0));
        }
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

