/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.themis.application.PhotoViewerPanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.settings.ThemisSettings;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="PhotoViewerTopComponent", persistenceType=0)
public final class PhotoViewerTopComponent
extends TopComponent
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisSettings settings = this.app.getSettings();
    ThemisProject project = this.app.getProject();
    PhotoViewerPanel panel;
    private JPanel jPanel1;

    public PhotoViewerTopComponent() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + ((Object)((Object)this)).getClass().getName() + " ...");
        THEMIS.getLicense();
        this.initComponents();
        this.setName(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("CTL_PhotoViewerTopComponent"));
        this.setToolTipText(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("HINT_PhotoViewerTopComponent"));
        this.panel = new PhotoViewerPanel(true);
        GridBagConstraints imagePanelConstraints = new GridBagConstraints();
        imagePanelConstraints.gridx = 0;
        imagePanelConstraints.gridy = 0;
        imagePanelConstraints.fill = 1;
        imagePanelConstraints.weightx = 1.0;
        imagePanelConstraints.weighty = 1.0;
        this.add(this.panel, imagePanelConstraints);
        ThemisActionProvider.getInstance().register(this);
        this.panel.updateComponents();
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 601: 
            case 650: 
            case 651: {
                this.updateDisplay(action.getId());
                break;
            }
            case 1100: {
                this.panel.populateUploadDetails();
                this.panel.updateComponents();
                this.updateDisplay();
                break;
            }
            case 1300: {
                this.panel.updateComponents();
                break;
            }
            case 2001: {
                this.panel.removeGeometries();
                File f = (File)action.getReference();
                if (f != null) {
                    this.panel.createImageReferences(f, "", false);
                    this.requestActive();
                    break;
                }
                this.panel.reset();
                break;
            }
            case 303: 
            case 1101: {
                this.panel.reset();
                break;
            }
            case 302: {
                this.panel.updateComponents();
            }
        }
    }

    private CmsObservation getObservationFromAction(ThemisAction action) {
        if (action.getReference() instanceof CmsObservation) {
            return (CmsObservation)action.getReference();
        }
        if (action.getId() >= 0L) {
            long id = action.getId();
            return (CmsObservation)this.project.loadElement(id, this.project.getUser());
        }
        ArrayList selectedObservationIds = this.project.getSelectionManager().getSelectedObservationIds();
        if (selectedObservationIds.size() > 0 && (Long)selectedObservationIds.get(0) > -1L) {
            return (CmsObservation)this.project.loadElement(((Long)selectedObservationIds.get(0)).longValue(), this.project.getUser());
        }
        return null;
    }

    private void updateDisplay() {
        this.updateDisplay(-1L);
    }

    private void updateDisplay(long lastSelectedId) {
        if (this.app.getSettings().getImageForObservation()) {
            this.panel.updateImagesBasedOnSelection(this.project.getSelectionManager().getSelectedObservationIds(), lastSelectedId);
        } else {
            ArrayList ids = this.project.getSelectionManager().getSelectedLocationIds();
            if (!ids.isEmpty()) {
                this.panel.updateImageBasedOnLocation(this.project.loadElement(((Long)ids.get(0)).longValue(), this.project.getUser()));
            } else {
                this.panel.reset();
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel1.setPreferredSize(new Dimension(70, 100));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 89, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 340, Short.MAX_VALUE));
        this.setPreferredSize(new Dimension(800, 150));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                PhotoViewerTopComponent.this.formComponentShown(evt);
            }
        });
        this.setLayout(new GridBagLayout());
    }

    private void formComponentShown(ComponentEvent evt) {
        this.panel.displayImage();
    }

    public void componentOpened() {
        if (this.project.isOpen()) {
            if (this.settings.getImageForObservation()) {
                this.panel.updateImagesBasedOnSelection(this.project.getSelectionManager().getSelectedObservationIds());
            } else if (this.settings.getImageForLocation()) {
                ArrayList ids = this.project.getSelectionManager().getSelectedLocationIds();
                if (!ids.isEmpty()) {
                    this.panel.updateImageBasedOnLocation(this.project.loadElement(((Long)ids.get(0)).longValue(), this.project.getUser()));
                } else {
                    this.panel.reset();
                }
            } else {
                this.panel.reset();
            }
        }
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.project.isOpen()) {
            if (this.settings.getImageForObservation()) {
                ArrayList ids = this.project.getSelectionManager().getSelectedObservationIds();
                this.panel.updateImagesBasedOnSelection(ids);
                if (ids.isEmpty() && this.project.getSelectionManager().getSelectedLocationIds().size() > 0) {
                    this.panel.updateImageBasedOnLocation(this.project.loadElement(((Long)this.project.getSelectionManager().getSelectedLocationIds().get(0)).longValue(), this.project.getUser()));
                }
            } else if (this.settings.getImageForLocation()) {
                ArrayList ids = this.project.getSelectionManager().getSelectedLocationIds();
                if (!ids.isEmpty()) {
                    this.panel.updateImageBasedOnLocation(this.project.loadElement(((Long)ids.get(0)).longValue(), this.project.getUser()));
                } else {
                    this.panel.reset();
                }
            } else {
                this.panel.reset();
            }
        }
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

