/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.element.CmsElement;
import java.util.ArrayList;

public class PlaceholderForEmail {
    String fullCode;
    String base;
    String att;
    int word = 0;
    String content = null;

    public PlaceholderForEmail setPlaceholder(String code) {
        this.fullCode = code;
        String wihtoutTag = code.substring(3, code.length() - 3);
        String[] splitForWord = wihtoutTag.split("#");
        String[] splitCode = splitForWord[0].split("\\.");
        if (splitForWord.length > 1) {
            this.word = Integer.parseInt(splitForWord[1]);
        }
        this.base = splitCode[0];
        this.att = splitCode[1];
        return this;
    }

    public static ArrayList<PlaceholderForEmail> analyse(String template) {
        ArrayList<PlaceholderForEmail> placeholders = new ArrayList<PlaceholderForEmail>();
        boolean idx = false;
        int nextIdx = template.indexOf("#!#", 0);
        while (nextIdx >= 0) {
            int endIdx = template.indexOf("#!#", nextIdx + 1);
            placeholders.add(new PlaceholderForEmail().setPlaceholder(template.substring(nextIdx, endIdx + 3)));
            nextIdx = template.indexOf("#!#", endIdx + 1);
        }
        return placeholders;
    }

    public void setContent(CmsElement ele) {
        if (this.base.equals(ele.getElementcode())) {
            this.content = ele.getAttributeValue(this.att);
            if (this.word > 0) {
                String[] words = this.content.split(" ");
                this.content = words.length >= this.word ? words[this.word - 1] : "";
            }
        }
    }

    public String apply(String template) {
        if (this.content != null) {
            return template.replaceAll(this.fullCode, this.content);
        }
        return template;
    }
}

