/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.observation.Bundle;
import at.grid.themis.application.ui.IconElementCellRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.TransferHandler;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="TemplateTopComponent", persistenceType=0)
public final class TemplateTopComponent
extends TopComponent
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    ArrayList<Long> templateFavourites = new ArrayList();
    TransferHandler transferHandler;
    long idSel = -1L;
    boolean useIcons = true;
    private JButton btnApplyTemplate;
    private JButton btnApplyTemplateToPlan;
    private JButton btnQuicksearchClear;
    private JToggleButton btnTemplateFavourite;
    private JComboBox fldTemplateLocationgroup;
    private JTextField fldTemplateQuicksearch;
    private JLabel jLabel1;
    private JLabel jLabel15;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JScrollPane jScrollPane4;
    private JLabel lblTemplateLocationGroup;
    private JList lstTemplateLocation;
    private JPanel panelGroupTemplate;
    private JPanel panelLocationTemplate;
    private JPanel panelQuicksearch;

    public TemplateTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_TemplateTopComponent());
        this.setToolTipText(Bundle.HINT_TemplateTopComponent());
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        this.transferHandler = new TransferHandler("selectedValue");
        this.lstTemplateLocation.setDragEnabled(true);
        this.lstTemplateLocation.setTransferHandler(this.transferHandler);
        this.lstTemplateLocation.setCellRenderer(new IconElementCellRenderer());
        ThemisActionProvider.getInstance().register(this);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 1300: {
                break;
            }
            case 1101: {
                this.clear();
                break;
            }
            case 704: 
            case 1100: 
            case 1102: {
                this.populate();
            }
        }
    }

    private void clear() {
        this.fldTemplateLocationgroup.removeAllItems();
        this.lstTemplateLocation.removeAll();
        this.fldTemplateQuicksearch.setText("");
        this.templateFavourites.clear();
        this.updateButtonVisibility();
    }

    private void populate() {
        if (!this.project.isOpen()) {
            this.clear();
            return;
        }
        this.templateFavourites = this.app.getSettings().getTemplateFavourites();
        this.useIcons = this.app.getSettings().getLocationAttribute("icon").isUsed();
        this.lstTemplateLocation.setCellRenderer(new IconElementCellRenderer(this.useIcons));
        List locationGroupTemplates = this.project.getTemplateManger().getLocationGroups(-99L);
        ((DefaultComboBoxModel)this.fldTemplateLocationgroup.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.fldTemplateLocationgroup.getModel()).addElement(new CmsBasicElement(-1L, ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.none.text")));
        ((DefaultComboBoxModel)this.fldTemplateLocationgroup.getModel()).addElement(new CmsBasicElement(-2L, ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.favourites")));
        CmsBasicElement eleSel = null;
        for (DataRecord rec : locationGroupTemplates) {
            CmsBasicElement ele = new CmsBasicElement(rec);
            if (this.idSel == ele.getId()) {
                eleSel = ele;
            }
            ((DefaultComboBoxModel)this.fldTemplateLocationgroup.getModel()).addElement(ele);
        }
        if (eleSel != null) {
            this.fldTemplateLocationgroup.setSelectedItem(eleSel);
        }
        if (this.fldTemplateLocationgroup.getModel().getSize() == 1) {
            this.fldTemplateLocationgroup.setSelectedIndex(0);
        } else if (this.fldTemplateLocationgroup.getModel().getSize() == 0) {
            List locationTemplates = this.project.getTemplateManger().getLocationTemplates(-1L);
            ((DefaultListModel)this.lstTemplateLocation.getModel()).removeAllElements();
            for (DataRecord rec : locationTemplates) {
                if (this.templateFavourites.contains(rec.getLong("meta_id"))) {
                    rec.add("meta_title", "*" + rec.getString("meta_title"));
                }
                CmsBasicElement item = new CmsBasicElement(rec);
                item.setAttribute("file", rec.getString("iconfile"));
                ((DefaultComboBoxModel)this.lstTemplateLocation.getModel()).addElement(item);
            }
        }
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        if (!this.project.isOpen()) {
            this.btnQuicksearchClear.setEnabled(false);
            this.btnApplyTemplate.setEnabled(false);
            this.btnApplyTemplateToPlan.setEnabled(false);
            this.btnTemplateFavourite.setEnabled(false);
        } else {
            this.btnQuicksearchClear.setEnabled(true);
            this.btnApplyTemplate.setEnabled(this.lstTemplateLocation.getSelectedIndex() >= 0);
            this.btnApplyTemplateToPlan.setEnabled(this.lstTemplateLocation.getSelectedIndex() >= 0);
            this.btnTemplateFavourite.setEnabled(true);
        }
    }

    private void updateTemplateQuicksearch() {
        String quicksearch = this.fldTemplateQuicksearch.getText();
        if ("".equals(quicksearch)) {
            this.updateTemplatesByGroup();
        } else {
            this.loadTemplates("locationtemplate", this.lstTemplateLocation, null, -1L, quicksearch, -1L);
        }
    }

    private void updateTemplatesByGroup() {
        CmsBasicElement eleLoc = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
        long selId = -1L;
        if (eleLoc != null) {
            selId = eleLoc.getId();
        }
        this.fldTemplateQuicksearch.setText("");
        CmsBasicElement ele = (CmsBasicElement)this.fldTemplateLocationgroup.getSelectedItem();
        long id = ele == null ? -1L : ele.getId();
        String relationattribute = ele == null ? null : "locationgroup";
        this.loadTemplates("locationtemplate", this.lstTemplateLocation, relationattribute, id, null, selId);
    }

    private void loadTemplates(String elementtype, JList lst, String relationattribute, long parentId, String quicksearch, long selId) {
        if (!this.project.isOpen()) {
            return;
        }
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes(elementtype);
        s.addSelectTitle("meta_title");
        s.addSelectAttribute(this.project.getDefaultElement(elementtype).getAttribute("itemsort"));
        if ("locationtemplate".equalsIgnoreCase(elementtype)) {
            s.addLeftJoin("tdtarelation AS iconrel ON e.idelement=iconrel.elementfrom");
            s.addLeftJoin("tdtafileupload AS iconfile ON iconrel.elementto=iconfile.idelement");
            s.addSelect("iconfile.path", "iconfile");
        }
        s.setSort("ele.itemsort,el.title");
        if (relationattribute != null) {
            if (parentId == -2L) {
                s.addWhere("e.idelement IN " + Util.toSqlString(this.templateFavourites, (boolean)false));
            } else if (parentId < 0L) {
                s.addWhereRelationNone((CmsAttribute)this.app.getProject().getDefaultElement(elementtype).getRelationAttribute(relationattribute));
            } else {
                s.addWhereRelationId((CmsAttribute)this.app.getProject().getDefaultElement(elementtype).getRelationAttribute(relationattribute), "=", Long.toString(parentId));
            }
        } else if (quicksearch != null) {
            s.addWhereFreetext(quicksearch);
        }
        SearchResult result = s.search();
        ((DefaultListModel)lst.getModel()).removeAllElements();
        CmsBasicElement selItem = null;
        for (DataRecord rec : result.getResult()) {
            if (this.templateFavourites.contains(rec.getLong("meta_id"))) {
                rec.add("meta_title", "*" + rec.getString("meta_title"));
            }
            CmsBasicElement item = new CmsBasicElement(rec);
            String iconFilename = rec.getString("iconfile");
            if (iconFilename == null || "".equals(iconFilename)) {
                iconFilename = "/at/grid/themis/application/media/no-icon48.gif";
            }
            item.setAttribute("file", iconFilename);
            if (item.getId() == selId) {
                selItem = item;
            }
            ((DefaultListModel)lst.getModel()).addElement(item);
        }
        if (selItem != null) {
            lst.setSelectedValue(selItem, true);
        }
    }

    private void toggleTemplateFavourite() {
        CmsBasicElement grp = (CmsBasicElement)this.fldTemplateLocationgroup.getSelectedItem();
        CmsBasicElement eleLoc = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
        if (eleLoc != null) {
            boolean sel = this.templateFavourites.contains(eleLoc.getId());
            boolean but = this.btnTemplateFavourite.isSelected();
            if (sel && !but) {
                this.templateFavourites.remove(eleLoc.getId());
                this.btnTemplateFavourite.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/favoriten24.gif")));
            } else if (!sel && but) {
                this.templateFavourites.add(eleLoc.getId());
                this.btnTemplateFavourite.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/favoriten_selected24.gif")));
            }
            this.app.getSettings().setTemplateFavourite(this.templateFavourites);
            if ("".equals(this.fldTemplateQuicksearch.getText())) {
                this.updateTemplatesByGroup();
            } else {
                this.updateTemplateQuicksearch();
            }
        }
    }

    private void applyLocationTemplate(boolean locateInPlan) {
        CmsBasicElement ele = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
        if (ele == null) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.selectTemplateFirstNotification.text"));
            return;
        }
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        CmsLocation location = this.project.createLocation(ele.getId());
        if (locateInPlan) {
            this.project.setAddMapRefToLoc(location);
            Notification notification = THEMIS.notify(1, "Planbezug setzen", ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("LocationsListTopComponent.placeItem.text"));
        } else {
            if (this.app.getSettings().getDoCreateNewObservationWithLocation()) {
                CmsObservation observation = this.project.createObservation(location);
                new LocationObservationDialog().editObservation((CmsElement)location, observation);
            } else {
                new LocationObservationDialog().editLocation((CmsElement)location);
            }
            if (location != null && location.isSaved()) {
                this.project.updateCurrentEvent();
                this.project.getSelectionManager().setSelectedLocation(location.getId(), true, (Object)this);
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.panelQuicksearch = new JPanel();
        this.fldTemplateQuicksearch = new JTextField();
        this.btnQuicksearchClear = new JButton();
        this.panelGroupTemplate = new JPanel();
        this.lblTemplateLocationGroup = new JLabel();
        this.fldTemplateLocationgroup = new JComboBox();
        this.panelLocationTemplate = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.lstTemplateLocation = new JList();
        this.jLabel3 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnApplyTemplateToPlan = new JButton();
        this.btnApplyTemplate = new JButton();
        this.btnTemplateFavourite = new JToggleButton();
        this.jLabel15 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add(this.jLabel1, gridBagConstraints);
        this.panelQuicksearch.setLayout(new GridBagLayout());
        this.fldTemplateQuicksearch.setFont(THEMIS.fontTextfield);
        this.fldTemplateQuicksearch.setText(NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.fldTemplateQuicksearch.text"));
        this.fldTemplateQuicksearch.setMinimumSize(new Dimension(200, 35));
        this.fldTemplateQuicksearch.setPreferredSize(new Dimension(200, 35));
        this.fldTemplateQuicksearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateTopComponent.this.fldTemplateQuicksearchActionPerformed(evt);
            }
        });
        this.fldTemplateQuicksearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TemplateTopComponent.this.fldTemplateQuicksearchKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelQuicksearch.add((Component)this.fldTemplateQuicksearch, gridBagConstraints);
        this.btnQuicksearchClear.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnQuicksearchClear, (String)NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.btnQuicksearchClear.text"));
        this.btnQuicksearchClear.setToolTipText(NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.btnQuicksearchClear.toolTipText"));
        this.btnQuicksearchClear.setBorder(new SoftBevelBorder(0));
        this.btnQuicksearchClear.setMinimumSize(new Dimension(35, 35));
        this.btnQuicksearchClear.setPreferredSize(new Dimension(35, 35));
        this.btnQuicksearchClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateTopComponent.this.btnQuicksearchClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelQuicksearch.add((Component)this.btnQuicksearchClear, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.panelQuicksearch, gridBagConstraints);
        this.lblTemplateLocationGroup.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblTemplateLocationGroup, (String)NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.lblTemplateLocationGroup.text"));
        this.fldTemplateLocationgroup.setFont(THEMIS.fontList);
        this.fldTemplateLocationgroup.setModel(new DefaultComboBoxModel());
        this.fldTemplateLocationgroup.setMinimumSize(new Dimension(28, 35));
        this.fldTemplateLocationgroup.setPreferredSize(new Dimension(220, 35));
        this.fldTemplateLocationgroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TemplateTopComponent.this.fldTemplateLocationgroupItemStateChanged(evt);
            }
        });
        GroupLayout panelGroupTemplateLayout = new GroupLayout(this.panelGroupTemplate);
        this.panelGroupTemplate.setLayout(panelGroupTemplateLayout);
        panelGroupTemplateLayout.setHorizontalGroup(panelGroupTemplateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTemplateLocationGroup, -1, -1, Short.MAX_VALUE).addComponent(this.fldTemplateLocationgroup, 0, 0, Short.MAX_VALUE));
        panelGroupTemplateLayout.setVerticalGroup(panelGroupTemplateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGroupTemplateLayout.createSequentialGroup().addComponent(this.lblTemplateLocationGroup).addGap(10, 10, 10).addComponent(this.fldTemplateLocationgroup, -2, -1, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.panelGroupTemplate, gridBagConstraints);
        this.panelLocationTemplate.setPreferredSize(new Dimension(390, 291));
        this.panelLocationTemplate.setLayout(new BorderLayout(5, 5));
        this.jScrollPane4.setMinimumSize(new Dimension(40, 200));
        this.jScrollPane4.setPreferredSize(new Dimension(250, 250));
        this.lstTemplateLocation.setFont(THEMIS.fontListBig);
        this.lstTemplateLocation.setModel(new DefaultListModel());
        this.lstTemplateLocation.setSelectionMode(0);
        this.lstTemplateLocation.setDragEnabled(true);
        this.lstTemplateLocation.setPreferredSize(null);
        this.lstTemplateLocation.setVisibleRowCount(6);
        this.lstTemplateLocation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TemplateTopComponent.this.lstTemplateLocationMouseClicked(evt);
            }
        });
        this.lstTemplateLocation.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TemplateTopComponent.this.lstTemplateLocationValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.lstTemplateLocation);
        this.panelLocationTemplate.add((Component)this.jScrollPane4, "Center");
        this.jLabel3.setFont(THEMIS.fontSubheading);
        this.jLabel3.setText(NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.jLabel3.text"));
        this.panelLocationTemplate.add((Component)this.jLabel3, "North");
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnApplyTemplateToPlan.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApplyTemplateToPlan, (String)NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.btnApplyTemplateToPlan.text"));
        this.btnApplyTemplateToPlan.setToolTipText(NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.btnApplyTemplateToPlan.toolTipText"));
        this.btnApplyTemplateToPlan.setBorder(new SoftBevelBorder(0));
        this.btnApplyTemplateToPlan.setMaximumSize(new Dimension(35, 35));
        this.btnApplyTemplateToPlan.setMinimumSize(new Dimension(35, 35));
        this.btnApplyTemplateToPlan.setPreferredSize(new Dimension(35, 35));
        this.btnApplyTemplateToPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateTopComponent.this.btnApplyTemplateToPlanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnApplyTemplateToPlan, gridBagConstraints);
        this.btnApplyTemplate.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/plus24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApplyTemplate, (String)NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.btnApplyTemplate.text"));
        this.btnApplyTemplate.setToolTipText(NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.btnApplyTemplate.toolTipText"));
        this.btnApplyTemplate.setBorder(new SoftBevelBorder(0));
        this.btnApplyTemplate.setMinimumSize(new Dimension(35, 35));
        this.btnApplyTemplate.setPreferredSize(new Dimension(35, 35));
        this.btnApplyTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateTopComponent.this.btnApplyTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnApplyTemplate, gridBagConstraints);
        this.btnApplyTemplate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.btnApplyTemplate.AccessibleContext.accessibleDescription"));
        this.btnTemplateFavourite.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/favoriten24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTemplateFavourite, (String)NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.btnTemplateFavourite.text"));
        this.btnTemplateFavourite.setToolTipText(NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.btnTemplateFavourite.toolTipText"));
        this.btnTemplateFavourite.setBorder(new SoftBevelBorder(0));
        this.btnTemplateFavourite.setMinimumSize(new Dimension(35, 35));
        this.btnTemplateFavourite.setPreferredSize(new Dimension(35, 35));
        this.btnTemplateFavourite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplateTopComponent.this.btnTemplateFavouriteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel2.add((Component)this.btnTemplateFavourite, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(TemplateTopComponent.class, (String)"TemplateTopComponent.jLabel15.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jLabel15, gridBagConstraints);
        this.panelLocationTemplate.add((Component)this.jPanel2, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.panelLocationTemplate, gridBagConstraints);
    }

    private void fldTemplateQuicksearchActionPerformed(ActionEvent evt) {
        this.updateTemplateQuicksearch();
    }

    private void btnQuicksearchClearActionPerformed(ActionEvent evt) {
        this.fldTemplateQuicksearch.setText("");
        this.updateTemplateQuicksearch();
    }

    private void fldTemplateLocationgroupItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.updateTemplatesByGroup();
        }
    }

    private void lstTemplateLocationValueChanged(ListSelectionEvent evt) {
        CmsBasicElement eleLoc = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
        if (eleLoc != null && this.templateFavourites.contains(eleLoc.getId())) {
            this.btnTemplateFavourite.setSelected(true);
            this.btnTemplateFavourite.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/favoriten_selected24.gif")));
        } else {
            this.btnTemplateFavourite.setSelected(false);
            this.btnTemplateFavourite.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/favoriten24.gif")));
        }
        this.updateButtonVisibility();
        Image dragImage = new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/no-icon96.gif")).getImage();
        if (this.useIcons && eleLoc != null) {
            String fn = eleLoc.getAttribute("file");
            if (fn != null && !"".equals(fn)) {
                try {
                    File f = this.project.getUploadFile("icon", fn);
                    if (f.isFile()) {
                        dragImage = new ImageIcon(f.getAbsolutePath()).getImage();
                    }
                }
                catch (Exception e) {
                    dragImage = new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/dragimage.gif")).getImage();
                }
            } else {
                dragImage = new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/dragimage.gif")).getImage();
            }
        }
        this.transferHandler.setDragImage(dragImage);
    }

    private void btnApplyTemplateToPlanActionPerformed(ActionEvent evt) {
        this.applyLocationTemplate(true);
    }

    private void btnApplyTemplateActionPerformed(ActionEvent evt) {
        this.applyLocationTemplate(false);
    }

    private void btnTemplateFavouriteActionPerformed(ActionEvent evt) {
        this.toggleTemplateFavourite();
    }

    private void lstTemplateLocationMouseClicked(MouseEvent evt) {
    }

    private void fldTemplateQuicksearchKeyReleased(KeyEvent evt) {
        this.updateTemplateQuicksearch();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

