/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.themis.application.observation.ThemisTableModel;
import at.grid.themis.ontology.DisplayAttributes;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColor;
import at.grid.themis.ontology.ThemisColors;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

class ThemisTableCellRenderer
extends DefaultTableCellRenderer {
    ThemisColor colorSelect = new ThemisColor();
    ThemisColor colorChecked = new ThemisColor();
    boolean useDueDate = ThemisApplication.getInstance().getSettings().getObservationAttribute("duedate").isUsed();

    ThemisTableCellRenderer() {
    }

    public void updateColors() {
        this.colorSelect = ThemisApplication.getInstance().getSettings().getObservationColorSelect();
        this.colorChecked = ThemisApplication.getInstance().getSettings().getObservationColorChecked();
        this.useDueDate = ThemisApplication.getInstance().getSettings().getObservationAttribute("duedate").isUsed();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ThemisTableModel tableModel = (ThemisTableModel)table.getModel();
        if (c instanceof JLabel) {
            ((JLabel)c).setBorder(new CompoundBorder(new EmptyBorder(new Insets(3, 2, 3, 2)), ((JLabel)c).getBorder()));
        }
        c.setBackground(Color.WHITE);
        c.setForeground(Color.BLACK);
        boolean isControlled = tableModel.isControlled(row);
        boolean isSel = tableModel.isSelected(row);
        boolean isDone = tableModel.isDone(row);
        boolean isDue = false;
        boolean isOverdue = false;
        if (this.useDueDate) {
            Date duedate = tableModel.getDueDate(row);
            Date refDateDue = ThemisApplication.getInstance().getAppointmentInfoDate();
            CmsEvent ev = ThemisApplication.getInstance().getProject().getCurrentEvent();
            Date refdateOverdue = ev == null ? new Date() : ev.getDateAttribute("date").getDate();
            boolean bl = isDue = duedate == null ? true : duedate.before(refDateDue);
            isOverdue = duedate == null ? false : !duedate.after(refdateOverdue);
        }
        int type = tableModel.getObservationType(row);
        DisplayAttributes disp = ThemisColors.getObservationColor((int)type, (boolean)isControlled, (boolean)isDone, (boolean)isDue, (boolean)isOverdue);
        if (isSel && column > 1) {
            this.setBackground(this.colorSelect.getBackground());
            this.setForeground(this.colorSelect.getForeground());
        } else if (isControlled) {
            this.setBackground(this.colorChecked.getBackground());
            this.setForeground(this.colorChecked.getForeground());
        } else {
            this.setBackground(disp.color);
            this.setForeground(disp.textColor);
        }
        if (value instanceof Date) {
            this.setText(Util.formatDate((Date)((Date)value), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()));
            this.setHorizontalAlignment(0);
        } else if ("done".equals(tableModel.columns.get((int)column).sqlselect) || "control".equals(tableModel.columns.get((int)column).sqlselect) || "priority".equals(tableModel.columns.get((int)column).sqlselect) || "sound".equals(tableModel.columns.get((int)column).sqlselect) || "hasimage".equals(tableModel.columns.get((int)column).sqlselect) || "hasaudio".equals(tableModel.columns.get((int)column).sqlselect)) {
            this.setHorizontalAlignment(0);
        } else {
            this.setHorizontalAlignment(10);
        }
        return c;
    }
}

