/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.themis.application.observation.ThemisTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ThemisTableColumnHeaderListener
extends MouseAdapter {
    JTable table = null;
    TableColumnModel colModel;
    ThemisTableModel m;
    int from = 0;
    int to = 0;
    boolean dragged = false;

    public ThemisTableColumnHeaderListener(JTable t) {
        this.table = t;
        this.colModel = this.table.getColumnModel();
        this.m = (ThemisTableModel)this.table.getModel();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        int colidx = this.table.columnAtPoint(evt.getPoint());
        if (colidx < 0) {
            return;
        }
        if (colidx == 0) {
            ThemisTableModel tm = (ThemisTableModel)this.table.getModel();
            tm.invertSelection();
            this.table.setModel(tm);
            this.table.repaint();
        } else {
            ThemisTableModel tm = (ThemisTableModel)this.table.getModel();
            ThemisTableModel.TableColumn col = tm.columns.get(colidx);
            tm.dataProvider.setTableSort(col.sqlselect);
            tm.dataProvider.updateTableModel();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.from = this.table.columnAtPoint(e.getPoint());
        this.dragged = false;
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.dragged = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.dragged = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.to = this.table.columnAtPoint(e.getPoint());
        ThemisTableModel tm = (ThemisTableModel)this.table.getModel();
        for (int ii = 1; ii < tm.columns.size(); ++ii) {
            TableColumn column = this.table.getColumnModel().getColumn(ii);
            int idx = column.getModelIndex();
            int width = column.getWidth();
            ThemisTableModel.TableColumn col = ((ThemisTableModel)this.table.getModel()).columns.get(ii);
            int width0 = col.width;
            if (width == width0) continue;
            col.width = width;
            tm.dataProvider.changeColumnWidth(col.sqlselect, col);
        }
    }
}

