/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.themis.application.observation.ThemisTableModel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisColor;
import at.grid.themis.ontology.ThemisColors;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class ThemisTableLocationCellRenderer
extends DefaultTableCellRenderer {
    ThemisColor colorSelect = new ThemisColor();
    ThemisColor colorChecked = new ThemisColor();

    ThemisTableLocationCellRenderer() {
    }

    public void updateColors() {
        this.colorSelect = ThemisApplication.getInstance().getSettings().getObservationColorSelect();
        this.colorChecked = ThemisApplication.getInstance().getSettings().getObservationColorChecked();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ThemisTableModel tableModel = (ThemisTableModel)table.getModel();
        c.setBackground(Color.WHITE);
        c.setForeground(Color.BLACK);
        boolean isSel = tableModel.isSelected(row);
        if (isSel && column <= 1) {
            this.setBackground(this.colorSelect.getBackground());
            this.setForeground(this.colorSelect.getForeground());
        } else {
            switch (tableModel.getColorLevel(row)) {
                case 1: {
                    this.setBackground(ThemisColors.COLOR_DUE);
                    this.setForeground(ThemisColors.black);
                    break;
                }
                case 2: {
                    this.setBackground(ThemisColors.COLOR_OVERDUE);
                    this.setForeground(ThemisColors.white);
                    break;
                }
                default: {
                    this.setBackground(ThemisColors.white);
                    this.setForeground(ThemisColors.black);
                }
            }
        }
        return c;
    }
}

