/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.observation.ThemisTableModelDataProvider;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class ThemisTableModel
extends AbstractTableModel {
    ArrayList<DataRecord> rows = new ArrayList();
    ArrayList<Long> observationids = new ArrayList();
    ArrayList<Boolean> selected = new ArrayList();
    ArrayList<TableColumn> columns = new ArrayList();
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    int lastRowSelection = -1;
    JTable table;
    ThemisTableModelDataProvider dataProvider;

    public ThemisTableModel(JTable table, ThemisTableModelDataProvider provider) {
        this.table = table;
        this.dataProvider = provider;
    }

    public void initialise() {
        this.columns.clear();
        this.rows.clear();
        this.observationids.clear();
        this.selected.clear();
        if (this.dataProvider != null) {
            this.dataProvider.initialiseTableColumns(this);
        }
    }

    public void setDataProvider(ThemisTableModelDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void clear() {
        this.rows.clear();
        this.observationids.clear();
        this.selected.clear();
    }

    public TableColumn addTableColumn(ThemisAttribute ta, int idx) {
        TableColumn col = new TableColumn(ta, idx);
        this.columns.add(col);
        TableColumnModel columnModel = this.table.getColumnModel();
        javax.swing.table.TableColumn tblcol = new javax.swing.table.TableColumn(idx);
        tblcol.setIdentifier(col.ta.getId());
        columnModel.addColumn(tblcol);
        return col;
    }

    public TableColumn addTableColumn(String t, int w) {
        TableColumn col = new TableColumn(t, w);
        this.columns.add(col);
        TableColumnModel columnModel = this.table.getColumnModel();
        javax.swing.table.TableColumn tblcol = new javax.swing.table.TableColumn(this.columns.indexOf(col));
        tblcol.setIdentifier(t);
        columnModel.addColumn(tblcol);
        return col;
    }

    public void addCheckColumn(int idx) {
        TableColumn col = new TableColumn("", "chk", 20, "boolean", idx);
        this.columns.add(col);
    }

    public ThemisAttribute getThemisAttribute(int idx) {
        if (idx < 0 || idx >= this.columns.size()) {
            return null;
        }
        return this.columns.get((int)idx).ta;
    }

    public void setTableColumnWidth(JTable t) {
        if (this.columns.isEmpty()) {
            return;
        }
        t.setAutoResizeMode(3);
        TableColumnModel columnModel = t.getColumnModel();
        for (int ii = 0; ii < this.columns.size(); ++ii) {
            columnModel.getColumn(ii).setWidth(this.columns.get((int)ii).width);
            columnModel.getColumn(ii).setPreferredWidth(this.columns.get((int)ii).width);
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.columns.get((int)col).header;
    }

    public Class getColumnClass(int columnIndex) {
        String f = this.columns.get((int)columnIndex).format;
        String code = this.columns.get((int)columnIndex).sqlselect;
        if ("done".equals(code) || "control".equals(code)) {
            return String.class;
        }
        if ("iconfile".equals(code)) {
            return Icon.class;
        }
        if ("boolean".equals(f)) {
            return Boolean.class;
        }
        if ("date".equals(f)) {
            return Date.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public void setSelectedObservationIds(ArrayList<Long> ids) {
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            this.selected.set(ii, ids.contains(this.observationids.get(ii)));
        }
    }

    public void setSelectedLocationIds(ArrayList<Long> ids) {
        for (int ii = 0; ii < this.rows.size(); ++ii) {
            this.selected.set(ii, ids.contains(this.rows.get(ii).getLong("meta_id")));
        }
    }

    public void invertSelection() {
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            this.selected.set(ii, this.selected.get(ii) == false);
        }
        this.dataProvider.selectionChanged();
    }

    public void selectAllOrNone() {
        if (this.selected.size() == 0) {
            return;
        }
        int count = 0;
        for (Boolean b : this.selected) {
            if (b == null || !b.booleanValue()) continue;
            ++count;
        }
        boolean newSetting = count < this.selected.size();
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            this.selected.set(ii, newSetting);
        }
        this.dataProvider.selectionChanged();
    }

    public void setSelectedRow(int row) {
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            this.selected.set(ii, ii == row);
        }
        this.project.getSelectionManager().setSelectedObservations(this.getSelectedObservationIds(), true, (Object)this.dataProvider);
        this.lastRowSelection = row;
    }

    public void setSelectedRowInterval(int row1, int row2) {
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            this.selected.set(ii, ii >= row1 && ii <= row2);
        }
        this.project.getSelectionManager().setSelectedObservations(this.getSelectedObservationIds(), true, (Object)this);
        this.lastRowSelection = row2;
    }

    public void setSelectedRowIntervalTo(int row) {
        int row0 = this.lastRowSelection;
        if (row0 >= 0) {
            int row1 = row > row0 ? row0 : row;
            int row2 = row < row0 ? row0 : row;
            this.setSelectedRowInterval(row1, row2);
        } else {
            this.setSelectedRow(row);
        }
        this.project.getSelectionManager().setSelectedObservations(this.getSelectedObservationIds(), true, (Object)this);
    }

    public void setSelectedRows(int[] sel) {
        for (int i : sel) {
            this.selected.set(i, true);
        }
        this.project.getSelectionManager().setSelectedObservations(this.getSelectedObservationIds(), true, (Object)this);
    }

    public void addSelectedRowWithoutProjectUpdate(int row) {
        this.selected.set(row, true);
    }

    public boolean isSelected(int row) {
        if (row >= 0 && row < this.selected.size()) {
            return this.selected.get(row);
        }
        return false;
    }

    public ArrayList<Integer> getSelectedIndices() {
        ArrayList<Integer> sel = new ArrayList<Integer>();
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            if (!this.selected.get(ii).booleanValue()) continue;
            sel.add(ii);
        }
        return sel;
    }

    public ArrayList<Long> getSelectedLocationIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            if (!this.selected.get(ii).booleanValue()) continue;
            ids.add(this.rows.get(ii).getLong("meta_id"));
        }
        return ids;
    }

    public ArrayList<Long> getSelectedObservationIds() {
        ArrayList<Long> sel = new ArrayList<Long>();
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            if (!this.selected.get(ii).booleanValue()) continue;
            sel.add(this.observationids.get(ii));
        }
        return sel;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int obstype;
        if (columnIndex == 0) {
            return this.selected.get(rowIndex);
        }
        String s = this.columns.get((int)columnIndex).sqlselect;
        String v = this.rows.get(rowIndex).getString(this.columns.get((int)columnIndex).sqlselect);
        String f = this.columns.get((int)columnIndex).format;
        int n = obstype = this.rows.get(rowIndex).isEmpty("idtype") ? 1 : this.rows.get(rowIndex).getInt("idtype");
        if ("duedate".equals(this.columns.get((int)columnIndex).sqlselect)) {
            switch (obstype) {
                case 3: {
                    return "";
                }
            }
            return this.rows.get(rowIndex).getDate(this.columns.get((int)columnIndex).sqlselect, this.project.getTimeZone());
        }
        if ("date".equals(this.columns.get((int)columnIndex).format)) {
            return this.rows.get(rowIndex).getDate(this.columns.get((int)columnIndex).sqlselect, this.project.getTimeZone());
        }
        if ("done".equals(this.columns.get((int)columnIndex).sqlselect)) {
            switch (obstype) {
                case 3: {
                    return "";
                }
                case 2: {
                    return this.isControlled(rowIndex) ? " OK " : "";
                }
            }
            return this.rows.get(rowIndex).getBoolean(this.columns.get((int)columnIndex).sqlselect) != false ? " OK " : "";
        }
        if ("control".equals(this.columns.get((int)columnIndex).sqlselect)) {
            return this.isControlled(rowIndex) ? " OK " : "";
        }
        if ("hasimage".equals(this.columns.get((int)columnIndex).sqlselect)) {
            return this.rows.get(rowIndex).getBoolean(this.columns.get((int)columnIndex).sqlselect) != false ? " X " : "";
        }
        if ("hasaudio".equals(this.columns.get((int)columnIndex).sqlselect)) {
            return this.rows.get(rowIndex).getBoolean(this.columns.get((int)columnIndex).sqlselect) != false ? " X " : "";
        }
        if ("boolean".equals(this.columns.get((int)columnIndex).format)) {
            return this.rows.get(rowIndex).getBoolean(this.columns.get((int)columnIndex).sqlselect);
        }
        if ("plan".equals(this.columns.get((int)columnIndex).sqlselect) && this.rows.get(rowIndex).getString(this.columns.get((int)columnIndex).sqlselect).equals("")) {
            return ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationListTopComponent.noMap.text");
        }
        DataRecord row = this.rows.get(rowIndex);
        TableColumn col = this.columns.get(columnIndex);
        return row.get(col.sqlselect);
    }

    public boolean isControlled(int row) {
        String cont = this.rows.get(row).getString("control");
        return "OK".equals(cont);
    }

    public boolean isDone(int row) {
        return this.rows.get(row).getBoolean("done");
    }

    public int getColorLevel(int row) {
        return this.rows.get(row).getInt("colorlevel", Integer.valueOf(0));
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col > 0) {
            return;
        }
        long id = this.getObservationId(row);
        this.selected.set(row, (Boolean)value);
        this.table.getSelectionModel().setSelectionInterval(row, row);
        ListSelectionModel selmodel = this.table.getSelectionModel();
        selmodel.clearSelection();
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            if (!this.selected.get(ii).booleanValue()) continue;
            selmodel.addSelectionInterval(ii, ii);
        }
        if (((Boolean)value).booleanValue()) {
            this.dataProvider.selectionChanged(id);
        } else {
            this.dataProvider.selectionChanged();
        }
    }

    public void addRow(DataRecord item, boolean sel) {
        this.rows.add(item);
        this.observationids.add(item.getLong("observationid"));
        this.selected.add(sel);
    }

    public int getObservationType(int row) {
        if (row < 0 || row >= this.rows.size()) {
            return 1;
        }
        return this.rows.get(row).isEmpty("idtype") ? 1 : this.rows.get(row).getInt("idtype");
    }

    public Date getDueDate(int row) {
        if (row < 0 || row >= this.rows.size()) {
            return null;
        }
        return this.rows.get(row).isEmpty("duedate") ? null : this.rows.get(row).getDate("duedate", this.app.getTimeZone());
    }

    public int getStatusColumn() {
        for (int ii = 0; ii < this.columns.size(); ++ii) {
            if (!this.columns.get((int)ii).sqlselect.equals("done")) continue;
            return ii;
        }
        return -1;
    }

    public long getElementId(int row) {
        if (row >= 0 && row < this.rows.size()) {
            return this.rows.get(row).getLong("meta_id");
        }
        return -1L;
    }

    public long getObservationId(int row) {
        if (row >= 0 && row < this.rows.size()) {
            Long id = this.rows.get(row).getLong("observationid");
            return id == null ? -1L : id;
        }
        return -1L;
    }

    public CmsElementSummary getElementSummary(int row) {
        if (row >= 0 && row < this.rows.size()) {
            return new CmsElementSummary((CmsApplication)this.project, this.rows.get(row), this.project.getUser());
        }
        return null;
    }

    void clearSelection() {
        for (int ii = 0; ii < this.selected.size(); ++ii) {
            if (!this.selected.get(ii).booleanValue()) continue;
            this.selected.set(ii, false);
        }
    }

    class TableColumn {
        public ThemisAttribute ta;
        public String header;
        public String sqlselect;
        public int width;
        public String format;
        public int index;

        public TableColumn(ThemisAttribute ta, int index) {
            this.ta = ta;
            this.header = ta.getLabel();
            this.sqlselect = ta.getSqlCode();
            this.width = ta.getWidthInTable();
            this.format = ta.getTypeCode();
            this.index = index;
        }

        public TableColumn(String header, String code, int width, String format, int index) {
            this.header = header;
            this.sqlselect = code;
            this.width = width;
            this.format = format;
            this.index = index;
        }

        public TableColumn(String header, int width) {
            this.header = header;
            this.width = width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getWidth() {
            return this.width;
        }

        public String toString() {
            return this.header + "##" + this.sqlselect + "##" + this.width + "##" + this.format;
        }

        public String toString2() {
            return this.sqlselect + ":" + this.width + ":" + this.format;
        }
    }
}

