/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation.action;

import at.grid.themis.application.action.ribbon.ToggleRibbonAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;

public final class AddToPlanningAction
extends ToggleRibbonAction
implements ActionListener {
    public AddToPlanningAction() {
        super(ResourceBundle.getBundle("at/grid/themis/application/observation/action/Bundle"), "CTL_AddToPlanningAction", "at/grid/themis/application/media/addToPlan.gif", "MEDIUM");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)ThemisApplication.getInstance()) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)ThemisApplication.getInstance())) {
            return;
        }
        if (!project.isOpen()) {
            Dialogs.getInstance().showWarningDialog(app.getProject().getResourceText("app.core.text.noproject", app.getLocale()));
            return;
        }
        ArrayList ids = project.getSelectionManager().getSelectedObservationIds();
        CmsEvent ev = project.getSelectionManager().getCurrentEvent();
        if (ids.isEmpty()) {
            Dialogs.getInstance().showWarningDialog("warning.noObservationsSelected");
            return;
        }
        if (ev == null) {
            Dialogs.getInstance().showWarningDialog("warning.noCurrentEvent");
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean add = false;
        add = Dialogs.getInstance().showConfirmDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationListTopComponent.addToPlanningPlural.text"), ids.size(), ev.getTitle()), ResourceBundle.getBundle("at/grid/themis/application/observation/Bundle").getString("ObservationListTopComponent.addToPlanningShort.text"));
        if (add) {
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (ev.getRelationAttribute("plannedobservations").contains(id)) continue;
                ev.getRelationAttribute("plannedobservations").add(id);
                sb.append(id + " ");
            }
            ev.save();
            project.createActionLog("event_plan", ev.getId(), sb.toString());
        }
    }
}

