/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation.action;

import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ribbon.ToggleRibbonAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;

public final class DeleteObservationAction
extends ToggleRibbonAction
implements ActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();

    public DeleteObservationAction() {
        super(ResourceBundle.getBundle("at/grid/themis/application/observation/action/Bundle"), "CTL_DeleteObservationAction", "at/grid/themis/application/media/action_remove.gif", "MEDIUM");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)ThemisApplication.getInstance()) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)ThemisApplication.getInstance())) {
            return;
        }
        if (this.project.getSelectionManager().hasSelectedObservationIds()) {
            ArrayList eventsLocked = this.project.getEventsSigned();
            ArrayList<Long> lockedIds = new ArrayList<Long>();
            for (CmsElementSummary ele : eventsLocked) {
                lockedIds.add(ele.getId());
            }
            ArrayList sel = this.project.getSelectionManager().getSelectedObservationIds();
            StringBuilder sbDeleted = new StringBuilder();
            StringBuilder sbLocked = new StringBuilder();
            ArrayList<CmsObservation> deleteElements = new ArrayList<CmsObservation>();
            ArrayList<CmsObservation> lockedElements = new ArrayList<CmsObservation>();
            for (Long l : sel) {
                boolean lockedEvent = false;
                CmsObservation ele = (CmsObservation)this.project.loadElement(l.longValue(), this.project.getUser());
                ArrayList eventIds = ele.getEventIds();
                Iterator iterator = eventIds.iterator();
                while (iterator.hasNext()) {
                    long eventid = (Long)iterator.next();
                    if (!lockedIds.contains(eventid)) continue;
                    lockedEvent = true;
                    break;
                }
                if (lockedEvent) {
                    lockedElements.add(ele);
                    continue;
                }
                deleteElements.add(ele);
            }
            for (CmsElement cmsElement : deleteElements) {
                sbDeleted.append("\n  - ").append(cmsElement.getTitle());
            }
            if (!lockedElements.isEmpty()) {
                for (CmsElement cmsElement : lockedElements) {
                    sbLocked.append("\n  - ").append(cmsElement.getTitle());
                }
            }
            boolean remove = false;
            boolean bl = deleteElements.size() > 1;
            boolean mz2 = lockedElements.size() > 1;
            StringBuilder message = new StringBuilder();
            if (deleteElements.size() > 0) {
                if (deleteElements.size() < 6) {
                    message.append(MessageFormat.format(this.bundle.getString("DeleteObservationAction.deleteObservation" + (bl ? "MZ" : "")), sbDeleted.toString()));
                } else {
                    message.append(MessageFormat.format(this.bundle.getString("DeleteObservationAction.deleteObservationMany"), deleteElements.size()));
                }
            }
            if (lockedElements.size() > 0) {
                if (deleteElements.size() > 0) {
                    message.append("\n\n");
                }
                if (lockedElements.size() < 6) {
                    message.append(MessageFormat.format(this.bundle.getString("DeleteObservationAction.lockedObservation" + (bl ? "MZ" : "")), sbLocked.toString())).append(sbLocked.toString());
                } else {
                    message.append(MessageFormat.format(this.bundle.getString("DeleteObservationAction.lockedObservationMany"), lockedElements.size()));
                }
            }
            if (deleteElements.size() > 0) {
                remove = Dialogs.getInstance().showConfirmDialog(message.toString(), "dialog.confirm-delete-observations.title");
            } else {
                Dialogs.getInstance().showWarningDialog(message.toString());
            }
            ArrayList<Long> deletedObservations = new ArrayList<Long>();
            if (remove) {
                for (CmsElement cmsElement : deleteElements) {
                    deletedObservations.add(cmsElement.getId());
                    cmsElement.moveToTrash();
                }
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.OBSERVATION_DELETED.setReference(deletedObservations));
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_DELETED.setReference(deletedObservations));
            }
        }
    }
}

