/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation.action;

import at.grid.cms.element.CmsElement;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ribbon.ToggleRibbonAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.planviewer.MultiLocationPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public final class EditLocationAction
extends ToggleRibbonAction {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();

    public EditLocationAction() {
        super(ResourceBundle.getBundle("at/grid/themis/application/observation/action/Bundle"), "CTL_EditLocationAction", "at/grid/themis/application/media/edit.gif", "MEDIUM");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)ThemisApplication.getInstance()) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)ThemisApplication.getInstance())) {
            return;
        }
        if (this.project.getSelectionManager().hasSelectedLocationIds()) {
            ArrayList sel = this.project.getSelectionManager().getSelectedLocationIds();
            if (sel.size() > 1) {
                MultiLocationPanel p = new MultiLocationPanel(sel);
                Object[] btnObsPanel = new String[]{ResourceBundle.getBundle("at/grid/themis/application/observation/action/Bundle").getString("EditLocationAction.close.text")};
                JOptionPane panel = new JOptionPane(p, -1, 0, null, btnObsPanel, btnObsPanel[0]);
                try {
                    JDialog dialog = panel.createDialog(null, ResourceBundle.getBundle("at/grid/themis/application/observation/action/Bundle").getString("EditLocationAction.editLocation.text"));
                    dialog.setResizable(true);
                    THEMIS.setDialogIcon(dialog);
                    dialog.setVisible(true);
                }
                catch (Exception exception) {}
            } else {
                long locid = (Long)sel.get(0);
                CmsLocation loc = (CmsLocation)this.project.loadElement(locid, this.project.getUser());
                if (loc != null) {
                    new LocationObservationDialog().editLocation((CmsElement)loc);
                }
            }
        } else {
            Dialogs.getInstance().showWarningDialog("location.no-location-selected");
        }
    }
}

