/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.observation.action;

import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.MultiObservationPanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ribbon.ToggleRibbonAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public final class EditObservationAction
extends ToggleRibbonAction
implements ActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();

    public EditObservationAction() {
        super(ResourceBundle.getBundle("at/grid/themis/application/observation/action/Bundle"), "CTL_EditObservationAction", "at/grid/themis/application/media/action_editObs.gif", "MEDIUM");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)ThemisApplication.getInstance()) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)ThemisApplication.getInstance())) {
            return;
        }
        if (this.project.getSelectionManager().hasSelectedObservationIds()) {
            if (THEMIS.checkAndCreateEvent()) {
                ArrayList sel = this.project.getSelectionManager().getSelectedObservationIds();
                if (sel.size() > 1) {
                    MultiObservationPanel p = new MultiObservationPanel(sel);
                    Object[] btnObsPanel = new String[]{ResourceBundle.getBundle("at/grid/themis/application/observation/action/Bundle").getString("EditLocationAction.close.text")};
                    JOptionPane panel = new JOptionPane(p, -1, 0, null, btnObsPanel, btnObsPanel[0]);
                    try {
                        JDialog dialog = panel.createDialog(null, ResourceBundle.getBundle("at/grid/themis/application/observation/action/Bundle").getString("EditObservationAction.editObservation.text"));
                        dialog.setResizable(true);
                        THEMIS.setDialogIcon(dialog);
                        dialog.setVisible(true);
                    }
                    catch (Exception dialog) {}
                } else {
                    CmsLocation loc;
                    long obsid = (Long)sel.get(0);
                    CmsObservation obs = (CmsObservation)this.project.loadElement(obsid, this.project.getUser());
                    CmsElementSummary ele = obs.getRelationAttribute("location").getFirstElement();
                    if (ele == null) {
                        loc = (CmsLocation)this.app.getProject().createElement("location");
                        loc.getRelationAttribute("observations").add((CmsElement)obs);
                    } else {
                        loc = (CmsLocation)ele.getElement();
                    }
                    if (loc != null) {
                        new LocationObservationDialog().editObservation((CmsElement)loc, obs.getId());
                    }
                }
            }
        } else {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/observation/action/Bundle").getString("EditObservationAction.selectObservation.text"));
        }
    }
}

