/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.planviewer;

import at.grid.cms.element.CmsElement;
import at.grid.gui.BasicGeometry;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsLocationTemplate;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.settings.ThemisSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LocationCreationActionListener
implements ActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisSettings settings = this.app.getSettings();
    ThemisProject project = this.app.getProject();
    ThemisFilter filter = this.app.getFilter();
    SimpleGeometry geo;
    CmsPlan plan;
    long id = -1L;
    boolean copy = false;
    boolean editGeometry = false;
    boolean addMapRef = false;
    boolean createFoto = false;

    public LocationCreationActionListener(long id, SimpleGeometry geo, CmsPlan plan, boolean copyLocation, boolean editLocGeometry, boolean addMapRef, boolean createFoto) {
        this.geo = new SimpleGeometry(geo, false);
        this.plan = plan;
        this.id = id;
        this.copy = copyLocation;
        this.editGeometry = editLocGeometry;
        this.addMapRef = addMapRef;
        this.createFoto = createFoto;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CmsLocation location = null;
        LocationObservationDialog locationObservationDialog = new LocationObservationDialog();
        if (this.id < 0L) {
            location = (CmsLocation)this.project.createElement("location");
            location.setAttributeValue("position", this.geo.toWKT());
            if (this.plan != null) {
                location.getRelationAttribute("plan").set((CmsElement)this.plan);
            }
            if (this.createFoto) {
                location.setAttributeValue("title", this.project.getResourceText("location.foto-doku-title"));
                boolean addFotoToObs = this.settings.getImageForObservation();
                if (addFotoToObs) {
                    CmsObservation obs = (CmsObservation)this.project.createElement("observation");
                    obs.setLocation(location);
                    obs.setNumber(location.getNextObservationNumber());
                    obs.setAttributeValue("title", this.project.getResourceText("observation.foto-doku-title"));
                    obs.setAttributeValue("description", this.project.getResourceText("observation.foto-doku-title"));
                    obs.getKeyAttribute("type").setValue(3L);
                    location.updateMD5();
                    locationObservationDialog.editObservation((CmsElement)location, obs);
                } else {
                    location.updateMD5();
                    locationObservationDialog.editLocation((CmsElement)location);
                }
            } else {
                location.updateMD5();
                locationObservationDialog.editLocation((CmsElement)location);
            }
        } else if (this.copy) {
            location = CmsLocation.duplicate((long)this.id, (CmsPlan)this.plan, (BasicGeometry)this.geo);
            locationObservationDialog.editLocation((CmsElement)location);
        } else if (this.editGeometry) {
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.ACTION_GEOMETRY_EDIT_DONE);
            location = (CmsLocation)this.project.loadElement(this.id, this.project.getUser());
            location.setAttributeValue("position", this.geo.toWKT());
            if (this.plan != null) {
                location.getRelationAttribute("plan").set((CmsElement)this.plan);
            }
            location.save();
            this.app.getFilter().resetSearchResult();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype("location").setId(location.getId()));
            this.project.clearEditLocGeometryId();
        } else if (this.addMapRef) {
            location = (CmsLocation)this.project.loadElement(this.id, this.project.getUser());
            location.setAttributeValue("position", this.geo.toWKT());
            if (this.plan != null) {
                location.getRelationAttribute("plan").set((CmsElement)this.plan);
            }
            location.save();
            this.app.getFilter().resetSearchResult();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype("location").setId(location.getId()));
            this.project.clearAddMapRefToLocId();
        } else {
            CmsLocationTemplate template = (CmsLocationTemplate)this.project.loadElement(this.id, this.project.getUser());
            location = (CmsLocation)this.project.createElement("location");
            template.applyTo(location);
            location.setAttributeValue("position", this.geo.toWKT());
            if (this.plan != null) {
                location.getRelationAttribute("plan").set((CmsElement)this.plan);
            }
            this.project.setProjectProperty("lastlocationtemplateid", template.getId() + "");
            this.project.updateRecentLocTemplatesList(Long.valueOf(template.getId()), false);
            if (this.app.getSettings().getDoCreateNewObservationWithLocation()) {
                CmsObservation obs = this.project.createObservation(location);
                new LocationObservationDialog().editObservation((CmsElement)location, obs);
            } else {
                new LocationObservationDialog().editLocation((CmsElement)location);
            }
        }
        if (location != null && location.isSaved()) {
            this.project.updateCurrentEvent();
        }
    }
}

