/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.planviewer;

import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.data.Coordinates2D;
import at.grid.data.grid.GridGeometry;
import at.grid.gui.ImagePanel;
import at.grid.gui.Point;
import at.grid.gui.SimpleGeometry;
import at.grid.gui.event.Action;
import at.grid.gui.event.ActionProvider;
import at.grid.ontology.swing.CmsImagePanel;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ThemisActions;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.project.ImportThemisFilePanel;
import at.grid.themis.application.simpleeditor.plan.LocationCreationActionListener;
import at.grid.themis.application.simpleeditor.plan.PlanActionListenerCreateOnPlan;
import at.grid.themis.application.simpleeditor.plan.PlanActionListenerCreatePhotoDoc;
import at.grid.themis.application.simpleeditor.plan.PlanActionListenerSetPlanReference;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsIcon;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsLocationTemplate;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.PlanCreator1;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class PlanPanel
extends JPanel
implements ThemisActionListener,
at.grid.gui.event.ActionListener {
    CmsPlan plan;
    ArrayList<Long> planIds = new ArrayList();
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/simpleeditor/Bundle");
    ThemisFilter filter = this.app.getFilter();
    ArrayList<Long> filteredlocationids = new ArrayList();
    private CmsImagePanel imagePanel;
    Border buttonDown = BorderFactory.createBevelBorder(1);
    Border buttonUp = BorderFactory.createBevelBorder(0);
    private Action MOVE_ACTION = new Action(100);
    private Action MOVE_LABEL_ACTION = new Action(101);
    private int SELECTION_ACTION_ID = 200;
    private Action SELECTION_ACTION = new Action(this.SELECTION_ACTION_ID);
    private Action RIGHTCLICK_ACTION = new Action(400);
    private Action PLACE_POINT_ACTION = new Action(500);
    private Action DROP_ACTION = new Action(600);
    private boolean externalCall = false;
    private boolean placeImmediately = false;
    private float transparency = 1.0f;
    private HashMap<String, Image> icons = new HashMap();
    private boolean useIcons = true;
    SimpleGeometry currentGeom = null;
    Color popupBackgroundColor = new Color(240, 240, 240);
    Color popupBackgroundGrey = new Color(200, 200, 200);
    Color popupBackgroundGreen = new Color(142, 240, 142);
    Color popupBackgroundYellow = new Color(242, 242, 142);
    private int pointSize = 20;
    boolean showCalibPoints = false;
    TopComponent tc = null;
    PlanPanel self = this;
    private JButton btnAccept;
    private JButton btnCancel;
    private JToggleButton btnDrawLine;
    private JToggleButton btnDrawPoint;
    private JToggleButton btnDrawPolygon;
    private JToggleButton btnEditGeometry;
    private JButton btnFullExt;
    private JButton btnNextPlan;
    private JButton btnPlanFilter;
    private JButton btnPlanList;
    private JButton btnPreviousPlan;
    private JButton btnZoomIn;
    private JButton btnZoomOut;
    private JPanel centerPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JLabel lblCoordinates;
    private JLabel lblEmpty1;
    private JLabel lblEmpty3;
    private JLabel lblInfo;
    private JPanel mainPanel;
    private JPanel panelCoord;
    private JPanel panelOverlay;
    private JPanel panelTopButtons;
    private JPanel panelZoomButtons;
    private JSlider sliderPlanTransparency;
    boolean fun;

    public PlanPanel(TopComponent tc) {
        this.initComponents();
        this.tc = tc;
        THEMIS.getLicense();
        this.imagePanel = new CmsImagePanel(ThemisApplication.getInstance().getProject().getLogger(), true);
        GridBagConstraints imagePanelConstraints = new GridBagConstraints();
        imagePanelConstraints.gridx = 0;
        imagePanelConstraints.gridy = 0;
        imagePanelConstraints.fill = 1;
        imagePanelConstraints.weightx = 1.0;
        imagePanelConstraints.weighty = 1.0;
        this.mainPanel.add((Component)((Object)this.imagePanel), imagePanelConstraints);
        this.imagePanel.setDrawImageBorder(true);
        this.imagePanel.setInfoLabel(this.lblInfo);
        this.imagePanel.setCoordinatesLabel(this.lblCoordinates);
        this.imagePanel.setBackgroundColor(Color.white);
        this.btnAccept.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnEditGeometry.setEnabled(false);
        this.sliderPlanTransparency.setEnabled(false);
        ActionProvider prov = new ActionProvider();
        prov.register((at.grid.gui.event.ActionListener)this);
        this.imagePanel.setActionProvider(prov);
        this.imagePanel.setMoveAction(this.MOVE_ACTION);
        this.imagePanel.setMoveLabelAction(this.MOVE_LABEL_ACTION);
        this.imagePanel.setSelectionAction(this.SELECTION_ACTION);
        this.imagePanel.setRightclickAction(this.RIGHTCLICK_ACTION);
        this.imagePanel.setDropAction(this.DROP_ACTION);
        this.imagePanel.setActionListener(this);
        this.imagePanel.setAllowMoveLabel(!"yes".equals(this.app.getConfiguration("display.avoid-moving-of-label", "no")));
        boolean allowDrag = !ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE);
        this.imagePanel.setDragable(allowDrag);
        this.imagePanel.setScaleIcons(true);
        this.imagePanel.setIconMinimumSize(15);
        this.imagePanel.setIconSize(ThemisApplication.getInstance().getSettings().getDisplayIconSize());
        this.pointSize = ThemisApplication.getInstance().getSettings().getDisplayPointSize();
        this.imagePanel.setSelectBuffer(this.app.getSettings().useLargePlanBuffer() ? 50 : 16);
        this.transparency = Float.parseFloat(this.app.getConfiguration("display.transparency", "1.0"));
        this.sliderPlanTransparency.setValue((int)(-100.0f * this.transparency));
        this.lblInfo.setText("");
        UIManager.put("PopupMenu.selectionBackground", Color.GREEN);
        UIManager.put("MenuItem.selectionBackground", Color.GREEN);
        this.reset();
        new DropTarget((Component)((Object)this.imagePanel), new ThemisDropTargetListener(false, false, new String[]{"themis"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                if (!ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
                    new ImportThemisFilePanel(f).showDialog();
                }
            }

            @Override
            public boolean dropAction(final Object transferData, DropTargetDropEvent event) {
                java.awt.Point e;
                if (transferData instanceof CmsBasicElement && (e = event.getLocation()) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PlanPanel.this.dropTemplateOnPlan(((CmsBasicElement)transferData).getId(), (int)e.getX(), (int)e.getY());
                        }
                    });
                    return true;
                }
                return false;
            }
        });
        this.btnPlanFilter.setVisible(false);
        ThemisActionProvider.getInstance().register(this);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + this.getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(Action action, Object o) {
        this.fun = false;
        if (action.equals((Object)this.MOVE_ACTION)) {
            boolean cancelMoveAction = false;
            for (Object g : this.imagePanel.getGeometries()) {
                if (!g.isSelected() || !this.checkLocation((SimpleGeometry)g)) continue;
                cancelMoveAction = true;
            }
            if (!cancelMoveAction && Dialogs.getInstance().showConfirmDialog(this.bundle.getString("PlanPanel.shiftLocation.text"))) {
                ArrayList<Long> selected = new ArrayList<Long>();
                for (SimpleGeometry g : this.imagePanel.getGeometries()) {
                    if (!g.isSelected()) continue;
                    selected.add(g.getId());
                    CmsElement loc = this.app.getProject().loadElement(g.getId(), this.app.getProject().getUser());
                    loc.setAttributeValue("position", THEMIS.transformGeometryToPlan(g, this.plan, this.imagePanel).toWKT());
                    loc.save();
                }
                this.loadGeometries();
                for (SimpleGeometry g : this.imagePanel.getGeometries()) {
                    if (!selected.contains(g.getId())) continue;
                    g.setSelected();
                }
            } else {
                this.loadGeometries();
            }
        } else if (action.equals((Object)this.MOVE_LABEL_ACTION)) {
            boolean cancelMoveAction = false;
            for (SimpleGeometry g : this.imagePanel.getGeometries()) {
                if (!g.isSelected() || !this.checkLocation(g)) continue;
                cancelMoveAction = true;
            }
            if (!cancelMoveAction) {
                ArrayList selected = new ArrayList();
                for (SimpleGeometry g : this.imagePanel.getGeometries()) {
                    if (!g.isSelected()) continue;
                    selected.add(g.getId());
                    CmsElement loc = this.app.getProject().loadElement(g.getId(), this.app.getProject().getUser());
                    SimpleGeometry labelpoint = new SimpleGeometry(1);
                    labelpoint.add(g.getLabelpoint());
                    loc.setAttributeValue("labelposition", THEMIS.transformGeometryToPlan(labelpoint, this.plan, this.imagePanel).toWKT());
                    loc.save();
                }
                this.loadGeometries();
                for (SimpleGeometry g : this.imagePanel.getGeometries()) {
                    if (!selected.contains(g.getId())) continue;
                    g.setSelected();
                }
            } else {
                this.loadGeometries();
            }
        } else if (action.equals((Object)this.RIGHTCLICK_ACTION)) {
            ThemisLogger.logger.fine("PlanPanel action=rightclick");
            SimpleGeometry clickgeo = (SimpleGeometry)o;
            this.currentGeom = this.transformIfNecessary(clickgeo);
            this.showActionPopup();
        } else if (action.equals((Object)this.SELECTION_ACTION)) {
            ThemisLogger.logger.fine("PlanPanel action=selection");
            ArrayList selids = (ArrayList)o;
            if (selids.isEmpty()) {
                this.project.getSelectionManager().clearSelection(true, (Object)this);
            } else if (selids.size() == 1) {
                this.showSelectionPopup((Long)selids.get(0), action.getX(), action.getY());
            } else {
                this.showMultiSelectionPopup(selids, action.getX(), action.getY());
            }
        } else if (action.equals((Object)this.PLACE_POINT_ACTION)) {
            if (this.placeImmediately) {
                this.btnAcceptActionPerformed(null);
            }
        } else if (action.equals((Object)this.DROP_ACTION)) {
            this.dropTemplateOnPlan((Long)o, action.getX(), action.getY());
        }
    }

    public void onAction(ThemisAction action) {
        if (action.getAction() > 4000 && action.getAction() < 4010) {
            return;
        }
        switch (action.getAction()) {
            case 302: 
            case 501: 
            case 651: 
            case 1110: 
            case 1112: {
                this.updateFilteredLocations();
                break;
            }
            case 650: {
                this.updateSelection();
                break;
            }
            case 1103: {
                this.imagePanel.setScaleIcons(true);
                this.imagePanel.setIconSize(ThemisApplication.getInstance().getSettings().getDisplayIconSize());
                this.pointSize = ThemisApplication.getInstance().getSettings().getDisplayPointSize();
                this.imagePanel.setAllowMoveLabel(!"yes".equals(this.app.getConfiguration("display.avoid-moving-of-label", "no")));
                this.updateIcons();
                this.updateFilteredLocations();
                break;
            }
            case 1102: {
                this.updateIcons();
                this.updateFilteredLocations();
                this.imagePanel.setSelectBuffer(this.app.getSettings().useLargePlanBuffer() ? 50 : 16);
                break;
            }
            case 104: {
                long locationid = action.getId();
                CmsElement location = this.app.getProject().loadElement(locationid, this.app.getProject().getUser());
                if (location.getRelationAttribute("plan").isEmpty()) break;
                long idplan = location.getRelationAttribute("plan").getFirstElementId();
                this.loadPlan(idplan, false);
                SimpleGeometry geom = SimpleGeometry.fromWKT((String)location.getAttributeValue("position"));
                if (this.plan.isCurrentPlanfileCalibrated()) {
                    this.imagePanel.zoomTo(geom.retransform(this.imagePanel.getImageHeight(), this.plan.getGeometry()));
                    break;
                }
                this.imagePanel.zoomTo(geom);
                break;
            }
            case 100: {
                this.loadPlan(action.getId(), true);
                this.imagePanel.reset();
                this.imagePanel.setBackgroundTransparency(this.transparency);
                this.imagePanel.repaint();
                break;
            }
            case 102: {
                if (action.getId() < 0L || this.equals(action.getSource())) break;
                this.loadPlan(action.getId(), false);
                break;
            }
            case 103: {
                if (this.plan == null) break;
                this.updatePlanIds(this.plan);
                this.updatePrevNextPlanButtons();
                break;
            }
            case 101: {
                if (this.plan == null || action.getId() != this.plan.getId()) break;
                this.updatePlanIds(this.plan);
                this.reset();
                this.disableBtnsPlanViewerTopComponent();
                break;
            }
            case 1101: {
                this.reset();
                this.disableBtnsPlanViewerTopComponent();
                break;
            }
            case 1100: {
                this.imagePanel.setScaleIcons(true);
                this.imagePanel.setIconSize(ThemisApplication.getInstance().getSettings().getDisplayIconSize());
                this.pointSize = ThemisApplication.getInstance().getSettings().getDisplayPointSize();
                String loadedPlan = this.project.getProjectProperty("project.plan.loaded", "noPlan");
                if (!"noPlan".equals(loadedPlan)) {
                    long idPlan = Long.parseLong(loadedPlan);
                    this.project.getSelectionManager().setCurrentPlan(idPlan, false, (Object)this);
                    this.loadPlan(idPlan, true);
                    break;
                }
                this.updateFilteredLocations(-1L);
                break;
            }
            case 1200: {
                if (this.plan == null) {
                    Dialogs.getInstance().showInfoDialog(this.bundle.getString("WARNING_LOAD_PLAN_FIRST"));
                    return;
                }
                this.placeImmediately = true;
                this.externalCall = true;
                this.imagePanel.setStatus(2);
                this.imagePanel.setGeometryAction(this.PLACE_POINT_ACTION);
                break;
            }
            case 3002: {
                this.actionStartDrawing(2);
                break;
            }
            case 3003: {
                this.actionStartDrawing(3);
                break;
            }
            case 3004: {
                this.actionStartDrawing(4);
                break;
            }
            case 1300: {
                boolean allowDrag = !ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE);
                this.imagePanel.setDragable(allowDrag);
                break;
            }
            case 3010: {
                if (this.plan == null) {
                    Dialogs.getInstance().showInfoDialog(this.bundle.getString("WARNING_LOAD_PLAN_FIRST"));
                    return;
                }
                this.externalCall = true;
                this.actionStartDrawing(2);
                break;
            }
            case 3012: {
                ArrayList points = (ArrayList)action.getReference();
                if (action.getFlag() != null) {
                    if (action.getFlag().booleanValue()) {
                        PlanCreator1.showCalibrationPoints((ImagePanel)this.imagePanel, null, (boolean)false);
                    }
                } else {
                    this.showCalibPoints = !this.showCalibPoints;
                }
                PlanCreator1.showCalibrationPoints((ImagePanel)this.imagePanel, (ArrayList)points, (boolean)this.showCalibPoints);
                break;
            }
            default: {
                if (!action.equals(this.SELECTION_ACTION)) break;
                this.updateSelection();
            }
        }
    }

    private void updatePlanIds(CmsPlan plan) {
        this.planIds.clear();
        ArrayList plansForBuilding = this.project.getPlansForBuilding(plan.getBuildingId());
        for (CmsElementSummary p : plansForBuilding) {
            if (p.isTrash()) continue;
            this.planIds.add(p.getId());
        }
    }

    private void updatePrevNextPlanButtons() {
        if (this.plan != null && this.planIds != null) {
            int idx = this.planIds.indexOf(this.plan.getId());
            this.btnPreviousPlan.setEnabled(idx > 0);
            this.btnNextPlan.setEnabled(idx < this.planIds.size() - 1);
        } else {
            this.btnPreviousPlan.setEnabled(false);
            this.btnNextPlan.setEnabled(false);
        }
    }

    private void dropTemplateOnPlan(long templateId, int x, int y) {
        SimpleGeometry clickgeo = new SimpleGeometry(1);
        clickgeo.add(this.imagePanel.screen2Image(x, y));
        clickgeo = this.transformIfNecessary(clickgeo);
        CmsLocation location = (CmsLocation)this.project.createElement("location");
        CmsLocationTemplate template = (CmsLocationTemplate)this.project.loadElement(templateId, this.project.getUser());
        template.applyTo(location);
        location.getLongAttribute("templateid").setValue(template.getId());
        location.setAttributeValue("position", clickgeo.toWKT());
        location.getRelationAttribute("plan").set((CmsElement)this.plan);
        this.project.setProjectProperty("lastlocationtemplateid", template.getId() + "");
        this.project.updateRecentLocTemplatesList(Long.valueOf(template.getId()), false);
        if (this.app.getSettings().getDoCreateNewObservationWithLocation()) {
            CmsObservation obs = this.project.createObservation(location);
            new LocationObservationDialog().editObservation((CmsElement)location, obs);
        } else {
            new LocationObservationDialog().editLocation((CmsElement)location);
        }
        if (location != null && location.isSaved()) {
            this.project.getSelectionManager().updateCurrentEvent();
            this.project.getSelectionManager().setSelectedLocation(location.getId(), true, (Object)this);
        }
    }

    private boolean checkLocation(SimpleGeometry geom) {
        Coordinates2D corner = geom.getBox().getLowerRight();
        Coordinates2D corner2 = geom.getBox().getUpperLeft();
        int w = this.imagePanel.getImageWidth();
        int h = this.imagePanel.getImageHeight();
        Point labelpoint = geom.getLabelpoint();
        if (corner.x < 0.0 || corner.y < 0.0) {
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("WARNING_OUTSIDE_PLAN"));
            return true;
        }
        if (corner2.x > (double)w || corner2.y > (double)h) {
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("WARNING_OUTSIDE_PLAN"));
            return true;
        }
        if (geom.getType() == 1 && geom.size() < 1) {
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("WARNING_NO_POINT"));
            return true;
        }
        if (geom.getType() == 2 && geom.size() < 2) {
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("WARNING_LINE_TWO_POINTS"));
            return true;
        }
        if ((geom.getType() == 3 || geom.getType() == 8) && geom.size() < 3) {
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("WARNING_POLY_THREE_POINTS"));
            return true;
        }
        if (labelpoint == null || labelpoint.getX() < 0.0 || labelpoint.getY() < 0.0 || labelpoint.getX() > (double)w || labelpoint.getY() > (double)h) {
            // empty if block
        }
        return false;
    }

    private void showMultiSelectionPopup(ArrayList<Long> selids, final int x, final int y) {
        JPopupMenu menu = new JPopupMenu(this.bundle.getString("PlanPanel.selection.text"));
        menu.setFont(THEMIS.fontLabelBig);
        for (long id : selids) {
            String lbl = this.project.getDatastorage().getLocationNumberTitle(id);
            JMenuItem item = this.createMenuItem(lbl, this.popupBackgroundColor, false);
            final long selid = id;
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlanPanel.this.project.getSelectionManager().setSelectedLocation(selid, true, (Object)PlanPanel.this.self);
                    PlanPanel.this.imagePanel.setSelection(selid);
                    PlanPanel.this.showSelectionPopup(selid, x, y);
                }
            });
            menu.add(item);
        }
        menu.show(this, x, y + 70);
    }

    private void showSelectionPopup(final long selid, int x, int y) {
        boolean isLicenseOnlyViewer = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE);
        ThemisLogger.logger.fine("PlanPanel selection popup: prepare");
        JPopupMenu menu = new JPopupMenu(this.bundle.getString("PlanPanel.selection.text"));
        menu.setFont(THEMIS.fontLabelBig);
        JMenuItem item = this.createMenuItem(this.bundle.getString("PlanPanel.select.text"), this.popupBackgroundColor, false);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanPanel.this.project.getSelectionManager().setSelectedLocation(selid, true, (Object)PlanPanel.this.self);
                PlanPanel.this.imagePanel.setSelection(selid);
                PlanPanel.this.btnEditGeometry.setEnabled(true);
            }
        });
        menu.add(item);
        if (!isLicenseOnlyViewer) {
            menu.addSeparator();
            item = this.createMenuItem(this.bundle.getString("PlanPanel.edit.text"), this.popupBackgroundColor, false, new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CmsLocation loc = (CmsLocation)PlanPanel.this.project.loadElement(selid, PlanPanel.this.project.getUser());
                    if (loc != null) {
                        new LocationObservationDialog().editLocation((CmsElement)loc);
                    }
                }
            });
            menu.add(item);
            item = this.createMenuItem(this.bundle.getString("PlanPanel.addObservation.text"), this.popupBackgroundColor, false, new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add-bw24.gif")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CmsLocation loc = (CmsLocation)PlanPanel.this.project.loadElement(selid, PlanPanel.this.project.getUser());
                    if (loc != null) {
                        CmsObservation obs = (CmsObservation)PlanPanel.this.project.createElement("observation");
                        obs.setLocation(loc);
                        obs.setNumber(loc.getNextObservationNumber());
                        new LocationObservationDialog().editObservation((CmsElement)loc, obs);
                    }
                }
            });
            menu.add(item);
            if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
                item = this.createMenuItem(this.bundle.getString("PlanPanel.copy.text"), this.popupBackgroundColor, false, new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)PlanPanel.this.app)) {
                            return;
                        }
                        PlanPanel.this.project.setCopiedLocationId(selid);
                        THEMIS.dismissNotify(5, THEMIS.notify(1, PlanPanel.this.project.getResourceText("notify.location.copy-on-plan.title"), PlanPanel.this.project.getResourceText("notify.location.copy-on-plan.text")));
                    }
                });
                menu.add(item);
            }
            if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
                item = this.createMenuItem(this.bundle.getString("PlanPanel.editGeometry.text"), this.popupBackgroundColor, false, new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/editgeometry24.gif")));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)PlanPanel.this.app)) {
                            return;
                        }
                        PlanPanel.this.project.getSelectionManager().setSelectedLocation(selid, true, (Object)PlanPanel.this.self);
                        PlanPanel.this.imagePanel.setSelection(selid);
                        PlanPanel.this.project.setEditLocGeometryId(selid);
                        PlanPanel.this.btnEditGeometry.setSelected(true);
                    }
                });
                menu.add(item);
            }
            menu.addSeparator();
            if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
                item = this.createMenuItem(this.bundle.getString("PlanPanel.setDone.text"), this.popupBackgroundGreen, true, new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/check-mark-12-24.gif")));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)PlanPanel.this.app)) {
                            return;
                        }
                        CmsLocation loc = (CmsLocation)PlanPanel.this.project.loadElement(selid, PlanPanel.this.project.getUser());
                        PlanPanel.this.project.getSelectionManager().setSelectedObservations(loc.getRelationAttribute("observations").getElementIds(), false, (Object)PlanPanel.this.self);
                        ThemisActions.reviewObservation(2);
                        PlanPanel.this.project.getSelectionManager().setSelectedLocation(loc.getId(), true, (Object)PlanPanel.this.self);
                    }
                });
                menu.add(item);
            }
            menu.addSeparator();
            if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
                item = this.createMenuItem(this.bundle.getString("PlanPanel.resetLabel.text"), this.popupBackgroundGrey, false);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)PlanPanel.this.app)) {
                            return;
                        }
                        CmsLocation loc = (CmsLocation)PlanPanel.this.project.loadElement(selid, PlanPanel.this.project.getUser());
                        loc.getAttribute("labelposition").clear();
                        loc.save();
                        PlanPanel.this.loadGeometries();
                    }
                });
                menu.add(item);
            }
            if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
                item = this.createMenuItem(this.bundle.getString("PlanPanel.delete.text"), this.popupBackgroundGrey, false, new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)PlanPanel.this.app)) {
                            return;
                        }
                        ThemisActions.deleteLocation(selid);
                        PlanPanel.this.project.getSelectionManager().clearSelection(true, (Object)PlanPanel.this.self);
                        PlanPanel.this.loadGeometries();
                    }
                });
                menu.add(item);
                menu.addSeparator();
            }
        }
        ThemisLogger.logger.fine("PlanPanel selection popup: show");
        menu.show(this, x, y);
    }

    private void showActionPopup() {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        if (this.plan == null || this.currentGeom == null) {
            return;
        }
        JPopupMenu menu = new JPopupMenu(this.bundle.getString("PlanPanel.selection.text"));
        SimpleGeometry geom = THEMIS.transformGeometryToPanel(this.currentGeom, this.plan, this.imagePanel);
        Point ptImage = geom.getLastPoint();
        Point ptScreen = this.imagePanel.image2screen(ptImage.getX(), ptImage.getY());
        if (this.checkLocation(geom)) {
            return;
        }
        if (this.btnEditGeometry.isSelected() && this.project.hasEditLocGeometryId()) {
            JMenuItem item = this.createMenuItem(this.bundle.getString("PlanPanel.shiftLocation.text"), this.popupBackgroundColor, false);
            item.addActionListener(new LocationCreationActionListener(this.project.getEditLocGeometryId(), this.currentGeom, this.plan, false, true, false, false));
            menu.add(item);
            int x = (int)ptScreen.getX();
            int y = (int)ptScreen.getY() - 30;
            menu.show(this, x, y);
        } else if (this.project.hasAddMapRefToLocId()) {
            JMenuItem item = this.createMenuItem(this.bundle.getString("PlanPanel.addMapRefToLoc.text"), this.popupBackgroundColor, false);
            if (this.project.getAddMapRefToLoc() != null) {
                item.addActionListener(new PlanActionListenerCreateOnPlan(this.currentGeom, this.plan, this.project.getAddMapRefToLoc()));
            } else {
                item.addActionListener(new PlanActionListenerSetPlanReference(this.currentGeom, this.plan, this.project.getAddMapRefToLocId()));
            }
            menu.add(item);
            item = this.createMenuItem(this.bundle.getString("PlanPanel.cancel"), this.popupBackgroundColor, false);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlanPanel.this.project.clearAddMapRefToLocId();
                }
            });
            menu.add(item);
            int x = (int)ptScreen.getX();
            int y = (int)ptScreen.getY() - 30;
            menu.show(this, x, y);
        } else {
            JMenuItem item = this.createMenuItem(this.bundle.getString("PlanPanel.createNewLocation.text"), this.popupBackgroundColor, false, new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
            item.addActionListener(new LocationCreationActionListener(-1L, this.currentGeom, this.plan, false, false, false, false));
            menu.add(item);
            menu.addSeparator();
            item = this.createMenuItem(this.bundle.getString("PlanPanel.createFoto.text"), this.popupBackgroundColor, false, new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_importPictures24.gif")));
            item.addActionListener(new PlanActionListenerCreatePhotoDoc(this.currentGeom, this.plan));
            menu.add(item);
            if (this.project.hasCopiedLocationId() || this.project.getRecentLocTemplatesList().size() > 0) {
                if (this.project.hasCopiedLocationId() && this.project.getCopiedLocationId() > 0L) {
                    menu.addSeparator();
                    CmsLocation location = (CmsLocation)this.project.loadElement(this.project.getCopiedLocationId(), this.project.getUser());
                    if (location != null) {
                        item = this.createMenuItem(this.bundle.getString("PlanPanel.paste.text") + " \"" + location.getAttributeValue("title") + "\"", this.popupBackgroundColor, false);
                        item.addActionListener(new LocationCreationActionListener(this.project.getCopiedLocationId(), this.currentGeom, this.plan, true, false, false, false));
                        menu.add(item);
                    }
                }
                if (this.project.getRecentLocTemplatesList().size() > 0) {
                    menu.addSeparator();
                    ArrayList locTemplates = this.project.getRecentLocTemplatesList();
                    ArrayList<Long> removeIds = new ArrayList<Long>();
                    Iterator iterator = locTemplates.iterator();
                    while (iterator.hasNext()) {
                        long metaid = (Long)iterator.next();
                        try {
                            BufferedImage img;
                            File iconFile;
                            CmsIcon iconEle;
                            UploadAttribute iconAtt;
                            CmsElementSummary iconSum;
                            RelationAttribute iconRel;
                            CmsLocationTemplate template = (CmsLocationTemplate)this.project.loadElement(metaid, this.project.getUser());
                            if (template == null || template.isTrash()) {
                                removeIds.add(metaid);
                                continue;
                            }
                            ImageIcon icon = null;
                            if (this.useIcons && (iconRel = template.getRelationAttribute("icon")) != null && (iconSum = iconRel.getFirstElement()) != null && (iconAtt = (iconEle = (CmsIcon)iconSum.getElement()).getUploadAttribute("file")) != null && (iconFile = iconAtt.getFirstUploadItemFile()) != null && (img = ImageHelper.loadImage((File)iconFile)) != null) {
                                icon = new ImageIcon(Util.resizeImage((BufferedImage)img, (int)24, (int)24, (int)2));
                            }
                            item = this.createMenuItem(template.getAttributeValue("title") + "", this.popupBackgroundColor, false, icon);
                            item.addActionListener(new LocationCreationActionListener(metaid, this.currentGeom, this.plan, false, false, false, false));
                            menu.add(item);
                        }
                        catch (Exception exception) {}
                    }
                    iterator = removeIds.iterator();
                    while (iterator.hasNext()) {
                        long removeId = (Long)iterator.next();
                        this.project.updateRecentLocTemplatesList(Long.valueOf(removeId), true);
                    }
                }
            }
            int countitems = menu.getSubElements().length;
            int x = (int)ptScreen.getX();
            int y = (int)ptScreen.getY();
            menu.show(this, x, y);
        }
    }

    private JMenuItem createMenuItem(String text, Color background, boolean bold) {
        return this.createMenuItem(text, background, bold, null);
    }

    private JMenuItem createMenuItem(String text, Color background, boolean bold, Icon icon) {
        JMenuItem item = new JMenuItem(text);
        item.setBackground(background);
        item.setIcon(icon);
        item.setOpaque(true);
        item.setMargin(new Insets(3, 0, 3, 0));
        if (bold) {
            item.setFont(THEMIS.fontLabelBigBold);
        } else {
            item.setFont(THEMIS.fontLabelBig);
        }
        return item;
    }

    private void showNextPlan() {
        int idx;
        if (this.plan != null && this.planIds.size() > 1 && (idx = this.planIds.indexOf(this.plan.getId())) < this.planIds.size() - 1) {
            long newPlanId = this.planIds.get(idx + 1);
            this.loadPlan(newPlanId, true);
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(newPlanId).from((Object)this, "next plan selected"));
        }
    }

    private void showPreviousPlan() {
        int idx;
        if (this.plan != null && this.planIds.size() > 1 && (idx = this.planIds.indexOf(this.plan.getId())) > 0) {
            long newPlanId = this.planIds.get(idx - 1);
            this.loadPlan(newPlanId, true);
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(newPlanId).from((Object)this, "previous plan selected"));
        }
    }

    private void loadPlan(long planid, boolean forceLoad) {
        this.mainPanel.setVisible(true);
        this.lblCoordinates.setVisible(true);
        this.lblInfo.setVisible(true);
        String et = this.project.getDatastorage().getElementtypeById(planid);
        if (!"plan".equals(et)) {
            this.project.setCurrentPlanId(-1L);
        } else {
            CmsPlan newplan = (CmsPlan)this.project.loadElement(planid, this.project.getUser());
            if (newplan.isTrash()) {
                this.project.setCurrentPlanId(-1L);
                return;
            }
            if (!forceLoad && this.plan != null && this.plan.getPlanFile() != null && this.plan.getPlanFile().equals(newplan.getPlanFile())) {
                return;
            }
            try {
                String buildingTitle;
                String planTitle;
                block22: {
                    if (!this.planIds.contains(planid)) {
                        this.updatePlanIds(newplan);
                    }
                    this.project.setCurrentPlanId(planid);
                    this.plan = newplan;
                    planTitle = this.plan.getTitle();
                    long idBuilding = this.plan.getBuildingId();
                    buildingTitle = "";
                    if (idBuilding > 0L) {
                        buildingTitle = this.project.getDatastorage().getElementTitle(idBuilding);
                    }
                    if (planTitle.length() > 25) {
                        if (idBuilding < 0L) {
                            planTitle = planTitle.substring(0, 25);
                        } else {
                            planTitle = planTitle.substring(0, Math.min(planTitle.length(), 15));
                            buildingTitle = buildingTitle.substring(0, Math.min(buildingTitle.length(), 25 - planTitle.length() - 3));
                        }
                    }
                    if (!"".equals(buildingTitle)) {
                        buildingTitle = buildingTitle + " / ";
                    }
                    this.useIcons = this.app.getSettings().getLocationAttribute("icon").isUsed();
                    File imagefile = this.plan.getPlanFile();
                    if (imagefile != null) {
                        if (!imagefile.exists()) {
                            imagefile = new File(new File(this.project.getProjectFolder(), "data"), imagefile.getName());
                        }
                        if (!imagefile.isFile()) {
                            this.app.getDialog().showErrorDialog(MessageFormat.format(this.bundle.getString("WARNING_PLANFILE_MISSING"), imagefile.getName()));
                            this.imagePanel.clearBackgroundImage();
                        } else {
                            try {
                                this.imagePanel.setBackgroundImage(imagefile);
                                if (this.plan.hasGeometry()) {
                                    this.imagePanel.setGeometry(this.plan.getGeometry());
                                    break block22;
                                }
                                this.imagePanel.setGeometry(null);
                            }
                            catch (Exception e) {
                                this.app.getDialog().showErrorDialog(MessageFormat.format(this.bundle.getString("WARNING_CANNOT_LOAD_PLAN_X"), imagefile.getName(), e.getMessage()));
                                e.printStackTrace();
                            }
                            catch (OutOfMemoryError err) {
                                this.app.getDialog().showErrorDialog("error.notEnoughRam");
                            }
                        }
                    } else {
                        this.imagePanel.removeBackgroundImage();
                    }
                }
                this.updateFilteredLocations(-1L);
                this.updateSelection();
                this.imagePanel.reset();
                this.imagePanel.setBackgroundTransparency(this.transparency);
                this.imagePanel.repaint();
                if (this.tc != null) {
                    this.tc.requestActive();
                    this.tc.setDisplayName("Plan " + buildingTitle + planTitle);
                }
                this.enableBtnsPlanViewTopComponent();
                this.updatePrevNextPlanButtons();
            }
            catch (Exception e) {
                Dialogs.getInstance().showErrorDialog(this.bundle.getString("WARNING_CANNOT_LOAD_PLAN"), e);
            }
        }
    }

    private void reset() {
        ThemisApplication.getLogger().info("Resetting PlanPanel");
        this.imagePanel.clearBackgroundImage();
        this.imagePanel.clearForegroundImages();
        this.imagePanel.removeGeometries();
        this.plan = null;
        this.lblCoordinates.setVisible(false);
        this.lblInfo.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PlanPanel.this.tc != null) {
                    PlanPanel.this.tc.setDisplayName("Plananzeige");
                }
            }
        });
        this.repaint();
        this.revalidate();
    }

    private void updateIcons() {
        this.useIcons = this.app.getSettings().getLocationAttribute("icon").isUsed();
        if (this.app.getIconPoint().exists()) {
            this.imagePanel.setIconPosition(this.app.getIconPoint());
        }
        if (this.app.getIconPointSel().exists()) {
            this.imagePanel.setIconPositionSel(this.app.getIconPointSel());
        }
        if (this.app.getIconPointInactive().exists()) {
            this.imagePanel.setIconPositionInactive(this.app.getIconPointInactive());
        }
        this.loadGeometries();
    }

    private void updateFilteredLocations() {
        this.updateFilteredLocations(-1L);
    }

    private void updateFilteredLocations(long locationid) {
        if (this.plan == null) {
            return;
        }
        this.loadGeometries();
    }

    private void updateSelection() {
        ArrayList locationIds = this.project.getSelectionManager().getSelectedLocationIds();
        this.imagePanel.setSelection(locationIds);
    }

    private void loadGeometries() {
        PlanCreator1.loadGeometries((ThemisApplication)this.app, (ImagePanel)this.imagePanel, (CmsPlan)this.plan, (ThemisProject)this.project, (float)1.0f, this.filteredlocationids, (boolean)this.showCalibPoints, null);
    }

    private void actionStartDrawing(int imagePanelDrawType) {
        this.project.clearAddMapRefToLocId();
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        if (this.btnEditGeometry.isSelected() || this.project.isOpen() && !this.imagePanel.isDrawing()) {
            this.btnDrawPoint.setSelected(imagePanelDrawType == 2);
            this.btnDrawLine.setEnabled(imagePanelDrawType == 3);
            this.btnDrawPolygon.setEnabled(imagePanelDrawType == 4);
            this.btnAccept.setVisible(true);
            this.btnCancel.setVisible(true);
            this.btnEditGeometry.setEnabled(this.btnEditGeometry.isSelected());
            this.imagePanel.setStatus(imagePanelDrawType);
        } else {
            this.btnDrawPoint.setSelected(false);
            this.btnDrawLine.setSelected(false);
            this.btnDrawPolygon.setSelected(false);
        }
    }

    private void startPlanCoordinates() {
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        this.panelOverlay = new JPanel();
        this.panelZoomButtons = new JPanel();
        this.btnFullExt = new JButton();
        this.btnZoomOut = new JButton();
        this.btnZoomIn = new JButton();
        this.panelTopButtons = new JPanel();
        this.btnDrawPoint = new JToggleButton();
        this.btnDrawLine = new JToggleButton();
        this.btnDrawPolygon = new JToggleButton();
        this.btnEditGeometry = new JToggleButton();
        this.lblEmpty1 = new JLabel();
        this.btnAccept = new JButton();
        this.btnCancel = new JButton();
        this.lblEmpty3 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.sliderPlanTransparency = new JSlider();
        this.btnPreviousPlan = new JButton();
        this.btnPlanList = new JButton();
        this.btnNextPlan = new JButton();
        this.panelCoord = new JPanel();
        this.btnPlanFilter = new JButton();
        this.jLabel2 = new JLabel();
        this.lblInfo = new JLabel();
        this.lblCoordinates = new JLabel();
        this.mainPanel = new JPanel();
        this.setMinimumSize(new Dimension(300, 100));
        this.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new OverlayLayout(this.centerPanel));
        this.panelOverlay.setMinimumSize(new Dimension(500, 400));
        this.panelOverlay.setOpaque(false);
        this.panelOverlay.setPreferredSize(new Dimension(500, 400));
        this.panelOverlay.setLayout(new BorderLayout());
        this.panelZoomButtons.setOpaque(false);
        this.panelZoomButtons.setPreferredSize(new Dimension(56, 502));
        this.panelZoomButtons.setLayout(new GridBagLayout());
        this.btnFullExt.setFont(THEMIS.fontButton);
        this.btnFullExt.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/fullscreen-10-32.gif")));
        this.btnFullExt.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnFullExt.toolTipText"));
        this.btnFullExt.setBorder(new SoftBevelBorder(0));
        this.btnFullExt.setCursor(new Cursor(0));
        this.btnFullExt.setEnabled(false);
        this.btnFullExt.setMaximumSize(new Dimension(45, 45));
        this.btnFullExt.setMinimumSize(new Dimension(45, 45));
        this.btnFullExt.setPreferredSize(new Dimension(45, 45));
        this.btnFullExt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnFullExtActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelZoomButtons.add((Component)this.btnFullExt, gridBagConstraints);
        this.btnZoomOut.setFont(THEMIS.fontButton);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zoomOut32.gif")));
        this.btnZoomOut.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnZoomOut.toolTipText"));
        this.btnZoomOut.setBorder(new SoftBevelBorder(0));
        this.btnZoomOut.setEnabled(false);
        this.btnZoomOut.setPreferredSize(new Dimension(45, 45));
        this.btnZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnZoomOutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelZoomButtons.add((Component)this.btnZoomOut, gridBagConstraints);
        this.btnZoomIn.setFont(THEMIS.fontButton);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zoomIn32.gif")));
        this.btnZoomIn.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnZoomIn.toolTipText"));
        this.btnZoomIn.setBorder(new SoftBevelBorder(0));
        this.btnZoomIn.setEnabled(false);
        this.btnZoomIn.setPreferredSize(new Dimension(45, 45));
        this.btnZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnZoomInActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelZoomButtons.add((Component)this.btnZoomIn, gridBagConstraints);
        this.panelOverlay.add((Component)this.panelZoomButtons, "West");
        this.panelTopButtons.setOpaque(false);
        this.panelTopButtons.setPreferredSize(new Dimension(820, 60));
        this.panelTopButtons.setLayout(new GridBagLayout());
        this.btnDrawPoint.setFont(THEMIS.fontButton);
        this.btnDrawPoint.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/createPoint32.gif")));
        this.btnDrawPoint.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnDrawPoint.toolTipText"));
        this.btnDrawPoint.setBorder(new SoftBevelBorder(0));
        this.btnDrawPoint.setEnabled(false);
        this.btnDrawPoint.setPreferredSize(new Dimension(45, 45));
        this.btnDrawPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnDrawPointActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnDrawPoint, gridBagConstraints);
        this.btnDrawLine.setFont(THEMIS.fontButton);
        this.btnDrawLine.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/createLine32.gif")));
        this.btnDrawLine.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnDrawLine.toolTipText"));
        this.btnDrawLine.setBorder(new SoftBevelBorder(0));
        this.btnDrawLine.setEnabled(false);
        this.btnDrawLine.setPreferredSize(new Dimension(45, 45));
        this.btnDrawLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnDrawLineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnDrawLine, gridBagConstraints);
        this.btnDrawPolygon.setFont(THEMIS.fontButton);
        this.btnDrawPolygon.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/createArea32.gif")));
        this.btnDrawPolygon.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnDrawPolygon.toolTipText"));
        this.btnDrawPolygon.setBorder(new SoftBevelBorder(0));
        this.btnDrawPolygon.setEnabled(false);
        this.btnDrawPolygon.setPreferredSize(new Dimension(45, 45));
        this.btnDrawPolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnDrawPolygonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnDrawPolygon, gridBagConstraints);
        this.btnEditGeometry.setFont(THEMIS.fontButton);
        this.btnEditGeometry.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/editgeometry32.gif")));
        this.btnEditGeometry.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnEditGeometry.toolTipText"));
        this.btnEditGeometry.setAlignmentY(0.0f);
        this.btnEditGeometry.setBorder(new SoftBevelBorder(0));
        this.btnEditGeometry.setEnabled(false);
        this.btnEditGeometry.setPreferredSize(new Dimension(45, 45));
        this.btnEditGeometry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnEditGeometryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnEditGeometry, gridBagConstraints);
        this.lblEmpty1.setPreferredSize(new Dimension(30, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.lblEmpty1, gridBagConstraints);
        this.btnAccept.setFont(THEMIS.fontButton);
        this.btnAccept.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm32.gif")));
        this.btnAccept.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnAccept.toolTipText"));
        this.btnAccept.setBorder(new SoftBevelBorder(0));
        this.btnAccept.setPreferredSize(new Dimension(45, 45));
        this.btnAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnAcceptActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnAccept, gridBagConstraints);
        this.btnCancel.setFont(THEMIS.fontButton);
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel32.gif")));
        this.btnCancel.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnCancel.toolTipText"));
        this.btnCancel.setBorder(new SoftBevelBorder(0));
        this.btnCancel.setPreferredSize(new Dimension(45, 45));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnCancel, gridBagConstraints);
        this.lblEmpty3.setPreferredSize(new Dimension(30, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.lblEmpty3, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabelSmall);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.sliderPlanTransparency.setMajorTickSpacing(35);
        this.sliderPlanTransparency.setMaximum(0);
        this.sliderPlanTransparency.setMinimum(-100);
        this.sliderPlanTransparency.setPaintTicks(true);
        this.sliderPlanTransparency.setSnapToTicks(true);
        this.sliderPlanTransparency.setToolTipText("Transparenz f\u00fcr den Planhintergrund einstellen");
        this.sliderPlanTransparency.setValue(-100);
        this.sliderPlanTransparency.setMinimumSize(new Dimension(80, 30));
        this.sliderPlanTransparency.setOpaque(false);
        this.sliderPlanTransparency.setPreferredSize(new Dimension(30, 80));
        this.sliderPlanTransparency.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PlanPanel.this.sliderPlanTransparencyMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.sliderPlanTransparency, gridBagConstraints);
        this.panelTopButtons.add((Component)this.jPanel1, new GridBagConstraints());
        this.btnPreviousPlan.setFont(THEMIS.fontButton);
        this.btnPreviousPlan.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft32.gif")));
        this.btnPreviousPlan.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnPreviousPlan.toolTipText"));
        this.btnPreviousPlan.setBorder(new SoftBevelBorder(0));
        this.btnPreviousPlan.setPreferredSize(new Dimension(45, 45));
        this.btnPreviousPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnPreviousPlanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnPreviousPlan, gridBagConstraints);
        this.btnPlanList.setFont(THEMIS.fontButton);
        this.btnPlanList.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_ViewProjectLibrary32.gif")));
        this.btnPlanList.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnPlanList.toolTipText"));
        this.btnPlanList.setBorder(new SoftBevelBorder(0));
        this.btnPlanList.setPreferredSize(new Dimension(45, 45));
        this.btnPlanList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnPlanListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelTopButtons.add((Component)this.btnPlanList, gridBagConstraints);
        this.btnNextPlan.setFont(THEMIS.fontButton);
        this.btnNextPlan.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight32.gif")));
        this.btnNextPlan.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnNextPlan.toolTipText"));
        this.btnNextPlan.setBorder(new SoftBevelBorder(0));
        this.btnNextPlan.setPreferredSize(new Dimension(45, 45));
        this.btnNextPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnNextPlanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnNextPlan, gridBagConstraints);
        this.panelOverlay.add((Component)this.panelTopButtons, "First");
        this.panelCoord.setOpaque(false);
        this.panelCoord.setLayout(new GridBagLayout());
        this.btnPlanFilter.setFont(THEMIS.fontButton);
        this.btnPlanFilter.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/filter24.gif")));
        this.btnPlanFilter.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnPlanFilter.toolTipText"));
        this.btnPlanFilter.setBorder(new SoftBevelBorder(0));
        this.btnPlanFilter.setPreferredSize(new Dimension(45, 45));
        this.btnPlanFilter.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PlanPanel.this.btnPlanFilterMousePressed(evt);
            }
        });
        this.btnPlanFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnPlanFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCoord.add((Component)this.btnPlanFilter, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelCoord.add((Component)this.jLabel2, gridBagConstraints);
        this.lblInfo.setFont(THEMIS.fontLabel);
        this.lblInfo.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lblInfo, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblInfo.text"));
        this.lblInfo.setToolTipText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblInfo.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCoord.add((Component)this.lblInfo, gridBagConstraints);
        this.lblCoordinates.setFont(THEMIS.fontLabel);
        this.lblCoordinates.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lblCoordinates, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblCoordinates.text"));
        this.lblCoordinates.setMaximumSize(new Dimension(120, 14));
        this.lblCoordinates.setMinimumSize(new Dimension(120, 14));
        this.lblCoordinates.setPreferredSize(new Dimension(120, 14));
        this.lblCoordinates.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PlanPanel.this.lblCoordinatesMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCoord.add((Component)this.lblCoordinates, gridBagConstraints);
        this.panelOverlay.add((Component)this.panelCoord, "Last");
        this.centerPanel.add(this.panelOverlay);
        this.mainPanel.setLayout(new GridBagLayout());
        this.centerPanel.add(this.mainPanel);
        this.add((Component)this.centerPanel, "Center");
    }

    private void btnDrawPointActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.actionStartDrawing(2);
    }

    private void btnDrawLineActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.actionStartDrawing(3);
    }

    private void btnDrawPolygonActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.actionStartDrawing(4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void btnAcceptActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen() && this.plan != null) {
            this.currentGeom = this.imagePanel.getCurrentGeometryObject();
            if (this.checkLocation(this.currentGeom)) {
                return;
            }
            if (!this.externalCall) {
                this.currentGeom = this.transformIfNecessary(this.currentGeom);
            }
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.ACTION_GEOMETRY_EDIT_DONE, true);
            if (this.externalCall) {
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.CREATE_POINT_IN_PLAN_DONE.setReference((Object)new SimpleGeometry(this.currentGeom, true)).setId(this.plan.getId()), true);
                this.externalCall = false;
            } else if (this.btnEditGeometry.isSelected()) {
                if (this.project.getSelectionManager().getSelectedLocationIds().size() != 1) {
                    Dialogs.getInstance().showWarningDialog(this.bundle.getString("WARNING_NO_LOCATION_SELECTED"));
                    return;
                }
                CmsLocation location = (CmsLocation)this.project.loadElement(((Long)this.project.getSelectionManager().getSelectedLocationIds().get(0)).longValue(), this.project.getUser());
                location.setAttributeValue("position", this.currentGeom.toWKT());
                if (this.plan != null) {
                    location.getRelationAttribute("plan").set((CmsElement)this.plan);
                }
                location.save();
                this.app.getFilter().resetSearchResult();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(location.getId()), true);
            } else if (this.project.hasAddMapRefToLocId()) {
                CmsLocation location = (CmsLocation)this.project.loadElement(this.project.getAddMapRefToLocId(), this.project.getUser());
                location.setAttributeValue("position", this.currentGeom.toWKT());
                if (this.plan != null) {
                    location.getRelationAttribute("plan").set((CmsElement)this.plan);
                }
                location.save();
                this.app.getFilter().resetSearchResult();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(this.project.getAddMapRefToLocId()), true);
                this.project.clearAddMapRefToLocId();
            } else {
                this.showActionPopup();
            }
        }
        this.btnEditGeometry.setSelected(false);
        this.btnDrawLine.setEnabled(true);
        this.btnDrawPolygon.setEnabled(true);
        this.btnDrawPoint.setEnabled(true);
        this.btnAccept.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnDrawLine.setSelected(false);
        this.btnDrawPolygon.setSelected(false);
        this.btnDrawPoint.setSelected(false);
        this.imagePanel.cancelDrawing();
        this.imagePanel.setGeometryAction(null);
        this.placeImmediately = false;
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.externalCall = false;
        this.placeImmediately = false;
        this.btnDrawLine.setEnabled(true);
        this.btnDrawPolygon.setEnabled(true);
        this.btnDrawPoint.setEnabled(true);
        this.btnAccept.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnDrawLine.setSelected(false);
        this.btnDrawPolygon.setSelected(false);
        this.btnDrawPoint.setSelected(false);
        this.btnEditGeometry.setSelected(false);
        this.imagePanel.cancelDrawing();
        this.imagePanel.setGeometryAction(null);
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.CREATE_POINT_IN_PLAN_DONE);
    }

    private void disableBtnsPlanViewerTopComponent() {
        this.btnZoomIn.setEnabled(false);
        this.btnZoomOut.setEnabled(false);
        this.btnFullExt.setEnabled(false);
        this.btnDrawPoint.setEnabled(false);
        this.btnDrawLine.setEnabled(false);
        this.btnDrawPolygon.setEnabled(false);
        this.btnEditGeometry.setEnabled(false);
        this.btnAccept.setVisible(false);
        this.btnCancel.setVisible(false);
        this.sliderPlanTransparency.setEnabled(false);
    }

    private void enableBtnsPlanViewTopComponent() {
        this.btnDrawLine.setEnabled(true);
        this.btnDrawPolygon.setEnabled(true);
        this.btnDrawPoint.setEnabled(true);
        this.btnZoomIn.setEnabled(true);
        this.btnZoomOut.setEnabled(true);
        this.btnFullExt.setEnabled(true);
        this.sliderPlanTransparency.setEnabled(true);
    }

    private void btnEditGeometryActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
    }

    private void sliderPlanTransparencyMouseReleased(MouseEvent evt) {
        float trans = this.transparency;
        float sliderValue = this.sliderPlanTransparency.getValue();
        if ((sliderValue = Math.abs(sliderValue) / 100.0f) == 0.0f) {
            sliderValue = 0.1f;
        }
        if (sliderValue != trans) {
            this.transparency = sliderValue;
            this.app.setConfiguration("display.transparency", Float.toString(this.transparency), true);
            this.imagePanel.setBackgroundTransparency(this.transparency);
            this.imagePanel.repaint();
        }
    }

    private void btnZoomInActionPerformed(ActionEvent evt) {
        this.imagePanel.zoomIn();
    }

    private void btnZoomOutActionPerformed(ActionEvent evt) {
        this.imagePanel.zoomOut();
    }

    private void btnFullExtActionPerformed(ActionEvent evt) {
        this.imagePanel.reset();
    }

    private void btnPreviousPlanActionPerformed(ActionEvent evt) {
        this.showPreviousPlan();
    }

    private void btnNextPlanActionPerformed(ActionEvent evt) {
        this.showNextPlan();
    }

    private void btnPlanListActionPerformed(ActionEvent evt) {
        JMenuItem item;
        JMenu submenu;
        JPopupMenu menu = new JPopupMenu("Planauswahl");
        ArrayList plans = this.project.getPlans();
        ArrayList buildings = this.project.getBuildings();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (CmsElementSummary ele : buildings) {
            ArrayList buildingPlans = this.project.getPlansForBuilding(ele.getId());
            submenu = THEMIS.createMenu(ele.getTitle(), Color.LIGHT_GRAY.brighter(), false, null);
            for (CmsElementSummary buildingPlan : buildingPlans) {
                ids.add(buildingPlan.getId());
                item = THEMIS.createMenuItem(buildingPlan.getTitle(), Color.WHITE, false, null);
                item.addActionListener(e2 -> {
                    this.loadPlan(buildingPlan.getId(), true);
                    ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(buildingPlan.getId()).from((Object)this, "plan from dropdown selected"));
                });
                submenu.add(item);
            }
            menu.add(submenu);
        }
        submenu = null;
        if (!buildings.isEmpty()) {
            submenu = THEMIS.createMenu("Ohne Geb\u00e4ude", Color.LIGHT_GRAY.brighter(), false, null);
        }
        boolean foundPlansWithoutBuilding = false;
        for (CmsElementSummary plan : plans) {
            if (ids.contains(plan.getId())) continue;
            item = THEMIS.createMenuItem(plan.getTitle(), Color.WHITE, false, null);
            item.addActionListener(e2 -> {
                this.loadPlan(plan.getId(), true);
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(plan.getId()).from((Object)this, "plan from dropdown selected"));
            });
            foundPlansWithoutBuilding = true;
            if (submenu == null) {
                menu.add(item);
                continue;
            }
            submenu.add(item);
        }
        if (submenu != null && foundPlansWithoutBuilding) {
            menu.add(submenu);
        }
        menu.show(this.btnPlanList, this.btnPlanList.getWidth(), 0);
    }

    private void lblCoordinatesMousePressed(MouseEvent evt) {
        this.fun3();
    }

    private void btnPlanFilterActionPerformed(ActionEvent evt) {
        ThemisFilter filter = ThemisApplication.getInstance().getFilter();
        filter.setCurrentPlanFilter();
    }

    private void btnPlanFilterMousePressed(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.fun3();
        }
    }

    private SimpleGeometry transformIfNecessary(SimpleGeometry geom) {
        if (this.plan == null || geom == null) {
            return null;
        }
        if (this.plan.isCalibrated()) {
            if (this.plan.isCurrentPlanfileCalibrated()) {
                GridGeometry geoPlan = this.plan.getGeometry();
                SimpleGeometry geomNew = geom.transform(geoPlan.getHeight(), geoPlan);
                return geomNew;
            }
            return geom.transform(this.imagePanel.getImageHeight(), this.plan.getCalibPlanfileElement().getCalibration().toGeometry());
        }
        return geom;
    }

    private void fun1() {
        this.fun = true;
        Thread tt = new Thread(() -> {
            int ii;
            ArrayList geometries = this.imagePanel.getGeometries();
            ArrayList<Double> vx = new ArrayList<Double>();
            ArrayList<Double> vy = new ArrayList<Double>();
            double ymin = 9.99999999E8;
            double ymax = -9.99999999E8;
            int idxSonne1 = 0;
            int idxSonne2 = 0;
            for (ii = 0; ii < geometries.size(); ++ii) {
                SimpleGeometry geom1 = (SimpleGeometry)geometries.get(ii);
                double y = geom1.getPoint().getY();
                if (y > ymax) {
                    idxSonne2 = ii;
                    ymax = y;
                }
                if (!(y < ymin)) continue;
                idxSonne1 = ii;
                ymin = y;
            }
            for (ii = 0; ii < geometries.size(); ++ii) {
                vx.add(0.0);
                vy.add(0.0);
            }
            vx.set(idxSonne1, 1.5);
            vx.set(idxSonne2, -1.5);
            double G = 66.7;
            double step = 2.0E-4;
            double ms = 500000.0;
            int count = geometries.size();
            while (this.fun) {
                int ii2;
                for (ii2 = 0; ii2 < count; ++ii2) {
                    SimpleGeometry geom1 = (SimpleGeometry)geometries.get(ii2);
                    if (!geom1.isOfType(1)) continue;
                    double m1 = ii2 == idxSonne1 || ii2 == idxSonne2 ? ms : 1.0;
                    for (int jj = ii2 + 1; jj < count; ++jj) {
                        SimpleGeometry geom2 = (SimpleGeometry)geometries.get(jj);
                        if (!geom2.isOfType(1)) continue;
                        double m2 = ii2 == idxSonne1 || ii2 == idxSonne2 ? ms : 1.0;
                        double dx = geom2.getPoint().getX() - geom1.getPoint().getX();
                        double dy = geom2.getPoint().getY() - geom1.getPoint().getY();
                        double d = Math.sqrt(dx * dx + dy * dy);
                        double a1 = G * m2 / (d * d);
                        double a2 = G * m1 / (d * d);
                        double a1x = a1 * dx / d;
                        double a1y = a1 * dy / d;
                        double a2x = a2 * dx / d;
                        double a2y = a2 * dy / d;
                        vx.set(ii2, (Double)vx.get(ii2) + a1x * step);
                        vy.set(ii2, (Double)vy.get(ii2) + a1y * step);
                        vx.set(jj, (Double)vx.get(jj) - a2x * step);
                        vy.set(jj, (Double)vy.get(jj) - a2y * step);
                    }
                }
                for (ii2 = 0; ii2 < count; ++ii2) {
                    SimpleGeometry g = (SimpleGeometry)geometries.get(ii2);
                    g.move(((Double)vx.get(ii2)).doubleValue(), ((Double)vy.get(ii2)).doubleValue());
                }
                this.imagePanel.repaint();
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        });
        tt.setDaemon(true);
        tt.start();
    }

    private void fun2() {
        this.fun = true;
        Thread tt = new Thread(() -> {
            int ii;
            ArrayList geometries = this.imagePanel.getGeometries();
            int count = geometries.size();
            ArrayList<Double> vx = new ArrayList<Double>();
            ArrayList<Double> vy = new ArrayList<Double>();
            double step = 0.001;
            double dmin = 100.0;
            double dmax = 600.0;
            double dmouse = 3000.0;
            HashMap prefDist = new HashMap();
            for (ii = 0; ii < count; ++ii) {
                SimpleGeometry geom1 = (SimpleGeometry)geometries.get(ii);
                geom1.setLabel(null);
                ArrayList<Double> dist = new ArrayList<Double>();
                for (int jj = 0; jj < count; ++jj) {
                    double dd = Math.random() * (dmax - dmin) + dmin;
                    dist.add(dd);
                }
                prefDist.put(ii, dist);
            }
            for (ii = 0; ii < count; ++ii) {
                vx.add(0.0);
                vy.add(0.0);
            }
            while (this.fun) {
                int ii2;
                java.awt.Point mousePosition = this.imagePanel.getMousePosition();
                for (ii2 = 0; ii2 < count; ++ii2) {
                    double d;
                    double dy;
                    double dx;
                    SimpleGeometry geom1 = (SimpleGeometry)geometries.get(ii2);
                    if (!geom1.isOfType(1)) continue;
                    vx.set(ii2, 0.0);
                    vy.set(ii2, 0.0);
                    for (int jj = 0; jj < count; ++jj) {
                        SimpleGeometry geom2;
                        if (ii2 == jj || !(geom2 = (SimpleGeometry)geometries.get(jj)).isOfType(1)) continue;
                        dx = geom2.getPoint().getX() - geom1.getPoint().getX();
                        dy = geom2.getPoint().getY() - geom1.getPoint().getY();
                        d = Math.sqrt(dx * dx + dy * dy);
                        double dpref = (Double)((ArrayList)prefDist.get(ii2)).get(jj);
                        double v0 = (d - dpref) * step;
                        vx.set(ii2, (Double)vx.get(ii2) + v0 * dx / d);
                        vy.set(ii2, (Double)vy.get(ii2) + v0 * dy / d);
                    }
                    if (mousePosition == null) continue;
                    Point pt = this.imagePanel.screen2Image(mousePosition.x, mousePosition.y);
                    dx = pt.getX() - geom1.getPoint().getX();
                    dy = pt.getY() - geom1.getPoint().getY();
                    d = Math.sqrt(dx * dx + dy * dy);
                    double v0 = (d - dmouse) * step;
                    vx.set(ii2, (Double)vx.get(ii2) + v0 * dx / d);
                    vy.set(ii2, (Double)vy.get(ii2) + v0 * dy / d);
                }
                for (ii2 = 0; ii2 < count; ++ii2) {
                    SimpleGeometry g = (SimpleGeometry)geometries.get(ii2);
                    g.move(((Double)vx.get(ii2)).doubleValue(), ((Double)vy.get(ii2)).doubleValue());
                }
                this.imagePanel.repaint();
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            this.updateFilteredLocations();
        });
        tt.setDaemon(true);
        tt.start();
    }

    private void fun3() {
        this.fun = true;
        Thread tt = new Thread(() -> {
            ArrayList geometries = this.imagePanel.getGeometries();
            int count = geometries.size();
            ArrayList<Double> vx = new ArrayList<Double>();
            ArrayList<Double> vy = new ArrayList<Double>();
            double step = 0.001;
            double dmin = 500.0;
            for (int ii = 0; ii < count; ++ii) {
                vx.add(0.0);
                vy.add(0.0);
            }
            System.out.println("FUN - STOP");
            while (this.fun) {
                int ii;
                java.awt.Point mousePosition = this.panelOverlay.getMousePosition();
                Point pt = mousePosition == null ? null : this.imagePanel.screen2Image(mousePosition.x, mousePosition.y);
                for (ii = 0; ii < count; ++ii) {
                    SimpleGeometry geom1;
                    if (ii >= geometries.size() || !(geom1 = (SimpleGeometry)geometries.get(ii)).isOfType(1)) continue;
                    vx.set(ii, 0.0);
                    vy.set(ii, 0.0);
                    if (pt == null) continue;
                    double dx = pt.getX() - geom1.getPoint().getX();
                    double dy = pt.getY() - geom1.getPoint().getY();
                    double d = Math.sqrt(dx * dx + dy * dy);
                    double v0 = 0.0;
                    if (d < dmin) {
                        v0 = Math.max(1.0 / d * step, 10.0);
                    }
                    vx.set(ii, (Double)vx.get(ii) - v0 * dx / d);
                    vy.set(ii, (Double)vy.get(ii) - v0 * dy / d);
                }
                for (ii = 0; ii < count; ++ii) {
                    if (ii >= geometries.size()) continue;
                    SimpleGeometry g = (SimpleGeometry)geometries.get(ii);
                    g.move(((Double)vx.get(ii)).doubleValue(), ((Double)vy.get(ii)).doubleValue());
                }
                this.imagePanel.repaint();
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            System.out.println("FUN - STOP");
            this.updateFilteredLocations();
        });
        tt.setDaemon(true);
        tt.start();
    }
}

